/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class RecordSet
extends ForwardingList<Value> {
    private final String type;
    private final int ttl;
    private final transient List<Value> values;

    private RecordSet(String type, int ttl, List<Value> values) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.ttl = ttl;
        Preconditions.checkArgument(ttl >= 0, "ttl must be >=0");
        this.values = Preconditions.checkNotNull(values, "values");
    }

    public String getType() {
        return this.type;
    }

    public int getTTL() {
        return this.ttl;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.type, this.ttl, this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RecordSet that = (RecordSet)RecordSet.class.cast(obj);
        return Objects.equal(this.type, that.type) && Objects.equal(this.ttl, that.ttl) && Objects.equal(this.values, that.values);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper("").omitNullValues().add("type", this.type).add("ttl", this.ttl).add("values", this.values).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    @Override
    protected List<Value> delegate() {
        return this.values;
    }

    public static final class Builder {
        private String type;
        private int ttl = -1;
        private ImmutableList.Builder<Value> values = ImmutableList.builder();

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder add(Value value) {
            this.values.add((Object)value);
            return this;
        }

        public Builder values(Iterable<Value> values) {
            this.values = ImmutableList.builder().addAll(values);
            return this;
        }

        public Builder addAll(Iterable<Value> values) {
            this.values.addAll((Iterable)values);
            return this;
        }

        public RecordSet build() {
            return new RecordSet(this.type, this.ttl, (List)((Object)this.values.build()));
        }

        public Builder from(RecordSet in) {
            return this.type(in.type).ttl(in.ttl).values(in.values);
        }
    }

    public static class Value {
        private final Optional<String> label;
        private final Optional<Integer> weight;
        private final Map<String, Object> rdata;

        private Value(Optional<String> label, Optional<Integer> weight, Map<String, Object> rdata) {
            this.label = Preconditions.checkNotNull(label, "label");
            this.weight = Preconditions.checkNotNull(weight, "weight");
            this.rdata = Preconditions.checkNotNull(rdata, "rdata");
        }

        public Optional<String> getLabel() {
            return this.label;
        }

        public Optional<Integer> getWeight() {
            return this.weight;
        }

        public Map<String, Object> getRData() {
            return this.rdata;
        }

        public int hashCode() {
            return Objects.hashCode(this.label, this.weight, this.rdata);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Value that = (Value)Value.class.cast(obj);
            return Objects.equal(this.label, that.label) && Objects.equal(this.weight, that.weight) && Objects.equal(this.rdata, that.rdata);
        }

        public String toString() {
            return MoreObjects.toStringHelper("").omitNullValues().add("label", this.label.orNull()).add("weight", this.weight.orNull()).add("rdata", this.rdata).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static final class Builder {
            private Optional<String> label = Optional.absent();
            private Optional<Integer> weight = Optional.absent();
            private Map<String, Object> rdata;

            public Builder label(String label) {
                this.label = Optional.fromNullable(label);
                return this;
            }

            public Builder weight(Integer weight) {
                this.weight = Optional.fromNullable(weight);
                return this;
            }

            public Builder rdata(Map<String, Object> rdata) {
                this.rdata = rdata;
                return this;
            }

            public Value build() {
                return new Value(this.label, this.weight, this.rdata);
            }

            public Builder from(Value in) {
                return this.label((String)in.label.orNull()).weight((Integer)in.weight.orNull()).rdata(in.rdata);
            }
        }
    }
}

