/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.config;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.TlsVersion;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.docker.suppliers.DockerSSLContextSupplier;
import org.jclouds.domain.Credentials;
import org.jclouds.http.okhttp.OkHttpClientSupplier;
import org.jclouds.location.Provider;

@Singleton
public class DockerOkHttpClientSupplier
implements OkHttpClientSupplier {
    private final DockerSSLContextSupplier dockerSSLContextSupplier;
    private final Supplier<Credentials> creds;

    @Inject
    DockerOkHttpClientSupplier(DockerSSLContextSupplier dockerSSLContextSupplier, @Provider Supplier<Credentials> creds) {
        this.dockerSSLContextSupplier = dockerSSLContextSupplier;
        this.creds = creds;
    }

    @Override
    public OkHttpClient get() {
        OkHttpClient client = new OkHttpClient();
        ConnectionSpec tlsSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0, TlsVersion.TLS_1_1, TlsVersion.TLS_1_2).build();
        ConnectionSpec cleartextSpec = new ConnectionSpec.Builder(ConnectionSpec.CLEARTEXT).build();
        client.setConnectionSpecs(ImmutableList.of(tlsSpec, cleartextSpec));
        if (new File(this.creds.get().identity).isFile() && new File(this.creds.get().credential).isFile()) {
            client.setSslSocketFactory(this.dockerSSLContextSupplier.get().getSocketFactory());
        }
        return client;
    }
}

