/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListTagsOptions
extends AccountInDomainOptions {
    public static final ListTagsOptions NONE = new ListTagsOptions();

    public ListTagsOptions customer(String customer) {
        this.queryParameters.replaceValues("customer", ImmutableSet.of(customer));
        return this;
    }

    public ListTagsOptions isRecursive(boolean isRecursive) {
        this.queryParameters.replaceValues("isrecursive", ImmutableSet.of(isRecursive + ""));
        return this;
    }

    public ListTagsOptions key(String key) {
        this.queryParameters.replaceValues("key", ImmutableSet.of(key));
        return this;
    }

    public ListTagsOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListTagsOptions projectId(String projectId) {
        this.queryParameters.replaceValues("projectid", ImmutableSet.of(projectId));
        return this;
    }

    public ListTagsOptions resourceId(String resourceId) {
        this.queryParameters.replaceValues("resourceid", ImmutableSet.of(resourceId));
        return this;
    }

    public ListTagsOptions resourceType(String resourceType) {
        this.queryParameters.replaceValues("resourcetype", ImmutableSet.of(resourceType));
        return this;
    }

    public ListTagsOptions resourceType(Tag.ResourceType resourceType) {
        this.queryParameters.replaceValues("resourcetype", ImmutableSet.of(resourceType.toString()));
        return this;
    }

    public ListTagsOptions value(String value) {
        this.queryParameters.replaceValues("value", ImmutableSet.of(value));
        return this;
    }

    public ListTagsOptions page(long page) {
        this.queryParameters.replaceValues("page", ImmutableSet.of(page + ""));
        return this;
    }

    public ListTagsOptions pageSize(long pageSize) {
        this.queryParameters.replaceValues("pagesize", ImmutableSet.of(pageSize + ""));
        return this;
    }

    @Override
    public ListTagsOptions accountInDomain(String account, String domain) {
        return (ListTagsOptions)ListTagsOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListTagsOptions domainId(String domainId) {
        return (ListTagsOptions)ListTagsOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListTagsOptions accountInDomain(String account, String domain) {
            ListTagsOptions options = new ListTagsOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListTagsOptions domainId(String domainId) {
            ListTagsOptions options = new ListTagsOptions();
            return options.domainId(domainId);
        }

        public static ListTagsOptions customer(String customer) {
            ListTagsOptions options = new ListTagsOptions();
            return options.customer(customer);
        }

        public static ListTagsOptions isRecursive(boolean isRecursive) {
            ListTagsOptions options = new ListTagsOptions();
            return options.isRecursive(isRecursive);
        }

        public static ListTagsOptions key(String key) {
            ListTagsOptions options = new ListTagsOptions();
            return options.key(key);
        }

        public static ListTagsOptions keyword(String keyword) {
            ListTagsOptions options = new ListTagsOptions();
            return options.keyword(keyword);
        }

        public static ListTagsOptions projectId(String projectId) {
            ListTagsOptions options = new ListTagsOptions();
            return options.projectId(projectId);
        }

        public static ListTagsOptions resourceId(String resourceId) {
            ListTagsOptions options = new ListTagsOptions();
            return options.resourceId(resourceId);
        }

        public static ListTagsOptions resourceType(String resourceType) {
            ListTagsOptions options = new ListTagsOptions();
            return options.resourceType(resourceType);
        }

        public static ListTagsOptions resourceType(Tag.ResourceType resourceType) {
            ListTagsOptions options = new ListTagsOptions();
            return options.resourceType(resourceType);
        }

        public static ListTagsOptions value(String value) {
            ListTagsOptions options = new ListTagsOptions();
            return options.value(value);
        }

        public static ListTagsOptions page(long page) {
            ListTagsOptions options = new ListTagsOptions();
            return options.page(page);
        }

        public static ListTagsOptions pageSize(long pageSize) {
            ListTagsOptions options = new ListTagsOptions();
            return options.pageSize(pageSize);
        }
    }
}

