/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.domain;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.b2.domain.AutoValue_ListPartsResponse;
import org.jclouds.b2.domain.AutoValue_ListPartsResponse_Entry;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class ListPartsResponse {
    @Nullable
    public abstract Integer nextPartNumber();

    public abstract List<Entry> parts();

    @SerializedNames(value={"nextPartNumber", "parts"})
    public static ListPartsResponse create(@Nullable Integer nextPartNumber, List<Entry> parts) {
        return new AutoValue_ListPartsResponse(nextPartNumber, ImmutableList.copyOf(parts));
    }

    public static abstract class Entry {
        public abstract long contentLength();

        public abstract String contentSha1();

        public abstract String fileId();

        public abstract int partNumber();

        public abstract Date uploadTimestamp();

        @SerializedNames(value={"contentLength", "contentSha1", "fileId", "partNumber", "uploadTimestamp"})
        public static Entry create(long contentLength, String contentSha1, String fileId, int partNumber, long uploadTimestamp) {
            return new AutoValue_ListPartsResponse_Entry(contentLength, contentSha1, fileId, partNumber, new Date(uploadTimestamp));
        }
    }
}

