/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSet;
import org.jclouds.azurecompute.arm.domain.VirtualMachineScaleSetPlan;
import org.jclouds.azurecompute.arm.domain.VirtualMachineScaleSetProperties;
import org.jclouds.azurecompute.arm.domain.VirtualMachineScaleSetSKU;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VirtualMachineScaleSet {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String location();

    public abstract VirtualMachineScaleSetSKU sku();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract VirtualMachineScaleSetPlan plan();

    @Nullable
    public abstract VirtualMachineScaleSetProperties properties();

    @SerializedNames(value={"id", "name", "location", "sku", "tags", "plan", "properties"})
    public static VirtualMachineScaleSet create(String id, String name, String location, VirtualMachineScaleSetSKU sku, Map<String, String> tags, VirtualMachineScaleSetPlan plan, VirtualMachineScaleSetProperties properties) {
        return VirtualMachineScaleSet.builder().id(id).name(name).location(location).sku(sku).tags(tags).plan(plan).properties(properties).build();
    }

    public abstract Builder toBuilder();

    private static Builder builder() {
        return new AutoValue_VirtualMachineScaleSet.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder location(String var1);

        public abstract Builder sku(VirtualMachineScaleSetSKU var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder plan(VirtualMachineScaleSetPlan var1);

        public abstract Builder properties(VirtualMachineScaleSetProperties var1);

        abstract Map<String, String> tags();

        abstract VirtualMachineScaleSet autoBuild();

        public VirtualMachineScaleSet build() {
            this.tags(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null);
            return this.autoBuild();
        }
    }
}

