/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Disk;
import org.jclouds.azurecompute.arm.domain.DiskProperties;
import org.jclouds.azurecompute.arm.domain.SKU;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Disk {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    public abstract String location();

    @Nullable
    public abstract String type();

    @Nullable
    public abstract SKU sku();

    public abstract DiskProperties properties();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"id", "name", "location", "type", "sku", "properties", "tags"})
    public static Disk create(String id, String name, String location, String type, SKU sku, DiskProperties properties, Map<String, String> tags) {
        return Disk.builder().id(id).name(name).location(location).type(type).sku(sku).properties(properties).tags(tags).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Disk.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder location(String var1);

        public abstract Builder type(String var1);

        public abstract Builder sku(SKU var1);

        public abstract Builder properties(DiskProperties var1);

        public abstract Builder tags(Map<String, String> var1);

        abstract Map<String, String> tags();

        abstract Disk autoBuild();

        public Disk build() {
            this.tags(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null);
            return this.autoBuild();
        }
    }
}

