/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.MutableContainerPropertiesWithMetadata;
import org.jclouds.azureblob.domain.internal.MutableContainerPropertiesWithMetadataImpl;
import org.jclouds.azureblob.functions.ParsePublicAccessHeader;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseContainerPropertiesFromHeaders
implements Function<HttpResponse, ContainerProperties>,
InvocationContext<ParseContainerPropertiesFromHeaders> {
    private final DateService dateParser;
    private final String metadataPrefix;
    private GeneratedHttpRequest request;

    @Inject
    public ParseContainerPropertiesFromHeaders(DateService dateParser, @Named(value="jclouds.blobstore.metaprefix") String metadataPrefix) {
        this.dateParser = dateParser;
        this.metadataPrefix = metadataPrefix;
    }

    @Override
    public ContainerProperties apply(HttpResponse from) {
        MutableContainerPropertiesWithMetadataImpl to = new MutableContainerPropertiesWithMetadataImpl();
        to.setName(this.request.getInvocation().getArgs().get(0).toString());
        this.addUserMetadataTo(from, to);
        this.parseLastModifiedOrThrowException(from, to);
        this.addETagTo(from, to);
        to.setUrl(this.request.getEndpoint());
        to.setPublicAccess(new ParsePublicAccessHeader().apply(from));
        return to;
    }

    @VisibleForTesting
    void addUserMetadataTo(HttpResponse from, MutableContainerPropertiesWithMetadata metadata) {
        for (Map.Entry<String, String> header : from.getHeaders().entries()) {
            if (header.getKey() == null || !header.getKey().startsWith(this.metadataPrefix)) continue;
            metadata.getMetadata().put(header.getKey().substring(this.metadataPrefix.length()).toLowerCase(), header.getValue());
        }
    }

    @VisibleForTesting
    void parseLastModifiedOrThrowException(HttpResponse from, MutableContainerPropertiesWithMetadata metadata) throws HttpException {
        String lastModified = from.getFirstHeaderOrNull("Last-Modified");
        if (lastModified == null) {
            throw new HttpException("Last-Modified header not present in response: " + from);
        }
        metadata.setLastModified(this.dateParser.rfc822DateParse(lastModified));
        if (metadata.getLastModified() == null) {
            throw new HttpException("could not parse: Last-Modified: " + lastModified);
        }
    }

    @VisibleForTesting
    protected void addETagTo(HttpResponse from, MutableContainerPropertiesWithMetadata metadata) {
        String eTag = from.getFirstHeaderOrNull("ETag");
        if (metadata.getETag() == null && eTag != null) {
            metadata.setETag(eTag);
        }
    }

    @Override
    public ParseContainerPropertiesFromHeaders setContext(HttpRequest request) {
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "note this handler requires a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)request;
        return this;
    }
}

