/*
 * Decompiled with CFR 0.152.
 */
package com.util.para;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.operation.OrderBy;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.bson.Document;

public class AgentLogsUtilityNew {
    public static void main(String[] args) throws IOException, ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceName = config.getProperty("deviceName").toString();
        String userName = config.getProperty("userName").toString();
        String action = config.getProperty("action").toString();
        String path = config.getProperty("path").toString();
        boolean pullLogs = config.getBoolean("pullLogs");
        boolean pullHistoricalLogs = config.getBoolean("pullHistoricalLogs");
        boolean pullDataBase = config.getBoolean("pullDataBase");
        boolean pullSetUpLogs = config.getBoolean("pullSetUpLogs");
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI supportUri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/support");
        MongoClient supportClient = new MongoClient(supportUri);
        MongoDatabase supportDb = supportClient.getDatabase(supportUri.getDatabase());
        MongoCollection<Document> deviceCollection = db.getCollection("DEVICE");
        MongoCollection<Document> eventCollection = db.getCollection("EVENT_HUB");
        MongoCollection<Document> bluvaultCollection = db.getCollection("BLUVAULT_PROPERTIES");
        String reason = "";
        String statusCode = "";
        MongoCollection<Document> supportCollection = supportDb.getCollection("SUPPORT_LOGS");
        System.out.println("userName:" + userName + " deviceName:" + deviceName);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("deviceName", deviceName));
        andQuery.put("$and", whereQuery);
        if (action.equalsIgnoreCase("pull_request")) {
            System.out.println("Inside pull_request.......");
            FindIterable<Document> devices = deviceCollection.find(andQuery);
            if (devices == null) {
                System.out.println("No device found....");
                reason = "No device found";
                statusCode = "404";
                System.out.println("Status Code=" + statusCode);
                System.exit(2);
            }
            for (Document device : devices) {
                ArrayList<BasicDBObject> whereQuery2 = new ArrayList<BasicDBObject>();
                BasicDBObject andQuery2 = new BasicDBObject();
                whereQuery2.add(new BasicDBObject("actionToDeviceUUID", device.getString("deviceUUID")));
                whereQuery2.add(new BasicDBObject("action", "PULL_AGENTLOGS"));
                andQuery2.put("$and", whereQuery2);
                Document event = (Document)eventCollection.find(andQuery2).first();
                if (event != null) {
                    System.out.println("event is already exists.....");
                    reason = "event is already exists";
                    statusCode = "202";
                    System.out.println("Status Code=" + statusCode);
                    System.exit(3);
                    continue;
                }
                Document eve = new Document();
                eve.put("actionBy", (Object)"admin");
                eve.put("actionToUserName", (Object)userName);
                eve.put("actionToDeviceUUID", (Object)device.getString("deviceUUID"));
                eve.put("action", (Object)"PULL_AGENTLOGS");
                eve.put("actionStatus", (Object)"CREATED");
                eventCollection.insertOne(eve);
                if (pullHistoricalLogs) {
                    eve = new Document();
                    eve.put("actionBy", (Object)"admin");
                    eve.put("actionToUserName", (Object)userName);
                    eve.put("actionToDeviceUUID", (Object)device.getString("deviceUUID"));
                    eve.put("actionStatus", (Object)"CREATED");
                    eve.put("action", (Object)"PULL_HISTORICAL_LOGS");
                    eventCollection.insertOne(eve);
                }
                if (pullDataBase) {
                    eve = new Document();
                    eve.put("actionBy", (Object)"admin");
                    eve.put("actionToUserName", (Object)userName);
                    eve.put("actionToDeviceUUID", (Object)device.getString("deviceUUID"));
                    eve.put("actionStatus", (Object)"CREATED");
                    eve.put("action", (Object)"PULL_HISTORICAL_LOGS");
                    eve.put("action", (Object)"DATABASES");
                    eventCollection.insertOne(eve);
                }
                if (pullSetUpLogs) {
                    eve = new Document();
                    eve.put("actionBy", (Object)"admin");
                    eve.put("actionToUserName", (Object)userName);
                    eve.put("actionToDeviceUUID", (Object)device.getString("deviceUUID"));
                    eve.put("actionStatus", (Object)"CREATED");
                    eve.put("action", (Object)"PULL_HISTORICAL_LOGS");
                    eve.put("action", (Object)"SETUP_LOGS");
                    eventCollection.insertOne(eve);
                }
                System.out.println("create events.......");
                statusCode = "200";
                reason = "create events";
            }
        } else if (action.equalsIgnoreCase("get_logs")) {
            System.out.println("Inside get_logs.......");
            BasicDBObject andQuery3 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery3 = new ArrayList<BasicDBObject>();
            whereQuery3.add(new BasicDBObject("userName", userName));
            whereQuery3.add(new BasicDBObject("deviceName", deviceName));
            andQuery3.put("$and", whereQuery);
            Document support = (Document)supportCollection.find(andQuery3).sort(new BasicDBObject("timeStamp", (Object)OrderBy.DESC.getIntRepresentation())).first();
            if (support != null) {
                String id = support.getObjectId("_id").toString();
                System.out.println("id:" + id);
                System.out.println("success......");
                reason = "success";
                statusCode = "200";
                System.out.println("path : /parablu/support/bslogs/" + id);
            } else {
                System.out.println("logs not yet came....");
                reason = "logs not yet came";
                statusCode = "205";
            }
        } else {
            System.out.println("logs not yet came....");
            reason = "logs not yet came";
            statusCode = "205";
        }
        System.out.println("reason=" + reason);
        System.out.println("Status Code=" + statusCode);
        System.exit(0);
    }

    public static enum EVENTHUB_ACTION {
        PULL_AGENTLOGS("PULL_AGENTLOGS", 0),
        PULL_HISTORICAL_LOGS("PULL_HISTORICAL_LOGS", 1),
        DATABASES("DATABASES", 2),
        SETUP_LOGS("SETUP_LOGS", 3);


        private EVENTHUB_ACTION(String name, int ordinal) {
        }
    }
}

