/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2LifecycleRule {
    @B2Json.required
    private final String fileNamePrefix;
    @B2Json.optional
    private final Integer daysFromUploadingToHiding;
    @B2Json.optional
    private final Integer daysFromHidingToDeleting;

    public static Builder builder(String fileNamePrefix) {
        return new Builder(fileNamePrefix);
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public Integer getDaysFromUploadingToHiding() {
        return this.daysFromUploadingToHiding;
    }

    public Integer getDaysFromHidingToDeleting() {
        return this.daysFromHidingToDeleting;
    }

    @B2Json.constructor(params="fileNamePrefix, daysFromUploadingToHiding, daysFromHidingToDeleting")
    private B2LifecycleRule(String fileNamePrefix, Integer daysFromUploadingToHiding, Integer daysFromHidingToDeleting) {
        B2Preconditions.checkArgument(fileNamePrefix != null, "fileNamePrefix must not be null");
        B2Preconditions.checkArgument(B2LifecycleRule.isNullOrPositive(daysFromUploadingToHiding), "daysFromUploadingToHiding must be positive");
        B2Preconditions.checkArgument(B2LifecycleRule.isNullOrPositive(daysFromHidingToDeleting), "daysFromHidingToDeleting must be positive");
        this.daysFromUploadingToHiding = daysFromUploadingToHiding;
        this.daysFromHidingToDeleting = daysFromHidingToDeleting;
        this.fileNamePrefix = fileNamePrefix;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.fileNamePrefix, this.daysFromUploadingToHiding, this.daysFromHidingToDeleting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2LifecycleRule that = (B2LifecycleRule)o;
        return Objects.equals(this.fileNamePrefix, that.fileNamePrefix) && Objects.equals(this.daysFromUploadingToHiding, that.daysFromUploadingToHiding) && Objects.equals(this.daysFromHidingToDeleting, that.daysFromHidingToDeleting);
    }

    public int hashCode() {
        return Objects.hash(this.fileNamePrefix, this.daysFromUploadingToHiding, this.daysFromHidingToDeleting);
    }

    private static boolean isNullOrPositive(Integer n) {
        return n == null || n > 0;
    }

    public static class Builder {
        private final String fileNamePrefix;
        private Integer daysFromUploadingToHiding;
        private Integer daysFromHidingToDeleting;

        public Builder(String fileNamePrefix) {
            this.fileNamePrefix = fileNamePrefix;
        }

        public Builder setDaysFromUploadingToHiding(Integer daysFromUploadingToHiding) {
            this.daysFromUploadingToHiding = daysFromUploadingToHiding;
            return this;
        }

        public Builder setDaysFromHidingToDeleting(Integer daysFromHidingToDeleting) {
            this.daysFromHidingToDeleting = daysFromHidingToDeleting;
            return this;
        }

        public B2LifecycleRule build() {
            return new B2LifecycleRule(this.fileNamePrefix, this.daysFromUploadingToHiding, this.daysFromHidingToDeleting);
        }
    }
}

