<?php
use \Core\View;
use \Helpers\Url;
use \Core\Language;
/*  
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.4.15
* @date 11/06/2023
* @time 18:49 PM
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SupportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='downloads'?></span>
            <div class="panel">
                <div class="panel-heading">
                    <h4>Files available for download</h4>
                </div>
                <div class="panel-body">                 
                    <div class="table-responsive">
                        <div class="h4 loading text-center"><img width="70px" src="<?=Url::templatePath()?>images/gears.gif"></div>
                        <table class="table table-bordered table-striped supportLogTable" style="display: none;">
                            <colgroup>
                                <col class="col-xs-2">
                                <col class="col-xs-3">
                                <col class="col-xs-4">
                                <col class="col-xs-3">
                            </colgroup>
                            <thead>
                            <tr>
                                    <th class="clickAble" ng-click="sortTypeD = 'fileName'; sortReverse = !sortReverse">
                                        <?=Language::show('File Name', 'keywords')?>
                                        <span ng-show="sortTypeD == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeD == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="clickAble" ng-click="sortTypeD = 'rawsize'; sortReverse = !sortReverse">
                                        <?=Language::show('Size', 'keywords')?>
                                        <span ng-show="sortTypeD == 'rawsize' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeD == 'rawsize' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="clickAble" ng-click="sortTypeD = 'lastServerModifiedTimeinMillis'; sortReverse = !sortReverse">
                                        <?=Language::show('Modified Time', 'keywords')?>
                                        <span ng-show="sortTypeD == 'lastServerModifiedTimeinMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeD == 'lastServerModifiedTimeinMillis' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="clickAble" ng-click="sortTypeD = 'fileName'; sortReverse = !sortReverse">
                                        <?=Language::show('Action', 'keywords')?>
                                        <span ng-show="sortTypeD == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeD == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in fileList | orderBy:sortTypeD:sortReverse">
                                <td ng-cloak>{{ value.fileName }}</td>
                                <td ng-cloak>{{ value.size }}</td>
                                <td ng-cloak>{{ value.lastServerModifiedTime }}</td>
                                <td><a class="btn btn-success btn-small" ng-click="downloadFile(value.fileName)" ng-cloak><i class="fa fa-download"></i> Download</a></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <!--<div class="row supportLogTable" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="updatedSupportLogsNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="updatedSupportLogsNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="updatedSupportLogsNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="updatedSupportLogsNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
      </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SupportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
