<?php

use \Core\View;
use \Helpers\Url;
use Helpers\Form;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='smtp'?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h4><?=$data['crumb1']?></h4>
                    </div>
                    <div class="panel-body">
			<form class="smtpConfiguration" id="smtpConfiguration" ng-submit="saveSmtpConfiguration()" data-parsley-validate>
				<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
				        <div class="d-none">
                                                <label for="pubkey">Public Key</label><br/>
                            <textarea id="pubkey" rows="15" cols="65">-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCqGKukO1De7zhZj6+H0qtjTkVxwTCpvKe4eCZ0
FPqri0cb2JZfXJ/DgYSF6vUpwmJG8wVQZKjeGcjDOL5UlsuusFncCzWBQ7RKNUSesmQRMSGkVb1/
3j+skZ6UtW+5u09lHNsj6tQ51s1SPrCBkedbNf0Tp0GbMJDyR4e9T04ZZwIDAQAB
-----END PUBLIC KEY-----</textarea><br/>
                        </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpHost">SMTP Host</label>
                                <input type="text" class="form-control" name="smtpHost" id="smtpHost" value="" placeholder="Enter SMTP Host" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="sslPort">SSL Port</label>
                                <input type="number" class="form-control" name="sslPort" id="sslPort" value="" placeholder="Enter SSL Port" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="factoryClass">SSL Factory Class</label>
                                <input type="text" class="form-control" name="factoryClass" id="factoryClass" value="" placeholder="Enter SSL Factory Class" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpPort">SMTP Port</label>
                                <input type="number" class="form-control" name="smtpPort" id="smtpPort" value="" placeholder="Enter SMTP Port" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpAuth">SMTP Auth</label>
                                <select class="form-control smtpAuth selectpicker" name="smtpAuth" id="smtpAuth" >
                                    <option value="true">True</option>
                                    <option value="false">False</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpStarttlsEnable">SMTP Start TLS Enable</label>
                                <select class="form-control smtpStarttlsEnable selectpicker" name="smtpStarttlsEnable" id="smtpStarttlsEnable" >
                                    <option value="true">True</option>
                                    <option value="false">False</option>
                                </select>
                            </div>
			    <div class="form-group col-lg-6">
                                <label for="smtpSSLEnable">SMTP SSL Enable</label>
                                <select class="form-control smtpSSLEnable selectpicker" name="smtpSSLEnable" id="smtpSSLEnable" >
                                    <option value="true">True</option>
                                    <option value="false">False</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpUname">SMTP Username</label>
                                <input type="text" class="form-control" name="smtpUname" id="smtpUname" value="" placeholder="Enter SMTP Username" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpPwd">SMTP Password</label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="Password change may cause...."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="password" class="form-control" name="smtpPwd" id="smtpPwd" value="" placeholder="Enter SMTP Password" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="email">Email ID</label>
                                <input type="email" class="form-control" name="email" id="email" value="" placeholder="Enter your Email ID" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="enableMail">Enable Email</label>
                                <select class="form-control enableMail selectpicker" name="enableMail" id="enableMail" >
                                    <option value="true">True</option>
                                    <option value="false">False</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-12">
                                <button type="submit" class="btn saveSMTP btn-success pull-right">Save</button>
			    </div>
</div>
                        </form>
                    </div>
                </div>
                <!--start add-->
                <div class="modal fade" id="testMail" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <?= Form::open(array(
                                        'ng-submit' => 'testMail()',
                                        'class' => 'testMailClass',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
                                        <div class="modal-header">
                                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                                            <h4 class="modal-title"><?=Language::show('Test Mail Validation', 'keywords')?></h4>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="email"><?=Language::show('Email', 'keywords')?></label>
                                                    <input type="email" class="form-control" name="email" id="testEmail" value="" placeholder="Enter your email id" required autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success testEmailBtn"><?=Language::show('Test Mail', 'keywords')?></button>
                                            <a ng-click="closeTestMail()" class="btn btn-default"><?=Language::show('Close', 'keywords')?></a>
                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end add -->
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
