<?php
use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.5.5.1
 * @date 21/07/22
 * @time 18:55
 * 
 */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
       <div class="col-lg-6">
        <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?='Encryption key management'?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='SSL and Encryption Configuration'?></span>
            <div class="row">
<div class="panel col-lg-12">
                                    <div class="form-group col-lg-12">
                                        <label for="azureType">Select Type</label>
                                        <select class="form-control" name="azureType" id="azureType" required>
                                                <option value="localKey">Local Encryption Configuration</option>
                                                <!--<option value="AZURE">Azure Key Vault</option>-->
                                        </select>
                                    </div>
</div>
<!--azure vault panel start-->
<div class="panel col-lg-12 azureVaultPanel">
<div class="panel-body">
                            <form class="encryptionConfiguration" ng-submit="saveEncryptionConfiguration()" data-parsley-validate>
<div class="localSettings" style="display:none;">
<div class="panel-heading">
                                <h4>Local Configuration</h4>
 </div>
<div class="panel-body">
                                <div class="table-responsive keychart d-none">
                                    <div class="h4 loading text-center d-none">Loading.....</div>
                                    <table class="table table-bordered table-striped deviceListTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Product Type</th>
                                            <th class="text-center">Salt key</th>
                                            <th class="text-center">Modified by</th>
                                            <th class="text-center">Modified time</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr class="ng-scope" ng-repeat="value in keys track by $index" ng-if="value.endTimestamp == 0">
                                            <td class="text-center" ng-if="value.productType == 'backup'">BluVault</td>
                                            <td class="text-center" ng-if="value.productType == 'serverBackup'">BluVault For Servers</td>
                                            <td class="text-center" ng-if="value.productType == 'sync'">BluSync</td>
                                            <td class="text-center">##############</td>
                                            <td class="text-center">{{value.userName}}</td>
                                            <td class="text-center">{{value.startTime}}</td>

                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                    <div class="form-group col-lg-12">
                                        <label for="productType">Select a Product Type</label>
                                        <select class="form-control" name="productType" id="productType" required>
                                                <?php if(\Helpers\Auth::checkCloudPermission('backup') || \Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                    <option value="backup">BluVault</option>
                                                <?php } ?>
                                         <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                                    <option value="serverBackup">BluVault For Servers</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                        <option value="sync">BluSync</option>
                                                <?php } ?>
                                                <?php //if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
							<!--<option value="O365">Office365</option>-->
                                                <?php //} ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="saltKey">Salt key</label>
                                        <input type="text" class="form-control" name="saltKey" id="saltKey" value="" placeholder="Enter your Salt key" autocomplete="off">
                                        <span class="help-line text-muted">Note:- This will be a part of the Encryption key, If the Administrator chooses to specify a salt key, salt key must be a min length of 16 and max length of 128.</span>
                                    </div>
                                    <br/>
                                    <div class="col-lg-12">
					<button type="submit" class="saveEncSetting btn btn-success float-right">Save</button>
					<a class="btn btn-primary pull-right" href="<?=Url::basePath('settings')?>" style="margin-right: 10px;">Cancel</a>
                                    </div>
</div>
</div>
</div>
<div class="azureVaultSettings" style="display:none;">
<div>
                                <h4>Azure Salt Configuration</h4>
                            </div>

                                <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                               <div class="form-group col-lg-6">
                                    <label id="clientIdLabel" for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter your Client ID" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label id="secretKeyLabel" for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                    <input type="text" class="form-control" name="secretKey" id="secretKey" value="" placeholder="Enter your Secret Key" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 tenantId">
                                        <label id="tenantIdLabel" for="tenantId"><?=Language::show('tenentId', 'keywords')?></label>
                                        <input type="text" class="form-control" name="tenantId" id="tenantId" value="" placeholder="Enter your Tenant Id" autocomplete="off">
                                </div>
<div class="row col-lg-12">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('Salt Configurations', 'keywords')?><span class="pull-right"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Salt Key</a></span></h4>
                                            </div>
<div class="panel-body col-lg-12">
                                                <table id="myTableAdd" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Vault</th>
                                                            <th>Key</th>
                                                            <th>Product Type</th>
                                                        </tr>
                                                     </thead>
                                                    <tbody>
                                                        <tr ng-if="vaultSecret ==''" class="first1">
                                                            <td ng-cloak style="vertical-align:middle;">
                                                                <input type="text" class="form-control vaultName" name="vaultName[]" id="vaultName" value="" placeholder="Enter Vault Name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;vertical-align:middle;">
                                                                <input type="text" class="form-control secretNames" name="secretNames[]" id="secretNamesInput" value="" placeholder="Enter Key" autocomplete="off">
                                                            </td>
                                                            <td>
<div class="form-group col-lg-12">
                                        <select class="form-control" name="productTypeAz[]" id="productTypeAz" required>
                                                <?php if(\Helpers\Auth::checkCloudPermission('backup') || \Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                    <option value="backup">BluVault</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                                    <option value="serverBackup">BluVault For Servers</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                        <option value="sync">BluSync</option>
                                                <?php } ?>
                                                <?php //if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                        <!--<option value="O365">Office365</option>-->
                                                <?php //} ?>
                                        </select>
                                    </div>
</td>
                                                        </tr>
                                                     <tr ng-if="vaultSecret != ''" ng-repeat="value in vaultSecret" class="first1">
                                                            <td ng-if="value.azureSaltKey == ''" ng-cloak style="vertical-align:middle;">
                                                                <input type="text" class="form-control vaultName" name="vaultName[]" id="vaultName" value="" placeholder="Enter Vault Name" autocomplete="off">
                                                            </td>
<td ng-if="value.azureSaltKey != ''" ng-cloak style="vertical-align:middle;">
                                                    <input type="text" class="form-control vaultName" name="vaultName[]" id="vaultName{{$index}}" value="{{value.azureSaltKey}}" placeholder="Enter Vault Name" autocomplete="off" readonly>
                                                </td>
                                                            <td ng-cloak style="white-space:unset !important;vertical-align:middle;">
<!--<span class="tag label label-info" id="secretNames{{$index}}" name="secretNames[]" style="margin-right: 5px;padding:5px;font-size:13px;" ng-cloak>{{value.saltSecret }}</span>-->
<input type="text" class="form-control secretNames" name="secretNames[]" id="secretNames{{$index}}" value="{{value.saltSecret }}" placeholder="Enter Secret Name" autocomplete="off" readonly>
                                                            </td>
<td>
<div class="form-group col-lg-12">
                                        <select class="form-control productTypeAz" name="productTypeAz[]" id="productTypeAz{{$index}}" readonly style="pointer-events:none;">
                                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                    <option value="backup" ng-selected="value.azureProductType == 'backup'">BluVault</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                        <option value="sync" ng-selected="value.azureProductType == 'sync'">BluSync</option>
                                                <?php } ?>
                                                <?php //if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                        <!--<option value="O365" ng-selected="value.azureProductType == 'O365'">Office365</option>-->
                                                <?php //} ?>
                                        </select>
                                    </div>
</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
 <br/>
<div class="col-lg-12">
	<a class="saveEncSetting btn btn-success float-right" ng-bootbox-confirm="<h4><?=Language::show('Please check the Secret Name as once saved you will be unable to edit.', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEncryptionConfiguration()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('save', 'keywords');?></a>
	<a class="btn btn-primary pull-right" href="<?=Url::basePath('settings')?>" style="margin-right: 10px;">Cancel</a>
</div>
</div>
</div>
                                </form>
                            </div>
</div>
<!--azure vault panel end-->
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js" type="text/javascript"></script>
<script>
$('#azureType').on('change', function(){
        var type = $('#azureType').val();
        if(type == 'localKey'){
                $('.localSettings').show();
                $('.azureVaultSettings').hide();
                $('#clientIdLabel').removeClass('star');
                $('#secretKeyLabel').removeClass('star');
                $('#tenantIdLabel').removeClass('star');
                $('#clientId').removeAttr("required");
                $('#secretKey').removeAttr("required");
                $('#tenantId').removeAttr("required");
        }else{
                $('.localSettings').hide();
                $('.azureVaultSettings').show();
                $('#clientIdLabel').addClass('star');
                $('#secretKeyLabel').addClass('star');
                $('#tenantIdLabel').addClass('star');
                $('#clientId').attr("required", "required");
                $('#secretKey').attr("required", "required");
                $('#tenantId').attr("required", "required");
        }
});
 
function addDynamicAdd(){
    var trlength= $('#myTableAdd tbody tr').length;
    var i = trlength;
    //console.log("trlength : "+trlength);
    var lasttr=$('#myTableAdd tbody tr:last').clone();
    lasttr.find('.vaultName').attr('id', 'vaultName' + trlength);    
    lasttr.find('.vaultName').attr('name', 'vaultName[]');
    lasttr.find('.vaultName').removeAttr('readonly');
    lasttr.find('.secretNames').attr('id', 'secretNamesInput' + trlength);
    lasttr.find('.secretNames').attr('name', 'secretNames[]');
    lasttr.find('.secretNames').removeAttr('readonly');
    lasttr.find('.secretNames').attr('class', 'kk form-control');
    lasttr.find('.secretNames').attr('value', '');
    lasttr.find('.productTypeAz').attr('id', 'productTypeAz' + trlength);
    lasttr.find('.productTypeAz').attr('name', 'productTypeAz[]');
    lasttr.find('.productTypeAz').removeAttr('readonly');
    lasttr.find('.productTypeAz').css('pointer-events','unset');
    lasttr.find('input').val('');
    lasttr.find('span').remove();
    $('.kk').not(':first').remove();
    i++;
    $('#myTableAdd tbody').append(lasttr);
    trlength= $('#myTableAdd tbody tr').length;
    i = trlength;
    //console.log("trlength11 : "+trlength);
    if(i > 1){
      $("[id*='removeAdd']").removeClass('disabled');
    }
}
</script> 
