<?php

use \Core\View;
use \Helpers\Url;
use \Core\Language;
use Helpers\Form;

/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4.0.5
* @date 05/06/19
* @time 17:48 PM
*
*/
?>
<div class="container">
    <div class="row">
    	<div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?="Settings"?></a></h3></li>
                <li>Backup Agent Package Management</li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='epaManager'?></span>
            <div class="panel panel-default">
                    <div class="panel-heading"><h3>Backup Agent Package Management</h3></div>
                    <div class="panel-body">
<!--                    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                        <li role="presentation" class="nav-item"><a class="nav-link active" data-target="#windows" aria-controls="windows" role="tab" data-toggle="tab">Windows</a></li>
                       <li class="nav-item" role="presentation"><a class="nav-link" data-target="#mac" aria-controls="mac" role="tab" data-toggle="tab">Mac</a></li>
		    </ul>-->
		   <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#windows" aria-expanded="true" aria-controls="windows">Windows</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#mac" aria-expanded="false" aria-controls="mac">Mac</a></li>
		      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#linux" aria-expanded="false" aria-controls="linux">Linux</a></li>
                    </ul>
                   <?php } ?>

		   <?php if(!isMobile()){ ?>
		    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#windows" aria-controls="windows" role="tab" data-toggle="tab">Windows</a></li>
                        <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#mac" aria-controls="mac" role="tab" data-toggle="tab">Mac</a></li>
			<li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#linux" aria-controls="linux" role="tab" data-toggle="tab">Linux</a></li>
                    </ul>
		   <?php } ?>

                <div class="tab-content">
		    <div role="tabpanel" class="tab-pane active" id="windows">
<br>
<?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
		      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#windowsEndPoint" aria-expanded="true" aria-controls="windowsEndPoint">Windows Endpoint</a></li>
		      <?php if($data['Windows_Server_Backup_Enabled'] == 'yes'){ ?>
		      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#windowsServer" aria-expanded="false" aria-controls="windowsServer">Windows Server</a></li>
		      <?php } ?>
                    </ul>
                   <?php } ?>
<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-size: small;font-weight: 600;">
			<li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#windowsEndPoint" aria-controls="windowsEndPoint" role="tab" data-toggle="tab">Windows Endpoint</a></li>
			<?php if($data['Windows_Server_Backup_Enabled'] == 'yes'){ ?>
			<li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#windowsServer" aria-controls="windowsServer" role="tab" data-toggle="tab">Windows Server</a></li>
			<?php } ?>
                    </ul>
                   <?php } ?>
<div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="windowsEndPoint">
                    <!-- for win start -->
                        <div class="panel panel-default">
                            <div class="panel-heading"><h3>EPA for Windows</h3></div>
                                <div class="panel-body">
                                    <div>
                                        <div id="example2" class="col-lg-6">
					    <form class="winAgentForm" data-parsley-validate enctype="multipart/form-data">
						    <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                                <div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="downloadAgent" name="downloadAgent" type="checkbox" value="enabled" onclick="myFunction()">
                                                        <label for="downloadAgent"><?=Language::show('Allow Agent Download', 'keywords');?></label>
                                                    </div>
                                                </div>
                                                <div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="autoUpdate" name="autoUpdate" type="checkbox" value="enabled" onclick="myFunction()">
                                                        <label for="autoUpdate"><?=Language::show('Auto Update Agent', 'keywords');?></label>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12" style="margin-bottom:15px;">
                                                    <label><?=Language::show('Current Version : ', 'keywords');?></label>
                                                        <span ng-cloak id="currentWinAgentVersion">NA</span>
                                                    </label>    
                                                </div>
                                                <!--<div class="form-group">
                                                            <label for="allowUpdate"><?=Language::show('Allow Update', 'keywords');?></label>
                                                            <select class="form-control allowUpdate" name="allowUpdate" id="allowUpdate" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                            </select>
                                                        </div>-->
                                                <div class="col-lg-12" id="chooser" style="pointer-events : none;">
                                                    <label><?=Language::show('Upload Package  ', 'keywords');?></label></br>
                                                    <div class="col-lg-12" style="margin-bottom:15px;">
                                                        <input type="radio" name="optradio" value="linkClicked" checked>
                                                        <label for="link"><?=Language::show('Package URL', 'keywords');?></label>
                                                        <input type="text" class="form-control" name="link" id="link" placeholder="<?=Language::show('Package URL', 'keywords');?>" autocomplete="off">
                                                    </div>
                                                    </br>
                                                    <div class="col-lg-12">
                                                        <input type="radio" name="optradio" value="fileClicked">Select File : <input type="file" name="updateFileName" id="updateFileName" accept=".exe" style="pointer-events: none;">
                                                        <?php if(isMobile()){ ?>
                                                        <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <span id="fileUploadingProgress"></span>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div id="progress-div-win" style="display:none;">
                                                        <div id="progress-bar-win"></div>
                                                    </div>
                                                    <div id="targetLayerWin"></div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button type="submit" class="submit btn btn-primary float-right winSave" style="margin-right: 10px;"><?=Language::show('save', 'keywords');?></button>
						</div>
</div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
		    <!-- for win end-->
</div>
<div role="tabpanel" class="tab-pane" id="windowsServer">
                    <!-- for win server start -->
                        <div class="panel panel-default">
                            <div class="panel-heading"><h3>EPA for Windows Server</h3></div>
                                <div class="panel-body">
                                    <div>
                                        <div id="example2" class="col-lg-6">
                                            <form class="winServerAgentForm" data-parsley-validate enctype="multipart/form-data">
                                                    <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                                <div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="downloadAgentServer" name="downloadAgentServer" type="checkbox" value="enabled" onclick="myFunctionServer()">
                                                        <label for="downloadAgentServer"><?=Language::show('Allow Agent Download', 'keywords');?></label>
                                                    </div>
                                                </div>
                                                <!--<div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="autoUpdateServer" name="autoUpdateServer" type="checkbox" value="enabled" onclick="myFunctionServer()">
                                                        <label for="autoUpdateServer"><?=Language::show('Auto Update Agent', 'keywords');?></label>
                                                    </div>
                                                </div>-->
                                                <div class="col-lg-12" style="margin-bottom:15px;">
                                                    <label><?=Language::show('Current Version : ', 'keywords');?></label>
                                                        <span ng-cloak id="currentWinServerAgentVersion">NA</span>
                                                    </label>
                                                </div>
						<div class="col-lg-12" id="chooserServer" style="pointer-events : none;">
						    <label><?=Language::show('Upload Package  ', 'keywords');?></label></br>
                                                    <div class="col-lg-12" style="margin-bottom:15px;">
                                                        <input type="radio" name="optradioServer" value="linkClickedServer" checked>
                                                        <label for="linkServer"><?=Language::show('Package URL', 'keywords');?></label>
                                                        <input type="text" class="form-control" name="linkServer" id="linkServer" placeholder="<?=Language::show('Package URL', 'keywords');?>" autocomplete="off">
                                                    </div>
                                                    </br>
                                                    <div class="col-lg-12">
                                                        <input type="radio" name="optradioServer" value="fileClickedServer">Select File : <input type="file" name="updateFileNameServer" id="updateFileNameServer" accept=".exe" style="pointer-events: none;">
                                                        <?php if(isMobile()){ ?>
                                                        <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <span id="fileUploadingProgressServer"></span>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div id="progress-div-winServer" style="display:none;">
                                                        <div id="progress-bar-winServer"></div>
                                                    </div>
                                                    <div id="targetLayerWinServer"></div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button type="submit" class="submit btn btn-primary float-right winServerSave" style="margin-right: 10px;"><?=Language::show('save', 'keywords');?></button>
						</div>
</div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <!-- for win server end-->
</div>
</div>
                    </div>                    
                    <div role="tabpanel" class="tab-pane" id="mac">
                    <!-- for mac start-->
                        <div class="panel panel-default">
                            <div class="panel-heading"><h3>EPA for Mac</h3></div>
                                <div class="panel-body">
                                    <div>
                                        <div id="example2" class="col-lg-6">
					    <form class="macAgentForm" data-parsley-validate enctype="multipart/form-data">
						    <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                                <div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="downloadAgentMac" name="downloadAgentMac" type="checkbox" value="enabled" onclick="myFunctionMac()">
                                                        <label for="downloadAgentMac"><?=Language::show('Allow Agent Download', 'keywords');?></label>
                                                    </div>
                                                </div>
                                            <!--<div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="autoUpdateMac" name="autoUpdateMac" type="checkbox" value="enabled">
                                                    <label for="autoUpdateMac"><?=Language::show('Auto Update Mac Agent', 'keywords');?></label>
                                                </div>
                                                </div>
                                                <div class="form-group">
                                                <label for="allowUpdateMac"><?=Language::show('Allow Update', 'keywords');?></label>
                                                <select class="form-control allowUpdateMac" name="allowUpdateMac" id="allowUpdateMac" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                                 </div>-->
                                                 <div class="col-lg-12" style="margin-bottom:15px;">
                                                    <label><?=Language::show('Current Version : ', 'keywords');?></label>
                                                    <span ng-cloak id="currentMacAgentVersion">NA</span>
                                                    </label>
                                                </div>
                                                <div class="col-lg-12" id="chooserMac" style="pointer-events : none;">
                                                    <label><?=Language::show('Upload Package  ', 'keywords');?></label></br>
                                                    <div class="col-lg-12" style="margin-bottom:15px;">
                                                        <input type="radio" name="optradioMac" value="linkClickedMac" checked>
                                                        <label for="linkMac"><?=Language::show('Package URL', 'keywords');?></label>
                                                        <input type="text" class="form-control" name="linkMac" id="linkMac" placeholder="<?=Language::show('Package URL', 'keywords');?>" autocomplete="off">
                                                    </div>
                                                    </br>
                                                    <div class="col-lg-12">
                                                        <input type="radio" name="optradioMac" value="fileClickedMac">Select File : <input type="file" name="updateFileNameMac" id="updateFileNameMac" accept=".dmg" style="pointer-events: none;">
                                                        <?php if(isMobile()){ ?>
                                                        <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <span id="fileUploadingProgressMac"></span>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div id="progress-div-mac" style="display:none;">
                                                        <div id="progress-bar-mac"></div>
                                                    </div>
                                                    <div id="targetLayerMac"></div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button type="submit" class="submit btn btn-primary float-right macSave" style="margin-right: 10px;"><?=Language::show('save', 'keywords');?></button>
						</div>
</div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <!-- for mac end -->
                    </div>
		    <!--sssss-->
		    <div role="tabpanel" class="tab-pane" id="linux">
		    <?php if(isMobile()){ ?>
			    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
			      	<li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#deb" aria-expanded="true" aria-controls="deb">Debian Package</a></li>
			      	<li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#rpm" aria-expanded="false" aria-controls="rpm">RPM Package</a></li>
			    </ul>
                   <?php } ?>
		    <?php if(!isMobile()){ ?>
			    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
				<li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#deb" aria-controls="deb" role="tab" data-toggle="tab">Debian Package</a></li>
				<li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#rpm" aria-controls="rpm" role="tab" data-toggle="tab">RPM Package</a></li>
			    </ul>
                   <?php } ?>
		   <div class="tab-content">
		   <div role="tabpanel" class="tab-pane active" id="deb">
                    <!-- for linux start-->
                        <div class="panel panel-default">
                            <div class="panel-heading"><h3>EPA for Debian Package</h3></div>
                                <div class="panel-body">
                                    <div>
                                        <div id="example2" class="col-lg-6">
                                            <form class="linuxAgentForm" data-parsley-validate enctype="multipart/form-data">
                                                <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
						<div class="row">
                                                <div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="downloadAgentLinux" name="downloadAgentLinux" type="checkbox" value="enabled" onclick="myFunctionLinux()">
                                                        <label for="downloadAgentLinux"><?=Language::show('Allow Agent Download', 'keywords');?></label>
                                                    </div>
                                                </div>                                            
                                                <div class="col-lg-12" style="margin-bottom:15px;">
							<label><?=Language::show('Current Debian Version : ', 'keywords');?></label>
                                                    	<span ng-cloak id="currentLinuxDebAgentVersion">NA</span>
                                                    	</label>
                                                </div>
                                                <!--<div class="col-lg-12" style="margin-bottom:15px;">
                                                    <label><?=Language::show('Current RPM Version : ', 'keywords');?></label>
                                                    <span ng-cloak id="currentLinuxRpmAgentVersion">NA</span>
                                                    </label>
                                                </div>-->
                                                <div class="col-lg-12" id="chooserLinux" style="pointer-events : none;">
                                                    <label><?=Language::show('Upload Package  ', 'keywords');?></label></br>
                                                    <div class="col-lg-12" style="margin-bottom:15px;">
                                                        <input type="radio" name="optradioLinux" value="linkClickedLinux" checked>
                                                        <label for="linkLinux"><?=Language::show('Package URL', 'keywords');?></label>
                                                        <input type="text" class="form-control" name="linkLinux" id="linkLinux" placeholder="<?=Language::show('Package URL', 'keywords');?>" autocomplete="off">
                                                    </div>
                                                    </br>
                                                    <div class="col-lg-12">
                                                        <input type="radio" name="optradioLinux" value="fileClickedLinux">Select File : <input type="file" name="updateFileNameLinux" id="updateFileNameLinux" accept=".zip" style="pointer-events: none;">
                                                        <?php if(isMobile()){ ?>
                                                        <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <span id="fileUploadingProgressLinux"></span>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div id="progress-div-linux" style="display:none;">
                                                        <div id="progress-bar-linux"></div>
						    </div>
                                                    <div id="targetLayerLinux"></div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button type="submit" class="submit btn btn-primary float-right linuxSave" style="margin-right: 10px;"><?=Language::show('save', 'keywords');?></button>
                                                </div>
						</div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <!-- for linux end -->
		    </div>
<div role="tabpanel" class="tab-pane" id="rpm">
<!-- for linux rpm start-->
                        <div class="panel panel-default">
                            <div class="panel-heading"><h3>EPA for RPM Package</h3></div>
                                <div class="panel-body">
                                    <div>
                                        <div id="example2" class="col-lg-6">
                                            <form class="linuxrpmAgentForm" data-parsley-validate enctype="multipart/form-data">
                                                <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
                                                <div class="row">
                                                <div class="form-group col-lg-12">
                                                    <div class="checkbox check-primary">
                                                        <input id="downloadAgentLinuxrpm" name="downloadAgentLinuxrpm" type="checkbox" value="enabled" onclick="myFunctionLinuxrpm()">
                                                        <label for="downloadAgentLinuxrpm"><?=Language::show('Allow Agent Download', 'keywords');?></label>
                                                    </div>
                                                </div>
                                                <!--<div class="col-lg-12" style="margin-bottom:15px;">
                                                        <label><?=Language::show('Current Debian Version : ', 'keywords');?></label>
                                                        <span ng-cloak id="currentLinuxDebAgentVersion">NA</span>
                                                        </label>
                                                </div>-->
                                                <div class="col-lg-12" style="margin-bottom:15px;">
                                                    <label><?=Language::show('Current RPM Version : ', 'keywords');?></label>
                                                    <span ng-cloak id="currentLinuxRpmAgentVersion">NA</span>
                                                    </label>
                                                </div>
                                                <div class="col-lg-12" id="chooserLinuxrpm" style="pointer-events : none;">
                                                    <label><?=Language::show('Upload Package  ', 'keywords');?></label></br>
                                                    <div class="col-lg-12" style="margin-bottom:15px;">
                                                        <input type="radio" name="optradioLinuxrpm" value="linkClickedLinuxrpm" checked>
                                                        <label for="linkLinuxrpm"><?=Language::show('Package URL', 'keywords');?></label>
							<input type="text" class="form-control" name="linkLinuxrpm" id="linkLinuxrpm" placeholder="<?=Language::show('Package URL', 'keywords');?>" autocomplete="off">
                                                    </div>
                                                    </br>
                                                    <div class="col-lg-12">
                                                        <input type="radio" name="optradioLinuxrpm" value="fileClickedLinuxrpm">Select File : <input type="file" name="updateFileNameLinuxrpm" id="updateFileNameLinuxrpm" accept=".zip" style="pointer-events: none;">
                                                        <?php if(isMobile()){ ?>
                                                        <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <span id="fileUploadingProgressLinuxrpm"></span>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div id="progress-div-linuxrpm" style="display:none;">
                                                        <div id="progress-bar-linuxrpm"></div>
                                                    </div>
                                                    <div id="targetLayerLinuxrpm"></div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button type="submit" class="submit btn btn-primary float-right linuxrpmSave" style="margin-right: 10px;"><?=Language::show('save', 'keywords');?></button>
						</div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <!-- for linux rpm end -->
</div>
                    </div>
<!--sssss-->
</div>
                </div>
            </div>
        </div>	

        <div id="confirm" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOk()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancel()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="confirmFile" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkFile()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelFile()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="confirmMac" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkMac()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelMac()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="confirmFileMac" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkFileMac()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelFileMac()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>

	<div id="confirmLinux" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkLinux()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelLinux()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>

	<div id="confirmFileLinux" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkFileLinux()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelFileLinux()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
	</div>

	<div id="confirmLinuxrpm" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkLinuxrpm()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelLinuxrpm()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>

	<div id="confirmFileLinuxrpm" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">You are trying to upload the same agent as in the server.Do you want to proceed?</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div>
                            <span class="pull-right">
                            <a class="btn btn-success pull-right" ng-click="checkOkFileLinuxrpm()">Ok</a>
                            <a class="btn btn-danger pull-right"  ng-click="checkCancelFileLinuxrpm()" style="margin-right: 10px;">Cancel</a>
                            </span>
                            <br/><br/>
                            </div>
                    </div>
                </div>
            </div>
        </div>     


        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js" type="text/javascript"></script>
<style> 
#example1 {
  border: 1px solid;
  border-radius: 10px;
  padding: 10px;
  box-shadow: 5px 10px;
}

#example2 {
  border: 1px solid;
  border-radius: 10px;
  padding: 10px;
box-shadow: 5px 10px #888888;
}

#example3 {
  border: 1px solid;
  border-radius: 10px;
  padding: 10px;
  box-shadow: 5px 10px red;
}
</style>
<script>
$('input[type="radio"]').on('click change', function(e) {
	var radioValue = $("input[name='optradio']:checked").val();
	if(radioValue == 'fileClicked'){
		document.getElementById("link").style.pointerEvents = "none";
		document.getElementById("updateFileName").style.pointerEvents = "auto";
	}else{
		document.getElementById("updateFileName").style.pointerEvents = "none";
		document.getElementById("link").style.pointerEvents = "auto";
	}
});

$('input[type="radio"]').on('click change', function(e) {
        var radioValue = $("input[name='optradioServer']:checked").val();
        if(radioValue == 'fileClickedServer'){
                document.getElementById("linkServer").style.pointerEvents = "none";
                document.getElementById("updateFileNameServer").style.pointerEvents = "auto";
        }else{
                document.getElementById("updateFileNameServer").style.pointerEvents = "none";
                document.getElementById("linkServer").style.pointerEvents = "auto";
        }
});

$('input[type="radio"]').on('click change', function(e) {
	var radioValueMac = $("input[name='optradioMac']:checked").val();
	if(radioValueMac == 'fileClickedMac'){
		document.getElementById("linkMac").style.pointerEvents = "none";
		document.getElementById("updateFileNameMac").style.pointerEvents = "auto";
	}else{
		document.getElementById("updateFileNameMac").style.pointerEvents = "none";
		document.getElementById("linkMac").style.pointerEvents = "auto";
	}
});

function myFunction(){
	var downloadAgent = document.querySelector('#downloadAgent');
	var autoUpdate = document.querySelector('#autoUpdate');
	if(downloadAgent.checked == false && autoUpdate.checked == false){
		document.getElementById("chooser").style.pointerEvents = "none";
		//document.getElementById("updateFileName").style.pointerEvents = "none";
		//document.getElementById("link").style.pointerEvents = "none";
	}else{
		document.getElementById("chooser").style.pointerEvents = "auto";
		//document.getElementById("updateFileName").style.pointerEvents = "auto";
		//document.getElementById("link").style.pointerEvents = "auto";
	}
}

function myFunctionServer(){
        var downloadAgent = document.querySelector('#downloadAgentServer');
        var autoUpdate = document.querySelector('#autoUpdateServer');
        if(downloadAgent.checked == false){
                document.getElementById("chooserServer").style.pointerEvents = "none";
                //document.getElementById("updateFileName").style.pointerEvents = "none";
                //document.getElementById("link").style.pointerEvents = "none";
        }else{
                document.getElementById("chooserServer").style.pointerEvents = "auto";
                //document.getElementById("updateFileName").style.pointerEvents = "auto";
                //document.getElementById("link").style.pointerEvents = "auto";
        }
}

function myFunctionMac(){
	var downloadAgentMac = document.querySelector('#downloadAgentMac');
	if(downloadAgentMac.checked == false){
		document.getElementById("chooserMac").style.pointerEvents = "none";
		//document.getElementById("updateFileNameMac").style.pointerEvents = "none";
		//document.getElementById("linkMac").style.pointerEvents = "none";
	}else{
		document.getElementById("chooserMac").style.pointerEvents = "auto";
		//document.getElementById("updateFileNameMac").style.pointerEvents = "auto";
		//document.getElementById("linkMac").style.pointerEvents = "auto";
	}
}
	
$('input[type="radio"]').on('click change', function(e) {
        var radioValueLinux = $("input[name='optradioLinux']:checked").val();
        if(radioValueLinux == 'fileClickedLinux'){
                document.getElementById("linkLinux").style.pointerEvents = "none";
                document.getElementById("updateFileNameLinux").style.pointerEvents = "auto";
        }else{
                document.getElementById("updateFileNameLinux").style.pointerEvents = "none";
                document.getElementById("linkLinux").style.pointerEvents = "auto";
        }
});

function myFunctionLinux(){
        var downloadAgentLinux = document.querySelector('#downloadAgentLinux');
        if(downloadAgentLinux.checked == false){
                document.getElementById("chooserLinux").style.pointerEvents = "none";
        }else{
                document.getElementById("chooserLinux").style.pointerEvents = "auto";
        }
}
	
$('input[type="radio"]').on('click change', function(e) {
        var radioValueLinuxrpm = $("input[name='optradioLinuxrpm']:checked").val();
        if(radioValueLinuxrpm == 'fileClickedLinuxrpm'){
                document.getElementById("linkLinuxrpm").style.pointerEvents = "none";
                document.getElementById("updateFileNameLinuxrpm").style.pointerEvents = "auto";
        }else{
                document.getElementById("updateFileNameLinuxrpm").style.pointerEvents = "none";
                document.getElementById("linkLinuxrpm").style.pointerEvents = "auto";
        }
});

function myFunctionLinuxrpm(){
        var downloadAgentLinuxrpm = document.querySelector('#downloadAgentLinuxrpm');
        if(downloadAgentLinuxrpm.checked == false){
                document.getElementById("chooserLinuxrpm").style.pointerEvents = "none";
        }else{
                document.getElementById("chooserLinuxrpm").style.pointerEvents = "auto";
        }
}	
</script>
<style>
#progress-bar-win {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-win {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerWin{width:100%;text-align:center;}

#progress-bar-winServer {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-winServer {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerWinServer{width:100%;text-align:center;}

#progress-bar-mac {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-mac {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerMac{width:100%;text-align:center;}
	
#progress-bar-linux {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-linux {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerlinux{width:100%;text-align:center;}
	
#progress-bar-linuxrpm {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-linuxrpm {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerlinuxrpm{width:100%;text-align:center;}	
</style>
