<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4
* @date 18/09/18
* @time 12:43 PM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
	    <span class="currentPage hide"><?='aadCredentials'?></span>
	    <?php if(isset($_SESSION['storageResult']) && $_SESSION['storageResult'] == 'error'){ ?>
             <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php }elseif(isset($_SESSION['storageResult']) && $_SESSION['storageResult'] == 'success'){ ?>
             <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php } ?>
            <?php $_SESSION['storageResult'] = ''; ?>
	    <?php $_SESSION['storageMessage'] = ''; ?>
	    <span class="defaultBkpPolicyNameOriginal hide"><?=$data['defaultBkpPolicyName']?></span>
	    <span class="defaultSyncPolicyNameOriginal hide"><?=$data['defaultSyncPolicyName']?></span>
	    <span class="defaultExchangePolicyNameOriginal hide"><?=$data['defaultExchangePolicyName']?></span>
	    <span class="defaultOdbPolicyNameOriginal hide"><?=$data['defaultOdbPolicyName']?></span>
	    <span class="defaultSharepointPolicyNameOriginal hide"><?=$data['defaultSharepointPolicyName']?></span>
<!--unsaved edit warning starts-->
<div id="unsavedWarning" class="modal fade" role="dialog" style="z-index: 9999999;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Warning</h4>
            </div>
            <div class="modal-body">
                <div>
                    <div>
                        <p>There are some unsaved changes. Please confirm to proceed as the changes will be lost without saving them.</p>
                    </div>
                    <span class="pull-right">
			<a class="btn btn-primary" ng-click="confirmProceed()">Ok</a>
			<a class="btn btn-default" ng-click="confirmCancel()">Cancel</a>
                    </span>
                    <br/><br/>
                </div>
            </div>
        </div>
    </div>
</div>
<!--unsaved edit warning ends-->
<!--unsaved add warning starts-->
<div id="unsavedWarningAdd" class="modal fade" role="dialog" style="z-index: 9999999;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Warning</h4>
            </div>
            <div class="modal-body">
                <div>
                    <div>
                        <p>There are some unsaved changes. Please confirm to proceed as the changes will be lost without saving them.</p>
                    </div>
                    <span class="pull-right">
                        <a class="btn btn-primary" ng-click="confirmProceedAdd()">Ok</a>
                        <a class="btn btn-default" ng-click="confirmCancelAdd()">Cancel</a>
                    </span>
                    <br/><br/>
                </div>
            </div>
        </div>
    </div>
</div>
<!--unsaved add warning ends-->
            <div class="row">
                <div class="panel noAadCredentialsPanel col-lg-12">
                    <div class="panel-heading">
                        <h4><span class="pull-right"><button id="addAAD"style="margin-top: 5px;" class="btn btn-success btn-small" data-toggle="modal" data-target="#addAad">Add Credentials</button></span></h4>
                    </div>
                    <div>
                        <h2 align="center">There are no AAD Credentials Saved</h2>
                    </div>
		</div>
                <div class="panel aadCredentialsPanel col-lg-12">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 0px;"><?=Language::show('azureActiveDirectoryCredentials', 'keywords')?><span class="pull-right"><a id="editAAD" style="margin-top: 5px;" class="btn btn-success btn-small" ng-click="editAadCredentials()">Edit Credentials</a></span></h4>
		    </div>
		    <?php if($data['multiTenantAADEnabled'] == 'false'){ ?>
                    <div class="panel-body">
			<form class="aadConfiguration" ng-submit="saveAadConfiguration()" data-parsley-validate>
<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                            <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#addAadSettingsTabView" aria-controls="addAadSettingsTabView" role="tab" data-toggle="tab">Settings</a></li>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#addAadGroupTabView" aria-controls="addAadGroupTabView" role="tab" data-toggle="tab">Group to policy mapping</a></li>
                    </ul>
            <?php } ?>
<div class="tab-content">
<div role="tabpanel" class="tab-pane active" id="addAadSettingsTabView">
<br>
<div class="row">
				<?php if($data['graphAADEnabled'] == 'false'){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientIdForLogin" id="clientIdForLogin" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off" readonly>
                                </div>
				<?php } ?>
                                <div class="form-group col-lg-6">
                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter your client Id" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                    <input type="text" class="form-control" name="secretKey" id="secretKey" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 tenentId">
                                        <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                        <input type="text" class="form-control" name="tenentId" id="tenentId" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 redirectURI">
                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 portalRedirectURI">
                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                    <input type="text" class="form-control" name="loginMode" id="loginMode" value="" placeholder="Enter Login Mode" autocomplete="off" readonly>
				</div>
</div>
</div>
<div role="tabpanel" class="tab-pane" id="addAadGroupTabView">
<br>
<div class="row col-lg-12">
<legend class="h4" style="color: #585f69;"><?=Language::show('Default Policies', 'keywords')?></legend>
<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultBkpPolicyNameView">Default Backup Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultBkpPolicyNameView" id="defaultBkpPolicyNameView" placeholder="" disabled>
                                                         <?php if(!empty($data['policies1'])){ ?>
                                                            <?php foreach($data['policies1'] as $key => $value){
                                                            $label = $value;
                                                            if( strlen( $label ) > 25 ) {
                                                               $label = substr( $label, 0, 25 ) . '...';
                                                            }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultSyncPolicyNameView">Default Sync Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultSyncPolicyNameView" id="defaultSyncPolicyNameView" placeholder="" disabled>
                                                         <?php if(!empty($data['syncPolicies1'])){ ?>
                                                            <?php foreach($data['syncPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="exchangePolicyNameView"><?=Language::show('Default Policy name for Microsoft Exchange users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultExchangePolicyNameView" id="defaultExchangePolicyNameView" disabled>
                                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="odbPolicyNameView"><?=Language::show('Default Policy name for OneDrive for Business users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultOdbPolicyName" id="defaultOdbPolicyNameView" disabled>
                                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="sharepointPolicyNameView"><?=Language::show('Default Policy name for Sharepoint sites', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultSharepointPolicyNameView" id="defaultSharepointPolicyNameView" disabled>
                                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultSharepointPolicyName'] == $value){echo 'selected';}?>><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>                                            
</div>
<div class="row">
                                <div class="col-lg-12 groupConfigurationsPanel">
				    <div class="col-lg-6">
					<div class="row">
                				<div class="col-lg-2">
                    					<label class="switch">
                        					<input id="switchGroupRead" type="checkbox" name="switchGroupRead" value="true">
                        					<div class="slider round"></div>
                    					</label>
                				</div>
			                	<span>Many to Many mapping</span>
            			    	</div>
				    </div>
                                    <table id="myTableShow" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
					    <col class="col-lg-4">
					    <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
						<th>Product Type</th>
						<th>Policy Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="(key,value) in aad">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-if="key == '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-cloak style="white-space:unset !important;">
                                                    <select class="form-control" name="aadPtType[]" id="aadPtType{{$index}}" disabled>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                            <option value="BACKUP" ng-selected="value == 'BACKUP'">BluVault</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                            <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('exchange')){ ?>
							    <option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
							<?php } ?>
							<?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        	<option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>
                                                        <?php } ?>                                                        
                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>                       
                                                    </select>
						</td>
						<td>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>

                                <select ng-show="value == 'BACKUP'" class="form-control selectPolicyPicker" name="policyViewRO[]" title='Select a Policy for Backup' disabled>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>

                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                <select ng-show="value == 'MAIL'" class="form-control selectExchangePolicyPicker" name="policyViewERO[]" title='Select a Microsoft Exchange Policy' disabled>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                <select ng-show="value == 'SP'" class="form-control selectSharepointPolicyPicker" name="policyViewSHRO[]" title='Select a Sharepoint Policy' disabled>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultSharepointPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                <select ng-show="value == 'ODB'" class="form-control selectOnedrivePolicyPicker" name="policyViewORO[]" title='Select a OneDrive for Business Policy' disabled>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                <select ng-show="value == 'SYNC'" class="form-control selectSyncPolicyPicker" name="policyViewSRO[]" title='Select a Policy for BluSync' disabled>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            <?php } ?>
                                                            </td>
                                            </tr>
                                        </tbody>					    
				    </table>
<!--new table start-->
				    <table id="myTableShowNew" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
						<th>Product Type</th>
                                                <th>Policy Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="ele in aadCredPrdouctPolicyList">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="{{ele.groupName}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-cloak style="white-space:unset !important;">
                                                    <select class="form-control" name="aadPtType[]" id="aadPtType{{$index}}" disabled>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                            <option value="BACKUP" ng-selected="ele.productType == 'BACKUP'">BluVault</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                            <option value="SYNC" ng-selected="ele.productType == 'SYNC'">BluSync</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('exchange')){ ?>
                                                            <option value="MAIL" ng-selected="ele.productType == 'MAIL'">Microsoft Exchange</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                <option value="ODB" ng-selected="ele.productType == 'ODB'">OneDrive for Business</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                                <option value="SP" ng-selected="ele.productType == 'SP'">SharePoint Online</option>
                                                        <?php } ?>                                                      
                                                    </select>
						</td>
						<td ng-cloak style="white-space:unset !important;">
						    <select class="form-control" name="aadPol[]" id="aadPol{{$index}}" disabled>
							<?php if(!empty($data['policies1'])){ ?>
                                        			<?php foreach($data['policies1'] as $key => $value){
                                        				$label = $value;
                                            				if( strlen( $label ) > 25 ) {
                                               					$label = substr( $label, 0, 25 ) . '...';
                                            				}?>
                                            				<option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$label?></option>
                                        			<?php } ?>
							<?php } ?>
							<?php if(!empty($data['exchangePolicies1'])){ ?>
                                            			<?php foreach($data['exchangePolicies1'] as $key => $value){
                                            				$label = $value;
                                            				if( strlen( $label ) > 25 ) {
                                               					$label = substr( $label, 0, 25 ) . '...';
                                            				}?>
                                            				<option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
                                            			<?php } ?>
							<?php } ?>
							<?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            			<?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            				$label = $value;
                                            				if( strlen( $label ) > 25 ) {
                                               					$label = substr( $label, 0, 25 ) . '...';
                                            				}?>
                                            				<option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
                                            			<?php } ?>
							<?php } ?>
							<?php if(!empty($data['odbPolicies1'])){ ?>
                                            			<?php foreach($data['odbPolicies1'] as $key => $value){
                                            				$label = $value;
                                            				if( strlen( $label ) > 25 ) {
                                               					$label = substr( $label, 0, 25 ) . '...';
                                            				}?>
                                            				<option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
                                            			<?php } ?>
							<?php } ?>
							<?php if(!empty($data['syncPolicies1'])){ ?>
                                        			<?php foreach($data['syncPolicies1'] as $key => $value){
                                        				$label = $value;
                                            				if( strlen( $label ) > 25 ) {
                                               					$label = substr( $label, 0, 25 ) . '...';
                                            				}?>
                                            				<option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
                                        			<?php } ?>
                                    			<?php } ?>
						    </select>						    
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
<!--new table end-->
				    <?php if($data['groupCount'] > 0){?><span class="pull-right"><a class="btn btn-primary btn-small" href="" ng-click="syncNow()">Sync Now</a></span><?php } ?>
                                </div>                                
                                <!--<button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right aadSave">Save</button>-->
                                <!--<div>
                                    <a href="javascript:;" class="btn btn-default" ng-click="gotTo('/settings/importUsersAAD')"><i class="fa fa-user-plus"> Import Users from AAD</i></a>
				</div>-->
</div>
</div>
                        </form>
                    </div>
		</div>
</div>
<?php } ?>
<?php if($data['multiTenantAADEnabled'] == 'true'){ ?>
		<div class="panel-body">
			<form class="aadConfiguration" ng-submit="saveAadConfiguration()" data-parsley-validate>
<div class="row">
                                <div class="form-group col-lg-6">
                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter your client Id" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                    <input type="text" class="form-control" name="secretKey" id="secretKey" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off" readonly>
                                </div>                                
                                <div class="form-group col-lg-6">
                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 redirectURI">
                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 portalRedirectURI">
                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                    <input type="text" class="form-control" name="loginMode" id="loginMode" value="" placeholder="Enter Login Mode" autocomplete="off" readonly>
                                </div>
<!--tenants start-->
<div class="col-lg-6">
                                    <label for="tenants"><?=Language::show('Tenant Configuration', 'keywords')?></label></br>
                                    <table id="myTableShowTenants" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Tenant Id</th>
                                                <th>Admin Consent</th>
                                            </tr>
                                        </thead>
					<tbody>
                                            <tr ng-if="tenants.length <= 0">
                                            	<td>Not configured</td><td>NA</td>
                                            </tr>
                                            <tr ng-repeat="value in tenants" ng-if="tenants.length > 0">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="tenants" id="tenants{{$index}}" value="{{value}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>                                                
						<td ng-cloak style="white-space:unset !important;">
						<?php
							$tenentId = '';
							$clientId = $data['data']->{'clientId'};
							$user_principal = $data['data']->{'user_principal'};
							//$redirectURI = $data["clientRedirectURI"];
							if(useLocalPackage != true){
								$redirectURI = "https://api-app.parablu.com/adminConsentMultiTenant.php";
								$appURL = "https://api-app.parablu.com/callConsent.php";
							}else{
								$redirectURI = LOCAL_IP."/app/adminConsentMultiTenant.php";
								$appURL = LOCAL_IP."/app/callConsent.php";
							}
							$params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
							//$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
							$ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
							$aa = $appURL.$params."&tenentId=";
							$bb = "&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
							?>
						<!--<a href="javascript:;" class="btn btn-default" ng-click="redirectTo(<?=$appURL.$params?>'&tenantId={{value}}&scope='<?=AZURE_SCOPE?>'&sourceURI='<?=\Helpers\Url::basePath();?>)"><i class="fa fa-windows"></i> Grant Admin Consent</a>-->
						<a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$aa?>{{value}}<?=$bb?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
<!--tenants ends-->                                                                
                                <div class="col-lg-6 groupConfigurationsPanel">
                                    <label for="groupConfigurations"><?=Language::show('groupConfigurations', 'keywords')?></label></br>
                                    <table id="myTableShow" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
                                                <th>Product Type</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="(key,value) in aad">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-if="key == '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-cloak style="white-space:unset !important;">
                                                    <select class="form-control" name="aadPtType[]" id="aadPtType{{$index}}" disabled>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                            <option value="BACKUP" ng-selected="value == 'BACKUP'">BluVault</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                            <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('exchange')){ ?>
								<option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
							<?php } ?>
							<?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                        <?php } ?>
                                                        <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        	<option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>
                                                        <?php } ?>                                                       
                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>                       
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
				    <?php if($data['groupCount'] > 0){?><span class="pull-right"><a class="btn btn-primary btn-small" href="" ng-click="syncNow()">Sync Now</a></span><?php } ?>
                                </div>                                
                                <!--<button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right aadSave">Save</button>-->
                                <!--<div>
                                    <a href="javascript:;" class="btn btn-default" ng-click="gotTo('/settings/importUsersAAD')"><i class="fa fa-user-plus"> Import Users from AAD</i></a>
				</div>-->
</div>
                        </form>
                    </div>
                </div>
<?php } ?>
                <!--start add-->
                <div class="modal fade" id="addAad" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <?= Form::open(array(
                                        'ng-submit' => 'saveAadConfiguration()',
                                        'class' => 'aadAadCredentials',
                                        'id' => 'aadAadCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
					<div class="modal-header">
                                            <h4 class="modal-title"><?=Language::show('addYourAzureActiveDirectoryCredentials', 'keywords')?></h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        </div>
					<div class="modal-body">
<?php if($data['multiTenantAADEnabled'] == 'false'){ ?>
<!--					    <div class="row">-->
<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                            <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#addAadSettingsTab" aria-controls="addAadSettingsTab" role="tab" data-toggle="tab">Settings</a></li>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#addAadGroupTab" aria-controls="addAadGroupTab" role="tab" data-toggle="tab">Group to policy mapping</a></li>
                    </ul>
	    <?php } ?>
<br>
<div class="tab-content">
<div role="tabpanel" class="tab-pane active" id="addAadSettingsTab">
<div class="row">
						<?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdForLoginadd" id="clientIdForLogin2" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off">
                                                </div>
						<?php } ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdadd" id="clientId2" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKeyadd" id="secretKey2" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 tenentId">
                                                    <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="tenentIdadd" id="tenentId2" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURIadd" id="endpointRedirectURI2" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURIadd" id="redirectURI2" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURIaad" id="portalRedirectURI2" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode2" id="loginMode2" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
							 <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <option value="OneLogin"><?=Language::show('OneLogin', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
					    </div>
</div>
                                            <!--<div class="row groupConfigurationsPanelAdd">
                                                <div class="panel-heading col-lg-12">
						<h4><?=Language::show('groupConfigurations', 'keywords')?>
						<div class="col-lg-12 row" style="margin-top: 10px;">
						    <div class="col-lg-6 row">
						    	<div class="col-lg-2">
		    					    <label class="switch">
                        				    	<input id="switchGroupView" type="checkbox" name="switchGroupView" value="true">
				                            	<div class="slider round"></div>
                    					    </label>
                 					</div>
                					<span style="margin-left: 5%;">Many to many mapping</span>
            					    </div>
						</div>
						<span class="pull-right oldaddBtn"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>
						<span class="pull-right newaddBtn" style="display:none;"><a onclick="addDynamicAddNew()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>
						</h4>
					    </div>-->
<!--old panel start-->
<!--<div class="panel-body col-lg-12 oldpanel">
                                                <table id="myTableAddOld" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameadd[]" id="aadGroupNamee1" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductTypeadd[]" id="aadProductTypee1" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
									<option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
								    <?php } ?>
								    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                        	    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        		<option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>
                                                        	    <?php } ?>                                   
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAdd(this)" id="removeAdd{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>-->
<!--old panel end-->
<!--new panel start-->
<!--                                                <div class="panel-body col-lg-12 newpanel" style="display:none;">
                                                <table id="myTableAddNew" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-3">
                                                        <col class="col-lg-3">
							<col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
							    <th>Product Type</th>
							    <th>Policy Name</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameaddNew[]" id="aadGroupNameeNew0" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off" required>
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control product" name="aadProductTypeaddNew[]" id="aadProductTypeeNew0" required onchange="showPolicy(this)">
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php //if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php //} ?>
                                                                    <?php //if(Auth::checkCloudPermission('exchange')){ ?>
									<option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
                                                        	    <?php //} ?>
                                                        	    <?php //if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        		<option value="SP" ng-selected="value == 'SP'">SharePoint</option>
                                                        	    <?php //} ?>
                                                        	    <?php //if(Auth::checkCloudPermission('onedrive')){ ?>
                                                        		<option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                        	    <?php //} ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
							    </td>
							    <td>
								    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <div class="form-group addpolicyDiv0">
                                <select class="form-control selectPolicyPicker pol" name="addpolicy[]" id="addpolicy0" title='Select a Policy for Backup'>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            
<?php //if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                            <div class="form-group addexchangePolicyDiv0" style="display:none">
                                <select class="form-control selectExchangePolicyPicker epol" name="addpolicyE[]" id="addexchangePolicy0" title='Select a Microsoft Exchange Policy'>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php //} ?>
                            
<?php //if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                            <div class="form-group addsharepointPolicyDiv0" style="display:none">
                                <select class="form-control selectSharepointPolicyPicker sppol" name="addpolicySH[]" id="addsharepointPolicy0" title='Select a Sharepoint Policy'>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php //} ?>
                            
<?php //if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                            <div class="form-group addonedrivePolicyDiv0" style="display:none">
                                <select class="form-control selectOnedrivePolicyPicker opol" name="addpolicyO[]" id="addonedrivePolicy0" title='Select a OneDrive for Business Policy'>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php //} ?>
                            
                            <?php //if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                            <div class="form-group addsyncPolicyDiv0" style="display:none">
                                <select class="form-control selectSyncPolicyPicker spol" name="addpolicyS[]" id="addsyncPolicy0" title='Select a Policy for BluSync'>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php //} ?>                                                                                    
							    </td>
                                                            <td>
                                                                <a onclick="RemoveAddNew(this)" id="removeAddNew{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
					    </div>-->
<!--new panel end-->
<!--</div>-->
<div role="tabpanel" class="tab-pane" id="addAadGroupTab">
<div class="row col-lg-12" id="defaultPoliciesAddPanel">
<legend class="h4" style="color: #585f69;">Default Policies</legend>
<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultBkpPolicyNameAdd">Default Backup Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultBkpPolicyNameAdd" id="defaultBkpPolicyNameAdd" placeholder="" onchange="changeDefaultPolicyAdd(this)">
                                                         <?php if(!empty($data['policies1'])){ ?>
                                                            <?php foreach($data['policies1'] as $key => $value){
                                                            $label = $value;
                                                            if( strlen( $label ) > 25 ) {
                                                               $label = substr( $label, 0, 25 ) . '...';
                                                            }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultSyncPolicyNameAdd">Default Sync Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultSyncPolicyNameAdd" id="defaultSyncPolicyNameAdd" placeholder="" onchange="changeDefaultPolicyAdd(this)">
                                                         <?php if(!empty($data['syncPolicies1'])){ ?>
                                                            <?php foreach($data['syncPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultExchangePolicyNameAdd"><?=Language::show('Default Policy name for Microsoft Exchange users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultExchangePolicyNameAdd" id="defaultExchangePolicyNameAdd" onchange="changeDefaultPolicyAdd(this)">
                                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="odbPolicyNameAdd"><?=Language::show('Default Policy name for OneDrive for Business users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultOdbPolicyNameAdd" id="defaultOdbPolicyNameAdd" onchange="changeDefaultPolicyAdd(this)">
                                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="sharepointPolicyNameAdd"><?=Language::show('Default Policy name for Sharepoint sites', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultSharepointPolicyNameAdd" id="defaultSharepointPolicyNameAdd" onchange="changeDefaultPolicyAdd(this)">
                                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultSharepointPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
</div>
<div class="row groupConfigurationsPanelAdd">
                                            <div class="panel-heading col-lg-12">
                                                <div class="col-lg-12 row" style="margin-top: 10px;">
                                                    <div class="col-lg-6 row">
                                                        <div class="col-lg-2">
                                                            <label class="switch">
                                                                <input id="switchGroupView" type="checkbox" name="switchGroupView" value="true">
                                                                <div class="slider round"></div>
                                                            </label>
                                                        </div>
                                                        <span style="margin-left: 5%;">Many to Many mapping</span>
                                                    </div>
                                                </div>
                                                <span class="pull-right oldaddBtn"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>
                                                <span class="pull-right newaddBtn" style="display:none;"><a onclick="addDynamicAddNew()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>                                               
                                            </div>
<!--old panel start-->
<div class="panel-body col-lg-12 oldpanel">
                                                <table id="myTableAddOld" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-3">
							<col class="col-lg-3">
							<col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
							    <th>Product Type</th>
							    <th>Policy Name</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameadd[]" id="aadGroupNamee1" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductTypeadd[]" id="aadProductTypee1" required onchange="changeProAddOld(this)">
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
                                                                        <option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                                        <option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>
                                                                    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
							    </td>
							    <td>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>

                                <select class="form-control selectPolicyPicker policyViewAdd" name="policyView[]" title='Select a Policy for Backup' disabled>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>

                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                <select class="form-control selectExchangePolicyPicker policyViewEAdd" name="policyViewE[]" title='Select a Microsoft Exchange Policy' style="display:none;" disabled>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                <select class="form-control selectSharepointPolicyPicker policyViewSHAdd" name="policyViewSH[]" title='Select a Sharepoint Policy' style="display:none;" disabled>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultSharepointPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                <select class="form-control selectOnedrivePolicyPicker policyViewOAdd" name="policyViewO[]" title='Select a OneDrive for Business Policy' style="display:none;" disabled>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                <select class="form-control selectSyncPolicyPicker policyViewSAdd" name="policyViewS[]" title='Select a Policy for BluSync' style="display:none;" disabled>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            <?php } ?>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAdd(this)" id="removeAdd{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
<!--old panel end-->
<!--new panel start-->
                                                <div class="panel-body col-lg-12 newpanel" style="display:none;">
                                                <table id="myTableAddNew" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-3">
                                                        <col class="col-lg-3">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                       	    <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Policy Name</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameaddNew[]" id="aadGroupNameeNew0" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control product" name="aadProductTypeaddNew[]" id="aadProductTypeeNew0" required onchange="showPolicy(this)">
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
                                                                        <option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                                        <option value="SP" ng-selected="value == 'SP'">SharePoint</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <div class="form-group addpolicyDiv0">
                                <select class="form-control selectPolicyPicker pol" name="addpolicy[]" id="addpolicy0" title='Select a Policy for Backup'>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            
                            <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                            <div class="form-group addexchangePolicyDiv0" style="display:none">
                                <select class="form-control selectExchangePolicyPicker epol" name="addpolicyE[]" id="addexchangePolicy0" title='Select a Microsoft Exchange Policy'>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            
                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                            <div class="form-group addsharepointPolicyDiv0" style="display:none">
                                <select class="form-control selectSharepointPolicyPicker sppol" name="addpolicySH[]" id="addsharepointPolicy0" title='Select a Sharepoint Policy'>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            
                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                            <div class="form-group addonedrivePolicyDiv0" style="display:none">
                                <select class="form-control selectOnedrivePolicyPicker opol" name="addpolicyO[]" id="addonedrivePolicy0" title='Select a OneDrive for Business Policy'>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            
                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                            <div class="form-group addsyncPolicyDiv0" style="display:none">
                                <select class="form-control selectSyncPolicyPicker spol" name="addpolicyS[]" id="addsyncPolicy0" title='Select a Policy for BluSync'>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAddNew(this)" id="removeAddNew{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
<!--new panel end-->                            
</div>
</div>
</div>
					    <!--</div>-->
<?php } ?>
<?php if($data['multiTenantAADEnabled'] == 'true'){ ?>
<div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdadd" id="clientId2" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKeyadd" id="secretKey2" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURIadd" id="endpointRedirectURI2" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURIadd" id="redirectURI2" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURIaad" id="portalRedirectURI2" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode2" id="loginMode2" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
							 <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <option value="OneLogin"><?=Language::show('OneLogin', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
                                            </div>
					    <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('Tenant Configuration', 'keywords')?><span class="pull-right"><a onclick="addDynamicAddTenant()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Tenant Id</a></span></h4>
                                            </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableAddTenant" class="myTableAddTenant table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Tenant Id</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadTenant[]" id="aadTenant" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                            </td>                                                            
                                                            <td>
                                                                <a onclick="RemoveAddTenant(this)" id="tenantAddRemove{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
					    </div>
					    <div class="row groupConfigurationsPanelAdd">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableAdd" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameadd[]" id="aadGroupNamee1" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductTypeadd[]" id="aadProductTypee1" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
									<option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
								    <?php } ?>
								    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                        	    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        		<option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>                                                        	    	  <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAdd(this)" id="removeAdd{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            </div>
<?php } ?>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success addCredentialsBtn"><?=Language::show('Save', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>

                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end add -->
                <!--start-->
                <div class="modal fade" id="editAad" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <?= Form::open(array(
                                        'ng-submit' => 'saveAadConfiguration1()',
                                        'class' => 'editAadCredentials',
                                        'id' => 'editAadCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
					<div class="modal-header">
<h4 class="modal-title"><?=Language::show('editYourAzureActiveDirectoryCredentials', 'keywords')?></h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        </div>
					<div class="modal-body">
<?php if($data['multiTenantAADEnabled'] == 'false'){ ?>
<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                            <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#addAadSettingsTabEdit" aria-controls="addAadSettingsTabEdit" role="tab" data-toggle="tab">Settings</a></li>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#addAadGroupTabEdit" aria-controls="addAadGroupTabEdit" role="tab" data-toggle="tab">Group to policy mapping</a></li>
                    </ul>
            <?php } ?>
<div class="tab-content">
<div role="tabpanel" class="tab-pane active" id="addAadSettingsTabEdit">
<br>
                                            <div class="row">
						<?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdForLogin" id="clientIdForLogin1" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off">
                                                </div>
						<?php } ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientId" id="clientId1" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKey" id="secretKey1" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 tenentId">
                                                    <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="tenentId" id="tenentId1" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI1" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI1" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI1" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div> 
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode1" id="loginMode1" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
							 <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <option value="OneLogin"><?=Language::show('OneLogin', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
					    </div>
</div>
<div role="tabpanel" class="tab-pane" id="addAadGroupTabEdit">
<br>
<div class="row col-lg-12" id="defaultPoliciesEditPanel">
<legend class="h4" style="color: #585f69;"><?=Language::show('Default Policies', 'keywords')?></legend>
<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultBkpPolicyNameEdit">Default Backup Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultBkpPolicyNameEdit" id="defaultBkpPolicyNameEdit" placeholder="" onchange="changeDefaultPolicyEdit(this)">
                                                         <?php if(!empty($data['policies1'])){ ?>
                                                            <?php foreach($data['policies1'] as $key => $value){
                                                            $label = $value;
                                                            if( strlen( $label ) > 25 ) {
                                                               $label = substr( $label, 0, 25 ) . '...';
                                                            }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultSyncPolicyNameEdit">Default Sync Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultSyncPolicyNameEdit" id="defaultSyncPolicyNameEdit" placeholder="" onchange="changeDefaultPolicyEdit(this)">
                                                         <?php if(!empty($data['syncPolicies1'])){ ?>
                                                            <?php foreach($data['syncPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultExchangePolicyNameEdit"><?=Language::show('Default Policy name for Microsoft Exchange users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultExchangePolicyNameEdit" id="defaultExchangePolicyNameEdit" onchange="changeDefaultPolicyEdit(this)">
                                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="odbPolicyNameEdit"><?=Language::show('Default Policy name for OneDrive for Business users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultOdbPolicyNameEdit" id="defaultOdbPolicyNameEdit" onchange="changeDefaultPolicyEdit(this)">
                                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="sharepointPolicyNameEdit"><?=Language::show('Default Policy name for Sharepoint sites', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultSharepointPolicyNameEdit" id="defaultSharepointPolicyNameEdit" onchange="changeDefaultPolicyEdit(this)">
                                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultSharepointPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
</div>
                                            <div class="row groupConfigurationsPanelEdit">
                                                <div class="panel-heading col-lg-12">
						<div class="col-lg-12 row">
                                                    <div class="col-lg-6 row">
                                                        <div class="col-lg-2">
                                                            <label class="switch">
                                                                <input id="switchGroupViewEdit" type="checkbox" name="switchGroupViewEdit" value="true">
                                                                <div class="slider round"></div>
                                                            </label>
                                                        </div>
                                                        <span style="margin-left: 5%;">Many to Many mapping</span>
                                                    </div>
                                                </div>
                                                <span class="pull-right oldaddEditBtn"><a onclick="dynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>
                                                <span class="pull-right newaddEditBtn" style="display:none;"><a onclick="dynamicAddNew()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>
<!--						<span class="pull-right"><a onclick="dynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span>-->
					    </h4>
                                            </div>
                                                <div class="panel-body col-lg-12 oldpanelEdit">
                                                <table id="myTable" class="myTable table table-bordered">
                                                    <colgroup>
							<col class="col-lg-3">
							<col class="col-lg-3">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
							    <th>Product Type</th>
							    <th>Policy Name</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="(key,value) in aad" class="first">
                                                            <td ng-if="key != '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-if="key == '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductType[]" id="aadProductType{{$index}}" required onchange="changeProEditOld(this)">
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP" ng-selected="value == 'BACKUP'">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
									<option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
								    <?php } ?>
								    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                        	    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        		<option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>
                                                        	    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>
                                                                    <?php } ?>
                                                                </select>
							    </td>
							     <td>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            
                                <select ng-class="{ 'showSelect': value == 'BACKUP' }" class="form-control selectPolicyPicker policyView" name="policyView[]" id="policyView{{$index}}" title='Select a Policy for Backup' disabled style="display:none;">
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>                            
                                <select ng-class="{ 'showSelect': value == 'MAIL' }" class="form-control selectExchangePolicyPicker policyViewE" name="policyViewE[]" id="policyViewE{{$index}}" title='Select a Microsoft Exchange Policy' disabled style="display:none;">
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>                            
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>                            
                                <select ng-class="{ 'showSelect': value == 'SP' }" class="form-control selectSharepointPolicyPicker policyViewSH" name="policyViewSH[]" id="policyViewSH{{$index}}" title='Select a Sharepoint Policy' disabled style="display:none;">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultSharepointPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>                            
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>                            
                                <select ng-class="{ 'showSelect': value == 'ODB' }" class="form-control selectOnedrivePolicyPicker policyViewO" name="policyViewO[]" id="policyViewO{{$index}}" title='Select a OneDrive for Business Policy' disabled style="display:none;">
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>                            
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>                            
                                <select ng-class="{ 'showSelect': value == 'SYNC' }" class="form-control selectSyncPolicyPicker policyViewS" name="policyViewS[]" id="policyViewS{{$index}}" title='Select a Policy for BluSync' disabled style="display:none;">
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>                            
                            <?php } ?>
                                                            </td>
                                                            <td>
                                                                <a onclick="Remove(this)" id="remove{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
					    </div>
<!--new panel edit start-->
					    <div class="panel-body col-lg-12 newpanelEdit" style="display:none;">
                                                <table id="myTableNew" class="myTableNew table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-3">
                                                        <col class="col-lg-3">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Policy Name</th>
                                                            <th>Action</th>
                                                        </tr>
						    </thead>
						    <tbody ng-if="aadCredPrdouctPolicyList.length <= 0">
                                                        <tr class="first">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameNew[]" id="aadGroupNameNew0" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>                                                            
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control productEdit" name="aadProductTypeNew[]" id="aadProductType0" required onchange="showPolicyEdit(this)">
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
                                                                        <option value="MAIL">Microsoft Exchange</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB">OneDrive for Business</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                                        <option value="SP">SharePoint Online</option>
                                                                    <?php } ?>                                                                    
                                                                </select>
                                                            </td>
                                                            <td>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <div class="form-group addpolicyDivNew0" >
                                <select class="form-control selectPolicyPicker polEdit" name="addpolicyNew[]" id="addpolicyNew0" title='Select a Policy for Backup'>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
					    <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

<?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                            <div class="form-group addexchangePolicyDivNew0" style="display:none;">
                                <select class="form-control selectExchangePolicyPicker epolEdit" name="addpolicyNewE[]" id="addexchangePolicyNew0" title='Select a Microsoft Exchange Policy'>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
					    <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

<?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                            <div class="form-group addsharepointPolicyDivNew0" style="display:none;">
                                <select class="form-control selectSharepointPolicyPicker sppolEdit" name="addpolicyNewSH[]" id="addsharepointPolicyNew0" title='Select a Sharepoint Policy'>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

<?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                            <div class="form-group addonedrivePolicyDivNew0" style="display:none;">
                                <select class="form-control selectOnedrivePolicyPicker opolEdit" name="addpolicyNewO[]" id="addonedrivePolicyNew0" title='Select a OneDrive for Business Policy'>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                            <div class="form-group addsyncPolicyDivNew0" style="display:none;">
                                <select class="form-control selectSyncPolicyPicker spolEdit" name="addpolicyNewS[]" id="addsyncPolicyNew0" title='Select a Policy for BluSync'>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveNew(this)" id="removeNew0" class="btn btn-small btn-danger clickAble"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
						    </tbody>
                                                    <tbody ng-if="aadCredPrdouctPolicyList.length > 0">
                                                        <tr ng-repeat="ele in aadCredPrdouctPolicyList" class="first">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameNew[]" id="aadGroupNameNew{{$index}}" value="{{ele.groupName}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" required>
                                                            </td>                                                            
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control productEdit" name="aadProductTypeNew[]" id="aadProductType{{$index}}" required onchange="showPolicyEdit(this)">
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP" ng-selected="ele.productType == 'BACKUP'">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC" ng-selected="ele.productType == 'SYNC'">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
                                                                        <option value="MAIL" ng-selected="ele.productType == 'MAIL'">Microsoft Exchange</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="ele.productType == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                                        <option value="SP" ng-selected="ele.productType == 'SP'">SharePoint Online</option>
                                                                    <?php } ?>                                                                    
                                                                </select>
                                                            </td>
                                                            <td>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <div class="form-group addpolicyDivNew{{$index}}" ng-class="{ 'visible': ele.productType === 'BACKUP' }" style="display:none;">
                                <select class="form-control selectPolicyPicker polEdit" name="addpolicyNew[]" id="addpolicyNew{{$index}}" title='Select a Policy for Backup'>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
					    <option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$label?></option>
					    <!--<option value="<?=$value?>"><?=$label?></option>-->
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

<?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                            <div class="form-group addexchangePolicyDivNew{{$index}}" ng-class="{ 'visible': ele.productType === 'MAIL' }"  style="display:none;">
                                <select class="form-control selectExchangePolicyPicker epolEdit" name="addpolicyNewE[]" id="addexchangePolicyNew{{$index}}" title='Select a Microsoft Exchange Policy'>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
					    <option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
<!--						<option value="<?=$value?>"><?=$label?></option>-->
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

<?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                            <div class="form-group addsharepointPolicyDivNew{{$index}}" ng-class="{ 'visible': ele.productType === 'SP' }" style="display:none;">
                                <select class="form-control selectSharepointPolicyPicker sppolEdit" name="addpolicyNewSH[]" id="addsharepointPolicyNew{{$index}}" title='Select a Sharepoint Policy'>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
<!--<option value="<?=$value?>"><?=$label?></option>-->
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

<?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                            <div class="form-group addonedrivePolicyDivNew{{$index}}" ng-class="{ 'visible': ele.productType === 'ODB' }" style="display:none;">
                                <select class="form-control selectOnedrivePolicyPicker opolEdit" name="addpolicyNewO[]" id="addonedrivePolicyNew{{$index}}" title='Select a OneDrive for Business Policy'>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$value?></option>
<!--<option value="<?=$value?>"><?=$label?></option>-->
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>

                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                            <div class="form-group addsyncPolicyDivNew{{$index}}" ng-class="{ 'visible': ele.productType === 'SYNC' }" style="display:none;">
                                <select class="form-control selectSyncPolicyPicker spolEdit" name="addpolicyNewS[]" id="addsyncPolicyNew{{$index}}" title='Select a Policy for BluSync'>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>" ng-selected="ele.policyName == '<?=$value?>'"><?=$label?></option>
<!--<option value="<?=$value?>"><?=$label?></option>-->
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveNew(this)" id="removeNew{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
						    </tbody>
                                                </table>
					    </div>
</div>
</div>
<!--new panel edit end-->
					    </div>
<?php } ?>
<?php if($data['multiTenantAADEnabled'] == 'true'){ ?>
<div class="row">                                                
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientId" id="clientId1" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKey" id="secretKey1" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>                                                
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI1" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI1" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI1" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div> 
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode1" id="loginMode1" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
							 <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <option value="OneLogin"><?=Language::show('OneLogin', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
                                            </div>
                                            <!--tenants start-->
                                            <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                	<h4><?=Language::show('Tenant Configuration', 'keywords')?><span class="pull-right"><a onclick="dynamicAddTenant()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Tenant Id</a></span></h4>
                                            	  </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableTenantEdit" class="myTableTenantEdit table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Tenant Id</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="value in tenants" class="first" ng-if="tenants.length > 0">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="tenantEdit[]" id="tenantEdit{{$index}}" value="{{value}}" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveTenantEdit(this)" id="tenantEditRemove{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-trash"></i></a>
                                                            </td>
							</tr>
							<tr class="first" ng-if="tenants.length <= 0">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="tenantEdit[]" id="tenantEdit0" value="{{value}}" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveTenantEdit(this)" id="tenantEditRemove0" class="btn btn-small btn-danger clickAble"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
					    </div>
					    </div>
                                            <!--tenants ends-->
                                            <div class="row groupConfigurationsPanelEdit">
                                                <div class="panel-heading col-lg-12">
                                                	<h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="dynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            	  </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTable" class="myTable table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="(key,value) in aad" class="first">
                                                            <td ng-if="key != '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-if="key == '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductType[]" id="aadProductType{{$index}}" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP" ng-selected="value == 'BACKUP'">BluVault</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(Auth::checkCloudPermission('exchange')){ ?>
									<option value="MAIL" ng-selected="value == 'MAIL'">Microsoft Exchange</option>
								    <?php } ?>
								    <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                                                                        <option value="ODB" ng-selected="value == 'ODB'">OneDrive for Business</option>
                                                                    <?php } ?>
                                                        	    <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                                                        		<option value="SP" ng-selected="value == 'SP'">SharePoint Online</option>
                                                        	    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sharepoint')) ||(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('onedrive')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('sharepoint')) || (\Helpers\Auth::checkCloudPermission('onedrive') && \Helpers\Auth::checkCloudPermission('exchange')) || (\Helpers\Auth::checkCloudPermission('exchange') && \Helpers\Auth::checkCloudPermission('sharepoint'))){ ?>
                                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="Remove(this)" id="remove{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            </div>
<?php } ?>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success editCredentialsBtn"><?=Language::show('Save', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>

                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end-->
	    </div>
		<!--grant start-->
		<?php //if($data['tokenMapped'] == "false") { ?>
		<?php if($data['graphAADEnabled'] == 'true' && $data['multiTenantAADEnabled'] == 'false'){ ?>
			<?php if(!empty($data['data'])) {?>
			<div class="panel col-lg-12">
				<div class="panel-heading"><h4>For Admin Consent</h4></div>
				 <div class="panel-body">
					<?php
						$tenentId = $data['data']->{'tenentId'};
						$clientId = $data['data']->{'clientId'};
						$user_principal = $data['data']->{'user_principal'};
						//$redirectURI = $data["clientRedirectURI"];
						if(useLocalPackage != true){
							$redirectURI = "https://api-app.parablu.com/adminConsentMultiTenant.php";
							$appURL = "https://api-app.parablu.com/callConsent.php";
						}else{
							$redirectURI = LOCAL_IP."/app/adminConsentMultiTenant.php";
							$appURL = LOCAL_IP."/app/callConsent.php";
						}
						$params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
						//$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
						$ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
					?>
					<p>
					       <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
					</p>
				</div>
			</div>
		<?php } ?>
		<?php } ?>
		<!--grant ends-->
<?php if($data['graphAADEnabled'] == 'false'){ ?>
            <div class="row storageMappingButton">
                <?php if(!empty($data['data']) && $data['data']->{'authRequired'} != false) {?>
                <div class="panel col-lg-12">
                    <div class="panel-heading"><h4>Azure Active Directory Mapping</h4>
                    </div>
                    <div class="panel-body">
                        <div class="form-group col-lg-12">
                            <div class="well well-lg">
                                <?php
                                $tenentId = $data['data']->{'tenentId'};
                                $clientId = $data['data']->{'clientId'};
                                $user_principal = $data['data']->{'user_principal'};
                                //$redirectURI = $data['data']->{'redirectURI'};
                                if(useLocalPackage != true){
                                    $redirectURI = "https://api-app.parablu.com/aad.php";
                                    $appURL = "https://api-app.parablu.com/call1.php";
                                }else{
                                    $redirectURI = LOCAL_IP."/app/aad.php";
                                    $appURL = LOCAL_IP."/app/call1.php";
                                }
                                    $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal".$user_principal;
                                    //$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                                    $ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                                ?>
                                <p>
                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Map Azure Active Directory</a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
<?php } ?>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js" type="text/javascript"></script>

<script>
$('#loginMode2').on('change', function(){
	var type = $('#loginMode2').val();
	if(type == 'Okta' || type == 'OneLogin'){
		$('.groupConfigurationsPanelAdd').hide(); 
	}else{
		$('.groupConfigurationsPanelAdd').show();
	}
});

$('#loginMode1').on('change', function(){
	var type = $('#loginMode1').val();
	if(type == 'Okta' || type == 'OneLogin'){
		$('.groupConfigurationsPanelEdit').hide();
	}else{
		$('.groupConfigurationsPanelEdit').show();
	}
});

function dynamicAdd(){
    var trlength= $('#myTable tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTable tbody tr:last').clone();
    var timestamp = new Date().getTime();
    function generateUniqueID(prefix) {
        return prefix + timestamp;
    }
    lasttr.find('select').attr('id', 'aadProductType' + timestamp);
    lasttr.find('select').attr('name', 'aadProductType[]');
    lasttr.find('input').attr('id', 'aadGroupName' + timestamp);
    lasttr.find('input').attr('name', 'aadGroupName[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'remove' + timestamp);
    lasttr.find('a').attr("onclick", "Remove(this);");
    lasttr.find('select.policyView').attr('id', generateUniqueID('policyView'));
    lasttr.find('select.policyViewS').attr('id', generateUniqueID('policyViewS'));
    lasttr.find('select.policyViewE').attr('id', generateUniqueID('policyViewE'));
    lasttr.find('select.policyViewO').attr('id', generateUniqueID('policyViewO'));
    lasttr.find('select.policyViewSH').attr('id', generateUniqueID('policyViewSH'));
    i++;
    $('#myTable tbody').append(lasttr);
    //trlength= $('#myTableOld tbody tr').length;
    //i = trlength;
    //if(i > 1){
    $("[id*='remove']").removeClass('disabled');
    //}
}

function dynamicAddNew() {
    var timestamp = new Date().getTime(); // Get current timestamp
    var lasttr = $('#myTableNew tbody tr:last').clone();
    // Function to generate a unique ID with a timestamp-based suffix
    function generateUniqueID(prefix) {
        return prefix + timestamp;
    }
    // Update IDs and names for select elements
    lasttr.find('select.productEdit').attr('id', generateUniqueID('aadProductTypeNew'));
    lasttr.find('select.productEdit').attr('name', 'aadProductTypeNew[]');
    lasttr.find('select.polEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.spolEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.epolEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.opolEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.sppolEdit').attr('id', generateUniqueID('addpolicy'));
    // Update IDs and names for input elements
    lasttr.find('input').attr('id', generateUniqueID('aadGroupNameNew'));
    lasttr.find('input').attr('name', 'aadGroupNameNew[]');
    lasttr.find('input').attr('value', '');
    // Update ID for remove link
    lasttr.find('a').attr('id', generateUniqueID('removeNew'));
    lasttr.find('a').attr("onclick", "RemoveNew(this);");
    // Update class and ID for parent divs
    /*lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp + ' visible');
    lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp + ' hidden');
    lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp + ' hidden');
    lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp + ' hidden');
    lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp + ' hidden');*/
    // Set the selected value for the productEdit select element
    var selectedProduct = lasttr.find('select.productEdit').val();
    lasttr.find('select.productEdit').val(selectedProduct);
    if(selectedProduct == 'BACKUP'){
        lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp + ' show');
        lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp + ' hide');
    }
    if(selectedProduct == 'SYNC'){
        lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp + ' show');
        lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp + ' hide');
    }
    if(selectedProduct == 'MAIL'){
        lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp + ' show');
        lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp + ' hide');
    }
    if(selectedProduct == 'ODB'){
        lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp + ' show');
        lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp + ' hide');
    }
    if(selectedProduct == 'SP'){
        lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp + ' hide');
        lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp + ' show');
    }
    // Append the modified row to the table body
    $('#myTableNew tbody').append(lasttr);
    // Enable remove links if there is more than one row
    //if ($('#myTableNew tbody tr').length > 1) {
        $("[id*='removeNew']").removeClass('disabled');
    //}
}

/*function dynamicAddNew() {
    var timestamp = new Date().getTime(); // Get current timestamp
    var lasttr = $('#myTableNew tbody tr:last').clone();
    // Function to generate a unique ID with a timestamp-based suffix
    function generateUniqueID(prefix) {
        return prefix + timestamp;
    }
    // Update IDs and names for select elements
    lasttr.find('select.productEdit').attr('id', generateUniqueID('aadProductTypeNew'));
    lasttr.find('select.productEdit').attr('name', 'aadProductTypeNew[]');
    lasttr.find('select.polEdit').attr('id', generateUniqueID('addpolicy'));    
    lasttr.find('select.spolEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.epolEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.opolEdit').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.sppolEdit').attr('id', generateUniqueID('addpolicy'));
    // Update IDs and names for input elements
    lasttr.find('input').attr('id', generateUniqueID('aadGroupNameNew'));
    lasttr.find('input').attr('name', 'aadGroupNameNew[]');
    lasttr.find('input').attr('value', '');
    // Update ID for remove link
    lasttr.find('a').attr('id', generateUniqueID('removeNew'));
    lasttr.find('a').attr("onclick", "RemoveNew(this);");
    // Update class and ID for parent divs
    lasttr.find('select.polEdit').parent('div').removeClass().addClass('addpolicyDivNew' + timestamp);
    lasttr.find('select.spolEdit').parent('div').removeClass().addClass('addsyncPolicyDivNew' + timestamp);
    lasttr.find('select.epolEdit').parent('div').removeClass().addClass('addexchangePolicyDivNew' + timestamp);
    lasttr.find('select.opolEdit').parent('div').removeClass().addClass('addonedrivePolicyDivNew' + timestamp);
    lasttr.find('select.sppolEdit').parent('div').removeClass().addClass('addsharepointPolicyDivNew' + timestamp);
    // Append the modified row to the table body
    $('#myTableNew tbody').append(lasttr);
    // Enable remove links if there is more than one row
    //if ($('#myTableNew tbody tr').length > 1) {
    	$("[id*='removeNew']").removeClass('disabled');
    //}
}*/

function Remove(button) {
        //new
        var trlength= $('#myTable tbody tr').length;
        var i = trlength;
        if(i > 1){
        //new
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTable");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTable tbody tr').length;
    i = trlength;
    if(i == 1){
        $("[id*='remove']").addClass('disabled');
    }
        }else{
         $("[id*='remove']").addClass('disabled');
        }
    //}
};

function RemoveNew(button) {
        //new
        var trlength= $('#myTableNew tbody tr').length;
        var i = trlength;
        if(i > 1){
        //new
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableNew");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableNew tbody tr').length;
    i = trlength;
    if(i == 1){
        $("[id*='removeNew']").addClass('disabled');
    }
        }else{
         $("[id*='removeNew']").addClass('disabled');
        }
    //}
};
	
/*function dynamicAdd(){
    var trlength= $('#myTable tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTable tbody tr:last').clone();
    lasttr.find('select').attr('id', 'aadProductType' + trlength);
    lasttr.find('select').attr('name', 'aadProductType[]');
    lasttr.find('input').attr('id', 'aadGroupName' + trlength);
    lasttr.find('input').attr('name', 'aadGroupName[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'remove' + trlength); 
    lasttr.find('a').attr("onclick", "Remove(this);");               
    i++;    
    $('#myTable tbody').append(lasttr);
    $("[id*='remove']").removeClass('disabled');
}

function Remove(button) {
        //new
        var trlength= $('#myTable tbody tr').length;
        var i = trlength;
        if(i > 1){
        //new
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTable");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTable tbody tr').length;
    i = trlength;
    if(i == 1){
        $("[id*='remove']").addClass('disabled');
    }
        }else{
         $("[id*='remove']").addClass('disabled');
        }
    //}
};*/

function addDynamicAdd(){
    var trlength= $('#myTableAddOld tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableAddOld tbody tr:last').clone();
    lasttr.find('select').attr('id', 'aadProductType' + trlength);
    lasttr.find('select').attr('name', 'aadProductTypeadd[]');
    lasttr.find('input').attr('id', 'aadGroupName' + trlength);
    lasttr.find('input').attr('name', 'aadGroupNameadd[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'removeAdd' + trlength);
    lasttr.find('a').attr("onclick", "RemoveAdd(this);");
    i++;
    $('#myTableAddOld tbody').append(lasttr);
    trlength= $('#myTableAddOld tbody tr').length;
    i = trlength;
    if(i > 1){
    $("[id*='removeAdd']").removeClass('disabled');
    }
}

function addDynamicAddNew() {
    var timestamp = new Date().getTime(); // Get current timestamp
    var lasttr = $('#myTableAddNew tbody tr:last').clone();
    // Function to generate a unique ID with a timestamp-based suffix
    function generateUniqueID(prefix) {
        return prefix + timestamp;
    }
    // Update IDs and names for select elements
    lasttr.find('select.product').attr('id', generateUniqueID('aadProductTypeNew'));
    lasttr.find('select.product').attr('name', 'aadProductTypeaddNew[]');
    lasttr.find('select.pol').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.spol').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.epol').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.opol').attr('id', generateUniqueID('addpolicy'));
    lasttr.find('select.sppol').attr('id', generateUniqueID('addpolicy'));
    // Update IDs and names for input elements
    lasttr.find('input').attr('id', generateUniqueID('aadGroupNameNew'));
    lasttr.find('input').attr('name', 'aadGroupNameaddNew[]');
    lasttr.find('input').attr('value', '');
    // Update ID for remove link
    lasttr.find('a').attr('id', generateUniqueID('removeAddNew'));
    lasttr.find('a').attr("onclick", "RemoveAddNew(this);");
    // Update class and ID for parent divs
    lasttr.find('select.pol').parent('div').removeClass().addClass('addpolicyDiv' + timestamp);
    lasttr.find('select.spol').parent('div').removeClass().addClass('addsyncPolicyDiv' + timestamp);
    lasttr.find('select.epol').parent('div').removeClass().addClass('addexchangePolicyDiv' + timestamp);
    lasttr.find('select.opol').parent('div').removeClass().addClass('addonedrivePolicyDiv' + timestamp);
    lasttr.find('select.sppol').parent('div').removeClass().addClass('addsharepointPolicyDiv' + timestamp);
    // Append the modified row to the table body
    $('#myTableAddNew tbody').append(lasttr);
    // Enable remove links if there is more than one row
    if ($('#myTableAddNew tbody tr').length > 1) {
        $("[id*='removeAddNew']").removeClass('disabled');
    }
}




function RemoveAdd(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableAddOld");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableAddOld tbody tr').length;
    i = trlength;
    if(i == 1){
    $("[id*='removeAdd']").addClass('disabled');
    }
    //}
};

function RemoveAddNew(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableAddNew");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableAddNew tbody tr').length;
    i = trlength;
    if(i == 1){
    $("[id*='removeAddNew']").addClass('disabled');
    }
    //}
};

function dynamicAddTenant(){
    var trlength= $('#myTableTenantEdit tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableTenantEdit tbody tr:last').clone();
    lasttr.find('input').attr('id', 'tenantEdit' + trlength);
    lasttr.find('input').attr('name', 'tenantEdit[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'tenantEditRemove' + trlength);
    lasttr.find('a').attr("onclick", "RemoveTenantEdit(this);");
    i++;
    $('#myTableTenantEdit tbody').append(lasttr);
    $("[id*='tenantEditRemove']").removeClass('disabled');
}

function RemoveTenantEdit(button) {
        //new
        var trlength= $('#myTableTenantEdit tbody tr').length;
        var i = trlength;
        if(i > 1){
        //new
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableTenantEdit");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableTenantEdit tbody tr').length;
    i = trlength;
    if(i == 1){
        $("[id*='tenantEditRemove']").addClass('disabled');
    }
        }else{
         $("[id*='tenantEditRemove']").addClass('disabled');
        }
    //}
};


function addDynamicAddTenant(){
    var trlength= $('#myTableAddTenant tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableAddTenant tbody tr:last').clone();
    lasttr.find('input').attr('id', 'aadTenant' + trlength);
    lasttr.find('input').attr('name', 'aadTenant[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'tenantAddRemove' + trlength);
    lasttr.find('a').attr("onclick", "RemoveAdd(this);");
    i++;
    $('#myTableAddTenant tbody').append(lasttr);
    trlength= $('#myTableAddTenant tbody tr').length;
    i = trlength;
    if(i > 1){
    $("[id*='tenantAddRemove']").removeClass('disabled');
    }
}

function RemoveAddTenant(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableAddTenant");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableAddTenant tbody tr').length;
    i = trlength;
    if(i == 1){
    $("[id*='tenantAddRemove']").addClass('disabled');
    }
    //}
};

function showPolicy(select) {
	var selectId = select.id;
	var selectValue = select.value;
	var numericPart = selectId.match(/\d+/)[0];
	console.log("Select element ID:", selectId);
	console.log("Select element Value:", selectValue);
	$('.addpolicyDiv' + numericPart + ', .addsyncPolicyDiv' + numericPart + ', .addexchangePolicyDiv' + numericPart + ', .addonedrivePolicyDiv' + numericPart + ', .addsharepointPolicyDiv' + numericPart).hide();
	if(selectValue == 'BACKUP'){
		$('.addpolicyDiv'+numericPart).show();
	}else if(selectValue == 'SYNC'){
                $('.addsyncPolicyDiv'+numericPart).show();
	}else if(selectValue == 'MAIL'){
                $('.addexchangePolicyDiv'+numericPart).show();
	}else if(selectValue == 'ODB'){
                $('.addonedrivePolicyDiv'+numericPart).show();
	}else if(selectValue == 'SP'){
                $('.addsharepointPolicyDiv'+numericPart).show();
	}
}

function showPolicyEdit(select) {
        var selectId = select.id;
        var selectValue = select.value;
	var numericPart = selectId.match(/\d+/)[0];
	console.log("Select element ID:", selectId);
        console.log("Select element Value:", selectValue);
        /*$('.addpolicyDivNew' + numericPart + ', .addsyncPolicyDivNew' + numericPart + ', .addexchangePolicyDivNew' + numericPart + ', .addonedrivePolicyDivNew' + numericPart + ', .addsharepointPolicyDivNew' + numericPart).hide();
        if(selectValue == 'BACKUP'){
                $('.addpolicyDivNew'+numericPart).show();
        }else if(selectValue == 'SYNC'){
                $('.addsyncPolicyDivNew'+numericPart).show();
        }else if(selectValue == 'MAIL'){
                $('.addexchangePolicyDivNew'+numericPart).show();
        }else if(selectValue == 'ODB'){
                $('.addonedrivePolicyDivNew'+numericPart).show();
        }else if(selectValue == 'SP'){
                $('.addsharepointPolicyDivNew'+numericPart).show();
}*/
	/*$('.addpolicyDivNew' + numericPart + ', .addsyncPolicyDivNew' + numericPart + ', .addexchangePolicyDivNew' + numericPart + ', .addonedrivePolicyDivNew' + numericPart + ', .addsharepointPolicyDivNew' + numericPart).css("display","none");
	$('.addpolicyDivNew' + numericPart + ', .addsyncPolicyDivNew' + numericPart + ', .addexchangePolicyDivNew' + numericPart + ', .addonedrivePolicyDivNew' + numericPart + ', .addsharepointPolicyDivNew' + numericPart).removeClass("visible");
        if(selectValue == 'BACKUP'){
                $('.addpolicyDivNew'+numericPart).css("display","block");
        }else if(selectValue == 'SYNC'){
                $('.addsyncPolicyDivNew'+numericPart).css("display","block");
        }else if(selectValue == 'MAIL'){
                $('.addexchangePolicyDivNew'+numericPart).css("display","block");
        }else if(selectValue == 'ODB'){
                $('.addonedrivePolicyDivNew'+numericPart).css("display","block");
        }else if(selectValue == 'SP'){
                $('.addsharepointPolicyDivNew'+numericPart).css("display","block");
	}*/
	$('.addpolicyDivNew' + numericPart + ', .addsyncPolicyDivNew' + numericPart + ', .addexchangePolicyDivNew' + numericPart + ', .addonedrivePolicyDivNew' + numericPart + ', .addsharepointPolicyDivNew' + numericPart).removeClass("show");
	$('.addpolicyDivNew' + numericPart + ', .addsyncPolicyDivNew' + numericPart + ', .addexchangePolicyDivNew' + numericPart + ', .addonedrivePolicyDivNew' + numericPart + ', .addsharepointPolicyDivNew' + numericPart).removeClass("visible");
	$('.addpolicyDivNew' + numericPart + ', .addsyncPolicyDivNew' + numericPart + ', .addexchangePolicyDivNew' + numericPart + ', .addonedrivePolicyDivNew' + numericPart + ', .addsharepointPolicyDivNew' + numericPart).addClass("hide");
	if(selectValue == 'BACKUP'){
                $('.addpolicyDivNew'+numericPart).removeClass("hide");
                $('.addpolicyDivNew'+numericPart).addClass("show");
        }else if(selectValue == 'SYNC'){
                $('.addsyncPolicyDivNew'+numericPart).removeClass("hide");
                $('.addsyncPolicyDivNew'+numericPart).addClass("show");
        }else if(selectValue == 'MAIL'){
                $('.addexchangePolicyDivNew'+numericPart).removeClass("hide");
                $('.addexchangePolicyDivNew'+numericPart).addClass("show");
        }else if(selectValue == 'ODB'){
                $('.addonedrivePolicyDivNew'+numericPart).removeClass("hide");
                $('.addonedrivePolicyDivNew'+numericPart).addClass("show");
        }else if(selectValue == 'SP'){
                $('.addsharepointPolicyDivNew'+numericPart).removeClass("hide");
                $('.addsharepointPolicyDivNew'+numericPart).addClass("show");
	}
}

$("#switchGroupView").click(function(){
      if ($(this).is(':checked')) {
        $('.newpanel, .newaddBtn' ).show();
	$('.oldpanel, .oldaddBtn').hide();
	document.getElementById("defaultPoliciesAddPanel").style['pointer-events'] = 'none';
	document.getElementById("defaultPoliciesAddPanel").style.opacity = "0.4";
	    if($("#defaultBkpPolicyNameAdd").length > 0 && ($("#defaultBkpPolicyNameAdd").val() != $('.defaultBkpPolicyNameOriginal').html())){
                $('#unsavedWarningAdd').modal().show();
            }
            if($("#defaultSyncPolicyNameAdd").length > 0 && ($("#defaultSyncPolicyNameAdd").val() != $('.defaultSyncPolicyNameOriginal').html())){
                $('#unsavedWarningAdd').modal().show();
            }
            if($("#defaultExchangePolicyNameAdd").length > 0 && ($("#defaultExchangePolicyNameAdd").val() != $('.defaultExchangePolicyNameOriginal').html())){
                $('#unsavedWarningAdd').modal().show();
            }
            if($("#defaultOdbPolicyNameAdd").length > 0 && ($("#defaultOdbPolicyNameAdd").val() != $('.defaultOdbPolicyNameOriginal').html())){
                $('#unsavedWarningAdd').modal().show();
            }
            if($("#defaultSharepointPolicyNameAdd").length > 0 && ($("#defaultSharepointPolicyNameAdd").val() != $('.defaultSharepointPolicyNameOriginal').html())){
                $('#unsavedWarningAdd').modal().show();
	    }
	    var inputFields = document.querySelectorAll('input[name="aadGroupNameaddNew[]"]');
        inputFields.forEach(function(inputField) {
            inputField.setAttribute('required', 'required');
        });
      } else {
        $('.newpanel, .newaddBtn').hide();
	$('.oldpanel, .oldaddBtn').show();
	document.getElementById("defaultPoliciesAddPanel").style['pointer-events'] = 'unset';
	document.getElementById("defaultPoliciesAddPanel").style.opacity = "1";
	var inputFields = document.querySelectorAll('input[name="aadGroupNameaddNew[]"]');
        inputFields.forEach(function(inputField) {
            inputField.removeAttribute('required');
        });
      }
});

$("#switchGroupViewEdit").click(function(){
      if ($(this).is(':checked')) {
        $('.newpanelEdit, .newaddEditBtn' ).show();
	$('.oldpanelEdit, .oldaddEditBtn').hide();
	document.getElementById("defaultPoliciesEditPanel").style['pointer-events'] = 'none';
	document.getElementById("defaultPoliciesEditPanel").style.opacity = "0.4";	
	if($("#defaultBkpPolicyNameEdit").length > 0 && ($("#defaultBkpPolicyNameEdit").val() != $('.defaultBkpPolicyNameOriginal').html())){
                $('#unsavedWarning').modal().show();
            }
            if($("#defaultSyncPolicyNameEdit").length > 0 && ($("#defaultSyncPolicyNameEdit").val() != $('.defaultSyncPolicyNameOriginal').html())){
                $('#unsavedWarning').modal().show();
            }
            if($("#defaultExchangePolicyNameEdit").length > 0 && ($("#defaultExchangePolicyNameEdit").val() != $('.defaultExchangePolicyNameOriginal').html())){
                $('#unsavedWarning').modal().show();
            }
            if($("#defaultOdbPolicyNameEdit").length > 0 && ($("#defaultOdbPolicyNameEdit").val() != $('.defaultOdbPolicyNameOriginal').html())){
                $('#unsavedWarning').modal().show();
            }
            if($("#defaultSharepointPolicyNameEdit").length > 0 && ($("#defaultSharepointPolicyNameEdit").val() != $('.defaultSharepointPolicyNameOriginal').html())){
                $('#unsavedWarning').modal().show();
	    }
	    var inputFields = document.querySelectorAll('input[name="aadGroupNameNew[]"]');
        inputFields.forEach(function(inputField) {
            inputField.setAttribute('required', 'required');
        });
      } else {
        $('.newpanelEdit, .newaddEditBtn').hide();
	$('.oldpanelEdit, .oldaddEditBtn').show();
	document.getElementById("defaultPoliciesEditPanel").style['pointer-events'] = 'unset';
	document.getElementById("defaultPoliciesEditPanel").style.opacity = "1";
	var inputFields = document.querySelectorAll('input[name="aadGroupNameNew[]"]');
        inputFields.forEach(function(inputField) {
            inputField.removeAttribute('required');
        });
      }
});


$("#switchGroupRead").click(function(){
      if ($(this).is(':checked')) {
        $('#myTableShowNew' ).show();
        $('#myTableShow').hide()
      } else {
        $('#myTableShowNew').hide();
        $('#myTableShow').show();
      }
});

function changeDefaultPolicyEdit(select) {
        var selectId = select.id;
        if(selectId == 'defaultBkpPolicyNameEdit'){
                $('.policyView').val($('#defaultBkpPolicyNameEdit').val());
        }else if(selectId == 'defaultSyncPolicyNameEdit'){
                $('.policyViewS').val($('#defaultSyncPolicyNameEdit').val());
        }else if(selectId == 'defaultExchangePolicyNameEdit'){
                $('.policyViewE').val($('#defaultExchangePolicyNameEdit').val());
        }else if(selectId == 'defaultOdbPolicyNameEdit'){
                $('.policyViewO').val($('#defaultOdbPolicyNameEdit').val());
        }else if(selectId == 'defaultSharepointPolicyNameEdit'){
                $('.policyViewSH').val($('#defaultSharepointPolicyNameEdit').val());
        }
}

function changeDefaultPolicyAdd(select) {
        var selectId = select.id;
        if(selectId == 'defaultBkpPolicyNameAdd'){
                $('.policyViewAdd').val($('#defaultBkpPolicyNameAdd').val());
        }else if(selectId == 'defaultSyncPolicyNameAdd'){
                $('.policyViewSAdd').val($('#defaultSyncPolicyNameAdd').val());
        }else if(selectId == 'defaultExchangePolicyNameAdd'){
                $('.policyViewEAdd').val($('#defaultExchangePolicyNameAdd').val());
        }else if(selectId == 'defaultOdbPolicyNameAdd'){
                $('.policyViewOAdd').val($('#defaultOdbPolicyNameAdd').val());
        }else if(selectId == 'defaultSharepointPolicyNameAdd'){
                $('.policyViewSHAdd').val($('#defaultSharepointPolicyNameAdd').val());
        }
}

function changeProEditOld(select) {	
	var selectId = select.id;
        var selectValue = select.value;
	var numericPart = selectId.match(/\d+/)[0];
	$('#policyView' + numericPart + ', #policyViewS' + numericPart + ', #policyViewE' + numericPart + ', #policyViewO' + numericPart + ', #policyViewSH' + numericPart).removeClass("showSelect");
	$('#policyView' + numericPart + ', #policyViewS' + numericPart + ', #policyViewE' + numericPart + ', #policyViewO' + numericPart + ', #policyViewSH' + numericPart).css("display","none");
	console.log("select id : "+selectId);
	console.log("select value : "+selectValue);

//	$('.policyView,.policyViewS, .policyViewE, .policyViewO, .policyViewSH').removeClass("showSelect");
//	$('.policyView,.policyViewS, .policyViewE, .policyViewO, .policyViewSH').css("display","none");
        if(selectValue == 'BACKUP'){
                $('#policyView'+numericPart).css("display","block");
        }else if(selectValue == 'SYNC'){
                $('#policyViewS'+numericPart).css("display","block");
        }else if(selectValue == 'MAIL'){
                $('#policyViewE'+numericPart).css("display","block");
        }else if(selectValue == 'ODB'){
                $('#policyViewO'+numericPart).css("display","block");
        }else if(selectValue == 'SP'){
                $('#policyViewSH'+numericPart).css("display","block");
        }
}

function changeProAddOld(select) {
	var selectValue = select.value;
	$('.policyViewAdd,.policyViewSAdd, .policyViewEAdd, .policyViewOAdd, .policyViewSHAdd').css("display","none");
        if(selectValue == 'BACKUP'){
                $('.policyViewAdd').css("display","block");
        }else if(selectValue == 'SYNC'){
                $('.policyViewSAdd').css("display","block");
        }else if(selectValue == 'MAIL'){
                $('.policyViewEAdd').css("display","block");
        }else if(selectValue == 'ODB'){
                $('.policyViewOAdd').css("display","block");
        }else if(selectValue == 'SP'){
                $('.policyViewSHAdd').css("display","block");
	}
}

</script>
<style>
.fab-wrapper{
display: none!important;
}
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 22px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 3px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
.visible{
display:block !important;
}

.showSelect{
display:block !important;
}
</style>
