<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('migration')?>"><?=Language::show('userMigration', 'report')?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="row">
                <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
                <span class="currentPage d-none"><?='userMigration'?></span>
                <div class="panel col-lg-12">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body">
                        <div class="h4 loading text-center" style="display: none;"><img width="70px" src="<?=Url::templatePath()?>images/gears.gif"></div>
                        <a class="btn btn-small btn-default pull-right" ng-click="downloadUserMigration()">Export To Excel</a>
                        <br/><br/>
                        <div class="table-responsive">
                        <table id="UserMigration" class="table table-bordered userMigration" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortTypeMigration = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortTypeMigration == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMigration == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeMigration = 'emailId'; sortReverse = !sortReverse">
                                    <?=Language::show('email', 'keywords')?>
                                    <span ng-show="sortTypeMigration == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMigration == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeMigration = 'createdTimestamp'; sortReverse = !sortReverse">
                                    <?=Language::show('Migrated Time', 'keywords')?>
                                    <span ng-show="sortTypeMigration == 'createdTimestamp' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMigration == 'createdTimestamp' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeMigration = 'migratedBy'; sortReverse = !sortReverse">
                                    <?=Language::show('Migrated By', 'keywords')?>
                                    <span ng-show="sortTypeMigration == 'migratedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMigration == 'migratedBy' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeMigration = 'migrated'; sortReverse = !sortReverse">
                                    <?=Language::show('Status', 'keywords')?>
                                    <span ng-show="sortTypeMigration == 'migrated' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMigration == 'migrated' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeMigration = 'reason'; sortReverse = !sortReverse">
                                    <?=Language::show('Reason', 'keywords')?>
                                    <span ng-show="sortTypeMigration == 'reason' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMigration == 'reason' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in userMigration | orderBy:sortTypeMigration:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                <td class="text-center" ng-if="value.emailId != null" ng-cloak>{{ value.emailId }}</td>
                                <td class="text-center" ng-if="value.emailId == null" ng-cloak> No email id </td>
                                <td class="text-center" ng-cloak>{{ value.createdTimestamp }}</td>
                                <td class="text-center" ng-cloak>{{ value.migratedBy }}</td>
                                <td class="text-center" ng-if="value.migrated == true"ng-cloak>Success</td>
                                <td class="text-center" ng-if="value.migrated == false"ng-cloak>Failed</td>
                                <td class="text-center" ng-if="value.reason == null" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.reason != null" ng-cloak>{{ value.reason }}</td>
                            </tr>
                            </tbody>
                        </table>
                            </div>
                        <div class="h4 userMigrationError text-center" style="display: none">No details found </div>
                    </div>
                    <div class="row userMigrationNavigate" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="updateUserMigrationNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="updateUserMigrationNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="updateUserMigrationNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="updateUserMigrationNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <!--<div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'userMigration')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
