<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.3
* @date 06/11/19
* @time 12:38 PM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
        <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?="Dashboard"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak" block-ui="myBlockUI">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='userBackupSummary'?></span>
            <span class="reportProductType d-none"><?=$data['reportProductType']?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body"><div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="updateUserBackupSummary(search.noOfDays,search.searchPolicyName)">
				    <div class="row">
<?php if($data['reportProductType'] == 'office'){?>
                                <div class="row col-lg-12" style="margin-bottom:10px;">
                                    <div class="col-lg-3">
                                        <label for="productType">Product Type</label>
                                        <select class="form-control productType" id="productType" name="productType" title='Select Product Type'>
                                            <option value="ODB" selected>OneDrive for Business</option>
                                            <option value="Exchange">Microsoft Exchange</option>
                                            <option value="Sharepoint">SharePoint Online</option>
                                        </select>
                                    </div>
                                </div>
    <?php } ?>
<?php if($data['reportProductType'] == 'backup'){?>
                                        <div class="col-lg-4">       
                                            <label for="searchPolicyName">Policy Name</label>
                                            <select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name'>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?> 
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
					</div>
<?php } ?>
<?php if($data['reportProductType'] == 'onedrive'){?>
                                        <div class="col-lg-4 searchODBPolicyNameBlock" id="searchODBPolicyNameBlock">
                                        <label for="searchODBPolicyName">OneDrive for Business Policy Name</label>
                                                <select class="form-control selectPicker" id="searchODBPolicyName" name="searchODBPolicyName[]" multiple  title='Select OneDrive for Business Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["odbPolicies"])) {?>
                                                            <?php foreach($data['odbPolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
					</div>
<?php } ?>
<?php if($data['reportProductType'] == 'exchange'){?>
                                        <div class="col-lg-4 searchExchangePolicyNameBlock" id="searchExchangePolicyNameBlock">
                                                <label for="searchExchangePolicyName">Exchange Policy Name</label>
                                                <select class="form-control selectPicker" id="searchExchangePolicyName" name="searchExchangePolicyName[]" multiple  title='Select Microsoft Exchange Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["exchangePolicies"])) {?>
                                                            <?php foreach($data['exchangePolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
					</div>
<?php } ?>
<?php if($data['reportProductType'] == 'sharepoint'){?>
                                        <div class="col-lg-4 searchSharepointPolicyNameBlock" id="searchSharepointPolicyNameBlock">
                                                <label for="searchSharepointPolicyName">SharePoint Online Policy Name</label>
                                                <select class="form-control selectPicker" id="searchSharepointPolicyName" name="searchSharepointPolicyName[]" multiple  title='Select SharePoint Online Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["sharepointPolicies"])) {?>
                                                            <?php foreach($data['sharepointPolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
                                        <?php } ?>
                                        <div class="col-lg-3">
                                            <label for="noOfDays">Data Protection Scorecard for</label>
                                            <input type="number" id="noOfDays" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:5px;" value="30"> <label style="margin-top:12px;">days </label>
                                        </div>
                                        <div class="dropdown col-lg-4" style="margin-top:25px;">
                                            <button type="submit" class="btn btn-primary">View</button>
                                            <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li class="includeOption"><input type="checkbox" class="includeOption" name="includeDetails" id="includeDetails"> <label for="includeDetails" style="cursor:pointer;">Include Details</label></li>
                                                <li><a ng-click="downloadUserBackupSummaryReport(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadUserBackupSummaryReportPdf(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">PDF</a><li>
                                              </ul>
                                            <a title="Schedule" class="btn btn-primary" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendBkpSummeryReportTimer')"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <br/>
			<div class="table-responsive">
<?php if( $data['reportProductType'] != 'sharepoint'){ ?>
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Users</td>
                                <td ng-cloak>{{ userBackupSummary.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
				<td class="text-left notForOffice" ng-cloak>Users with at least one asset assigned</td>
<?php if( $data['reportProductType'] == 'onedrive' || $data['reportProductType'] == 'exchange'){ ?>
				<td class="text-left forOffice" ng-cloak>Users with at least one asset assigned</td>
<?php } ?>
                                <td ng-cloak>{{ userBackupSummary.userWithDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>
                                <td class="text-left" ng-cloak>No. of users for whom at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummary.userWithFirstBkpCompleted }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
				<td class="text-left notForOffice" ng-cloak>No. of users without asset registered</td>
<?php if( $data['reportProductType'] == 'onedrive' || $data['reportProductType'] == 'exchange'){ ?>
				<td class="text-left forOffice" ng-cloak>No. of users without any asset registered</td>
<?php } ?>
                                <td ng-cloak>{{ userBackupSummary.userWithOutDevices }}</td>
                            </tr>
                            <?php if( $data['reportProductType'] == 'backup'){ ?>
                                <tr class="text-center">
                                    <td class="text-center" ng-cloak>5.</td>
                                    <td class="text-left" ng-cloak>No. of users whose assets had a heartbeat to the server in the last <span class="heartbeat"></span> days</td>
                                    <td ng-cloak>{{ userBackupSummary.noOfUsersHeardCount }}</td>
                                </tr>
                            <?php } ?>                            
                            <tr class="text-center">
                                <?php if( $data['reportProductType'] == 'backup'){ ?>
                                    <td class="text-center" ng-cloak>6.</td>
                                <?php } else { ?>
                                    <td class="text-center" ng-cloak>5.</td>
                                <?php } ?>
				<td class="text-left notForOffice" ng-cloak>No. of users whose assets have been protected in the last <span class="protected"></span> days</td>
<?php if( $data['reportProductType'] == 'onedrive' || $data['reportProductType'] == 'exchange'){ ?>
				<td class="text-left forOffice" ng-cloak>No. of users whose assets have been protected in the last <span class="protected"></span> days</td>
<?php } ?>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersProtected }}</td>
                            </tr>
			    </tbody>
			</table>
<?php } ?>
<?php if( $data['reportProductType'] == 'sharepoint'){ ?>
			<table id="onlysharepoint" class="table table-bordered onlysharepoint" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Sites</td>
                                <td ng-cloak>{{ userBackupSummary.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
                                <td class="text-left" ng-cloak>No. of Sites for which at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummary.userWithFirstBkpCompleted }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>                                
                                <td class="text-left" ng-cloak>No. of Sites which have been protected in the last <span class="protected"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersProtected }}</td>
                            </tr>
			    </tbody>
			</table>
<?php } ?>
                        </div>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                    </div>
                    <!--<div class="row loadMore" style="display: none;">
<div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'longBackup')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
    </div>
<!--modal start-->
<div class="modal fade" id="scheduleModalList" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <div class="modal-header">
                    <h4 class="modal-title"><?=Language::show('List of Schedules', 'keywords')?></h4>
                </div>
                <div class="modal-body">
                    <div class="row schedulesNotFound" style="display: none;">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h2 align="center"><?=Language::show('No Schedules found !!!!!!', 'keywords');?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row schedulesFound" style="display: none;">
                        <div class="table-responsive col-lg-12 schedulesTable">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Schedule Name</th>
                                        <th>Schedule Time</th>
                                        <th>Recipient email IDs</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in schedules">
                                    <td ng-if="value.productType == '<?php echo $data['reportProductType'];?>'">{{value.scheduleName | limitTo:20}}{{value.scheduleName.length > 20 ? '...' : ''}}</td>
                                        <td ng-if="value.productType == '<?php echo $data['reportProductType'];?>'">{{value.time}}</td>
                                        <td ng-if="value.allAdmins == 'false' && value.productType == '<?php echo $data['reportProductType'];?>'" class="text-left" title="{{ value.emailIds }}" ng-cloak>{{ value.emailIds | limitTo:50}}{{value.emailIds.length > 50 ? '...' : ''}}</td>
                                        <td ng-if="value.allAdmins == 'true' && value.productType == '<?php echo $data['reportProductType'];?>'" class="text-left" title="All admins" ng-cloak>All admins</td>
                                        <td ng-if="value.productType == '<?php echo $data['reportProductType'];?>'">
                                            <a class="btn btn-small btn-success" ng-click="getSchedule(value.id)">Edit</a>
                                            <a class="btn btn-small btn-danger" ng-click="deleteScheduleConfirm(value.id, value.scheduleName)">Delete</a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
                        <a href="" class="btn btn-success" ng-click="createSchedule()">Create New Schedule</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!--modal ends -->
<!--modal start-->
    <div class="modal fade" id="createScheduleModal" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                            'ng-submit' => 'saveSchedule(search.userName,search.searchPolicyName)',
                            'class' => 'saveSchedule',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true,
                            'autocomplete' => 'off'
                            )); ?>
                            <div class="modal-header">
                                <h4 class="modal-title"><?=Language::show('Schedule Settings', 'keywords')?></h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                            <p>
                                                Any saved schedules will need at least 5 minutes to take effect
                                            </p>
                                        </div>
                                    </div>
                                </div>
				<div class="row">
<?php if($data['reportProductType'] == 'backup'){?>
<div class="form-group col-lg-6" id="policy1">
<label class="star" for="searchPolicyName">Policy Name</label>
                 <select class="form-control selectPicker searchPolicyName1" id="searchPolicyName1" name="searchPolicyName[]" multiple>
<option value="all" selected>all</option>
                     <?php if(!empty($data["backupPolicies"])) {?>
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
					</div>
<?php } ?>
<?php if($data['reportProductType'] == 'onedrive'){?>
<div class="form-group col-lg-6" id="searchODBPolicyNameBlock1">
<label class="star" for="searchODBPolicyName1">Policy Name</label>
                 <select class="form-control selectPicker" id="searchODBPolicyName1" name="searchODBPolicyName[]" multiple  title='Select OneDrive for Business Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["odbPolicies"])) {?>
                                                            <?php foreach($data['odbPolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
<?php } ?>
<?php if($data['reportProductType'] == 'exchange'){?>
<div class="form-group col-lg-6" id="searchExchangePolicyNameBlock1">
<label class="star" for="searchExchangePolicyName1">Policy Name</label>
                 <select class="form-control selectPicker" id="searchExchangePolicyName1" name="searchExchangePolicyName[]" multiple  title='Select Microsoft Exchange Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["exchangePolicies"])) {?>
                                                            <?php foreach($data['exchangePolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
<?php } ?>
<?php if($data['reportProductType'] == 'sharepoint'){?>
<div class="form-group col-lg-6" id="searchSharepointPolicyNameBlock1">
<label class="star" for="searchSharepointPolicyName1">Policy Name</label>
                 <select class="form-control selectPicker" id="searchSharepointPolicyName1" name="searchSharepointPolicyName[]" multiple  title='Select SharePoint Online Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["sharepointPolicies"])) {?>
                                                            <?php foreach($data['sharepointPolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
<?php } ?>
<div class="form-group col-lg-6">
                                        <label for="noOfDays1">Data Protection Scorecard for
                                        <input type="number" name="noOfDays1" class="form-control" id="noOfDays1" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:5px;" required> days </label>
                                    </div>
                                    <div class="form-group col-lg-12 d-none">
                                        <label for="createdBy"><?=Language::show('createdBy', 'keywords')?></label>
                                            <input type="text" class="form-control" name="createdBy" id="createdBy" placeholder="" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords')?></label>
                                        <input type="text" class="form-control" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label class="star" for="scheduleType">Schedule Type :</label>
                                        <select class="form-control" name="scheduleType" id="scheduleType">
                                            <option value="choiceDays"><?=Language::show('Days', 'settings')?></option>
                                            <option value="choiceMonths"><?=Language::show('Months', 'settings')?></option>
                                            <option value="choiceTime"><?=Language::show('Run Once', 'settings')?></option>
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group col-lg-12 choiceDays">
                                        <label  class="col-lg-12"><span class="star"><?=Language::show('days', 'keywords');?></span> -
                                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Every Day</a>
                                        <select class="form-control selectPickerSchedule" name="days[]" id="days" required="" multiple title="Select days">
                                            <option value="SUN"><?=Language::show('sunday', 'keywords')?></option>
                                            <option value="MON"><?=Language::show('monday', 'keywords')?></option>
                                            <option value="TUE"><?=Language::show('tuesday', 'keywords')?></option>
                                            <option value="WED"><?=Language::show('wednesday', 'keywords')?></option>
                                            <option value="THU"><?=Language::show('thursday', 'keywords')?></option>
                                            <option value="FRI"><?=Language::show('friday', 'keywords')?></option>
                                            <option value="SAT"><?=Language::show('saturday', 'keywords')?></option>
                                        </select>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceMonths" style="display:none;">
                                        <label class="col-lg-12"><span class="star"><?=Language::show('Month', 'keywords');?></span> -
                                        <a href="javascript:;" class="monthDaily" ng-click="toggleSelectPickerAllMonths()">Every Month</a>
					<div class="col-lg-12 row">
					    <div class="col-lg-6 form-group">
                                                <select class="form-control selectPickerScheduleMonth" name="months[]" id="months" multiple title='Select months'>
                                                    <option value="JAN"><?=Language::show('January', 'keywords')?></option>
                                                    <option value="FEB"><?=Language::show('February', 'keywords')?></option>
                                                    <option value="MAR"><?=Language::show('March', 'keywords')?></option>
                                                    <option value="APR"><?=Language::show('April', 'keywords')?></option>
                                                    <option value="MAY"><?=Language::show('May', 'keywords')?></option>
                                                    <option value="JUN"><?=Language::show('June', 'keywords')?></option>
                                                    <option value="JUL"><?=Language::show('July', 'keywords')?></option>
                                                    <option value="AUG"><?=Language::show('August', 'keywords')?></option>
                                                    <option value="SEP"><?=Language::show('September', 'keywords')?></option>
                                                    <option value="OCT"><?=Language::show('October', 'keywords')?></option>
                                                    <option value="NOV"><?=Language::show('November', 'keywords')?></option>
                                                    <option value="DEC"><?=Language::show('December', 'keywords')?></option>
                                                </select>
                                                </div>
                                            <div class="col-lg-6 form-group">
                                                <input type="number" min='1' max="31" class="form-control" name="dayOfMonth" id="dayOfMonth" placeholder="Enter Day of Month" disabled="disabled">
                                            </div>
                                        </div>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceTime" style="display:none;">
                                        <label class="col-lg-4"><span class="star"><?=Language::show('Run once', 'keywords');?></span>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="The schedule will be honored in the time zone under which the Parablu server is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <input type="text" class="form-control" name="date" id="date" placeholder="Enter Date" disabled="disabled">
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="scheduleStartTime"><?=Language::show('Schedule Time', 'keywords')?></label>
                                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                                    </div>
                                    <span class="d-none ownerFor" id="ownerFor"></span>
                                    <div class="col-lg-6">
                                            <input class="includeDetails1" id="includeDetails1" type="checkbox" name="includeDetails1">
                                            <label for="includeDetails1">Include Details</label>
                                    </div>
                                </div>
                                <div class="row usersFound" id="usersFound" style="display: none;">
                                    <div class="table-responsive col-lg-4 usersTable">
                                        <table class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th class="text-left clickAble" ng-click="currentBackupSortType = 'emailId'; sortReverse = !sortReverse">
                                                    <input type="checkbox" class="select-all checkbox d-none" name="select-all"/><?=Language::show('Administrators', 'keywords')?>
                                                    <span ng-show="currentBackupSortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                                    <span ng-show="currentBackupSortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td class="text-left">
                                                        <label style="cursor:pointer;"><input type="checkbox" class="select-item checkbox" name="allAdmins" id="allAdmins" value="All admins" ng-checked="value.allAdmins == 'true'"/> All admins </label>
                                                    </td>
                                                </tr>
                                                <tr ng-repeat="value in users | orderBy:currentBackupSortType:sortReverse" ng-click="itemSelect(value.emailId)">
                                                    <td class="text-left">
                                                        <label style="cursor:pointer;"><input type="checkbox" class="select-item checkbox" name="select-item_{{value.emailId}}" value="{{ value.emailId }}" ng-checked="value.isCheck == 'yes'"/>  {{ value.emailId | limitTo:20}}{{value.emailId.length > 20 ? '...' : ''}}</label>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group row">
                                            <label for="selectedUsers"><?=Language::show('Email reports to', 'keywords');?></label><br/>
                                            <input type="text" data-role="tagsinput" value="" class="form-control selectedUsers" name="selectedUsers[]" id="selectedUsers" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Selected Users', 'keywords');?>" required autocomplete="off">
                                            </div>
        
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success createScheduleBtn"><?=Language::show('Save', 'keywords')?></button>
                                <button type="button" id="closeScheduleModal" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                            </div>
                <?= Form::close(); ?>
                 </div>
        </div>
    </div>
<!--modal ends -->
<!--confirm modal start-->
<div class="modal fade confirmdelete" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                                <h4 class="modal-title">Are you sure you want to delete the selected schedule?</h4>

                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-default" ng-click="deleteSchedule()">Ok</button>
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->        
    <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<style>
@media (min-width: 1200px)
.col-lg-4 {
    width: 30.333333% !important;
}
</style>
<script>
$('.timePicker').timepicker({
        showMeridian: false,
//        defaultTime: '9:45'
    });
    $('.selectPickerSchedule').selectpicker('render');
    $('.selectPickerScheduleMonth').selectpicker('render');
    $('#scheduleType').selectpicker('render');
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});

var currentDate = new Date();
    //$('#date').datepicker('update', currentDate);
    
$('#scheduleType').on('change', function(){
    var choice = $('#scheduleType').val();
    if(choice == 'choiceDays'){
        $('.choiceDays').show();
        $('.choiceMonths').hide();
        $('.choiceTime').hide();
        $('#days').attr('required', 'required');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').prop('disabled', false);
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    } else if(choice == 'choiceTime') {
        $('.choiceTime').show();
        $('.choiceDays').hide();
        $('.choiceMonths').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#date').removeAttr('disabled');
        $('#days').removeAttr('required');
        $('#date').datepicker('update', currentDate);
        $('#days').prop('disabled', 'disabled');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    }else {
        $('.choiceMonths').show();
        $('.choiceDays').hide();
        $('.choiceTime').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').removeAttr('required');
        $('#days').prop('disabled', 'disabled');
        document.getElementById("months").disabled=false;
        $('#months').attr('required','required');
        $('#dayOfMonth').removeAttr('disabled');
        $('#dayOfMonth').attr('required','required');
    }
});
$('#date').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0m',
        //endDate: '-0d',
        todayHighlight: true
    });
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                item.checked = checked;
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
        });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                console.log("items"+items);
                console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            console.log("chhhhh");
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            console.log("all clicked");
            var usersSelected;
            var arr = $('input.select-item:checkbox:checked').map(function () {
                return this.value;
            }).get();
            usersSelected = arr;
                    $('.selectedUsers').tagsinput('removeAll');
            $('.selectedUsers').tagsinput('add', usersSelected.join());
        });
        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }


    });
    
    $("#closeScheduleModal").click(function() {
            $('#createScheduleModal').modal('hide');
            $('.select-item').prop('checked', false);
            if($('.reportProductType').val() == 'sharepoint'){
                    $('#searchSharepointPolicyName1').selectpicker('val', 'all');
            }
            if($('.reportProductType').val() == 'onedrive'){
                    $('#searchOnedrivePolicyName1').selectpicker('val', 'all');
            }
            if($('.reportProductType').val() == 'exchange'){
                    $('#searchExchangePolicyName1').selectpicker('val', 'all');
            }
            if($('.reportProductType').val() == 'backup'){
                    $('#searchPolicyName1').selectpicker('val', 'all');
            }
            $('#noOfDays1').val('');
    });
    
    (function(){
        $("#closeScheduleModal").on("hidden.bs.modal", function(){
            $(this).removeData();
        });
    });

    $('#productType').on('change', function(){
        var type = $('#productType').val();
        if(type == 'ODB'){
            $('.searchExchangePolicyNameBlock').hide();
            $('.searchSharepointPolicyNameBlock').hide();
            $('.searchODBPolicyNameBlock').show();
        }else if(type == 'Exchange'){
            $('.searchODBPolicyNameBlock').hide();
            $('.searchSharepointPolicyNameBlock').hide();
            $('.searchExchangePolicyNameBlock').show();
        }else{
            $('.searchSharepointPolicyNameBlock').show();
            $('.searchODBPolicyNameBlock').hide();
            $('.searchExchangePolicyNameBlock').hide();
        }
    });

/*    $(document).ready(function () {
  // Listen for change event on the multiple select dropdown
  $('#searchSharepointPolicyName').on('change', function () {
    // Get the selected values
    const selectedValues = $(this).val();

    // If "all" is not in the selected values and everything else is deselected
    if (!selectedValues || (selectedValues.length === 1 && selectedValues[0] !== 'all')) {
      // Select "all"
      $(this).val('all');
    }
  });
    });*/

    document.querySelector('.includeOption').addEventListener('click', function(event) {
    	event.stopPropagation();
    });

    </script>
<style>
.modal {
  overflow-y:auto;
}
</style>
