<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
          <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?="Dashboard"?></a></h3></li>
                <li><?='Capacity Savings Report'?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak" block-ui="myBlockUI">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='capacityManagementReport'?></span>
            <span class="reportProductType d-none"><?=$data['reportProductType']?></span>
<div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading"><h3><?='Capacity Savings Report'?></div>
                    <div class="panel-body"><div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="updateCapacityManagementReport()">
				    <div class="row">
<?php if($data['reportProductType'] == 'backup'){?>
                                        <div class="col-lg-3">
                                            <label for="searchPolicyName">Policy Name</label>
                                            <select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name'>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?>
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
<?php } ?>
<?php if($data['reportProductType'] == 'onedrive'){?>
                                        <div class="col-lg-3 searchODBPolicyNameBlock" id="searchODBPolicyNameBlock">
                                        <label for="searchODBPolicyName">OneDrive for Business Policy Name</label>
                                                <select class="form-control selectPicker" id="searchODBPolicyName" name="searchODBPolicyName[]" multiple  title='Select OneDrive for Business Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["odbPolicies"])) {?>
                                                            <?php foreach($data['odbPolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
<?php } ?>
<?php if($data['reportProductType'] == 'exchange'){?>
                                        <div class="col-lg-3 searchExchangePolicyNameBlock" id="searchExchangePolicyNameBlock">
                                                <label for="searchExchangePolicyName">Exchange Policy Name</label>
                                                <select class="form-control selectPicker" id="searchExchangePolicyName" name="searchExchangePolicyName[]" multiple  title='Select Microsoft Exchange Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["exchangePolicies"])) {?>
                                                            <?php foreach($data['exchangePolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
<?php } ?>
<?php if($data['reportProductType'] == 'sharepoint'){?>
                                        <div class="col-lg-3 searchSharepointPolicyNameBlock" id="searchSharepointPolicyNameBlock">
                                                <label for="searchSharepointPolicyName">SharePoint Online Policy Name</label>
                                                <select class="form-control selectPicker" id="searchSharepointPolicyName" name="searchSharepointPolicyName[]" multiple  title='Select SharePoint Online Policy Name'>
                                                        <option value="all" selected>all</option>
                                                        <?php if(!empty($data["sharepointPolicies"])) {?>
                                                            <?php foreach($data['sharepointPolicies'] as $value){
                                                                        $label = $value;
                                                                        if( strlen( $value ) > 25 ) {
                                                                           $label = substr( $label, 0, 25 ) . '...';
                                                                        }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                            </select>
                                        </div>
                                        <?php } ?>
                                        <div class="col-lg-3 hide">
                                            <label for="noOfDays">Assets not heard from in</label>
                                            <input type="number" id="noOfDays" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:5px;" value="30">
                                            <label style="margin-top:12px;">days </label>
                                        </div>                                           
                                        <div class="dropdown col-lg-4" style="margin-top:25px;">
                                            <button type="submit" class="btn btn-primary">View</button>
                                            <button class="btn btn-primary dropdown-toggle hide" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                            <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadAgentNotHeardReport(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadAgentNotHeardReportPdf(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">PDF</a><li>
                                            </ul>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <br/>
			<div class="table-responsive">			
			<table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
			<span class="pull-right" id="totalSavings" style="margin-bottom: 20px;">Total Savings: {{totalCpActualFileSize}}</span>
			  <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Asset Name', 'keywords')?>
                                    <span ng-show="lastAgentServerSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="lastAgentServerSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>                                
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Storage Savings', 'keywords')?>
                                    <span ng-show="lastAgentServerSortType == 'formatedTimeInMills' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="lastAgentServerSortType == 'formatedTimeInMills' && sortReverse" class="fa fa-caret-down"></span>
                                </th>                                
                            </tr>
                            </thead>
                            <tbody>
                            <tbody>
                            <tr ng-repeat="value in noBackup | orderBy:lastAgentServerSortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.cpActualFileSize }}</td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                    </div>
                    <div class="row noBackup" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <!--<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="updateAgentNotHeardNavigate(search.noOfDays,search.searchPolicyName,first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>-->
                            <a class="btn btn-primary previous" title="Previous" ng-click="updateAgentNotHeardNavigate(search.noOfDays,search.searchPolicyName,previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="updateAgentNotHeardNavigate(search.noOfDays,search.searchPolicyName,next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <!--<a class="btn btn-primary last" title="Last" ng-click="updateAgentNotHeardNavigate(search.noOfDays,search.searchPolicyName,last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<style>
@media (min-width: 1200px)
.col-lg-4 {
    width: 30.333333% !important;
}

.modal {
  overflow-y:auto;
}
.invalid{
  background-color: gainsboro !important;
  cursor:not-allowed !important;
  pointer-events:none !important;
}       
</style>
