<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){?>
                    <li>Storage Utilization By Server</li>
                <?php }else{ ?>
                    <li>Storage Utilization By Device</li>
                <?php }?>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='storageUtilized'?></span>
            <div class="row">
                <div class="panel">
                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){?>
                        <div class="panel-heading"><h3>Storage Utilization By Server</div>
                    <?php }else{ ?>
                        <div class="panel-heading"><h3>Storage Utilization By Device</div>
                    <?php }?>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateStorageUtilized('', search.deviceName, 0)" data-parsley-validate>
                                    <div class="">
                                        <select class="searchDeviceName" style="width: 25%;" id="deviceName" ng-model="search.deviceName" data-parsley-trigger="change" required></select>
                                        <button type="submit" class="btn btn-default">Generate Report</button>
                                        <a href="<?=Url::basePath('report/storageUtilizedByDevice')?>" class="btn btn-default">Show All</a>
                                        <a ng-click="exportToExcel('#StorageUtilizedDevice', 'Storage Utilized by Device', storageUtilized)" class="btn btn-default">Export To excel</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table id="StorageUtilizedDevice" class="table table-bordered storageUtilized" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                        <?=Language::show('Server', 'keywords')?>
                                    <?php }else{ ?>
                                        <?=Language::show('device', 'keywords')?>
                                    <?php } ?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('user', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="sortType = 'storageUsed'; sortReverse = !sortReverse">
                                    <?=Language::show('storageUsed', 'keywords')?>
                                    <span ng-show="sortType == 'storageUsed' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'storageUsed' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in storageUtilized | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <td ng-cloak>{{ value.userName }}</td>
                                <?php } ?>
                                <td ng-cloak>{{ value.storageUsed }}</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 storageUtilizedError text-center" style="display: none">No details found for Storage utilized by Device</div>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'restoreHistory')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'dd/mm/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
    $('#from').datepicker('update', '01/01/2015');
    $('#to').datepicker({
        format: 'dd/mm/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"device/searchDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){?>
        placeholder: 'Select Server'
        <?php }else{ ?>
        placeholder: 'Select Device'
        <?php }?>
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
