<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
use Helpers\Form;
 /*
 *
 * Copyright 2015 
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php 
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.5.5.3_7
 * @date 24-May-2024
 * @time 11:30 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3>MSP Provisioning</h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
	</div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='mspProvisioning'?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <div class="col-lg-12" block-ui="myBlockUI">
                                <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                        <div class="background"></div>
                                        <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Total Customers</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{customerListCount}}</span>
                                        </div>
                                </div>
                        </div>
                    </div>
                    <div class="panel-body table-responsive" id="licenseKeyList">
                        <div class="col-lg-12">
                            <h4>Customers List
                                <input type="text" id="searchCustomerInput" onkeyup="searchCustomer()" placeholder="Type in a Customer Name / Email Id" title="Search" style="width: 30%;margin-left: 20%;margin-top: -5px;border-radius: 10px;border: 1px solid #F27331!important;">
                                <span class="pull-right"><a ng-click="addNewCustomer()" class="btn btn-primary btn-small" title="Add New Customer" href="javascript:;">Add New Customer</a></span>
                            </h4>
<div class="customerListTableDiv" style="height: 500px;overflow-y: auto;border: 1px solid #ddd;margin: 20px;">
                            <table class="table table-bordered table-striped table-hover files-table customerListTable" id="customerListTable">
                        <thead style="background-color: #f9f9f9;position: sticky;top: -1px;z-index: 1;">
                        <tr>
                            <th class="text-left clickAble" ng-click="sortTypeCL = 'customerName'; sortReverseCL = !sortReverseCL">
				Customer Name
                                <span ng-show="sortTypeCL == 'customerName' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'customerName' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeCL = 'customerEmail'; sortReverseCL = !sortReverseCL">
                                Customer Email Id
                                <span ng-show="sortTypeCL == 'customerEmail' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'customerEmail' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeCL = 'active'; sortReverseCL = !sortReverseCL">
                                Active
                                <span ng-show="sortTypeCL == 'active' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'active' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeCL = 'suspend'; sortReverseCL = !sortReverseCL">
                                Suspended
                                <span ng-show="sortTypeCL == 'suspend' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'suspend' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'activationTimeStamp'; sortReverseCL = !sortReverseCL">
                                Customer added on
                                <span ng-show="sortTypeCL == 'activationTimeStamp' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'activationTimeStamp' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeCL = 'lastModified'; sortReverseCL = !sortReverseCL">
                                Customer last modified on
                                <span ng-show="sortTypeCL == 'lastModified' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'lastModified' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeCL = 'activationTimeStamp'; sortReverseCL = !sortReverseCL">
                                Action
                                <span ng-show="sortTypeCL == 'activationTimeStamp' && !sortReverseCL" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeCL == 'activationTimeStamp' && sortReverseCL" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
			<tbody>
			<tr ng-repeat-start="value in customerList | orderBy:sortTypeCL:sortReverseCL track by $index">
                            <td class="text-left clickAble" title="{{ value.customerName }}" ng-cloak><span ng-click="getCustomerInfo(value.customerId, value.customerName, 'onlyBaseInfo')" style="color:blue;text-decoration:underline;">{{ value.customerName  | limitTo:20 }}{{value.customerName.length > 20 ? '...' : ''}}</span></td>
                            <td class="text-left" title="{{ value.customerEmail }}" ng-cloak>{{ value.customerEmail }}</td>
                            <td class="text-left" ng-cloak>
                                <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.active == true">Yes</label><label style="width: 70px;" class="badge badge-danger" ng-if="value.active == false">No</label></h5>
                            </td>
                            <td class="text-left" ng-cloak>
                                <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.suspend == true">Yes</label><label style="width: 70px;" class="badge badge-danger" ng-if="value.suspend == false">No</label></h5>
                            </td>
                            <td class="text-left" ng-cloak>{{ value.activationTime}}</td>
                            <td class="text-left" ng-cloak>{{ value.lastModifiedTime}}</td>
                            <td class="text-left" ng-cloak><!--<a ng-click="modifyProvisioning(value.customerName, value.baseSubscriptionId)" class="btn btn-primary btn-small" title="Modify">Modify</a>--> <a class="btn btn-small btn-primary" title="Show Actions" id="showMore_{{value.customerId}}" ng-click="showActionsProvisioning(value.customerId)" style="border-radius: 20px;"><i class="fa fa-ellipsis-v fa-1x"></i></a></td>
                        </tr>
                        <tr style="display:none;" ng-repeat-end id="collapse{{value.customerId}}">
                            <td class="text-center" colspan="7" style="border:unset;border-bottom: 2px solid black;padding: 5px 15px 5px 15px;">
                                <a class="btn btn-primary btn-small changeBasePlanBtn{{$index}}" title="Change Base Plan" ng-click="modifyProvisioning(value.customerId, value.customerName, 'CHANGE_BASE_PLAN')" style="margin-right:10px;">Change Base Plan</a>
                                <a class="btn btn-primary btn-small activateAddOnBtn{{$index}}" title="Activate Add-On" ng-click="modifyProvisioning(value.customerId, value.customerName, 'ACTIVATE_ADDON')" style="margin-right:10px;">Activate Add-On</a>
                                <a class="btn btn-primary btn-small changeAddOnQuantityBtn{{$index}}" title="Change Add-On Quantity" ng-click="getCustomerInfo(value.customerId, value.customerName, 'addonInfo')" style="margin-right:10px;">Change Add-On Quantity</a>
                                <a class="btn btn-primary btn-small suspendBtn{{$index}}" title="Suspend" ng-click="performAction(value.customerId, value.customerName, 'SUSPEND')" style="margin-right:10px;">Suspend</a>
                                <a class="btn btn-primary btn-small resumeBtn{{$index}}" title="Resume" ng-click="performAction(value.customerId, value.customerName, 'RESUME')" style="margin-right:10px;">Resume</a>
                                <a class="btn btn-primary btn-small cancelBtn{{$index}}" title="Cancel" ng-click="performAction(value.customerId, value.customerName, 'CANCEL')" style="margin-right:10px;">Cancel</a>
                            </td>
                        </tr>
                        </tbody>
		    </table>
		    <div id="noResultsMessage" style="display:none;text-align: center;margin:20px;">No match found</div>
</div>
                        </div>
                     </div>

<!--add customer modal start-->
<div class="modal fade" id="addNewCustomer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'addCustomerForm',
                        'id' => 'addCustomerForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'addSingleCustomer()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                        <div class="modal-content mediumModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Add New Customer</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row col-lg-12">
                                    <div class="form-group col-lg-6">
                                        <label for="customerName"><?=Language::show('Customer Name', 'keywords')?></label>
                                        <input type="text" class="form-control" name="customerName" id="customerName" value="" placeholder="Enter Customer Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="userFirstName"><?=Language::show('Administrator First Name', 'keywords')?></label>
                                        <input type="text" class="form-control" name="userFirstName" id="userFirstName" value="" placeholder="Enter Administrator First Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="userLastName"><?=Language::show('Administrator Last Name', 'keywords')?></label>
                                        <input type="text" class="form-control" name="userLastName" id="userLastName" value="" placeholder="Enter Administrator Last Name" autocomplete="off">
                                    </div>
				    <div class="form-group col-lg-6">
					<label for="userEmail"><?=Language::show('Administrator Email', 'keywords')?></label>
                                        <input type="text" class="form-control" name="userEmail" id="userEmail" value="" placeholder="Enter Administrator Email" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="userPhoneNumber"><?=Language::show('Administrator Phone Number', 'keywords')?></label>
                                        <input type="text" class="form-control" name="userPhoneNumber" id="userPhoneNumber" value="" placeholder="Enter Administrator Phone Number" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="action"><?=Language::show('Action', 'keywords')?></label>
                                        <input type="text" class="form-control" name="action" id="action" value="Execute" placeholder="Enter Action" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="numQuantity"><?=Language::show('Quantity', 'keywords')?></label>
                                        <input type="number" class="form-control" name="numQuantity" id="numQuantity" value="1" min="1" max="100" placeholder="Enter Quantity" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="actionType"><?=Language::show('Action Type', 'keywords')?></label>
                                        <input type="text" class="form-control" name="actionType" id="actionType" value="ACTIVATE_BASE_PLAN" placeholder="Enter Action Type" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="skuCode"><?=Language::show('Select Plan', 'keywords')?></label>
                                        <select name="skuCode" id="skuCode" class="form-control skuCode"  title='Select Plan'>
                                                <option value="FR5" selected>FR5 (5 GB Storage for 1 User)</option>
                                                <option value="FR10" selected>FR10 (10 GB Storage for 2 Users)</option>
                                                <option value="FR20" selected>FR20 (20 GB Storage for 4 Users)</option>
                                                <option value="FR30" selected>FR30 (30 GB Storage for 6 Users)</option>
                                                <option value="FR40" selected>FR40 (40 GB Storage for 8 Users)</option>
                                                <option value="FR50" selected>FR50 (50 GB Storage for 10 Users)</option>
                                                <option value="MG100">MG100 (100 GB Storage for 5 Users)</option>
                                                <option value="MG250">MG250 (250 GB Storage for 10 Users)</option>
                                                <option value="MG500">MG500 (500 GB Storage for 20 Users)</option>
                                                <option value="MG1000">MG1000 (1 TB Storage for 40 Users)</option>
                                                <option value="MG2000">MG2000 (2 TB Storage for 80 Users)</option>
                                                <option value="UB100">UB100 (2.5 TB Storage for 100 Users)</option>
                                                <option value="UB250">UB250 (6.25 TB Storage for 250 Users)</option>
						<option value="UB500">UB500 (12.5 TB Storage for 500 Users)</option>
                                                <option value="UB1000">UB1000 (25 TB Storage for 1000 Users)</option>
                                                <option value="UB2500">UB2500 (62.5 TB Storage for 2500 Users)</option>
                                        </select>
                                    </div>
                            </div>
</div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveServer btn btn-success">Save</button>
                            </div>
                        </div>
                    <?= Form::close(); ?>
                </div>
    </div>
<!--add customer modal ends-->

<!--modify customer modal start-->
<div class="modal fade" id="modifyProvisioning" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'modifyProvisioningForm',
                        'id' => 'modifyProvisioningForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'modifyCustomer()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                        <div class="modal-content mediumModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Modify Customer - {{customerName}}</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row col-lg-12">
                                    <div class="form-group col-lg-6 currentSkuCodeMDiv">
					<label for="currentSkuCodeM"><?=Language::show('Current Plan', 'keywords')?></label>
                                        <select name="currentSkuCodeM" id="currentSkuCodeM" class="form-control currentSkuCodeM" title='Current Plan'>
                                                <option value="FR5" selected>FR5 (5 GB Storage for 1 User)</option>
                                                <option value="FR10" selected>FR10 (10 GB Storage for 2 Users)</option>
                                                <option value="FR20" selected>FR20 (20 GB Storage for 4 Users)</option>
                                                <option value="FR30" selected>FR30 (30 GB Storage for 6 Users)</option>
                                                <option value="FR40" selected>FR40 (40 GB Storage for 8 Users)</option>
                                                <option value="FR50" selected>FR50 (50 GB Storage for 10 Users)</option>
                                                <option value="MG100">MG100 (100 GB Storage for 5 Users)</option>
                                                <option value="MG250">MG250 (250 GB Storage for 10 Users)</option>
                                                <option value="MG500">MG500 (500 GB Storage for 20 Users)</option>
                                                <option value="MG1000">MG1000 (1 TB Storage for 40 Users)</option>
                                                <option value="MG2000">MG2000 (2 TB Storage for 80 Users)</option>
                                                <option value="UB100">UB100 (2.5 TB Storage for 100 Users)</option>
                                                <option value="UB250">UB250 (6.25 TB Storage for 250 Users)</option>
                                                <option value="UB500">UB500 (12.5 TB Storage for 500 Users)</option>
                                                <option value="UB1000">UB1000 (25 TB Storage for 1000 Users)</option>
                                                <option value="UB2500">UB2500 (62.5 TB Storage for 2500 Users)</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 existingAddOnsDiv">
                                        <label for="existingAddOns"><?=Language::show('Current Add-on(s) present ', 'keywords')?></label>
                                        <input type="text" data-role="tagsinput" value="" class="form-control" name="existingAddOns" id="existingAddOns" autocomplete="off"/>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="actionTypeM"><?=Language::show('Action Type', 'keywords')?></label>
                                        <select name="actionTypeM" id="actionTypeM" class="form-control actionTypeM"  title='Select Action Type'>
                                                <option value="CHANGE_BASE_PLAN">CHANGE BASE PLAN</option>
                                                <option value="ACTIVATE_ADDON">ACTIVATE ADDON</option>
                                                <option value="CHANGE_ADDON_QUANTITY">CHANGE ADDON QUANTITY</option>
                                                <option value="SUSPEND">SUSPEND</option>
                                                <option value="RESUME">RESUME</option>
                                                <option value="CANCEL">CANCEL</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="subscriptionID"><?=Language::show('Subscription ID', 'keywords')?></label>
                                        <input type="text" class="form-control" name="subscriptionID" id="subscriptionID" value="" placeholder="Enter Subscription ID" autocomplete="off" readonly>
				    </div>
                                    <div class="form-group col-lg-6 numQuantityMDiv">
                                        <label for="numQuantityM"><?=Language::show('Quantity', 'keywords')?></label>
                                        <input type="number" class="form-control" name="numQuantityM" id="numQuantityM" value="1" min="1" max="100" placeholder="Enter Quantity" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="actionM"><?=Language::show('Action', 'keywords')?></label>
                                        <input type="text" class="form-control" name="actionM" id="actionM" value="Execute" placeholder="Enter Action" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 skuCodeMDiv">
                                        <label for="skuCodeM"><?=Language::show('Select Plan', 'keywords')?></label>
                                        <select name="skuCodeM" id="skuCodeM" class="form-control skuCodeM"  title='Select Plan'>
                                                <option value="FR5" selected>FR5 (5 GB Storage for 1 User)</option>
                                                <option value="FR10" selected>FR10 (10 GB Storage for 2 Users)</option>
                                                <option value="FR20" selected>FR20 (20 GB Storage for 4 Users)</option>
                                                <option value="FR30" selected>FR30 (30 GB Storage for 6 Users)</option>
                                                <option value="FR40" selected>FR40 (40 GB Storage for 8 Users)</option>
                                                <option value="FR50" selected>FR50 (50 GB Storage for 10 Users)</option>
                                                <option value="MG100">MG100 (100 GB Storage for 5 Users)</option>
                                                <option value="MG250">MG250 (250 GB Storage for 10 Users)</option>
                                                <option value="MG500">MG500 (500 GB Storage for 20 Users)</option>
                                                <option value="MG1000">MG1000 (1 TB Storage for 40 Users)</option>
                                                <option value="MG2000">MG2000 (2 TB Storage for 80 Users)</option>
                                                <option value="UB100">UB100 (2.5 TB Storage for 100 Users)</option>
                                                <option value="UB250">UB250 (6.25 TB Storage for 250 Users)</option>
                                                <option value="UB500">UB500 (12.5 TB Storage for 500 Users)</option>
                                                <option value="UB1000">UB1000 (25 TB Storage for 1000 Users)</option>
                                                <option value="UB2500">UB2500 (62.5 TB Storage for 2500 Users)</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 skuCodeMPDiv" style="display:none;">
                                        <label for="skuCodeMP"><?=Language::show('Select Add-on', 'keywords')?></label>
                                        <select name="skuCodeMP" id="skuCodeMP" class="form-control skuCodeMP"  title='Select Add-on'>
                                                <option value="AD5U" selected>AD5U (Add-on 5 users on MG plan)</option>
                                                <option value="MGAD250" selected>MGAD250 (Add-on 250 GB on MG plan)</option>
                                                <option value="UBAD250" selected>UBAD250 (Add-on 250 GB on UB plan)</option>
						<option value="ADSER40" selected>ADSER40 (Add 1 Server with existing pooled data)</option>
                                                <option value="ADSER400" selected>ADSER400 (Add 1 Server with 500 GB addition to existing pooled data)</option>
                                        </select>
                                    </div>
                            </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveServer btn btn-success">Save</button>
                            </div>
                        </div>
                    <?= Form::close(); ?>
                </div>
    </div>
<!--modify customer modal ends-->

<!--customer info modal start-->
<div class="modal fade" id="customerInfo" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Details for {{customerName}}</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row col-lg-12">
                                        <div class="col-lg-12" ng-if="customerInfo.length <= 0">
                                                <p>No data available</p>
                                        </div>
                                        <div class="table-responsive" ng-if="customerInfo.length != 0">
<span><b>Base Pack Details</b></span>
                                            <table class="col-lg-12 table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td class="col-lg-3">
                                                            <span>SKU Name</span>
                                                        </td>
                                                        <td class="col-lg-9">
							    <span ng-cloak>{{ customerInfo.skuName }}</span>
                                                        </td>
                                                    <tr>
                                                    <tr>
                                                        <td class="col-lg-3">
                                                            <span>Subscription Id</span>
                                                        </td>
                                                        <td class="col-lg-9">
                                                            <span id="copyText" class="copytextarea1" ng-cloak><textarea class="col-lg-10 copytextarea" readonly>{{ customerInfo.baseSubscriptionId }}</textarea></span><a href="" class="textareacopybtn clickAble pull-right" title="Copy" style="margin-left: 5px;" ng-click="copyToClipboard()"><i class="fa fa-clipboard" aria-hidden="true"></i></a>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="col-lg-3">
                                                            <span>Active</span>
                                                        </td>
                                                        <td class="col-lg-9">
                                                            <span ng-cloak>{{ customerInfo.active }}</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="col-lg-3">
                                                            <span>Activated On</span>
                                                        </td>
                                                        <td class="col-lg-9">
                                                            <span ng-cloak>{{ customerInfo.activationTime }}</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="col-lg-3">
                                                            <span>Quantity</span>
                                                        </td>
                                                        <td class="col-lg-9">
                                                            <span ng-cloak>{{ customerInfo.numQuantity }}</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="col-lg-3">
							    <span>Number of Add-On(s)</span>
                                                        </td>
                                                        <td class="col-lg-9">
                                                            <span ng-cloak>{{ customerInfo.numberOfAddOns }}</span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
<!--collapse start-->
<span ng-if="addonList.length > 0"><b>List of Add-on(s)</b></span>
                                        <div class="col-lg-12">
                                <div class="panel-group" ng-repeat="value in addonList">
                                    <div class="panel panel-default" style="border: 1px dotted #f27331;">
                                      <div class="panel-heading">
                                        <h4 class="panel-title">
                                                <p><b><span>{{value.skuName }}</span></b>
                                                <a class="btn btn-small btn-primary pull-right" id="showdetails1_{{value.addonSubscriptionId}}" data-toggle="collapse" data-target="#collapse{{value.addonSubscriptionId}}" ng-click="showEvents1(value.addonSubscriptionId)" style="border-radius: 20px;">View Details</a>
                                                <a class="btn btn-small btn-danger pull-right" id="hidedetails1_{{value.addonSubscriptionId}}" ng-click="hidedetails1(value.addonSubscriptionId)" style="border-radius: 20px;display:none;">Hide details</a>
                                            </p>
                                        </h4>
                                      </div>
                                      <div id="collapse{{value.addonSubscriptionId}}" class="panel-collapse collapse">
                                        <div class="panel-body col-lg-12">
                                            <!--panel body start-->
                                            <div class="col-lg-12">
                                                <div id="eventsPanel" style="border: 1px solid #f27331;border-radius: 10px;margin-left:20px;">
                                                    <div class="row col-lg-12">
                                                        <!--events start-->
                                                        <div class="table-responsive col-lg-12" style="margin-top:20px;">
                                                        </hr>
                                                            <table id="CurrentEventtable" class="table table-bordered currentEventtable">
                                                                <tbody>
                                                                <tr class="text-left">
                                                                    <td ng-cloak>SKU Name</td>
                                                                    <td ng-cloak>{{ value.skuName}}</td>
                                                                </tr>
								<tr class="text-left">
                                                                    <td ng-cloak>Add-on Subscription Id</td>
                                                                    <td ng-cloak>{{ value.addonSubscriptionId}}</td>
                                                                </tr>
                                                                <tr class="text-left">
                                                                    <td ng-cloak>Active</td>
                                                                    <td ng-cloak>{{value.active}}</span></td>
                                                                </tr>
                                                                <tr class="text-left">
                                                                    <td ng-cloak>Activated On</td>
                                                                    <td ng-cloak>{{ value.activationTime}}</td>
                                                                </tr>
                                                                <tr class="text-left">
                                                                    <td ng-cloak>Number Quantity</td>
                                                                    <td ng-cloak>{{ value.numQuantity}}</td>
                                                                </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--panel body stop-->
                                        </div>
                                      </div>
                                  </div>
                            </div>
                         </div>
<!--collapse end-->
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <!--<button type="submit" class="saveServer btn btn-success">Save</button>-->
                            </div>
                        </div>
                </div>
    </div>
<!--customer info modal ends-->
<!--modify addon modal start-->
<div class="modal fade" id="modifyAddon" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Add-on Details for {{customerName}}</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row col-lg-12">
                                        <div class="col-lg-12" ng-if="addonList.length <= 0">
                                                <p>No data available</p>
                                        </div>
                                        <div class="table-responsive" ng-if="addonList.length != 0">
                                            <table class="col-lg-12 table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th class="text-left">SKU Name</th>
                                                        <th class="text-left">Activated On</th>
                                                        <th class="text-left">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr ng-repeat="value in addonList track by $index">
                                                        <td class="col-lg-4">
                                                            <span ng-cloak>{{ value.skuName }}</span>
                                                        </td>
                                                        <td class="col-lg-4">
                                                            <span ng-cloak>{{ value.activationTime }}</span>
                                                        </td>
                                                        <td class="col-lg-4">
                                                            <span ng-cloak><a id="changeQuantity_{{value.skuName}}" ng-click="changeQuantity(value.skuName)" class="btn btn-success btn-small" title="Edit">Edit</a>
<span id="control_{{value.skuName}}" style="display:none;"><a ng-click="reduce(value.skuName)" class="btn btn-danger btn-small" title="Reduce" style="margin:5px;"><i class="fa fa-minus fa-1x"></i></a><input id="num_{{value.skuName}}" type="number" min="0" value="1"/><a ng-click="add(value.skuName)" class="btn btn-success btn-small" title="Add" style="margin:5px;"><i class="fa fa-plus fa-1x"></i></a><a id="apply_{{value.skuName}}" ng-click="applyChangeQuantity(value.skuName)" class="btn btn-primary btn-small" title="Apply" style="margin:5px;">Apply</a><a id="cancel_{{value.skuName}}" ng-click="cancelQuantity(value.skuName)" class="btn btn-primary btn-small" title="Cancel" style="margin:5px;">Cancel</a></span>
</span>
                                                        </td>
                                                    <tr>
                                                </tbody>
                                            </table>
                                        </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <!--<button type="submit" class="saveServer btn btn-success">Save</button>-->
                            </div>
                        </div>
                </div>
    </div>
<!--modify addon modal ends-->
</div>
</div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<script>
$("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});

$('#validityPeriod').datepicker({
        format: 'dd-M-yyyy',
                autoclose: true,
                startDate: '-1y',
        endDate: '+1y',
        todayHighlight: true
});

$('#actionTypeM').on('change', function(){
        var type = $('#actionTypeM').val();
        if(type == 'CHANGE_BASE_PLAN'){
                $('.skuCodeMDiv').show();
                $('.skuCodeMPDiv').hide();
                $('.numQuantityMDiv').show();
        }else if(type =='ACTIVATE_ADDON' || type == 'CHANGE_ADDON_QUANTITY'){
                $('.skuCodeMDiv').hide();
                $('.skuCodeMPDiv').show();
                $('.numQuantityMDiv').show();
        }else{
                $('.skuCodeMDiv').hide();
                $('.skuCodeMPDiv').hide();
                $('.numQuantityMDiv').hide();
        }
});

    function searchCustomer() {
        var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
        input = document.getElementById("searchCustomerInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("customerListTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td1 = tr[i].getElementsByTagName("td")[0];
                td2 = tr[i].getElementsByTagName("td")[1];
                if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
                        //if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
                        if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
	// Show a message when no matches are found
	var noResultsMessage = document.getElementById("noResultsMessage");
        if (!foundMatch) {
                noResultsMessage.style.display = "block";
        } else {
                noResultsMessage.style.display = "none";
        }
    }

</script>
<style>
 .switch {
   position: relative;
   display: inline-block;
   width: 60px;
   height: 34px;
 }

 .switch input {display:none;}

 .slider {
   position: absolute;
   cursor: pointer;
   top: 0;
   left: 0;
   right: 0;
   bottom: 0;
   background-color: #ccc;
   -webkit-transition: .4s;
   transition: .4s;
 }

 .slider:before {
   position: absolute;
   content: "";
   height: 26px;
   width: 26px;
   left: 4px;
   bottom: 4px;
   background-color: white;
   -webkit-transition: .4s;
   transition: .4s;
 }
input:checked + .slider {
   background-color: #f27331;
 }
 input:focus + .slider {
   box-shadow: 0 0 1px #f27331;
 }

 input:checked + .slider:before {
   -webkit-transform: translateX(26px);
   -ms-transform: translateX(26px);
   transform: translateX(26px);
 }
 /* Rounded sliders */
 .slider.round {
   border-radius: 34px;
 }

 .slider.round:before {
   border-radius: 50%;
 }
 </style>

<style>
#progress-bar-win {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-win {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerWin{width:100%;text-align:center;}
td:nth-child(2) {
white-space: unset !important;
}
.bootstrap-tagsinput input{
display:none !important;
}
.bootstrap-tagsinput .tag [data-role="remove"]{
display:none !important;
}
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
</style>
