<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/spPolicies')?>"><?='SharePoint Online Policies'?></a></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('create_new_policy', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="d-none currentPage"><?='createPolicyOneDrive'?></span>
                    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
			'id' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreateOneDrive()',
                        'data-parsley-validate' => true
                    ));
                    ?>

                    <div class="row">
                        <div class="col-lg-7">
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" minlength="3" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed." autofocus>
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
				<textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter your policy description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512"></textarea>
				<input type="text" class="form-control hide" name="policyType" id="policyType" value="Sharepoint" required autocomplete="off">
                            </div>
			    <div class="form-group hide">
                             	<label for="noOfDevicesAllowed"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="<?=$data['noOfDevicesAllowed'];?>" data-parsley-type="integer" min="1" onfocusout="myFunctionDevice();"/>
                                <span id="deviceerror" style="color: #f55753;font-size: 0.9em;"></span>
                             </div>
                            </div>
                        </div>
<!-- Nav tabs -->
                    <!--<ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>-->
                    <!-- for mobile start-->
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
		      <li class="nav-item hide" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
			<?php if($data['uap_view'] == 'yes'){?>
		      <li class="nav-item hide" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
			<?php } ?>
			<?php if($data['searchEnabled'] == 'yes'){?>
			<li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#search" aria-expanded="false" aria-controls="advanced">Search</a></li>
			<?php } ?>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li class="nav-item" role="presentation"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li class="nav-item hide" role="presentation"><a href="" class="nav-link" data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
			<!--<li class="shareDetailsTab" role="presentation"><a data-target="#shareDetails" aria-controls="advanced" role="tab" data-toggle="tab">Secure Sharing</a></li>-->
			<?php if($data['uap_view'] == 'yes'){?>
			<li class="nav-item hide" role="presentation"><a href="" class="nav-link" data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
			<?php } ?>
			<?php if($data['searchEnabled'] == 'yes'){?>
			<li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#search" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
			<?php } ?>
                        <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
<!-- start -->
<div class="row">
                                <div class="col-lg-7">
                                    <br/>
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('backup_information', 'keywords')?> - for SharePoint Online Backup</legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;">Create New Schedule</a></label>
                                        <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['sch1'])){ ?>
                                                <?php foreach($data['sch1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox" checked>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="3" onfocusout="myFunctionVer()"/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
				    </div>
				    <div class="form-group d-none">
                                        <label class="col-lg-12" style="margin-left: -14px;"><?=Language::show('Backup all versions available in source', 'keywords');?></label>
                                        <div class="row">
                                                <div class="col-lg-2">
                                                        <label class="switch">
                                                                <input id="switchbackupAllVersions" type="checkbox" name="switchbackupAllVersions" value="true">
                                                                <div class="slider round"></div>
                                                        </label>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionMPS();" disabled/>
                                        <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
</div>
                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>d-none<?php } ?>">
					<label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('Per Site Backup Storage Limit', 'keywords');?> (In GB)</label>
<div class="row">
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox" checked>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="250" onfocusout="myFunctionUBS();"/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
</div>
<div class="form-group">
					 <span class="row" style="margin-left: 0px;"><p>Purge deleted files from the catalog after</p></span>
<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchpurgeDeletedFilesOlderThan" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="purgeDeletedFilesOlderThan" id="purgeDeletedFilesOlderThan"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionpurgeDeletedFilesOlderThan();" disabled/>
                                             <span id="sizepurgeDeletedFilesOlderThan" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
					 </div>
</div>
                                     </div>
                </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:45px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                            <td><a class="btn btn-default btn-small" ng-click="getParticularSchedule(value.scheduleName)">Edit</a></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
			    </div>
<div class="row <?php if($data['spArchivingEnabled'] != 'true'){?> d-none <?php } ?>">
			    	<div class="col-lg-7">
					<div class="panel-group" id="accordion">
					    <div>
						<h4 class="panel-title">
						  <a data-toggle="collapse" data-parent="#accordion" href="#collapse1" style="color: #000 !important;font-size:18px;">Archive documents from SharePoint Online if</a>
						  <span style="margin-left:10px;"><input type="checkbox" class="createLinkEnabled" id="createLinkEnabled" name="createLinkEnabled" value="enabled"/></span>
						</h4>
						<div id="collapse1" class="panel-collapse collapse in">
                                                        <div class="form-group row col-lg-12">
								<label for="threshholdLimit"><?=Language::show('Site consumption is higher than (%)', 'keywords');?></label>
								<div class="col-lg-10">
								<input type="number" class="form-control input-small" id="threshholdLimit" name="threshholdLimit" min="1" max="100" value="80">
								</div>
<div class="col-lg-2" style="margin-top:5px;">
                                             <label class="switch">
                                             <input id="includethreshholdLimit" name="includethreshholdLimit" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                                        </div>
                                                        <center><span>AND</span></center>
                                                        <div class="form-group row col-lg-12">
								<label for="purgeFilesOlderThan"><?=Language::show('Documents have not been modified in (days)', 'keywords');?></label>
								<div class="col-lg-10">
								<input type="number" class="form-control input-small" id="purgeFilesOlderThan" name="purgeFilesOlderThan" min="1" value="365" max="9131">
								</div>
<div class="col-lg-2" style="margin-top:5px;">
                                             <label class="switch">
                                             <input id="includepurgeFilesOlderThan" name="includepurgeFilesOlderThan" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                                        </div>
                                                        <center><span>AND</span></center>
                                                        <div class="form-group row col-lg-12">
								<label for="purgeFilesSizeGTThan"><?=Language::show('Documents are of size greater than (MB)', 'keywords');?></label>
								<div class="col-lg-10">
								<input type="number" class="form-control input-small" id="purgeFilesSizeGTThan" name="purgeFilesSizeGTThan" min="1" value="5">
								</div>
<div class="col-lg-2" style="margin-top:5px;">
                                             <label class="switch">
                                             <input id="includepurgeFilesSizeGTThan" name="includepurgeFilesSizeGTThan" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
					 </div>
<input type="number" class="form-control input-small hide" id="threshholdLimitOld" name="threshholdLimitOld">
<input type="number" class="form-control input-small hide" id="purgeFilesOlderThanOld" name="purgeFilesOlderThanOld">
<input type="number" class="form-control input-small hide" id="purgeFilesSizeGTThanOld" name="purgeFilesSizeGTThanOld">
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="d-none" for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker d-none" ng-model="osType" name="osType" id="osType" required="" title='Select OS Type'>
                                            <!--<option value="windows">Windows</option>
                                            <option value="mac">Mac</option>-->
                                            <option value="universal" selected>Universal</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackupOdb" name="defaultFoldersBackupOdb" id="defaultFoldersBackupOdb" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('inclusionError', 'keywords')?>" ng-keydown="$event.keyCode === 13 && searchItemOdb()" />
                                            <span class="input-group-btn">
                                        <button ng-click="addDefaultFolderOdb(defaultFoldersBackupOdb)" class="btn btn-default defaultFoldersBackupOdbBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                    </span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exclusionFolderName"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="exclusionFolderNameOdb" name="exclusionFolderNameOdb" id="exclusionFolderNameOdb" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>" ng-keydown="$event.keyCode === 13 && searchItemEOdb()"/>
                                            <span class="input-group-btn">
                                                <button type="button" ng-click="addExclusionFolderOdb(exclusionFolderNameOdb)" class="btn btn-default exclusionFoldersOdbBtn"><i class="fa fa-minus-circle"></i> <?=Language::show('exclude', 'keywords')?></button>
                                            </span>
                                        </div >
                                    </div>

                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div>
                                                        <ul class="list-group" ng-if="defaultUniversalFoldersOdb.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFoldersOdb track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolderOdb($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFoldersOdb.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div>
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversalOdb.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversalOdb track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> cliakAble" ng-click="removeExclusionFolderOdb($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversalOdb.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>  
                                </div>
			    </div>
<div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('filters', 'keywords')?> <a data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></label>
                                        <select class="form-control selectFilterTypePicker" name="filterType" id="filtersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<div class="row col-lg-12">
                                            <h5 class="col-lg-1 inclusionBadgeOdb" style="margin-top: 10px;"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                            <h5 class="col-lg-1 exclusionBadgeOdb" style="display:none;margin-top:10px;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <select class="col-lg-10 selectFilterPicker" name="filters[]" id="filters" required title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
					</div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:nowrap !important;">
                                                                <a ng-if="value.filterName !='all_files'" ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>" ng-bootbox-confirm-action="newFilterEdit(value.filterName)" ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
<!-- end -->			
                        <!--new exp end-->                            


                        </div>
                        <div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateAdmins" name="createUser[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Site Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Site Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>   
                                    </div>                                 
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Site Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedAdmins" name="deviceDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedReadonlyadmins" name="deviceDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Deleted', 'keywords');?></label>
                                        <select class="form-control deviceDeletedUsers" name="deviceDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                             
                                        <select class="form-control deviceBlockedAdmins" name="deviceBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceBlockedReadonlyadmins" name="deviceBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Blocked', 'keywords');?></label>
                                        <select class="form-control deviceBlockedUsers" name="deviceBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control deviceDecoupledAdmins" name="deviceDecoupled[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDecoupledReadonlyadmins" name="deviceDecoupled[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('Device de-couple', 'keywords');?></label>
                                        <select class="form-control deviceDecoupledUsers" name="deviceDecoupled[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedAdmins" name="deviceLimitReached[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedReadonlyadmins" name="deviceLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Limit Reached', 'keywords');?></label>
                                        <select class="form-control deviceLimitReachedUsers" name="deviceLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control weeklyBackupReportAdmins" name="weeklyBkpreport[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control weeklyBackupReportReadonlyadmins" name="weeklyBkpreport[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('Weekly backup report', 'keywords');?></label>
                                        <select class="form-control weeklyBackupReportUsers" name="weeklyBkpreport[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group"> 
                                        <select class="form-control firstBackupCompletedAdmins" name="firstBkpCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control firstBackupCompletedReadonlyadmins" name="firstBkpCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('First backup completed', 'keywords');?></label>
                                        <select class="form-control firstBackupCompletedUsers" name="firstBkpCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreInitiatedAdmins" name="restoreInitiated[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreInitiatedReadonlyadmins" name="restoreInitiated[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore initiated', 'keywords');?></label>
                                        <select class="form-control restoreInitiatedUsers" name="restoreInitiated[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control storageLimitReachedAdmins" name="storageLimitReached[]">
                                        <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                        <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control storageLimitReachedReadonlyadmins" name="storageLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <label><?=Language::show('Storage limit reached', 'keywords');?></label>
                                        <select class="form-control storageLimitReachedUsers" name="storageLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row d-none">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
				    <span class="help-line text-muted">Note:- These settings will have no effect for Exchange Online backup data.</span>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfiles" name="bkpfiles" id="bkpfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettings" name="bkpsettings" id="bkpsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                    
                                    <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restore" name="restore" id="restore" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicy" name="refbkppolicy" id="refbkppolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                        <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 row">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share hide">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group portalRestore">
                                            <label for="portalRestore"><?=Language::show('Restore', 'keywords');?></label>
                                            <select class="form-control portalRestore" name="portalRestore" id="portalRestore" required="" title='Select <?=Language::show('Restore', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row shareDetailsLabel hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>-->
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabled" name="highSecureShareEnabled" type="checkbox" value="enabled" checked>
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerCPBlock">
								<label class="switch">
									<input id="controllerCP" type="checkbox" name="controllerCP" value="true" checked>
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Complex Password</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerADBlock">
								<label class="switch">
									<input id="controllerAD" type="checkbox" name="controllerAD" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlock">
								<label class="switch">
									<input id="controllerED" type="checkbox" name="controllerED" value="true" checked>
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Require Expiration Date for shared data</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerMFABlock">
								<label class="switch">
									<input id="controllerMFA" type="checkbox" name="controllerMFA" value="true" checked>
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Enable multi-factor authentication</span>
						</div>
					</div>
				   </div>                                    
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="search">
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                    <a style="font-size:14px !important;" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == 'no'){?> style="pointer-events:none;"<?php } ?>>
                                            <label for="contentIndexEnabled"><?=Language::show('Content Index', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == 'no'){?> readonly <?php } ?>>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Content Index Filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="d-none" for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble d-none" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label><br>
<!--                                        <select class="form-control selectSearchFilterTypePicker" ng-model="searchfiltersType" id="searchfiltersType" title='Select Filter Type'>-->
					<select class="form-control selectSearchFilterTypePicker" name="searchFilterType" id="searchfiltersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
					</select>
				    </div>
                                    <div class="row col-lg-12">
                                        <h5 class="col-lg-1 inclusionBadgeCS" style="margin-top: 10px;"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                        <h5 class="col-lg-1 exclusionBadgeCS" style="display:none;margin-top:10px;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
					<select class="col-lg-10 form-control selectSearchFilterPicker" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple <?php if($data['searchEnabled'] == 'yes'){ ?> required <?php } ?>>
                                           <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                    <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSearchFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:nowrap !important;">
                                                                <a ng-if="value.filterName !='all_files'" ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>" ng-bootbox-confirm-action="newFilterEdit(value.filterName)" ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            </br>
                            <div class="row d-none">
                                <div class="col-lg-7">
                                    <legend class="h4 d-none" style="color: #585f69;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group partial d-none">
                                        <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunction();" disabled/>
                                            <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>-->
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
                                              </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="500" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                
                                </div>
                                <div class="col-lg-5 d-none">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default" style="margin-top:30px;">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="9" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="8" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                
                                
                            </div>
                            
                            <div class="row">
                                <div class="col-lg-7">
				    <legend class="h4" style="color: #585f69;"><?=Language::show('options', 'keywords')?></legend>
				    <div class="col-lg-12 row hide">
                                        <div class="col-lg-1">
                                                <label class="switch">
                                                        <input id="legalHold" type="checkbox" name="legalHold" value="true">
                                                        <div class="slider round"></div>
                                                </label>
                                        </div>
                                        <span class="col-lg-11">Legal Hold</span>
                                    </div>
                                    <div class="form-group hide">
                                        <div class="checkbox check-primary">
                                            <!--<input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>-->
                                            <!--<a href="#" data-toggle="tooltip" data-placement="top" title="If checked then dependent parameters get changed."><i class="fa fa-question-circle" aria-hidden="true"></i></a>-->
                                            <span class="systemFolders1" style="display: none;">
                                                <input id="systemFolders1" name="systemFolders" type="checkbox" value="enabled">
                                                <label for="systemFolders1"><?=Language::show('systemFolders', 'keywords');?></label>
                                            </span>
                                        </div>
				    </div>
				    <div class="form-group col-lg-12 hide" style="padding-left:0%;" id="BlukryptipaddressDiv">
                                        <label for="blukryptIPAdress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                            <?php if(!empty($data['pgs'])){ ?>
                                                    <select class="blukryptIPAdress" name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                        <?php foreach($data['pgs'] as $key => $value){ ?>
                                                            <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                        <?php } ?>
                                                    </select>

                                            <?php } ?>
                                    </div>
                                    <div class="form-group col-lg-12 <?php if($data['bk_view'] == 'no'){?> d-none <?php } ?>" style="padding-left:0%;">
                                        <label for="msAppBluKrypt"><?=Language::show('M365 Backup Agent', 'keywords');?></label>
                                        <select class="msAppBluKrypt" name="msAppBluKrypt" id="msAppBluKrypt" style="width: 100%" <?php if($data['onedriveBackupEnabled'] == 'true'){ echo 'required';}?>>
                                            <?php foreach($data['cons'] as $key => $value){ ?>
                                                <option  value="<?=$value['host']?>"><?=$value['host']?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>
				    <div class="form-group hide" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminRestore"><?=Language::show('Can Administrator Restore User Data', 'keywords');?></label>
                                        <select class="form-control canAdminRestore" name="canAdminRestore" id="canAdminRestore" required="" title='Select <?=Language::show('Can Admin Restore', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminDelete"><?=Language::show('Can Administrator Delete User Data', 'keywords');?></label>
                                        <select class="form-control canAdminDelete" name="canAdminDelete" id="canAdminDelete" required="" title='Select <?=Language::show('Can Admin Delete', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } else { ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <div class="form-group d-none">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainer d-none" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg d-none">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY" selected><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
<!--                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                            <?php if(!empty($data['pgs'])){ ?>
                                                    <select class="blukryptIPAdress" name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                        <?php foreach($data['pgs'] as $key => $value){ ?>
                                                            <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                        <?php } ?>
                                                    </select>
                                                    
                                            <?php } ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="msAppBluKrypt"><?=Language::show('M365 Backup Agent', 'keywords');?></label>
                                        <select class="msAppBluKrypt" name="msAppBluKrypt" id="msAppBluKrypt" style="width: 100%" required="">
                                            <?php foreach($data['cons'] as $key => $value){ ?>
                                                <option  value="<?=$value['host']?>"><?=$value['host']?></option>
                                            <?php } ?>
                                        </select>
                                    </div>-->
                                    <div class="form-group d-none">
                                        <label for="ccS"><?=Language::show('ccS', 'keywords');?> - <a class="clickAble" ng-click="addNewCcS()">Add Cloud Credentials</a></label>
                                        <select class="form-control selectCcSPicker" ng-model="ccSs"  name="ccS" id="ccS" title='Select <?=Language::show('ccS', 'keywords')?>'>
                                            <?php if(!empty($data['ccS'])){ ?>
                                                <?php foreach($data['ccS'] as $key => $value){ ?>
                                                    <option value="<?=$value->{'identity'}?>"><?=$value->{'identity'}?></option>
                                                <?php } ?>
                                            <?php }else{ ?>
                                                <option selected disabled>Please Add A Cloud Credential</option>
                                            <?php } ?>
                                        </select>
                                    </div>                        
                                    <div class="form-group hide">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" value="4" min="1" max="23" required="">
				    </div>
<div class="form-group d-none">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cpuThrottling"><?=Language::show('CPU Throttling', 'keywords');?></label></br>
                                            <div class="""slidecontainer">
                                              <input type="range" min="1" max="10" value="5" name="cpuThrottling" class="slidercpu" id="myRange">
                                              <p>Value: <span id="demo"></span></p>
                                            </div>
                                    </div>
                                    <div class="form-group d-none">
                                       <label for="canBackupHiddenFiles"><?=Language::show('canBackupHiddenFiles', 'keywords');?></label>
                                       <select class="form-control canBackupHiddenFiles" name="canBackupHiddenFiles" id="canBackupHiddenFiles" required="" title='Select <?=Language::show('canBackupHiddenFiles', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div>
                                    <div style="padding-left:3%;" class="form-group row d-none">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="switchFairnessAlgorithm" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input type="number" class="form-control" min="0" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup"  autocomptocomplete="off" value="0" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                   <div class="form-group d-none">
                                       <label for="downloadAgent"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <a href="#" data-toggle="tooltip" data-placement="top" title="Relogin on portal is required"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                    <div class="form-group d-none">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                            <div class="row d-none">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Environment Level Password Enforcement  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Go to Global settings to enable this option."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">
                            <!--<button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>-->
                            <a ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to continue?', 'keywords')?></h4>"
                                ng-bootbox-confirm-action="policyCreateOneDrive()"
                                ng-bootbox-confirm-action-cancel="" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/spPolicies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createCcS" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                    'ng-submit' => 'saveCloudCredentials(true)',
                    'class' => 'cloudCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
		    <h4 class="modal-title">Create a new CcS</h4>
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-12">
                            <label for="cloudType">Cloud Type</label>
                            <select class="form-control" name="cloudType" id="cloudType">
                                <option value="azureBlob">Azure Blob</option>
                                <option value="ibmCloud">IBM Cloud</option>
                                <option value="amazon">Amazon s3 Services</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="identity">Identity</label>
                            <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="Enter your cloud identity" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="accessKey">Access key</label>
                            <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="Enter your access key" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 epaUrl" style="display: none;">
                            <label for="epaUrl">End Point Url</label>
                            <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="Enter your End Point Agent URL" autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 containerName" style="display: none;">
                            <label for="containerName">Amazon Container Name</label>
                            <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="Enter your Amazon Container Name" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade" id="confirmAdd" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addDefaultFolderConfirm(defaultFoldersBackup)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
    </div>
            <div class="modal fade" id="confirmAdd1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirm(exclusionFolderName)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
	    </div>
<div class="modal fade" id="confirmOdb" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addDefaultFolderConfirmOdb(defaultFoldersBackupOdb)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
    </div>
<div class="modal fade" id="confirmMail" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addDefaultFolderConfirmMail(defaultFoldersBackupMail)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
    </div>
            <div class="modal fade" id="confirmAddOdb1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirmOdb(exclusionFolderNameOdb)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <div class="modal fade" id="confirmAddMail1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirmMail(exclusionFolderNameMail)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
<!--odb sch start-->
<div class="modal fade createSchedule" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleCreateForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <h4 id="addSchedule_title" class="modal-title">Create Schedule</h4>
		    <h4 id="editSchedule_title" class="modal-title" style="display: none;">Edit Schedule</h4>
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked d-none" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="active" style="display:unset !important;"><a data-toggle="tab" data-target="#general1" aria-expanded="true" aria-controls="general">General</a></li>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#advanced1" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs d-none" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="active"><a data-target="#general1" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#advanced1" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general1">
				            <br>
                            <div class="form-group">
                                <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                                <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
                            </div>
                            <div class="form-group d-none">
                                <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                                <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group">
                                <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                            </div>
                            <div class="form-group">
                                <label for="days"><?=Language::show('days', 'keywords');?></label>
                                <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                                <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                                    <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                    <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                    <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                    <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                    <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                    <option value="6"><?=Language::show('friday', 'keywords')?></option>
                                    <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                                </select>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced1">
                            </br>
                            <div class="form-group backupTypeForm">
                                <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                                <select class="form-control backupType" name="backupType" id="backupType" required>
                                    <option value="FULL">Full</option>
                                    <option value="INCR" selected>Incremental</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="addSchedule_save">Save changes</button>
                    <a class="btn btn-primary pull-right" id="editSchedule_save" ng-click="scheduleSavePolicy()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
<!--odb sch end-->
<!--Mail sch start-->
<div class="modal fade createScheduleMail" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleCreateFormMail',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreateMail(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <h4 id="addSchedule_titleMail" class="modal-title">Create Schedule</h4>
		    <h4 id="editSchedule_titleMail" class="modal-title" style="display: none;">Edit Schedule</h4>
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked d-none" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="active" style="display:unset !important;"><a data-toggle="tab" data-target="#general1" aria-expanded="true" aria-controls="general">General</a></li>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#advanced1" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs d-none" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="active"><a data-target="#general1" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#advanced1" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
</ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general1">
                                            <br>
                            <div class="form-group">
                                <label for="scheduleNameMail"><?=Language::show('scheduleName', 'keywords');?></label>
                                <input type="text" class="form-control" value="" name="scheduleNameMail" id="scheduleNameMail" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
                            </div>
                            <div class="form-group d-none">
                                <label for="scheduleTimeZoneMail"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                                <input type="text" class="form-control" name="scheduleTimeZoneMail" id="scheduleTimeZoneMail" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group">
                                <label for="scheduleStartTimeMail"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="text" class="form-control timePicker input-small" id="scheduleStartTimeMail" name="scheduleStartTimeMail" required>
                            </div>
                            <div class="form-group">
                                <label for="daysMail"><?=Language::show('days', 'keywords');?></label>
                                <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                                <select class="form-control selectPicker" name="daysMail[]" id="daysMail" required="" multiple title='Select days'>
                                    <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                    <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                    <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                    <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                    <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                    <option value="6"><?=Language::show('friday', 'keywords')?></option>
				    <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                                </select>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced1">
                            </br>
                            <div class="form-group backupTypeForm">
                                <label for="backupTypeMail"><?=Language::show('Backup Type', 'keywords');?></label>
                                <select class="form-control backupTypeMail" name="backupTypeMail" id="backupTypeMail" required>
                                    <option value="FULL">Full</option>
                                    <option value="INCR" selected>Incremental</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="addSchedule_saveMail">Save changes</button>
                    <a class="btn btn-primary pull-right" id="editSchedule_saveMail" ng-click="scheduleSavePolicyMail()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>

<div class="modal fade createFilter" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                     <h4 id="add_title" class="modal-title">Create Filter</h4>
		     <h4 id="edit_title" class="modal-title" style="display: none;">Edit Filter</h4>
		     <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
                    </div>
                    <div class="form-group d-none">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filterTemplate"><?=Language::show('Select Filter Template', 'keywords')?></label>
                        <select class="form-control selectFilterTemplatePickerPolicy" name="filterTemplate[]" id="selectFilterTemplatePickerPolicy" title='Select Filters template' multiple>
<?php if(!empty($data['filCanned'])){ ?>
                                                <?php foreach($data['filCanned'] as $key => $value){ ?>
                                                    <?php $label = $value;
                                                                if( strlen( $value ) > 50 ) {
                                                                   $label = substr( $label, 0, 50 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                        <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of extensions"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        <br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="add_save" class="btn btn-primary pull-right">Save changes</button>
                    <a class="btn btn-primary pull-right" id="edit_save" ng-click="filterSavePolicy()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
</div>
        </div>
    </div>

<div class="modal fade createFilterMail" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterFormMail',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreateMail(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                     <h4 id="add_titleMail" class="modal-title">Create Filter</h4>
		     <h4 id="edit_titleMail" class="modal-title" style="display: none;">Edit Filter</h4>
		     <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterNameMail"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterNameMail" id="filterNameMail" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
                    </div>
                    <div class="form-group d-none">
                        <label for="filterTypeMail"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterTypeMail" name="filterTypeMail" id="filterTypeMail" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filterTemplate"><?=Language::show('Select Filter Template', 'keywords')?></label>
                        <select class="form-control selectFilterTemplatePickerPolicyMail" name="filterTemplateMail[]" id="selectFilterTemplatePickerPolicyMail" title='Select Filters template' multiple>
<?php if(!empty($data['filCanned'])){ ?>
                                                <?php foreach($data['filCanned'] as $key => $value){ ?>
                                                    <?php $label = $value;
                                                                if( strlen( $value ) > 50 ) {
                                                                   $label = substr( $label, 0, 50 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                        <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of extensions"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        <br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFiltersMail" name="filtersMail[]" id="editFiltersMail" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="add_saveMail" class="btn btn-primary pull-right">Save changes</button>
                    <a class="btn btn-primary pull-right" id="edit_saveMail" ng-click="filterSavePolicyMail()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
</div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
	$('.selectFilterPicker').selectpicker('render');
    	$('.selectofficeProductType').selectpicker('render');
	$('.selectFilterTemplatePickerPolicy').selectpicker('render');
	$('.selectFilterTemplatePickerPolicyMail').selectpicker('render');
    	$('#fullBackupStartDate').prop("readonly", true);
	$('.filterType').selectpicker('render');
	$('.filterTypeMail').selectpicker('render');
        $('.selectSearchFilterPicker').selectpicker('render');
        $('.compEnabled').selectpicker('render');
        $('.selectCcSPicker').selectpicker('render');
        $('.selectSchedulePicker').selectpicker('render');
        $('.vssEnabled').selectpicker('render');
        $('.selectOsTypePicker').selectpicker('render').on('change', function(){
        if($('.selectOsTypePicker').val() == 'windows'){
            $('.vssContainer').show();
        }else if($('.selectOsTypePicker').val() == 'universal'){
                $('.vssContainer').show();
        }
        else{
            $('.vssContainer').hide();
        }
    });
    $('.dedup').selectpicker('render');
    $('.fullBackupEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render')
        .on("change", function(event){
            if($('.incrementalFileTransfer').val() == 'false'){
                $('.partialfileattributerow').addClass('hide');
                $('#partialFileSize').attr('disabled', 'disabled')
                $('#fileChunkableSize').attr('disabled', 'disabled')
            }else{
                $('.partialfileattributerow').removeClass('hide');
                $('#partialFileSize').removeAttr('disabled', 'disabled')
                $('#fileChunkableSize').removeAttr('disabled', 'disabled')
            }
        });
    $('.networkThrottling').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
    $('.backupDatePicker').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#fullBackupEnabled').on('change', function(){
        var option = $('#fullBackupEnabled').val();
        if(option == 'true'){
            $('.backupDate').show();
            $('[name="fullBackupStartDate"').attr('required', 'required');
        }else{
            $('.backupDate').hide();
        }
    });
    $('#sortAlgoForPg').on('change', function(){
        var option = $('#sortAlgoForPg').val();
        if(option == 'PRIORITY'){
		$('#Blukryptipaddress').attr('required', 'required');
		$('#BlukryptipaddressDiv').show();
        }else{
		$('#Blukryptipaddress').removeAttr('required', 'required');
		$('#BlukryptipaddressDiv').hide();
        }
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker();
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.containerName').show();
            $('[name="containerName"').attr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.epaUrl').show();
            $('[name="epaUrl"').attr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }else{
            $('.epaUrl').hide();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }
    });
    $('.Share').on('change', function(){
        if($('#Share').val() == 'true'){
            $('.shareDetailsLabel').show();
            $('.highSecuredShareOptions').show();
            $('.highSecureShareEnabled').show();
        }else{
            $('.shareDetailsLabel').hide();
            $('.highSecuredShareOptions').hide();
            $('.highSecureShareEnabled').hide();
        }
    });
    $('#highSecureShareEnabled').on('change', function(){
        var checked = document.getElementById('highSecureShareEnabled').checked;
        if(checked){
            $('.controllerCPBlock').css('pointer-events','none');
            $('.controllerADBlock').css('pointer-events','none');
            $('.controllerEDBlock').css('pointer-events','none');
            $('.controllerMFABlock').css('pointer-events','none');

            document.getElementById('controllerED').checked=true;
            document.getElementById('controllerCP').checked=true;
            document.getElementById('controllerAD').checked=false;               
            document.getElementById('controllerMFA').checked=true;
        }else{
            $('.controllerCPBlock').css('pointer-events','');
            $('.controllerADBlock').css('pointer-events','');
            $('.controllerEDBlock').css('pointer-events','');
            $('.controllerMFABlock').css('pointer-events','');

            document.getElementById('controllerED').checked=false;
            document.getElementById('controllerCP').checked=true;
            document.getElementById('controllerAD').checked=true;            
            document.getElementById('controllerMFA').checked=false;
        }
    });

</script>

<script type="text/javascript">
    $(".blukryptIPAdress").select2();

    $(".blukryptIPAdress").on("select2:select", function (evt) {
        var element = evt.params.data.element;
        var $element = $(element);

        $element.detach();
        $(this).append($element);
        $(this).trigger("change");
        //$('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
    });
</script>
<script>
    $('.timePicker').timepicker({
        showMeridian: false
    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 22px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 3px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    /*$("#switch").click(function(){
        document.getElementById("switcherror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPG').removeAttr('disabled'); //enable input
        $('#nwFromClientToPG').val('');
        
    } else {
        
        $('#nwFromClientToPG').attr('disabled', true); //disable input
        $('#nwFromClientToPG').val('UNLIMITED');
    }
        });*/

        
    $("#switchFairnessAlgorithm").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
            $('#daysToWaitForNextBackup').removeAttr('disabled'); //enable input
            $('#daysToWaitForNextBackup').val('0');
        }else {
            $('#daysToWaitForNextBackup').attr('disabled', true); //disable input
            $('#daysToWaitForNextBackup').val('0');
        }
    });
</script>

<script>
    /*function myFunction(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPG').val()))
        {
        if (  $('#nwFromClientToPG').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPG').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
         else if($('#nwFromClientToPG').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }*/
    
    function myFunctionMPS(){
        document.getElementById("sizeerror").innerHTML = "";
        if(isNaN($('#maxPermissibleFileSize').val()))
        {
        if (  $('#maxPermissibleFileSize').val() !='UNLIMITED')  {
            document.getElementById("sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if($('#maxPermissibleFileSize').val() < 1){
             document.getElementById("sizeerror").innerHTML = "Minimum File Size Allowed is 1";
         }
         else if(!isNaN($('#maxPermissibleFileSize').val()) && $('#maxPermissibleFileSize').val() > 999999){
             document.getElementById("sizeerror").innerHTML = "Maximum Permissible File Size Allowed is 999999";
         }
         else if($('#maxPermissibleFileSize').val().indexOf(".")!=-1){
            document.getElementById("sizeerror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("sizeerror").innerHTML = "";
        }
    }
    
    function myFunctionUBS(){
        document.getElementById("limiterror").innerHTML = "";
        if(isNaN($('#perUserBackupStorageLimit').val()))
        {
        if (  $('#perUserBackupStorageLimit').val() !='UNLIMITED')  {
            document.getElementById("limiterror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
         else if($('#perUserBackupStorageLimit').val() < 1){
             document.getElementById("limiterror").innerHTML = "Minimum Per User Backup Storage Limit Allowed is 1";
         }
        else if(!isNaN($('#perUserBackupStorageLimit').val()) && $('#perUserBackupStorageLimit').val() > 99999){
             document.getElementById("limiterror").innerHTML = "Maximum Per User Backup Storage Limit Allowed is 99999";
         }
         else if($('#perUserBackupStorageLimit').val().indexOf(".")!=-1){
            document.getElementById("limiterror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("limiterror").innerHTML = "";
        }
    }

    function myFunctionVer(){
        document.getElementById("vererror").innerHTML = "";
        if(isNaN($('#maxVersions').val()))
        {
            if (  $('#maxVersions').val() !='UNLIMITED')  {
                document.getElementById("vererror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() < 1){
            document.getElementById("vererror").innerHTML = "Minimum number of Versions Allowed is 1";
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() > 10000000){
            document.getElementById("vererror").innerHTML = "Maximum number of Versions Allowed is 1 Crore";
        }
        else{
            document.getElementById("vererror").innerHTML = "";
        }
    }

    function myFunctionMB(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPGMB').val()))
        {
        if (  $('#nwFromClientToPGMB').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPGMB').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
         else if($('#nwFromClientToPGMB').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }
    
    $(".liteVersion").addClass("disabledbutton");
    $("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});
    
    $("#switch").click(function(){
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPGMB').removeAttr('disabled','disabled'); //enable input
        $('#nwFromClientToPGMB').val('4');
        $('#networkThrottlingUnit').removeAttr("disabled","disabled");
        
    } else {
        
        $('#nwFromClientToPGMB').attr('disabled', true); //disable input
        $('#nwFromClientToPGMB').val('UNLIMITED');
        $('#networkThrottlingUnit').attr("disabled","disabled");
        $('.networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
    }
        });
        
    /*$('html').bind('keypress', function(e)
    {
       if(e.keyCode == 13)
       {
          return false;
       }
    });*/
    
   $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
        $('#scheduleName').removeAttr('readonly', 'readonly');
        });

        $('.createFilter').on('hidden.bs.modal', function(){
        $('#filterName').removeAttr('readonly', 'readonly');
        });

    });
    
    $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
            $('#addSchedule_title').removeClass("d-none");
            $('#editSchedule_title').removeClass("d-block");
            $('#addSchedule_save').removeClass("d-none");
            $('#editSchedule_save').removeClass("d-block");
        });
        $('.createFilter').on('hidden.bs.modal', function(){
            $('#add_title').removeClass("d-none");
            $('#edit_title').removeClass("d-block");
            $('#add_save').removeClass("d-none");
            $('#edit_save').removeClass("d-block");
        });
    });

    $( document ).ready(function() {
        $('tr > ul').addClass('d-none');
    });

    $(".acc").click(function(){
        $(".aa").toggleClass("hide");
        $(".bb").toggleClass("show");
        $('.currentBackupText').toggleClass('d-none');
    });

    $(".bb").click(function(){
        $('.currentBackupText').toggleClass('d-block');
    });
</script>
<style>
.slidecontainer {
    width: 100%;
}

.slidercpu {
    -webkit-appearance: none;
    width: 100%;
    height: 15px;
    border-radius: 5px;
    background: #d3d3d3;
    outline: none;
    opacity: 0.7;
    -webkit-transition: .2s;
    transition: opacity .2s;
}

.slidercpu:hover {
    opacity: 1;
}

.slidercpu::-webkit-slider-thumb {
    -webkit-appearance: none;
appearance: none;
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #2196F3;
    cursor: pointer;
}

.slidercpu::-moz-range-thumb {
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #2196F3;
    cursor: pointer;
}
</style>
<script>
var slider = document.getElementById("myRange");
var output = document.getElementById("demo");
output.innerHTML = slider.value;

slider.oninput = function() {
  output.innerHTML = this.value;
}

$('#officeProductType').on('change', function(){
    var option = $('#officeProductType').val();
    if(option == 'OUTLOOK'){
        $('.maxVersionsDiv').addClass('d-none');
        $('.Versions').addClass('d-none');
        $('.Share').addClass('d-none');
        $('.shareDetailsLabel').addClass('d-none');
    }else{
        $('.maxVersionsDiv').removeClass('d-none');
        $('.Versions').removeClass('d-none');
        $('.Share').removeClass('d-none');
        $('.shareDetailsLabel').removeClass('d-none');
    }
});
$("#switchAllowedDomains").click(function(){
      if ($(this).is(':checked')) {
        $('#allowedDomains').prop('readonly', false);
        $('#allowedDomains').attr('required', 'required');
      } else {
        $('#allowedDomains').prop('readonly', true);
        $('#allowedDomains').removeAttr('required');
      }
});

function myFunctionpurgeDeletedFilesOlderThan(){
         document.getElementById("sizepurgeDeletedFilesOlderThan").innerHTML = "";
         if(isNaN($('#purgeDeletedFilesOlderThan').val()))
         {
             if (  $('#purgeDeletedFilesOlderThan').val() !='UNLIMITED')  {
                 document.getElementById("sizepurgeDeletedFilesOlderThan").innerHTML = "Input can be either 'UNLIMITED' or any integer";
             }
         }
         else if(!isNaN($('#purgeDeletedFilesOlderThan').val()) && $('#purgeDeletedFilesOlderThan').val() < 1){
             document.getElementById("sizepurgeDeletedFilesOlderThan").innerHTML = "Minimum number of Versions Allowed is 1";
         }
         else if($('#purgeDeletedFilesOlderThan').val().indexOf(".")!=-1){
            document.getElementById("sizepurgeDeletedFilesOlderThan").innerHTML = "Please enter an integral value";
        }
         else{
             document.getElementById("sizepurgeDeletedFilesOlderThan").innerHTML = "";
         }
     }

$("#switchpurgeDeletedFilesOlderThan").click(function(){
         document.getElementById("sizepurgeDeletedFilesOlderThan").innerHTML = "";
         if ($(this).is(':checked')) {
             $('#purgeDeletedFilesOlderThan').removeAttr('disabled'); //enable input
             $('#purgeDeletedFilesOlderThan').val('90');
         }else {
             $('#purgeDeletedFilesOlderThan').attr('disabled', true); //disable input
             $('#purgeDeletedFilesOlderThan').val('UNLIMITED');
         }
     });

function myFunctionpurgeDeletedMailsOlderThan(){
         document.getElementById("sizepurgeDeletedMailsOlderThan").innerHTML = "";
         if(isNaN($('#purgeDeletedMailsOlderThan').val()))
         {
             if (  $('#purgeDeletedMailsOlderThan').val() !='UNLIMITED')  {
                 document.getElementById("sizepurgeDeletedMailsOlderThan").innerHTML = "Input can be either 'UNLIMITED' or any integer";
             }
         }
         else if(!isNaN($('#purgeDeletedMailsOlderThan').val()) && $('#purgeDeletedMailsOlderThan').val() < 1){
             document.getElementById("sizepurgeDeletedMailsOlderThan").innerHTML = "Minimum number of Versions Allowed is 1";
         }
         else if($('#purgeDeletedMailsOlderThan').val().indexOf(".")!=-1){
            document.getElementById("sizepurgeDeletedMailsOlderThan").innerHTML = "Please enter an integral value";
        }
         else{
             document.getElementById("sizepurgeDeletedMailsOlderThan").innerHTML = "";
         }
     }

$("#switchpurgeDeletedMailsOlderThan").click(function(){
         document.getElementById("sizepurgeDeletedMailsOlderThan").innerHTML = "";
         if ($(this).is(':checked')) {
             $('#purgeDeletedMailsOlderThan').removeAttr('disabled'); //enable input
             $('#purgeDeletedMailsOlderThan').val('90');
         }else {
             $('#purgeDeletedMailsOlderThan').attr('disabled', true); //disable input
             $('#purgeDeletedMailsOlderThan').val('UNLIMITED');
         }
     });

function myFunctiondeletedMailsOlderThan(){
         document.getElementById("sizedeletedMailsOlderThan").innerHTML = "";
         if(isNaN($('#deletedMailsOlderThan').val()))
         {
             if (  $('#deletedMailsOlderThan').val() !='UNLIMITED')  {
                 document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "Input can be either 'UNLIMITED' or any integer";
             }
         }
         else if(!isNaN($('#deletedMailsOlderThan').val()) && $('#deletedMailsOlderThan').val() < 1){
             document.getElementById("sizedeletedMailsOlderThan").innerHTML = "Minimum number of Versions Allowed is 1";
         }
         else if($('#deletedMailsOlderThan').val().indexOf(".")!=-1){
            document.getElementById("sizedeletedMailsOlderThan").innerHTML = "Please enter an integral value";
        }
         else{
             document.getElementById("sizedeletedMailsOlderThan").innerHTML = "";
         }
     }

$("#switchdeletedMailsOlderThan").click(function(){
         document.getElementById("sizedeletedMailsOlderThan").innerHTML = "";
         if ($(this).is(':checked')) {
             $('#deletedMailsOlderThan').removeAttr('disabled'); //enable input
             $('#deletedMailsOlderThan').val('90');
         }else {
             $('#deletedMailsOlderThan').attr('disabled', true); //disable input
             $('#deletedMailsOlderThan').val('UNLIMITED');
         }
     });

</script>
<style type="text/css">
    .disabled {
    pointer-events:none; //This makes it not clickable
    opacity:0.6;         //This grays it out to look disabled
}
h5{
color:black;
}
</style>
<script>
$("#switchver").click(function(){
        document.getElementById("vererror").innerHTML = "";
        if ($(this).is(':checked')) {

        $('#maxVersions').removeAttr('disabled'); //enable input
        $('#maxVersions').val('3');

    } else {

        $('#maxVersions').attr('disabled', true); //disable input
        $('#maxVersions').val('UNLIMITED');
    }
        });

function myFunctionVer(){
        document.getElementById("vererror").innerHTML = "";
        if(isNaN($('#maxVersions').val()))
        {
            if (  $('#maxVersions').val() !='UNLIMITED')  {
                document.getElementById("vererror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() < 1){
            document.getElementById("vererror").innerHTML = "Minimum number of Versions Allowed is 1";
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() > 10000000){
            document.getElementById("vererror").innerHTML = "Maximum number of Versions Allowed is 1 Crore";
        }
        else{
            document.getElementById("vererror").innerHTML = "";
        }
}

$("#switchsize").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {

        $('#maxPermissibleFileSize').removeAttr('disabled'); //enable input
        $('#maxPermissibleFileSize').val('');

    } else {

        $('#maxPermissibleFileSize').attr('disabled', true); //disable input
        $('#maxPermissibleFileSize').val('UNLIMITED');
    }
        });

function myFunctionMPS(){
        document.getElementById("sizeerror").innerHTML = "";
        if(isNaN($('#maxPermissibleFileSize').val()))
        {
        if (  $('#maxPermissibleFileSize').val() !='UNLIMITED')  {
            document.getElementById("sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }

        }
        else if($('#maxPermissibleFileSize').val() < 1){
             document.getElementById("sizeerror").innerHTML = "Minimum File Size Allowed is 1";
         }
         else if(!isNaN($('#maxPermissibleFileSize').val()) && $('#maxPermissibleFileSizeOdb').val() > 999999){
             document.getElementById("sizeerror").innerHTML = "Maximum Permissible File Size Allowed is 999999";
         }
         else if($('#maxPermissibleFileSize').val().indexOf(".")!=-1){
            document.getElementById("sizeerror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("sizeerror").innerHTML = "";
        }
    }



    $("#switchsizeMail").click(function(){
        document.getElementById("sizeerrorMail").innerHTML = "";
        if ($(this).is(':checked')) {

        $('#maxPermissibleFileSizeMail').removeAttr('disabled'); //enable input
        $('#maxPermissibleFileSizeMail').val('');

    } else {

        $('#maxPermissibleFileSizeMail').attr('disabled', true); //disable input
        $('#maxPermissibleFileSizeMail').val('UNLIMITED');
    }
        });

function myFunctionMPSMail(){
        document.getElementById("sizeerrorMail").innerHTML = "";
        if(isNaN($('#maxPermissibleFileSizeMail').val()))
        {
        if (  $('#maxPermissibleFileSizeMail').val() !='UNLIMITED')  {
            document.getElementById("sizeerrorMail").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }

        }
        else if($('#maxPermissibleFileSizeMail').val() < 1){
             document.getElementById("sizeerrorMail").innerHTML = "Minimum File Size Allowed is 1";
         }
         else if(!isNaN($('#maxPermissibleFileSizeMail').val()) && $('#maxPermissibleFileSizeMail').val() > 999999){
             document.getElementById("sizeerrorMail").innerHTML = "Maximum Permissible File Size Allowed is 999999";
         }
         else if($('#maxPermissibleFileSizeMail').val().indexOf(".")!=-1){
            document.getElementById("sizeerrorMail").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("sizeerrorMail").innerHTML = "";
        }
}

$("#switchlimit").click(function(){
        document.getElementById("limiterror").innerHTML = "";
        if ($(this).is(':checked')) {

        $('#perUserBackupStorageLimit').removeAttr('disabled'); //enable input
        $('#perUserBackupStorageLimit').val('');

    } else {

        $('#perUserBackupStorageLimit').attr('disabled', true); //disable input
        $('#perUserBackupStorageLimit').val('UNLIMITED');
    }
        });


function myFunctionUBS(){
        document.getElementById("limiterror").innerHTML = "";
        if(isNaN($('#perUserBackupStorageLimit').val()))
        {
        if (  $('#perUserBackupStorageLimit').val() !='UNLIMITED')  {
            document.getElementById("limiterror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }

        }
         else if($('#perUserBackupStorageLimit').val() < 1){
             document.getElementById("limiterror").innerHTML = "Minimum Per User Backup Storage Limit Allowed is 1";
         }
        else if(!isNaN($('#perUserBackupStorageLimit').val()) && $('#perUserBackupStorageLimitOdb').val() > 99999){
             document.getElementById("limiterror").innerHTML = "Maximum Per User Backup Storage Limit Allowed is 99999";
         }
         else if($('#perUserBackupStorageLimit').val().indexOf(".")!=-1){
            document.getElementById("limiterror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("limiterror").innerHTML = "";
        }
    }



    $("#switchlimitMail").click(function(){
        document.getElementById("limiterrorMail").innerHTML = "";
        if ($(this).is(':checked')) {

        $('#perUserBackupStorageLimitMail').removeAttr('disabled'); //enable input
        $('#perUserBackupStorageLimitMail').val('');

    } else {

        $('#perUserBackupStorageLimitMail').attr('disabled', true); //disable input
        $('#perUserBackupStorageLimitMail').val('UNLIMITED');
    }
        });


function myFunctionUBSMail(){
        document.getElementById("limiterrorMail").innerHTML = "";
        if(isNaN($('#perUserBackupStorageLimitMail').val()))
        {
        if (  $('#perUserBackupStorageLimitMail').val() !='UNLIMITED')  {
            document.getElementById("limiterrorMail").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }

        }
         else if($('#perUserBackupStorageLimitMail').val() < 1){
             document.getElementById("limiterrorMail").innerHTML = "Minimum Per User Backup Storage Limit Allowed is 1";
         }
        else if(!isNaN($('#perUserBackupStorageLimitMail').val()) && $('#perUserBackupStorageLimitMail').val() > 99999){
             document.getElementById("limiterrorMail").innerHTML = "Maximum Per User Backup Storage Limit Allowed is 99999";
         }
         else if($('#perUserBackupStorageLimitMail').val().indexOf(".")!=-1){
            document.getElementById("limiterrorMail").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("limiterrorMail").innerHTML = "";
        }
}

$(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
        $('#scheduleName').removeAttr('readonly', 'readonly');
        });

        $('.createFilter').on('hidden.bs.modal', function(){
        $('#filterName').removeAttr('readonly', 'readonly');
	});

	$('.createScheduleMail').on('hidden.bs.modal', function(){
        $('#scheduleNameMail').removeAttr('readonly', 'readonly');
	});
	$('.createScheduleOdb').on('hidden.bs.modal', function(){
        $('#scheduleName').removeAttr('readonly', 'readonly');
	});

	$('.createFilter').on('hidden.bs.modal', function(){
        $('#filterName').removeAttr('readonly', 'readonly');
	});
	$('.createFilterMail').on('hidden.bs.modal', function(){
        $('#filterNameMail').removeAttr('readonly', 'readonly');
        });

    });

    $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
            $('#addSchedule_title').removeClass("d-none");
            $('#editSchedule_title').removeClass("d-block");
            $('#addSchedule_save').removeClass("d-none");
            $('#editSchedule_save').removeClass("d-block");
        });
        $('.createFilter').on('hidden.bs.modal', function(){
            $('#add_title').removeClass("d-none");
            $('#edit_title').removeClass("d-block");
            $('#add_save').removeClass("d-none");
            $('#edit_save').removeClass("d-block");
	});
	$('.createScheduleOdb').on('hidden.bs.modal', function(){
            $('#addSchedule_title').removeClass("d-none");
            $('#editSchedule_title').removeClass("d-block");
            $('#addSchedule_save').removeClass("d-none");
            $('#editSchedule_save').removeClass("d-block");
	});
	$('.createScheduleMail').on('hidden.bs.modal', function(){
            $('#addSchedule_titleMail').removeClass("d-none");
            $('#editSchedule_titleMail').removeClass("d-block");
            $('#addSchedule_saveMail').removeClass("d-none");
            $('#editSchedule_saveMail').removeClass("d-block");
	});

	$('.createFilter').on('hidden.bs.modal', function(){
            $('#add_title').removeClass("d-none");
            $('#edit_title').removeClass("d-block");
            $('#add_save').removeClass("d-none");
            $('#edit_save').removeClass("d-block");
	});
	$('.createFilterMail').on('hidden.bs.modal', function(){
            $('#add_titleMail').removeClass("d-none");
            $('#edit_titleMail').removeClass("d-block");
            $('#add_saveMail').removeClass("d-none");
            $('#edit_saveMail').removeClass("d-block");
        });
    });
    var createLinkEnabledSwitch = document.querySelector('.createLinkEnabled');
    if(createLinkEnabledSwitch){
            createLinkEnabledSwitch.onchange = function() {
                    if(createLinkEnabledSwitch.checked){
                            if(!$('#collapse1').hasClass('show')){
                                    $('#collapse1').addClass('show');
                                    $('#includethreshholdLimit').attr('checked', 'checked');
                                    $('#includepurgeFilesOlderThan').attr('checked', 'checked');
                                    $('#includepurgeFilesSizeGTThan').attr('checked', 'checked');
                                    $('#threshholdLimit').removeAttr('disabled');
                                    $('#purgeFilesOlderThan').removeAttr('disabled');
                                    $('#purgeFilesSizeGTThan').removeAttr('disabled');
                                    $('#threshholdLimit').val('80');
                                    $('#purgeFilesOlderThan').val('365');
                                    $('#purgeFilesSizeGTThan').val('5');
                                    document.getElementById('includethreshholdLimit').checked = true;
                                    document.getElementById('includepurgeFilesOlderThan').checked = true;
                                    document.getElementById('includepurgeFilesSizeGTThan').checked = true;
                                    /*if($('#threshholdLimitOld').val() != '-1' || $('#threshholdLimitOld').val() == ''){
                                        $('#threshholdLimit').val($('#threshholdLimitOld').val());
                                    }else{
                                        $('#threshholdLimit').val('80');
                                    }
                                    if($('#purgeFilesOlderThanOld').val() != '-1' || $('#purgeFilesOlderThanOld').val() == ''){
                                        $('#purgeFilesOlderThan').val($('#purgeFilesOlderThanOld').val());
                                    }else{
                                        $('#purgeFilesOlderThan').val('365');
                                    }
                                    if($('#purgeFilesSizeGTThanOld').val() != '-1' || $('#purgeFilesSizeGTThanOld').val() == ''){
                                        $('#purgeFilesSizeGTThan').val($('#purgeFilesSizeGTThanOld').val());
                                    }else{
                                        $('#purgeFilesSizeGTThan').val('5');
                            }*/
                        }
                    }else{
                            $('#includethreshholdLimit').removeAttr('checked');
                            $('#includepurgeFilesOlderThan').removeAttr('checked');
                            $('#includepurgeFilesSizeGTThan').removeAttr('checked');
                        if($('#collapse1').hasClass('show')){
				$('#collapse1').removeClass('show');
			}
                    }
        };
    }
    $("#includethreshholdLimit").click(function(){
         if ($(this).is(':checked')) {
             /*if($('#threshholdLimitOld').val() != '-1'){
                $('#threshholdLimit').val($('#threshholdLimitOld').val());
             }else{
                $('#threshholdLimit').val('80');
         }*/
             $('#threshholdLimit').val('80');
             $('#threshholdLimit').removeAttr('disabled');
         }else {
             $('#threshholdLimit').val('');
             $('#threshholdLimit').attr('disabled','disabled');
             checkAll();
         }
    });
    $("#includepurgeFilesOlderThan").click(function(){
         if ($(this).is(':checked')) {
             /*if($('#purgeFilesOlderThanOld').val() != '-1'){
                $('#purgeFilesOlderThan').val($('#purgeFilesOlderThanOld').val());
             }else{
                $('#purgeFilesOlderThan').val('365');
         } */
             $('#purgeFilesOlderThan').val('365');
             $('#purgeFilesOlderThan').removeAttr('disabled');
         }else {
             $('#purgeFilesOlderThan').val('');
             $('#purgeFilesOlderThan').attr('disabled','disabled');
             checkAll();
         }
    });
    $("#includepurgeFilesSizeGTThan").click(function(){
         if ($(this).is(':checked')) {
             /*if($('#purgeFilesSizeGTThanOld').val() != '-1'){
                $('#purgeFilesSizeGTThan').val($('#purgeFilesSizeGTThanOld').val());
             }else{
                $('#purgeFilesSizeGTThan').val('5');
         } */
             $('#purgeFilesSizeGTThan').val('5');
             $('#purgeFilesSizeGTThan').removeAttr('disabled');
         }else {
             $('#purgeFilesSizeGTThan').val('');
             $('#purgeFilesSizeGTThan').attr('disabled','disabled');
         }
         checkAll();
    });
    function checkAll(){
            if(createLinkEnabledSwitch.checked){
                    if(!$("#includethreshholdLimit").is(':checked') && !$("#includepurgeFilesOlderThan").is(':checked') && !$("#includepurgeFilesSizeGTThan").is(':checked')){
                        angular.element(document.getElementById('policyName')).scope().archiveError();
                    }
            }
    }
</script>
<style>
.table-responsive {
display: table;

}
</style>
