<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('pms')?>"><h3><?=$data['title']?></h3></a></li>
                <li><span><?=$data['crumb1']?></span></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <span class="hide currentPage"><?='singleServerPolicyMapping'?></span>
            <span class="hide csrf_token"><?=$data['csrf_token']?></span>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=$data['crumb2']?></h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <form ng-submit="updatePolicyMappingList('0', search.deviceName)">
                            <div class="col-lg-12">
                                <input name="searchUsername"
                                       type="text"
                                       class="pull-right form-control"
                                       ng-model="search.deviceName"
                                       placeholder="Enter a list of comma separated Device Names or just type 'all (for List of Devices)' and hit enter to search"
                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                       data-content="Entered Device Name were not found!!!"
                                />
                            </div>
                        </form>
                    </div>
                    <br/>
                    <table class="table table-bordered table-striped userPolicyMappingListTable" style="display: none;">
                        <colgroup>
                            <col class="col-xs-1">
                            <col class="col-xs-3">
                            <col class="col-xs-5">
                            <col class="col-xs-3">
                        </colgroup>
                        <thead>
                        <tr>
                            <th>#</th>
                            <th class="hide"><?=Language::show('deviceName', 'keywords')?></th>
                            <th><?=Language::show('deviceName', 'keywords')?></th>
                            <th><?=Language::show('policyName', 'keywords')?></th>
                            <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="value in userPolicyMappingUsers track by $index" class="mappingRow{{$index}}">
                            <td ng-cloak>{{ $index+1 }}</td>
                            <td class="deviceUUID hide" ng-cloak>{{ value.deviceUUID }}</td>
                            <td class="deviceName" ng-cloak>{{ value.deviceName }}</td>
                            <td class="policyName" ng-cloak>
                                <span>{{ value.policyName }}</span>
                                <form style="display: none;">
                                    <select class="form-control" name="userPolicyMappingPolicyName{{$index}}" id="userPolicyMappingPolicyName" required="">
                                        <option ng-repeat="policy in userPolicyMappingPolicies" value="{{ policy }}">{{ policy }}</option>
                                    </select>
                                </form>
                            </td>
                            <td class="action" ng-cloak>
                                <a class="edit btn btn-default btn-small" ng-click="showMappingList($index)"><i class="fa fa-edit"></i> <?=Language::show('change_policy', 'keywords');?></a>
                                <a style="display: none;" class="save btn btn-success btn-small" ng-click="changeServerPolicy($index)"><i class="fa fa-save"></i> <?=Language::show('save_policy', 'keywords');?></a>
                                <a style="display: none;" class="save btn btn-danger btn-small" ng-click="cancelChangePolicy($index)"><i class="fa fa-times"></i> <?=Language::show('cancel', 'keywords');?></a>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js" type="text/javascript"></script>
