<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/policies')?>"><?=$data['crumb1']?></a></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('create_new_policy', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="hide currentPage"><?='createPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'policyForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'policyCreate()',
                            'data-parsley-validate' => true
                        ));
                    ?>
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="form-group hide">
                                <div class="checkbox check-primary">
                                    <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                    <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                <span class="systemFolders" style="display: none;">
                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced Tab</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
                    <div class="row">
                        <div class="col-lg-7">
                            <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                            <div class="form-group">
                                <label for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" data-parsley-min="1" />
                            </div>
                            <div class="form-group">
                                <label for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
                                <input type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="1024" data-parsley-type="integer"  data-parsley-min="1" />
                            </div>
                            <div class="form-group">
                                <label for="schedules"><?=Language::show('schedules', 'keywords');?> - <a class="clickAble" ng-click="addNewSchedule()">Create New Schedule</a></label>
                                <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                    <?php if(!empty($data['schedules'])){ ?>
                                        <?php foreach($data['schedules'] as $key => $value){ ?>
                                            <option value="<?=$value['scheduleName']?>"><?=$value['scheduleName']?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                <label for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
                                <input type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="-1" />
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="row" ng-if="defaultSchedules.length >= 1">
                                <div class="col-lg-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                        </div>
                                        <div class="panel-body">
                                            <table class="table table-bordered table-responsive">
                                                <tbody>
                                                <tr ng-repeat="value in defaultSchedules">
                                                    <td>{{ value.scheduleName }}</td>
                                                    <td>{{ value.time }} hrs</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row hide">
                        <div class="col-lg-7">
                            <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                            <div class="form-group">
                                <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                <select class="form-control selectOsTypePicker" ng-model="osType" name="osType" id="osType" required="" title='Select OS Type'>
                                    <option value="windows">Windows</option>
                                    <option value="mac">Mac/Linux</option>
                                </select>
                            </div>
                            <div class="form-group vssContainer" style="display: none;">
                                <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'>
                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" ng-model="defaultFoldersBackup" name="defaultFoldersBackup" id="defaultFoldersBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off"
                                           data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                           data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                        />
                                <span class="input-group-btn">
                                    <button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default defaultFoldersBackupBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="machineMaxThreshold"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                <input type="text" class="form-control" name="machineMaxThreshold" id="machineMaxThreshold" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="128" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                            </div>
                            <div class="form-group">
                                <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="80" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                            </div>
                        </div>
                        <div class="col-lg-5" ng-if="osType != undefined">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                </div>
                                <div class="panel-body">
                                    <div  ng-if="osType == 'windows'">
                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                            <li ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                        </ul>
                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                    </div>
                                    <div  ng-if="osType == 'mac'">
                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                            <li ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                        </ul>
                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-7">
                            <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                            <div class="form-group">
                                <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble" ng-click="addNewFilter()">Create New Filter</a></label>
                                <select class="form-control selectFilterPicker" ng-model="filter" name="filters" id="filters" required title='Select Filters'>
                                    <?php if(!empty($data['filters'])){ ?>
                                        <?php foreach($data['filters'] as $key => $value){ ?>
                                            <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="row allFilters" ng-if="defaultFilter != undefined">
                                <div class="col-lg-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5> <i class="fa fa-filter"></i> Filters</h5>
                                        </div>
                                        <div class="panel-body">
                                            <?=Language::show('filterName', 'keywords');?>: {{ defaultFilter.filterName }}
                                            <br/>
                                            <?=Language::show('Filter Type', 'keywords');?>: {{ defaultFilter.filterType }}
                                            <br/>
                                            <?=Language::show('filters', 'keywords');?>: <b style="word-wrap: break-word">{{ defaultFilter.filters }}</b>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-7">
                            <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('privacyGateWay', 'keywords')?></legend>
                            <?php if(!empty($data['pgs'])){ ?>
                                <ul class="list-group sortable">
                                    <?php foreach($data['pgs'] as $key => $value){ ?>
                                        <li class="list-group-item" id="<?=$value['gatewayName'];?>"><?=$value['gatewayName'];?></li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                        </div>
                    </div>
                    </div><!--general-->
                    <div role="tabpanel" class="tab-pane" id="advanced">
                    <div class="row">
                        <div class="col-lg-7">
                            <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                            <div class="form-group hide">
                                <label for="ccS"><?=Language::show('ccS', 'keywords');?> - <a class="clickAble" ng-click="addNewCcS()">Add Cloud Credentials</a></label>
                                <select class="form-control selectCcSPicker" ng-model="ccSs"  name="ccS" id="ccS" title='Select <?=Language::show('ccS', 'keywords')?>'>
                                    <?php if(!empty($data['ccS'])){ ?>
                                        <?php foreach($data['ccS'] as $key => $value){ ?>
                                            <option value="<?=$value->{'identity'}?>"><?=$value->{'identity'}?></option>
                                        <?php } ?>
                                    <?php }else{ ?>
                                        <option selected disabled>Please Add A Cloud Credential</option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="5" data-parsley-type="integer" data-parsley-min="1" />
                            </div>
                            <div class="form-group">
                                <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                            </div>
                            <div class="form-group">
                                <label for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                            </div>
                            <div class="form-group">
                                <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                            </div>
                            <div class="form-group">
                                <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="5" data-parsley-type="integer" data-parsley-min="1" />
                            </div>
                            <div class="form-group hide">
                                <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group hide">
                                <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                <input type="text" class="form-control timePicker input-small" id="policyRefresh" name="policyRefresh">
                            </div>
                        </div>
                    </div>
                    </div>
                    </div>
                    <div class="row hide">
                        <div class="col-lg-7">
                            <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('fullBackupOptions', 'keywords')?></legend>
                            <div class="form-group">
                                <label for="fullBackupPeriod"><?=Language::show('fullBackupPeriod', 'keywords');?></label>
                                <select class="form-control fullBackupPeriod" name="fullBackupPeriod" id="fullBackupPeriod" title='Select <?=Language::show('fullBackupPeriod', 'keywords')?>'>
                                    <option value="dd"><?=Language::show('daily', 'keywords')?></option>
                                    <option value="ww" selected><?=Language::show('weekly', 'keywords')?></option>
                                    <option value="mm" selected><?=Language::show('monthly', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group fullBackupDayOption">
                                <label for="fullBackupDay"><?=Language::show('selectADay', 'keywords');?></label>
                                <select class="form-control fullBackupDay" name="fullBackupDay" id="fullBackupDay" title='<?=Language::show('selectADay', 'keywords')?>'>
                                    <?php for($i = 1; $i < 31; $i++){ ?>
                                        <option value="<?=$i?>"><?=Language::show($i, 'keywords')?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="fullBackupHours"><?=Language::show('selectAHour', 'keywords');?></label>
                                <input type="text" class="form-control timePicker input-small fullBackupHours" id="fullBackupHours" name="fullBackupHours">
                            </div>
                        </div>
                    </div>
                    
<!--                    <div class="row">-->
<!--                        <div class="col-lg-7">-->
<!--                            <legend class="h4" style="color: #585f69; margin-left: -17px;">-->
<!--                                --><?//=Language::show('Pre Backup Script', 'keywords')?>
<!--                                <span ng-if="preBackup.length < 2">- <a class="clickAble small" ng-click="openScript('preBackup')">Add</a></span>-->
<!--                            </legend>-->
<!--                            <div class="form-group">-->
<!--                                <span ng-if="preBackup.length <= 0"><i>No Scripts</i></span>-->
<!--                            <span ng-repeat="value in preBackup track by $index" ng-if="preBackup.length >= 1">-->
<!--                                <span class="clickAble" ng-click="removeScript('preBackup', $index)"><i class="fa fa-times-circle-o"></i></span>-->
<!--                                Script Name:-->
<!--                                <span class="text-primary">-->
<!--                                    {{ value.scriptName }}-->
<!--                                    <span ng-if="value.backupType == 'f'">(Full)</span>-->
<!--                                    <span ng-if="value.backupType == 'i'">(Incremental)</span>-->
<!--                                </span>-->
<!--                                <span ng-if="value.scriptArgs.length >= 1">, Arguments: <label class="label label-primary" ng-repeat="vale in value.scriptArgs">{{ vale }}</label></span>-->
<!--                                <br/>-->
<!--                            </span>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                    <div class="row">-->
<!--                        <div class="col-lg-7">-->
<!--                            <legend class="h4" style="color: #585f69; margin-left: -17px;">-->
<!--                                --><?//=Language::show('Post Backup Script', 'keywords')?>
<!--                                <span ng-if="postBackup.length < 2">- <a class="clickAble small" ng-click="openScript('postBackup')">Add</a></span>-->
<!--                            </legend>-->
<!--                            <div class="form-group">-->
<!--                                <span ng-if="postBackup.length <= 0"><i>No Scripts</i></span>-->
<!--                            <span ng-repeat="value in postBackup track by $index" ng-if="postBackup.length >= 1">-->
<!--                                <span class="clickAble" ng-click="removeScript('postBackup', $index)"><i class="fa fa-times-circle-o"></i></span>-->
<!--                                Script Name:-->
<!--                                <span class="text-primary">-->
<!--                                    {{ value.scriptName }}-->
<!--                                    <span ng-if="value.backupType == 'f'">(Full)</span>-->
<!--                                    <span ng-if="value.backupType == 'i'">(Incremental)</span>-->
<!--                                </span>-->
<!--                                <span ng-if="value.scriptArgs.length >= 1">, Arguments: <label class="label label-primary" ng-repeat="vale in value.scriptArgs">{{ vale }}</label></span>-->
<!--                                <br/>-->
<!--                            </span>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                    <div class="row">-->
<!--                        <div class="col-lg-7">-->
<!--                            <legend class="h4" style="color: #585f69; margin-left: -17px;">-->
<!--                                --><?//=Language::show('Pre Restore Script', 'keywords')?>
<!--                                <span ng-if="preRestore.length < 2">- <a class="clickAble small" ng-click="openScript('preRestore')">Add</a></span>-->
<!--                            </legend>-->
<!--                            <div class="form-group">-->
<!--                                <span ng-if="preRestore.length <= 0"><i>No Scripts</i></span>-->
<!--                            <span ng-repeat="value in preRestore track by $index" ng-if="preRestore.length >= 1">-->
<!--                                <span class="clickAble" ng-click="removeScript('preRestore', $index)"><i class="fa fa-times-circle-o"></i></span>-->
<!--                                Script Name:-->
<!--                                <span class="text-primary">-->
<!--                                    {{ value.scriptName }}-->
<!--                                    <span ng-if="value.backupType == 'f'">(Full)</span>-->
<!--                                    <span ng-if="value.backupType == 'i'">(Incremental)</span>-->
<!--                                </span>-->
<!--                                <span ng-if="value.scriptArgs.length >= 1">, Arguments: <label class="label label-primary" ng-repeat="vale in value.scriptArgs">{{ vale }}</label></span>-->
<!--                                <br/>-->
<!--                            </span>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                    <div class="row">-->
<!--                        <div class="col-lg-7">-->
<!--                            <legend class="h4" style="color: #585f69; margin-left: -17px;">-->
<!--                                --><?//=Language::show('Post Restore Script', 'keywords')?>
<!--                                <span ng-if="postRestore.length < 2">- <a class="clickAble small" ng-click="openScript('postRestore')">Add</a></span>-->
<!--                            </legend>-->
<!--                            <div class="form-group">-->
<!--                                <span ng-if="postRestore.length <= 0"><i>No Scripts</i></span>-->
<!--                            <span ng-repeat="value in postRestore track by $index" ng-if="postRestore.length >= 1">-->
<!--                                <span class="clickAble" ng-click="removeScript('postRestore', $index)"><i class="fa fa-times-circle-o"></i></span>-->
<!--                                Script Name:-->
<!--                                <span class="text-primary">-->
<!--                                    {{ value.scriptName }}-->
<!--                                    <span ng-if="value.backupType == 'f'">(Full)</span>-->
<!--                                    <span ng-if="value.backupType == 'i'">(Incremental)</span>-->
<!--                                </span>-->
<!--                                <span ng-if="value.scriptArgs.length >= 1">, Arguments: <label class="label label-primary" ng-repeat="vale in value.scriptArgs">{{ vale }}</label></span>-->
<!--                                <br/>-->
<!--                            </span>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
                    
                    <div class="row">
                        <div class="col-lg-7">
                            <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                    </div>
                    <?=
                        Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createSchedule">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit Schedule</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                        <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                        <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                    </div>
                    <div class="form-group">
                        <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime">
                    </div>
                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                        <div class="form-group backupTypeForm">
                            <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                            <select class="form-control backupType" name="backupType" id="backupType" required>
                                <option value="f">Full</option>
                                <option value="i">Incremental</option>
                            </select>
                        </div>
                    <?php } ?>
                    <div class="form-group">
                        <label for="days"><?=Language::show('days', 'keywords');?></label>
                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                        <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                            <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                            <option value="2"><?=Language::show('monday', 'keywords')?></option>
                            <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                            <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                            <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                            <option value="6"><?=Language::show('friday', 'keywords')?></option>
                            <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createFilter">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit Filter</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label><br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createCcS">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?= Form::open(array(
                    'ng-submit' => 'saveCloudCredentials(true)',
                    'class' => 'cloudCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create a new CcS</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group col-lg-12">
                        <label for="cloudType">Cloud Type</label>
                        <select class="form-control" name="cloudType" id="cloudType">
                            <option value="azureBlob">Azure Blob</option>
                            <option value="ibmCloud">IBM Cloud</option>
                            <option value="amazon">Amazon s3 Services</option>
                        </select>
                    </div>
                    <div class="form-group col-lg-6">
                        <label for="identity">Identity</label>
                        <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="Enter your cloud identity" required autocomplete="off">
                    </div>
                    <div class="form-group col-lg-6">
                        <label for="accessKey">Access key</label>
                        <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="Enter your access key" required autocomplete="off">
                    </div>
                    <div class="form-group col-lg-12 epaUrl" style="display: none;">
                        <label for="epaUrl">End Point Url</label>
                        <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="Enter your End Point Agent URL" autocomplete="off">
                    </div>
                    <div class="form-group col-lg-12 containerName" style="display: none;">
                        <label for="containerName">Amazon Container Name</label>
                        <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="Enter your Amazon Container Name" autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade addScript">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'addAScriptForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'addAScript(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Add Script</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="scriptName"><?=Language::show('Script Name', 'keywords');?></label>
                        <input type="text" class="form-control" name="scriptName" id="scriptName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Script Name', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group backupTypeForm">
                        <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                        <select class="form-control backupType" name="backupType" id="backupType" required>
                            <option value="f">Full</option>
                            <option value="i">Incremental</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="scriptArgs"><?=Language::show('Script Arguments', 'keywords');?></label><br/>
                        <select style="width: 100%" class="form-control" name="scriptArgs[]" id="scriptArgs" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Arguments', 'keywords');?>" autocomplete="off" multiple="" tabindex="-1" aria-hidden="true"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.filterType').selectpicker('render');
    $('.compEnabled').selectpicker('render');
    $("#scriptArgs").select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });
    $('.fullBackupDay').selectpicker('render');
    $('.fullBackupPeriod').selectpicker('render').on('change', function(){
        if($('.fullBackupPeriod').val() != 'dd'){
            $('.fullBackupDayOption').show();
        }else{
            $('.fullBackupDayOption').hide();
        }
    });
    $('.selectSchedulePicker').selectpicker('render');
    $('.vssEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render').on('change', function(){
        if($('.selectOsTypePicker').val() == 'windows'){
            $('.vssContainer').show();
        }else{
            $('.vssContainer').hide();
        }
    });
    $('.selectCcSPicker').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render');
    $('.networkThrottling').selectpicker('render');
    $('.selectFilterPicker').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '0:00'
    });
    $('.backupType').selectpicker('render');
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js" type="text/javascript"></script>
