<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="d-none currentPage"><?='nobackupschedule'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
	<div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <?php if(PORTAL_LIGHT_VERSION == false){ ?>
                    <h4><?=$data['crumb1']?><?php if($data['readOnlyAdminUser'] == 'No'){ ?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/nobackupschedule/create')?>"><?=Language::show('create_new_schedule', 'keywords');?></a></span><?php } ?></h4>
                    <?php } else {?>
                    <h4><?=$data['crumb1']?><span class="pull-right toolTip" data-toggle="tooltip" data-placement="top" title="This feature is disabled in Lite Version" style="cursor: not-allowed";><a class="btn btn-success btn-small" disabled href="<?=Url::basePath('pms/nobackupschedule/create')?>"><?=Language::show('create_new_schedule', 'keywords');?></a></span></h4>
                    <?php } ?>
		</div>
		<div class="panel-body notPresent">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center"><?=Language::show('No Schedules found', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
                <div class="panel-body present" style="display:none;">
                    <div class="bs-example" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-2">
				    <col class="col-xs-2">
				    <col class="col-xs-2">
                                    <col class="col-xs-6">
				    <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                    <col class="col-xs-2">
				    <?php } ?>
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th class="text-left clickAble" ng-click="sortTypeSchedule = 'scheduleName'; sortReverse = !sortReverse">
                                        <?=Language::show('scheduleName', 'keywords')?>
                                        <span ng-show="sortTypeSchedule == 'scheduleName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeSchedule == 'scheduleName' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortTypeSchedule = 'schedulesTimeCnvrtInt'; sortReverse = !sortReverse">
                                        <?=Language::show('scheduleStartTime', 'keywords')?>
                                        <span ng-show="sortTypeSchedule == 'schedulesTimeCnvrtInt' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeSchedule == 'schedulesTimeCnvrtInt' && sortReverse" class="fa fa-caret-down"></span>
					</th>
					<th class="text-left clickAble" ng-click="sortTypeSchedule = 'schedulesToTimeCnvrtInt'; sortReverse = !sortReverse">
                                        <?=Language::show('scheduleEndTime', 'keywords')?>
                                        <span ng-show="sortTypeSchedule == 'schedulesToTimeCnvrtInt' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeSchedule == 'schedulesToTimeCnvrtInt' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortTypeSchedule = 'days'; sortReverse = !sortReverse">
                                        <?=Language::show('days', 'keywords')?>
                                        <span ng-show="sortTypeSchedule == 'days' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeSchedule == 'days' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
					<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                        <th><?=Language::show('action', 'keywords')?></th>
					<?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in schedules | orderBy:sortTypeSchedule:sortReverse">
                                        <td ng-cloak>{{ value.scheduleName }}</td>
					<td ng-cloak>{{ value.fromTime }}</td>
					<td ng-cloak>{{ value.toTime }}</td>
                                        <td ng-cloak>{{ value.days }}</td>
					<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                        <td ng-cloak>
                                            <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                               ng-bootbox-confirm-action="getParticularNoBackupScheduleEditPage(value.scheduleName)"
                                                ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small"><?=Language::show('Edit', 'keywords');?></a>
                                            <a ng-bootbox-confirm="<h4>Are you sure you want to delete the selected schedule?</h4>"
                                               ng-bootbox-confirm-action="deleteNoBackupSchedule(value.scheduleName)"
                                               ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small btn-danger"><i class="fa fa-trash"></i> <?=Language::show('Delete', 'keywords');?></a>
                                        </td>
					<?php } ?>
                                    </tr>
				</tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade editNoBackupSchedule">
            <div class="modal-dialog">
                <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                    <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'nobackupscheduleForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'nobackupscheduleSave()',
                            'data-parsley-validate' => true
                        ));
                    ?>
                    <div class="modal-header">
			<h4 class="modal-title">Edit Schedule</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked d-none" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="active" style="display:unset !important;"><a data-toggle="tab" data-target="#general1" aria-expanded="true" aria-controls="general">General</a></li>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#advanced1" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs d-none" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="active"><a data-target="#general1" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#advanced1" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general1">
				            <br>
                            <div class="form-group">
                                <label for="nobackupscheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                                <input type="text" class="form-control" value="{{ schedules[scheduleIndex].scheduleName }}" readonly name="nobackupscheduleName" id="nobackupscheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group d-none">
                                <label for="nobackupscheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                                <input type="text" class="form-control" name="nobackupscheduleTimeZone" id="nobackupscheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group">
                                <label for="nobackupscheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="text" class="form-control nobackupscheduleStartTime input-small timepicker" id="nobackupscheduleStartTime" name="nobackupscheduleStartTime" required>
			    </div>
			    <div class="form-group">
                                <label for="nobackupscheduleEndTime"><?=Language::show('scheduleEndTime', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="text" class="form-control nobackupscheduleEndTime input-small timepicker" id="nobackupscheduleEndTime" name="nobackupscheduleEndTime" required>
                            </div>
                            <div class="form-group">
                                <label for="nobackupdays"><?=Language::show('days', 'keywords');?></label>
                                <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                                <select class="form-control selectPicker" name="nobackupdays[]" id="nobackupdays" required="" multiple title='Select days'>
                                    <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                    <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                    <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                    <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                    <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                    <option value="6"><?=Language::show('friday', 'keywords')?></option>
                                    <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                                </select>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced1">
                            </br>
                            <div class="form-group backupTypeForm">
                                <label for="nobackupbackupType"><?=Language::show('Backup Type', 'keywords');?></label>
                                <select class="form-control nobackupbackupType" name="nobackupbackupType" id="nobackupbackupType" required>
                                    <option value="FULL">Full</option>
                                    <option value="INCR" selected>Incremental</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                    <?= Form::close(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.backupType').selectpicker('render');
    $('.timepicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
