<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('pms/nobackupschedules')?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
		<div class="row">
			<div class="panel col-lg-12">
			    <div class="panel-heading">
				<h4><?=Language::show('create_new_schedule', 'keywords')?></h4>
			    </div>
			    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
				<?=
				Form::open(array(
				    'csrf' => $data['csrf_token'],
				    'class' => 'nobackupscheduleCreateForm',
				    'autocomplete' => 'off',
				    'ng-submit' => 'nobackupscheduleCreate(false)',
				    'data-parsley-validate' => true
				));
				?>
			    <?php if(isMobile()){ ?>
			    <ul class="nav nav-pills nav-stacked d-none" style="border: 1px solid #EC6621;border-radius: 10px;">
			      <li class="active" style="display:unset !important;"><a data-toggle="tab" data-target="#general1" aria-expanded="true" aria-controls="general">General</a></li>
			      <li style="display:unset !important;"><a data-toggle="tab" data-target="#advanced1" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
			    </ul>
			    <?php } ?>
			    <!-- for mobile end -->
			    <?php if(!isMobile()){ ?>
			    <!-- Nav tabs -->
			    <ul class="nav nav-tabs d-none" role="tablist" style="font-size: medium;font-weight: 600;">
				<li role="presentation" class="active"><a data-target="#general1" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
				<li role="presentation"><a data-target="#advanced1" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
			    </ul>
			    <?php } ?>

			    <!-- Tab panes -->
			    <div class="tab-content">
				<div role="tabpanel" class="tab-pane active" id="general1">
						    <br>
				    <div class="form-group">
					<label for="nobackupscheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
					<input type="text" class="form-control" name="nobackupscheduleName" id="nobackupscheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
				    </div>
				    <div class="form-group d-none">
					<label for="nobackupscheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
					<input type="text" class="form-control" name="nobackupscheduleTimeZone" id="nobackupscheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
				    </div>
				    <div class="form-group">
					<label for="nobackupscheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
					<a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
					<input type="text" class="form-control timePicker input-small" id="nobackupscheduleStartTime" name="nobackupscheduleStartTime" required>
				    </div>
				    <div class="form-group">
                                        <label for="nobackupscheduleEndTime"><?=Language::show('scheduleEndTime', 'keywords');?></label>
                                        <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                        <input type="text" class="form-control timePicker input-small" id="nobackupscheduleEndTime" name="nobackupscheduleEndTime" required>
                                    </div>
				    <div class="form-group">
					<label for="nobackupdays"><?=Language::show('days', 'keywords');?></label> -
					<a href="javascript:;" class="nobackupscheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
					<select class="form-control selectPicker" name="nobackupdays[]" id="nobackupdays" required="" multiple title='Select days'>
					    <option value="1"><?=Language::show('sunday', 'keywords')?></option>
					    <option value="2"><?=Language::show('monday', 'keywords')?></option>
					    <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
					    <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
					    <option value="5"><?=Language::show('thursday', 'keywords')?></option>
					    <option value="6"><?=Language::show('friday', 'keywords')?></option>
					    <option value="7"><?=Language::show('saturday', 'keywords')?></option>
					</select>
				    </div>
				</div>
				<div role="tabpanel" class="tab-pane" id="advanced1">
				    </br>
				    <div class="form-group backupTypeForm">
					<label for="nobackupbackupType"><?=Language::show('Backup Type', 'keywords');?></label>
					<select class="form-control nobackupbackupType" name="nobackupbackupType" id="nobackupbackupType" required>
					    <option value="FULL">Full</option>
					    <option value="INCR" selected>Incremental</option>
					</select>
				    </div>
				</div>
			    </div>
				<button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
				<?=
				    Form::close();
				?>
			    </div>
			</div>
		</div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.nobackupbackupType').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
