<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='networkThrottlingView'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <?php if(!empty($data['pgList'])){ ?>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('clientToBluKrypt', 'keywords')?></h4>
                    </div>
                    <div class="panel-body">
                        <?php foreach($data['pgList'] as $key => $value){ ?>
                            <div class="col-lg-3">
                                <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/throttling/set/c2p/<?=$value->{'gatewayName'}?>')">
                                    <div class="background">
                                        <i class="fa fa-crop"></i>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <span style="margin-left: 30px; font-size: 20px;"><i class="fa fa-user"></i> &nbsp;&nbsp;&nbsp;&nbsp;-><i class="fa fa-key"></i></span>
                                        <br/>
                                        <a style="margin-left: 40px; font-size: 20px;"><?=$value->{'gatewayName'}?></a>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('bluKryptToAzureBlob', 'keywords')?></h4>
                    </div>
                    <div class="panel-body">
                        <?php foreach($data['pgList'] as $key => $value){ ?>
                            <div class="col-lg-3">
                                <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/throttling/set/p2a/<?=$value->{'gatewayName'}?>')">
                                    <div class="background">
                                        <i class="fa fa-crop"></i>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <span style="margin-left: 30px; font-size: 20px;"><i class="fa fa-key"></i> &nbsp;&nbsp;&nbsp;&nbsp;-><i class="fa fa-cloud"></i></span>
                                        <br/>
                                        <a style="margin-left: 45px; font-size: 20px;"><?=$value->{'gatewayName'}?></a>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>

                    </div>
                </div>
            </div>
        <?php }else{ ?>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-body">
                        <h2>There are no Privacy Gateways defined</h2>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js" type="text/javascript"></script>
