<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('pms/filters')?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="row">
                    <div class="panel col-lg-12">
                        <div class="panel-heading">
                            <h4><?=Language::show('create_new_filter', 'keywords')?></h4>
                        </div>
                        <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                            <?=
                            Form::open(array(
                                'csrf' => $data['csrf_token'],
                                'class' => 'filterForm',
                                'autocomplete' => 'off',
                                'ng-submit' => 'filterCreate(false)',
                                'data-parsley-validate' => true
                            ));
                            ?>
                            <div class="form-group">
                                <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                                <input type="text" class="form-control" name="filterName" id="filterName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
                            </div>
                            <div class="form-group d-none">
                                <label for="filterType"><?=Language::show('Filter Type', 'keywords')?></label>
                                <select class="form-control filterType" name="filterType" id="filterType" required>
                                    <option value="inclusion">Inclusion Filter</option>
                                    <option value="exclusion">Exclusion Filter</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="filterTemplate"><?=Language::show('Select Filter Template', 'keywords')?></label>
                                <select class="form-control selectFilterTemplatePicker" name="filterTemplate[]" id="selectFilterTemplatePicker" title='Select Filters template' multiple>
                                                <?php if(!empty($data['fil1'])){ ?>
                                                    <?php foreach($data['fil1'] as $key => $value){ ?>
                                                        <?php $label = $value;
                                                                    if( strlen( $value ) > 50 ) {
                                                                       $label = substr( $label, 0, 50 ) . '...';
                                                                    }?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                            </div>
                            <!--<div class="form-group">
                                <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of extensions"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <br/>
                                <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control" name="filters[]" id="filters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                            </div>-->                            
                            <div class="form-group">
                                <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of extensions"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <br/>
                                <input type="text" data-role="tagsinput" value="" class="form-control" name="filters[]" id="filters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                            </div>
			    <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
			    <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/filters')" style="margin-right: 10px;">Cancel</a>
                            <?=
                                Form::close();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js" type="text/javascript"></script>
<script>
    $('.filterType').selectpicker('render');
    $('.selectFilterTemplatePicker').selectpicker('render');
</script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
