<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=Language::show('downloadAgent', 'keywords')?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <?php if($data['MSP_Environment_Enabled'] == 'No'){?>
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
        <?php } else { ?>
        <div class="col-lg-12 col-md-12 col-sm-12 ng-cloak">
        <?php } ?>
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='downloads'?></span>
            <!--change password msp user start-->
<div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">
                                  <!-- Modal content-->
                                  <div class="modal-content">
                                    <?= Form::open(array(
                                                'ng-submit' => 'changePasswordMsp()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                     )); ?>                                    
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel">Change Password</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userName']?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['recoverykey']?>">
					<input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['googleSecretKey']?>">
				    <div class="form-group">
                                                <label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">
                                         </div>
                                      <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>

                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
                                                </div>
					    <div id="captchaDiv">
			    <?php
		    	    if(enableRecaptcha == true){
                            global $image;
                            $image = imagecreatetruecolor(200, 50) or die("Cannot Initialize new GD image stream");
                            $background_color = imagecolorallocate($image, 255, 255, 255);
                            $text_color = imagecolorallocate($image, 0, 255, 255);
                            $line_color = imagecolorallocate($image, 64, 64, 64);
                            $pixel_color = imagecolorallocate($image, 0, 0, 255);
                            imagefilledrectangle($image, 0, 0, 200, 50, $background_color);
                            for ($i = 0; $i < 3; $i++) {
                                imageline($image, 0, rand() % 50, 200, rand() % 50, $line_color);
                            }
                            for ($i = 0; $i < 1000; $i++) {
                                imagesetpixel($image, rand() % 200, rand() % 50, $pixel_color);
                            }
                            $letters = $data['letter'];
                            //$letters = $data['letter'];
                            $len = strlen($letters);
                            $letter = $letters[rand(0, $len - 1)];
                            $text_color = imagecolorallocate($image, 0, 0, 0);
                            $word = "";
                            $font = '/var/www/portal/app/templates/default/css/fonts/monofont.ttf';
                            for ($i = 0; $i < strlen($letters); $i++) {
                                    $letter = $letters[$i];
                                    $letter = trim($letter);
                        //          imagestring($image, 8, 70 + ($i * 15), 20, $letter, $text_color);
                                    imagettftext($image, 36, 0, 70 + ($i * 15), 35, $text_color, $font, $letter);
                                $word .= $letter;
                            }
                            $images = glob("*.png");
                            foreach ($images as $image_to_delete) {
                                @unlink($image_to_delete);
                                }
			    imagepng($image, "image" . $data['count'] . ".png");
			    }
                        ?>
			</div>
			<?php if(enableRecaptcha == true){ ?>
				<div class="from-group">
				    <label>Enter captcha shown below </label>
				    <input class="form-control" type="text" id="code" name="code" required autocomplete="off"/>
				    <!--<img id="captchaImage" src="image<?php echo $data['count'] ?>.png">-->
				    <span id="captchaSpan">
					<img id="captchaImage" src="https://<?=CLOUD_URL?>/portal/image<?=$data['count']?>.png">
				    </span>
				    <span id="refreshSpan"><a class="loginCaptchaRefresh" id="loginCaptchaRefresh" style="margin-left:10px;"><i class="glyphicon glyphicon-refresh" title="refresh captcha"></i></a></span>
				</div>
                        <?php }else{ ?>
                        	<input class="form-control d-none" type="text" id="code" name="code" value="<?=$data['letter']?>" autocomplete="off"/>
			<?php } ?>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>

                                </div>
                            </div>
<!--change password msp user end-->
            <?php if(isMobile()){ ?>
                    <!--<ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                        <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                        <?php if(Auth::checkCloudPermission('backup') == true || Auth::checkCloudPermission('office365') == true){ ?>
                            <?php if($data['isAdmin'] == 'true'){ ?>
                                <li class="nav-item hide" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                            <?php } ?>
                        <?php } ?>
                    </ul>-->
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!--<ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <?php if(Auth::checkCloudPermission('backup') == true || Auth::checkCloudPermission('office365') == true){ ?>
                            <?php if($data['isAdmin'] == 'true'){ ?>
                                <li class="nav-item hide" role="presentation"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            <?php } ?>
                        <?php } ?>
                    </ul>-->
                    <?php } ?>
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
            <?php if(ENABLE_EPA == true){ ?>
                <div class="row">
                    <div class="panel col-lg-12">
                        <div class="panel-heading">
                            <!--<h4 style="padding: 0px 0px 0px 15px;">For Desktops & Laptops</h4>-->
                        </div>
                        <div class="panel-body epas1" style="display:none;">
                            <h4 style="padding: 0px 0px 0px 15px;">No Agents available for download</h4>
                        </div>
                        <div class="panel-body epas">
                            <div class="row">
                                <?php if(WINDOWS_EPA == true){ ?>
                                    <div class="col-lg-4 epaWindows">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWSPC_APP == false){echo 'building';} ?>" <?php if(WINDOWSPC_APP == true){echo 'ng-click="download(\'EPAForWindows\')"';} ?>>
                                            <div class="background">
                                                <i class="fa fa-windows"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows Endpoint</i><br>
                                                <a>Backup Agent for Windows Endpoint</a>
                                            </div>
                                        </div>
                                    </div>
				<?php } ?>
				<?php if($data['Windows_Server_Backup_Enabled'] == 'yes'){?>
                                <?php if($data['isAdmin'] == 'true'){ ?>
				<?php if(WINDOWS_EPA == true){ ?>
				<?php if($data['serverMgmt'] == 'yes'){?>
                                    <div class="col-lg-4 epaWindowsServer">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWSPC_APP == false){echo 'building';} ?>" <?php if(WINDOWSPC_APP == true){echo 'ng-click="download(\'EPAForWindowsServer\')"';} ?>>
                                            <div class="background" style="opacity:0.3!important;">
                                                <img src="<?=Url::templatePath()?>images/windows_server_grey.png" style="height:95px;width:100px;"><!--<i class="fa fa-windows"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows Server</i><br>
                                                <a>Backup Agent for Windows Server</a>
                                            </div>
                                        </div>
				    </div>
				<?php } ?>
                                <?php } ?>
                                <?php } ?>
                                <?php } ?>
                                <?php if(MAC_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip epaMac" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Mac Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(MAC_APP == false){echo 'building';} ?>" <?php if(MAC_APP == true){echo ' ng-click="download(\'EPAForMac\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-apple"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-apple"> For Mac</i><br>
                                                <a>Backup Agent for Mac</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(LINUX_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip epadebLinux" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Linux Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(LINUX_APP == false){echo 'building';} ?>" <?php if(LINUX_APP == true){echo ' ng-click="download(\'EPAForLinuxDeb\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-linux"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-linux"> Backup Agent </i><br>
                                                <a>Debian Package</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(LINUX_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip eparpmLinux" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Linux Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(LINUX_APP == false){echo 'building';} ?>" <?php if(LINUX_APP == true){echo ' ng-click="download(\'EPAForLinuxRpm\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-linux"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-linux"> Backup Agent </i><br>
                                                <a>RPM Package</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <?php if(ENABLE_MOBILE_APPS == true){ ?>
                <div class="row">
                    <div class="panel">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">For Tablets & Smart phones</h4>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <?php if(ENABLE_ANDROID_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(ANDROID_APP == false){echo 'building';} ?>" <?php if(ANDROID_APP == true){echo 'ng-click="download(\'AppForAndroid\')"';} ?>>
                                            <div class="background">
                                                <i class="fa fa-android"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-android"> For Android</i><br>
                                                <a>App for Android</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(ENABLE_WINDOWS_PHONE_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWS_APP == false){echo 'building';} ?>" <?php if(WINDOWS_APP == true){echo 'ng-click="download(\'AppForWindows\')';} ?>>
                                            <div class="background">
                                                <i class="fa fa-windows"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows Phone</i><br>
                                                <a>App for Windows Phone</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(ENABLE_IOS_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble  <?php if(IOS_APP == false){echo 'building';} ?>" <?php if(IOS_APP == true){echo 'ng-click="download(\'AppForMac\')';} ?>>
                                            <div class="background">
                                                <i class="fa fa-apple"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-apple"> For iOS</i><br>
                                                <a>App for iOS</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if($data['isAdmin'] == 'true'){ ?>
            <div role="tabpanel" class="tab-pane" id="advanced">
                <div class="row">
                    <div class="panel col-lg-12">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">Available packages</h4>
                        </div>
                        <div class="row">
                                <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="download('ParabluODBSecondaryAdminMappingApp')">
                                            <div class="background">
                                                <i class="fa fa-cloud"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-cloud"> OneDrive for Business Mapper</i><br>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;margin:5px;">
                                            <p>
                                                Utility that maps your end-users to the appropriate OneDrive for Business storage target their backups need to go to.
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if($data['onedriveBackupEnabled'] == 'true'){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="download('ParabluO365MappingApp')">
                                            <div class="background">
                                                <i class="fa fa-share-alt"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-share-alt"> OneDrive for Business Backup Enabler</i><br>
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;margin:5px;">
                                            <p>
                                                Utility that enables the backup software with appropriate privileges to backup MS OneDrive from Business data from your M365 tenant.
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if($data['exchangeBackupEnabled'] == 'true'){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="download('ParabluODBExchangeMappingApp')">
                                            <div class="background">
                                                <i class="fa fa-envelope"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-envelope"> MS Exchange Online Backup Enabler</i><br>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;margin:5px;">
                                            <p>
                                                Utility that enables the backup software with appropriate privileges to backup your MS Exchange mailbox data from your M365 tenant.
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
</div>
</div>
</div>
<?php } ?>
</div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.building').popover({
        trigger : 'click',
        placement : 'bottom',
        title : function(){
            var t = $(this).attr("id");
            return 'Client Download';
        },
        content : 'Product is not publicly available. If you need this, please contact your relationship manager.'
    });
</script>
<style>
.panel .background {
font-size: 75px !important;
}
.widget-click .widget-body i{
font-size: 16px !important;
}
</style>
