<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 28/10/2022
* @time 18:30 PM
*
 */
?>
<div id="userAlert" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
        <span style="color: white;font-size: 18px;" id="userPercentage"> </span>
        <span class="pull-right" ng-click="closeUserWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div id="storageAlert" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
        <span style="color: white;font-size: 18px;" id="storagePercentage"> </span>
        <span class="pull-right" ng-click="closeStorageWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div class="main" ng-controller="ReportController">
    <span class="d-none currentPage"><?='sbmdashboard'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="d-none domain"><?=$data['domain']?></span>
    <span class="d-none serverMgmt"><?=$data['serverMgmt']?></span>
    <span class="d-none packModel"><?=$data['packModel']?></span>
    <span class="forceSessionLogoutAfterChangepassword d-none"><?=$data['forceSessionLogoutAfterChangepassword']?></span>
    <span class="showAccessCodeOnFirstLogin d-none"><?=$data['showAccessCodeOnFirstLogin']?></span>
    <span class="reportProductType d-none"><?='backup'?></span>
    <div class="row profile">        
	<div class="col-lg-12 col-md-12 col-sm-12">
<div class="modal fade" id="confirmationModalEndPoint" tabindex="-1" role="dialog" aria-labelledby="confirmationModalEndPointLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" >Warning</h5>
      </div>
      <div class="modal-body">
        There are unsaved changes. Are you sure you want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" id="confirmCancelChangeEndPoint">Cancel</button>
        <button type="button" class="btn btn-primary" id="confirmTabChangeEndPoint">Proceed</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="confirmationModalServer" tabindex="-1" role="dialog" aria-labelledby="confirmationModalServerLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Warning</h5>
      </div>
      <div class="modal-body">
        There are unsaved changes. Are you sure you want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" id="confirmCancelChangeServer">Cancel</button>
        <button type="button" class="btn btn-primary" id="confirmTabChangeServer">Proceed</button>
      </div>
    </div>
  </div>
</div>
<!--quota manager start-->
<div class="modal fade qoutaManager" id="quotaManager" data-backdrop="static" data-keyboard="false" style="overflow-y:scroll;">
                <div class="modal-dialog">
                    <div class="modal-content mediumModal">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <div class="panel-heading col-lg-12">
                                <h4 class="currentBackup text-center">License Optimizer </h4>
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;font-size: small;">
                            <li role="presentation" class="nav-item"><a href="" id="endpointOptimizerM" class="nav-link active" data-target="#endpointOptimizer" aria-controls="endpoint" role="tab" data-toggle="tab">Endpoint</a></li>
                            <?php if($data['serverMgmt'] == 'yes'){?>
                            <li role="presentation" class="nav-item"><a href="" id="serverOptimizerM" class="nav-link" data-target="#serverOptimizer" aria-controls="server" role="tab" data-toggle="tab">Server Backup</a></li>
                            <?php } ?>
                    </ul>
                <?php } ?>
            <br>
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="endpointOptimizer">
                            <div class="row">
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Users</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalNoOfActiveUsers }} / {{statisticsOptimizer.totalNoOfUsersAlloted}}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalStorageUtilized }} / {{ statisticsOptimizer.totalStorageAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <span class="hide" id="actual_totalNoOfActiveUsers"></span>
                                <span class="hide" id="actual_totalStorageUtilized"></span>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Users will be reduced by</p><p id="usersReducedTo" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6 optimizerDiv" style="border: 1px solid #F27331!important;border-radius: 10px;height:350px;overflow-y:scroll;">
                                        <h4 style="text-align:center;text-decoration:underline;margin:5%;">Select Users and Assets to delete.</h2>
                                        <span ng-if="quotaDevices1.length <= 0">No data available</span>
                                        <div class="col-lg-12" ng-repeat="(key, devices) in quotaDevices1" class="item">
                                                <label><input type="checkbox" id="parent_{{key}}" value="{{key}}" ng-model="selectAll[key]" ng-change="toggleSelectAll(key)" style="margin-right:10px;" ><i class="fa fa-user"></i> {{ key }}</label>
                                                <span class="item-title" ng-click="toggleCollapse(key)" ng-class="{'no-children': quotaDevices1[key].length === 0}">
                                                        <span ng-if="!isExpanded[key]" style="color:green;"><i class="fa fa-plus-circle"></i></span>
                                                        <span ng-if="isExpanded[key]" style="color:red;"><i class="fa fa-minus-circle"></i></span>
                                                </span>
                                                <p ng-repeat="device in devices track by $index" style="margin-left:10%;" class="expandable" ng-class="{'expanded': isExpanded[key]}"><label><input type="checkbox" class="child_{{key}}" value="{{device.deviceUUID}}" ng-model="device.selected" ng-change="toggleSelection(device, key)" style="margin-right:10px;"><i class="fa fa-{{ device.icon }} fa-1x"></i> {{device.name}} [{{device.storageUsedByDeviceGB}}]</label></p>
                                                <hr style="margin-top:unset;margin-bottom: 10px;">
                                        </div>
                                </div>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Managed Data will be reduced by</p><p id="storageReducedTo" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row col-lg-12 "style="justify-content:center;margin-top:10px;">
                                <a class="btn btn-success btn-small" ng-click="applyCompliance()" href="javascript:;">Apply</a>
                                <a class="btn btn-primary btn-small" id="closeQuotaManagerEndpoint" ng-click="cancelQuotaManagerEndpoint()" href="javascript:;">Reset</a>
                            </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="serverOptimizer">
                            <div class="row">
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-users"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Servers</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalNoOfServerDevices }} / {{statisticsOptimizer.totalNoOfServersAlloted}}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-desktop"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalStorageUtilized }} / {{ statisticsOptimizer.totalStorageAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                             </div>
                            <div class="row col-lg-12">
                                <span class="hide" id="actual_totalNoOfActiveServers"></span>
                                <span class="hide" id="actual_totalStorageUtilizedServer"></span>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Servers will be reduced by</p><p id="serversReducedTo" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6 optimizerDivServer" style="border: 1px solid #F27331!important;border-radius: 10px;height:350px;overflow-y:scroll;">
                                        <h4 style="text-align:center;text-decoration:underline;margin:5%;">Select Servers to delete.</h2>
                                        <span ng-if="quotaServers1.length <= 0">No data available</span>
                                        <div class="col-lg-12" ng-repeat="server in quotaServers1" class="item">
                                                <label><input type="checkbox" id="parent_{{server.name}}" value="{{server.uuId}}" ng-model="server.selected" ng-change="toggleSelectionServer(server)" style="margin-right:10px;" ><i class="fa fa-desktop"></i> {{ server.name }} [{{server.storageUsedByDeviceGB}}]</label>
                                                <hr style="margin-top:unset;margin-bottom: 10px;">
                                        </div>
                                </div>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Managed Data will be reduced by</p><p id="storageReducedToServer" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row col-lg-12 "style="justify-content:center;margin-top:10px;">
                                <a class="btn btn-success btn-small" ng-click="applyComplianceServer()" href="javascript:;">Apply</a>
                                <a class="btn btn-primary btn-small" id="closeQuotaManagerServer" ng-click="cancelQuotaManagerServer()" href="javascript:;">Reset</a>
                            </div>
                    </div>
                </div>

                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;justify-content:center;">
                            <a class="btn btn-default btn-small" id="closeQuotaManager" href="javascript:;">Close</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade applyComplianceNewConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body" ng-if="inCompliance == 'Yes'">
                            <p>
                                <span>Are you sure you want to apply the changes?</span>
                            </p>
<div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        These changes may require some time to take effect.
                                    </p>
                                </div>
                            </div>
                        </div>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="applyComplianceNewConfirmation()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                        <div class="modal-body" ng-if="inCompliance == 'No'">
                            <p>
                                <span>You might want to reduce the storage consumption a down to {{storageCompliancePercentage}}GB little more in order to ensure that your next few scheduled backups are successful.</span>
                            </p>
                            <button type="button" class="btn btn-success" data-dismiss="modal" style="float:right;">Yes</button>
                            <button type="button" ng-click="applyComplianceNewConfirmation()" class="btn btn-default" style="float:right;margin-right:5px;">No</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade gotoDeviceComplianceConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation for moving to Storage Compliance</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span>It seems that Users are still not in compliance state. Do you wish to go for Storage Compliance?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="gotoDeviceComplianceConfirm()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade gotoUserComplianceConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation for moving to User Compliance</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span>It seems that Storage is still not in compliance state. Do you wish to go for User Compliance?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="gotoUserComplianceConfirm()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade applyComplianceNewConfirmationServer">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body" ng-if="inComplianceServer == 'Yes'">
                            <p>
                                <span>Are you sure you want to apply the changes?</span>
                            </p>
<div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        These changes may require some time to take effect.
                                    </p>
                                </div>
                            </div>
                        </div>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="applyComplianceNewConfirmationServer()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                        <div class="modal-body" ng-if="inComplianceServer == 'No'">
                            <p>
                                <span>You might want to reduce the storage consumption a down to {{storageCompliancePercentageServer}}GB little more in order to ensure that your next few scheduled backups are successful.</span>
                            </p>
                            <button type="button" class="btn btn-success" data-dismiss="modal" style="float:right;">Yes</button>
                            <button type="button" ng-click="applyComplianceNewConfirmationServer()" class="btn btn-default" style="float:right;margin-right:5px;">No</button>
                        </div>
                    </div>
                </div>
            </div>
<!--qouta manager end-->
		<!--global tabs start-->
		<?php if(isMobile()){ ?>
                    <ul class="nav nav-pills flex-column parentTabs" style="border: 1px solid #EC6621;border-radius: 10px;">
			    <li class="nav-item" style="display:unset !important;"><a href="" id="endpointM" class="nav-link parentLink" data-target="#endpoint" aria-controls="endpoint" aria-expanded="true" data-toggle="tab">Endpoint Backup Management</a></li>
			    <?php if($data['Windows_Server_Backup_Enabled'] == 'yes'){ ?>
			    	<?php if($data['serverMgmt'] == 'yes'){?>			    
			    		<li class="nav-item" style="display:unset !important;"><a href="" id="serverM" class="nav-link parentLink" data-target="#server" aria-controls="server" aria-expanded="false" data-toggle="tab">Server Backup Management</a></li>
			    	<?php } ?>
			    <?php } ?>
                    </ul>
                <?php } ?>
		<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs parentTabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">
			    <li role="presentation" class="nav-item"><a href="" id="endpointM" class="nav-link parentLink" data-target="#endpoint" aria-controls="endpoint" role="tab" data-toggle="tab">Endpoint Backup Management</a></li>
			    <?php if($data['Windows_Server_Backup_Enabled'] == 'yes'){ ?>
			    	<?php if($data['serverMgmt'] == 'yes'){?>
			    		<li role="presentation" class="nav-item"><a href="" id="serverM" class="nav-link parentLink" data-target="#server" aria-controls="server" role="tab" data-toggle="tab">Server Backup Management</a></li>
			    	<?php } ?>
			    <?php } ?>
                    </ul>
	    	<?php } ?>
		<!--global tabs end-->
<div class="tab-content" style="border: 2px solid #F27331;border-radius: 10px;">
                    <div role="tabpanel" class="tab-pane" id="endpoint">
<!--new start-->
<!--endpoint tabs starts-->
		<?php if(isMobile()){ ?>
                    <ul class="nav nav-pills flex-column childTabs" style="border: 1px solid #EC6621;border-radius: 10px;">
                            <li class="nav-item" style="display:unset !important;"><a href="" id="userM" class="nav-link" data-target="#user" aria-controls="user" aria-expanded="true" data-toggle="tab">User Management</a></li>
                            <li class="nav-item" style="display:unset !important;"><a href="" id="deviceM" class="nav-link" data-target="#device" aria-controls="device" aria-expanded="false" data-toggle="tab">Asset Management</a></li>
                            <li class="nav-item" style="display:unset !important;"><a href="" id="policyM" class="nav-link" data-target="#policy" aria-controls="policy" aria-expanded="false" data-toggle="tab">Policy Management</a></li>
		     	    <li class="nav-item" style="display:unset !important;"><a href="" id="reportM" class="nav-link" data-target="#report" aria-controls="report" aria-expanded="false" data-toggle="tab">Reports</a></li>
                    </ul>
		<?php } ?>
		<?php if(!isMobile()){ ?>
		    <ul class="nav nav-tabs childTabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: small;<?php }else { ?> font-size: small;<?php } ?>">
			    <li role="presentation" class="nav-item hide"><a href="" class="nav-link" data-target="#overview" aria-controls="overview" role="tab" data-toggle="tab">Overview</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="userM" class="nav-link" data-target="#user" aria-controls="user" role="tab" data-toggle="tab">User Management</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="deviceM" class="nav-link" data-target="#device" aria-controls="device" role="tab" data-toggle="tab">Asset Management</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="policyM" class="nav-link" data-target="#policy" aria-controls="policy" role="tab" data-toggle="tab">Policy Management</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="reportM" class="nav-link" data-target="#report" aria-controls="report" role="tab" data-toggle="tab">Reports</a></li>
			    <li class="hide" role="presentation" class="nav-item"><a href="" id="userKK" class="nav-link" data-target="#userkk" aria-controls="report" role="tab" data-toggle="tab">User Name</a></li>
                    </ul>
		<?php } ?>
<!--endpoint tabs ends-->
	    <div class="tab-content">
		    <div role="tabpanel" class="tab-pane" id="userkk">
<!--del user details start-->
<div class="row">                                    
                <div class="col-lg-9">
                    <div class="panel col-lg-12">                        
                        <div class="panel-body">
                            <div class="error col-lg-12" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                            <?= Form::open(array(
                                'method' => 'post',
                                'ng-submit' => 'saveUserDetails()',
                                'class' => 'userSettingsForm',
				'id' => 'userSettingsForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            )); ?>

			    <div class="row" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Basic Information', 'keywords')?></legend>
                            <div class="form-group col-lg-6 d-none">
                                <label for="user_name"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="user_name" id="user_name" value="<?=$data['userDetails']->{'user-name'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="password_hash"><?=Language::show('password_hash', 'keywords');?></label>
				<input type="text" class="form-control" name="password_hash" id="password_hash" value="<?=$data['userDetails']->{'password-hash'}?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('password_hash', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="aadLoginId"><?=Language::show('aadLoginId', 'keywords');?></label>
                                <input type="text" class="form-control" name="aadLoginId" id="aadLoginId" value="<?=$data['userDetails']->{'aadLoginId'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('aadLoginId', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="is_guest"><?=Language::show('Is Guest', 'keywords');?></label>
                                <input type="text" class="form-control" name="is_guest" id="is_guest" value="<?=$data['userDetails']->{'is-guest'};?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="local_user"><?=Language::show('local_user', 'keywords');?></label>
                                <input type="text" class="form-control" name="local_user" id="local_user" value="<?=$data['userDetails']->{'localUser'};?>" autocomplete="off">
			    </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="superAdmin"><?=Language::show('Super Admin', 'keywords');?></label>
                                <input type="text" class="form-control" name="superAdmin" id="superAdmin" value="<?=$data['userDetails']->{'superAdmin'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="softBlockedTime"><?=Language::show('Soft Blocked Time', 'keywords');?></label>
                                <input type="text" class="form-control" name="softBlockedTime" id="softBlockedTime" value="<?=$data['userDetails']->{'softBlockedTime'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="lastLoginTime"><?=Language::show('lastLoginTime', 'keywords');?></label>
                                <input type="text" class="form-control" name="lastLoginTime" id="lastLoginTime" value="<?=$data['lastLoggedInTime'];?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="userNameLowerCase"><?=Language::show('userNameLowerCase', 'keywords');?></label>
                                <input type="text" class="form-control" name="userNameLowerCase" id="userNameLowerCase" value="<?=$data['userDetails']->{'user-name-lower-case'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="consentGiven"><?=Language::show('User Consent', 'keywords');?></label>
                                <input type="text" class="form-control" name="consentGiven" id="consentGiven" value="<?=$data['userDetails']->{'user-consent'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="consentGivenTime"><?=Language::show('User Consent Time', 'keywords');?></label>
                                <input type="text" class="form-control" name="consentGivenTime" id="consentGivenTime" value="<?=$data['userDetails']->{'user-consent-time'};?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="recovery_key"><?=Language::show('recovery_key', 'keywords');?></label>
                                <input type="text" class="form-control" name="recovery_key" id="recovery_key" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('recovery_key', 'keywords');?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="google_secret_key"><?=Language::show('google_secret_key', 'keywords');?></label>
                                <input type="text" class="form-control" name="google_secret_key" id="google_secret_key" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('google_secret_key', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="backupTargetErrorCode"><?=Language::show('Backup Target Error Code', 'keywords');?></label>
                                <input type="text" class="form-control" name="backupTargetErrorCode" id="backupTargetErrorCode" value="<?=$data['userDetails']->{'backupTargetErrorCode'};?>" autocomplete="off">
                            </div>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="is_first_login" id="is_first_login" required="">
                                        <option value="true" <?php if($data['userDetails']->{'is-first-login'} == 'true'){ ?>selected<?php } ?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-first-login'} == 'false'){ ?>selected<?php } ?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords');?></label>
                                    <input type="text" class="form-control" name="is_first_login" id="is_first_login" value="<?php if($data['userDetails']->{'is-first-login'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('is_first_login', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>                            
                                <div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_status" id="account_status" value="<?php if($data['userDetails']->{'is-active'} == 'true'){ echo Language::show('activate', 'keywords'); }else{ echo Language::show('de_activate', 'keywords'); } ?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('account_status', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
			    <div class="form-group col-lg-6">
                                <label for="displayName"><?=Language::show('displayName', 'keywords');?></label>
                                <input type="text" class="form-control" name="displayName" id="displayName" value="<?=$data['userDetails']->{'display-name'};?>" autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed." <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true' || $data['userDetails']->{'site'} == 'true' || $data['activateEdit'] == false){ echo 'readonly';}?>>
                            </div>
                            <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                <label for="location"><?=Language::show('location', 'keywords');?></label>
                                <input type="text" class="form-control" name="location" id="location" value="<?=$data['userDetails']->{'location'};?>" autocomplete="off" <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true' || $data['userDetails']->{'site'} == 'true' || $data['activateEdit'] == false){ echo 'readonly';}?>>
                            </div>
                            <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                <label for="department"><?=Language::show('department', 'keywords');?></label>
                                <input type="text" class="form-control" name="department" id="department" value="<?=$data['userDetails']->{'department'};?>" autocomplete="off" <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true' || $data['userDetails']->{'site'} == 'true' || $data['activateEdit'] == false){ echo 'readonly';}?>>
                            </div>
			    <?php if($data['userDetails']->{'site'} != 'true'){ ?>
				    <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'} && $data['loggedInUser']['readOnlyAdmin'] != true){ ?>
					<div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
					    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords')?></label>
					    <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                                <option value="admin" <?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('admin', 'keywords')?></option>
                                                <option value="read_only_admin" <?php if($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('read_only_admin', 'keywords')?></option>
                                                <option value="user" <?php if($data['userDetails']->{'is-admin'} != 'true' && $data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'selected';}?>><?=Language::show('user', 'keywords')?></option>
					    </select>
					</div>
					<div class="form-group col-lg-3 readOnlyAdminRole" <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ ?> style="display:none;" <?php } ?> <?php if($data['userDetails']->{'spAdmin'} == 'true'){ ?> style="display:none;" <?php } ?>>
						<label for="readOnlyAdminRole">Read Only Admin</label>
						<div class="row">
							<div class="col-lg-2">
								<label class="switch" style="margin-left: 15px;">
								<input id="switchrole" name="delegatedAdmin" <?php if($data['userDetails']->{'delegated-admin'} == 'true'){ ?> checked <?php } ?> type="checkbox">
								<div class="slider round"></div>
								</label>
							</div>
						</div>
					</div>
				    <?php }else{ ?>
					<div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
					    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords');?></label>
					    <input type="text" class="form-control" name="account_type" id="account_type" value="<?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'Admin';}elseif($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo Language::show('read_only_admin','keywords');}elseif($data['userDetails']->{'is-guest'} == 'true'){ echo Language::show('Guest','keywords');}else{ echo Language::show('user','keywords');}?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('account_type', 'keywords');?>" required autocomplete="off" readonly>
					</div>
					<div class="form-group col-lg-3 readOnlyAdminRole" <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ ?> style="display:none;" <?php } ?>>
						<label for="readOnlyAdminRole">Read Only Admin</label>
						<div class="row">
							<div class="col-lg-2">
								<label class="switch" style="margin-left: 15px;">
								<input id="switchrole" name="delegatedAdmin" <?php if($data['userDetails']->{'delegated-admin'} == 'true'){ ?> checked <?php } ?> type="checkbox" disabled>
								<div class="slider round"></div>
								</label>
							</div>
						</div>
					</div>
				    <?php } ?>
			    <?php } else { ?>
				<div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_type" id="account_type" value="Site" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('account_type', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
			    <?php } ?>			    
			    <div class="form-group col-lg-6 spPolicyName <?php if($data['userDetails']->{'site'} == 'false'){echo 'd-none';}?>">
                                    <label for="spPolicyName" style="margin-bottom:0px;"><?=Language::show('SharePoint Online Policy Name', 'keywords');?></label>
				    <input type="text" class="form-control" name="spPolicyName" id="spPolicyName" value="<?=$data['userDetails']->{'spPolicyName'}?>" <?php if($data['userDetails']->{'site'} == 'true'){ ?> required <?php } ?> autocomplete="off" readonly>
                                </div>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 d-none share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true" <?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'share-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 d-none share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <input type="text" class="form-control" name="share_enabled" id="share_enabled" value="<?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                <label for="email_address"><?=Language::show('email_address', 'keywords');?></label>                            
                                <input type="email" class="form-control" name="email_address" id="email_address" value="<?=$data['userDetails']->{'email-id'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email_address', 'keywords');?>" <?php if($data['userDetails']->{'site'} != 'true'){ ?> required <?php } ?> autocomplete="off" <?php if($data['activateEdit'] == false){ echo 'readonly';}?> <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true'){ echo 'readonly';}?>>
                            </div>
                            <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
				    <?php if($data['oneDriveBackupType'] != 'NONMUX'){ ?>
					<div class="form-group col-lg-6">
					    <label for="odb_login_Id"><?=Language::show('Backup Target', 'keywords');?></label>
					    <input type="text" class="form-control" name="odb_login_Id" id="odb_login_Id" value="<?=$data['userDetails']->{'odb-loginId'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('OneDrive for Business Login Id', 'keywords');?>" autocomplete="off" <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true'){ echo 'readonly';}?> <?php if($data['oneDriveBackupType'] == 'MUX'){ ?> required <?php } ?>>
					</div>
				    <?php } ?>
                            <?php } ?>
			    <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="backupTargetAssigned"><?=Language::show('Backup Target Assigned', 'keywords');?></label>
                                    <input type="text" class="form-control" name="backupTargetAssigned" id="backupTargetAssigned" value="<?php if($data['userDetails']->{'backupTargetAssigned'} == 'true'){ echo Language::show('Yes', 'keywords'); }else{ echo Language::show('No', 'keywords'); } ?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Backup Target Assigned', 'keywords');?>" autocomplete="off" readonly>
                                </div>
                            <?php } ?>
			    <div class="form-group col-lg-6 hide">
			    	<label for="oneDriveBackupType"><?=Language::show('OneDrive Backup Type', 'keywords');?></label>
			    	<input type="text" class="form-control" name="oneDriveBackupType" id="oneDriveBackupType" value="<?=$data['oneDriveBackupType'];?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('OneDrive Backup Type', 'keywords');?>" autocomplete="off">
			    </div>

</div>
			    <div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'site'} == 'true') { echo 'd-none'; } ?> <?php if($data['managedBackup'] == 'No') { echo 'd-none'; } ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
<?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'd-none';}?> <?php if(DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>" <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?> style="pointer-events: none;" <?php } ?>>
                                    <label for="backup" style="margin-bottom:0px;"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?>>
                                        <option value="true" <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'd-none';}?> <?php if(DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="backup" id="backup" value="<?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('backup', 'keywords');?>" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
<?php if(Auth::checkCloudPermission('backup') == true) { ?>
                            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                            <div class="form-group col-lg-6 backup backupPolicyName <?php if(Auth::checkCloudPermission('backup') == false || DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>">
                                    <label for="policyName"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName1" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['backupPolicies'])){ ?>
                                            <?php foreach($data['backupPolicies'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>" <?php if($data['userDetails']->{'policy-name'} == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } else { ?>
                            <div class="form-group col-lg-6">
                                <label for="policy_name"><?=Language::show('policy_name', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policy_name" value="<?=$data['userDetails']->{'policy-name'};?>" autocomplete="off" readonly>
                            </div>
                            <?php } ?>
<?php } ?>
<?php if(Auth::checkCloudPermission('backup') == true) { ?>	
<?php
            $backupPoliciesAdmin = [];
            if(!empty((array)$data['userDetails']->{'backupPoliciesAdmin'}->{'backupPolicyAdmin'})){
               foreach($data['userDetails']->{'backupPoliciesAdmin'}->{'backupPolicyAdmin'} as $key => $value){
                    $backupPoliciesAdmin = array_merge($backupPoliciesAdmin, array((string)$value));
               }
            }
        ?>
        <div class="form-group col-lg-12 backupPoliciesAdmin <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'd-none';}?>">
            <label for="backupPoliciesAdmin">Manage Backup Policies</label>
            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                <select name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" class="form-control selectPicker" title="Select Backup Policies Name" multiple data-selected-text-format="count > 7">
                            <?php if(!empty($data['backupPolicies'])){ ?> 
                                <?php foreach($data['backupPolicies'] as $key => $value){ 
                                $label = $value;
                                if( strlen( $label ) > 25 ) {
                                   $label = substr( $label, 0, 25 ) . '...';
                                }
                                ?>
                                    <option value="<?=$value?>"<?php if(in_array($value,$backupPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                <?php } ?>
                            <?php } ?>
                </select>
            <?php } else { ?>
                <input type="text" class="form-control" name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" value="<?=implode(',', $backupPoliciesAdmin);?>" autocomplete="off" readonly>
            <?php } ?>
        </div>
	<?php } ?>
	</div>
<div class="row <?php if(DISABLE_BLUSYNC == true || Auth::checkCloudPermission('sync') == false) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'site'} == 'true') { echo 'd-none'; } ?> <?php if($data['managedSync'] == 'No') { echo 'd-none'; } ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('BluSync Information', 'keywords')?></legend>

<?php
                            $miniClouds = [];
                            if(!empty((array)$data['userDetails']->{'mini-clouds'}->{'mini-cloud'})){
                                foreach($data['userDetails']->{'mini-clouds'}->{'mini-cloud'} as $key => $value){
                                    $miniClouds = array_merge($miniClouds, array((string)$value->{'mini-cloud-name'}));
                                }
                            }
                            ?>
                            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['miniClouds']->{'mini-cloud'} as $key => $value){ ?>
                                            <?php
                                                $trimmedName = str_replace("_mc_","",$value->{'mini-cloud-name'});
                                            ?>
                                                <option value="<?=$value->{'mini-cloud-name'}?>" <?php if(in_array($value->{'mini-cloud-name'}, $miniClouds)){ echo 'selected';}?>><?=$trimmedName?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php }else{ ?>
                                <?php if(!empty($miniClouds)){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords');?></label>
                                        <input type="text" class="form-control" name="miniCloudName" id="miniCloudName" value="<?=implode(',', $miniClouds);?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('miniCloud', 'keywords');?>" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
                            <?php } ?>                            
			    <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 sync <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>" <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?> style="pointer-events: none;" <?php } ?>>
                                    <label for="sync" style="margin-bottom:0px;">BluSync</label>
                                    <select class="form-control selectPicker" name="sync" id="sync" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <option value="true" <?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'sync-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 sync <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="sync">BluSync</label>
                                    <input type="text" class="form-control" name="sync" id="sync" value="<?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync', 'keywords');?>" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
	
			    <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 syncAccessType syncAccessTypeBlock <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'sync-enabled'} == 'false'){ echo 'd-none'; } ?>">
                                    <label for="syncAccessType">BluSync Access</label>
                                    <select class="form-control selectPicker" name="syncAccessType" id="syncAccessType" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <option value="WEBONLY" <?php if($data['userDetails']->{'sync-enabled'} =='true' && $data['userDetails']->{'syncAccessType'} =='WEBONLY'){echo 'selected';}?>><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="WEBANDENDPOINT" <?php if($data['userDetails']->{'syncAccessType'} =='WEBANDENDPOINT'){echo 'selected';}?>><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>                    
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 syncAccessType syncAccessTypeBlock <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'sync-enabled'} == 'false'){ echo 'd-none'; } ?>">
                                    <label for="syncAccessType">BluSync Access</label>
                                    <input type="text" class="form-control" name="syncAccessType" id="syncAccessType" value="<?php if($data['userDetails']->{'syncAccessType'} =='WEBANDENDPOINT'){ echo Language::show('epa_web_access', 'keywords'); }else if($data['userDetails']->{'syncAccessType'} =='WEBONLY'){ echo Language::show('web_access', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync_access', 'keywords');?>" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>                            
                            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                            <div class="form-group col-lg-6 sync <?php if(Auth::checkCloudPermission('sync') == false || DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="syncPolicyName">BluSync Policy Name</label><br/>
                                    <select class="form-control selectPolicyPicker" name="syncPolicyName" id="syncPolicyName" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                            <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>" <?php if($data['userDetails']->{'sync-policy-name'} == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } else { ?>
                            <div class="form-group col-lg-6">
                                <label for="sync_policy_name">BluSync Policy Name</label>
                                <input type="text" class="form-control" name="syncPolicyName" id="sync_policy_name" value="<?=$data['userDetails']->{'sync-policy-name'};?>" autocomplete="off" readonly>
                            </div>
                            <?php } ?>
<?php //} ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'd-none';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true" <?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'server-backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'd-none';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="serverBackup" id="serverBackup" value="<?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('serverBackup', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
			   <?php if(Auth::checkCloudPermission('sync') == true) { ?>
			   <?php
                                $syncPoliciesAdmin = [];
                                if(!empty((array)$data['userDetails']->{'syncPoliciesAdmin'}->{'syncPolicyAdmin'})){
                                   foreach($data['userDetails']->{'syncPoliciesAdmin'}->{'syncPolicyAdmin'} as $key => $value){
                                        $syncPoliciesAdmin = array_merge($syncPoliciesAdmin, array((string)$value));
                                   }
                                }
                            ?>
                            <div class="form-group <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?> col-lg-6 <?php } else { ?> col-lg-12 <?php } ?> syncPoliciesAdmin <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'd-none'; } ?>">
                                    <label for="syncPoliciesAdmin">Manage BluSync Policies</label> 
                                    <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                    <select name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" class="form-control selectPicker" title="Select BluSync Policies Name" multiple data-selected-text-format="count > 7">
                                        <?php if(!empty($data['syncPolicies1'])){ ?> 
                                             <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                             $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                             ?>
                                                <option value="<?=$value?>"<?php if(in_array($value,$syncPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    <?php } else { ?>
                                        <input type="text" class="form-control" name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" value="<?=implode(',', $syncPoliciesAdmin);?>" autocomplete="off" readonly>
                                    <?php } ?>
                            </div>
			    <?php } ?>
			    <?php if($data['userDetails']->{'localUser'} == 'true'){ ?>
			    <div class="form-group col-lg-12 <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>">
                                        <div class="checkbox check-primary">
                                            <input id="autoAgingUsers" name="autoAgingUsers" type="checkbox" value="enabled" onclick="onToggleAgingBlock()" <?php if($data['userDetails']->{'autoExpireType'} != 'DISABLED' ){ echo 'checked';}?>>
                                            <label for="autoAgingUsers"><?=Language::show('Allow automatic user-aging', 'keywords');?></label>
                                        </div>
                            </div>
			    <div class="form-group col-lg-12 autoAgingUsersBlock <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>" style="border: 1px dashed grey;border-radius: 10px;">
				<div class="row">
                                	<div class="form-group col-lg-4">
                                    		<label for="noOfDaysForAutoBlock"><?=Language::show('Number of days after which to auto-block users', 'keywords');?></label>
                                    		<input type="number" class="form-control" name="noOfDaysForAutoBlock" id="noOfDaysForAutoBlock" <?php if($data['userDetails']->{'noOfDaysForAutoBlock'} != '0'){?> value="<?=$data['userDetails']->{'noOfDaysForAutoBlock'}; ?>" <?php } else { ?> value="2000" <?php } ?> placeholder="<?=Language::show('Number of days', 'keywords');?>" autocomplete="off" <?php if($data['userDetails']->{'autoExpireType'} != 'DISABLED'){ ?> min="45" max="2000" required <?php } ?>>
                                	</div>
                                	<div class="col-lg-8" id="chooser" style="margin-left:-14px;margin-top:20px;">
                                        	<div class="col-lg-12" style="margin-bottom:15px;">
                                                    <input type="radio" name="autoExpireType" value="EXPIRE_IDLE_TIME" <?php if($data['userDetails']->{'autoExpireType'} == 'EXPIRE_IDLE_TIME'){echo 'checked';}?>>
                                                        <label for="link" style="display:initial;"><?=Language::show('Number of days of inactivity after which user is automatically blocked', 'keywords');?></label>
							</br>
                                                        <input type="radio" name="autoExpireType" value="EXPIRE_CREATED_TIME" <?php if($data['userDetails']->{'autoExpireType'} == 'EXPIRE_CREATED_TIME'){echo 'checked';}?>>
                                                        <label for="link" style="display:initial;"><?=Language::show('Number of days after user ID creation after which user is automatically blocked', 'keywords');?></label>							
                                                </div>
                                        </div>
				</div>
			    </div>
			    <?php if($data['autoExpireUsers'] != 'DISABLED' ){ ?>
			    <div class="row col-lg-12 helpTextAging <?php if($data['userDetails']->{'autoExpireType'} == 'DISABLED' ){ echo 'd-none';}?>">
				    <div class="col-lg-12">
					<div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
					    <p>
						Users, once blocked will lose access to all products.
						<br/>Applies only to users in the Parablu namespace.
					    </p>
					</div>      
				    </div>      
                            </div>
			    <?php } ?>
			    <?php } ?>
                     </div>
		    <?php if(Auth::checkCloudPermission('office365') == true){ ?>
		    <div class="row <?php if($data['userDetails']->{'site'} == 'true'){ echo 'hide';} ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
			    <legend class="h4" style="color: #585f69;"><?=Language::show('M365 Information', 'keywords')?></legend>
<?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                                <div class="form-group col-lg-6 <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                        <label class="star" for="exchangeBkpEnabled"><?=Language::show('Microsoft Exchange Backup', 'keywords')?></label>
                                        <div class="checkbox check-primary">
                                                <?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                                                        <input id="exchangeBkpEnabled" name="exchangeBkpEnabled" type="checkbox" value="enabled" <?php if($data['userDetails']->{'exchangeBkpEnabled'} == 'true'){ ?> checked <?php } ?> <?php if($data['activateEdit'] != true){ ?> disabled <?php } ?>>
                                                        <label for="exchangeBkpEnabled"><?=Language::show('Enable Exchange', 'keywords');?></label>
                                                <?php } ?>
                                        </div>
                                </div>
                                <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 odbPolicyName">
                                    <label for="exchangePolicyName"><?=Language::show('Microsoft Exchange Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="exchangePolicyName" id="exchangePolicyName" required="">
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['userDetails']->{'exchangePolicyName'} == $value){echo 'selected';}?>><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                <?php } else { ?>
                                	<div class="form-group col-lg-6">
                                        <label for="exchangePolicyName"><?=Language::show('Microsoft Exchange Policy Name', 'keywords');?></label>
                                        <input type="text" class="form-control" name="exchangePolicyName" id="exchangePolicyName" value="<?=$data['userDetails']->{'exchangePolicyName'};?>" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
<?php } ?>
<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
<div class="form-group col-lg-6 <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                        <label class="star" for="onedriveBkpEnabled"><?=Language::show('OneDrive for Business Backup', 'keywords')?></label>
                                        <div class="checkbox check-primary">
                                                <?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
                                                        <input id="onedriveBkpEnabled" name="onedriveBkpEnabled" type="checkbox" value="enabled" <?php if($data['userDetails']->{'onedriveBkpEnabled'} == 'true'){ ?> checked <?php } ?> <?php if($data['activateEdit'] != true){ ?> disabled <?php } ?>>
                                                        <label for="onedriveBkpEnabled"><?=Language::show('Enable OneDrive', 'keywords');?></label>
                                                <?php } ?>

                                        </div>
                                </div>
                                <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 oneDrivePolicyName">
                                    <label for="oneDrivePolicyName"><?=Language::show('OneDrive for Business Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="oneDrivePolicyName" id="oneDrivePolicyName" required="">
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['userDetails']->{'oneDrivePolicyName'} == $value){echo 'selected';}?>><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                <?php } else { ?>
                                    <div class="form-group col-lg-6">
                                        <label for="oneDrivePolicyName"><?=Language::show('OneDrive for Business Policy Name', 'keywords');?></label>
                                        <input type="text" class="form-control" name="oneDrivePolicyName" id="oneDrivePolicyName" value="<?=$data['userDetails']->{'oneDrivePolicyName'};?>" autocomplete="off" readonly>
                                    </div>
				<?php } ?>
<?php } ?>
<?php if(Auth::checkCloudPermission('sharepoint') == true){ ?>
<div class="form-group col-lg-6 <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                        <label class="star" for="sharePointBkpEnabled"><?=Language::show('SharePoint Online Backup', 'keywords')?></label>
                                        <div class="checkbox check-primary">
                                                <?php if(Auth::checkCloudPermission('sharepoint') == true){ ?>
                                                        <input id="sharePointBkpEnabled" name="sharePointBkpEnabled" type="checkbox" value="enabled" <?php if($data['userDetails']->{'sharePointBkpEnabled'} == 'true'){ ?> checked <?php } ?> <?php if($data['activateEdit'] != true){ ?> disabled <?php } ?>>
                                                        <label for="sharePointBkpEnabled"><?=Language::show('Enable SharePoint Online', 'keywords');?></label>
                                                <?php } ?>
                                        </div>
                                </div>
                                <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 spPolicyName">
                                    <label for="spPolicyName"><?=Language::show('SharePoint Online Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="spPolicyName" id="spPolicyName" required="">
                                        <?php if(!empty($data['spPolicies1'])){ ?>
                                            <?php foreach($data['spPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" <?php if($data['userDetails']->{'spPolicyName'} == $value){echo 'selected';}?>><?=$value?></option>
                                            <?php } ?>
					<?php } ?>
				    </select>
                                    </div>
                                <?php } else { ?>
                                    <div class="form-group col-lg-6">
                                        <label for="spPolicyName"><?=Language::show('SharePoint Online Policy Name', 'keywords');?></label>
                                        <input type="text" class="form-control" name="spPolicyName" id="spPolicyName" value="<?=$data['userDetails']->{'spPolicyName'};?>" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
<?php } ?>
<?php
            $odbPoliciesAdmin = [];
            if(!empty((array)$data['userDetails']->{'odbPoliciesAdmin'}->{'odbPolicyAdmin'})){
               foreach($data['userDetails']->{'odbPoliciesAdmin'}->{'odbPolicyAdmin'} as $key => $value){
                    $odbPoliciesAdmin = array_merge($odbPoliciesAdmin, array((string)$value));
               }
            }
        ?>
        <div class="form-group odbPoliciesAdmin col-lg-12" <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ ?> style="display:none;" <?php } ?>>
            <label for="odbPoliciesAdmin">Manage M365 Policies</label>
                <select name="odbPoliciesAdmin[]" id="odbPoliciesAdmin" class="form-control selectPicker" title="Select office 365 Policies Name" multiple data-selected-text-format="count > 7">
                            <?php if(!empty($data['allPolicies'])){ ?>
                                <?php foreach($data['allPolicies'] as $key => $value){
                                $label = $value;
                                if( strlen( $label ) > 25 ) {
                                   $label = substr( $label, 0, 25 ) . '...';
                                }
                                ?>
                                    <option value="<?=$value?>"<?php if(in_array($value,$odbPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                <?php } ?>
                            <?php } ?>
                </select>
	</div>
<!-- manage end -->
<?php } ?>
<?= Form::close(); ?>
</div>
</div>
</div>
</div>
<!--del user details end-->

		    </div>
                    <div role="tabpanel" class="tab-pane" id="user">
<br>
		    <!--backup start-->
<div class="row">
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-users"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Users</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalNoOfActiveUsers }} / {{ statistics.totalNoOfUsersAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-desktop"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalStorageUtilized }} / {{ statistics.totalStorageAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-danger" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-history"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Assets Installed</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalNoOfDevices }}</span>
                                            </div>
                                        </div>
                                </div>
</div>
		    <div class="panel" style="height:500px;overflow:scroll;">
		    <div class="panel-heading">
                    <h4>
			<?=Language::show('list_of_users', 'keywords');?>                        
                        <!--<a ng-click="exportUsersToExcel()" class="btn btn-small btn-primary <?php if(!isMobile()) { ?> pull-right <?php } ?>">Export Users</a>-->
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == true || \Helpers\Auth::checkCloudPermission('sync') == true){ ?>
                            <a class="btn btn-success btn-small pull-right d-none"  href="<?=Url::basePath('userGroup')?>">Manage User Group</a>
                        <?php } ?>
                        <?php if(block == false){ ?>
                            <a class="btn btn-primary btn-small pull-right" disabled style="color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>">Manage Users in Bulk</a>
                        <?php } else {?>
                            <?php if(!isMobile()) { ?>
                                <a class="btn btn-primary btn-small pull-right hide" style="color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>">Manage Users in Bulk</a>
                            <?php }else{ ?>
                                <a class="btn btn-primary btn-small hide" style="margin-top: 2px; color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>">Manage Users in Bulk</a>
                            <?php } ?>
                        <?php } ?>
			<button class="btn btn-primary btn-small pull-right" data-toggle="modal" data-target="#addUser">Add Users in Bulk</button>
                    </h4>
                </div>
                <div class="panel-body">
                    <!--<div class="row">
			<form class="col-lg-12" ng-submit="searchUser1()" data-parsley-validate>
				<div class="row">
				    <div class="col-lg-12">
					<select class="assignUsersMsp" name="userNames[]" style="width: 100%;" data-parsley-trigger="change" id="selectAssignUsersMsp" multiple="multiple"></select>
				    </div>
				</div>
			</form>
                    </div>-->
                    <br/>
		    <div class="panel nouserListTable" style="display: none;">
                    	<div>
                        	<h2 align="center">No Users Found</h2>
                    	</div>
                    </div>
                    <div class="table-responsive">
			<div class="h4 loading text-center"><img width="70px" src="<?=Url::templatePath()?>images/gears.gif"></div>
			<div class="form-group col-lg-12" style="margin-top:10px;">
                                <input class="form-control" type="text" id="searchUserInput" onkeyup="searchedUsers()" placeholder="Search for Users.." title="Type in a User Id">
                        </div>
                        <table class="table table-bordered table-striped userListTable" id="userListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-left clickAble" ng-click="sortTypeMSPU = 'emailId'; sortReverseMSPU = !sortReverseMSPU">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortTypeMSPU == 'emailId' && !sortReverseMSPU" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMSPU == 'emailId' && sortReverseMSPU" class="fa fa-caret-down"></span>
				</th>
				<th class="text-left clickAble" ng-click="sortTypeMSPU = 'userName'; sortReverseMSPU = !sortReverseMSPU">
                                    <?=Language::show('Policy', 'keywords')?>
                                    <span ng-show="sortTypeMSPU == 'userName' && !sortReverseMSPU" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMSPU == 'userName' && sortReverseMSPU" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortTypeMSPU = 'timeinmillis'; sortReverseMSPU = !sortReverseMSPU">
                                    <?=Language::show('Last Modified Time', 'keywords')?>
                                    <span ng-show="sortTypeMSPU == 'timeinmillis' && !sortReverseMSPU" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMSPU == 'timeinmillis' && sortReverseMSPU" class="fa fa-caret-down"></span>
				</th>
				<th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
			    </thead>
			    <tbody>
			    <tr class="addUserBtnRow">
				<td class="addUserBtnTD"><a class="btn btn-primary btn-small" ng-click="addUserRow()">Add User</a></td>
<td></td>
<td></td>
<td></td>
			    </tr>
<tr class="addUserRow" style="display:none;">
<td>
<div class="form-group">
                                                                    <label for="emailId"><?=Language::show('Email Id', 'keywords')?></label>
                                                                    <input type="text" class="form-control" name="newemailId" id="newemailId" value="" placeholder="Enter Email Id" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@','_','-' and '.' Any other special characters are not allowed.">
								</div>
</td>
<td>
<div class="form-group">
<input type="hidden" class="delegatedAdminPolicy" id="delegatedAdminPolicy" value="<?=$data['policy']?>"/>
                                                                    <label for="policy"><?=Language::show('Policy', 'keywords')?></label>
                                                                    <select class="form-control" name="newpolicy" id="newpolicy">
                                                                        <option value="suspended" selected>No Backup</option>
									<option value="nonsuspended">Backup</option>
                                                                    </select>
                                                                </div>
</td>
<td>
<a class="btn btn-success btn-small" ng-click="addSingleMspUser()" style="margin-top:10%;">Save</a>
<a class="btn btn-danger btn-small addUserCancel" ng-click="addUserCancel()" style="margin-top:10%;">Cancel</a>
</td>

                            </tr>
			    <tr class="existingUsers{{$index}}" ng-repeat="value in users  | orderBy:sortTypeMSPU:sortReverseMSPU track by $index" class="mappingRowUsers{{$index}}">
				<td ng-cloak  title="{{value.emailId}}">{{ value.emailId | limitTo:30}}{{value.emailId.length > 30 ? '...' : ''}}
<input type="hidden" class="gotemail" value="{{value.emailId}}" />
</td>
				<td class="policyNameUsers" ng-cloak>
<input type="hidden" class="gotname" value="{{value.policyName}}" />
					<select class="form-control userPolicy" name="userPolicyMappingPolicyNameUsers{{$index}}" id="userPolicyMappingPolicyNameUsers{{$index}}" onchange="changedPolicy(this.id)" ng-class="{ 'match': value.emailId === '<?= $data['sessionUser'] ?>' }">
					<?php 
						$policy = $data['policy'];
						$policy_staging = $data['policy_staging'];
					?>

						<option value="false" ng-selected="value.suspended == false">Backup</option>
						<option value="true" ng-selected="value.suspended == true">No Backup</option>
                                        </select>
<!--<a class="editUsers btn btn-default btn-small pull-right" ng-click="showMappingListUsers($index)"><i class="fa fa-edit"></i> <?=Language::show('change_policy', 'keywords');?></a>
                                        <a style="display: none;" class="saveUsers btn btn-success btn-small" ng-click="changePolicyUsers($index,value.backupPolicyName)"><i class="fa fa-save"></i> <?=Language::show('save_policy', 'keywords');?></a>
                                        <a style="display: none;" class="saveUsers btn btn-danger btn-small" ng-click="cancelChangePolicyUsers($index)"><i class="fa fa-times"></i> <?=Language::show('cancel', 'keywords');?></a>-->
				</td>
				<td ng-cloak>{{ value.time }}
<input type="hidden" class="time" value="{{value.time}}" />
</td>
<td ng-cloak>
<a ng-show="value.isActive" class="btn btn-warning btn-small" ng-bootbox-confirm="<h4><?=Language::show('blockConfirmMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUserProfile(value.userName, 'true', 'user')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="background: #6d5cae !important;color:white!important;width: 125px;"><?=Language::show('Deactivate', 'keywords');?></a>
<a ng-show="!value.isActive" class="btn btn-success btn-small" ng-bootbox-confirm="<h4>Confirmation</h4><hr><span>Please note that after user re-activation, assets belonging to this user will have to be<ol><li>Re-activated separately from the Asset Management screen.</li><li>Re-installed with the endpoint agent.</li></ol>Are you sure you wish to Re-activate the selected user?</span>" ng-bootbox-confirm-action="unBlockUserProfile(value.userName, 'true', 'user')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('Reactivate', 'keywords');?></a>
<a ng-hide="value.isActive" class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('deleteConfirm', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this user.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteUserProfile(value.userName, 'true', 'user')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('delete', 'keywords');?></a>
</td>                                
			    </tr>
                            </tbody>
			</table>
			<a href="" class="btn btn-small btn-primary clickAble pull-right edittUsers" ng-click="closeMSPUsers()" style="display:none;">Cancel</a>
			<a href="" class="btn btn-small btn-primary clickAble pull-right edittUsers" ng-click="updateMultipleUsersMsp()" style="display:none;">Apply</a>
			<div id="noResultsMessageUser" style="display:none;text-align: center;margin:20px;">No match found</div>
                    </div>
                    <div class="row userListTableNavigate hide">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="updateUsersNavigate('all',first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="updateUsersNavigate('all',previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="updateUsersNavigate('all',next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="updateUsersNavigate('all',last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
		    </div>
		    <!--exportUsersToExcelModal starts-->
		    <div class="modal fade exportUsersToExcelModal" id="exportUsersToExcelModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
			<div class="modal-dialog" role="document">
			    <div class="modal-content">
				<div class="modal-header">
				    <h4 class="modal-title" id="myModalLabel">Export Users</h4>
				    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
				    <div class="col-lg-12" id="chooserUsers">
					<div class="col-lg-6">
						<input type="radio" name="optradioUsers" value="allUsers" checked>
						<label for="link"><?=Language::show('All Users', 'keywords');?></label>
					</div>
				    </div>
				    <br>
				</div>
				<div class="modal-footer">
				    <a ng-click="exportUsersToExcel()" class="btn btn-success">Export Excel</a>
				    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
				</div>
			    </div>
			</div>
		    </div>
		    <!--exportUsersToExcelModal ends-->
		</div>
		</div>
		    <!--backup ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="device">
<br>
<!--backup start-->
		<div class="panel panel-default files-panel no-box-shadow" style="height:500px;overflow:scroll;">
                <div class="status" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive devicesList" style="display: none;">
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchBluvaultInput" onkeyup="searchedBluvaultDevices()" placeholder="Search by Assets or User Name.." title="Type in a Asset Name or User Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'name'; sortReverseMSPD = !sortReverseMSPD">
                                Asset
                                <span ng-show="sortTypeMSPD == 'name' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'name' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'userNamePlain'; sortReverseMSPD = !sortReverseMSPD">
                                UserName
                                <span ng-show="sortTypeMSPD == 'userNamePlain' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'userNamePlain' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'status'; sortReverseMSPD = !sortReverseMSPD">
                                Status
                                <span ng-show="sortTypeMSPD == 'status' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'status' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'createdOn'; sortReverseMSPD = !sortReverseMSPD">
                                Asset Configured on
                                <span ng-show="sortTypeMSPD == 'createdOn' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'createdOn' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'lastSuccessfullBackup'; sortReverseMSPD = !sortReverseMSPD">
                                Last Successful Backup
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'storageValue'; sortReverseMSPD = !sortReverseMSPD">
                                Data Utilized
                                <span ng-show="sortTypeMSPD == 'storageValue' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'storageValue' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'lastSuccessfullBackup'; sortReverseMSPD = !sortReverseMSPD">
                                Action
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="value in devices | orderBy:sortTypeMSPD:sortReverseMSPD track by $index">
                            <td class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)"style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span> <a class="hide" title="Device Configuration" ng-click="updateUserDevicePolicyInfoMsp(value.uuId)" style="font-size: 12px;"><i class="fa fa-info-circle" aria-hidden="true"></i></a></td>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-cloak>{{ value.status }}</td>
                            <td class="text-left" ng-cloak>{{ value.createdOn}}</td>
			    <td class="text-left" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-left" ng-cloak>{{ value.storageUsedByDevice}}</td>			    
			    <td class="text-left">
				<a href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" class="btn btn-small btn-primary" style="width: 130px;">Backup Summary</a>
				<a ng-if="(value.blocked == false && value.backupStatus != 'STARTED') && (value.blocked == false && value.backupStatus != 'SCANNING') && (value.blocked == false && value.decoupled == false)" ng-click="initiateBackupMSP(value.uuId)" class="btn btn-small btn-primary initiateBackupBtn{{$index}}" style="color:white !important;margin-left:5px;width: 130px;">Initiate Backup</a>
				<a ng-if="(value.blocked == false && value.backupStatus == 'STARTED') || (value.blocked == false && value.backupStatus == 'SCANNING')" class="btn btn-small btn-primary" style="color:white !important;margin-left:5px;width: 130px;cursor:unset !important;">Backup In Progress</a>
				<a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDeviceMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.uuId, true,value.userNamePlain, value.name, 'backup')" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked == false" class="btn btn-small btn-success" style="background: #6d5cae !important;color:white!important;margin-left:5px;width: 130px;">Deactivate</a>
				<a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDeviceMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.uuId, false,value.userNamePlain, value.name, 'backup')" ng-bootbox-confirm-action-cancel="" class="btn btn-success btn-small" ng-if="value.blocked == true" style="color:white!important;margin-left:5px;width: 130px;">Reactivate</a>
				<a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteDevice(value.uuId,value.userNamePlain, value.name, 'backup')" ng-bootbox-confirm-action-cancel="" class="btn btn-danger btn-small" ng-if="value.blocked == true" style="color:white!important;margin-left:5px;width: 130px;">Delete</a>
			    </td>
                        </tr>
			</tbody>
		    </table>
		    <div id="noResultsMessageDevice" style="display:none;text-align: center;margin:20px;">No match found</div>
		</div>
		<div class="row devicesListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountD}} of {{totalpageCountD}}</span></p>
                            <a class="btn btn-primary firstD" title="First" ng-click="manageDevicesNavigate('backup', firstD)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousD" title="Previous" ng-click="manageDevicesNavigate('backup', previousD)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextD" title="Next" ng-click="manageDevicesNavigate('backup', nextD)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastD" title="Last" ng-click="manageDevicesNavigate('backup', lastD)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
		<!--modal start-->
<div class="modal fade" id="foldersMsp">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <h4 class="modal-title">Device Configuration</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                <!-- table start-->
                                <div class="table-responsive">
                                    <table class="col-lg-12 table table-bordered table-striped">
                                        <tbody>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Default folders that will be backed up automatically</span>
                                            </td>
                                            <td class="col-lg-9">
						<span ng-repeat="value in defaultFoldersMspList track by $index" ng-cloak>
                                                        <a title="{{value}}" style="word-wrap:break-word;" ng-cloak><span ng-if="$index != 0">,</span>{{ value }}</a>
						</span>
                                            </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>File types that will be {{filterTypeMsp}}</span>
                                            </td>
					    <td class="col-lg-9">
                                                <span>{{fileTypesMsp}}</span>
                                            </td>
                                         </tr>
                                         <tr ng-if="userDefinedFoldersMsp.length > 0">
                                            <td class="col-lg-3">
                                                <span>Device Inclusion folders</span>
                                            </td>
                                            <td class="col-lg-9">                                            
                                                <span ng-repeat="value in userDefinedFoldersMsp track by $index" ng-cloak>
                                                        <a title="{{value}}" style="word-wrap:break-word;" ng-cloak><span ng-if="$index != 0">,</span>{{ value }}</a>
                                                </span>
                                            </td>
                                         </tr>
                                         <tr ng-if="userExcludedFoldersMsp.length > 0">
                                            <td class="col-lg-3">
                                                <span>Device Exclusion folders</span>
                                            </td>
                                            <td class="col-lg-9">                                                
                                                <span ng-repeat="value in userExcludedFoldersMsp track by $index" ng-cloak>
                                                        <a title="{{value}}" style="word-wrap:break-word;" ng-cloak><span ng-if="$index != 0">,</span>{{ value }}</a>
                                                </span>                                               
                                            </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Maximum file size allowed</span>
                                            </td>
					    <td class="col-lg-9">
                                                <span ng-if="maxSizeAllowedMsp == '1048576.00 MB'"> Unlimited</span>
                                                <span ng-if="maxSizeAllowedMsp != '1048576.00 MB'">Any file more than <span ng-cloak>{{ maxSizeAllowedMsp }}</span> will not be backed up</p>
                                            </td>
                                         </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- table ends-->                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
            </div>
        </div>
    </div>
<!--modal ends-->
	    </div>
		    <!--backup ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="policy" ng-controller="PmsController">
<br>
		    <!--policy management  start-->
<!--summary modal starts-->
			<!-- start -->
		<div class="panel" ng-controller="PmsController">
                <div class="panel-heading">
		    <h4><?=Language::show('Policy Summary', 'keywords');?>
			<select name="summaryPolicyName" id="summaryPolicyName" class="summaryPolicyName col-lg-2 hide" title='Select Backup Policy Name' style="margin-left:20px;">
                        <?php if(!empty($data['backupPolicies'])){ ?>
				<?php foreach($data['backupPolicies'] as $value){
				    if($value != 'STAGING_POLICY'){
                                	$label = $value;
                                        if( strlen( $value ) > 25 ) {
                                        	$label = substr( $label, 0, 25 ) . '...';
					}?>
                                        <option value="<?=$value?>"><?=$label?></option>
                                <?php }} ?>
                        <?php } ?>
                        </select>
			<span class="pull-right">
				<a title="Edit" class="toolTip" id="policyEdit" data-toggle="tooltip" data-placement="left" href="" ng-click="editSpecificFields()" style="margin:5px;"><i class="fa fa-edit"></i> </a>
				<a ng-bootbox-confirm="<h4><?=Language::show('Are you sure to switch back to default settings for policy?.', 'keywords')?></h4>" ng-bootbox-confirm-action="switchToDefaults()" ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-primary" id="switchToDefaults"style="display:none;"><?=Language::show('Switch to defaults', 'keywords');?></a>
				<!--<a title="Export as PDF" href="" class="toolTip" id="policyDownload" data-toggle="tooltip" data-placement="top" ng-click="downloadPolicyPdfSummary()" style="margin:5px;"><i class="fa fa-download"></i></a>-->
			</span>
		    </h4>
                </div>
                    <div class="panel-body" id="viewBody" style="padding: 0px 30px 30px 30px;">                   
                    <div class="row">
<!--summary table starts-->
<!-- table start-->
                                <div class="table-responsive">
                                    <table class="col-lg-12 table table-bordered table-striped deviceListTable">
                                        <tbody>                                        
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Schedules</span><p class="editt" style="display:none;">[Recommended Value: Daily 12:30]</p>
                                            </td>
                                            <td class="col-lg-9">
                                                <span class="oldd" id="scheduleTypeS"></span><span class="oldd"> : </span><span class="oldd" id="scheduleTimeS"></span>
                                                <div class="col-lg-12 row editt initialSch" style="display:none;">
                                                <table class="col-lg-12 table table-bordered" id="scheduleEditTable">
                                                        <tbody>
                                                                <tr>
                                                                        <td class="col-lg-3">
                                                                                <div>
                                                                                        <select class="form-control" name="schedulesTypeS" id="schedulesTypeS1" title='Select Schedules Type'>
                                                                                                <option value="daily">Daily</option>
                                                                                                <option value="weekly">Weekly</option>
                                                                                        </select>
                                                                                </div>
                                                                        </td>
                                                                        <td class="col-lg-9">
                                                                                <div class="row col-lg-12">
                                                                                        <select class="form-control col-lg-5 daysS selectDaysPickerEdit" name="daysS[]" id="daysS1" title='Select days' data-max-options="3" multiple style="display:none;">
                                                                                                <option value="Sunday"><?=Language::show('sunday', 'keywords')?></option>
                                                                                                <option value="Monday"><?=Language::show('monday', 'keywords')?></option>
                                                                                                <option value="Tuesday"><?=Language::show('tuesday', 'keywords')?></option>
                                                                                                <option value="Wednesday"><?=Language::show('wednesday', 'keywords')?></option>
                                                                                                <option value="Thursday"><?=Language::show('thursday', 'keywords')?></option>
                                                                                                <option value="Friday"><?=Language::show('friday', 'keywords')?></option>
                                                                                                <option value="Saturday"><?=Language::show('saturday', 'keywords')?></option>
                                                                                        </select>
                                                                                        <select class="form-control col-lg-5 daysS selectTimeSinglePickerEdit" name="timeSingle[]" id="timeSingle" title='Select time' style="display:none;">
                                                                                                <option value="0000"><?=Language::show('00:00', 'keywords')?></option>
												<option value="0030"><?=Language::show('00:30', 'keywords')?></option>
                                                                                                <option value="0100"><?=Language::show('01:00', 'keywords')?></option>
                                                                                                <option value="0130"><?=Language::show('01:30', 'keywords')?></option>
                                                                                                <option value="0200"><?=Language::show('02:00', 'keywords')?></option>
                                                                                                <option value="0230"><?=Language::show('02:30', 'keywords')?></option>
                                                                                                <option value="0300"><?=Language::show('03:00', 'keywords')?></option>
                                                                                                <option value="0330"><?=Language::show('03:30', 'keywords')?></option>
                                                                                                <option value="0400"><?=Language::show('04:00', 'keywords')?></option>
                                                                                                <option value="0430"><?=Language::show('04:30', 'keywords')?></option>
                                                                                                <option value="0500"><?=Language::show('05:00', 'keywords')?></option>
                                                                                                <option value="0530"><?=Language::show('05:30', 'keywords')?></option>
                                                                                                <option value="0600"><?=Language::show('06:00', 'keywords')?></option>
                                                                                                <option value="0630"><?=Language::show('06:30', 'keywords')?></option>
												<option value="0700"><?=Language::show('07:00', 'keywords')?></option>
                                                                                                <option value="0730"><?=Language::show('07:30', 'keywords')?></option>
                                                                                                <option value="0800"><?=Language::show('08:00', 'keywords')?></option>
                                                                                                <option value="0830"><?=Language::show('08:30', 'keywords')?></option>
                                                                                                <option value="0900"><?=Language::show('09:00', 'keywords')?></option>
                                                                                                <option value="0930"><?=Language::show('09:30', 'keywords')?></option>
                                                                                                <option value="1000"><?=Language::show('10:00', 'keywords')?></option>
                                                                                                <option value="1030"><?=Language::show('10:30', 'keywords')?></option>
                                                                                                <option value="1100"><?=Language::show('11:00', 'keywords')?></option>
                                                                                                <option value="1130"><?=Language::show('11:30', 'keywords')?></option>
                                                                                                <option value="1200"><?=Language::show('12:00', 'keywords')?></option>
                                                                                                <option value="1230"><?=Language::show('12:30', 'keywords')?></option>
                                                                                                <option value="1300"><?=Language::show('13:00', 'keywords')?></option>
                                                                                                <option value="1330"><?=Language::show('13:30', 'keywords')?></option>
                                                                                                <option value="1400"><?=Language::show('14:00', 'keywords')?></option>
                                                                                                <option value="1430"><?=Language::show('14:30', 'keywords')?></option>
												<option value="1500"><?=Language::show('15:00', 'keywords')?></option>
                                                                                                <option value="1530"><?=Language::show('15:30', 'keywords')?></option>
                                                                                                <option value="1600"><?=Language::show('16:00', 'keywords')?></option>
                                                                                                <option value="1630"><?=Language::show('16:30', 'keywords')?></option>
                                                                                                <option value="1700"><?=Language::show('17:00', 'keywords')?></option>
                                                                                                <option value="1730"><?=Language::show('17:30', 'keywords')?></option>
                                                                                                <option value="1800"><?=Language::show('18:00', 'keywords')?></option>
                                                                                                <option value="1830"><?=Language::show('18:30', 'keywords')?></option>
                                                                                                <option value="1900"><?=Language::show('19:00', 'keywords')?></option>
                                                                                                <option value="1930"><?=Language::show('19:30', 'keywords')?></option>
                                                                                                <option value="2000"><?=Language::show('20:00', 'keywords')?></option>
                                                                                                <option value="2030"><?=Language::show('20:30', 'keywords')?></option>
                                                                                                <option value="2100"><?=Language::show('21:00', 'keywords')?></option>
                                                                                                <option value="2130"><?=Language::show('21:30', 'keywords')?></option>
                                                                                                <option value="2200"><?=Language::show('22:00', 'keywords')?></option>
												<option value="2230"><?=Language::show('22:30', 'keywords')?></option>
                                                                                                <option value="2300"><?=Language::show('23:00', 'keywords')?></option>
                                                                                                <option value="2330"><?=Language::show('23:30', 'keywords')?></option>
                                                                                        </select>
											<select class="form-control col-lg-5 daysS selectTimeMultiplePickerEdit" name="timeMultiple[]" id="timeMultiple" title='Select time' multiple data-max-options="3" style="display:none;">
                                                                                                <option value="0000"><?=Language::show('00:00', 'keywords')?></option>
                                                                                                <option value="0030"><?=Language::show('00:30', 'keywords')?></option>
                                                                                                <option value="0100"><?=Language::show('01:00', 'keywords')?></option>
                                                                                                <option value="0130"><?=Language::show('01:30', 'keywords')?></option>
                                                                                                <option value="0200"><?=Language::show('02:00', 'keywords')?></option>
                                                                                                <option value="0230"><?=Language::show('02:30', 'keywords')?></option>
                                                                                                <option value="0300"><?=Language::show('03:00', 'keywords')?></option>
                                                                                                <option value="0330"><?=Language::show('03:30', 'keywords')?></option>
                                                                                                <option value="0400"><?=Language::show('04:00', 'keywords')?></option>
                                                                                                <option value="0430"><?=Language::show('04:30', 'keywords')?></option>
                                                                                                <option value="0500"><?=Language::show('05:00', 'keywords')?></option>
                                                                                                <option value="0530"><?=Language::show('05:30', 'keywords')?></option>
                                                                                                <option value="0600"><?=Language::show('06:00', 'keywords')?></option>
                                                                                                <option value="0630"><?=Language::show('06:30', 'keywords')?></option>
                                                                                                <option value="0700"><?=Language::show('07:00', 'keywords')?></option>
												<option value="0730"><?=Language::show('07:30', 'keywords')?></option>
                                                                                                <option value="0800"><?=Language::show('08:00', 'keywords')?></option>
                                                                                                <option value="0830"><?=Language::show('08:30', 'keywords')?></option>
                                                                                                <option value="0900"><?=Language::show('09:00', 'keywords')?></option>
                                                                                                <option value="0930"><?=Language::show('09:30', 'keywords')?></option>
                                                                                                <option value="1000"><?=Language::show('10:00', 'keywords')?></option>
                                                                                                <option value="1030"><?=Language::show('10:30', 'keywords')?></option>
                                                                                                <option value="1100"><?=Language::show('11:00', 'keywords')?></option>
                                                                                                <option value="1130"><?=Language::show('11:30', 'keywords')?></option>
                                                                                                <option value="1200"><?=Language::show('12:00', 'keywords')?></option>
                                                                                                <option value="1230"><?=Language::show('12:30', 'keywords')?></option>
                                                                                                <option value="1300"><?=Language::show('13:00', 'keywords')?></option>
                                                                                                <option value="1330"><?=Language::show('13:30', 'keywords')?></option>
                                                                                                <option value="1400"><?=Language::show('14:00', 'keywords')?></option>
                                                                                                <option value="1430"><?=Language::show('14:30', 'keywords')?></option>
												<option value="1500"><?=Language::show('15:00', 'keywords')?></option>
                                                                                                <option value="1530"><?=Language::show('15:30', 'keywords')?></option>
                                                                                                <option value="1600"><?=Language::show('16:00', 'keywords')?></option>
                                                                                                <option value="1630"><?=Language::show('16:30', 'keywords')?></option>
                                                                                                <option value="1700"><?=Language::show('17:00', 'keywords')?></option>
                                                                                                <option value="1730"><?=Language::show('17:30', 'keywords')?></option>
                                                                                                <option value="1800"><?=Language::show('18:00', 'keywords')?></option>
                                                                                                <option value="1830"><?=Language::show('18:30', 'keywords')?></option>
                                                                                                <option value="1900"><?=Language::show('19:00', 'keywords')?></option>
                                                                                                <option value="1930"><?=Language::show('19:30', 'keywords')?></option>
                                                                                                <option value="2000"><?=Language::show('20:00', 'keywords')?></option>
                                                                                                <option value="2030"><?=Language::show('20:30', 'keywords')?></option>
                                                                                                <option value="2100"><?=Language::show('21:00', 'keywords')?></option>
                                                                                                <option value="2130"><?=Language::show('21:30', 'keywords')?></option>
                                                                                                <option value="2200"><?=Language::show('22:00', 'keywords')?></option>
												<option value="2230"><?=Language::show('22:30', 'keywords')?></option>
                                                                                                <option value="2300"><?=Language::show('23:00', 'keywords')?></option>
                                                                                                <option value="2330"><?=Language::show('23:30', 'keywords')?></option>
                                                                                        </select>

                                                                                </div>
<span id="scheduleError" style="color: #f55753;font-size: 0.9em;display:none;">Please add at least one schedule.</span>
                                                                        </td>
                                                                </tr>
                                                        </tbody>
                                                </table>
						<select class="form-control selectScheduleEditPicker hide" ng-model="schedulesS" name="schedulesS[]" id="schedulesS" multiple title='Select Schedules' data-max-options="3">
                                                    <?php if(!empty($data['sch1'])){ ?>
                                                        <?php foreach($data['sch1'] as $key => $value){ ?>
                                                            <?php if(strpos($value, 'AM') !== false || strpos($value, 'PM') !== false){?>
                                                                <option value="<?=$value?>"><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </select>
                                                </div>
                                            </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
						<span>Default Folders for Backup</span>
						<?php if($data['packModel'] == 'PREMIUM'){ ?>
							<p class="editt" style="display:none;">[Recommended Value: ALL]</p>
						<?php } else { ?>
							<p class="editt" style="display:none;">[Recommended Value: {user.home}]</p>
						<?php } ?>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset;">
						<span class="oldd" id="defaultFoldersS"></span>
						<div class="col-lg-12 editt" style="display:none;">
                                                        <div class="col-lg-12 row">
                                                                <ul class="list-group list-group-horizontal" ng-show="defaultUniversalFolders.length" style="display:contents !important;">
                                                                        <li class="list-group-item" title="{{value}}" ng-if="value != '' " ng-repeat="value in defaultUniversalFolders track by $index">{{ value | limitTo:20}}{{value.length > 20 ? '...' : ''}} <a href="javascript:;" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-bootbox-confirm="Are you sure you want to remove this folder?" ng-bootbox-confirm-action="removeInclusionFolderMsp(value)" ng-bootbox-confirm-action-cancel="" style="margin-left:10px;"><i class="fa fa-times-circle-o"></i></a></li>
                                                                </ul>
                                                        </div>
                                                        <div class="input-group col-lg-6 row">
                                                                <input type="text" class="form-control" ng-model="defaultFoldersBackupMsp" name="defaultFoldersBackupMsp" id="defaultFoldersBackupMsp" placeholder="Enter the full path of the folder" autocomplete="off"/>
                                                                <span class="input-group-btn">
                                                                        <button type="button" ng-click="addDefaultFolderMsp(defaultFoldersBackupMsp)" class="btn btn-default">Add</button>
                                                                </span>
                                                        </div >
                                                </div>
                                           </td>
					 </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Excluded Folders for Backup</span>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset;">
                                                <span class="oldd" id="excludedFoldersS"></span>
                                                <div class="col-lg-12 editt" style="display:none;">
                                                        <div class="col-lg-12 row">
								<ul class="list-group list-group-horizontal" ng-show="newExcluded.length" style="display:contents !important;">
                                                                        <li class="list-group-item" title="{{value}}" ng-if="value != '' " ng-repeat="value in newExcluded track by $index">{{ value | limitTo:20}}{{value.length > 20 ? '...' : ''}} <a href="javascript:;" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-bootbox-confirm="Are you sure you want to remove this folder?" ng-bootbox-confirm-action="removeExclusionFolderMsp(value)" ng-bootbox-confirm-action-cancel="" style="margin-left:10px;"><i class="fa fa-times-circle-o"></i></a></li>
                                                                </ul>
                                                        </div>
                                                        <div class="input-group col-lg-6 row">
                                                                <input type="text" class="form-control" ng-model="exclusionFolderNameMsp" name="exclusionFolderNameMsp" id="exclusionFolderNameMsp" placeholder="Enter the full path of the folder" autocomplete="off"/>
                                                                <span class="input-group-btn">
                                                                        <button type="button" ng-click="addExclusionFolderMsp(exclusionFolderNameMsp)" class="btn btn-default">Add</button>
                                                                </span>
                                                        </div >
                                                </div>
                                           </td>
                                         </tr>                                         
                                         <tr>
                                            <td class="col-lg-3" style="white-space: unset!important;">
                                                <span>File Filters</span><p class="editt" style="display:none;">[Recommended Value(s): Inclusion of Office_Files, Pictures]</p>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset!important;">
						<div class="col-lg-12 row oldd" style="white-space: pre-wrap;">
                                                	<span>Filter </span><span id="filtersType1S"></span> : <span id="filtersS"></span>
						</div>
						<div class="col-lg-12 row editt" style="display:none;">
						    <label class="radio-inline" style="margin:5px;">
                                                        <input type="radio" name="optradio" id="inclusionRadio" value="inclusion"> Inclusion
                                                    </label>
                                                    <label class="radio-inline" style="margin:5px;">
                                                        <input type="radio" name="optradio" id="exclusionRadio" value="exclusion"> Exclusion
						    </label>
						    <div class="col-lg-4 editt" style="display:none;">
                                        		<select class="col-lg-10 selectFilterPickerMSP" name="filtersS[]" id="filtersMSP" required="" title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
				    </div>
				    <span id="filterError" style="color: #f55753;font-size: 0.9em;display:none;">Please add at least one filter.</span>
						</div>
                                                <span id="filterExtSpan"><br>
                                                        Filter Extensions : <!--<span id="filterExtS"></span>-->
							<input type="text" data-role="tagsinput" value="" class="form-control" name="filterExtS" id="filterExtS" autocomplete="off">
						</span>
                                            </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Throttle traffic at endpoint agent to</span>
                                            </td>
					    <td class="col-lg-9">
						<div class="col-lg-12 row oldd">
							<span class="oldd" id="nwFromClientToPGMBSOld"></span>
						</div>
						<div class="col-lg-12 row editt" style="display:none;">
                						<div class="col-lg-2" style="margin-top:5px;">
                    							<label class="switch">
                        							<input id="switchNwFromClientToPGMBS" type="checkbox" name="switchNwFromClientToPGMBS" value="true">
                        							<div class="slider round"></div>
                    							</label>
                						</div>
								<div class="col-lg-3">
                                              				<input type="text" class="form-control" name="nwFromClientToPGMBS" id="nwFromClientToPGMBS" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMBS();" disabled/>
                                              				<span id="switcherrorS" style="color: #f55753;font-size: 0.9em;"></span>
                                              				<span id="switchwarningS" style="color: #f27331;font-size: 0.9em;"></span>
                                              			</div>
                                              			<div class="col-lg-3">
                                                			<select class="form-control" name="networkThrottlingUnitS" id="networkThrottlingUnitS" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    			<option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    			<option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    			<option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                			</select>
                                              			</div>
							</div>
	                                                <!--<span class="oldd" id="nwFromClientToPGMBS"></span> <span class="oldd" id="networkThrottlingUnitS"></span>
	                                                <div class="slidecontainer editt" style="display:none">
	                                              		<input type="range" min="1" max="10" value="" name="cpuThrottling" class="slidercpu" id="myRangeEdit">
	                                              		<p><span id="demoEdit">5</span> Mbps</p>
	                                            	</div>-->
						</div>
                                            </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Throttle endpoint agent CPU usage</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <div class="slidecontainerS oldd">
                                              		<input type="range" min="1" max="10" value="" name="cpuThrottlingS" class="slidercpuS" id="myRangeS"><span style="margin:20px;">  Value: <span id="demoS"></span></span>
						</div>
						<div class="editt" style="display:none;">
                                                        <input type="range" min="1" max="10" value="" name="cpuThrottlingSEdit" class="slidercpuS" id="myRangeSEdit"><span style="margin:20px;">  Value: <span id="demoSEdit"></span></span>
                                                </div>
                                            </td>
					 </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>User Action Preferences</span>
                                            </td>
                                            <td class="col-lg-9">                                         
<div id="accordion">
  <div class="card">
    <div class="card-header" id="headingOne">
      <h5 class="mb-0">
	<a style="color:black; text-decoration: none;cursor:pointer;" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">Show User Action Preferences</a>
      </h5>
    </div>

    <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
      <div class="card-body" style="pointer-events:none;opacity:0.6;">
	<div class="col-lg-12 row">
	    <div class="col-lg-12 row">
		<h4 style="margin-left: 20px;">Agent</h4>
	    </div>
	    <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchMyBackupFiles" type="checkbox" name="switchMyBackupFiles" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">My Backup Files</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchRestore" type="checkbox" name="switchRestore" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Restore</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSettings" type="checkbox" name="switchSettings" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Settings</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchRefreshPolicy" type="checkbox" name="switchRefreshPolicy" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Refresh Policy</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchInitiateBackup" type="checkbox" name="switchInitiateBackup" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Initiate Backup</span>
            </div>
            <div class="col-lg-3 row">
		<div class="col-lg-2">
		    <label class="switch">
			<input id="switchPauseBackup" type="checkbox" name="switchPauseBackup" value="true">
			<div class="slider round"></div>
		    </label>
                </div>
                <span style="margin-left: 20%;">Pause Backup</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchStopBackup" type="checkbox" name="switchStopBackup" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Stop Backup</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchCheckForUpdate" type="checkbox" name="switchCheckForUpdate" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Check for Update</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSupportRequest" type="checkbox" name="switchSupportRequest" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Support Request</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchDecoupleDevice" type="checkbox" name="switchDecoupleDevice" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Decouple Asset</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchAbout" type="checkbox" name="switchAbout" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">About</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchExit" type="checkbox" name="switchExit" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Exit</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSystemIcon" type="checkbox" name="switchSystemIcon" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Systray Icon</span>
            </div>
	</div>
	<div class="col-lg-12 row">
            <div class="col-lg-12 row">
                <h4 style="margin-left: 20px;">Portal</h4>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchOpen" type="checkbox" name="switchOpen" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Open</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchView" type="checkbox" name="switchView" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">View</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchVersions" type="checkbox" name="switchVersions" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Versions</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchRestoreP" type="checkbox" name="switchRestoreP" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Restore</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchDownload" type="checkbox" name="switchDownload" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Download</span>
            </div>
	</div>
      </div>
    </div>
  </div>    
  </div>
</div>
</td>
                                         </tr>
                                        </tbody>
				    </table>
<div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>Note: For more information on how to configure these settings, you may refer to the <a href="<?=Url::templatePath()?>images/Administrator_Guide_Endpoint.pdf" target="_blank">Administration Guide.</a> </p>
                                </div>
                            </div>
                        </div>
<a href="" class="btn btn-small btn-primary clickAble pull-right editt" ng-click="closeMSPPolicy()" style="display:none;margin-bottom: 10px;">Cancel</a>
<a href="" class="btn btn-small btn-primary clickAble pull-right editt" ng-click="policyCreateEditMsp()" style="display:none;margin-right: 10px;margin-bottom: 10px;">Apply</a>
                                </div>
                                <!-- table ends-->
<!--summary table ends-->
<div class="modal fade" id="inclusionToExclusion" tabindex="-1" role="dialog" aria-labelledby="confirmationModalInLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" >Warning</h5>
      </div>
      <div class="modal-body">
        You have now decided to include all these file types.  Are you sure of this, and want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" ng-click="includeToExcludeCancel()">No</button>
        <button type="button" class="btn btn-primary" ng-click="includeToExcludeProceed()">Yes</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="exclusionToInclusion" tabindex="-1" role="dialog" aria-labelledby="confirmationModalExLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" >Warning</h5>
      </div>
      <div class="modal-body">
        You have now decided to exclude all these file types.  Are you sure of this, and want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" ng-click="excludeToIncludeCancel()">No</button>
        <button type="button" class="btn btn-primary" ng-click="excludeToIncludeProceed()">Yes</button>
      </div>
    </div>
  </div>
</div>
<!--exclusion confirmation starts-->
<div class="modal fade" id="confirmAdd1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirm(exclusionFolderName)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
<!--exclusion confirmation ends-->
                    </div>
</div>
                    </div>                   
<!--summary modal ends-->

<!--actual policy edit starts-->
<div class="panel-body hide" style="padding: 0px 30px 30px 30px;">
                    <span class="d-none currentPage"><?='editPolicy'?></span>
		    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                    <span class="d-none policyType"><?=''?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
			'id' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreateEdit()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="row">
                        <div class="col-lg-7">
                            
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" value="{{ selectedPolicy.policygroupName }}" required autocomplete="off" readonly>
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter Policy Description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512"></textarea>
			    </div>
<div class="form-group">
                                <label for="policyStorageSizeAllowed"><?=Language::show('policyStorageSizeAllowed', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyStorageSizeAllowed" id="policyStorageSizeAllowed" placeholder="" value="" autocomplete="off">
                                <label for="policyUsersAllowed"><?=Language::show('policyUsersAllowed', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyUsersAllowed" id="policyUsersAllowed" placeholder="" value="" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                      <li class="nav-item d-none" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#search" aria-expanded="false" aria-controls="advanced">Search</a></li>
<?php } ?>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
                        <!--<li class="shareDetailsTab" role="presentation"><a data-target="#shareDetails" aria-controls="advanced" role="tab" data-toggle="tab">Secure Sharing</a></li>-->
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                        <li class="nav-item d-none" role="presentation"><a href="" class="nav-link" data-target="#search" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
<?php } ?>
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?><?php  if(PORTAL_LIGHT_VERSION == false){ ?> - <a href="" class="clickAble" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;">Create New Schedule</a><?php } ?></label>
                                        <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['sch1'])){ ?>
                                                <?php foreach($data['sch1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                            <td>
                                                                <!--<a class="btn btn-default btn-small" ng-click="getParticularSchedule(value.scheduleName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="getParticularSchedule(value.scheduleName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxFileVersions == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchver" type="checkbox" <?php if(maxFileVersions == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxFileVersions == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxPermissibleFileSize == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox" <?php if(maxPermissibleFileSize == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxPermissibleFileSize == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>d-none<?php } ?>">
					<label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(userStorageQuta == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox" <?php if(userStorageQuta == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(userStorageQuta == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                            <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="noOfDevicesAllowed"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                        <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" min="1" onfocusout="myFunctionDevice();"/>
                                        <span id="deviceerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div   class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osTypee" required="" title='Select OS Type' disabled>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div><?php } else {?>
                                    <div class="form-group">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osTypee" required="" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackup" name="defaultFoldersBackup" id="defaultFoldersBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                    		<button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default" style="padding-bottom: 10px;" type="button">Add</button>
                                	    </span>
                                        </div>
                                    </div>
				    <!-- sql start-->
				    <?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
				    <div class="form-group">
                                        <label for="sqlBackupFolders"><?=Language::show('defaultFoldersBackup', 'keywords');?> for MS SQL</label> <a href="" class="clickAble showSQLSettings" ng-click="addSqlServer()" style="font-size: small;font-weight: 600;">Configure SQL Server</a>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="sqlBackupFolders" name="sqlBackupFolders" id="sqlBackupFolders" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?> for SQL" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                        	<button ng-click="addDefaultFolderSQL(sqlBackupFolders)" class="btn btn-default sqlBackupFoldersBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                    	    </span>
                                        </div>
				    </div>
				    <div class="form-group hide">
				    	<label for="serverUserNameToSave"><?=Language::show('Server User Name', 'keywords');?></label>
				    	<input type="text" class="form-control" name="serverUserNameToSave" id="serverUserNameToSave" value="" placeholder="Enter Server User Name" autocomplete="off">
				    </div>
				    <div class="form-group hide">
				    	<label for="serverPasswordToSave"><?=Language::show('Server Password', 'keywords');?></label>
				    	<input type="password" class="form-control" name="serverPasswordToSave" id="serverPasswordToSave" value="" placeholder="Enter Password" autocomplete="off">
				    </div>
				    <?php } ?>
				    <!--sql end-->
                                    <div class="form-group">
                                        <label for="exclusionFolderName"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName1" placeholder="Enter the full path of the folder" autocomplete="off"
                                                data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                data-content="<?=Language::show('exclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                                <button type="button" ng-click="addExclusionFolder(exclusionFolderName)" class="btn btn-default">Add</button>
                                            </span>
                                        </div >
                                    </div>
                                    <!--start-->
                                    <div>
                                        <div class="form-group col-lg-12">
                                            <label for="exceptionFolderName"><?=Language::show('Exceptions to exclusions', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" ng-model="exceptionFolderName" name="exceptionFolderName" id="exceptionFolderName" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>"/>
                                                <span class="input-group-btn">
                                                    <button type="button" ng-click="addExceptionFolder(exceptionFolderName)" class="btn btn-default exceptionFoldersBtn">Add</button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end-->
                                    <div class="form-group d-none">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="clientDedup"><?=Language::show('Client Dedup', 'keywords');?></label>
                                        <select class="form-control clientDedup" name="clientDedup" id="clientDedup" title='Select <?=Language::show('clientDedup', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="maxFileSizeForBkpBatch"><?=Language::show('Maximun File Size For Backup Batch', 'keywords');?></label>
                                        <input type="text" class="form-control" name="maxFileSizeForBkpBatch" id="maxFileSizeForBkpBatch" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSizeForBkpBatch', 'keywords');?>" autocomplete="off" value="50" />
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="overflow-y: scroll;height: 450px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div  ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-if="defaultUniversalFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
						<?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
						<div class="form-group hide" style="margin-left:10px;">
                                                    <div class="checkbox check-primary">
                                                        <input id="sqlbkpEnabled" name="sqlbkpEnabled" type="checkbox" value="enabled">
                                                        <label for="sqlbkpEnabled"><?=Language::show('Backup SQL Database', 'keywords');?></label>
                                                    </div>
						</div>
						<!--SQl start-->
						<div class="panel panel-default" style="overflow-y: scroll;height: 150px;">
							<div class="panel-heading">
								<h5> <i class="fa fa-folder-open"></i> Default MS SQL Folders</h5>
						       </div>
							<div class="panel-body">
								<div class="table-responsive">
									<div  ng-if="osType == 'universal'">
										<ul class="list-group" ng-if="sqlBackupFoldersList.length >= 1">
											<li style="word-wrap: break-word" ng-repeat="value in sqlBackupFoldersList track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolderSQL($index)"><i class="fa fa-times-circle-o"></i></a></li>
										</ul>
										<span ng-if="sqlBackupFoldersList.length <= 0">There are no default folders for SQL to backup</span>
									</div>
								</div>
							</div>
						</div>
						<!--SQL ends-->
						<?php } ?>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersWindows.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersWindows track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersWindows.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersMac.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersMac track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersMac.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversal.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversal track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversal.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <!--start-->
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Exceptions to exclusions </h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersWindows.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersWindows track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersWindows.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersMac.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersMac track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersMac.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersUniversal.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersUniversal track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersUniversal.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                </div>
                                                <!--end-->
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectFilterTypePicker" name="filtersType" id="filtersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<div class="row col-lg-12">
                                            <h5 class="col-lg-1 inclusionBadge" style="margin-top: 10px;"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                            <h5 class="col-lg-1 exclusionBadge" style="display:none;margin-top:10px;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <select class="col-lg-10 selectFilterPicker" name="filters[]" id="filters" required="" title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
					</div>
					<div class="col-lg-12 row" style="margin-top:20px;">
						<div class="col-lg-2">
							<label class="switch">
								<input id="applyFilterToExceptionsToExclusion" type="checkbox" name="applyFilterToExceptionsToExclusion" value="true">
								<div class="slider round"></div>
							</label>
						</div>
						<span style="margin-top:5px;">Apply filters to Exceptions To Exclusions</span>
					</div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
						    <!--new start-->
						    <div class="form-group">
                                                        <label for="backupFilesWithoutExtension">Backup files without an extension</label>
                                                        <input type="checkbox" class="backupFilesWithoutExtension" name="backupFilesWithoutExtension"/>
						    </div>
						    <!--new end-->
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:nowrap !important;">
                                                                <!--<a class="btn btn-default btn-small pull-right" ng-click="newFilterEdit(defaultFilter.filterName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control userCreateAdmins" name="createUser[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>   
                                    </div>                                 
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedAdmins" name="deviceDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedReadonlyadmins" name="deviceDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Deleted', 'keywords');?></label>
                                        <select class="form-control deviceDeletedUsers" name="deviceDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                             
                                        <select class="form-control deviceBlockedAdmins" name="deviceBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceBlockedReadonlyadmins" name="deviceBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Blocked', 'keywords');?></label>
                                        <select class="form-control deviceBlockedUsers" name="deviceBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control deviceDecoupledAdmins" name="deviceDecoupled[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDecoupledReadonlyadmins" name="deviceDecoupled[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device de-couple', 'keywords');?></label>
                                        <select class="form-control deviceDecoupledUsers" name="deviceDecoupled[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control deviceLimitReachedAdmins" name="deviceLimitReached[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedReadonlyadmins" name="deviceLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Limit Reached', 'keywords');?></label>
                                        <select class="form-control deviceLimitReachedUsers" name="deviceLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control weeklyBackupReportAdmins" name="weeklyBkpreport[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control weeklyBackupReportReadonlyadmins" name="weeklyBkpreport[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Weekly backup report', 'keywords');?></label>
                                        <select class="form-control weeklyBackupReportUsers" name="weeklyBkpreport[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group"> 
                                        <select class="form-control firstBackupCompletedAdmins" name="firstBkpCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control firstBackupCompletedReadonlyadmins" name="firstBkpCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('First backup completed', 'keywords');?></label>
                                        <select class="form-control firstBackupCompletedUsers" name="firstBkpCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreInitiatedAdmins" name="restoreInitiated[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreInitiatedReadonlyadmins" name="restoreInitiated[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore initiated', 'keywords');?></label>
                                        <select class="form-control restoreInitiatedUsers" name="restoreInitiated[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
				    
				<div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreCompletedAdmins" name="restoreCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreCompletedReadonlyadmins" name="restoreCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore completed', 'keywords');?></label>
                                        <select class="form-control restoreCompletedUsers" name="restoreCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control storageLimitReachedAdmins" name="storageLimitReached[]">
                                        <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                        <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control storageLimitReachedReadonlyadmins" name="storageLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Storage limit reached', 'keywords');?></label>
                                        <select class="form-control storageLimitReachedUsers" name="storageLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfiles" name="bkpfiles" id="bkpfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettings" name="bkpsettings" id="bkpsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <select class="form-control initiatebackup" name="initiatebackup" id="initiatebackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <select class="form-control stopbackup" name="stopbackup" id="stopbackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="about"><?=Language::show('ABOUT', 'keywords');?></label>
                                        <select class="form-control about" name="about" id="about" required="" title='Select <?=Language::show('about', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>
                                   <div class="form-group">
                                        <label for="systrayIcon"><?=Language::show('Systray Icon', 'keywords');?></label>
                                        <select class="form-control systrayIcon" name="systrayIcon" id="systrayIcon" required="" title='Select <?=Language::show('systrayIcon', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restore" name="restore" id="restore" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicy" name="refbkppolicy" id="refbkppolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="pauseBackup"><?=Language::show('PAUSE_BACKUP', 'keywords');?></label>
                                        <select class="form-control pauseBackup" name="pauseBackup" id="pauseBackup" required="" title='Select <?=Language::show('pauseBackup', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                        <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>				    
				    <div class="form-group hide">
                                        <label for="disallowAdminRestores"><?=Language::show('Disallow Admin Restores', 'keywords');?></label>
                                        <select class="form-control disallowAdminRestores" name="disallowAdminRestores" id="disallowAdminRestores" required="" title='Select <?=Language::show('Disallow Admin Restores', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                   
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 row">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share hide">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group portalRestore">
                                            <label for="portalRestore"><?=Language::show('Restore', 'keywords');?></label>
                                            <select class="form-control portalRestore" name="portalRestore" id="portalRestore" required="" title='Select <?=Language::show('Restore', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row shareDetailsLabel hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>              
			   	    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="shareDomainsEnabled" name="shareDomainsEnabled" type="checkbox" value="enabled">
                                                    <label for="shareDomainsEnabled"><?=Language::show('Enable Domain Control', 'keywords');?></label>
                                                </div>
                                        </div>
					<div class="row">
						<div class="form-group col-lg-6">
							<label for="shareDomainIncExclusions"><?=Language::show('Share Domain Inclusions/Exclusions', 'keywords');?></label>
							<input type="text" class="form-control" name="shareDomainIncExclusions" id="shareDomainIncExclusions" placeholder="" autocomplete="off" value="" />
						</div>
						<div class="col-lg-6" style="margin-left:-14px;margin-top:20px;">
							<div class="col-lg-12" style="margin-bottom:15px;">
								<input type="radio" name="shareDomainType" id="only" value="Share only with these Email domains">
								<label for="link"><?=Language::show('Share only with these Email domains', 'keywords');?></label>
								</br>
								<input type="radio" name="shareDomainType" id="withall" value="Share with all Email domains excepting these">
								<label for="link"><?=Language::show('Share with all Email domains excepting these', 'keywords');?></label>
							</div>
						</div>
					</div>
				    </div>
				    <div class="col-lg-6 row" style="margin-top:10px;">
                                        <div class="col-lg-2 controllerSLBlock">
                                        	<label class="switch">
                                        		<input id="controllerSL" type="checkbox" name="controllerSL" value="true">
                                        		<div class="slider round"></div>
                                        	</label>
                                        </div>
					<span style="margin-top:5px;">Allow sharer visibility to the shared link</span>

				    </div>
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabled" name="highSecureShareEnabled" type="checkbox" value="enabled">
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-6 row">
							<div class="col-lg-2 controllerCPBlock">
								<label class="switch">
									<input id="controllerCP" type="checkbox" name="controllerCP" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Complex Password</span>							
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerADBlock">
								<label class="switch">
									<input id="controllerAD" type="checkbox" name="controllerAD" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlock">
								<label class="switch">
									<input id="controllerED" type="checkbox" name="controllerED" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Require Expiration Date for shared data</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerMFABlock">
								<label class="switch">
									<input id="controllerMFA" type="checkbox" name="controllerMFA" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Enable multi-factor authentication</span>
						</div>
					</div>
				   </div>                                    
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="search">
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                            <label for="contentIndexEnabled"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search Filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble d-none" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectSearchFilterTypePicker" name="searchFilterType" id="searchfiltersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<select class="form-control selectSearchFilterPicker" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple <?php if($data['searchEnabled'] == true){ ?> required <?php } ?>>
                                           <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                    <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSearchFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td>
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            </br>

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4 d-none" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group d-none" <?php if(partialFileTransfer == false){ ?>  class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version" <?php } ?>>
                                        <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>' <?php if(partialFileTransfer == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?></label>
                                            <div class="col-lg-8" <?php if(networkThrotlling == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switch" type="checkbox" <?php if(networkThrotlling == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
					</label></div>
<div class="row">
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              <span id="switchwarning" style="color: #f27331;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
					      </div>
</div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="cpuThrottling"><?=Language::show('CPU Throttling', 'keywords');?></label></br>
                                            <div class="slidecontainer">
                                              <input type="range" min="1" max="10" value="" name="cpuThrottling" class="slidercpu" id="myRange">
                                              <p>Value: <span id="demo"></span></p>
                                            </div>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.crawlLimit }}" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5 d-none">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default" style="margin-top:30px;">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.pftSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
				    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
				    <div class="col-lg-6 row">
                                        <div class="col-lg-2">
                                                <label class="switch">
                                                        <input id="legalHold" type="checkbox" name="legalHold" value="true">
                                                        <div class="slider round"></div>
                                                </label>
                                        </div>
                                        <span style="margin-top:5px;margin-left: 15%;">Legal Hold</span>
                                    </div>
                                    <div class="form-group" <?php if(legalHold == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <div class="checkbox check-primary">
                                            <!--<input id="legalHold" name="legalHold" type="checkbox" value="enabled"  <?php if(legalHold == false){ ?> disabled <?php }?>>
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>-->
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="If checked then dependent parameters get changed."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <span class="systemFolders" style="display: none;">
                                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                                </span>
                                        </div>
                                    </div>
				    <?php if($data['rwDetectionEnabled'] == 'true'){ ?>
						<div class="col-lg-6 row">
							<span style="margin-top:5px;">Unusual Activity Detection Enabled</span>
							<div class="col-lg-2 rwDetectionEnabledBlock">
								<label class="switch">
									<input id="rwDetectionEnabled" type="checkbox" name="rwDetectionEnabled" value="true" checked>
									<div class="slider round"></div>
								</label>
							</div>
                                                </div>
				    <?php } ?>
                                    <div class="form-group col-lg-12">
				    <label class="col-lg-12" style="margin-left: -30px;" for="noOfDaysToKeepDeviceNotHeard"><?=Language::show('Block devices which have not been heard from in', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchnoOfDaysToKeepDeviceNotHeard" type="checkbox" checked>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-4">
                                            <input type="text" class="form-control" name="noOfDaysToKeepDeviceNotHeard" id="noOfDaysToKeepDeviceNotHeard" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('No. of Days To Keep Device Not Heard', 'keywords');?>" required autocomplete="off" value="60" onfocusout="myFunctionnoOfDaysToKeepDeviceNotHeard();"/>
                                            <span id="noOfDaysToKeepDeviceNotHearderror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
					<div class="col-lg-2" style="margin-top: 10px;"><label>days</label></div>
</div>
                                    </div>
				    <div class="form-group d-none">
                                        <label for="numberOfThreadsAllowedForBackup"><?=Language::show('Number of threads allowed for Backup', 'keywords');?></label>
                                        <input type="number" class="form-control" name="numberOfThreadsAllowedForBackup" id="numberOfThreadsAllowedForBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Number of threads allowed for Backup', 'keywords');?>" required autocomplete="off" value="" min="1" max="5"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminRestore"><?=Language::show('Can Administrator Restore User Data', 'keywords');?></label>
                                        <select class="form-control canAdminRestore <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminRestore" id="canAdminRestore" required="" title='Select <?=Language::show('Can Admin Restore', 'keywords')?>' onclick="flipAllowEndUserTocontrolRestore()">
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" style="margin-left:30px;<?php if($data['overridePolicySettings'] == true){?>pointer-events:none;opacity: 0.4;<?php } ?>">
                                        <label for="allowEndUserTocontrolRestore"><?=Language::show('Allow end-user over-ride', 'keywords');?></label>
                                        <select class="form-control allowEndUserTocontrolRestore <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="allowEndUserTocontrolRestore" id="allowEndUserTocontrolRestore" required="" title='Select option'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"> <?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminDelete"><?=Language::show('Can Administrator Delete User Data', 'keywords');?></label>
                                        <select class="form-control canAdminDelete <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminDelete" id="canAdminDelete" required="" title='Select <?=Language::show('Can Admin Delete', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>' <?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } else { ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'<?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <div class="form-group d-none">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>' <?php if(enableCompression == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainer d-none" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'<?php if(backupFilesInUse == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg" <?php if(blukryptSearch == false){ ?> class="toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Field cannot be edited in Lite Version"<?php }?>>
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>' <?php if(blukryptSearch == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="Blukryptipaddress" style="background-color:#dcdcdc;" id="Blukryptipaddress" readonly />
                                    </div>
                                    <?php } else {?>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <?php if(!empty($data['pgs'])){ ?>
                                            <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                <?php foreach($data['pgs'] as $key => $value){ ?>
                                                    <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                <?php } ?>
                                            </select>
                                        <?php } ?>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group" <?php if(policyRefresh == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="1" max="23" required="" <?php if(policyRefresh == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                    </div>
				    <div class="form-group d-none">
                                        <label class="col-lg-12" for="logUnaccessedFiles" style="margin-top:10px;"><?=Language::show('Capture Unaccessed Items', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchlogUnaccessedFiles" name="switchlogUnaccessedFiles" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                    </div>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
				    </div>
				    <div class="form-group">
                                       <label for="autoupdateAgent"><?=Language::show('Auto Update Agent', 'keywords');?></label>
                                       <select class="form-control autoUpdateAgent" name="autoUpdateAgent" id="autoUpdateAgent" required="" title='Select <?=Language::show('Auto Update Agent', 'keywords')?>'>
                                           <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div>
				    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="switchAgentPassword" style="margin-left:-14px;"><?=Language::show('Agent uninstallation password', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAgentPassword" name="switchAgentPassword" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentPassword" style="margin-left:-14px;"><?=Language::show('password', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentPassword" id="agentPassword" value="" placeholder="Enter Password" autocomplete="off" readonly>
                                                <span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphrase"></span>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentRePassword" style="margin-left:-14px;"><?=Language::show('rePassword', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentRePassword" id="agentRePassword" placeholder="Re-Type Password" autocomplete="off" value="" data-parsley-equalto="#agentPassword" data-parsley-trigger="change" readonly/>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group">
                                       <label for="canBackupHiddenFiles"><?=Language::show('canBackupHiddenFiles', 'keywords');?></label>
                                       <select class="form-control canBackupHiddenFiles" name="canBackupHiddenFiles" id="canBackupHiddenFiles" required="" title='Select <?=Language::show('canBackupHiddenFiles', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div style="padding-left:3%;" class="form-group row d-none">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="switchFairnessAlgorithm" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input type="number" class="form-control" min="0" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup"  autocomptocomplete="off" value="0" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                   <div class="form-group">
                                       <label for="downloadAgent"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <a href="#" data-toggle="tooltip" data-placement="top" title="Relogin on portal is required"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div class="form-group">
					 <span class="row" style="margin-left: 0px;"><p>Purge deleted files from the catalog after</p></span>
					<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchnoOfDaysToKeepDeletedFiles" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="noOfDaysToKeepDeletedFiles" id="noOfDaysToKeepDeletedFiles"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionnoOfDaysToKeepDeletedFiles();" disabled/>
                                             <span id="sizenoOfDaysToKeepDeletedFiles" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
					 </div>
					</div>
					   <div class="form-group <?php if($data['showUserConsentFieldInPolicies'] != true){?>hide<?php } ?>">
                                         <span class="row" style="margin-left: 0px;"><p>User Consent Display Text</p></span>
					<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchuserConsentEnabled" name="userConsentEnabled" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-10">                                            
						 <textarea style="width:100%" class="userConsentDisplayText" name="userConsentDisplayText" id="userConsentDisplayText" placeholder="Enter User Consent Display Text" data-parsley-trigger="change" rows="3" onfocusout="checkTextLength()"></textarea>
					     <span id="texterror" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
					</div>
					</div>   
                                     </div>
				    <div class="row">
					    <div class="col-lg-4">
						<label for="preScanCommandEnabled">Enable Pre Scan Command</label><br>
						<label class="switch">
						<input id="preScanCommandEnabled" name="preScanCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="preScanCommand"><?=Language::show('Pre Scan Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preScanCommand" id="preScanCommand" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
					    	<div class="form-group">
					    	    <label for="legalHold">Continue backup on command-failure</label>
						    <input id="continueOnPreScan" name="continueOnPreScan" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
				    <div class="row">
				    	<div class="col-lg-4">
						<label for="preBackupCommandEnabled">Enable Pre Backup Command</label><br>
						<label class="switch">
						<input id="preBackupCommandEnabled" name="preBackupCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					</div>
					<div class="col-lg-5 form-group">
						<label for="preBackupCommand"><?=Language::show('Pre Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preBackupCommand" id="preBackupCommand" placeholder="" autocomplete="off" value="">
					</div>
					<div class="col-lg-3">
						<div class="form-group">
							<label for="legalHold">Continue backup on command-failure</label>
							<input id="continueOnPreBkp" name="continueOnPreBkp" type="checkbox" value="enabled">
							</div>
					    </div>
					</div>
					<div class="row">
					    <div class="col-lg-4">
						<label for="postBackupCommandEnabled">Enable Post Backup Command</label><br>
						<label class="switch">
						<input id="postBackupCommandEnabled" name="postBackupCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="postBackupCommand"><?=Language::show('Post Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="postBackupCommand" id="postBackupCommand" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
						<div class="form-group">
					    	<label for="legalHold">Continue backup on command-failure</label>
						<input id="continueOnPostBkp" name="continueOnPostBkp" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
                                    <div class="form-group d-none">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate d-none" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Go to Global settings to enable this option."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
			    <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        Grayed out options are currently controlled in Cloud Properties. Please speak to you Administrator or visit the Cloud Properties page to change their behavior.
                                        <br/>Both password enforcement options cannot be disabled at same time.
                                    </p>
                                </div>
                            </div>
			    </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">                            
                            <a ng-bootbox-confirm="<h4><?=Language::show('Will be effective on next policy refresh, for immediate effect manually refresh policy.', 'keywords')?></h4>"
                                ng-bootbox-confirm-action="policyCreateEdit()"
                                ng-bootbox-confirm-action-cancel="" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/policies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
<!--actual policy edit ends-->
		    <!--policymanagement tab ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="report">
<br>
		    <!--report starts-->
			<div class="row col-lg-12">
                <div class="panel col-lg-12">
		    <div class="panel-heading">
			<h3>Data Protection Scorecard
			<button class="btn btn-primary dropdown-toggle pull-right" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadUserBackupSummaryReport(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadUserBackupSummaryReportPdf(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">PDF</a><li>
                                              </ul>
                                        </h3>
		    </div>
<br>
                    <div class="panel-body"><div class="row">
			    <div class="col-lg-12 hide">
				<input type="hidden" class="policyNameReport" id="policyNameReport" value="<?=$data['policy']?>" />
                                <form ng-submit="updateUserBackupSummary(search.noOfDays,search.searchPolicyName)">
                                    <div class="row">
                                        <div class="col-lg-4">       
                                            <label for="searchPolicyName">Policy Name</label>
                                            <select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name'>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?> 
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="noOfDays">Data Protection Scorecard for</label>
                                            <input type="number" id="noOfDays" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:5px;" value="30"> <label style="margin-top:12px;">days </label>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Users</td>
                                <td ng-cloak>{{ userBackupSummary.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
                                <td class="text-left notForOffice" ng-cloak>Users with at least one asset assigned</td>
                                <td class="text-left forOffice" ng-cloak>Users with at least one OneDrive assigned</td>
                                <td ng-cloak>{{ userBackupSummary.userWithDevices }}</td>
			    </tr>
			    <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users without asset registered</td>
                                <td class="text-left forOffice" ng-cloak>No. of users without OneDrive registered</td>
                                <td ng-cloak>{{ userBackupSummary.userWithOutDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
                                <td class="text-left" ng-cloak>No. of users for whom at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummary.userWithFirstBkpCompleted }}</td>
                            </tr>                            
                            <?php if( $data['reportProductType'] != 'office'){ ?>
                                <tr class="text-center">
                                    <td class="text-center" ng-cloak>5.</td>
                                    <td class="text-left" ng-cloak>No. of users whose assets had a heartbeat to the server in the last <span class="heartbeat"></span> days</td>
                                    <td ng-cloak>{{ userBackupSummary.noOfUsersHeardCount }}</td>
                                </tr>
                            <?php } ?>                            
                            <tr class="text-center">
                                <?php if( $data['reportProductType'] != 'office'){ ?>
                                    <td class="text-center" ng-cloak>6.</td>
                                <?php } else { ?>
                                    <td class="text-center" ng-cloak>5.</td>
                                <?php } ?>
                                <td class="text-left notForOffice" ng-cloak>No. of users whose assets have been protected in the last <span class="protected"></span> days</td>
                                <td class="text-left forOffice" ng-cloak>No. of users whose OneDrives have been protected in the last <span class="protected"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersProtected }}</td>
                            </tr>
                            </tbody></table>
                        </div>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                    </div>
                </div>
                    <!--report ends-->
                    </div>
            </div>
<!--new ends-->
<!--start add-->
                <div class="modal fade" id="addUser" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <div class="modal-header">
                                <h4 class="modal-title">Add Users in Bulk</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
				<div class="row">
<div class="form-group col-lg-8">
					<a href="javascript:;" class="btn btn-success btn-small" ngf-select="readUserNamesFromExcelMsp($files)" <?php if(isMobile()){ ?> disabled <?php } ?>> <i class="share-icon fa fa-upload"> Import Usernames from Excel</i></a>
					<a href="" ng-click="downloadSampleMsp('user')" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
				    </div>
<!--start-->
<div class="row uncreatedUsers col-lg-12" style="display: none;">
                
                    <div class="panel-heading">
                        <h3>
                            User creation status
                            <a id="uncreatedDump" ng-click="downloadSampleExcel('downloadDump')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                            <span id="uncreatedDumpStatement" style="color: #f55753;font-size: 0.7em !important;"></span>
                        </h3>
                    </div>
                    <div class="panel-body col-lg-12 table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?=Language::show('username', 'keywords')?></th>
                                    <th><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in not_created track by $index">
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <td ng-cloak>{{ value.errorMessage }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                
            </div>
<!--stop-->
					<div class="panel-body col-lg-12 bulkUserPanel" style="display:none;">
<div class="col-lg-10" style="border: 1px solid #f27331;border-radius: 10px;height: 250px;overflow-y: scroll;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead ng-show="discoveredSites.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Users</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="discoveredSites.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>Add Users to Configure</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="discoveredSites.length > 0">
                                            <tr>
                                                <th class="col-lg-2"></th>
                                                <th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Users
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
						</th>
						<th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Policy
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="discoveredSites.length > 0">
                                            <tr ng-repeat="value in discoveredSites | orderBy:sortTypeSites:sortReverseSites" class="text-left">
                                                <td class="col-lg-2 text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
						<td ng-click="pickElement(value, $index)" ng-cloak><span title="{{value}}" style="cursor: pointer;">{{value | limitTo:25}}{{value.length > 25 ? '...' : ''}}</span></td>
						<td ng-cloak style="white-space:unset !important;">
                                                                <div>
                                                                    <select class="form-control" name="policy">
                                                                        <option value="No_Backup">No Backup</option>
                                                                        <option value="Backup">Backup</option>
                                                                    </select>
                                                                </div>
                                                 </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                        </div>
                                </div>
                            </div>                            
                        </div>
                    </div>
                </div>
<!--end add-->
<!--modal start-->
<?php if($data['popup'] == 'visible') { ?>
<div class="modal fade" id="changePasswordForFirstloginConsent" tabindex="-1" role="dialog" data-keyboard="false" data-backdrop="static" aria-labelledby="myModalLabel">
                <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Change Password Consent</h4>
                            </div>
                            <div class="modal-body">
                                <p>Please change password to proceed further.</p>
                            </div>
                            <div class="modal-footer">
                                <a class="btn btn-primary" id="proceedBtn" ng-click="proceedForChangePassword()">Proceed</a>
                            </div>
                        </div>
                </div>
            </div>
<?php } ?>
<!--modal ends-->
<!--modal-->
<?php if($data['popup'] == 'visible') { ?>
            <div class="modal fade" id="changePasswordForFirstlogin" role="dialog" data-keyboard="false" data-backdrop="static">
                <div class="modal-dialog">
                <!-- Modal content-->
                        <div class="modal-content">
                        <?=Form::open(array(
                            		'ng-submit' => 'changePasswordForFirstlogin()',
                            		'method' => 'post',
                            		'id' => 'changePasswordForFirstlogin',
                            		'csrf' => $data['csrf_token'],
                            		'autocomplete' => 'off',
                            		'data-parsley-validate' => true
                        		));
                        ?>
        		<div class="modal-header">
          			<h4 class="modal-title">Change Password</h4>
        		</div>
        		<div class="modal-body">
	                        <div class="form-group">
	                        	<label for="passwordGuest">Password</label>
	                        	<?php if(complexPassword == true) { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } else { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } ?>
                        	</div>
                        	<div class="form-group">
                            		<label for="rePasswordGuest">Re Type Password</label>
					<input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
					<span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphraseReset"></span>
					<span id="rePasswordError" style="color: #f55753;font-size: 0.9em;"></span>
                        	</div>
				<?php if(multifactorAuthWithAccessCode == true){ ?>
                        	<div class="form-group <?php if($data['showAccessCodeOnFirstLogin'] != '1'){ ?> d-none <?php } ?>">
                                        <label for="accessKey">Enter One Time Access Code sent to the registered Email address - <a href="" id="generateOtpLink" style="cursor:pointer;">Resend One Time Access Code</a></label>
                                        <input type="text" class="form-control" name="accessKey" id="accessKey" placeholder="<?=Language::show('Enter', 'keywords');?> <?=Language::show('One Time Access Code', 'keywords');?>" <?php if($data['showAccessCodeOnFirstLogin'] == '1'){ ?> required <?php } ?> autocomplete="off">
                                </div>
                        	<?php } ?>
				<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
				<!--collapse start-->
				<div class="form-group">
					<a ng-click="requestQR()" href="" style="margin-top:25px;">Request QR Code</a>
                            	</div>
				<div class="col-lg-12 collapse" id="qrCollapse" style="border: 1px solid rgb(242, 115, 49);">
					<div class="row" style="margin-bottom:10px;">
                                		<div class="col-lg-8">
                                    			<label for="mailId"><?=Language::show('Email Id', 'keywords');?></label>
                                    			<input type="text" class="form-control" name="mailId" id="mailId" value="<?=$_SESSION['emailId']?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('Email Id', 'keywords');?>" autocomplete="off" style="opacity:0.5;pointer-events:none;">
                                            	</div>
						<div class="col-lg-2">
						    <a type="button" class="btn btn-success" ng-click="requestQR()" style="margin-top:25px;"><?=Language::show('Submit', 'share');?></a>
						</div>
						<div class="col-lg-12">
						    <span id="statussuccess" style="color: #4faf50;font-size: 0.9em;"></span>
						    <span id="statuserror" style="color: #f55753;font-size: 0.9em;"></span>
						</div>
					</div>
                            	</div>
				<!--collapse end-->
				<center class="hide"><div id="img">
                                <img src='<?php echo $qrCodeUrl; ?>' />
                                </div></center>
				<?php } ?>
        		</div>
        		<div class="modal-footer">
          			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
          				<p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan the QR code sent to your Email Id and generate a one-time key.</p>
				<?php } else { ?>
        				<p style="float: left;">Note: Please change password to proceed further.</p>
				<?php } ?>
          			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
                			<a id="changePasswordBtnGuest" ng-bootbox-confirm="<h4>You may use Microsoft or Google Authenticator to set up Multi-Factor Authentication (MFA) using the QR code sent to your Email Id.  If you have not requested for QR code yet, please click Cancel and get QR code from 'Request QR Code' first.</h4>"
                                       ng-bootbox-confirm-action="changePasswordForFirstlogin()"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-primary"> <?=Language::show('save', 'keywords');?></a>
          			<?php } else { ?>
                			<button type="submit" id="changePasswordBtnGuest" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
          			<?php } ?>
        		</div>
        		<?=Form::close();?>
      		</div>
      	</div>
  </div>
  <?php } ?>
<!--modal-->
<?php if($data['MSP_Environment_Enabled'] == 'Yes' && $data['popup'] != 'visible'){?>			    
<!--change password msp user start-->
<div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">
                                  <!-- Modal content-->
                                  <div class="modal-content">
                                    <?= Form::open(array(
                                                'ng-submit' => 'changePasswordMsp()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                     )); ?>                                    
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel">Change Password</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userName']?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['recoverykey']?>">
					<input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['googleSecretKey']?>">
				    <div class="form-group">
                                                <label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">
                                         </div>
                                      <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>

                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
						    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
						    <span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphraseReset"></span>
                                                </div>
					    <div id="captchaDiv">
			    <?php
		    	    if(enableRecaptcha == true){
                            global $image;
                            $image = imagecreatetruecolor(200, 50) or die("Cannot Initialize new GD image stream");
                            $background_color = imagecolorallocate($image, 255, 255, 255);
                            $text_color = imagecolorallocate($image, 0, 255, 255);
                            $line_color = imagecolorallocate($image, 64, 64, 64);
                            $pixel_color = imagecolorallocate($image, 0, 0, 255);
                            imagefilledrectangle($image, 0, 0, 200, 50, $background_color);
                            for ($i = 0; $i < 3; $i++) {
                                imageline($image, 0, rand() % 50, 200, rand() % 50, $line_color);
                            }
                            for ($i = 0; $i < 1000; $i++) {
                                imagesetpixel($image, rand() % 200, rand() % 50, $pixel_color);
                            }
                            $letters = $data['letter'];
                            //$letters = $data['letter'];
                            $len = strlen($letters);
                            $letter = $letters[rand(0, $len - 1)];
                            $text_color = imagecolorallocate($image, 0, 0, 0);
                            $word = "";
                            $font = '/var/www/portal/app/templates/default/css/fonts/monofont.ttf';
                            for ($i = 0; $i < strlen($letters); $i++) {
                                    $letter = $letters[$i];
                                    $letter = trim($letter);
                        //          imagestring($image, 8, 70 + ($i * 15), 20, $letter, $text_color);
                                    imagettftext($image, 36, 0, 70 + ($i * 15), 35, $text_color, $font, $letter);
                                $word .= $letter;
                            }
                            $images = glob("*.png");
                            foreach ($images as $image_to_delete) {
                                @unlink($image_to_delete);
                                }
			    imagepng($image, "image" . $data['count'] . ".png");
			    }
                        ?>
			</div>
			<?php if(enableRecaptcha == true){ ?>
				<div class="from-group">
				    <label>Enter captcha shown below </label>
				    <input class="form-control" type="text" id="code" name="code" required autocomplete="off"/>
				    <span id="captchaSpan">
					<img id="captchaImage" src="https://<?=CLOUD_URL?>/portal/image<?=$data['count']?>.png">
				    </span>
				    <span id="refreshSpan"><a class="loginCaptchaRefresh" id="loginCaptchaRefresh" style="margin-left:10px;"><i class="glyphicon glyphicon-refresh" title="refresh captcha"></i></a></span>
				</div>
                        <?php }else{ ?>
                        	<input class="form-control d-none" type="text" id="code" name="code" value="<?=$data['letter']?>" autocomplete="off"/>
			<?php } ?>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>

                                </div>
                            </div>
<!--change password msp user end-->
<?php } ?>										   
<!--event hub modal start-->
<div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Backup Management</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>					
					<span class="d-none" id="actionToUserName"></span>
					<span class="d-none" id="actionToDeviceUUID"></span>
					<span class="d-none" id="deviceType"></span>
					<div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="row col-lg-12 hide" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
                            			<center>
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
                            			</center>
 						</div>
 					</div>
 					<?php } ?>
					<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="row col-lg-12 hide" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                <center>
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </center>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="row col-lg-12 agLogs hide" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                            </center>
                        </div>
                    </div>
                    <div class="row col-lg-12 fBackup hide" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Yes" data-off="No">
                            </center>
                        </div>
                    </div>
		     <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <input class="d-none" id="startBackupGet" name="startBackupGet" type="text" value="">
		     <div class="row col-lg-12 <?php if($data['readOnlyAdminUser'] == 'Yes'){ ?>hide<?php } ?>" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Initiate Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">
                                    <center>
                             			<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()" style="border-radius:15px;">Start Backup</a>
                             			<a ng-if="buttonValue=='stopBackup'" class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="border-radius:15px;"><?=Language::show('Stop Backup', 'keywords');?></a>
                                        <a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()" style="border-radius:15px;">Pause Backup</a>
                             			<a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()" style="border-radius:15px;">Cancel Schedule</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
		    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		    <input class="d-none" id="startRestoreGet" name="startRestoreGet" type="text" value="">
                    <div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
                                                <a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
                                                <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
                                                <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
                    <div class="row col-lg-12 stopBackupWhileRestoreBlock d-none">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--event hub modal ends-->
        </div>
    </div>
<div role="tabpanel" class="tab-pane" id="server">
<!--server backup tabs starts-->
<?php if(isMobile()){ ?>
                    <ul class="nav nav-pills flex-column childTabs" style="border: 1px solid #EC6621;border-radius: 10px;">
                            <li class="nav-item" style="display:unset !important;"><a href="" id="userSBM" class="nav-link" data-target="#userSB" aria-controls="userSB" aria-expanded="true" data-toggle="tab">Server Management</a></li>
                            <!--<li class="nav-item" style="display:unset !important;"><a href="" id="deviceSBM" class="nav-link" data-target="#deviceSB" aria-controls="deviceSB" aria-expanded="false" data-toggle="tab">Server Management</a></li>-->
                            <li class="nav-item" style="display:unset !important;"><a href="" id="policySBM" class="nav-link" data-target="#policySB" aria-controls="policySB" aria-expanded="false" data-toggle="tab">Policy Management</a></li>
                            <li class="nav-item" style="display:unset !important;"><a href="" id="reportSBM" class="nav-link" data-target="#reportSB" aria-controls="reportSB" aria-expanded="false" data-toggle="tab">Reports</a></li>
                    </ul>
            <?php } ?>
<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs childTabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: small;<?php }else { ?> font-size: small;<?php } ?>">
                            <li role="presentation" class="nav-item"><a href="" id="userSBM" class="nav-link" data-target="#userSB" aria-controls="userSB" role="tab" data-toggle="tab">Server Management</a></li>
                            <!--<li role="presentation" class="nav-item"><a href="" id="deviceSBM" class="nav-link" data-target="#deviceSB" aria-controls="deviceSB" role="tab" data-toggle="tab">Server Management</a></li>-->
                            <li role="presentation" class="nav-item"><a href="" id="policySBM" class="nav-link" data-target="#policySB" aria-controls="policySB" role="tab" data-toggle="tab">Policy Management</a></li>
                            <li role="presentation" class="nav-item"><a href="" id="reportSBM" class="nav-link" data-target="#reportSB" aria-controls="reportSB" role="tab" data-toggle="tab">Reports</a></li>
                    </ul>
            <?php } ?>
<!--server backup tabs ends-->

            <div class="tab-content">
		    <div role="tabpanel" class="tab-pane" id="userSB">
<span class="d-none csrf_token"><?=$data['csrf_token']?></span>
<!--bulk server add start-->
                <div class="modal fade" id="addServer" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <div class="modal-header">
                                <h4 class="modal-title">Add Servers</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="form-group col-lg-8">
                                        <a href="javascript:;" class="btn btn-success btn-small" ngf-select="readUserNamesFromExcelMspServer($files)" <?php if(isMobile()){ ?> disabled <?php } ?>> <i class="share-icon fa fa-upload"> Import Server names from Excel</i></a>
                                        <a href="" ng-click="downloadSampleMsp('server')" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
                                    </div>
<!--start-->
<div class="row uncreatedServers col-lg-12" style="display: none;">

                    <div class="panel-heading col-lg-12">
                        <h3>
                            Server creation status
                            <a id="uncreatedDumpServer" ng-click="downloadSampleExcel('downloadDumpServer')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                            <span id="uncreatedDumpStatementServer" style="color: #f55753;font-size: 0.7em !important;"></span>
                        </h3>
                    </div>
                    <div class="panel-body col-lg-12 table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?=Language::show('Server Name', 'keywords')?></th>
                                    <th><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in not_createdServer track by $index">
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <td ng-cloak>{{ value.errorMessage }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
            </div>
<!--stop-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
<!--bulk server add end-->
<br>
			<div class="row">
				<div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-users"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Servers</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalNoOfActiveServerUsers }} / {{statistics.totalNoOfServersAlloted}}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-desktop"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalStorageUtilized }} / {{ statistics.totalStorageAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-danger" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-history"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Servers Installed</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalNoOfServerDevices }}</span>
                                            </div>
                                        </div>
				</div>
			</div>
<!--server list start-->
<div class="panel" style="height:500px;overflow:scroll;">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('List of Servers', 'keywords');?>
                        <!--<a ng-click="exportServersToExcel()" class="btn btn-small btn-primary <?php if(!isMobile()) { ?> pull-right <?php } ?>">Export Servers</a>-->
                        <!--<button class="btn btn-primary btn-small pull-right" data-toggle="modal" data-target="#addServer">Add Servers in Bulk</button>-->
                    </h4>
                </div>
                <div class="panel-body">
                	<!--<div class="row">
                        <form class="col-lg-12" ng-submit="searchUser1()" data-parsley-validate>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <select class="assignUsersMsp" name="userNames[]" style="width: 100%;" data-parsley-trigger="change" id="selectAssignUsersMsp" multiple="multiple"></select>
                                    </div>
                                </div>
                        </form>
                    </div>-->
                    <br/>
                    <div class="panel nouserListTable" style="display: none;">
                        <div>
                                <h2 align="center">No Users Found</h2>
                        </div>
		    </div>
		    <div class="serverStatus" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive serverDevicesList" style="display: none;">
		    <div class="form-group" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchServerInput" onkeyup="searchedBluvaultServers()" placeholder="Search by Server Name.." title="Type in a Server Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover serverDevicesListTable" id="serverDevicesListTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'name'; sortReverseMSPD = !sortReverseMSPD">
                                Server
                                <span ng-show="sortTypeMSPD == 'name' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'name' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'policyName'; sortReverseMSPD = !sortReverseMSPD">
                                Policy Name
                                <span ng-show="sortTypeMSPD == 'policyName' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'policyName' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'status'; sortReverseMSPD = !sortReverseMSPD">
                                Status
                                <span ng-show="sortTypeMSPD == 'status' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'status' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'createdOn'; sortReverseMSPD = !sortReverseMSPD">
                                Server Configured on
                                <span ng-show="sortTypeMSPD == 'createdOn' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'createdOn' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'lastSuccessfullBackup'; sortReverseMSPD = !sortReverseMSPD">
                                Last Successful Backup
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'storageValue'; sortReverseMSPD = !sortReverseMSPD">
                                Data Utilized
                                <span ng-show="sortTypeMSPD == 'storageValue' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'storageValue' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left">Action</th>
                        </tr>
                        </thead>
			<tbody>
			<tr class="addServerBtnRow">
				<td colspan="8" class="addServerBtnTD"><a class="btn btn-primary btn-small" ng-click="addServerRow()">Add Server</a></td>
			</tr>
			<tr class="addServerRow" style="display:none;">
				<td colspan="3">
					<div class="form-group">
                                        	<label for="serverName"><?=Language::show('Server Name', 'keywords')?></label>
                                                <input type="text" class="form-control" name="newServerName" id="newServerName" value="" placeholder="Enter Server Name" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@','_','-' and '.' Any other special characters are not allowed.">
					</div>
				</td>
				<td colspan="3">
					<div class="form-group">
						<label for="policy"><?=Language::show('Policy', 'keywords')?></label>
<?php if(!empty($data['serverbackupPolicies'])){ ?>
<input type="hidden" class="delegatedAdminPolicyServer" id="delegatedAdminPolicyServer" value="<?=$data['serverbackupPolicies'][0]?>"/>
<?php } ?>
						<select name="newServerPolicy" id="newServerPolicy" class="form-control newServerPolicy"  title='Select Server Backup Policy Name'>												
						<?php if(!empty($data['serverbackupPolicies'])){ ?>
                                                <option value="suspended">No Backup</option>
                                                    <?php foreach($data['serverbackupPolicies'] as $value){
                                                    $label = $value;
                                                    $lastDashPosition = strrpos($label, "-");
                                                        if ($lastDashPosition !== false) {
                                                                $trimmedString = substr($label, 0, $lastDashPosition);
							}else{
								$trimmedString = $label;
							}
						        if (strpos($trimmedString, "Server_Backup") === 0) {
                                                            $trimmedString = 'Server Backup';
                                                        } else {
                                                            $trimmedString = $trimmedString;
                                                        }
                                                                if( strlen( $value ) > 75 ) {
                                                                   $label = substr( $label, 0, 75 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$trimmedString?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                         </div>
				</td>
				<td>
					<a class="btn btn-success btn-small" ng-click="addSingleMspServer()" style="margin-top:10%;">Save</a>
					<a class="btn btn-danger btn-small addServerCancel" ng-click="addServerCancel()" style="margin-top:10%;">Cancel</a>
				</td>
                            </tr>
			    <tr class="existingServers{{$index}}" ng-repeat="value in serverDevices | orderBy:sortTypeMSPD:sortReverseMSPD track by $index" class="mappingRowServers{{$index}}">			   
			    	<td ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak  title="{{value.name}}" ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;cursor:pointer;">{{ value.name | limitTo:30}}{{value.name.length > 30 ? '...' : ''}}
					<input type="hidden" class="gotnameserver" value="{{value.userNamePlain}}" />
			    	</td>
				<td ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak>
					<input type="hidden" class="gotpolicynameserver" value="{{value.policyName}}" />
					<select class="form-control serverPolicy" name="serverPolicyMappingPolicyNameServer{{$index}}" id="serverPolicyMappingPolicyNameServer{{$index}}" onchange="changedPolicyServer(this.id)" title="{{value.policyName}}">
                                        <?php if(!empty($data['serverbackupPolicies'])){ ?>
                                                    <?php foreach($data['serverbackupPolicies'] as $value){
                                                        $label = $value;
                                                        $lastDashPosition = strrpos($label, "-");
                                                        if ($lastDashPosition !== false) {
                                                                $trimmedString = substr($label, 0, $lastDashPosition);
							}else{
								$trimmedString = $label;
							}
							if (strpos($trimmedString, "Server_Backup") === 0) {
                                                            $trimmedString = 'Server Backup';
                                                        } else {
                                                            $trimmedString = $trimmedString;
                                                        }
                                                                if( strlen( $value ) > 75 ) {
                                                                   $label = substr( $label, 0, 75 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>" ng-selected="value.policyName == '<?=$value?>'"><?=$trimmedString?></option>
                                                    <?php } ?>
					<?php } ?>
					<option value="suspended" ng-selected="value.serverUserSuspend == true">No Backup</option>
                                        </select>
			    	</td>
			    	<td ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak>{{value.status}}</td>
			    	<td ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak>{{ value.createdOn}}</td>
			    	<td ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak> {{value.lastSuccessfullBackup}}</td>
				<td ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak> {{ value.storageUsedByDevice}}</td>
				<td ng-if="value.class == 'greyout'" ng-class="{ 'greyBck': value.class == 'greyout' }"ng-cloak>
					<a class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmServer', 'keywords')?></h4>" ng-bootbox-confirm-action="deleteServerProfile(value.namePlain, 'true', 'user', '')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('delete', 'keywords');?></a>
					<a class="btn btn-warning btn-small" ng-click="sendMailWelcomeMail(value.userNamePlain)" href="" style="background: #6d5cae !important;color:white!important;"><?=Language::show('Email Server Credentials', 'keywords');?></a>
                                </td>				
			    	<td ng-if="value.class != 'greyout'" class="text-left" ng-class="{ 'greyBck': value.class == 'greyout' }" ng-cloak>
                                	<a href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" class="btn btn-small btn-primary" style="width: 130px;">Backup Summary</a>
                                	<a ng-if="(value.blocked == false && value.backupStatus != 'STARTED') && (value.blocked == false && value.backupStatus != 'SCANNING')" ng-click="initiateBackupMSP(value.uuId)" class="btn btn-small btn-primary initiateBackupBtn{{$index}}" style="color:white !important;margin-left:5px;width: 130px;">Initiate Backup</a>
                                	<a ng-if="(value.blocked == false && value.backupStatus == 'STARTED') || (value.blocked == false && value.backupStatus == 'SCANNING')" class="btn btn-small btn-primary" style="color:white !important;margin-left:5px;width: 130px;cursor:unset !important;">Backup In Progress</a>
					<a ng-if="value.blocked == false" class="btn btn-warning btn-small" ng-bootbox-confirm="<h4><?=Language::show('blockConfirmServerMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockServerProfile(value.userNamePlain, 'true', 'user', value.name)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="background: #6d5cae !important;color:white!important;width: 125px;"><?=Language::show('Deactivate', 'keywords');?></a>
                                        <a ng-if="value.blocked == true" class="btn btn-success btn-small" ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmServerMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="unBlockServerProfile(value.userNamePlain, 'true', 'user', value.name)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('Reactivate', 'keywords');?></a>
                                        <a ng-if="value.blocked == true" class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmServer', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this Server.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteServerProfile(value.userNamePlain, 'true', 'user', value.name)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('delete', 'keywords');?></a>
                            	</td>
                            </tr>
			</tbody>
		    </table>
		    <div id="noResultsMessageServer" style="display:none;text-align: center;margin:20px;">No match found</div>
		    <a href="" class="btn btn-small btn-primary clickAble pull-right edittServers" ng-click="closeMSPServers()" style="display:none;">Cancel</a>
		    <a href="" class="btn btn-small btn-primary clickAble pull-right edittServers" ng-click="updateMultipleServersMsp()" style="display:none;">Apply</a>
		</div>
		<div class="row serverDevicesListTableNavigate hide">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountSD}} of {{totalpageCountSD}}</span></p>
                            <a class="btn btn-primary firstSD" title="First" ng-click="manageDevicesNavigate('backup', firstD)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousSD" title="Previous" ng-click="manageDevicesNavigate('backup', previousD)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextSD" title="Next" ng-click="manageDevicesNavigate('backup', nextD)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastSD" title="Last" ng-click="manageDevicesNavigate('backup', lastD)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>                    
                    <!--exportUsersToExcelModal starts-->
                    <div class="modal fade exportUsersToExcelModalServer" id="exportUsersToExcelModalServer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel">Export Servers</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                </div>
                                <div class="modal-body">
                                    <div class="col-lg-12" id="chooserServers">
                                        <div class="col-lg-6">
                                                <input type="radio" name="optradioServers" value="allServers" checked>
                                                <label for="link"><?=Language::show('All Servers', 'keywords');?></label>
                                        </div>
                                    </div>
                                    <br>
                                </div>
                                <div class="modal-footer">
                                    <a ng-click="exportUsersToExcelServers()" class="btn btn-success">Export Excel</a>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--exportUsersToExcelModal ends-->
                </div>
                </div>
                <!--server list end-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="deviceSB">

		    </div>
		    <!--<div role="tabpanel" class="tab-pane" id="policySB" ng-controller="PmsController">-->
		    <div role="tabpanel" class="tab-pane" id="policySB" ng-controller="PmsController">
<br>
		    <!--server policy management  start-->
<!--summary modal starts-->
			<!-- start -->
		<div class="panel" ng-controller="PmsController">
                <div class="panel-heading">
		    <h4><?=Language::show('Policy Summary', 'keywords');?>
			<select name="summaryPolicyNameServer" id="summaryPolicyNameServer" class="summaryPolicyNameServer col-lg-2" style="margin-left:20px;">
				<?php if(!empty($data['serverbackupPolicies'])){ ?>
                                                    <?php foreach($data['serverbackupPolicies'] as $value){
                                                    $label = $value;
                                                    $lastDashPosition = strrpos($label, "-");
                                                        if ($lastDashPosition !== false) {
                                                                $trimmedString = substr($label, 0, $lastDashPosition);
                                                        }else{
                                                                $trimmedString = $label;
							}
						    	if (strpos($trimmedString, "Server_Backup") === 0) {
                                                            $trimmedString = 'Server Backup';
                                                        } else {
                                                            $trimmedString = $trimmedString;
                                                        }
                                                                if( strlen( $value ) > 75 ) {
                                                                   $label = substr( $label, 0, 75 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$trimmedString?></option>
                                                    <?php } ?>
                                <?php } ?>
                        </select>
			<span class="pull-right">
				<a title="Edit" class="toolTip" id="policyEditServer" data-toggle="tooltip" data-placement="left" href="" ng-click="editSpecificFieldsServer()" style="margin:5px;"><i class="fa fa-edit"></i> </a>
				<a title="Clone" class="toolTip" id="policyCloneServer" data-toggle="tooltip" data-placement="left" href="" ng-click="cloneSpecificFieldsServer()" style="margin:5px;"><i class="fa fa-copy"></i> </a>
				<a ng-bootbox-confirm="<h4><?=Language::show('Are you sure to switch back to default settings for policy?.', 'keywords')?></h4>" ng-bootbox-confirm-action="switchToDefaultsServer()" ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-primary" id="switchToDefaultsServer" style="display:none;"><?=Language::show('Switch to defaults', 'keywords');?></a>
				<!--<a title="Export as PDF" href="" class="toolTip" id="policyDownloadServer" data-toggle="tooltip" data-placement="top" ng-click="downloadPolicyPdfSummaryServer()" style="margin:5px;"><i class="fa fa-download"></i></a>-->
			</span>
		    </h4>
                </div>
                    <div class="panel-body" id="viewBodyServer" style="padding: 0px 30px 30px 30px;">                   
                    <div class="row">
<!--summary table starts-->
<!-- table start-->
                                <div class="table-responsive">
                                    <table class="col-lg-12 table table-bordered table-striped deviceListTableServer">
					<tbody>                                        
					<tr class="newPolicygroupNameServerCloneRow" style="display:none;">
                                            <td class="col-lg-3">
                                                <span>Policy Name</span>
					    </td>
					    <td>						
						<input type="text" class="form-control" name="newPolicygroupNameServerClone" id="newPolicygroupNameServerClone" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>"value="" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @, - , _ and . Any other special characters are not allowed.">
						<input type="hidden" class="uniqueIdentifier" id="uniqueIdentifier" value="{{uniqueIdentifier}}" />
					    </td>
					 </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Schedules</span><p class="edittServer" style="display:none;">[Recommended Value: Daily 00:30]</p>
                                            </td>
                                            <td class="col-lg-9">
                                                <span class="olddServer" id="scheduleTypeSServer"></span><span class="olddServer"> : </span><span class="olddServer" id="scheduleTimeSServer"></span>
                                                <div class="col-lg-12 row edittServer initialSchServer" style="display:none;">
                                                <table class="col-lg-12 table table-bordered" id="scheduleEditTableServer">
                                                        <tbody>
                                                                <tr>
                                                                        <td class="col-lg-3">
                                                                                <div>
                                                                                        <select class="form-control" name="schedulesTypeSServer" id="schedulesTypeS1Server" title='Select Schedules Type'>
                                                                                                <option value="daily">Daily</option>
                                                                                                <option value="weekly">Weekly</option>
                                                                                        </select>
                                                                                </div>
                                                                        </td>
                                                                        <td class="col-lg-9">
                                                                                <div class="row col-lg-12">
                                                                                        <select class="form-control col-lg-5 daysSServer selectDaysPickerEditServer" name="daysSServer[]" id="daysS1Server" title='Select days' data-max-options="3" multiple style="display:none;">
                                                                                                <option value="Sunday"><?=Language::show('sunday', 'keywords')?></option>
                                                                                                <option value="Monday"><?=Language::show('monday', 'keywords')?></option>
                                                                                                <option value="Tuesday"><?=Language::show('tuesday', 'keywords')?></option>
                                                                                                <option value="Wednesday"><?=Language::show('wednesday', 'keywords')?></option>
                                                                                                <option value="Thursday"><?=Language::show('thursday', 'keywords')?></option>
                                                                                                <option value="Friday"><?=Language::show('friday', 'keywords')?></option>
                                                                                                <option value="Saturday"><?=Language::show('saturday', 'keywords')?></option>
                                                                                        </select>
                                                                                        <select class="form-control col-lg-5 daysSServer selectTimeSinglePickerEditServer" name="timeSingleServer[]" id="timeSingleServer" title='Select time' style="display:none;">
                                                                                                <option value="0000"><?=Language::show('00:00', 'keywords')?></option>
												<option value="0030"><?=Language::show('00:30', 'keywords')?></option>
                                                                                                <option value="0100"><?=Language::show('01:00', 'keywords')?></option>
                                                                                                <option value="0130"><?=Language::show('01:30', 'keywords')?></option>
                                                                                                <option value="0200"><?=Language::show('02:00', 'keywords')?></option>
                                                                                                <option value="0230"><?=Language::show('02:30', 'keywords')?></option>
                                                                                                <option value="0300"><?=Language::show('03:00', 'keywords')?></option>
                                                                                                <option value="0330"><?=Language::show('03:30', 'keywords')?></option>
                                                                                                <option value="0400"><?=Language::show('04:00', 'keywords')?></option>
                                                                                                <option value="0430"><?=Language::show('04:30', 'keywords')?></option>
                                                                                                <option value="0500"><?=Language::show('05:00', 'keywords')?></option>
                                                                                                <option value="0530"><?=Language::show('05:30', 'keywords')?></option>
                                                                                                <option value="0600"><?=Language::show('06:00', 'keywords')?></option>
                                                                                                <option value="0630"><?=Language::show('06:30', 'keywords')?></option>
												<option value="0700"><?=Language::show('07:00', 'keywords')?></option>
                                                                                                <option value="0730"><?=Language::show('07:30', 'keywords')?></option>
                                                                                                <option value="0800"><?=Language::show('08:00', 'keywords')?></option>
                                                                                                <option value="0830"><?=Language::show('08:30', 'keywords')?></option>
                                                                                                <option value="0900"><?=Language::show('09:00', 'keywords')?></option>
                                                                                                <option value="0930"><?=Language::show('09:30', 'keywords')?></option>
                                                                                                <option value="1000"><?=Language::show('10:00', 'keywords')?></option>
                                                                                                <option value="1030"><?=Language::show('10:30', 'keywords')?></option>
                                                                                                <option value="1100"><?=Language::show('11:00', 'keywords')?></option>
                                                                                                <option value="1130"><?=Language::show('11:30', 'keywords')?></option>
                                                                                                <option value="1200"><?=Language::show('12:00', 'keywords')?></option>
                                                                                                <option value="1230"><?=Language::show('12:30', 'keywords')?></option>
                                                                                                <option value="1300"><?=Language::show('13:00', 'keywords')?></option>
                                                                                                <option value="1330"><?=Language::show('13:30', 'keywords')?></option>
                                                                                                <option value="1400"><?=Language::show('14:00', 'keywords')?></option>
                                                                                                <option value="1430"><?=Language::show('14:30', 'keywords')?></option>
												<option value="1500"><?=Language::show('15:00', 'keywords')?></option>
                                                                                                <option value="1530"><?=Language::show('15:30', 'keywords')?></option>
                                                                                                <option value="1600"><?=Language::show('16:00', 'keywords')?></option>
                                                                                                <option value="1630"><?=Language::show('16:30', 'keywords')?></option>
                                                                                                <option value="1700"><?=Language::show('17:00', 'keywords')?></option>
                                                                                                <option value="1730"><?=Language::show('17:30', 'keywords')?></option>
                                                                                                <option value="1800"><?=Language::show('18:00', 'keywords')?></option>
                                                                                                <option value="1830"><?=Language::show('18:30', 'keywords')?></option>
                                                                                                <option value="1900"><?=Language::show('19:00', 'keywords')?></option>
                                                                                                <option value="1930"><?=Language::show('19:30', 'keywords')?></option>
                                                                                                <option value="2000"><?=Language::show('20:00', 'keywords')?></option>
                                                                                                <option value="2030"><?=Language::show('20:30', 'keywords')?></option>
                                                                                                <option value="2100"><?=Language::show('21:00', 'keywords')?></option>
                                                                                                <option value="2130"><?=Language::show('21:30', 'keywords')?></option>
                                                                                                <option value="2200"><?=Language::show('22:00', 'keywords')?></option>
												<option value="2230"><?=Language::show('22:30', 'keywords')?></option>
                                                                                                <option value="2300"><?=Language::show('23:00', 'keywords')?></option>
                                                                                                <option value="2330"><?=Language::show('23:30', 'keywords')?></option>
                                                                                        </select>
											<select class="form-control col-lg-5 daysSServer selectTimeMultiplePickerEditServer" name="timeMultipleServer[]" id="timeMultipleServer" title='Select time' multiple data-max-options="3" style="display:none;">
                                                                                                <option value="0000"><?=Language::show('00:00', 'keywords')?></option>
                                                                                                <option value="0030"><?=Language::show('00:30', 'keywords')?></option>
                                                                                                <option value="0100"><?=Language::show('01:00', 'keywords')?></option>
                                                                                                <option value="0130"><?=Language::show('01:30', 'keywords')?></option>
                                                                                                <option value="0200"><?=Language::show('02:00', 'keywords')?></option>
                                                                                                <option value="0230"><?=Language::show('02:30', 'keywords')?></option>
                                                                                                <option value="0300"><?=Language::show('03:00', 'keywords')?></option>
                                                                                                <option value="0330"><?=Language::show('03:30', 'keywords')?></option>
                                                                                                <option value="0400"><?=Language::show('04:00', 'keywords')?></option>
                                                                                                <option value="0430"><?=Language::show('04:30', 'keywords')?></option>
                                                                                                <option value="0500"><?=Language::show('05:00', 'keywords')?></option>
                                                                                                <option value="0530"><?=Language::show('05:30', 'keywords')?></option>
                                                                                                <option value="0600"><?=Language::show('06:00', 'keywords')?></option>
                                                                                                <option value="0630"><?=Language::show('06:30', 'keywords')?></option>
                                                                                                <option value="0700"><?=Language::show('07:00', 'keywords')?></option>
												<option value="0730"><?=Language::show('07:30', 'keywords')?></option>
                                                                                                <option value="0800"><?=Language::show('08:00', 'keywords')?></option>
                                                                                                <option value="0830"><?=Language::show('08:30', 'keywords')?></option>
                                                                                                <option value="0900"><?=Language::show('09:00', 'keywords')?></option>
                                                                                                <option value="0930"><?=Language::show('09:30', 'keywords')?></option>
                                                                                                <option value="1000"><?=Language::show('10:00', 'keywords')?></option>
                                                                                                <option value="1030"><?=Language::show('10:30', 'keywords')?></option>
                                                                                                <option value="1100"><?=Language::show('11:00', 'keywords')?></option>
                                                                                                <option value="1130"><?=Language::show('11:30', 'keywords')?></option>
                                                                                                <option value="1200"><?=Language::show('12:00', 'keywords')?></option>
                                                                                                <option value="1230"><?=Language::show('12:30', 'keywords')?></option>
                                                                                                <option value="1300"><?=Language::show('13:00', 'keywords')?></option>
                                                                                                <option value="1330"><?=Language::show('13:30', 'keywords')?></option>
                                                                                                <option value="1400"><?=Language::show('14:00', 'keywords')?></option>
                                                                                                <option value="1430"><?=Language::show('14:30', 'keywords')?></option>
												<option value="1500"><?=Language::show('15:00', 'keywords')?></option>
                                                                                                <option value="1530"><?=Language::show('15:30', 'keywords')?></option>
                                                                                                <option value="1600"><?=Language::show('16:00', 'keywords')?></option>
                                                                                                <option value="1630"><?=Language::show('16:30', 'keywords')?></option>
                                                                                                <option value="1700"><?=Language::show('17:00', 'keywords')?></option>
                                                                                                <option value="1730"><?=Language::show('17:30', 'keywords')?></option>
                                                                                                <option value="1800"><?=Language::show('18:00', 'keywords')?></option>
                                                                                                <option value="1830"><?=Language::show('18:30', 'keywords')?></option>
                                                                                                <option value="1900"><?=Language::show('19:00', 'keywords')?></option>
                                                                                                <option value="1930"><?=Language::show('19:30', 'keywords')?></option>
                                                                                                <option value="2000"><?=Language::show('20:00', 'keywords')?></option>
                                                                                                <option value="2030"><?=Language::show('20:30', 'keywords')?></option>
                                                                                                <option value="2100"><?=Language::show('21:00', 'keywords')?></option>
                                                                                                <option value="2130"><?=Language::show('21:30', 'keywords')?></option>
                                                                                                <option value="2200"><?=Language::show('22:00', 'keywords')?></option>
												<option value="2230"><?=Language::show('22:30', 'keywords')?></option>
                                                                                                <option value="2300"><?=Language::show('23:00', 'keywords')?></option>
                                                                                                <option value="2330"><?=Language::show('23:30', 'keywords')?></option>
                                                                                        </select>

                                                                                </div>
<span id="scheduleErrorServer" style="color: #f55753;font-size: 0.9em;display:none;">Please add at least one schedule.</span>
                                                                        </td>
                                                                </tr>
                                                        </tbody>
                                                </table>
						<select class="form-control selectScheduleEditPickerServer hide" ng-model="schedulesSServer" name="schedulesSServer[]" id="schedulesSServer" multiple title='Select Schedules' data-max-options="3">
                                                    <?php if(!empty($data['sch1'])){ ?>
                                                        <?php foreach($data['sch1'] as $key => $value){ ?>
                                                            <?php if(strpos($value, 'AM') !== false || strpos($value, 'PM') !== false){?>
                                                                <option value="<?=$value?>"><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </select>
                                                </div>
                                            </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Default Folders for Backup</span><p class="edittServer" style="display:none;">[Recommended Value: ALL]</p>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset;">
						<span class="olddServer" id="defaultFoldersSServer"></span>
						<div class="col-lg-12 edittServer" style="display:none;">
                                                        <div class="col-lg-12 row">
                                                                <ul class="list-group list-group-horizontal" ng-show="defaultUniversalFoldersServer.length" style="display:contents !important;">
                                                                        <li class="list-group-item" title="{{value}}" ng-if="value != '' " ng-repeat="value in defaultUniversalFoldersServer track by $index">{{ value | limitTo:20}}{{value.length > 20 ? '...' : ''}} <a href="javascript:;" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-bootbox-confirm="Are you sure you want to remove this folder?" ng-bootbox-confirm-action="removeInclusionFolderMspServer(value)" ng-bootbox-confirm-action-cancel="" style="margin-left:10px;"><i class="fa fa-times-circle-o"></i></a></li>
                                                                </ul>
                                                        </div>
                                                        <div class="input-group col-lg-6 row">
                                                                <input type="text" class="form-control" ng-model="defaultFoldersBackupMspServer" name="defaultFoldersBackupMspServer" id="defaultFoldersBackupMspServer" placeholder="Enter the full path of the folder" autocomplete="off"/>
                                                                <span class="input-group-btn">
                                                                        <button type="button" ng-click="addDefaultFolderMspServer(defaultFoldersBackupMspServer)" class="btn btn-default">Add</button>
                                                                </span>
                                                        </div >
                                                </div>
                                           </td>
					 </tr>
					 <tr <?php if($data['isSQLBkpEnabled'] != 'true'){ ?> class="d-none" <?php } ?>>
                                            <td class="col-lg-3">
                                                <span>Default Folders to Backup for MS SQL</span><br><a href="" class="clickAble edittServer showSQLSettingsServer" ng-click="addSqlServerServer()" style="display:none;font-size: small;font-weight: 600;">Configure SQL Server</a>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset;">
                                                <span class="olddServer" id="sqlFoldersSServer"></span>
                                                <div class="col-lg-12 edittServer" style="display:none;">
                                                        <div class="col-lg-12 row">
                                                                <ul class="list-group list-group-horizontal" ng-show="sqlBackupFoldersListServer.length" style="display:contents !important;">
                                                                        <li class="list-group-item" ng-if="value != '' " ng-repeat="value in sqlBackupFoldersListServer track by $index">{{ value }} <a href="javascript:;" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-bootbox-confirm="Are you sure you want to remove this folder?" ng-bootbox-confirm-action="removeDefaultFolderSQLServer($index)" ng-bootbox-confirm-action-cancel="" style="margin-left:10px;"><i class="fa fa-times-circle-o"></i></a></li>
                                                                </ul>
                                                        </div>
                                                        <div class="input-group col-lg-6 row">
                                                                <input type="text" class="form-control" ng-model="sqlBackupFoldersServer" name="sqlBackupFoldersServer" id="sqlBackupFoldersServer" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Please enter a valid folder path."/>
                                                                <span class="input-group-btn">
                                                                        <button type="button" ng-click="addDefaultFolderSQLServer(sqlBackupFoldersServer)" class="btn btn-default">Add</button>
                                                                </span>
                                                        </div >
                                                </div>
                                           </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Excluded Folders for Backup</span>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset;">
                                                <span class="olddServer" id="excludedFoldersSServer"></span>
                                                <div class="col-lg-12 edittServer" style="display:none;">
                                                        <div class="col-lg-12 row">
								<ul class="list-group list-group-horizontal" ng-show="newExcludedServer.length" style="display:contents !important;">
                                                                        <li class="list-group-item" title="{{value}}" ng-if="value != '' " ng-repeat="value in newExcludedServer track by $index">{{ value | limitTo:20}}{{value.length > 20 ? '...' : ''}} <a href="javascript:;" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-bootbox-confirm="Are you sure you want to remove this folder?" ng-bootbox-confirm-action="removeExclusionFolderMspServer(value)" ng-bootbox-confirm-action-cancel="" style="margin-left:10px;"><i class="fa fa-times-circle-o"></i></a></li>
                                                                </ul>
                                                        </div>
                                                        <div class="input-group col-lg-6 row">
                                                                <input type="text" class="form-control" ng-model="exclusionFolderNameMspServer" name="exclusionFolderNameMspServer" id="exclusionFolderNameMspServer" placeholder="Enter the full path of the folder" autocomplete="off"/>
                                                                <span class="input-group-btn">
                                                                        <button type="button" ng-click="addExclusionFolderMspServer(exclusionFolderNameMspServer)" class="btn btn-default">Add</button>
                                                                </span>
                                                        </div >
                                                </div>
                                           </td>
                                         </tr>                                 
                                         <tr>
                                            <td class="col-lg-3" style="white-space: unset!important;">
                                                <span>File Filters</span><p class="edittServer" style="display:none;">[Recommended Value: Inclusion of All Files]</p>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset!important;">
						<div class="col-lg-12 row olddServer" style="white-space: pre-wrap;">
                                                	<span>Filter </span><span id="filtersType1SServer"></span> : <span id="filtersSServer"></span>
						</div>
						<div class="col-lg-12 row edittServer" style="display:none;">
						    <label class="radio-inline" style="margin:5px;">
                                                        <input type="radio" name="optradioServer" id="inclusionRadioServer" value="inclusion"> Inclusion
                                                    </label>
                                                    <label class="radio-inline" style="margin:5px;">
                                                        <input type="radio" name="optradioServer" id="exclusionRadioServer" value="exclusion"> Exclusion
						    </label>
						    <div class="col-lg-4 edittServer" style="display:none;">
                                        		<select class="col-lg-10 selectFilterPickerMSPServer" name="filtersSServer[]" id="filtersMSPServer" required="" title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
				    </div>
				    <span id="filterErrorServer" style="color: #f55753;font-size: 0.9em;display:none;">Please add at least one filter.</span>
						</div>
						<span id="filterExtServerSpan"><br>
                                                        Filter Extensions : <!--<span id="filterExtS"></span>-->
							<input type="text" data-role="tagsinput" value="" class="form-control" name="filterExtSServer" id="filterExtSServer" autocomplete="off">
						</span>
                                            </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Throttle traffic at endpoint agent to</span>
                                            </td>
					    <td class="col-lg-9">
						<div class="col-lg-12 row olddServer">
							<span class="olddServer" id="nwFromClientToPGMBSOldServer"></span>
						</div>
						<div class="col-lg-12 row edittServer" style="display:none;">
                						<div class="col-lg-2" style="margin-top:5px;">
                    							<label class="switch">
                        							<input id="switchNwFromClientToPGMBSServer" type="checkbox" name="switchNwFromClientToPGMBSServer" value="true">
                        							<div class="slider round"></div>
                    							</label>
                						</div>
								<div class="col-lg-3">
                                              				<input type="text" class="form-control" name="nwFromClientToPGMBSServer" id="nwFromClientToPGMBSServer" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMBSServer();" disabled/>
                                              				<span id="switcherrorSServer" style="color: #f55753;font-size: 0.9em;"></span>
                                              				<span id="switchwarningSServer" style="color: #f27331;font-size: 0.9em;"></span>
                                              			</div>
                                              			<div class="col-lg-3">
                                                			<select class="form-control" name="networkThrottlingUnitSServer" id="networkThrottlingUnitSServer" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    			<option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    			<option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    			<option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                			</select>
                                              			</div>
							</div>	                                                
						</div>
                                            </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Throttle endpoint agent CPU usage</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <div class="slidecontainerSServer olddServer">
                                              		<input type="range" min="1" max="10" value="" name="cpuThrottlingSServer" class="slidercpuSServer" id="myRangeSServer"><span style="margin:20px;">  Value: <span id="demoSServer"></span></span>
						</div>
						<div class="edittServer" style="display:none;">
                                                        <input type="range" min="1" max="10" value="" name="cpuThrottlingSEditServer" class="slidercpuSServer" id="myRangeSEditServer"><span style="margin:20px;">  Value: <span id="demoSEditServer"></span></span>
                                                </div>
                                            </td>
					 </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>User Action Preferences</span>
                                            </td>
                                            <td class="col-lg-9">                                         
<div id="accordionServer">
  <div class="card">
    <div class="card-header" id="headingOneServer">
      <h5 class="mb-0">
	<a style="color:black; text-decoration: none;cursor:pointer;" data-toggle="collapse" data-target="#collapseOneServer" aria-expanded="true" aria-controls="collapseOneServer">Show User Action Preferences</a>
      </h5>
    </div>

    <div id="collapseOneServer" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
      <div class="card-bodyServer" style="pointer-events:none;opacity:0.6;">
	<div class="col-lg-12 row">
	    <div class="col-lg-12 row">
		<h4 style="margin-left: 20px;">Agent</h4>
	    </div>
	    <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchMyBackupFilesServer" type="checkbox" name="switchMyBackupFilesServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">My Backup Files</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchRestoreServer" type="checkbox" name="switchRestoreServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Restore</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSettingsServer" type="checkbox" name="switchSettingsServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Settings</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchRefreshPolicyServer" type="checkbox" name="switchRefreshPolicyServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Refresh Policy</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchInitiateBackupServer" type="checkbox" name="switchInitiateBackupServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Initiate Backup</span>
            </div>
            <div class="col-lg-3 row hide">
		<div class="col-lg-2">
		    <label class="switch">
			<input id="switchPauseBackupServer" type="checkbox" name="switchPauseBackupServer" value="true">
			<div class="slider round"></div>
		    </label>
                </div>
                <span style="margin-left: 20%;">Pause Backup</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchStopBackupServer" type="checkbox" name="switchStopBackupServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Stop Backup</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchCheckForUpdateServer" type="checkbox" name="switchCheckForUpdateServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Check for Update</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSupportRequestServer" type="checkbox" name="switchSupportRequestServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Support Request</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchDecoupleDeviceServer" type="checkbox" name="switchDecoupleDeviceServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Decouple Asset</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchAboutServer" type="checkbox" name="switchAboutServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">About</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchExitServer" type="checkbox" name="switchExitServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Exit</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSystemIconServer" type="checkbox" name="switchSystemIconServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Systray Icon</span>
            </div>
	</div>
	<div class="col-lg-12 row hide">
            <div class="col-lg-12 row">
                <h4 style="margin-left: 20px;">Portal</h4>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchOpenServer" type="checkbox" name="switchOpenServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Open</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchViewServer" type="checkbox" name="switchViewServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">View</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchVersionsServer" type="checkbox" name="switchVersionsServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Versions</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchRestorePServer" type="checkbox" name="switchRestorePServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Restore</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchDownloadServer" type="checkbox" name="switchDownloadServer" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Download</span>
            </div>
	</div>
      </div>
    </div>
  </div>    
  </div>
</div>
</td>
					 </tr>
					 <tr>
						<td> Custom Commands</td>
						<td class="commandsRow">
						    <div id="accordionServerCustom">
  							<div class="card">
    							    <div class="card-header" id="headingOneServerCustom">
      								<h5 class="mb-0">
        							    <a style="color:black; text-decoration: none;cursor:pointer;" data-toggle="collapse" data-target="#collapseOneServerCustom" aria-expanded="true" aria-controls="collapseOneServerCustom">Show Custom Commands</a>
      								</h5>
    							    </div>
							    <div id="collapseOneServerCustom" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
      							<div class="card-bodyServerCustom" style="pointer-events:none;opacity:0.6;">
							<div class="row col-lg-12">
                                            			<div class="col-lg-3">
                                                			<label for="preScanCommandEnabledServerEdit">Enable Pre Scan Command</label><br>
                                                			<label class="switch">
                                                			<input id="preScanCommandEnabledServerEdit" name="preScanCommandEnabledServerEdit" type="checkbox" value="true">
                                                			<div class="slider round"></div>
                                                			</label>
                                            			</div>
                                            			<div class="col-lg-5 form-group">
                                                			<label for="preScanCommandServerEdit"><?=Language::show('Pre Scan Command Path', 'keywords');?></label>
                                                			<input type="text" class="form-control" name="preScanCommandServerEdit" id="preScanCommandServerEdit" placeholder="" autocomplete="off" value="" disabled>
                                            			</div>
                                            			<div class="col-lg-3 form-group">                                       
                                                    				<label for="continueOnPreScanServerEdit">Continue backup on command-failure</label><br>
                                                    				<input id="continueOnPreScanServerEdit" name="continueOnPreScanServerEdit" type="checkbox" value="enabled">                                                			
                                            			</div>
                                    			</div>
                                    			<div class="row col-lg-12">
                                        			<div class="col-lg-3">
                                                			<label for="preBackupCommandEnabledServerEdit">Enable Pre Backup Command</label><br>
                                                			<label class="switch">
                                                			<input id="preBackupCommandEnabledServerEdit" name="preBackupCommandEnabledServerEdit" type="checkbox" value="true">
                                                			<div class="slider round"></div>
                                                			</label>
                                        			</div>
                                        			<div class="col-lg-5 form-group">
                                                			<label for="preBackupCommandServerEdit"><?=Language::show('Pre Backup Command Path', 'keywords');?></label>
                                                			<input type="text" class="form-control" name="preBackupCommandServerEdit" id="preBackupCommandServerEdit" placeholder="" autocomplete="off" value="" disabled>
                                        			</div>
                                        			<div class="col-lg-3 form-group">                                              
                                                        			<label for="continueOnPreBkpServerEdit">Continue backup on command-failure</label><br>
                                                        			<input id="continueOnPreBkpServerEdit" name="continueOnPreBkpServerEdit" type="checkbox" value="enabled">                                                       
                                            			</div>
                                        		</div>
                                        		<div class="row col-lg-12">
                                            			<div class="col-lg-3">
                                                			<label for="postBackupCommandEnabledServerEdit">Enable Post Backup Command</label><br>
                                                			<label class="switch">
                                                			<input id="postBackupCommandEnabledServerEdit" name="postBackupCommandEnabledServerEdit" type="checkbox" value="true">
                                                			<div class="slider round"></div>
                                                			</label>
                                            			</div>
                                            			<div class="col-lg-5 form-group">
                                                			<label for="postBackupCommandServerEdit"><?=Language::show('Post Backup Command Path', 'keywords');?></label>
                                                			<input type="text" class="form-control" name="postBackupCommandServerEdit" id="postBackupCommandServerEdit" placeholder="" autocomplete="off" value="" disabled>
                                            			</div>
                                            			<div class="col-lg-3 form-group">
                                                				<label for="continueOnPostBkpServerEdit">Continue backup on command-failure</label><br>
                                                				<input id="continueOnPostBkpServerEdit" name="continueOnPostBkpServerEdit" type="checkbox" value="enabled">                                
                                            			</div>
							</div>
							</div>
						    </div>
						  </div>
						</div>
						</td>
					 </tr>
                                        </tbody>
				    </table>
<div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>Note: For more information on how to configure these settings, you may refer to the <a href="<?=Url::templatePath()?>images/Administrator_Guide_Server.pdf" target="_blank">Administration Guide.</a> </p>
                                </div>
                            </div>
                        </div>
<a href="" class="btn btn-small btn-primary clickAble pull-right edittServer" ng-click="closeMSPPolicyServer()" style="display:none;margin-bottom: 10px;">Cancel</a>
<a href="" class="btn btn-small btn-primary clickAble pull-right edittServerBtn" ng-click="policyCreateEditMspServer()" style="display:none;margin-right: 10px;margin-bottom: 10px;">Apply</a>
<a href="" class="btn btn-small btn-primary clickAble pull-right cloneServerBtn" ng-click="policyCloneMspServer()" style="display:none;margin-right: 10px;margin-bottom: 10px;">Apply</a>
                                </div>
                                <!-- table ends-->
<!--summary table ends-->
<!--sql server modal start-->
<div class="modal fade" id="configureSqlServerServer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'sqlFormServer',
                        'id' => 'sqlFormServer',
                        'autocomplete' => 'off',
                        'ng-submit' => 'addSqlServerConfirmServer()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Configure SQL Server</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group col-lg-12">
                                        <label for="serverUserNameServer"><?=Language::show('SQL Server User Name', 'keywords');?></label>
                                        <input type="text" class="form-control" name="serverUserNameServer" id="serverUserNameServer" value="" placeholder="Enter Server User Name" autocomplete="off" required>
                                </div>
                                <div class="form-group col-lg-12">
                                        <label for="serverPasswordServer"><?=Language::show('SQL Server Password', 'keywords');?></label>
                                        <input type="password" class="form-control" name="serverPasswordServer" id="serverPasswordServer" value="" placeholder="Enter Server Password" autocomplete="off" required>
                                        <span toggle="#serverPasswordphraseServer" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-serverPasswordphraseServer"></span>
                                </div>
				<div class="form-group col-lg-12">
                                        <label for="serverRePasswordServer"><?=Language::show('Re-Type SQL Server Password', 'keywords');?></label>
                                        <input type="password" class="form-control" name="serverRePasswordServer" id="serverRePasswordServer" placeholder="Re-Type Server Password" autocomplete="off" value="" data-parsley-equalto="#serverPasswordServer" data-parsley-trigger="change" required/>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveSqlServerServer btn btn-success">Save</button>
                            </div>
                        </div>
                    <?= Form::close(); ?>
                    <!--</form>-->
                </div>
    </div>
<!--sql server modal ends-->
<div class="modal fade" id="inclusionToExclusionServer" tabindex="-1" role="dialog" aria-labelledby="confirmationModalInServerLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" >Warning</h5>
      </div>
      <div class="modal-body">
        You have now decided to include all these file types.  Are you sure of this, and want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" ng-click="includeToExcludeCancelServer()">No</button>
        <button type="button" class="btn btn-primary" ng-click="includeToExcludeProceedServer()">Yes</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="exclusionToInclusionServer" tabindex="-1" role="dialog" aria-labelledby="confirmationModalExServerLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" >Warning</h5>
      </div>
      <div class="modal-body">
        You have now decided to exclude all these file types.  Are you sure of this, and want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" ng-click="excludeToIncludeCancelServer()">No</button>
        <button type="button" class="btn btn-primary" ng-click="excludeToIncludeProceedServer()">Yes</button>
      </div>
    </div>
  </div>
</div>
<!--exclusion confirmation starts-->
<div class="modal fade" id="confirmAdd1Server" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirmServer(exclusionFolderName)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
<!--exclusion confirmation ends-->
                    </div>
</div>
                    </div>                   
<!--summary modal ends-->

<!--actual policy edit starts-->
<div class="panel-body hide" style="padding: 0px 30px 30px 30px;">
                    <span class="d-none currentPage"><?='editPolicyServer'?></span>
		    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                    <span class="d-none policyType"><?='SERVER'?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyFormServer',
			'id' => 'policyFormServer',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreateEditServer()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="row">
                        <div class="col-lg-7">
                            
                            <div class="form-group">
                                <label for="policyNameServer"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyNameServer" id="policyNameServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" value="{{ selectedPolicyServer.policygroupName }}" required autocomplete="off" readonly>
                                <label for="descriptionServer"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="descriptionServer" name="descriptionServer" id="descriptionServer" placeholder="Enter Policy Description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512"></textarea>
			    </div>
<div class="form-group">
                                <label for="policyStorageSizeAllowedServer"><?=Language::show('policyStorageSizeAllowed', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyStorageSizeAllowedServer" id="policyStorageSizeAllowedServer" placeholder="" value="" autocomplete="off">
                                <label for="policyUsersAllowedServer"><?=Language::show('policyUsersAllowed', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyUsersAllowedServer" id="policyUsersAllowedServer" placeholder="" value="" autocomplete="off">
                            </div>
                        </div>
                    </div>
                                        
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#generalServer" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#emailAlertConfigurationsServer" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>                        
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#uISettingsForAgentServer" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                        <li class="nav-item d-none" role="presentation"><a href="" class="nav-link" data-target="#searchServer" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
<?php } ?>
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#advancedServer" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="generalServer">

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedulesServer"><?=Language::show('schedules', 'keywords');?><?php  if(PORTAL_LIGHT_VERSION == false){ ?> - <a href="" class="clickAble" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;">Create New Schedule</a><?php } ?></label>
                                        <select class="form-control selectSchedulePickerServer" ng-model="schedulesServer"  name="schedulesServer[]" id="schedulesServer" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['sch1'])){ ?>
                                                <?php foreach($data['sch1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="defaultSchedulesServer.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedulesServer">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                            <td>                                                                
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="getParticularSchedule(value.scheduleName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersionsServer"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxFileVersions == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchverServer" type="checkbox" <?php if(maxFileVersions == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxFileVersions == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxVersionsServer" id="maxVersionsServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVerServer();" disabled/>
                                            <span id="vererrorServer" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSizeServer"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxPermissibleFileSize == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchsizeServer" type="checkbox" <?php if(maxPermissibleFileSize == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxPermissibleFileSize == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxPermissibleFileSizeServer" id="maxPermissibleFileSizeServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPSServer();" disabled/>
                                            <span id="sizeerrorServer" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>d-none<?php } ?>">
					<label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimitServer"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(userStorageQuta == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchlimitServer" type="checkbox" <?php if(userStorageQuta == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(userStorageQuta == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="perUserBackupStorageLimitServer" id="perUserBackupStorageLimitServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBSServer();" disabled/>
                                            <span id="limiterrorServer" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="noOfDevicesAllowedServer"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                        <input type="number" class="form-control" name="noOfDevicesAllowedServer" id="noOfDevicesAllowedServer" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" min="1" onfocusout="myFunctionDeviceServer();"/>
                                        <span id="deviceerrorServer" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div   class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version">
                                        <label for="osTypeServer"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePickerServer" name="osTypeServer" id="osTypeeServer" required="" title='Select OS Type' disabled>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div><?php } else {?>
                                    <div class="form-group">
                                        <label for="osTypeServer"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePickerServer" name="osTypeServer" id="osTypeeServer" required="" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackupServer"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackupServer" name="defaultFoldersBackupServer" id="defaultFoldersBackupServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('inclusionError', 'keywords')?>"/>
                                            <span class="input-group-btn">
                                    		<button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default" style="padding-bottom: 10px;" type="button">Add</button>
                                	    </span>
                                        </div>
                                    </div>
				    <!-- sql start-->
				    <?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
				    <div class="form-group">
                                        <label for="sqlBackupFoldersServer"><?=Language::show('defaultFoldersBackup', 'keywords');?> for MS SQL</label> <a href="" class="clickAble showSQLSettingsServer" ng-click="addSqlServer()" style="font-size: small;font-weight: 600;">Configure SQL Server</a>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="sqlBackupFoldersServer" name="sqlBackupFoldersServer" id="sqlBackupFoldersServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?> for SQL" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('inclusionError', 'keywords')?>" />
                                            <span class="input-group-btn">
                                        	<button ng-click="addDefaultFolderSQL(sqlBackupFolders)" class="btn btn-default sqlBackupFoldersBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                    	    </span>
                                        </div>
				    </div>
				    <div class="form-group hide">
				    	<label for="serverUserNameToSaveServer"><?=Language::show('Server User Name', 'keywords');?></label>
				    	<input type="text" class="form-control" name="serverUserNameToSaveServer" id="serverUserNameToSaveServer" value="" placeholder="Enter Server User Name" autocomplete="off">
				    </div>
				    <div class="form-group hide">
				    	<label for="serverPasswordToSaveServer"><?=Language::show('Server Password', 'keywords');?></label>
				    	<input type="password" class="form-control" name="serverPasswordToSaveServer" id="serverPasswordToSaveServer" value="" placeholder="Enter Password" autocomplete="off">
				    </div>
				    <?php } ?>
				    <!--sql end-->
                                    <div class="form-group">
                                        <label for="exclusionFolderNameServer"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="exclusionFolderNameServer" name="exclusionFolderNameServer" id="exclusionFolderName1Server" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>" />
                                            <span class="input-group-btn">
                                                <button type="button" ng-click="addExclusionFolder(exclusionFolderName)" class="btn btn-default">Add</button>
                                            </span>
                                        </div >
                                    </div>
                                    <!--start-->
                                    <div>
                                        <div class="form-group col-lg-12">
                                            <label for="exceptionFolderName"Server><?=Language::show('Exceptions to exclusions', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" ng-model="exceptionFolderNameServer" name="exceptionFolderNameServer" id="exceptionFolderNameServer" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>"/>
                                                <span class="input-group-btn">
                                                    <button type="button" ng-click="addExceptionFolder(exceptionFolderName)" class="btn btn-default exceptionFoldersBtn">Add</button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end-->
                                    <div class="form-group d-none">
                                        <label for="memoryUtilizationServer"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilizationServer" id="memoryUtilizationServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicyServer.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cpuUtilizationServer"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilizationServer" id="cpuUtilizationServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicyServer.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="clientDedupServer"><?=Language::show('Client Dedup', 'keywords');?></label>
                                        <select class="form-control clientDedupServer" name="clientDedupServer" id="clientDedupServer" title='Select <?=Language::show('clientDedup', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="maxFileSizeForBkpBatchServer"><?=Language::show('Maximun File Size For Backup Batch', 'keywords');?></label>
                                        <input type="text" class="form-control" name="maxFileSizeForBkpBatchServer" id="maxFileSizeForBkpBatchServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSizeForBkpBatch', 'keywords');?>" autocomplete="off" value="50" />
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="overflow-y: scroll;height: 450px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div  ng-if="osTypeServer == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFoldersServer.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultWinFoldersServer track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultWinFoldersServer.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osTypeServer == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFoldersServer.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultMacFoldersServer track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultMacFoldersServer.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osTypeServer == 'universal'">
                                                        <ul class="list-group" ng-if="defaultUniversalFoldersServer.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFoldersServer track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFoldersServer.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
						<?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
						<div class="form-group hide" style="margin-left:10px;">
                                                    <div class="checkbox check-primary">
                                                        <input id="sqlbkpEnabledServer" name="sqlbkpEnabledServer" type="checkbox" value="enabled">
                                                        <label for="sqlbkpEnabledServer"><?=Language::show('Backup SQL Database', 'keywords');?></label>
                                                    </div>
						</div>
						<!--SQl start-->
						<div class="panel panel-default" style="overflow-y: scroll;height: 150px;">
							<div class="panel-heading">
								<h5> <i class="fa fa-folder-open"></i> Default MS SQL Folders</h5>
						       </div>
							<div class="panel-body">
								<div class="table-responsive">
									<div  ng-if="osTypeServer == 'universal'">
										<ul class="list-group" ng-if="sqlBackupFoldersListServer.length >= 1">
											<li style="word-wrap: break-word" ng-repeat="value in sqlBackupFoldersListServer track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolderSQL($index)"><i class="fa fa-times-circle-o"></i></a></li>
										</ul>
										<span ng-if="sqlBackupFoldersListServer.length <= 0">There are no default folders for SQL to backup</span>
									</div>
								</div>
							</div>
						</div>
						<!--SQL ends-->
						<?php } ?>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div ng-if="osTypeServer == 'windows'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersWindowsServer.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersWindowsServer track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersWindowsServer.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osTypeServer == 'mac'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersMacServer.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersMacServer track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersMacServer.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osTypeServer == 'universal'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversalServer.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversalServer track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversalServer.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <!--start-->
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Exceptions to exclusions </h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div ng-if="osTypeServer == 'windows'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersWindowsServer.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersWindowsServer track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersWindowsServer.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osTypeServer == 'mac'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersMacServer.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersMacServer track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersMacServer.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osTypeServer == 'universal'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersUniversalServer.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersUniversalServer track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersUniversalServer.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                </div>
                                                <!--end-->
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <label for="filtersServer"><?=Language::show('filters', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filtersServer"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectFilterTypePickerServer" name="filtersTypeServer" id="filtersTypeServer" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<div class="row col-lg-12">
                                            <h5 class="col-lg-1 inclusionBadgeServer" style="margin-top: 10px;"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                            <h5 class="col-lg-1 exclusionBadgeServer" style="display:none;margin-top:10px;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <select class="col-lg-10 selectFilterPickerServer" name="filtersServer[]" id="filtersServer" required="" title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
					</div>
					<div class="col-lg-12 row" style="margin-top:20px;">
						<div class="col-lg-2">
							<label class="switch">
								<input id="applyFilterToExceptionsToExclusionServer" type="checkbox" name="applyFilterToExceptionsToExclusionServer" value="true">
								<div class="slider round"></div>
							</label>
						</div>
						<span style="margin-top:5px;">Apply filters to Exceptions To Exclusions</span>
					</div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFiltersServer" ng-if="defaultFilterServer.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
						    <!--new start-->
						    <div class="form-group">
                                                        <label for="backupFilesWithoutExtensionServer">Backup files without an extension</label>
                                                        <input type="checkbox" class="backupFilesWithoutExtensionServer" name="backupFilesWithoutExtensionServer"/>
						    </div>
						    <!--new end-->
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilterServer">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:nowrap !important;">
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div role="tabpanel" class="tab-pane" id="emailAlertConfigurationsServer">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control userCreateAdminsServer" name="createUserServer[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadminsServer" name="createUserServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsersServer" name="createUserServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdminsServer" name="userDeletedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadminsServer" name="userDeletedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsersServer" name="userDeletedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control userBlockedAdminsServer" name="userBlockedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>   
                                    </div>                                 
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadminsServer" name="userBlockedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsersServer" name="userBlockedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdminsServer" name="userLimitReachedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadminsServer" name="userLimitReachedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsersServer" name="userLimitReachedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedAdminsServer" name="deviceDeletedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedReadonlyadminsServer" name="deviceDeletedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Deleted', 'keywords');?></label>
                                        <select class="form-control deviceDeletedUsersServer" name="deviceDeletedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                             
                                        <select class="form-control deviceBlockedAdminsServer" name="deviceBlockedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceBlockedReadonlyadminsServer" name="deviceBlockedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Blocked', 'keywords');?></label>
                                        <select class="form-control deviceBlockedUsersServer" name="deviceBlockedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control deviceDecoupledAdminsServer" name="deviceDecoupledServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDecoupledReadonlyadminsServer" name="deviceDecoupledServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device de-couple', 'keywords');?></label>
                                        <select class="form-control deviceDecoupledUsersServer" name="deviceDecoupledServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control deviceLimitReachedAdminsServer" name="deviceLimitReachedServer[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedReadonlyadminsServer" name="deviceLimitReachedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Limit Reached', 'keywords');?></label>
                                        <select class="form-control deviceLimitReachedUsersServer" name="deviceLimitReachedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control weeklyBackupReportAdminsServer" name="weeklyBkpreportServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control weeklyBackupReportReadonlyadminsServer" name="weeklyBkpreportServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Weekly backup report', 'keywords');?></label>
                                        <select class="form-control weeklyBackupReportUsersServer" name="weeklyBkpreportServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group"> 
                                        <select class="form-control firstBackupCompletedAdminsServer" name="firstBkpCompletedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control firstBackupCompletedReadonlyadminsServer" name="firstBkpCompletedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('First backup completed', 'keywords');?></label>
                                        <select class="form-control firstBackupCompletedUsersServer" name="firstBkpCompletedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreInitiatedAdminsServer" name="restoreInitiatedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreInitiatedReadonlyadminsServer" name="restoreInitiatedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore initiated', 'keywords');?></label>
                                        <select class="form-control restoreInitiatedUsersServer" name="restoreInitiatedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
				    
				<div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreCompletedAdminsServer" name="restoreCompletedServer[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreCompletedReadonlyadminsServer" name="restoreCompletedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore completed', 'keywords');?></label>
                                        <select class="form-control restoreCompletedUsersServer" name="restoreCompletedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control storageLimitReachedAdminsServer" name="storageLimitReachedServer[]">
                                        <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                        <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control storageLimitReachedReadonlyadminsServer" name="storageLimitReachedServer[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Storage limit reached', 'keywords');?></label>
                                        <select class="form-control storageLimitReachedUsersServer" name="storageLimitReachedServer[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgentServer">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfilesServer" name="bkpfilesServer" id="bkpfilesServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettingsServer" name="bkpsettingsServer" id="bkpsettingsServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <select class="form-control initiatebackupServer" name="initiatebackupServer" id="initiatebackupServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <select class="form-control stopbackupServer" name="stopbackupServer" id="stopbackupServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control supportServer" name="supportServer" id="supportServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="aboutServer"><?=Language::show('ABOUT', 'keywords');?></label>
                                        <select class="form-control aboutServer" name="aboutServer" id="aboutServer" required="" title='Select <?=Language::show('about', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotificationsServer"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotificationsServer" name="blockNotificationsServer" id="blockNotificationsServer" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>
                                   <div class="form-group">
                                        <label for="systrayIconServer"><?=Language::show('Systray Icon', 'keywords');?></label>
                                        <select class="form-control systrayIconServer" name="systrayIconServer" id="systrayIconServer" required="" title='Select <?=Language::show('systrayIcon', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restoreServer" name="restoreServer" id="restoreServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicyServer" name="refbkppolicyServer" id="refbkppolicyServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="pauseBackupServer"><?=Language::show('PAUSE_BACKUP', 'keywords');?></label>
                                        <select class="form-control pauseBackupServer" name="pauseBackupServer" id="pauseBackupServer" required="" title='Select <?=Language::show('pauseBackup', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="updateAgentServer"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                        <select class="form-control updateAgentServer" name="updateAgentServer" id="updateAgentServer" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <select class="form-control decoupleServer" name="decoupleServer" id="decoupleServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>				    
				    <div class="form-group hide">
                                        <label for="disallowAdminRestoresServer"><?=Language::show('Disallow Admin Restores', 'keywords');?></label>
                                        <select class="form-control disallowAdminRestoresServer" name="disallowAdminRestoresServer" id="disallowAdminRestoresServer" required="" title='Select <?=Language::show('Disallow Admin Restores', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabledServer"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exittServer" name="exittServer" id="exittServer" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                   
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 row">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group OpenServer">
                                            <label for="OpenServer"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control OpenServer" name="OpenServer" id="OpenServer" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group VersionsServer">
                                            <label for="VersionsServer"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control VersionsServer" name="VersionsServer" id="VersionsServer" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group DownloadServer">
                                            <label for="DownloadServer"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control DownloadServer" name="DownloadServer" id="DownloadServer" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group ViewServer">
                                            <label for="ViewServer"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control ViewServer" name="ViewServer" id="ViewServer" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group ShareServer hide">
                                            <label for="ShareServer"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control ShareServer" name="ShareServer" id="ShareServer" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group portalRestoreServer">
                                            <label for="portalRestoreServer"><?=Language::show('Restore', 'keywords');?></label>
                                            <select class="form-control portalRestoreServer" name="portalRestoreServer" id="portalRestoreServer" required="" title='Select <?=Language::show('Restore', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row shareDetailsLabelServer hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>              
			   	    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="shareDomainsEnabledServer" name="shareDomainsEnabledServer" type="checkbox" value="enabled">
                                                    <label for="shareDomainsEnabledServer"><?=Language::show('Enable Domain Control', 'keywords');?></label>
                                                </div>
                                        </div>
					<div class="row">
						<div class="form-group col-lg-6">
							<label for="shareDomainIncExclusionsServer"><?=Language::show('Share Domain Inclusions/Exclusions', 'keywords');?></label>
							<input type="text" class="form-control" name="shareDomainIncExclusionsServer" id="shareDomainIncExclusionsServer" placeholder="" autocomplete="off" value="" />
						</div>
						<div class="col-lg-6" style="margin-left:-14px;margin-top:20px;">
							<div class="col-lg-12" style="margin-bottom:15px;">
								<input type="radio" name="shareDomainTypeServer" id="onlyServer" value="Share only with these Email domains">
								<label for="link"><?=Language::show('Share only with these Email domains', 'keywords');?></label>
								</br>
								<input type="radio" name="shareDomainTypeServer" id="withallServer" value="Share with all Email domains excepting these">
								<label for="link"><?=Language::show('Share with all Email domains excepting these', 'keywords');?></label>
							</div>
						</div>
					</div>
				    </div>
				    <div class="col-lg-6 row" style="margin-top:10px;">
                                        <div class="col-lg-2 controllerSLBlockServer">
                                        	<label class="switch">
                                        		<input id="controllerSLServer" type="checkbox" name="controllerSLServer" value="true">
                                        		<div class="slider round"></div>
                                        	</label>
                                        </div>
					<span style="margin-top:5px;">Allow sharer visibility to the shared link</span>

				    </div>
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabledServer" name="highSecureShareEnabledServer" type="checkbox" value="enabled">
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-6 row">
							<div class="col-lg-2 controllerCPBlockServer">
								<label class="switch">
									<input id="controllerCPServer" type="checkbox" name="controllerCPServer" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Complex Password</span>							
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerADBlockServer">
								<label class="switch">
									<input id="controllerADServer" type="checkbox" name="controllerADServer" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlockServer">
								<label class="switch">
									<input id="controllerEDServer" type="checkbox" name="controllerEDServer" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Require Expiration Date for shared data</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerMFABlockServer">
								<label class="switch">
									<input id="controllerMFAServer" type="checkbox" name="controllerMFAServer" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Enable multi-factor authentication</span>
						</div>
					</div>
				   </div>                                    
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="search">
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group contentIndexEnabledServer" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                            <label for="contentIndexEnabledServer"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabledServer" name="contentIndexEnabledServer" id="contentIndexEnabledServer" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search Filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble d-none" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectSearchFilterTypePickerServer" name="searchFilterTypeServer" id="searchfiltersTypeServer" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<select class="form-control selectSearchFilterPickerServer" name="searchfiltersServer[]" id="searchfiltersServer" title='Select Filters' multiple <?php if($data['searchEnabled'] == true){ ?> required <?php } ?>>
                                           <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultSearchFilterServer.length >= 1">
                                    <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSearchFilterServer">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td>
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advancedServer">
                            </br>

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4 d-none" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group d-none" <?php if(partialFileTransfer == false){ ?>  class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version" <?php } ?>>
                                        <label for="incrementalFileTransferServer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransferServer" name="incrementalFileTransferServer" id="incrementalFileTransferServer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>' <?php if(partialFileTransfer == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPGServer"><?=Language::show('nwFromClientToPG', 'keywords');?></label>
                                            <div class="col-lg-8" <?php if(networkThrotlling == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchServer" type="checkbox" <?php if(networkThrotlling == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
					</label></div>
<div class="row">
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMBServer" id="nwFromClientToPGMBServer" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherrorServer" style="color: #f55753;font-size: 0.9em;"></span>
                                              <span id="switchwarningServer" style="color: #f27331;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnitServer" id="networkThrottlingUnitServer" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
					      </div>
</div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="cpuThrottlingServer"><?=Language::show('CPU Throttling', 'keywords');?></label></br>
                                            <div class="slidecontainer">
                                              <input type="range" min="1" max="10" value="" name="cpuThrottlingServer" class="slidercpuServer" id="myRangeServer">
                                              <p>Value: <span id="demoServer"></span></p>
                                            </div>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="nwFromPGToCloudServer"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloudServer" id="nwFromPGToCloudServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicyServer.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="filesCrawlLimitServer"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimitServer" id="filesCrawlLimitServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicyServer.crawlLimit }}" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="networkThrottlingServer"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottlingServer" name="networkThrottlingServer" id="networkThrottlingServer" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5 d-none">
                                    </br></br>
                                    <div class="row partialfileattributerowServer">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default" style="margin-top:30px;">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSizeServer"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSizeServer" id="partialFileSizeServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicyServer.pftSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSizeServer"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSizeServer" id="fileChunkableSizeServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicyServer.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
				    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
				    <div class="col-lg-6 row">
                                        <div class="col-lg-2">
                                                <label class="switch">
                                                        <input id="legalHoldServer" type="checkbox" name="legalHoldServer" value="true">
                                                        <div class="slider round"></div>
                                                </label>
                                        </div>
                                        <span style="margin-top:5px;margin-left: 15%;">Legal Hold</span>
                                    </div>
                                    <div class="form-group" <?php if(legalHold == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <div class="checkbox check-primary">
                                            <!--<input id="legalHoldServer" name="legalHoldServer" type="checkbox" value="enabled"  <?php if(legalHold == false){ ?> disabled <?php }?>>
                                            <label for="legalHoldServer"><?=Language::show('legalHold', 'keywords');?></label>-->
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="If checked then dependent parameters get changed."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <span class="systemFoldersServer" style="display: none;">
                                                    <input id="systemFoldersServer" name="systemFoldersServer" type="checkbox" value="enabled">
                                                    <label for="systemFoldersServer"><?=Language::show('systemFolders', 'keywords');?></label>
                                                </span>
                                        </div>
                                    </div>
				    <?php if($data['rwDetectionEnabled'] == 'true'){ ?>
						<div class="col-lg-6 row">
							<span style="margin-top:5px;">Unusual Activity Detection Enabled</span>
							<div class="col-lg-2 rwDetectionEnabledBlockServer">
								<label class="switch">
									<input id="rwDetectionEnabledServer" type="checkbox" name="rwDetectionEnabledServer" value="true" checked>
									<div class="slider round"></div>
								</label>
							</div>
                                                </div>
				    <?php } ?>
                                    <div class="form-group col-lg-12">
				    <label class="col-lg-12" style="margin-left: -30px;" for="noOfDaysToKeepDeviceNotHeardServer"><?=Language::show('Block devices which have not been heard from in', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchnoOfDaysToKeepDeviceNotHeardServer" type="checkbox" checked>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-4">
                                            <input type="text" class="form-control" name="noOfDaysToKeepDeviceNotHeardServer" id="noOfDaysToKeepDeviceNotHeardServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('No. of Days To Keep Device Not Heard', 'keywords');?>" required autocomplete="off" value="60" onfocusout="myFunctionnoOfDaysToKeepDeviceNotHeard();"/>
                                            <span id="noOfDaysToKeepDeviceNotHearderrorServer" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
					<div class="col-lg-2" style="margin-top: 10px;"><label>days</label></div>
</div>
                                    </div>
				    <div class="form-group d-none">
                                        <label for="numberOfThreadsAllowedForBackupServer"><?=Language::show('Number of threads allowed for Backup', 'keywords');?></label>
                                        <input type="number" class="form-control" name="numberOfThreadsAllowedForBackupServer" id="numberOfThreadsAllowedForBackupServer" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Number of threads allowed for Backup', 'keywords');?>" required autocomplete="off" value="" min="1" max="5"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLoginServer" name="webBasedLoginServer" id="webBasedLoginServer" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminRestoreServer"><?=Language::show('Can Administrator Restore User Data', 'keywords');?></label>
                                        <select class="form-control canAdminRestoreServer <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminRestoreServer" id="canAdminRestoreServer" required="" title='Select <?=Language::show('Can Admin Restore', 'keywords')?>' onclick="flipAllowEndUserTocontrolRestore()">
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" style="margin-left:30px;<?php if($data['overridePolicySettings'] == true){?>pointer-events:none;opacity: 0.4;<?php } ?>">
                                        <label for="allowEndUserTocontrolRestoreServer"><?=Language::show('Allow end-user over-ride', 'keywords');?></label>
                                        <select class="form-control allowEndUserTocontrolRestoreServer <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="allowEndUserTocontrolRestoreServer" id="allowEndUserTocontrolRestoreServer" required="" title='Select option'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"> <?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminDeleteServer"><?=Language::show('Can Administrator Delete User Data', 'keywords');?></label>
                                        <select class="form-control canAdminDeleteServer <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminDeleteServer" id="canAdminDeleteServer" required="" title='Select <?=Language::show('Can Admin Delete', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                        <div class="form-group d-none">
                                            <label for="dedupServer"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedupServer" name="dedupServer" id="dedupServer" required="" title='Select <?=Language::show('dedup', 'keywords')?>' <?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } else { ?>
                                        <div class="form-group d-none">
                                            <label for="dedupServer"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedupServer" id="dedupServer" required="" title='Select <?=Language::show('dedup', 'keywords')?>'<?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <div class="form-group d-none">
                                        <label for="compEnabledServer"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabledServer" name="compEnabledServer" id="compEnabledServer" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>' <?php if(enableCompression == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainerServer d-none" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabledServer" name="vssEnabledServer" id="vssEnabledServer" required="" title='Select <?=Language::show('vss', 'keywords')?>'<?php if(backupFilesInUse == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="dcmEnabledServer"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabledServer" name="dcmEnabledServer" id="dcmEnabledServer" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPgServer" <?php if(blukryptSearch == false){ ?> class="toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Field cannot be edited in Lite Version"<?php }?>>
                                        <label for="searchAlgoForPgServer"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPgServer" name="searchAlgoForPgServer" id="sortAlgoForPgServer" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>' <?php if(blukryptSearch == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div class="form-group">
                                        <label for="BlukryptipaddressServer"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="BlukryptipaddressServer" style="background-color:#dcdcdc;" id="BlukryptipaddressServer" readonly />
                                    </div>
                                    <?php } else {?>
                                    <div class="form-group">
                                        <label for="BlukryptipaddressServer"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <?php if(!empty($data['pgs'])){ ?>
                                            <select class="blukryptIPAdressServer" multiple name="BlukryptipaddressServer[]" id="BlukryptipaddressServer" style="width: 100%">
                                                <?php foreach($data['pgs'] as $key => $value){ ?>
                                                    <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                <?php } ?>
                                            </select>
                                        <?php } ?>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group" <?php if(policyRefresh == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label for="policyRefreshServer"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefreshServer" name="policyRefreshServer" min="1" max="23" required="" <?php if(policyRefresh == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                    </div>
				    <div class="form-group d-none">
                                        <label class="col-lg-12" for="logUnaccessedFilesServer" style="margin-top:10px;"><?=Language::show('Capture Unaccessed Items', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchlogUnaccessedFilesServer" name="switchlogUnaccessedFilesServer" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                    </div>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroupServer" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheckServer" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomainsServer" name="switchAllowedDomainsServer" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomainsServer" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomainsServer" id="allowedDomainsServer" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomainsServer" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
				    </div>
				    <div class="form-group">
                                       <label for="autoupdateAgentServer"><?=Language::show('Auto Update Agent', 'keywords');?></label>
                                       <select class="form-control autoUpdateAgentServer" name="autoUpdateAgentServer" id="autoUpdateAgentServer" required="" title='Select <?=Language::show('Auto Update Agent', 'keywords')?>'>
                                           <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div>
				    <div class="form-group">
                                        <fieldset data-role="controlgroupServer" data-type="horizontal">
                                        <label class="col-lg-12" for="switchAgentPasswordServer" style="margin-left:-14px;"><?=Language::show('Agent uninstallation password', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAgentPasswordServer" name="switchAgentPasswordServer" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentPasswordServer" style="margin-left:-14px;"><?=Language::show('password', 'keywords');?></label>
                                                <input type="passwordServer" class="form-control" name="agentPasswordServer" id="agentPasswordServer" value="" placeholder="Enter Password" autocomplete="off" readonly>
                                                <span toggle="#passwordphraseServer" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphrase"></span>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentRePasswordServer" style="margin-left:-14px;"><?=Language::show('rePassword', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentRePasswordServer" id="agentRePasswordServer" placeholder="Re-Type Password" autocomplete="off" value="" data-parsley-equalto="#agentPasswordServer" data-parsley-trigger="change" readonly/>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group">
                                       <label for="canBackupHiddenFilesServer"><?=Language::show('canBackupHiddenFiles', 'keywords');?></label>
                                       <select class="form-control canBackupHiddenFilesServer" name="canBackupHiddenFilesServer" id="canBackupHiddenFilesServer" required="" title='Select <?=Language::show('canBackupHiddenFiles', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div style="padding-left:3%;" class="form-group row d-none">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="switchFairnessAlgorithmServer" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input type="number" class="form-control" min="0" name="daysToWaitForNextBackupServer" id="daysToWaitForNextBackupServer"  autocomptocomplete="off" value="0" disabled/>
                                            <span id="sizeerrorServer" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                   <div class="form-group">
                                       <label for="downloadAgentServer"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <a href="#" data-toggle="tooltip" data-placement="top" title="Relogin on portal is required"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                       <select class="form-control downloadAgentServer" name="downloadAgentServer" id="downloadAgentServer" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div class="form-group">
					 <span class="row" style="margin-left: 0px;"><p>Purge deleted files from the catalog after</p></span>
					<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchnoOfDaysToKeepDeletedFilesServer" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="noOfDaysToKeepDeletedFilesServer" id="noOfDaysToKeepDeletedFilesServer" autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionnoOfDaysToKeepDeletedFiles();" disabled/>
                                             <span id="sizenoOfDaysToKeepDeletedFilesServer" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
					 </div>
					</div>
					   <div class="form-group <?php if($data['showUserConsentFieldInPolicies'] != true){?>hide<?php } ?>">
                                         <span class="row" style="margin-left: 0px;"><p>User Consent Display Text</p></span>
					<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchuserConsentEnabledServer" name="userConsentEnabledServer" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-10">                                            
						 <textarea style="width:100%" class="userConsentDisplayTextServer" name="userConsentDisplayTextServer" id="userConsentDisplayTextServer" placeholder="Enter User Consent Display Text" data-parsley-trigger="change" rows="3" onfocusout="checkTextLength()"></textarea>
					     <span id="texterror" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
					</div>
					</div>   
                                     </div>
				    <div class="row">
					    <div class="col-lg-4">
						<label for="preScanCommandEnabledServer">Enable Pre Scan Command</label><br>
						<label class="switch">
						<input id="preScanCommandEnabledServer" name="preScanCommandEnabledServer" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="preScanCommandServer"><?=Language::show('Pre Scan Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preScanCommandServer" id="preScanCommandServer" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
					    	<div class="form-group">
					    	    <label for="legalHoldServer">Continue backup on command-failure</label>
						    <input id="continueOnPreScanServer" name="continueOnPreScanServer" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
				    <div class="row">
				    	<div class="col-lg-4">
						<label for="preBackupCommandEnabledServer">Enable Pre Backup Command</label><br>
						<label class="switch">
						<input id="preBackupCommandEnabledServer" name="preBackupCommandEnabledServer" type="checkbox">
						<div class="slider round"></div>
						</label>
					</div>
					<div class="col-lg-5 form-group">
						<label for="preBackupCommandServer"><?=Language::show('Pre Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preBackupCommandServer" id="preBackupCommandServer" placeholder="" autocomplete="off" value="">
					</div>
					<div class="col-lg-3">
						<div class="form-group">
							<label for="legalHoldServer">Continue backup on command-failure</label>
							<input id="continueOnPreBkpServer" name="continueOnPreBkpServer" type="checkbox" value="enabled">
							</div>
					    </div>
					</div>
					<div class="row">
					    <div class="col-lg-4">
						<label for="postBackupCommandEnabledServer">Enable Post Backup Command</label><br>
						<label class="switch">
						<input id="postBackupCommandEnabledServer" name="postBackupCommandEnabledServer" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="postBackupCommandServer"><?=Language::show('Post Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="postBackupCommandServer" id="postBackupCommandServer" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
						<div class="form-group">
					    	<label for="legalHoldServer">Continue backup on command-failure</label>
						<input id="continueOnPostBkpServer" name="continueOnPostBkpServer" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
                                    <div class="form-group d-none">
                                        <label for="fullBackupEnabledServer"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabledServer" name="fullBackupEnabledServer" id="fullBackupEnabledServer" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDateServer d-none" style="display: none;">
                                        <label for="fullBackupStartDateServer"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePickerServer input-small" id="fullBackupStartDateServer" name="fullBackupStartDateServer" placeholder="Select date for full backup" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Go to Global settings to enable this option."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePasswordServer"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNEServer <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canUserChangePasswordServer" id="canUserChangePasswordServer" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPasswordServer"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNEServer <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canAdminChangeUserPasswordServer" id="canAdminChangeUserPasswordServer" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePasswordServer"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordServer" name="canUserChangePasswordServer" id="canUserChangePasswordServer" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPasswordServer"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordServer" name="canAdminChangeUserPasswordServer" id="canAdminChangeUserPasswordServer" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
			    <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        Grayed out options are currently controlled in Cloud Properties. Please speak to you Administrator or visit the Cloud Properties page to change their behavior.
                                        <br/>Both password enforcement options cannot be disabled at same time.
                                    </p>
                                </div>
                            </div>
			    </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">                            
                            <a ng-bootbox-confirm="<h4><?=Language::show('Will be effective on next policy refresh, for immediate effect manually refresh policy.', 'keywords')?></h4>"
                                ng-bootbox-confirm-action="policyCreateEditServer()"
                                ng-bootbox-confirm-action-cancel="" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/serverpolicies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
<!--actual policy edit ends-->
		    <!--server policymanagement tab ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="reportSB">
<br>
		    <!--server dps report start-->
			<!--report starts-->
                        <div class="row col-lg-12">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h3>Data Protection Scorecard
                        <!--<button class="btn btn-primary dropdown-toggle pull-right" type="button" id="dropdownMenu1Server" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadUserBackupSummaryReportServer()" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadUserBackupSummaryReportPdfServer()" style="cursor:pointer;">PDF</a><li>
                                              </ul>-->
                                        </h3>
                    </div>
<br>
                    <div class="panel-body"><div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="updateUserBackupSummaryMspServer(search.noOfDays)">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <label for="searchPolicyNameServerBackup">Policy Name</label>
                                            <select name="searchPolicyNameServerBackup[]" id="searchPolicyNameServerBackup" multiple class="form-control selectPicker searchPolicyNameServerBackup"  title='Select Server Backup Policy Name'>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['serverbackupPolicies'])){ ?>
							<?php foreach($data['serverbackupPolicies'] as $value){
								$label = $value;
								$lastDashPosition = strrpos($label, "-");
								if ($lastDashPosition !== false) {
                                                                	$trimmedString = substr($label, 0, $lastDashPosition);
                                                        	}else{
                                                                	$trimmedString = $label;
								}
								if (strpos($trimmedString, "Server_Backup") === 0) {
                                                            		$trimmedString = 'Server Backup';
                                                        	} else {
                                                            		$trimmedString = $trimmedString;
                                                        	}
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$trimmedString?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="noOfDaysServer">Data Protection Scorecard for</label>
                                            <input type="number" id="noOfDaysServer" min="1" placeholder="Number Of Days" data-parsley-trigger="change" value="30"> <label style="margin-top:12px;">days </label>
					</div>
					<div class="dropdown col-lg-4" style="margin-top:25px;">
					    <a ng-click="updateUserBackupSummaryMspServer(search.noOfDays)" class="btn btn-primary"style="cursor:pointer;">View</a>
                                            <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenu1Server" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadUserBackupSummaryReportServer()" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadUserBackupSummaryReportPdfServer()" style="cursor:pointer;">PDF</a><li>
                                              </ul>                                            
                                        </div>
                                    </div>
                                </form>
                            </div>
			</div>
<br>
                        <div class="table-responsive">
                        <table id="NoBackupServer" class="table table-bordered noBackupServer" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Servers</td>
                                <td ng-cloak>{{ userBackupSummaryServer.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
                                <td class="text-left notForOfficeServer" ng-cloak>Servers with agent registered</td>
                                <td class="text-left forOfficeServer" ng-cloak>Servers with agent registered</td>
                                <td ng-cloak>{{ userBackupSummaryServer.userWithDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>
                                <td class="text-left notForOfficeServer" ng-cloak>No. of servers without agent registered</td>
                                <td class="text-left forOfficeServer" ng-cloak>No. of users without OneDrive registered</td>
                                <td ng-cloak>{{ userBackupSummaryServer.userWithOutDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
                                <td class="text-left" ng-cloak>No. of servers for whom at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummaryServer.userWithFirstBkpCompleted }}</td>
                            </tr>
                            <?php if( $data['reportProductType'] != 'office'){ ?>
                                <tr class="text-center">
                                    <td class="text-center" ng-cloak>5.</td>
                                    <td class="text-left" ng-cloak>No. of servers whose agents had a heartbeat in the last <span class="heartbeatServer"></span> days</td>
                                    <td ng-cloak>{{ userBackupSummaryServer.noOfUsersHeardCount }}</td>
                                </tr>
                            <?php } ?>
                            <tr class="text-center">
                                <?php if( $data['reportProductType'] != 'office'){ ?>
                                    <td class="text-center" ng-cloak>6.</td>
                                <?php } else { ?>
                                    <td class="text-center" ng-cloak>5.</td>
                                <?php } ?>
                                <td class="text-left notForOfficeServer" ng-cloak>No. of servers which have been protected in the last <span class="protectedServer"></span> days</td>
                                <td class="text-left forOfficeServer" ng-cloak>No. of servers which have been protected in the last <span class="protectedServer"></span> days</td>
                                <td ng-cloak>{{ userBackupSummaryServer.noOfUsersProtected }}</td>
                            </tr>
                            </tbody></table>
                        </div>
                        <div class="h4 noBackupErrorServer text-center" style="display: none">No details found</div>
                    </div>
                </div>
                    <!--report ends-->			
		    <!--server dps report end-->
		    </div>

	    </div>
</div>
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<div id="overlayTextDelegated"><center><h2 style="color:white;margin-top:20%;">Loading.....</h2></center></div>
    <?php //View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
<script>
$(".searchDeviceNameSharepointDevice").select2({
ajax: {
            url: "<?=DIR?>"+"getAllUnBlockedSites",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultSites,
        templateSelection: selectTemplateSelectionSites,
        placeholder: 'Select sites'
    });

    function selectTemplateResultSites(users){
    	if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionSites(users){

            console.log("gggggggg : "+users.text);
            if(users.text != 'Select user'){
            $.ajax({
            url: "<?=DIR?>"+"devicesSharepoint",
            data: {deviceName: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            console.log("newone111 : "+jData.devicesSharepoint);
            console.log("newone111 : "+jData.devicesSharepoint[0].deviceUUID);
            if (jData.devicesSharepoint){
            var options = "";
/*jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
            });*/
//$('.searchDeviceNameOnedriveDevice').html(options);
	    /*xx start*/
//$("#uuuSharepointDevice").val(users.text);	   
$("#uuuSharepointDevice").val(jData.devicesSharepoint[0].deviceUUID);
        /*xx end*/
        	}else{
//              $('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
//                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
                $("#uuuSharepointDevice").val('');
            }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
            }
        return users.text;
    }
</script>
<script>
$('.restoreDateSharepointDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
        container:'.restoreBuckettSharepointDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateSharepointDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateSharepointDevice').removeAttr('disabled');
        $('#restoreTimeSharepointDevice').removeAttr('disabled');
    } else {
        $('#restoreDateSharepointDevice').attr('disabled', true); //disable input
        $('#restoreTimeSharepointDevice').attr('disabled', true);
    }
});


$("#switchinplaceSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('required', 'required');
        $('#destinationPathlabelSharepointDevice').removeClass('star');
        $('#destinationPathSharepointDevice').attr('disabled', true);
        $('#browseSharepointDevice').attr('disabled', true);
    } else {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('disabled');
        $('#destinationPathlabelSharepointDevice').addClass('star');
        $('#destinationPathSharepointDevice').attr('required', 'required');
        $('#browseSharepointDevice').removeAttr('disabled');
    }
});

    function searchDiscoveredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchDiscoveredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("discoveredSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }

    function searchConfiguredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchConfiguredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("addedSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }

    //for user management tab start
    var assignUsers = $(".assignUsers").select2({
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    function addAssignUsers(selectedMiniCloudName) {
        assignUsers.val(null).trigger("change");
        var miniClouds = $('.attachedUsersFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsers').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
        assignUsers.val(miniClouds).trigger("change");
    }

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }

    //for user management tab end
    
    //for device management tab starts
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevicesForDeviceList",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Devices'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
    //for device management tab ends
    
    $("#userPolicyMappingPolicyNameUsers0").change(function() {
            console.log("changed");
    });

    function changedPolicy(id) {
	    console.log("changed : "+id);
	    var index = id.replace('userPolicyMappingPolicyNameUsers', '');
	    if(!$('.existingUsers'+index).hasClass("updatedUser")){
		    $('.existingUsers'+index).addClass('updatedUser');
	    }
	    $('.edittUsers').show();
    }

    function changedPolicyServer(id) {
            console.log("changed : "+id);
            var index = id.replace('serverPolicyMappingPolicyNameServer', '');
            if(!$('.existingServers'+index).hasClass("updatedServer")){
                    $('.existingServers'+index).addClass('updatedServer');
            }
            $('.edittServers').show();
    }

    $('.selectSchedulePicker').selectpicker('render');
    $('.selectScheduleEditPicker').selectpicker('render');
    $('.selectDaysPickerEdit').selectpicker('render');
    $('.selectTimeMultiplePickerEdit').selectpicker('render');
    $('.selectTimeSinglePickerEdit').selectpicker('render');
    $('.selectFilterPickerMSP').selectpicker('render');
    $('.selectScheduleEditPickerSB').selectpicker('render');

    var slider = document.getElementById("myRangeSEdit");
var output = document.getElementById("demoSEdit");
//output.innerHTML = slider.value;

slider.oninput = function() {
  output.innerHTML = this.value;
}

	var sliderServer = document.getElementById("myRangeSEditServer");
	var outputServer = document.getElementById("demoSEditServer");
	sliderServer.oninput = function() {
		outputServer.innerHTML = this.value;
	}
</script>
<style>
.fab-wrapper{
display: none!important;
}
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 22px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 3px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
					    <script>
					    var assignUsers = $(".assignUsersMsp").select2({
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultMsp,
        templateSelection: selectTemplateSelectionMsp,
        placeholder: 'Select users'
    });

    function addAssignUsers(selectedMiniCloudName) {
        assignUsers.val(null).trigger("change");
        var miniClouds = $('.attachedUsersFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsersMsp').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
        assignUsers.val(miniClouds).trigger("change");
    }

    function selectTemplateResultMsp(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionMsp(users){
        return users.text;
    }

    function searchedUsers() {
        var input, filter, table, tr, td, i, txtValue, foundMatch = false;
        input = document.getElementById("searchUserInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("userListTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[0];
                if (td) {
                        txtValue = td.title || td.textContent;
                        if(txtValue.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
                // Show a message when no matches are found
                var noResultsMessage = document.getElementById("noResultsMessageUser");
                if (!foundMatch) {
                        noResultsMessage.style.display = "block";
                } else {
                        noResultsMessage.style.display = "none";
                }
	}
	$('.addUserRow').hide();
    }

    function searchedBluvaultDevices() {
        var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
        input = document.getElementById("searchBluvaultInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("devicesListTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
		td1 = tr[i].getElementsByTagName("td")[0];
		td2 = tr[i].getElementsByTagName("td")[1];
                if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
                        //if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
                        if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
		}
		// Show a message when no matches are found
                var noResultsMessage = document.getElementById("noResultsMessageDevice");
                if (!foundMatch) {
                        noResultsMessage.style.display = "block";
                } else {
                        noResultsMessage.style.display = "none";
                }
        }
    }

    function searchedBluvaultServers() {
    	var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
    	input = document.getElementById("searchServerInput");
    	filter = input.value.toUpperCase();
    	table = document.getElementById("serverDevicesListTable");
    	tr = table.getElementsByTagName("tr");
    	for (i = 0; i < tr.length; i++) {
        	// Exclude rows with class names "addServerRow" and "addServerBtnRow"
        	if (!tr[i].classList.contains("addServerRow") && !tr[i].classList.contains("addServerBtnRow")) {
			td1 = tr[i].getElementsByTagName("td")[0];
			td2 = tr[i].getElementsByTagName("td")[1];
            		if (td1 && td2) {
                		txtValue1 = td1.title || td1.textContent;
                        	txtValue2 = td2.title || td2.textContent;
                        	if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                	tr[i].style.display = "";
                                	foundMatch = true;
                        	} else {
                                	tr[i].style.display = "none";
                        	}
            		}
		}
		// Show a message when no matches are found
                var noResultsMessage = document.getElementById("noResultsMessageServer");
                if (!foundMatch) {
                        noResultsMessage.style.display = "block";
                } else {
                        noResultsMessage.style.display = "none";
                }
    	}
    }


    <?php if($data['popup'] == 'visible') { ?>
        $('#changePasswordForFirstloginConsent').modal('show');
    <?php } ?>

    $('#addUser').on('hidden.bs.modal', function () {
        $('.uncreatedUsers').hide();
        $('#uncreatedDump').hide();
	document.getElementById("uncreatedDumpStatement").innerHTML = "";
    });					

    function myFunctionMBS(){
	document.getElementById("switcherrorS").innerHTML = "";
        if(isNaN($('#nwFromClientToPGMBS').val())){
                if($('#nwFromClientToPGMBS').val() !='UNLIMITED')  {
                    document.getElementById("switcherrorS").innerHTML = "Input can be any integer";
                    document.getElementById("switchwarningS").innerHTML = "";
                }
        }
        var inp = $('#nwFromClientToPGMBS').val();
        var unit = $('#networkThrottlingUnitS').val();
        if(unit == 'kbps'){
                var convertedVal = inp/1000;
        }
        if(unit == 'mbps'){
                var convertedVal = inp;
        }
        if(unit == 'gbps'){
                var convertedVal = inp*1000;
        }
        if(convertedVal > 10000){
                document.getElementById("switcherrorS").innerHTML = "Input value should be upto 10 Gbps";
        }
    }

    $("#switchNwFromClientToPGMBS").click(function(){
        if ($(this).is(':checked')) {
        	$('#nwFromClientToPGMBS').removeAttr('disabled','disabled'); //enable input
        	$('#nwFromClientToPGMBS').val('4');
        	$('#networkThrottlingUnitS').removeAttr("disabled","disabled");
        } else {
        	$('#nwFromClientToPGMBS').attr('disabled', true); //disable input
        	$('#nwFromClientToPGMBS').val('UNLIMITED');
        	$('#networkThrottlingUnitS').attr("disabled","disabled");
        	$('.networkThrottlingUnitS').find('option[value="mbps"]').prop("selected",true);
        }
    });

    $('#schedulesTypeS1').on('change', function(){
            var type = $('#schedulesTypeS1').val();
            if(type == 'weekly'){
                    $('.selectDaysPickerEdit').show();
                    $('.selectTimeSinglePickerEdit').show();
                    $('.selectTimeMultiplePickerEdit').hide();
            }else{
                    $('.selectDaysPickerEdit').hide();
                    $('.selectTimeSinglePickerEdit').hide();
                    $('.selectTimeMultiplePickerEdit').show();
            }
    });

    function myFunctionMBSServer(){
        document.getElementById("switcherrorSServer").innerHTML = "";
        if(isNaN($('#nwFromClientToPGMBSServer').val())){
                if($('#nwFromClientToPGMBSServer').val() !='UNLIMITED')  {
                    document.getElementById("switcherrorSServer").innerHTML = "Input can be any integer";
                    document.getElementById("switchwarningSServer").innerHTML = "";
                }
        }
        var inp = $('#nwFromClientToPGMBSServer').val();
        var unit = $('#networkThrottlingUnitSServer').val();
        if(unit == 'kbps'){
                var convertedVal = inp/1000;
        }
        if(unit == 'mbps'){
                var convertedVal = inp;
        }
        if(unit == 'gbps'){
                var convertedVal = inp*1000;
        }
        if(convertedVal > 10000){
                document.getElementById("switcherrorSServer").innerHTML = "Input value should be upto 10 Gbps";
        }
    }
    
    $("#switchNwFromClientToPGMBSServer").click(function(){
        if ($(this).is(':checked')) {
                $('#nwFromClientToPGMBSServer').removeAttr('disabled','disabled'); //enable input
                $('#nwFromClientToPGMBSServer').val('4');
                $('#networkThrottlingUnitSServer').removeAttr("disabled","disabled");
        } else {
                $('#nwFromClientToPGMBSServer').attr('disabled', true); //disable input
                $('#nwFromClientToPGMBSServer').val('UNLIMITED');
                $('#networkThrottlingUnitSServer').attr("disabled","disabled");
                $('.networkThrottlingUnitSServer').find('option[value="mbps"]').prop("selected",true);
        }
    });

    $('#schedulesTypeS1Server').on('change', function(){
            var type = $('#schedulesTypeS1Server').val();
            if(type == 'weekly'){
                    $('.selectDaysPickerEditServer').show();
                    $('.selectTimeSinglePickerEditServer').show();
                    $('.selectTimeMultiplePickerEditServer').hide();
            }else{
                    $('.selectDaysPickerEditServer').hide();
                    $('.selectTimeSinglePickerEditServer').hide();
                    $('.selectTimeMultiplePickerEditServer').show();
            }
    });

    $("#closeQuotaManager").click(function() {
	$('#quotaManager').modal('hide');
	location.reload();
    });

    $("#preScanCommandEnabledServerEdit").click(function(){
        if ($(this).is(':checked')) {
                document.getElementById('continueOnPreScanServerEdit').checked=true;
		$('#preScanCommandServerEdit').attr('required', 'required');
		$('#preScanCommandServerEdit').removeAttr('disabled');
		$('#continueOnPreScanServerEdit').removeAttr('disabled');
        } else {
            document.getElementById('continueOnPreScanServerEdit').checked=false;
	    $('#preScanCommandServerEdit').removeAttr('required', 'required');
	    $('#preScanCommandServerEdit').attr('disabled', 'disabled');
	    $('#continueOnPreScanServerEdit').attr('disabled', 'disabled');
        }
    });

    $("#preBackupCommandEnabledServerEdit").click(function(){
        if ($(this).is(':checked')) {
                document.getElementById('continueOnPreBkpServerEdit').checked=true;
		$('#preBackupCommandServerEdit').attr('required', 'required');
		$('#preBackupCommandServerEdit').removeAttr('disabled');
		$('#continueOnPreBkpServerEdit').removeAttr('disabled');

        } else {
            document.getElementById('continueOnPreBkpServerEdit').checked=false;
	    $('#preBackupCommandServerEdit').removeAttr('required', 'required');
	    $('#preBackupCommandServerEdit').attr('disabled', 'disabled');
	    $('#continueOnPreBkpServerEdit').attr('disabled', 'disabled');
        }
    });

    $("#postBackupCommandEnabledServerEdit").click(function(){
        if ($(this).is(':checked')) {
                document.getElementById('continueOnPostBkpServerEdit').checked=true;
		$('#postBackupCommandServerEdit').attr('required', 'required');
		$('#postBackupCommandServerEdit').removeAttr('disabled');
		$('#continueOnPostBkpServerEdit').removeAttr('disabled');
        } else {
            document.getElementById('continueOnPostBkpServerEdit').checked=false;
	    $('#postBackupCommandServerEdit').removeAttr('required', 'required');
	    $('#postBackupCommandServerEdit').attr('disabled', 'disabled');
	    $('#continueOnPostBkpServerEdit').attr('disabled', 'disabled');
        }
    });


$( ".toggle-serverPasswordphraseServer" ).mousedown(function() {
	$("#serverPasswordServer").attr("type", "text");
	$(this).toggleClass("fa-eye-slash fa-eye");
    });

    $( ".toggle-serverPasswordphraseServer" ).mouseup(function() {
	$("#serverPasswordServer").attr("type", "password");
	$(this).toggleClass("fa-eye fa-eye-slash");
    });

    function toggleSelectAllMspServer(control) {
        var allOptionIsSelected = (control.val() || []).indexOf("all") > -1;
        function valuesOf(elements) {
                return $.map(elements, function(element) {
                        return element.value;
                });
        }
            if (control.data('allOptionIsSelected') != allOptionIsSelected) {
                if (allOptionIsSelected) {
                    control.selectpicker('val', 'all');
                } else {
                    control.selectpicker('val', []);
                }
            } else {
                if (allOptionIsSelected && control.val().length != control.find('option').length) {
                    control.selectpicker('val', valuesOf(control.find('option:selected[value!=all]')));
                    allOptionIsSelected = false;
                } else if (!allOptionIsSelected && control.val().length == control.find('option').length - 1) {
                    control.selectpicker('val', 'all');
                    allOptionIsSelected = true;
                }
            }
        control.data('allOptionIsSelected', allOptionIsSelected);
        if($('#searchPolicyNameServerBackup').val() == ''){
//                toastr.error('Please select atleast on policy.', {allowHtml: true});
                return;
        }
    }
    $('#searchPolicyNameServerBackup').selectpicker().change(function(){toggleSelectAllMspServer($(this));}).trigger('change');

    $( ".toggle-passwordphraseReset" ).mousedown(function() {
  $("#rePassword").attr("type", "text");
$(this).toggleClass("fa-eye-slash fa-eye");
});

$( ".toggle-passwordphraseReset" ).mouseup(function() {
  $("#rePassword").attr("type", "password");
$(this).toggleClass("fa-eye fa-eye-slash");
});
    </script>
    <style>
	    .invalid{
	        background-color: gainsboro !important;
	        cursor:not-allowed !important;
	        opacity: 0.4 !important;
	        pointer-events:none !important;
	    }
	    div.dropdown-menu.open{
	        max-height: 314px !important;
	        overflow: hidden;
	    }
	    ul.dropdown-menu.inner{
	        max-height: 260px !important;
	        overflow-y: auto;
	    }
	    .parentLink.active{
		background-color: #F27331!important;
	    }
	    .greyBck{
		background: lightgrey !important;
		color:black;
                text-decoration:none;
		cursor:unset;		
	    }
	    .greySelect{                
                pointer-events:none;
            }
 
    </style>
<style>
	    .invalid{
	        background-color: gainsboro !important;
	        cursor:not-allowed !important;
	        opacity: 0.4 !important;
	        pointer-events:none !important;
	    }
	    div.dropdown-menu.open{
	        max-height: 314px !important;
	        overflow: hidden;
	    }
	    ul.dropdown-menu.inner{
	        max-height: 260px !important;
	        overflow-y: auto;
	    }
	#overlayTextDelegated {
	  position: fixed;
	  display: none;
	  width: 100%;
	  height: 100%;
	  top: 0;
	  left: 0;
	  right: 0;
	  bottom: 0;
	  background-color: rgba(0,0,0,0.5);
	  z-index: 1000000000000;
	  cursor: pointer;
	}
	.expandable-row {
            cursor: pointer;
	}
	.expandable {
            display: none;
        }
        .expanded {
            display: table-row;
	}
	.expandable {
            display: none;
        }
        .expanded {
            display: block;
        }

        .item {
            margin-bottom: 10px;
        }
        .item-title {
            cursor: pointer;
        }
	.expand-icon::before{
	    content: '&#xf055';
            font-weight: bold;
            cursor: pointer;
	}
        .collapse-icon::before {
            content: '&#xf056;';
            font-weight: bold;
            cursor: pointer;
	}
	.item-title.no-children {
            display: none;
        }
	.match{
		pointer-events: none;
		opacity: 0.4;
	}
	.serverDevicesListTable td{
		vertical-align:middle;
	}
	.bootstrap-tagsinput input{
		display:none !important;
	}
	.bootstrap-tagsinput .tag [data-role="remove"]{
		display:none !important;
	}
    </style>
