<?php

use Core\Language;
use \Core\View;
use \Helpers\Url;
use Helpers\Auth;
use Helpers\Form;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div id="licensewarning" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
	<span style="color: white;font-size: 18px;" id="expiryDate"> </span>
	<span class="pull-right" ng-click="closeWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div id="softblockwarning" style="background-color: red;text-align: center;cursor:pointer;display:none;">
        <span style="color: white;font-size: 18px;" id="gotToSoftblockpage" onclick="redirect('gotToSoftblockpage')"> One or more Blocked users waiting for approval.</span>
	<span class="pull-right" ng-click="closeSoftBlockWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div class="container">
    <div class="row">
        <div class="col-lg-12"> 
<!--            <ol class="breadcrumb">
                <li><h3><?=Language::show('backup_dashboard', 'keywords')?></h3></li>
            </ol>-->
<h3>
    <!--<?=Language::show('backup_dashboard', 'keywords')?>-->
    <span style="float:right;font-size: 12px;"><?php if ($data['time']) {?>Last Login Time : <?php echo $data['time']; } ?></span>
</h3>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
	    <span class="currentPage d-none"><?='dashboard'?></span>
	    <span class="isBackupEnabled d-none"><?=$data['isBackupEnabled']?></span>
	    <span class="isSyncEnabled d-none"><?=$data['isSyncEnabled']?></span>
	    <span class="isOnedriveEnabled d-none"><?=$data['isOnedriveEnabled']?></span>
	    <span class="isExchangeEnabled d-none"><?=$data['isExchangeEnabled']?></span>
            <span class="isSharepointEnabled d-none"><?=$data['isSharepointEnabled']?></span>
	    <span class="forceSessionLogoutAfterChangepassword d-none"><?=$data['forceSessionLogoutAfterChangepassword']?></span>
	    <span class="showAccessCodeOnFirstLogin d-none"><?=$data['showAccessCodeOnFirstLogin']?></span>
	    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills flex-column" style="border: 1px solid #EC6621;border-radius: 10px;">
                        <?php if(Auth::checkCloudPermission('backup')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="backupD" class="nav-link" data-target="#general" aria-controls="general" aria-expanded="true" data-toggle="tab">BluVault</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="syncD" class="nav-link" data-target="#sync" aria-controls="sync" aria-expanded="false" data-toggle="tab">BluSync</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('exchange')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="exchangeD" class="nav-link" data-target="#exchangeTab" aria-controls="exchangeTab" aria-expanded="false" data-toggle="tab" ng-click="changeTab('Exchange')">Microsoft Exchange</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('onedrive')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="onedriveD" class="nav-link" data-target="#odb" aria-controls="odb" aria-expanded="false" data-toggle="tab" ng-click="changeTab('ODB')">OneDrive for Business</a></li>
                        <?php } ?>
			<?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="sharepointD" class="nav-link" data-target="#sharepointTab" aria-controls="sharepointTab" aria-expanded="false" data-toggle="tab" ng-click="changeTab('Sharepoint')">SharePoint Online</a></li>
                        <?php } ?>                  
                    </ul>
            <?php } ?>
	    <?php if(!isMobile()){ ?>
		    <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
			<?php if(Auth::checkCloudPermission('backup') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="backupD" class="nav-link" data-target="#general" aria-controls="general" role="tab" data-toggle="tab" ng-click="changeTab('backup')">BluVault</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="syncD" class="nav-link" data-target="#sync" aria-controls="sync" role="tab" data-toggle="tab">BluSync</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="exchangeD" class="nav-link" data-target="#exchangeTab" aria-controls="exchangeTab" role="tab" data-toggle="tab" ng-click="changeTab('Exchange')">Microsoft Exchange</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="onedriveD" class="nav-link" data-target="#odb" aria-controls="odb" role="tab" data-toggle="tab" ng-click="changeTab('ODB')">OneDrive for Business</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sharepoint') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="sharepointD" class="nav-link" data-target="#sharepointTab" aria-controls="sharepointTab" role="tab" data-toggle="tab" ng-click="changeTab('Sharepoint')">SharePoint Online</a></li>
                        <?php } ?>                        
		    </ul>
            <?php } ?>
</br>
<!--modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningbackups">
                <div class="modal-dialog">
                    <div class="modal-content">
			<span><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <div class="panel-heading col-lg-12">
                                <h4 class="currentBackup" style="display:none;">Currently Running Backups
                                    <div class="col-lg-5 pull-right">
                                    <center>
                                        <form ng-submit="searchCurrentlyRunningBackups(search.term)">
                                        <span id="search_img" class="fa fa-search fa-x" style="color: #b2b2b2;"></span>
                                        <input name="searchOutlook" type="text" class="pull-right form-control" ng-model="search.term" placeholder="Enter user name or asset name or 'all' and hit enter to search" style="padding: 6px 24px !important;"/>
                                        </form>
                                    </center>
                                    </div>
                                </h4>
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="table-responsive currentBackupTableExpanded">
                            </hr>
                            <table id="CurrentBackuptable" class="table table-bordered currentBackuptable" style="display: none;">
                                <thead>
                                <tr>
                                <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                <th class="text-center active">
                                        <input type="checkbox" class="select-all checkbox" name="select-all"/>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Asset Name', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                    <th class="text-center clickAble" ng-click="currentBackupSortType = 'backupType'; sortReverse = !sortReverse">
				    	<?=Language::show('Backup Type', 'keywords')?>
					<span ng-show="currentBackupSortType == 'backupType' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'backupType' && sortReverse" class="fa fa-caret-down"></span>
					&nbsp;
					<select class="form-control backupType" style="width: 30% !important;display:inherit !important;">
					    <option value="" selected>All</option>
                                            <option value="INCR">INCR</option>
                                            <option value="FULL">Full</option>                                            
                                        </select>
				    </th>
				    <th class="text-center clickAble statusCol" ng-click="currentBackupSortType = 'status'; sortReverse = !sortReverse">
                                        <?=Language::show('Status', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center actionn"><?=Language::show('action', 'keywords')?></th>
                                    <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackupE | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td>
                                        <input type="checkbox" class="select-item checkbox" name="select-item" onclick="newone()" value="{{ value.deviceUUID }}"/>
                                    </td>
                                    <?php } ?>
                                    <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-show="value.backupType == 'INCR'" ng-cloak>Incremental</td>
				    <td ng-show="value.backupType == 'FULL'" ng-cloak>Full</td>
				    <td ng-cloak>{{ value.status }}</td>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td class="actionn">
                                        <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip ripple" id="pause_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                    <?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
                            <div class="row currentBackupnavigate hide" style="display: none;">
                            <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="expandViewNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="expandViewNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="expandViewNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="expandViewNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                            </div>
                            <div class="h4 currentBackupError text-center" style="display: none">No details found for Current Backup</div>
                            <div class="row loadMore" style="display: none;">
                                <div class="col-lg-12 text-center">
                                    <a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                                        <br /><br />
                                </div>
                            </div>

                            <?php if($data['stopPauseAccess'] == 'true'){ ?>
			    <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveBulkEventHubCurrentBackup('pause')" data-toggle="tooltip" data-placement="top" title="Pause Backup" id="bulkpausebackup" class="block btn btn-small btn-danger toolTip disabled" style="margin-right:5px;">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-pause fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <a ng-click="saveBulkEventHubCurrentBackup('stop')" data-toggle="tooltip" data-placement="top" title="Stop Backup" id="bulkstopbackup" class="block btn btn-small btn-danger toolTip disabled">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <?php } ?>
		                </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal ends-->
<!--currently running restores modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningrestores">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
			  <div class="col-lg-10 panel-heading">
                            <h4 class="currentRestore" style="display:none;">
                                Currently Running Restores
                            </h4>
			  </div>
			  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive">
                            </hr>
                        <table id="CurrentRestore" class="table table-bordered currentRestoretable" style="display: none;">
                                <thead>
                                <tr>
				<!--<th class="active text-center">
                                        <input type="checkbox" class="select-all-restore checkbox" name="select-all-restore"/>
				</th>-->
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<!--<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>-->
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center actionRestore"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestoreE | orderBy:currentBackupSortType:sortReverse" class="text-center">
					<!--<td>
        					<input type="checkbox" class="select-item-restore checkbox" name="select-item-restore" onclick="newRestore()" value="{{ value.deviceUUID }}"/>
                                    	</td>-->
					<td title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:50}}{{value.userName.length > 50 ? '...' : ''}}</td>
					<td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:50}}{{value.deviceName.length > 50 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:50}}{{value.restoreFolder.length > 50 ? '...' : ''}}]</span></td>
					<td title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName  | limitTo:50 }}{{value.restoreByUserName.length > 50 ? '...' : ''}}</td>
					<td title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName }}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:50}}{{value.destFolder.length > 50 ? '...' : ''}}]</span></td>
					<!--<td ng-show="!value.restoreInitiatedBy" ng-cloak> - </td>
					<td ng-show="value.restoreInitiatedBy" ng-cloak>{{ value.restoreInitiatedBy }}</td>-->
					<td ng-cloak>{{ value.startTime }}</td>
					<td ng-show="value.uploadPercent == '-'"> - </td>
                                    	<td ng-show="value.uploadPercent != '-'">
                                        	<div title="{{value.uploadPercent | number:0}}%" class="progress">
							<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        	</div>
                                    	</td>
                                    	<td class="actionRestore">						
						<a ng-click="stopRestore(value.userName, value.deviceUUID, value.batchId, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
						<span class="fa-stack">
						  <i class="fa fa-circle fa-stack-2x"></i>
						  <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
						</span>
						</a>
					</td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<div class="row currentRestorenavigate" style="display: none;">
<div class="col-lg-12 text-center">
<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
<a class="btn btn-primary first" title="First" ng-click="expandViewRestoreNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
<a class="btn btn-primary previous" title="Previous" ng-click="expandViewRestoreNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
<a class="btn btn-primary next" title="Next" ng-click="expandViewRestoreNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
<a class="btn btn-primary last" title="Last" ng-click="expandViewRestoreNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
</div>
</div>
                <div class="h4 currentRestoreError text-center" style="display: none">No details found for Current Restore</div>
                <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
<!--                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, '')">Load More ...</a>-->
<a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
<a ng-click="stopBulkRestore()" id="bulkStopRestore" class="block btn btn-small btn-danger toolTip disabled" data-toggle="tooltip" data-placement="top" title="Stop Restore"><span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                        </span></a>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--currently running restores modal ends-->
<div class="tab-content">
<div role="tabpanel" class="tab-pane" id="general">
    <?php if(Auth::checkCloudPermission('backup') == true){ ?>
            <?php if($data['isAdmin'] == 'true') { ?>
            <div class="bluvaultSection">
            <div class="row dashboard">   
		<?php if(flipUsersTile == false){ ?>
                    <?php if(activeUsers == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeBackupUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statistics.noOfBackupUsersAllowed }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-users"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Blocked Users</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-users"></i>
                                <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfBlockedBackupUsers }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(activeUsers == true){?> frontU <?php }else{ ?> backU <?php } ?>" onclick="flipUser()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-users"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Active Users</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-users"></i>
                                            <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeBackupUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statistics.noOfBackupUsersAllowed }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(activeUsers == true){?> backU <?php }else{ ?> frontU <?php } ?>" onclick="flipbackUser()" >
                                <div class="panel panel-default no-box-shadow widget-danger fold">
                                    <div class="background">
                                        <i class="fa fa-users"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                    	<a>Blocked Users</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-users"></i>
                                        <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfBlockedBackupUsers }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <?php if(flipDevicesTile == false){ ?>
                    <?php if(activeDevices == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('devices')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-desktop"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Assets</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-desktop"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.devicesConnected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Blocked Assets</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-desktop"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfBlockedDevices }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(activeDevices == true){?> frontD <?php }else{ ?> backD <?php } ?>" onclick="flipDevice()" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                    <div class="background">
                                        <i class="fa fa-desktop"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Active Assets</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-desktop"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.devicesConnected }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(activeDevices == true){?> backD <?php }else{ ?> frontD <?php } ?>" onclick="flipbackDevice()" >
                                <div class="panel panel-default no-box-shadow widget-danger fold">
                                    <div class="background">
                                        <i class="fa fa-desktop"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Blocked Assets</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-desktop"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfBlockedDevices }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                    <?php if(flipTotalCompletedBackups == false){ ?>
                    <?php if(totalCompletedBackups == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a style="font-size: 11px;">Active assets with Full Backups Completed</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeDevicesWithFullBackupsCompleted }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-database"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a style="font-size: 11px;">Active Users with Full Backups Completed</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-database"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeUsersWithFullBackupsCompleted }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(totalCompletedBackups == true){?> front <?php }else{ ?> back <?php } ?>" onclick="flip()" >
                                <div class="panel panel-default no-box-shadow widget-primary fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a style="font-size: 11px;">Active assets with Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-database"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeDevicesWithFullBackupsCompleted }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(totalCompletedBackups == true){?> back <?php }else{ ?> front <?php } ?>" onclick="flipback()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a style="font-size: 11px;">Active Users with Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-database"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeUsersWithFullBackupsCompleted }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
		<?php } ?>                    
		<!--Users with Systems not protected start -->
		<!-- new start-->
		<?php if($data['flipNotProtectedTile'] == false){ ?>
                    <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('systemsNotProtected')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-warning">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Assets not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfDevicesNotProtected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('usersNotProtected')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users without any assets protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                            </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){?> frontNP <?php }else{ ?> backNP <?php } ?>" onclick="flipNP()" ondblclick="redirect('systemsNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-warning fold">
                                        <div class="background">
                                                <i class="fa fa-exclamation-triangle"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <a>Assets not protected</a>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                                <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfDevicesNotProtected }}</span></a>
                                        </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'usersWithSystemsNotProtected'){?> frontNP <?php }else{ ?> backNP <?php } ?>" onclick="flipbackNP()" ondblclick="redirect('usersNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users without any assets protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
		<!-- new end-->
		<!--Users with Systems not protected ends -->
            </div>
	    <div class="row">
<?php
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'no';
}
if($data['Hosted'] == 'false' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['superAdmin'] == 'superAdmin'){
$view = 'yes';
}
?>
<?php if($view == 'no'){?>
			    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
<?php } else { ?>
                <?php if(flipTotalActualStorageUtilized == false){ ?>
                    <?php if(totalActualStorageUtilized == false){ ?>
                        <?php if($data['hideCompressedSize'] == true){ ?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
                        <?php } else { ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statistics.totalStorageUtilized }}</span></p>
                                                <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statistics.totalCompressedSizeInPercentage }}</span></p>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                                <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                	 </div>
                                </div>
                        </div>
                        <?php } ?>
                    <?php }else{ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                <?php if($data['hideCompressedSize'] == false){?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> frontDB <?php }else{ ?> backDB <?php } ?>" onclick="flip1()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                        <i class="fa fa-hdd-o"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> backDB <?php }else{ ?> frontDB <?php } ?>" onclick="flipback1()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                        <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statistics.totalStorageUtilized }}</span></p>
                                        <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statistics.totalCompressedSizeInPercentage }}</span></p>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                        <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> frontDB <?php }else{ ?> backDB <?php } ?>" onclick="flip1()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> backDB <?php }else{ ?> frontDB <?php } ?>" onclick="flipback1()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Data Backed up</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statistics.totalStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
	    <?php } } ?>
<?php } ?>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-cog"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Currently Running Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-cog"></i>
                            <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statistics.currentlyRunningBackupCount }}</a>
                        </div>
                    </div>
		</div>
		<div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('restoreByDate')" style="cursor:pointer;" <?php } ?>>
               	<div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-history"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <!--<p style="color: #fff;">Completed restores<span class="pull-right" ng-cloak>{{ statistics.restoresDone }}</span></p>
                                <p style="color: #fff;">Avg. restores per user<span class="pull-right" ng-cloak>{{ statistics.avgRestorePerUser }}</span></p>-->
				<a>Completed restores</a>
                            </div>
                            <!--<div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">-->
			    <div class="panel-body widget widget-body">
                                <i class="fa fa-history"></i>
				<a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statistics.restoresDone }}</a>
                            </div>
                       </div>
               </div>
               <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('usersWithoutDevices')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Users without active assets</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statistics.userWithOutDevices }}</a>
                        </div>
                    </div>
               </div>
            </div>
            <?php if($data['rwDetectionEnabled'] == 'true'){?>
            <div class="row">
               <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('unusualActivityHistoryForAll')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-primary">
                            <div class="background">
                                <i class="fa fa-exclamation-circle"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Unusual Activity Detection</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                 <!--<i class="fa fa-exclamation-circle"></i>-->
                                <a class="pull-right d-none" style="font-size: 23px;font-weight:600;"><span ng-cloak>{{ statistics.noOfUnusualDataAlerts }}</span></a>
                                <a style="font-size: 10px;margin-left:0px;">Active Alerts in Last 7 Days</a>
                            </div>
                        </div>
                    </div>
               </div>
            <?php } ?>
            </div>
<?php } ?>
            <div class="row">
<?php if($data['showCurrentlyRunningReports'] == true){?>		    
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showDeviceHeartbeatReport'] == true || $data['showUserBackupSummary'] == true || $data['showUserBackupSummary'] == true){?>
<div class="col-lg-8">
<?php } else { ?>
                <div class="col-lg-12">
<?php } ?>
<div class="col-lg-12">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="acc" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapse">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackup(1,'backup')" class="aa glyphicon glyphicon-menu-down"></i>
                                        <i class="bb d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupText" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapse" class="panel-collapse collapse">
			<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentBackup(1,'backup')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
			<i class="glyphicon glyphicon-resize-full" ng-click="expandView(1, '', '','backup')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
			<br>
                        <div class="table-responsive currentBackupDiv" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentBackup" class="table table-bordered currentBackup" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Asset Name', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
				  <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                  <th class="text-center"><?=Language::show('action', 'keywords')?></th>
				  <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center" ng-show="$index<50">
                                    <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
				    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td>
                                        <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>

                                    </td>
				    <?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandBackupStatement" style="display:none;"><a href="javascript:;" ng-click="expandView(1, '', '','backup')" style="cursor:pointer;">Expand</a> to view complete list of currently running backups.</span><p>
                <div class="h4 currentBackupError text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running restores start-->
<div class="col-lg-12">
<div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accrestore" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapserestore">
                                <h3 class="panel-title">Currently Running Restores 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentRestore(1,'backup')" class="aarestore glyphicon glyphicon-menu-down"></i>
                                        <i class="bbrestore d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
		      <p class="currentRestoreText" style="margin-left: 10px;">Expand to view currently running restores</p>
                      <div id="collapserestore" class="panel-collapse collapse">
		      <i class="glyphicon glyphicon-refresh" ng-click="updateCurrentRestore(1,'backup')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
		      <i class="glyphicon glyphicon-resize-full" ng-click="expandViewRestore(1,'backup')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
		      <br>
                        <div class="table-responsive currentRestoreDiv" style="overflow-y: scroll;height: 200px; display:none;">


                        <table id="CurrentRestore" class="table table-bordered currentRestore" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
				<!--<th class="text-center clickAble d-none" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>-->
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                    <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestore | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:20}}{{value.restoreFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:20}}{{value.restoreByUserName.length > 20 ? '...' : ''}}</td>
				    <td title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:20}}{{value.restoreByDeviceName.length > 20 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:20}}{{value.destFolder.length > 20 ? '...' : ''}}]</span></td>
				    <!--<td class="d-none" ng-show="!value.restoreInitiatedBy" ng-cloak> - </td>
				    <td class="d-none" ng-show="value.restoreInitiatedBy" ng-cloak>{{ value.restoreInitiatedBy }}</td>-->
				    <td ng-cloak>{{ value.startTime }}</td>
				    <td ng-show="value.uploadPercent == '-'"> - </td>					
                                    <td ng-show="value.uploadPercent != '-'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td>
					<a ng-click="stopRestore(value.userName, value.deviceUUID, value.batchId, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandRestoreStatement" style="display:none;"><a href="javascript:;" ng-click="expandViewRestore(1,'backup')" style="cursor:pointer;">Expand</a> to view complete list of currently running restores.</span></p>
                <div class="h4 currentRestoreError text-center" style="display: none">No details found for Current Restores</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running ends-->
                </div>
<?php } ?>	
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showDeviceHeartbeatReport'] == true || $data['showUserBackupSummary'] == true || $data['showUserBackupSummary'] == true){?>
		<?php if($data['showCurrentlyRunningReports'] == true){?>
				<div class="col-lg-4">
		<?php } else { ?>
		<div class="col-lg-12">
		<?php } ?>                
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title" style="color:black;"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
			    <?php if($data['showUserBackupSummary'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupSummary/backup')?>"> Data Protection Scorecard</a></p>
                            <?php } ?>
                            <?php if($data['showBackupOverview'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/overview/backup')?>"> Backup Overview </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <?php if($data['showBackupHistory'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupHistory/backup')?>"> Backup History </a></p>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/failedBackup/backup')?>"> Failed Backups History</a></p>
                            <?php } ?>
			    <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/incompleteBackup/backup')?>"> Incomplete Backups Report</a></p>
                            <?php } ?>
                            <?php if($data['showSystemsWithoutBackups'] == true){?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/backup')?>"> Assets not protected</a></p>
				<p><a style="font-weight:600!important;" href="<?=Url::basePath('report/usersNoBackup/backup')?>"> Users without any assets protected</a>
                            <?php }else{ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/backup')?>"> Servers without backups</a></p>
                            <?php } ?>
                        <?php } ?>
                        <?php if($data['showRestoreHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/restoreByDate/backup')?>"> Restore History</a></p>
                            <?php } ?>
                            <?php if($data['showStorageUtilizationReport'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/dailyUserBackupOverview/backup')?>"> Storage Utilization Report</a></p>
                            <?php } ?>
                            <?php if($data['showDeviceHeartbeatReport'] == true){?>
                            <p class="AgentHeartBeatReport"><a style="font-weight:600!important;" href="<?=Url::basePath('report/lastAgentServerConnectionDetails/backup')?>"> Asset Heartbeat Report</a></p>
                            <?php } ?>
			    <?php if($data['showBackupCompletionReport'] == true){?>
			    <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/deviceOverview/backup')?>"> Backup Completion Report</a></p>
                            <?php } ?>
			    <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/productOverview/backup')?>"> Product Overview Report</a></p>
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
            
            <?php } ?>
        </div>
	<!--bluvault tab end-->

	<!--odb start-->
        <div role="tabpanel" class="tab-pane" id="odb">
            <?php if($data['isAdmin'] == 'true') { ?>
            <!--<div class="onedriveSection">-->
	    <div class="row dashboard">
<?php if(flipUsersTileOnedrive == false){ ?>
                    <?php if(activeUsersOnedrive == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('users')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfActiveOneDriveUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statisticsOneDrive.noOfOneDriveUsersAllowed }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-users"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Blocked Users</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-users"></i>
                                <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedOneDriveUsers }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(activeUsersOnedrive == true){?> frontUODB <?php }else{ ?> backUODB <?php } ?>" onclick="flipUserODB()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-users"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Active Users</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-users"></i>
                                        <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfActiveOneDriveUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statisticsOneDrive.noOfOneDriveUsersAllowed }}</span></a>
                                    </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(activeUsersOnedrive == true){?> backUODB <?php }else{ ?> frontUODB <?php } ?>" onclick="flipbackUserODB()" >
                           <div class="panel panel-default no-box-shadow widget-danger fold">
                           	<div class="background">
                                	<i class="fa fa-users"></i>
                            	</div>
			    	<div class="panel-heading widget-header">
					<a>Blocked Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                	<i class="fa fa-users"></i>
                                        <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedOneDriveUsers }}</span></a>
                                </div>
                            </div>
                        </div>
		    </div></div>
		    <?php } ?>
                <?php if(flipDevicesTileOnedrive == false){ ?>
                    <?php if(activeDevicesOnedrive == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('devices')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-desktop"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Assets</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-desktop"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.devicesConnected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
		    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('devices')" style="cursor:pointer;" <?php } ?>>
			<div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Blocked Assets</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-desktop"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedDevices }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
               <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(activeDevicesOnedrive == true){?> frontDODB <?php }else{ ?> backDODB <?php } ?>" onclick="flipDeviceODB()" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                    <div class="background">
                                        <i class="fa fa-desktop"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Active Assets</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
					    <i class="fa fa-desktop"></i>
					    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.devicesConnected }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(activeDevicesOnedrive == true){?> backDODB <?php }else{ ?> frontDODB <?php } ?>" onclick="flipbackDeviceODB()" >
                                <div class="panel panel-default no-box-shadow widget-danger fold">
                                    <div class="background">
                                        <i class="fa fa-desktop"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Blocked Assets</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-desktop"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedDevices }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
               <?php } ?>
               <?php if(flipTotalCompletedBackupsOnedrive == false){ ?>
                    <?php if(totalCompletedBackupsOnedrive == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a style="font-size: 11px;">Active Assets with Full Backups Completed</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeDevicesWithFullBackupsCompleted }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-database"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a style="font-size: 11px;">Active Users with Full Backups Completed</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-database"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeUsersWithFullBackupsCompleted }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
               <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(totalCompletedBackupsOnedrive == true){?> frontODB <?php }else{ ?> backODB <?php } ?>" onclick="flipODB()" >
                                <div class="panel panel-default no-box-shadow widget-primary fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a style="font-size: 11px;">Active Assets with Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-database"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeDevicesWithFullBackupsCompleted }}</span></a>
                                    </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalCompletedBackupsOnedrive == true){?> backODB <?php }else{ ?> frontODB <?php } ?>" onclick="flipbackODB()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a style="font-size: 11px;">Active Users with Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-database"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeUsersWithFullBackupsCompleted }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
		<?php } ?>                    
		<!-- new start-->
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('systemsNotProtected')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-warning">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Assets not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfDevicesNotProtected }}</span></a>
                                </div>
                            </div>
                        </div>
		<!-- new end-->
            </div>
	    <div class="row">
<?php
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'no';
}
if($data['Hosted'] == 'false' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['superAdmin'] == 'superAdmin'){
$view = 'yes';
}
?>
<?php if($view == 'no'){?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
<?php } else { ?>
                <?php if(flipTotalActualStorageUtilizedOnedrive == false){ ?>
                    <?php if(totalActualStorageUtilizedOnedrive == false){ ?>
                        <?php if($data['hideCompressedSize'] == true){ ?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
                        <?php } else { ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                            <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                            <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                        </div>
                                </div>
                        </div>
                        <?php } ?>
                    <?php }else{ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                <?php if($data['hideCompressedSize'] == false){?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilizedOnedrive == true){?> frontDBODB <?php }else{ ?> backDBODB <?php } ?>" onclick="flip1ODB()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilizedOnedrive == true){?> backDBODB <?php }else{ ?> frontDBODB <?php } ?>" onclick="flipback1ODB()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                    <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                    <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilizedOnedrive == true){?> frontDBODB <?php }else{ ?> backDBODB <?php } ?>" onclick="flip1ODB()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilizedOnedrive == true){?> backDBODB <?php }else{ ?> frontDBODB <?php } ?>" onclick="flipback1ODB()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Data Backed up</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
		<?php } ?>
<?php } ?>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-cog"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Currently Running Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-cog"></i>
                            <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.currentlyRunningBackupCount }}</a>
                        </div>
                    </div>
		</div>
		<div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('restoreByDate')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-history"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <!--<p style="color: #fff;">Completed restores<span class="pull-right" ng-cloak>{{ statisticsOneDrive.restoresDone }}</span></p>
                                <p style="color: #fff;">Avg. restores per user<span class="pull-right" ng-cloak>{{ statisticsOneDrive.avgRestorePerUser }}</span></p>-->
				<a>Completed restores</a>
                            </div>
                            <!--<div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">-->
			    <div class="panel-body widget widget-body">
                                <i class="fa fa-history"></i>
				<a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.restoresDone }}</a>
                            </div>
                        </div>
                    </div>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('usersWithoutDevices')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Users without active assets</a>
                             </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statisticsOneDrive.userWithOutDevices }}</a>
                        </div>
                    </div>
                </div>

            </div>
	    <?php } ?>
            <div class="row">
<?php if($data['showCurrentlyRunningReports'] == true){?>		    
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
<div class="col-lg-8">
<?php } else { ?>
                <div class="col-lg-12">
<?php } ?>
<div class="col-lg-12">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accOnedrive" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapseOnedrive">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackup(1,'ONEDRIVE')" class="aaOnedrive glyphicon glyphicon-menu-down"></i>
                                        <i class="bbOnedrive d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupTextOnedrive" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapseOnedrive" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentBackup(1,'ONEDRIVE')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandView(1, '', '','ONEDRIVE')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentBackupDivOnedrive" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentBackupOnedrive" class="table table-bordered currentBackupOnedrive" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Asset Name', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center"><?=Language::show('action', 'keywords')?></th>
<?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center" ng-show="$index<50">
                                    <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td>
                                        <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>

                                    </td>
<?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandBackupStatementOnedrive" style="display:none;"><a href="javascript:;" ng-click="expandView(1,'','','ONEDRIVE')" style="cursor:pointer;">Expand</a> to view complete list of currently running backups.</span><p>
                <div class="h4 currentBackupErrorOnedrive text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running restores start-->
<div class="col-lg-12">
<div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accrestoreOnedrive" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapserestoreOnedrive">
                                <h3 class="panel-title">Currently Running Restores 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentRestore(1,'ONEDRIVE')" class="aarestoreOnedrive glyphicon glyphicon-menu-down"></i>
                                        <i class="bbrestoreOnedrive d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
<p class="currentRestoreTextOnedrive" style="margin-left: 10px;">Expand to view currently running restores</p>
                      <div id="collapserestoreOnedrive" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentRestore(1,'ONEDRIVE')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandViewRestore(1,'ONEDRIVE')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentRestoreDivOnedrive" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentRestoreOnedrive" class="table table-bordered currentRestoreOnedrive" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<!--<th class="text-center clickAble d-none" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>-->
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestore | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:20}}{{value.restoreFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:20 }}{{value.restoreByUserName.length > 20 ? '...' : ''}}</td>
				    <td title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:20 }}{{value.restoreByDeviceName.length > 20 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:20}}{{value.destFolder.length > 20 ? '...' : ''}}]</span></td>
				    <!--<td class="d-none" ng-show="!value.restoreInitiatedBy" ng-cloak> - </td>
				    <td class="d-none" ng-show="value.restoreInitiatedBy" ng-cloak>{{ value.restoreInitiatedBy | limitTo:20 }}{{value.restoreInitiatedBy.length > 20 ? '...' : ''}}</td>-->
				    <td ng-cloak>{{ value.startTime }}</td>
				    <td ng-show="value.uploadPercent == '-'"> - </td>
                                    <td ng-show="value.uploadPercent != '-'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td>
                                        <a ng-click="stopRestore(value.userName, value.deviceUUID, value.batchId, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandRestoreStatementOnedrive" style="display:none;"><a href="javascript:;" ng-click="expandViewRestore(1,'ONEDRIVE')" style="cursor:pointer;">Expand</a> to view complete list of currently running restores.</span></p>
                <div class="h4 currentRestoreErrorOnedrive text-center" style="display: none">No details found for Current Restores</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running ends-->
                </div>
	<?php } ?>
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
		<?php if($data['showCurrentlyRunningReports'] == true){?>
		<div class="col-lg-4">
		<?php } else { ?>
		<div class="col-lg-12">
		<?php } ?>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title" style="color:black;"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
			    <?php if($data['showUserBackupSummary'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupSummary/onedrive')?>"> Data Protection Scorecard</a></p>
                            <?php } ?>
                            <?php if($data['showBackupOverview'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/overview/onedrive')?>"> Backup Overview </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <?php if($data['showBackupHistory'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupHistory/onedrive')?>"> Backup History </a></p>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/failedBackup/onedrive')?>"> Failed Backups History</a></p>
                            <?php } ?>
			    <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/incompleteBackup/onedrive')?>"> Incomplete Backups Report</a></p>
                            <?php } ?>
                            <?php if($data['showSystemsWithoutBackups'] == true){?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/onedrive')?>"> Assets not protected</a></p>
				<p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/usersNoBackup/onedrive')?>"> Users without any systems protected</a>
                            <?php }else{ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/onedrive')?>"> Servers without backups</a></p>
                            <?php } ?>
                        <?php } ?>
                        <?php if($data['showRestoreHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/restoreByDate/onedrive')?>"> Restore History</a></p>
                            <?php } ?>
                            <?php if($data['showStorageUtilizationReport'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/dailyUserBackupOverview/onedrive')?>"> Storage Utilization Report</a></p>
			    <?php } ?>                            
			    <?php if($data['oneDriveArchivingEnabled'] == 'true'){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/capacityManagementReport/onedrive')?>"> Capacity Savings</a></p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
	</div>
<!--</div>-->
	<!--odb end-->

	<!--exchange start-->
        <div role="tabpanel" class="tab-pane" id="exchange">
            <?php if($data['isAdmin'] == 'true') { ?>
            <!--<div class="exchangeSection">-->
	    <div class="row dashboard">
<?php if(flipUsersTileExchange == false){ ?>
                    <?php if(activeUsersExchange == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('users')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfActiveExchangeUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statisticsOneDrive.noOfExchangeUsersAllowed }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-users"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Blocked Users</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-users"></i>
                                <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedExchangeUsers }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectExchange('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(activeUsersExchange == true){?> frontUExchange <?php }else{ ?> backUExchange <?php } ?>" onclick="flipUserExchange()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-users"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Active Users</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-users"></i>
                                        <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfActiveExchangeUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statisticsOneDrive.noOfExchangeUsersAllowed }}</span></a>
                                    </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(activeUsersExchange == true){?> backUExchange <?php }else{ ?> frontUExchange <?php } ?>" onclick="flipbackUserExchange()" >
                           <div class="panel panel-default no-box-shadow widget-danger fold">
                           	<div class="background">
                                	<i class="fa fa-users"></i>
                            	</div>
			    	<div class="panel-heading widget-header">
					<a>Blocked Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                	<i class="fa fa-users"></i>
                                        <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedExchangeUsers }}</span></a>
                                </div>
                            </div>
                        </div>
		    </div></div>
		    <?php } ?>
                <?php if(flipDevicesTileExchange == false){ ?>
                    <?php if(activeDevicesExchange == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('devices')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-desktop"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Assets</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-desktop"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.devicesConnected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
		    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('devices')" style="cursor:pointer;" <?php } ?>>
			<div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Blocked Assets</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-desktop"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedDevices }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
               <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectExchange('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(activeDevicesExchange == true){?> frontDExchange <?php }else{ ?> backDExchange <?php } ?>" onclick="flipDeviceExchange()" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                    <div class="background">
                                        <i class="fa fa-desktop"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Active Assets</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
					    <i class="fa fa-desktop"></i>
					    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.devicesConnected }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(activeDevicesExchange == true){?> backDExchange <?php }else{ ?> frontDExchange <?php } ?>" onclick="flipbackDeviceExchange()" >
                                <div class="panel panel-default no-box-shadow widget-danger fold">
                                    <div class="background">
                                        <i class="fa fa-desktop"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Blocked Assets</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-desktop"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedDevices }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
               <?php } ?>
               <?php if(flipTotalCompletedBackupsExchange == false){ ?>
                    <?php if(totalCompletedBackupsExchange == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a style="font-size: 11px;">Active Assets with Full Backups Completed</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeDevicesWithFullBackupsCompleted }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-database"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a style="font-size: 11px;">Active Users with Full Backups Completed</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-database"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeUsersWithFullBackupsCompleted }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
               <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectExchange('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(totalCompletedBackupsExchange == true){?> frontExchange <?php }else{ ?> backExchange <?php } ?>" onclick="flipExchange()" >
                                <div class="panel panel-default no-box-shadow widget-primary fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a style="font-size: 11px;">Active Assets with Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-database"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeDevicesWithFullBackupsCompleted }}</span></a>
                                    </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalCompletedBackupsExchange == true){?> backExchange <?php }else{ ?> frontExchange <?php } ?>" onclick="flipbackExchange()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a style="font-size: 11px;">Active Users with Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-database"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeUsersWithFullBackupsCompleted }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
		<?php } ?>                    
		<!-- new start-->
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('systemsNotProtected')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-warning">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Assets not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfDevicesNotProtected }}</span></a>
                                </div>
                            </div>
                        </div>
		<!-- new end-->
            </div>
	    <div class="row">
<?php
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'no';
}
if($data['Hosted'] == 'false' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['superAdmin'] == 'superAdmin'){
$view = 'yes';
}
?>
<?php if($view == 'no'){?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
<?php } else { ?>
                <?php if(flipTotalActualStorageUtilizedExchange == false){ ?>
                    <?php if(totalActualStorageUtilizedExchange == false){ ?>
                        <?php if($data['hideCompressedSize'] == true){ ?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
                        <?php } else { ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectExchange('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                            <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                            <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                        </div>
                                </div>
                        </div>
                        <?php } ?>
                    <?php }else{ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectExchange('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                <?php if($data['hideCompressedSize'] == false){?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectExchange('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilizedExchange == true){?> frontDBExchange <?php }else{ ?> backDBExchange <?php } ?>" onclick="flip1Exchange()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilizedExchange == true){?> backDBExchange <?php }else{ ?> frontDBExchange <?php } ?>" onclick="flipback1Exchange()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                    <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                    <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectExchange('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilizedExchange == true){?> frontDBExchange <?php }else{ ?> backDBExchange <?php } ?>" onclick="flip1Exchange()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilizedExchange == true){?> backDBExchange <?php }else{ ?> frontDBExchange <?php } ?>" onclick="flipback1Exchange()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Data Backed up</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
		<?php } ?>
<?php } ?>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-cog"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Currently Running Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-cog"></i>
                            <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.currentlyRunningBackupCount }}</a>
                        </div>
                    </div>
		</div>
		<div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectExchange('restoreByDate')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-history"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <!--<p style="color: #fff;">Completed restores<span class="pull-right" ng-cloak>{{ statisticsOneDrive.restoresDone }}</span></p>
                                <p style="color: #fff;">Avg. restores per user<span class="pull-right" ng-cloak>{{ statisticsOneDrive.avgRestorePerUser }}</span></p>-->
				<a>Completed restores</a>
                            </div>
                            <!--<div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">-->
			    <div class="panel-body widget widget-body">
                                <i class="fa fa-history"></i>
				<a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.restoresDone }}</a>
                            </div>
                        </div>
                    </div>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectExchange('usersWithoutDevices')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Users without active assets</a>
                             </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statisticsOneDrive.userWithOutDevices }}</a>
                        </div>
                    </div>
                </div>

            </div>
	    <?php } ?>
            <div class="row">
<?php if($data['showCurrentlyRunningReports'] == true){?>		    
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
<div class="col-lg-8">
<?php } else { ?>
                <div class="col-lg-12">
<?php } ?>
<div class="col-lg-12">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accExchange" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapseExchange">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackup(1,'EXCHANGE')" class="aaExchange glyphicon glyphicon-menu-down"></i>
                                        <i class="bbExchange d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupTextExchange" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapseExchange" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentBackup(1,'EXCHANGE')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandView(1, '', '','EXCHANGE')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentBackupDivExchange" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentBackupExchange" class="table table-bordered currentBackupExchange" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Asset Name', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center"><?=Language::show('action', 'keywords')?></th>
<?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center" ng-show="$index<50">
                                    <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td>
                                        <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>

                                    </td>
<?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandBackupStatementExchange" style="display:none;"><a href="javascript:;" ng-click="expandView(1,'','','EXCHANGE')" style="cursor:pointer;">Expand</a> to view complete list of currently running backups.</span><p>
                <div class="h4 currentBackupErrorExchange text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running restores start-->
<div class="col-lg-12">
<div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accrestoreExchange" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapserestoreExchange">
                                <h3 class="panel-title">Currently Running Restores 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentRestore(1,'EXCHANGE')" class="aarestoreExchange glyphicon glyphicon-menu-down"></i>
                                        <i class="bbrestoreExchange d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
<p class="currentRestoreTextExchange" style="margin-left: 10px;">Expand to view currently running restores</p>
                      <div id="collapserestoreExchange" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentRestore(1,'EXCHANGE')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandViewRestore(1,'EXCHANGE')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentRestoreDivExchange" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentRestoreExchange" class="table table-bordered currentRestoreExchange" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>Asset Name [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<!--<th class="text-center clickAble d-none" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>-->
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestore | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:20}}{{value.restoreFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:20 }}{{value.restoreByUserName.length > 20 ? '...' : ''}}</td>
				    <td title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:20 }}{{value.restoreByDeviceName.length > 20 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:20}}{{value.destFolder.length > 20 ? '...' : ''}}]</span></td>
				    <!--<td class="d-none" ng-show="!value.restoreInitiatedBy" ng-cloak> - </td>
				    <td class="d-none" ng-show="value.restoreInitiatedBy" ng-cloak>{{ value.restoreInitiatedBy | limitTo:20 }}{{value.restoreInitiatedBy.length > 20 ? '...' : ''}}</td>-->
				    <td ng-cloak>{{ value.startTime }}</td>
				    <td ng-show="value.uploadPercent == '-'"> - </td>
                                    <td ng-show="value.uploadPercent != '-'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td>
                                        <a ng-click="stopRestore(value.userName, value.deviceUUID, value.batchId, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandRestoreStatementExchange" style="display:none;"><a href="javascript:;" ng-click="expandViewRestore(1,'EXCHANGE')" style="cursor:pointer;">Expand</a> to view complete list of currently running restores.</span></p>
                <div class="h4 currentRestoreErrorExchange text-center" style="display: none">No details found for Current Restores</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running ends-->
                </div>
	<?php } ?>
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
		<?php if($data['showCurrentlyRunningReports'] == true){?>
		<div class="col-lg-4">
		<?php } else { ?>
		<div class="col-lg-12">
		<?php } ?>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title" style="color:black;"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
			    <?php if($data['showUserBackupSummary'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupSummary/exchange')?>"> Data Protection Scorecard</a></p>
                            <?php } ?>
                            <?php if($data['showBackupOverview'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/overview/exchange')?>"> Backup Overview </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <?php if($data['showBackupHistory'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupHistory/exchange')?>"> Backup History </a></p>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/failedBackup/exchange')?>"> Failed Backups History</a></p>
                            <?php } ?>
			    <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/incompleteBackup/exchange')?>"> Incomplete Backups Report</a></p>
                            <?php } ?>
                            <?php if($data['showSystemsWithoutBackups'] == true){?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/exchange')?>"> Assets not protected</a></p>
				<p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/usersNoBackup/exchange')?>"> Users without any systems protected</a>
                            <?php }else{ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/exchange')?>"> Servers without backups</a></p>
                            <?php } ?>
                        <?php } ?>
                        <?php if($data['showRestoreHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/restoreByDate/exchange')?>"> Restore History</a></p>
                            <?php } ?>
                            <?php if($data['showStorageUtilizationReport'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/dailyUserBackupOverview/exchange')?>"> Storage Utilization Report</a></p>
			    <?php } ?>
			    <?php if($data['mailArchivingEnabled'] == 'true'){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/capacityManagementReport/exchange')?>"> Capacity Savings</a></p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
	</div>
<!--</div>-->
        <!--exchange end-->

        <!--sharepoint start-->
        <div role="tabpanel" class="tab-pane" id="sharepointTab">
            <?php if($data['isAdmin'] == 'true') { ?>
            <div class="sharepointSection">
	    	<div class="row dashboard">
			<div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('devices')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a style="font-size: 14px;">Active Sites</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfActiveSPSites }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statisticsOneDrive.noOfSPSitesAllowed }}</span></a>
                                </div>
                            </div>
                        </div>
		<!--blocked tile start-->
			<div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('devices')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-danger">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a style="font-size: 14px;">Blocked Sites</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfBlockedSPSites }}</span></a>
                                </div>
                            </div>
                        </div>
<!--blocked tile end-->
                        <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a style="font-size: 14px;">Active Sites with Full Backups Completed</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeDevicesWithFullBackupsCompleted }}</span></a>
                                </div>
                            </div>
                        </div>
		<!-- new start-->
		<?php if($data['flipNotProtectedTile'] == false){ ?>
                    <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){ ?>
                        <div class="col-lg-3 hide" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('systemsNotProtected')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-warning">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfDevicesNotProtected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3 hide" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('usersNotProtected')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users without any systems protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3 hide" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){?> frontNPODB <?php }else{ ?> backNPODB <?php } ?>" onclick="flipNPODB()" ondblclick="redirectSharepoint('systemsNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-warning fold">
                                        <div class="background">
                                                <i class="fa fa-exclamation-triangle"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <a>Systems not protected</a>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                                <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfDevicesNotProtected }}</span></a>
                                        </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'usersWithSystemsNotProtected'){?> frontNPODB <?php }else{ ?> backNPODB <?php } ?>" onclick="flipbackNPODB()" ondblclick="redirectSharepoint('usersNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users without any systems protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfUsersProtected }}</span></a>
                                </div>
                             </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
		<!-- new end-->
            </div>
	    <div class="row">
<?php
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'no';
}
if($data['Hosted'] == 'false' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'ParaBlu'){
        $view = 'no';
}
if($data['MSP'] == 'true' && $data['Hosted'] == 'true' && $data['Storage_Provider'] == 'Others'){
        $view = 'yes';
}
if($data['superAdmin'] == 'superAdmin'){
$view = 'yes';
}
?>
<?php if($view == 'no'){?>
                            <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
<?php } else { ?>
                <?php if(flipTotalActualStorageUtilizedSharepoint == false){ ?>
                    <?php if(totalActualStorageUtilizedSharepoint == false){ ?>
                        <?php if($data['hideCompressedSize'] == true){ ?>
                            <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
                        <?php } else { ?>
                        <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectSharepoint('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                            <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                            <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                        </div>
                                </div>
                        </div>
                        <?php } ?>
                    <?php }else{ ?>
                        <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectSharepoint('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                <?php if($data['hideCompressedSize'] == false){?>
                <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectSharepoint('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilizedSharepoint == true){?> frontDBSharepoint <?php }else{ ?> backDBSharepoint <?php } ?>" onclick="flip1Sharepoint()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilizedSharepoint == true){?> backDBSharepoint <?php }else{ ?> frontDBSharepoint <?php } ?>" onclick="flipback1Sharepoint()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                    <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                    <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectSharepoint('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilizedSharepoint == true){?> frontDBSharepoint <?php }else{ ?> backDBSharepoint <?php } ?>" onclick="flip1Sharepoint()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilizedSharepoint == true){?> backDBSharepoint <?php }else{ ?> frontDBSharepoint <?php } ?>" onclick="flipback1Sharepoint()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Data Backed up</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
		<?php } ?>
<?php } ?>
                <div class="col-lg-4" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-cog"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Currently Running Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-cog"></i>
                            <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.currentlyRunningBackupCount }}</a>
                        </div>
                    </div>
		</div>
		<div class="col-lg-4" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectSharepoint('restoreByDate')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-history"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <!--<p style="color: #fff;">Completed restores<span class="pull-right" ng-cloak>{{ statisticsOneDrive.restoresDone }}</span></p>
                                <p style="color: #fff;">Avg. restores per user<span class="pull-right" ng-cloak>{{ statisticsOneDrive.avgRestorePerUser }}</span></p>-->
				<a>Completed restores</a>
                            </div>
                            <!--<div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">-->
			    <div class="panel-body widget widget-body">
                                <i class="fa fa-history"></i>
				<a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.restoresDone }}</a>
                            </div>
                        </div>
                    </div>
                <div class="col-lg-3 hide" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectSharepoint('usersWithoutDevices')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Users without active devices</a>
                             </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statisticsOneDrive.userWithOutDevices }}</a>
                        </div>
                    </div>
                </div>

            </div>
	    </div>
	    <?php } ?>
<!--modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningbackupsSharepoint">
                <div class="modal-dialog">
                    <div class="modal-content">
			<span><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>
                        <div class="modal-header" style="margin-bottom: -10px;">                            
                            <div class="panel-heading col-lg-12">
                                <h4 class="currentBackupSharepoint" style="display:none;">Currently Running Backups
                                    <div class="col-lg-5 pull-right">
                                    <center>
                                        <form ng-submit="searchCurrentlyRunningBackupsSharepoint(search.term)">
                                        <span id="search_img" class="fa fa-search fa-x" style="color: #b2b2b2;"></span>
                                        <input name="searchOutlook" type="text" class="pull-right form-control" ng-model="search.term" placeholder="Enter site name or 'all' and hit enter to search" style="padding: 6px 24px !important;" />
                                        </form>
                                    </center>
                                    </div>
                                </h4>
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="table-responsive currentBackupSharepointTableExpanded" >
                            </hr>
                            <table id="CurrentBackupSharepoint" class="table table-bordered currentBackupSharepointtable" style="display: none;">
                                <thead>
                                <tr>
                                <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                <th class="text-center active">
                                        <input type="checkbox" class="select-all-sharepoint checkbox" name="select-all-sharepoint"/>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble hide" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Site Name', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                    <th class="text-center clickAble" ng-click="currentBackupSortType = 'backupType'; sortReverse = !sortReverse">
					 <?=Language::show('Backup Type', 'keywords')?>
					 <span ng-show="currentBackupSortType == 'backupType' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'backupType' && sortReverse" class="fa fa-caret-down"></span>
					&nbsp;
					<select class="form-control backupTypeSharepoint" style="width: 30% !important;display:inherit !important;">
					    <option value="" selected>All</option>
                                            <option value="INCR">INCR</option>
                                            <option value="FULL">Full</option>                                            
                                        </select>
				    </th>
				    <th class="text-center clickAble statusCol" ng-click="currentBackupSortType = 'status'; sortReverse = !sortReverse">
                                        <?=Language::show('Status', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center actionnSharepoint"><?=Language::show('action', 'keywords')?></th>
                                    <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackupE | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td>
                                        <input type="checkbox" class="select-item-sharepoint checkbox" name="select-item-sharepoint" onclick="newoneSharepoint()" value="{{ value.deviceUUID }}"/>
                                    </td>
                                    <?php } ?>
                                    <td class="hide" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-show="value.backupType == 'INCR'" ng-cloak>Incremental</td>
				    <td ng-show="value.backupType == 'FULL'" ng-cloak>Full</td>
				    <td ng-cloak>{{ value.status }}</td>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td class="actionnSharepoint">
                                        <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveEventHubCurrentBackupSharepoint(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip ripple" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackupSharepoint(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                    <?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
                            <div class="row currentBackupSharepointnavigate hide" style="display: none;">
                            <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="expandViewSharepointNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="expandViewSharepointNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="expandViewSharepointNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="expandViewSharepointNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                            </div>
                            <div class="h4 currentBackupErrorSharepoint text-center" style="display: none">No details found for Current Backup</div>
                            <div class="row loadMore" style="display: none;">
                                <div class="col-lg-12 text-center">
                                    <a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                                        <br /><br />
                                </div>
                            </div>
                            
                            <?php if($data['stopPauseAccess'] == 'true'){ ?>
			    <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveBulkEventHubCurrentBackupSharepoint('pause')" id="bulkpausebackupSharepoint" class="block btn btn-small btn-danger toolTip disabled" style="margin-right:5px;" data-toggle="tooltip" data-placement="top" title="Pause Backup">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-pause fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <a ng-click="saveBulkEventHubCurrentBackupSharepoint('stop')" id="bulkstopbackupSharepoint" class="block btn btn-small btn-danger toolTip disabled" data-toggle="tooltip" data-placement="top" title="Stop Backup">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>                            
                            <?php } ?>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal ends-->
<!--currently running restores modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningrestoresSharepoint">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">      
			  <div class="col-lg-10 panel-heading">
                            <h4 class="currentRestoreSharepoint" style="display:none;">
                                Currently Running Restores
                            </h4>
			  </div>
			  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>				
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive">
                            </hr>
                        <table id="CurrentRestoreSharepoint" class="table table-bordered currentRestoreSharepointtable" style="display: none;">
                                <thead>
                                <tr>
				  <!--<th class="active">
                                        <input type="checkbox" class="select-all-restore-sharepoint checkbox" name="select-all-restore-sharepoint"/>
				  </th>-->
                                  <th class="text-center clickAble hide" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                            <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>Site [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>Site [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <!--<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>-->
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
				  </th>
                                  <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                  <th class="text-center actionRestoreSharepoint"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestoreE | orderBy:currentBackupSortType:sortReverse" class="text-center">
				<!--<td>
        				<input type="checkbox" class="select-item-restore-sharepoint checkbox" name="select-item-restore-sharepoint" onclick="newRestoreSharepoint()" value="{{ value.deviceUUID }}"/>
                                </td>-->
				<td class="hide" title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:50}}{{value.userName.length > 50 ? '...' : ''}}</td>
				<td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:50}}{{value.deviceName.length > 50 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:50}}{{value.restoreFolder.length > 50 ? '...' : ''}}]</span></td>
				<td title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:50}}{{value.restoreByUserName.length > 50 ? '...' : ''}}</td>
				<td title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:50}}{{value.restoreByDeviceName.length > 50 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:50}}{{value.destFolder.length > 50 ? '...' : ''}}]</span></td>
				<!--<td ng-show="!value.restoreInitiatedBy" ng-cloak> - </td>
				<td ng-show="value.restoreInitiatedBy" ng-cloak>{{ value.restoreInitiatedBy }}</td>-->
				<td ng-cloak>{{ value.startTime }}</td>
				<td ng-show="value.uploadPercent == '-'"> - </td>					
                                <td ng-show="value.uploadPercent != '-'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                </td>
                                <td class="actionRestoreSharepoint">
     					<a ng-click="stopRestoreSharepoint(value.userName, value.deviceUUID, value.batchId, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
</td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<div class="row currentRestoreSharepointnavigate" style="display: none;">
<div class="col-lg-12 text-center">
<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
<a class="btn btn-primary first" title="First" ng-click="expandViewRestoreNavigateSharepoint(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
<a class="btn btn-primary previous" title="Previous" ng-click="expandViewRestoreNavigateSharepoint(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
<a class="btn btn-primary next" title="Next" ng-click="expandViewRestoreNavigateSharepoint(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
<a class="btn btn-primary last" title="Last" ng-click="expandViewRestoreNavigateSharepoint(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
</div>
</div>
                <div class="h4 currentRestoreErrorSharepoint text-center" style="display: none">No details found for Current Restore</div>
                <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
				<a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                            <br/><br/>
                        </div>
                    </div>
<a ng-click="stopBulkRestoreSharepoint()" id="bulkStopRestoreSharepoint" class="block btn btn-small btn-danger toolTip disabled" data-toggle="tooltip" data-placement="top" title="Stop Restore"><span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                        </span></a>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--currently running restores modal ends-->

            <div class="row">
<?php if($data['showCurrentlyRunningReports'] == true){?>		    
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
<div class="col-lg-8">
<?php } else { ?>
                <div class="col-lg-12">
<?php } ?>
<div class="col-lg-12">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accSharepoint" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapseSharepoint">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackupSharepoint(1,'SHAREPOINT')" class="aaSharepoint glyphicon glyphicon-menu-down"></i>
                                        <i class="bbSharepoint d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupTextSharepoint" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapseSharepoint" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentBackupSharepoint(1,'SHAREPOINT')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandViewSharepoint(1, '', '','SHAREPOINT')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentBackupDivSharepoint" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentBackupSharepoint" class="table table-bordered currentBackupSharepoint" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble hide" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Site Name', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center"><?=Language::show('action', 'keywords')?></th>
<?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center" ng-show="$index<50">
                                    <td class="hide" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td>
                                        <a ng-class="{'invalid': value.status === 'SCANNING' || value.status === 'QUEUED'}" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>

                                    </td>
<?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandBackupStatementSharepoint" style="display:none;"><a href="javascript:;" ng-click="expandViewSharepoint(1, '', '','SHAREPOINT')" style="cursor:pointer;">Expand</a> to view complete list of currently running backups.</span><p>
                <div class="h4 currentBackupErrorSharepoint text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running restores start-->
<div class="col-lg-12">
<div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accrestoreSharepoint" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapserestoreSharepoint">
                                <h3 class="panel-title">Currently Running Restores 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentRestoreSharepoint(1,'SHAREPOINT')" class="aarestoreSharepoint glyphicon glyphicon-menu-down"></i>
                                        <i class="bbrestoreSharepoint d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
<p class="currentRestoreTextSharepoint" style="margin-left: 10px;">Expand to view currently running restores</p>
                      <div id="collapserestoreSharepoint" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentRestoreSharepoint(1,'SHAREPOINT')" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandViewRestoreSharepoint(1,'SHAREPOINT')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentRestoreDivSharepoint" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentRestoreSharepoint" class="table table-bordered currentRestoreSharepoint" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble hide" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>Site [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>Site [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<!--<th class="text-center clickAble d-none" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>-->
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestore | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td class="hide" title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:20}}{{value.restoreFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:20 }}{{value.restoreByUserName.length > 20 ? '...' : ''}}</td>
				    <td title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:20 }}{{value.restoreByDeviceName.length > 20 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:20}}{{value.destFolder.length > 20 ? '...' : ''}}]</span></td>
				    <!--<td class="d-none" ng-show="!value.restoreInitiatedBy" ng-cloak> - </td>
				    <td class="d-none" ng-show="value.restoreInitiatedBy" ng-cloak>{{ value.restoreInitiatedBy | limitTo:20 }}{{value.restoreInitiatedBy.length > 20 ? '...' : ''}}</td>-->
				    <td ng-cloak>{{ value.startTime }}</td>
				    <td ng-show="value.uploadPercent == '-'"> - </td>					
                                    <td ng-show="value.uploadPercent != '-'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td>
                                        <a ng-click="stopRestoreSharepoint(value.userName, value.deviceUUID, value.batchId, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandRestoreStatementSharepoint" style="display:none;"><a href="javascript:;" ng-click="expandViewRestoreSharepoint(1,'SHAREPOINT')" style="cursor:pointer;">Expand</a> to view complete list of currently running restores.</span></p>
                <div class="h4 currentRestoreErrorSharepoint text-center" style="display: none">No details found for Current Restores</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running ends-->
                </div>
	<?php } ?>
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
		<?php if($data['showCurrentlyRunningReports'] == true){?>
		<div class="col-lg-4">
		<?php } else { ?>
		<div class="col-lg-12">
		<?php } ?>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title" style="color:black;"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
			    <?php if($data['showUserBackupSummary'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupSummary/sharepoint')?>"> Data Protection Scorecard</a></p>
                            <?php } ?>
                            <?php if($data['showBackupOverview'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/overview/sharepoint')?>"> Backup Overview </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <?php if($data['showBackupHistory'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupHistory/sharepoint')?>"> Backup History </a></p>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/failedBackup/sharepoint')?>"> Failed Backups History</a></p>
                            <?php } ?>
			    <?php if($data['showFailedBackupHistory'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/incompleteBackup/sharepoint')?>"> Incomplete Backups Report</a></p>
                            <?php } ?>
                            <?php if($data['showSystemsWithoutBackups'] == true){?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/sharepoint')?>"> Systems not protected</a></p>
				<p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/usersNoBackup/sharepoint')?>"> Users without any systems protected</a>
                            <?php }else{ ?>
                                <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/sharepoint')?>"> Servers without backups</a></p>
                            <?php } ?>
                        <?php } ?>
                        <?php if($data['showRestoreHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/restoreByDate/sharepoint')?>"> Restore History</a></p>
                            <?php } ?>
                            <?php if($data['showStorageUtilizationReport'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/dailyUserBackupOverview/sharepoint')?>"> Storage Utilization Report</a></p>
			    <?php } ?>
			    <?php if($data['spArchivingEnabled'] == 'true'){?>
			    <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/capacityManagementReport/sharepoint')?>"> Capacity Savings</a></p>
			    <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
        </div>
	<!--sharepoint end-->
        
        <!--sync start-->
        <div role="tabpanel" class="tab-pane <?php echo $data['activeTabS'];?>" id="sync">
        <?php
            /*    $percent = $data['cloudDetails']->{'space-used'}/$data['cloudDetails']->{'license'}->{'max-storage'};
                $percent_friendly = number_format( $percent * 100, 2 );
                if($percent_friendly > 25 && $percent_friendly <= 50) {
                    $color = '#10cfbd';
                    $class = 'success';
                }elseif($percent_friendly > 50 && $percent_friendly <= 75) {
                    $color = '#f8d053';
                    $class = 'warning';
                }elseif($percent_friendly > 75 && $percent_friendly <= 100) {
                    $color = '#6d5cae';
                    $class = 'danger';
                }else{
                    $color = '#2095f2';
                    $class = 'primary';
                }*/
                ?>
                <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                <div class="row">
                    <!-- start -->
                        <div class="col-lg-6" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsSync.noOfSyncUsersConnected }}</span><span style="font-size: 20px;"> active out of </span><span ng-cloak style="font-size: 20px;">{{ statisticsSync.liscenseElement.totalNoOfUsers}}</span></a>
                                </div>
                            </div>
                        </div>                     
                    <div class="col-lg-6" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('miniClouds')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-cloud"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>MiniClouds</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-cloud"></i>
                                <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span ng-cloak style="font-size: 20px;">{{statisticsSync.noOfMyClouds}}</span><span style="font-size: 20px;"> used out of </span><span ng-cloak style="font-size: 20px;">{{statisticsSync.liscenseElement.noOfMiniCloudsAllowed}}</span></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">            
                    <!-- end -->
                    <div class="col-lg-6" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('syncCLoudUsage')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-warning">
                            <div class="background">
                                <i class="fa fa-hdd-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Storage Details</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-hdd-o"></i>
                                <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{statisticsSync.spaceUsed}} {{unit}}</span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6" block-ui="myBlockUI">
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-clock-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Parablu Installation valid Until</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-clock-o"></i>
                                <a class="pull-right" ng-cloak style="font-size: 20px;margin-top: -20px;">{{statisticsSync.liscenseElement.validityPeriod}}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 d-none">
                        <div class="panel">
                            <div class="panel-heading">
                            </div>
                            <div class="panel-body">
                                <div class="row" style="padding-right: 15px; padding-left: 15px;">
                                    <table class="table table-bordered text-center d-none">
                                        <tbody>
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title" style="color:black;"> Reports </h3>
                                </div>
                                <hr/>
                                <div class="panel-body">
                                    <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/syncCLoudUsage')?>"> BluSync Overview Summary</a></p>
				    <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/minicloudActivity')?>"> MiniCloud Activity History</a></p>
                                    <!--<p><a href="<?=Url::basePath('report/download/syncOverviewReport')?>"> Sync User Activity History in Excel format</a></p>-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
    </div>
        <!--sync end-->
    </div> <!--tab-content ends-->
	<!--modal start-->
            <div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> userBackupSummaryModal" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <div class="panel-heading">
                                <h4>User Backup Summary</h4>
<!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="col-lg-12" style="border: 1px solid #F27331;padding: 20px;border-radius: 10px;">
                                <span class="reportProductType hide" id="reportProductType"></span>
                                <form ng-submit="updateUserBackupSummary(search.noOfDays,search.searchPolicyName)">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <label for="searchPolicyName">Policy Name</label>
                                            <select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name' disabled>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?>
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="noOfDays">User Backup Summary for</label>
                                            <input type="number" id="noOfDays" value="30" min="1" placeholder="Number Of Days" data-parsley-trigger="change" disabled> <label style="margin-top:12px;">days </label>
                                        </div>					
                                    </div>
                                </form>
                            </div>
                    <br/>
                    <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                    <br/>
                    <div class="table-responsive" style="overflow-x: unset !important;">
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
			    </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Users</td>
                                <td ng-cloak>{{ userBackupSummary.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
                                <td class="text-left notForOffice" ng-cloak>Users with at least one device assigned</td>
				<td class="text-left forOffice" ng-cloak>Users with at least one OneDrive assigned</td>
                                <td ng-cloak>{{ userBackupSummary.userWithDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>
                                <td class="text-left" ng-cloak>No. of users for whom at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummary.userWithFirstBkpCompleted }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users without device registered</td>
				<td class="text-left forOffice" ng-cloak>No. of users without OneDrive registered</td>
                                <td ng-cloak>{{ userBackupSummary.userWithOutDevices }}</td>
                            </tr>
                            <tr class="text-center notForOffice">
                                <td class="text-center" ng-cloak>5.</td>
                                <td class="text-left" ng-cloak>No. of users whose devices had a heartbeat to the server in the last <span class="heartbeat"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersHeardCount }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center notForOffice" ng-cloak>6.</td>
                                <td class="text-center forOffice" ng-cloak>5.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users whose devices have been protected in the last <span class="protected"></span> days</td>
				<td class="text-left forOffice" ng-cloak>No. of users whose OneDrive have been protected in the last <span class="protected"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersProtected }}</td>
                            </tr>
                            </tbody></table>
                        </div>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal start-->
<?php if($data['popup'] == 'visible') { ?>
<div class="modal fade" id="changePasswordForFirstloginConsent" tabindex="-1" role="dialog" data-keyboard="false" data-backdrop="static" aria-labelledby="myModalLabel">
                <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Change Password Consent</h4>
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            </div>
                            <div class="modal-body">
                                <p>Please change password to proceed further.</p>
                            </div>
                            <div class="modal-footer">
                                <!--<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>-->
                                <a class="btn btn-primary" id="proceedBtn" ng-click="proceedForChangePassword()">Proceed</a>
                            </div>
                        </div>
                </div>
            </div>
<?php } ?>
<!--modal ends-->
<!--modal-->
<?php if($data['popup'] == 'visible') { ?>
            <div class="modal fade" id="changePasswordForFirstlogin" role="dialog" data-keyboard="false" data-backdrop="static">
                <div class="modal-dialog">
                <!-- Modal content-->
                        <div class="modal-content">
                        <?=Form::open(array(
                            		'ng-submit' => 'changePasswordForFirstlogin()',
                            		'method' => 'post',
                            		'id' => 'changePasswordForFirstlogin',
                            		'csrf' => $data['csrf_token'],
                            		'autocomplete' => 'off',
                            		'data-parsley-validate' => true
                        		));
                        ?>
        		<div class="modal-header">
          			<h4 class="modal-title">Change Password</h4>
        		</div>
        		<div class="modal-body">
	                        <div class="form-group">
	                        	<label for="passwordGuest">Password</label>
	                        	<?php if(complexPassword == true) { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } else { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } ?>
                        	</div>
                        	<div class="form-group">
                            		<label for="rePasswordGuest">Re Type Password</label>
					<input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
					<span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphrase"></span>
					<span id="rePasswordError" style="color: #f55753;font-size: 0.9em;"></span>
                        	</div>
				<?php if(multifactorAuthWithAccessCode == true){ ?>
                        	<div class="form-group <?php if($data['showAccessCodeOnFirstLogin'] != '1'){ ?> d-none <?php } ?>">
                                        <label for="accessKey">Enter One Time Access Code sent to the registered Email address - <a href="" id="generateOtpLink" style="cursor:pointer;">Resend One Time Access Code</a></label>
                                        <input type="text" class="form-control" name="accessKey" id="accessKey" placeholder="<?=Language::show('Enter', 'keywords');?> <?=Language::show('One Time Access Code', 'keywords');?>" <?php if($data['showAccessCodeOnFirstLogin'] == '1'){ ?> required <?php } ?> autocomplete="off">
                                </div>
                        	<?php } ?>
				<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
				<!--collapse start-->
				<div class="form-group">
					<a ng-click="requestQR()" href="" style="margin-top:25px;">Request QR Code</a>
                                	<!--<a data-toggle="collapse" href="#qrCollapse" role="button" aria-expanded="false" aria-controls="qrCollapse"><span class="aa">Request QR Code</span><span class="aa hide">Request QR Code</span></a>-->
                            	</div>
				<div class="col-lg-12 collapse" id="qrCollapse" style="border: 1px solid rgb(242, 115, 49);">
					<div class="row" style="margin-bottom:10px;">
                                		<div class="col-lg-8">
                                    			<label for="mailId"><?=Language::show('Email Id', 'keywords');?></label>
                                    			<input type="text" class="form-control" name="mailId" id="mailId" value="<?=$_SESSION['emailId']?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('Email Id', 'keywords');?>" autocomplete="off" style="opacity:0.5;pointer-events:none;">
                                            	</div>
						<div class="col-lg-2">
						    <a type="button" class="btn btn-success" ng-click="requestQR()" style="margin-top:25px;"><?=Language::show('Submit', 'share');?></a>
						</div>
						<div class="col-lg-12">
						    <span id="statussuccess" style="color: #4faf50;font-size: 0.9em;"></span>
						    <span id="statuserror" style="color: #f55753;font-size: 0.9em;"></span>
						</div>
					</div>
                            	</div>
				<!--collapse end-->
				<center class="hide"><div id="img">
                                <img src='<?php echo $qrCodeUrl; ?>' />
                                </div></center>
				<?php } ?>
        		</div>
        		<div class="modal-footer">
          			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
          				<p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan the QR code sent to your Email Id and generate a one-time key.</p>
				<?php } else { ?>
        				<p style="float: left;">Note: Please change password to proceed further.</p>
				<?php } ?>
          			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
                			<a id="changePasswordBtnGuest" ng-bootbox-confirm="<h4>You may use Microsoft or Google Authenticator to set up Multi-Factor Authentication (MFA) using the QR code sent to your Email Id.  If you have not requested for QR code yet, please click Cancel and get QR code from 'Request QR Code' first.</h4>"
                                       ng-bootbox-confirm-action="changePasswordForFirstlogin()"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-primary"> <?=Language::show('save', 'keywords');?></a>
          			<?php } else { ?>
                			<button type="submit" id="changePasswordBtnGuest" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
          			<?php } ?>
        		</div>
        		<?=Form::close();?>
      		</div>
      	</div>
  </div>
  <?php } ?>
<!--modal-->		
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js" type="text/javascript"></script>
<script>
$(".acc").click(function(){
    	$(".aa").toggleClass("d-none");
	$(".bb").toggleClass("d-block");
	$('.currentBackupText').toggleClass('d-none');
});

$(".accOnedrive").click(function(){
        $(".aaOnedrive").toggleClass("d-none");
        $(".bbOnedrive").toggleClass("d-block");
        $('.currentBackupTextOnedrive').toggleClass('d-none');
});

$(".accExchange").click(function(){
        $(".aaExchange").toggleClass("d-none");
        $(".bbExchange").toggleClass("d-block");
        $('.currentBackupTextExchange').toggleClass('d-none');
});

$(".accSharepoint").click(function(){
    	$(".aaSharepoint").toggleClass("d-none");
	$(".bbSharepoint").toggleClass("d-block");
	$('.currentBackupTextSharepoint').toggleClass('d-none');
});

$(".accrestore").click(function(){
    	$(".aarestore").toggleClass("d-none");
	$(".bbrestore").toggleClass("d-block");
	$('.currentRestoreText').toggleClass('d-none');
});

$(".accrestoreOnedrive").click(function(){
        $(".aarestoreOnedrive").toggleClass("d-none");
        $(".bbrestoreOnedrive").toggleClass("d-block");
        $('.currentRestoreTextOnedrive').toggleClass('d-none');
});

$(".accrestoreExchange").click(function(){
        $(".aarestoreExchange").toggleClass("d-none");
        $(".bbrestoreExchange").toggleClass("d-block");
        $('.currentRestoreTextExchange').toggleClass('d-none');
});

$(".accrestoreSharepoint").click(function(){
    	$(".aarestoreSharepoint").toggleClass("d-none");
	$(".bbrestoreSharepoint").toggleClass("d-block");
	$('.currentRestoreTextSharepoint').toggleClass('d-none');
});

function redirect(type){
	switch (type) {
	    case 'users':
		window.location.href = "<?=Url::basePath('users')?>";
		break;
	    case 'devices':
		localStorage.setItem("selectedTab","backupT");
                window.location.href = "<?=Url::basePath('backup/manageAssets')?>";
		break;
	    case 'userBackupHistory':
		window.location.href = "<?=Url::basePath('report/userBackupHistory/backup')?>";
		break;
	    <?php if($data['showStorageUtilizationReport'] == true){?>			
	    case 'dailyUserBackupOverview':
		window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview/backup')?>";
		break;
	    <?php } ?>
	    case 'restoreByDate':
		window.location.href = "<?=Url::basePath('report/restoreByDate/backup')?>";
		break;
	    case 'miniClouds':
		window.location.href = "<?=Url::basePath('miniClouds')?>";
		break;
	    case 'syncCLoudUsage':
		window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
		break;
	    case 'usersWithoutDevices':
		window.location.href = "<?=Url::basePath('report/usersWithoutDevices/backup')?>";
		break;
	    case 'systemsNotProtected':
		window.location.href = "<?=Url::basePath('report/noBackup/backup')?>";
		break;
	    case 'usersNotProtected':
                window.location.href = "<?=Url::basePath('report/usersNoBackup/backup')?>";
                break;
	    case 'unusualActivityHistoryForAll':
		window.location.href = "<?=Url::basePath('unusualActivityHistoryForAll')?>";
                break;
	    case 'gotToSoftblockpage':
                window.location.href = "<?=Url::basePath('users/usersBulkBlockDelete/softBlockDiv')?>";
                break;
	}
}

function redirectOnedrive(type){
        switch (type) {
            case 'users':
                window.location.href = "<?=Url::basePath('users')?>";
                break;
            case 'devices':
                localStorage.setItem("selectedTab","onedriveT");
                window.location.href = "<?=Url::basePath('backup/manageAssets')?>";
                break;
            case 'userBackupHistory':
                window.location.href = "<?=Url::basePath('report/userBackupHistory/onedrive')?>";
                break;
            <?php if($data['showStorageUtilizationReport'] == true){?>
            case 'dailyUserBackupOverview':
                window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview/onedrive')?>";
                break;
            <?php } ?>
            case 'restoreByDate':
                window.location.href = "<?=Url::basePath('report/restoreByDate/onedrive')?>";
                break;
            case 'miniClouds':
                window.location.href = "<?=Url::basePath('miniClouds')?>";
                break;
            case 'syncCLoudUsage':
                window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
                break;
            case 'usersWithoutDevices':
                window.location.href = "<?=Url::basePath('report/usersWithoutDevices/onedrive')?>";
                break;
            case 'systemsNotProtected':
                window.location.href = "<?=Url::basePath('report/noBackup/onedrive')?>";
                break;
            case 'usersNotProtected':
                window.location.href = "<?=Url::basePath('report/usersNoBackup/onedrive')?>";
                break;
        }
}

function redirectExchange(type){
        switch (type) {
            case 'users':
                window.location.href = "<?=Url::basePath('users')?>";
                break;
            case 'devices':
                localStorage.setItem("selectedTab","exchangeT");
                window.location.href = "<?=Url::basePath('backup/manageAssets')?>";
                break;
            case 'userBackupHistory':
                window.location.href = "<?=Url::basePath('report/userBackupHistory/exchange')?>";
                break;
            <?php if($data['showStorageUtilizationReport'] == true){?>
            case 'dailyUserBackupOverview':
                window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview/exchange')?>";
                break;
            <?php } ?>
            case 'restoreByDate':
                window.location.href = "<?=Url::basePath('report/restoreByDate/exchange')?>";
                break;
            case 'miniClouds':
                window.location.href = "<?=Url::basePath('miniClouds')?>";
                break;
            case 'syncCLoudUsage':
                window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
                break;
            case 'usersWithoutDevices':
                window.location.href = "<?=Url::basePath('report/usersWithoutDevices/exchange')?>";
                break;
            case 'systemsNotProtected':
                window.location.href = "<?=Url::basePath('report/noBackup/exchange')?>";
                break;
            case 'usersNotProtected':
                window.location.href = "<?=Url::basePath('report/usersNoBackup/exchange')?>";
                break;
        }
}
	
function redirectSharepoint(type){
	switch (type) {
	    case 'users':
		window.location.href = "<?=Url::basePath('users')?>";
		break;
	    case 'devices':
		localStorage.setItem("selectedTab","sharepointT");
                window.location.href = "<?=Url::basePath('backup/manageAssets')?>";
		break;
	    case 'userBackupHistory':
		window.location.href = "<?=Url::basePath('report/userBackupHistory/sharepoint')?>";
		break;
	    <?php if($data['showStorageUtilizationReport'] == true){?>
	    case 'dailyUserBackupOverview':
		window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview/sharepoint')?>";
		break;
	    <?php } ?>
	    case 'restoreByDate':
		window.location.href = "<?=Url::basePath('report/restoreByDate/sharepoint')?>";
		break;
	    case 'miniClouds':
		window.location.href = "<?=Url::basePath('miniClouds')?>";
		break;
	    case 'syncCLoudUsage':
		window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
		break;
	    case 'usersWithoutDevices':
		window.location.href = "<?=Url::basePath('report/usersWithoutDevices/sharepoint')?>";
		break;
	    case 'systemsNotProtected':
		window.location.href = "<?=Url::basePath('report/noBackup/sharepoint')?>";
		break;
	    case 'usersNotProtected':
                window.location.href = "<?=Url::basePath('report/usersNoBackup/sharepoint')?>";
                break;
	}	
}

    //IE doesn't transform-style:preserve-3d.
    //using TweenLite.set() takes care of all vendor-prefixes
TweenLite.set(".cardWrapper", {perspective:800});
TweenLite.set(".card", {transformStyle:"preserve-3d"});
<?php if(flipUsersTile == true){?>
	TweenLite.set(".backU", {rotationY:-180});
<?php } ?>
<?php if(flipUsersTileOnedrive == true){?>       
        TweenLite.set(".backUODB", {rotationY:-180});
<?php } ?>
<?php if(flipUsersTileExchange == true){?>
        TweenLite.set(".backUExchange", {rotationY:-180});
<?php } ?>
<?php if(flipDevicesTile == true){?>
	TweenLite.set(".backD", {rotationY:-180});	
<?php } ?>
<?php if(flipDevicesTileOnedrive == true){?>
        TweenLite.set(".backDODB", {rotationY:-180});
<?php } ?>
<?php if(flipDevicesTileExchange == true){?>
        TweenLite.set(".backDExchange", {rotationY:-180});
<?php } ?>
TweenLite.set(".back", {rotationY:-180});
TweenLite.set(".backODB", {rotationY:-180});
TweenLite.set(".backExchange", {rotationY:-180});
TweenLite.set(".backDB", {rotationY:-180});
TweenLite.set(".backDBODB", {rotationY:-180});
TweenLite.set(".backDBExchange", {rotationY:-180});
TweenLite.set(".backDBSharepoint", {rotationY:-180});
TweenLite.set(".backRe", {rotationY:-180});
TweenLite.set(".backNP", {rotationY:-180});
TweenLite.set(".backNPODB", {rotationY:-180});    
TweenLite.set(".backNPExchange", {rotationY:-180});

<?php if(flipUsersTile == true){?>	
	TweenLite.set([".backU", ".frontU"], {backfaceVisibility:"hidden"});
<?php } ?>
<?php if(flipDevicesTile == true){?>
	TweenLite.set([".backD", ".frontD"], {backfaceVisibility:"hidden"});
<?php } ?>
<?php if(flipUsersTileOnedrive == true){?>
        TweenLite.set([".backUODB", ".frontUODB"], {backfaceVisibility:"hidden"});
<?php } ?>
<?php if(flipUsersTileExchange == true){?>
        TweenLite.set([".backUExchange", ".frontUExchange"], {backfaceVisibility:"hidden"});
<?php } ?>
<?php if(flipDevicesTileOnedrive == true){?>
        TweenLite.set([".backDODB", ".frontDODB"], {backfaceVisibility:"hidden"});
<?php } ?>
<?php if(flipDevicesTileExchange == true){?>
        TweenLite.set([".backDExchange", ".frontDExchange"], {backfaceVisibility:"hidden"});
<?php } ?>
TweenLite.set([".back", ".front"], {backfaceVisibility:"hidden"});
TweenLite.set([".backODB", ".frontODB"], {backfaceVisibility:"hidden"});
TweenLite.set([".backExchange", ".frontExchange"], {backfaceVisibility:"hidden"});
TweenLite.set([".backDB", ".frontDB"], {backfaceVisibility:"hidden"});
TweenLite.set([".backDBODB", ".frontDBODB"], {backfaceVisibility:"hidden"});
TweenLite.set([".backDBExchange", ".frontDBExchange"], {backfaceVisibility:"hidden"});
TweenLite.set([".backDBSharepoint", ".frontDBSharepoint"], {backfaceVisibility:"hidden"});
TweenLite.set([".backRe", ".frontRe"], {backfaceVisibility:"hidden"});
TweenLite.set([".backNP", ".frontNP"], {backfaceVisibility:"hidden"});
TweenLite.set([".backNPODB", ".frontNPODB"], {backfaceVisibility:"hidden"});
TweenLite.set([".backNPExchange", ".frontNPExchange"], {backfaceVisibility:"hidden"});

setTimeout(function(){
	$('.backU').addClass('d-none');
	$('.backD').addClass('d-none');
	$('.backUODB').addClass('d-none');
	$('.backDODB').addClass('d-none');
	$('.backUExchange').addClass('d-none');
        $('.backDExchange').addClass('d-none');
	$('.back').addClass('d-none');
	$('.backODB').addClass('d-none');
	$('.backExchange').addClass('d-none');
	$('.backDB').addClass('d-none');
	$('.backDBODB').addClass('d-none');
	$('.backDBExchange').addClass('d-none');
	$('.backDBSharepoint').addClass('d-none');
	$('.backRe').addClass('d-none');
	$('.backNP').addClass('d-none');
	$('.backNPODB').addClass('d-none');
	$('.backNPExchange').addClass('d-none');
}, 100);

$(".cardWrapper").hover(
  function() {
    TweenLite.to($(this).find(".card"), 1.2, {rotationY:180, ease:Back.easeOut});
  },
  function() {
    TweenLite.to($(this).find(".card"), 1.2, {rotationY:0, ease:Back.easeOut});  
  }
);

//a nice little intro;)
TweenMax.staggerTo($(".card"), 1, {rotationY:-180, repeat:1, yoyo:true}, 0.1);

<?php if(flipUsersTile == true){?>	
<?php if(activeUsers == true){?>
function flipUser() {
    $(".frontU").addClass("d-none");
    $(".backU").removeClass("d-none");
    $(".backU").css("transform","");
    $(".backU").css("backface-visibility","");
}
function flipbackUser() {
    $(".backU").addClass("d-none");
    $(".frontU").removeClass("d-none");
    $(".frontU").css("transform","");
    $(".frontU").css("backface-visibility","");
    }
<?php }else{ ?>
function flipUser() {
    $(".backU").addClass("d-none");
    $(".frontU").removeClass("d-none");
    $(".frontU").css("transform","");
    $(".frontU").css("backface-visibility","");
}
function flipbackUser() {
    $(".frontU").addClass("d-none");
    $(".backU").removeClass("d-none");
    $(".backU").css("transform","");
    $(".backU").css("backface-visibility","");
    }
<?php } ?>
<?php } ?>	

<?php if(flipDevicesTile == true){?>	
<?php if(activeDevices == true){?>
function flipDevice() {
    $(".frontD").addClass("d-none");
    $(".backD").removeClass("d-none");
    $(".backD").css("transform","");
    $(".backD").css("backface-visibility","");
}
function flipbackDevice() {
    $(".backD").addClass("d-none");
    $(".frontD").removeClass("d-none");
    $(".frontD").css("transform","");
    $(".frontD").css("backface-visibility","");
    }
<?php }else{ ?>
function flipDevice() {
    $(".backD").addClass("d-none");
    $(".frontD").removeClass("d-none");
    $(".frontD").css("transform","");
    $(".frontD").css("backface-visibility","");
}
function flipbackDevice() {
    $(".frontD").addClass("d-none");
    $(".backD").removeClass("d-none");
    $(".backD").css("transform","");
    $(".backD").css("backface-visibility","");
    }
<?php } ?>
<?php } ?>	

<?php if(flipUsersTileOnedrive == true){?>	
<?php if(activeUsersOnedrive == true){?>
function flipUserODB() {
    $(".frontUODB").addClass("d-none");
    $(".backUODB").removeClass("d-none");
    $(".backUODB").css("transform","");
    $(".backUODB").css("backface-visibility","");
}
function flipbackUserODB() {
    $(".backUODB").addClass("d-none");
    $(".frontUODB").removeClass("d-none");
    $(".frontUODB").css("transform","");
    $(".frontUODB").css("backface-visibility","");
    }
<?php }else{ ?>
function flipUserODB() {
    $(".backUODB").addClass("d-none");
    $(".frontUODB").removeClass("d-none");
    $(".frontUODB").css("transform","");
    $(".frontUODB").css("backface-visibility","");
}
function flipbackUserODB() {
    $(".frontUODB").addClass("d-none");
    $(".backUODB").removeClass("d-none");
    $(".backUODB").css("transform","");
    $(".backUODB").css("backface-visibility","");
    }
<?php } ?>
<?php } ?>

<?php if(flipUsersTileExchange == true){?>
<?php if(activeUsersExchange == true){?>
function flipUserExchange() {
    $(".frontUExchange").addClass("d-none");
    $(".backUExchange").removeClass("d-none");
    $(".backUExchange").css("transform","");
    $(".backUExchange").css("backface-visibility","");
}
function flipbackUserExchange() {
    $(".backUExchange").addClass("d-none");
    $(".frontUExchange").removeClass("d-none");
    $(".frontUExchange").css("transform","");
    $(".frontUExchange").css("backface-visibility","");
    }
<?php }else{ ?>
function flipUserExchange() {
    $(".backUExchange").addClass("d-none");
    $(".frontUExchange").removeClass("d-none");
    $(".frontUExchange").css("transform","");
    $(".frontUExchange").css("backface-visibility","");
}
function flipbackUserExchange() {
    $(".frontUExchange").addClass("d-none");
    $(".backUExchange").removeClass("d-none");
    $(".backUExchange").css("transform","");
    $(".backUExchange").css("backface-visibility","");
    }
<?php } ?>
<?php } ?>

<?php if(flipDevicesTileOnedrive == true){?>	
<?php if(activeDevicesOnedrive == true){?>
function flipDeviceODB() {
    $(".frontDODB").addClass("d-none");
    $(".backDODB").removeClass("d-none");
    $(".backDODB").css("transform","");
    $(".backDODB").css("backface-visibility","");
}
function flipbackDeviceODB() {
    $(".backDODB").addClass("d-none");
    $(".frontDODB").removeClass("d-none");
    $(".frontDODB").css("transform","");
    $(".frontDODB").css("backface-visibility","");
    }
<?php }else{ ?>
function flipDeviceODB() {
    $(".backDODB").addClass("d-none");
    $(".frontDODB").removeClass("d-none");
    $(".frontDODB").css("transform","");
    $(".frontDODB").css("backface-visibility","");
}
function flipbackDeviceODB() {
    $(".frontDODB").addClass("d-none");
    $(".backDODB").removeClass("d-none");
    $(".backDODB").css("transform","");
    $(".backDODB").css("backface-visibility","");
    }
<?php } ?>
<?php } ?>

<?php if(flipDevicesTileExchange == true){?>
<?php if(activeDevicesExchange == true){?>
function flipDeviceExchange() {
    $(".frontDExchange").addClass("d-none");
    $(".backDExchange").removeClass("d-none");
    $(".backDExchange").css("transform","");
    $(".backDExchange").css("backface-visibility","");
}
function flipbackDeviceExchange() {
    $(".backDExchange").addClass("d-none");
    $(".frontDExchange").removeClass("d-none");
    $(".frontDExchange").css("transform","");
    $(".frontDExchange").css("backface-visibility","");
    }
<?php }else{ ?>
function flipDeviceExchange() {
    $(".backDExchange").addClass("d-none");
    $(".frontDExchange").removeClass("d-none");
    $(".frontDExchange").css("transform","");
    $(".frontDExchange").css("backface-visibility","");
}
function flipbackDeviceExchange() {
    $(".frontDExchange").addClass("d-none");
    $(".backDExchange").removeClass("d-none");
    $(".backDExchange").css("transform","");
    $(".backDExchange").css("backface-visibility","");
    }
<?php } ?>
<?php } ?>

<?php if(totalCompletedBackups == true){?>
function flip() {
    $(".front").addClass("d-none");
    $(".back").removeClass("d-none");
    $(".back").css("transform","");
    $(".back").css("backface-visibility","");
}
function flipback() {
    $(".back").addClass("d-none");
    $(".front").removeClass("d-none");
    $(".front").css("transform","");
    $(".front").css("backface-visibility","");
    }
<?php }else{ ?>
function flip() {
    $(".back").addClass("d-none");
    $(".front").removeClass("d-none");
    $(".front").css("transform","");
    $(".front").css("backface-visibility","");
}
function flipback() {
    $(".front").addClass("d-none");
    $(".back").removeClass("d-none");
    $(".back").css("transform","");
    $(".back").css("backface-visibility","");
    }
<?php } ?>

<?php if(totalCompletedBackupsOnedrive == true){?>
function flipODB() {
    $(".frontODB").addClass("d-none");
    $(".backODB").removeClass("d-none");
    $(".backODB").css("transform","");
    $(".backODB").css("backface-visibility","");
}
function flipbackODB() {
    $(".backODB").addClass("d-none");
    $(".frontODB").removeClass("d-none");
    $(".frontODB").css("transform","");
    $(".frontODB").css("backface-visibility","");
    } 
<?php }else{ ?>
function flipODB() {
    $(".backODB").addClass("d-none");
    $(".frontODB").removeClass("d-none");
    $(".frontODB").css("transform","");
    $(".frontODB").css("backface-visibility","");
}
function flipbackODB() {
    $(".frontODB").addClass("d-none");
    $(".backODB").removeClass("d-none");
    $(".backODB").css("transform","");
    $(".backODB").css("backface-visibility","");
    } 
<?php } ?>

<?php if(totalCompletedBackupsExchange == true){?>
function flipExchange() {
    $(".frontExchange").addClass("d-none");
    $(".backExchange").removeClass("d-none");
    $(".backExchange").css("transform","");
    $(".backExchange").css("backface-visibility","");
}
function flipbackExchange() {
    $(".backExchange").addClass("d-none");
    $(".frontExchange").removeClass("d-none");
    $(".frontExchange").css("transform","");
    $(".frontExchange").css("backface-visibility","");
    } 
<?php }else{ ?>
function flipExchange() {
    $(".backExchange").addClass("d-none");
    $(".frontExchange").removeClass("d-none");
    $(".frontExchange").css("transform","");
    $(".frontExchange").css("backface-visibility","");
}
function flipbackExchange() {
    $(".frontExchange").addClass("d-none");
    $(".backExchange").removeClass("d-none");
    $(".backExchange").css("transform","");
    $(".backExchange").css("backface-visibility","");
    } 
<?php } ?>	

<?php if(totalActualStorageUtilized == true){?>
function flip1() {
    $(".frontDB").addClass("d-none");
    $(".backDB").removeClass("d-none");
    $(".backDB").css("transform","");
    $(".backDB").css("backface-visibility","");
}
function flipback1() {
    $(".backDB").addClass("d-none");
    $(".frontDB").removeClass("d-none");
    $(".frontDB").css("transform","");
    $(".frontDB").css("backface-visibility","");
}

<?php }else{ ?>
function flip1() {
    $(".backDB").addClass("d-none");
    $(".frontDB").removeClass("d-none");
    $(".frontDB").css("transform","");
    $(".frontDB").css("backface-visibility","");
}
function flipback1() {
    $(".frontDB").addClass("d-none");
    $(".backDB").removeClass("d-none");
    $(".backDB").css("transform","");
    $(".backDB").css("backface-visibility","");
}
<?php } ?>

<?php if(totalActualStorageUtilizedOnedrive == true){?>
function flip1ODB() {
    $(".frontDBODB").addClass("d-none");
    $(".backDBODB").removeClass("d-none");
    $(".backDBODB").css("transform","");
    $(".backDBODB").css("backface-visibility","");
}
function flipback1ODB() {
    $(".backDBODB").addClass("d-none");
    $(".frontDBODB").removeClass("d-none");
    $(".frontDBODB").css("transform","");
    $(".frontDBODB").css("backface-visibility","");
}
<?php }else{ ?>
function flip1ODB() {
    $(".backDBODB").addClass("d-none");
    $(".frontDBODB").removeClass("d-none");
    $(".frontDBODB").css("transform","");
    $(".frontDBODB").css("backface-visibility","");
}
function flipback1ODB() {
    $(".frontDBODB").addClass("d-none");
    $(".backDBODB").removeClass("d-none");
    $(".backDBODB").css("transform","");
    $(".backDBODB").css("backface-visibility","");
}
<?php } ?>

<?php if(totalActualStorageUtilizedExchange == true){?>
function flip1Exchange() {
    $(".frontDBExchange").addClass("d-none");
    $(".backDBExchange").removeClass("d-none");
    $(".backDBExchange").css("transform","");
    $(".backDBExchange").css("backface-visibility","");
}
function flipback1Exchange() {
    $(".backDBExchange").addClass("d-none");
    $(".frontDBExchange").removeClass("d-none");
    $(".frontDBExchange").css("transform","");
    $(".frontDBExchange").css("backface-visibility","");
}
<?php }else{ ?>
function flip1Exchange() {
    $(".backDBExchange").addClass("d-none");
    $(".frontDBExchange").removeClass("d-none");
    $(".frontDBExchange").css("transform","");
    $(".frontDBExchange").css("backface-visibility","");
}
function flipback1Exchange() {
    $(".frontDBExchange").addClass("d-none");
    $(".backDBExchange").removeClass("d-none");
    $(".backDBExchange").css("transform","");
    $(".backDBExchange").css("backface-visibility","");
}
<?php } ?>	

<?php if(totalActualStorageUtilizedSharepoint == true){?>
function flip1Sharepoint() {
    $(".frontDBSharepoint").addClass("d-none");
    $(".backDBSharepoint").removeClass("d-none");
    $(".backDBSharepoint").css("transform","");
    $(".backDBSharepoint").css("backface-visibility","");
}
function flipback1Sharepoint() {
    $(".backDBSharepoint").addClass("d-none");
    $(".frontDBSharepoint").removeClass("d-none");
    $(".frontDBSharepoint").css("transform","");
    $(".frontDBSharepoint").css("backface-visibility","");
}

<?php }else{ ?>
function flip1Sharepoint() {
    $(".backDBSharepoint").addClass("d-none");
    $(".frontDBSharepoint").removeClass("d-none");
    $(".frontDBSharepoint").css("transform","");
    $(".frontDBSharepoint").css("backface-visibility","");
}
function flipback1Sharepoint() {
    $(".frontDBSharepoint").addClass("d-none");
    $(".backDBSharepoint").removeClass("d-none");
    $(".backDBSharepoint").css("transform","");
    $(".backDBSharepoint").css("backface-visibility","");
}
<?php } ?>	

<?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){?>
function flipNP() {
setTimeout(function(){  
    $(".frontNP").addClass("d-none");
    $(".backNP").removeClass("d-none");
    $(".backNP").css("transform","");
    $(".backNP").css("backface-visibility","");
    }, 1000);
}
function flipbackNP() {
setTimeout(function(){  
    $(".backNP").addClass("d-none");
    $(".frontNP").removeClass("d-none");
    $(".frontNP").css("transform","");
    $(".frontNP").css("backface-visibility","");
    }, 1000);
    }
<?php }else{ ?>
function flipNP() {
setTimeout(function(){  
    $(".backNP").addClass("d-none");
    $(".frontNP").removeClass("d-none");
    $(".frontNP").css("transform","");
    $(".frontNP").css("backface-visibility","");
    }, 1000);
}
function flipbackNP() {
setTimeout(function(){
    $(".frontNP").addClass("d-none");
    $(".backNP").removeClass("d-none");
    $(".backNP").css("transform","");
    $(".backNP").css("backface-visibility","");
    }, 1000);
}
<?php } ?>
	
<?php if($data['tile8ReportTypeOnedrive'] == 'systemsWithoutBackup'){?>
function flipNPODB() {
setTimeout(function(){  
    $(".frontNPODB").addClass("d-none");
    $(".backNPODB").removeClass("d-none");
    $(".backNPODB").css("transform","");
    $(".backNPODB").css("backface-visibility","");
    }, 1000);
}
function flipbackNPODB() {
setTimeout(function(){  
    $(".backNPODB").addClass("d-none");
    $(".frontNPODB").removeClass("d-none");
    $(".frontNPODB").css("transform","");
    $(".frontNPODB").css("backface-visibility","");
    }, 1000);
    }
<?php }else{ ?>
function flipNPODB() {
setTimeout(function(){  
    $(".backNPODB").addClass("d-none");
    $(".frontNPODB").removeClass("d-none");
    $(".frontNPODB").css("transform","");
    $(".frontNPODB").css("backface-visibility","");
    }, 1000);
}
function flipbackNPODB() {
setTimeout(function(){
    $(".frontNPODB").addClass("d-none");
    $(".backNPODB").removeClass("d-none");
    $(".backNPODB").css("transform","");
    $(".backNPODB").css("backface-visibility","");
    }, 1000);
}
<?php } ?>

<?php if($data['tile8ReportTypeExchange'] == 'systemsWithoutBackup'){?>
function flipNPExchange() {
setTimeout(function(){  
    $(".frontNPExchange").addClass("d-none");
    $(".backNPExchange").removeClass("d-none");
    $(".backNPExchange").css("transform","");
    $(".backNPExchange").css("backface-visibility","");
    }, 1000);
}
function flipbackNPExchange() {
setTimeout(function(){  
    $(".backNPExchange").addClass("d-none");
    $(".frontNPExchange").removeClass("d-none");
    $(".frontNPExchange").css("transform","");
    $(".frontNPExchange").css("backface-visibility","");
    }, 1000);
    }
<?php }else{ ?>
function flipNPExchange() {
setTimeout(function(){  
    $(".backNPExchange").addClass("d-none");
    $(".frontNPExchange").removeClass("d-none");
    $(".frontNPExchange").css("transform","");
    $(".frontNPExchange").css("backface-visibility","");
    }, 1000);
}
function flipbackNPExchange() {
setTimeout(function(){
    $(".frontNPExchange").addClass("d-none");
    $(".backNPExchange").removeClass("d-none");
    $(".backNPExchange").css("transform","");
    $(".backNPExchange").css("backface-visibility","");
    }, 1000);
}
<?php } ?>    


/*endpoint backup start*/    
$(function(){
        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item:checked:checked").length > 1){
                $('.actionn').hide();
                $('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');
            }else{
                $('.actionn').show();

                $('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            all.checked = len===total;
        }
    });
/**endpoint backup end/

/*Sharepoint backup start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all-sharepoint").click(function () {
            var checked = this.checked;
            $("input.select-item-sharepoint").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item-sharepoint:checked:checked").length > 1){
                $('.actionnSharepoint').hide();
                $('#bulkstopbackupSharepoint').removeClass('disabled');
                $('#bulkpausebackupSharepoint').removeClass('disabled');
            }else{
                $('.actionnSharepoint').show();
                $('#bulkstopbackupSharepoint').addClass('disabled');
                $('#bulkpausebackupSharepoint').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item-sharepoint").click(function () {
            var checked = this.checked;
            checkSelectedSharepoint();
        });

        //check is all selected
        function checkSelectedSharepoint() {
            var all = $("input.select-all-sharepoint")[0];
            var total = $("input.select-item-sharepoint").length;
            var len = $("input.select-item-onedrive:checked:checked").length;
            all.checked = len===total;
        }
    });
/*Sharepoint backup end*/

/*endpoint restore start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all-restore").click(function () {
            var checked = this.checked;
            $("input.select-item-restore").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item-restore:checked:checked").length > 1){
                $('.actionRestore').hide();
                $('#bulkStopRestore').removeClass('disabled');
            }else{
                $('.actionRestore').show();
                $('#bulkStopRestore').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item-restore").click(function () {
            var checked = this.checked;
            checkSelectedRestore();
        });

        //check is all selected
        function checkSelectedRestore() {
            var all = $("input.select-all-restore")[0];
            var total = $("input.select-item-restore").length;
            var len = $("input.select-item-restore:checked:checked").length;
            all.checked = len===total;
        }
    });
/*endpoint restore end*/

/*Sharepoint restore start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all-restore-sharepoint").click(function () {
            var checked = this.checked;
            $("input.select-item-restore-sharepoint").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item-restore-sharepoint:checked:checked").length > 1){
                $('.actionRestoreSharepoint').hide();
                $('#bulkStopRestoreSharepoint').removeClass('disabled');
            }else{
                $('.actionRestoreSharepoint').show();
                $('#bulkStopRestoreSharepoint').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item-restore-sharepoint").click(function () {
            var checked = this.checked;
            checkSelectedRestoreSharepoint();
        });

        //check is all selected
        function checkSelectedRestoreSharepoint() {
            var all = $("input.select-all-restore-sharepoint")[0];
            var total = $("input.select-item-restore-sharepoint").length;
            var len = $("input.select-item-restore-sharepoint:checked:checked").length;
            all.checked = len===total;
        }
    });
/*onedrive restore end*/

    function newone(){
        var len = $("input.select-item:checked:checked").length;
        if(len > 1){
            $('.actionn').hide();
            $('#bulkstopbackup').removeClass('disabled');
            $('#bulkpausebackup').removeClass('disabled');
        }else{
            $('.actionn').show();
            $('#bulkstopbackup').addClass('disabled');
            $('#bulkpausebackup').addClass('disabled');
        }
    }

    function newoneSharepoint(){
        var len = $("input.select-item-sharepoint:checked:checked").length;
        if(len > 1){
            $('.actionnSharepoint').hide();
            $('#bulkstopbackupSharepoint').removeClass('disabled');
            $('#bulkpausebackupSharepoint').removeClass('disabled');
        }else{
            $('.actionnSharepoint').show();
            $('#bulkstopbackupSharepoint').addClass('disabled');
            $('#bulkpausebackupSharepoint').addClass('disabled');
        }
    }

    function newRestore(){
        var len = $("input.select-item-restore:checked:checked").length;
        if(len > 1){
            $('.actionRestore').hide();
            $('#bulkStopRestore').removeClass('disabled');
        }else{
            $('.actionRestore').show();
            $('#bulkStopRestore').addClass('disabled');
        }
    }

    function newRestoreSharepoint(){
        var len = $("input.select-item-restore-sharepoint:checked:checked").length;
        if(len > 1){
            $('.actionRestoreSharepoint').hide();
            $('#bulkStopRestoreSharepoint').removeClass('disabled');
        }else{
            $('.actionRestoreSharepoint').show();
            $('#bulkStopRestoreSharepoint').addClass('disabled');
        }
    }

   <?php if($data['popup'] == 'visible') { ?>
        $('#changePasswordForFirstloginConsent').modal('show');
    <?php } ?>

document.querySelectorAll('.backupType').forEach(function (dropdown) {
    dropdown.addEventListener('click', function (event) {
        event.stopPropagation();
        // Your dropdown open/close logic here
    });
});	    

 $('.currentlyRunningbackupsSharepoint').on('hidden.bs.modal', function () {
	$('.backupTypeSharepoint').val('');
 });
localStorage.setItem("login","yes");
    localStorage.setItem('isLoggedIn','<?=$data['loggedIn']?>');
$(document).ready(function (){
        if(localStorage.getItem('isLoggedIn') =='Yes' && localStorage.getItem('userNameO') != null){
                console.log("redirected to archieve link");
                window.location = $('.protocol').html()+$('.cloud_url').html()+'/portal/viewFile/'+localStorage.getItem('userNameO')+'/'+localStorage.getItem('deviceUUIDO')+'/'+localStorage.getItem('odItemIdO')+'/'+localStorage.getItem('attachNameO')+'/'+localStorage.getItem('mailFoldPathO');
        }
});

$( ".toggle-passwordphrase" ).mousedown(function() {
  $("#rePassword").attr("type", "text");
$(this).toggleClass("fa-eye-slash fa-eye");
});

$( ".toggle-passwordphrase" ).mouseup(function() {
  $("#rePassword").attr("type", "password");
$(this).toggleClass("fa-eye fa-eye-slash");
});
</script>
<style>
.card{
	background-color: unset;
	border: unset;
}

.fold:before {
	content: "";
	z-index: 2;
	display: block;
	position: absolute;
	/*top: 0;*/
	bottom: 0;
	right: 0;
	border-width: 25px 25px 0 0;
	border-style: solid;
	border-color: #1976D2 #f0f0f0;
	-webkit-border-top-left-radius: 8px;
	-moz-border-top-left-radius: 8px;
	border-top-left-radius: 8px;
	/*-webkit-box-shadow: 0 0 5px #555;
	-moz-box-shadow: 0 0 5px #555;
	box-shadow: 0 0 5px #555;*/
	-webkit-transition: all .5s ease-in-out;
	-moz-transition: all .5s ease-in-out;
	transition: all .5s ease-in-out
}

#search_img {
	position: absolute;
	left: 18px;
	top: 9px;
	}

.cardWrapper{
	/*width:200px;*/
	height:135px;
	position:relative;
	/*background-color:#333;*/
	float:left;
	/*margin-right:10px;*/
	cursor:pointer;
	-webkit-font-smoothing:antialiased;
}

.cardFace{
	/*position:absolute;
	width:200px;
	height:200px;*/
	width:100%;
	overflow:hidden;
}

.moreInfo{
  padding:10px;
  color:white;
  line-height:24px;
  
}
.invalid{
  color: gainsboro !important;
  cursor:not-allowed !important;
  pointer-events:none !important;
    }	
</style>
