<?php
use \Core\View;
use Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 16/11/22
* @time 15:58 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="HistoryController">
    <span class="hide currentPage"><?='unusualActivityHistory'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide userName"><?=$data['userName']?></span>
    <span class="hide deviceName"><?=$data['deviceName']?></span>
    <span class="hide deviceUUID"><?=$data['deviceUUID']?></span>
    <span class="d-none redirectFrom"><?='fromDashboard'?></span>	
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
	<!--tabs start-->
        <?php if(isMobile()){ ?>
            <ul class="nav nav-pills flex-column" style="border: 1px solid #EC6621;border-radius: 10px;">
                <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#mua" aria-expanded="true" aria-controls="mua">Manage Unusual Activities</a></li>
                <li class="nav-item" style="display:unset !important;"><a data-toggle="tab" class="nav-link" data-target="#mud" aria-expanded="false" aria-controls="mud">Manage Quarantine Devices</a></li>
                <li class="nav-item" style="display:unset !important;"><a data-toggle="tab" class="nav-link" data-target="#mfql" aria-expanded="false" aria-controls="mfql">Manage File Quarantine List</a></li>
            </ul>
	<?php } ?>
	<?php if(!isMobile()){ ?>
            <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">
                <li role="presentation" class="nav-item"><a class="nav-link active" data-target="#mua" aria-controls="mua" role="tab" data-toggle="tab">Manage Unusual Activities</a></li>
                <li role="presentation" class="nav-item"><a class="nav-link" data-target="#mud" aria-controls="mud" role="tab" data-toggle="tab">Manage Quarantine Devices</a></li>
                <li role="presentation" class="nav-item"><a class="nav-link" data-target="#mfql" aria-controls="mfql" role="tab" data-toggle="tab">Manage File Quarantine List</a></li>
            </ul>
        <?php } ?>
	<!--tabs stop-->
	<br>
	<!--tab-content ends-->
	<div class="tab-content">
	    <!--mua tab starts-->
	    <div role="tabpanel" class="tab-pane active" id="mua">
            	<div class="panel">                
			<!--starts-->
			<div class="row">
                    		<div class="col-lg-4" block-ui="myBlockUI">
					<div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
					    <div class="background">
						<!--<i class="fa fa-users"></i>-->
					    </div>
					    <div class="panel-body widget widget-body">
						<span style="font-size: 20px;margin-top: -20px;color:white;">Active Alerts</span><a style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ totalActiveAlerts }}</span></a>
					    </div>
					</div>
                    		</div>
			        <div class="col-lg-4" block-ui="myBlockUI">
					<div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
					    <div class="background">
						<!--<i class="fa fa-desktop"></i>-->
					    </div>
					    <div class="panel-body widget widget-body">
						<!--<i class="fa fa-desktop"></i>-->
						<span style="font-size: 20px;margin-top: -20px;color:white;">Total No. of Alerts</span><a style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ totalAlerts }}</span></a>
					    </div>
					</div>
			        </div>
			        <div class="col-lg-4" block-ui="myBlockUI">
					<div class="panel panel-default no-box-shadow widget-danger" style="border-radius:10px;">
					    <div class="background">
						<!--<i class="fa fa-history"></i>-->
					    </div>
					    <div class="panel-body widget widget-body">
						<!--<i class="fa fa-desktop"></i>-->
						<span style="font-size: 20px;margin-top: -20px;color:white;">Total No. of Devices</span><a style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ totalDevicesAffected }}</span></a>
					    </div>
					</div>
			        </div>
			</div>
			<!--modal starts-->
			    <div class="modal fade infGraph" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
				<div class="modal-dialog modal-lg" style="width:800px !important;">
				    <div class="modal-content">
					<div class="modal-header">
							<h4 class="modal-title">Device Details</h4>
					    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>
					<div class="modal-body">
						<div class="panel-body widget widget-body">
							<div class="row col-lg-12">
								<div class="first" id="devicePro" style="border: 1px dashed black;">
									<canvas id="myChart11" width="700" height="400" style="width:700px;height:400px;"></canvas>
								</div>
							</div>
						</div>
					</div>
					<div class="modal-footer">
					    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				    </div>
				</div>
			    </div>
			<!--modal ends-->
			<center><span id="allUnusualSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
			<div class="panel-heading">
			    <h4>
				<?=Language::show('Unusual Activity History', 'keywords')?>
				<!--<span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('settings/quarantineList')?>"><?=Language::show('Manage file quarantine list', 'keywords');?></a></span>-->
		   	    </h4>
			</div>
			<div class="col-lg-12">
			    <span style="float: right;padding-left: 5px;padding-top: 6px;margin-bottom:5px;">
					<span>
						<input id="activeIncidents" name="activeIncidents" type="checkbox" value="enabled" checked>
						<label for="activeIncidents" style="font-size:11.9px;"><?=Language::show('Active Incidents Only', 'keywords');?></label>
					</span>
			    </span>
			</div>
			<div class="panel-body noRecords" style="padding: 0px 10px 10px 10px;">
			    <div class="row">
				<div class="col-lg-12">
				    <h2 align="center">No records found!</h2>
				</div>
			    </div>
			</div>
			<div class="row col-lg-12 records">
			    <div class="col-lg-12">
				<div class="panel-group" ng-repeat="value in auditsUnique | orderBy:sortTypeUA:sortReverseUA">
				    <div class="panel panel-default" style="border: 1px dotted #f27331;">
				      <div class="panel-heading">
					<h4 class="panel-title">
					    <p><span>{{value.deviceName}}</span> - <span>{{value.userName}}</span>
						<a class="btn btn-small btn-primary pull-right" id="showdetails1_{{value.deviceUUID}}" data-toggle="collapse" data-target="#collapse{{value.deviceUUID}}" ng-click="showEvents1(value.deviceName,value.userName, value.deviceUUID, value.batchId)" style="border-radius: 20px;">Show details</a>
						<a class="btn btn-small btn-danger pull-right" id="hidedetails1_{{value.deviceUUID}}" ng-click="hidedetails1(value.deviceName,value.userName, value.deviceUUID, value.batchId)" style="border-radius: 20px;display:none;">Hide details</a>
						<a class="btn btn-small btn-primary pull-right" ng-click="unusualActivityAction('getLogs', value.deviceUUID, value.id)" style="border-radius: 20px;">Get Logs</a>
						<a class="btn btn-small btn-primary pull-right" ng-click="unusualActivityAction('ignoreall', value.deviceUUID, value.id)" style="border-radius: 20px;">Resolve All</a>
						<a ng-bootbox-confirm="<h4><?=Language::show('Are you sure?  This will stop all backup and restore activity for the device.', 'keywords')?></h4>" ng-bootbox-confirm-action="unusualActivityAction('disableDevice', value.deviceUUID, value.id)" ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger pull-right" ng-if="value.isDevicequarantined==false" style="border-radius: 20px;">Disable Device</a>
						<a class="btn btn-small btn-primary pull-right" ng-if="value.isDevicequarantined==true" ng-click="unusualActivityAction('enabledevice', value.deviceUUID, '')"style="border-radius: 20px;">Enable Device</a>	
					    </p>
					</h4>
				      </div>
				      <div id="collapse{{value.deviceUUID}}" class="panel-collapse collapse">
				      	<div class="panel-body col-lg-12">
					    <!--panel body start-->
					    <a class="btn btn-small btn-success showTrend pull-right" ng-click="showTrend()" style="border-radius: 20px;">Show Trend</a>
					    <div class="row">
						<div class="table-responsive centerPanel col-lg-5" style="border: 1px solid #f27331;border-radius: 10px;">
						</hr>
						<table id="CurrentBackuptable" class="table table-bordered currentBackuptable">
						    <thead>
							<tr>					
                                 			    <th class="text-center clickAble" ng-click="sortTypeUA = 'backupStartTimestamp'; sortReverseUA = !sortReverseUA">
                                 			    	<?=Language::show('Backup Start Time', 'keywords')?>
                                 			    	<span ng-show="sortTypeUA == 'backupStartTimestamp' && !sortReverseUA" class="fa fa-caret-up"></span>
                                 			    	<span ng-show="sortTypeUA == 'backupStartTimestamp' && sortReverseUA" class="fa fa-caret-down"></span>
                                 			    </th>
                                 			    <th class="text-center clickAble" ng-click="sortTypeUA = 'alertType'; sortReverseUA = !sortReverseUA">
                                 			    	<?=Language::show('Alert Type', 'keywords')?>
                                 			    	<span ng-show="sortTypeUA == 'alertType' && !sortReverseUA" class="fa fa-caret-up"></span>
                                 			    	<span ng-show="sortTypeUA == 'alertType' && sortReverseUA" class="fa fa-caret-down"></span>
                                 			    </th>
                                 			    <th class="text-center clickAble" ng-click="sortTypeUA = 'alertType'; sortReverseUA = !sortReverseUA">
                                 			    	<?=Language::show('Action', 'keywords')?>
                                 			    	<span ng-show="sortTypeUA == 'alertType' && !sortReverseUA" class="fa fa-caret-up"></span>
                                 			    	<span ng-show="sortTypeUA == 'alertType' && sortReverseUA" class="fa fa-caret-down"></span>
                                 			    </th>
							</tr>
						    </thead>
						    <tbody>
							<tr ng-class="{'selected':$index == selectedRowMails}" ng-repeat="value in audits | orderBy:sortTypeUA:sortReverseUA" class="text-center">
                                 			    <!--<td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>-->
                                 			    <td ng-cloak>{{ value.backupStartTime}}</td>
                                 			    <td ng-cloak>{{ value.alertType}}</td>
                                 			    <td class="text-center" ng-cloak><a href="" ng-click="showEvents(value.deviceName,value.userName, value.deviceUUID, value.batchId, $index)" ng-cloak>Show Details</a></td>
							</tr>
						    </tbody>
						</table>
						</div>
						<div class="col-lg-6 rightPanel" id="eventsPanel" style="border: 1px solid #f27331;border-radius: 10px;display:none;margin-left:20px;">
						    <div class="col-lg-12">
							<span><a class="btn btn-small btn-danger pull-right" title="Close panel" ng-click="hideEvents()" style="border-radius: 20px;float:right;">X</a></span>
						    </div>
						    <div class="row col-lg-12">
							<div class="table-responsive col-lg-12">
							    <table class="table table-bordered">
								<tbody style="font-size:12px;">
								    <tr class="text-left">
									<td ng-cloak>Device Name</td>
									<td ng-cloak>{{ displayDeviceName}}</td>
								    </tr>
								    <tr class="text-left">
									<td ng-cloak>User Name</td>
									<td ng-cloak>{{ displayUserName}}</td>
								    </tr>
								    <tr class="text-left">
									<td ng-cloak>Alert Type</td>
									<td ng-cloak>{{ alertType}}</td>
								    </tr>
								    <tr class="text-left">
									<td ng-cloak>Total number of backed up files</td>
									<td ng-cloak>{{totalNumberOfFiles}}</td>
								    </tr>
								</tbody>
							    </table>
							</div>	
							<div class="col-lg-12">	
							    <!--<a class="btn btn-small btn-success pull-right" ng-click="unusualActivityAction('getLogs')" style="border-radius: 20px;">Get Logs</a>-->	
							    <a class="btn btn-small btn-primary pull-right" ng-show="status == 'Active'" ng-click="unusualActivityAction('ignore', value.deviceUUID, '')" style="border-radius: 20px;">Resolve</a>
							    <a class="btn btn-small btn-primary pull-right" ng-show="status == 'Resolved'" ng-click="unusualActivityAction('activate', value.deviceUUID, '')" style="border-radius: 20px;">Activate</a>
							    <!--<a ng-bootbox-confirm="<h4><?=Language::show('Are you sure?  This will stop all backup and restore activity for the device.', 'keywords')?></h4>" ng-bootbox-confirm-action="unusualActivityAction('disableDevice')" ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger pull-right" ng-show="isDevicequarantined==false" style="border-radius: 20px;">Disable Device</a>
							    <a class="btn btn-small btn-success pull-right" ng-show="isDevicequarantined==true" ng-click="unusualActivityAction('enabledevice')"style="border-radius: 20px;">Enable Device</a>-->
							    <br>
							</div>	
							<!--events start-->
							<div class="table-responsive col-lg-12" style="margin-top:20px;">
							</hr>
							    <table id="CurrentEventtable" class="table table-bordered currentEventtable">
								<thead>
									<tr>
										<th class="text-center"><?=Language::show('Type', 'keywords')?></th>                                
										<th class="text-center"><?=Language::show('No. of impacted files', 'keywords')?></th>
										<th class="text-center"><?=Language::show('status', 'keywords')?></th>
									</tr>
								</thead>
								<tbody>
								<tr class="text-center">
								    <td class="text-left" ng-cloak>Possible file infections</td>
								    <td ng-cloak>{{ numberOfFilesInfected}}</td>
								    <td ng-cloak>{{ status}}</td>
								</tr>
								<tr class="text-center">
								    <td class="text-left" ng-cloak>Files Deleted</td>
								    <td ng-cloak>{{ numberOfFilesDeleted}}</td>
								    <td ng-cloak>{{ status}}</td>
								</tr>
								<tr class="text-center">
								    <td class="text-left" ng-cloak>Files Created</td>
								    <td ng-cloak>{{ numberOfNewFiles}}</td>
								    <td ng-cloak>{{ status}}</td>
								</tr>
								<tr class="text-center">
								    <td class="text-left" ng-cloak>Files Modified</td>
								    <td ng-cloak>{{ numberOfFilesmodified}}</td>
								    <td ng-cloak>{{ status}}</td>
								</tr>						
								</tbody>
							    </table>
							</div>
						    </div>
						</div>
					    </div>
					    <!--panel body stop-->
				      	</div>
				      </div>
				</div>
			    </div>
			 </div>
			 <div class="table-responsive leftPanelOld col-lg-12 hide" style="border: 1px solid #f27331;border-radius: 10px;overflow:scroll;height:500px;">
                            </hr>
                            <table id="CurrentBackuptable" class="table table-bordered currentBackuptable">
                                <thead>
                                    <tr>
                                	<th class="text-center clickAble" ng-click="sortTypeUA = 'deviceName'; sortReverseUA = !sortReverseUA">
                                            <?=Language::show('deviceName', 'keywords')?>
                                            <span ng-show="sortTypeUA == 'deviceName' && !sortReverseUA" class="fa fa-caret-up"></span>
                                            <span ng-show="sortTypeUA == 'deviceName' && sortReverseUA" class="fa fa-caret-down"></span>
                                	</th>
                                	<th class="text-center clickAble" ng-click="sortTypeUA = 'userName'; sortReverseUA = !sortReverseUA">
                                            <?=Language::show('userId', 'keywords')?>
                                            <span ng-show="sortTypeUA == 'userName' && !sortReverseUA" class="fa fa-caret-up"></span>
                                            <span ng-show="sortTypeUA == 'userName' && sortReverseUA" class="fa fa-caret-down"></span>
                                	</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in auditsUnique | orderBy:sortTypeUA:sortReverseUA" class="text-center">
                                	<td title="{{ value.deviceName }}" class="text-center" ng-cloak><a href="" ng-click="showEvents1(value.deviceName,value.userName, value.deviceUUID, value.batchId)" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</a></td>
                                	<td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    </tr>
                                </tbody>
                            </table>
			 </div>
			 <div class="table-responsive centerPanelOld col-lg-6" style="border: 1px solid #f27331;border-radius: 10px;overflow:scroll;height:500px;display:none;">
                            </hr>
                            <table id="CurrentBackuptable" class="table table-bordered currentBackuptable">
                                <thead>
                                <tr>                                
                                     <th class="text-center clickAble" ng-click="sortTypeUA = 'backupStartTimestamp'; sortReverseUA = !sortReverseUA">
                                 	 <?=Language::show('Backup Start Time', 'keywords')?>
                                 	 <span ng-show="sortTypeUA == 'backupStartTimestamp' && !sortReverseUA" class="fa fa-caret-up"></span>
                                 	 <span ng-show="sortTypeUA == 'backupStartTimestamp' && sortReverseUA" class="fa fa-caret-down"></span>
                                     </th>
                                     <th class="text-center clickAble" ng-click="sortTypeUA = 'alertType'; sortReverseUA = !sortReverseUA">
                                 	 <?=Language::show('Alert Type', 'keywords')?>
                                 	 <span ng-show="sortTypeUA == 'alertType' && !sortReverseUA" class="fa fa-caret-up"></span>
                                 	 <span ng-show="sortTypeUA == 'alertType' && sortReverseUA" class="fa fa-caret-down"></span>
                                     </th>
                                     <th class="text-center clickAble" ng-click="sortTypeUA = 'alertType'; sortReverseUA = !sortReverseUA">
                                 	 <?=Language::show('Action', 'keywords')?>
                                 	 <span ng-show="sortTypeUA == 'alertType' && !sortReverseUA" class="fa fa-caret-up"></span>
                                 	 <span ng-show="sortTypeUA == 'alertType' && sortReverseUA" class="fa fa-caret-down"></span>
                                     </th>
                                </tr>
                                </thead>
				<tbody>
                                    <tr ng-repeat="value in audits | orderBy:sortTypeUA:sortReverseUA" class="text-center">                                    
                                 	 <td ng-cloak>{{ value.backupStartTime}} </td>
                                 	 <td ng-cloak>{{ value.alertType}}</td>
                                 	 <td class="text-center" ng-cloak><a href="" ng-click="showEvents(value.deviceName,value.userName, value.deviceUUID, value.batchId)" ng-cloak>Show Details</a></td>
                                    </tr>
                                </tbody>
                            </table>
			 </div>
			 <div class="col-lg-5 rightPanelOld" id="eventsPanel" style="border: 1px solid #f27331;border-radius: 10px;display:none;">
			     <div>
			 	<a class="btn btn-small btn-danger pull-right" title="Close panel" ng-click="hideEvents()" style="border-radius: 20px;">X</a>
			 	<p><span>Device Name :</span> {{displayDeviceName}} </p>
			 	<p><span>User Name :</span> {{displayUserName}} </p>
			 	<p><span>Alert Type :</span> {{alertType}} </p>
			 	<a class="btn btn-small btn-success pull-right" ng-click="unusualActivityAction('getLogs')" style="border-radius: 20px;">Get Logs</a>
			 	<a class="btn btn-small btn-primary pull-right" ng-show="status == 'Active'" ng-click="unusualActivityAction('ignore')" style="border-radius: 20px;">Resolve</a>
			 	<a class="btn btn-small btn-primary pull-right" ng-show="status == 'Resolved'" ng-click="unusualActivityAction('activate')" style="border-radius: 20px;">Activate</a>
			 	<a ng-bootbox-confirm="<h4><?=Language::show('Are you sure?  This will stop all backup and restore activity for the device.', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="unusualActivityAction('disableDevice')"
				       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger pull-right" ng-show="isDevicequarantined==false" style="border-radius: 20px;">Disable Device</a>
			 	<a class="btn btn-small btn-success pull-right" ng-show="isDevicequarantined==true" ng-click="unusualActivityAction('enabledevice')"style="border-radius: 20px;">Enable Device</a>
			 	<br>
			 	<!--events start-->
			 	    <div class="table-responsive col-lg-12" style="margin-top:20px;">
			 	    </hr>
                            	    <table id="CurrentEventtable" class="table table-bordered currentEventtable">
					<thead>
                                	    <tr>                                
                                		<th class="text-center clickAble" ng-click="sortTypeUA = 'alertType'; sortReverseUA = !sortReverseUA">
                                        	    <?=Language::show('Type', 'keywords')?>
                                        	    <span ng-show="sortTypeUA == 'alertType' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        	    <span ng-show="sortTypeUA == 'alertType' && sortReverseUA" class="fa fa-caret-down"></span>
                                		</th>
                                		<th class="text-center clickAble" ng-click="sortTypeUA = 'totalNumberOfFiles'; sortReverseUA = !sortReverseUA">
                                        	    <?=Language::show('Total No. of files', 'keywords')?>
                                        	    <span ng-show="sortTypeUA == 'totalNumberOfFiles' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        	    <span ng-show="sortTypeUA == 'totalNumberOfFiles' && sortReverseUA" class="fa fa-caret-down"></span>
                                		</th>
                                		<th class="text-center clickAble" ng-click="sortTypeUA = 'numberOfFilesInfected'; sortReverseUA = !sortReverseUA">
                                        	    <?=Language::show('No. of impacted files', 'keywords')?>
                                        	    <span ng-show="sortTypeUA == 'numberOfFilesInfected' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        	    <span ng-show="sortTypeUA == 'numberOfFilesInfected' && sortReverseUA" class="fa fa-caret-down"></span>
                                		</th>
                                		<th class="text-centerclickAble" ng-click="sortTypeUA = 'status'; sortReverseUA = !sortReverseUA">
                                        	    <?=Language::show('status', 'keywords')?>
                                        	    <span ng-show="sortTypeUA == 'status' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        	    <span ng-show="sortTypeUA == 'status' && sortReverseUA" class="fa fa-caret-down"></span>
                                		</th>
                                	    </tr>
					</thead>
					<tbody>
                                	    <tr class="text-center">
                                		<td ng-cloak>Possible file infections</td>
                                		<td ng-cloak>{{ totalNumberOfFiles}}</td>
                                		<td ng-cloak>{{ numberOfFilesInfected}}</td>
                                		<td ng-cloak>{{ status}}</td>
                                	    </tr>
                                	    <tr class="text-center">
                                		<td ng-cloak>Files Deleted</td>
                                		<td ng-cloak>{{ totalNumberOfFiles}}</td>
                                		<td ng-cloak>{{ numberOfFilesDeleted}}</td>
                                		<td ng-cloak>{{ status}}</td>
                                	    </tr>
                                	    <tr class="text-center">
                                		<td ng-cloak>Files Created</td>
                                		<td ng-cloak>{{ totalNumberOfFiles}}</td>
                                		<td ng-cloak>{{ numberOfNewFiles}}</td>
                                		<td ng-cloak>{{ status}}</td>
                                	    </tr>
					</tbody>
                            	    </table>
			 	    </div>
			 	<!--events end-->
			     </div>
			 </div>
		    </div>
		    <div class="row records">
                        <div class="col-lg-12 text-center">
                            <!--<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="navigateUnusualActivityHistory(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>-->
                            <a class="btn btn-primary previous" title="Previous" ng-click="navigateUnusualActivityHistory(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="navigateUnusualActivityHistory(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <!--<a class="btn btn-primary last" title="Last" ng-click="navigateUnusualActivityHistory(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>-->
                        </div>
		    </div>
			<!--ends-->
            	</div>
	    </div><!--mua tab ends-->
	    <div role="tabpanel" class="tab-pane" id="mud">
	    	<!--mud starts-->
		    <div class="panel">
			<div class="panel-body noRecordsMUD" style="padding: 0px 10px 10px 10px;">
			    <div class="row">
				<div class="col-lg-12">
				    <h2 align="center">No records found!</h2>
				</div>
			    </div>
			</div>
			<div class="panel-body recordsMUD" style="padding: 0px 10px 10px 10px;">
				<div class="row" style="padding: 10px 10px 10px 10px">
				    <div class="col-lg-12">
					<h4><?=Language::show('Quarantined Device List', 'keywords')?></h4>
				    </div>
				</div>
				<div class="row">
				    <div class="col-lg-12">
					<div class="table-responsive col-lg-12 quarantineDevicesListDiv" style="border: 1px solid #f27331;border-radius: 10px;overflow:scroll;height:500px;">
					</hr>
					<table id="quarantineDevicesList" class="table table-bordered quarantineDevicesList">
					    <thead>
						<tr>
						    <th class="text-center clickAble" ng-click="sortTypeQD = 'deviceName'; sortReverseQD = !sortReverseQD">
						<?=Language::show('Device Name', 'keywords')?>
						<span ng-show="sortTypeQD == 'deviceName' && !sortReverseQD" class="fa fa-caret-up"></span>
						<span ng-show="sortTypeQD == 'deviceName' && sortReverseQD" class="fa fa-caret-down"></span>
						    </th>
						    <th class="text-center clickAble" ng-click="sortTypeQD = 'userName'; sortReverseQD = !sortReverseQD">
						<?=Language::show('User Name', 'keywords')?>
						<span ng-show="sortTypeQD == 'userName' && !sortReverseQD" class="fa fa-caret-up"></span>
						<span ng-show="sortTypeQD == 'userName' && sortReverseQD" class="fa fa-caret-down"></span>
						    </th>
						    <th class="text-center clickAble"><?=Language::show('action', 'keywords')?></th>
						</tr>
					    </thead>
					    <tbody>
						<tr class="text-center" ng-repeat="value in quarantineDevicesList | orderBy:sortTypeQD:sortReverseQD">
						    <td title="{{ value.deviceName }}" ng-cloak>{{ value.deviceName | limitTo:40}}{{value.deviceName.length > 40 ? '...' : ''}}</td>
						    <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:40}}{{value.userName.length > 40 ? '...' : ''}}</td>
						    <td ng-cloak>
							<a ng-click="unusualActivityAction('enableQdevice', value.deviceUUID, value.deviceId)" class="btn btn-small btn-success" style="border-radius: 20px;">Enable Device</a>
						</td>
						</tr>
					    </tbody>
					</table>
					</div>
				    </div>
				</div>
			</div>
		    </div>
	    	<!--mud ends-->
	    </div>
	    <div role="tabpanel" class="tab-pane" id="mfql">
	    <!--mfql start-->
	        <div class="panel">
			<div class="panel-heading">
			    <h4><span class="pull-right"><a class="btn btn-success btn-small" ng-click=uploadSampleModal()><?=Language::show('Upload Infected Samples', 'keywords');?></a></span></h4>
			</div>
			<div class="row recordsQL">
			    <div class="col-lg-6" block-ui="myBlockUI">
				<div class="panel panel-default no-box-shadow widget-primary" style="border-radius:10px;">
				    <div class="background">
					<!--<i class="fa fa-users"></i>-->
				    </div>
				    <div class="panel-heading widget-header" style="border-radius:10px;">
					<a>Uploaded Infected Files</a>
					<!--<a href="" class="pull-right" style="font-size: 18px;"><span class="ng-binding">13</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;"> 50 </span></a>-->
					<a href="" class="pull-right" style="font-size: 18px;"><span ng-cloak>{{ uploadedInfFilesCount }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;"> 50 </span></a>
				    </div>
				    <!--<div class="panel-body widget widget-body">
					<a href="" class="pull-right" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ uploadedInfFilesCount }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;"> 50 </span></a>
				    </div>-->
				</div>
			    </div>
			</div>
			<div class="panel-body" style="padding: 0px 10px 10px 10px;">
			    <div class="row">
				<div class="col-lg-12">
				    <h4><?=Language::show('Quarantine Files List', 'keywords')?></h4>
				</div>
			    </div>
			</div>
			<div class="panel-body noRecordsQL" style="padding: 0px 10px 10px 10px;">
			    <div class="row">
				<div class="col-lg-12">
				    <h2 align="center">No records found!</h2>
				</div>
			    </div>
			</div>
			<div class="panel-body recordsQL" style="padding: 0px 10px 10px 10px;">
			    <div class="row">
				    <div class="col-lg-12">
					<div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;border-radius:10px;">
					    <p>Files specified below are considered malicious and will be prevented from being downloaded or restored.</p>
					</div>
				    </div>
			    </div>
			    <div class="row">
				<div class="col-lg-12">
				   <div class="table-responsive col-lg-12 quarantineListDiv" style="border: 1px solid #f27331;border-radius: 10px;overflow:scroll;height:500px;">
				    </hr>
				    <table id="quarantineList" class="table table-bordered quarantineList">
					<thead>
					<tr>
					<th class="text-center clickAble" ng-click="sortTypeQL = 'fileName'; sortReverseQL = !sortReverseQL">
						<?=Language::show('File Name', 'keywords')?>
						<span ng-show="sortTypeQL == 'fileName' && !sortReverseQL" class="fa fa-caret-up"></span>
						<span ng-show="sortTypeQL == 'fileName' && sortReverseQL" class="fa fa-caret-down"></span>
					</th>
					<th class="text-center clickAble" ng-click="sortTypeQL = 'timestampInMillis'; sortReverseQL = !sortReverseQL">
						<?=Language::show('File Added On', 'keywords')?>
						<span ng-show="sortTypeQL == 'timestampInMillis' && !sortReverseQL" class="fa fa-caret-up"></span>
						<span ng-show="sortTypeQL == 'timestampInMillis' && sortReverseQL" class="fa fa-caret-down"></span>
					</th>
					<th class="text-center clickAble"><?=Language::show('action', 'keywords')?></th>
					</tr>
					</thead>
					<tbody>
					<tr class="text-center" ng-repeat="value in quarantineList | orderBy:sortTypeQL:sortReverseQL">
						<td title="{{ value.fileName }}" ng-cloak>{{value.fileName}}</td>
						<td ng-cloak>{{value.timestamp}}</td>
						<td ng-cloak>
							<a class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to delete the selected file?', 'keywords')?></h4>" ng-bootbox-confirm-action="deleteRwFile(value.id)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="border-radius: 20px;">Delete</a>
						</td>
					</tr>
					</tbody>
				    </table>
				    </div>
				</div>
			    </div>
			</div>
                	<!--modal starts-->
			<div class="modal fade uploadSampleModal" id="uploadSampleModal" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
			    <div class="modal-dialog modal-lg" style="width:800px !important;">
			        <div class="modal-content">
					<div class="modal-header">
							<h4 class="modal-title">Upload File</h4>
					    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>
					<div class="modal-body">
				    	    <div class="panel-body">
						<div class="row">
						    <div class="col-lg-12">
							<div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;border-radius:10px;">
							    <p>Uploaded files are only processed to create a hash – and are not stored on Parablu’s servers.</p>
							</div>
						    </div>
						</div>
						<form class="infForm" data-parsley-validate enctype="multipart/form-data" style="border: 1px solid #f27331;border-radius: 10px;">
						    <div class="row" style="margin-left:5px;">
							<div class="col-lg-12" style="margin-top:10px;">
							    <span><b>Upload sample files :</b></span>
							</div>
							<div class="col-lg-12" style="margin-top:10px;">
							Choose File : <input type="file" name="infFileName" id="infFileName">
							      <?php if(isMobile()){ ?>
								<span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
							      <?php } ?>
						       </div>
						       <div class="col-lg-12">
								<span id="InfFileUploadingProgress"></span>
						       </div>
						       <div class="col-lg-8">
							<div id="progress-div-inf" style="margin-left:10px;display:none;">
							       <div id="progress-bar-inf"></div>
							      </div>
							      <div id="targetLayerInf"></div>
						       </div>
						       <div class="col-lg-12">
								    <button type="submit" class="submit btn btn-primary pull-right infFileSave" style="margin-right: 10px;margin-bottom:10px;"><?=Language::show('Upload', 'keywords');?></button>
						       </div>
						    </div>
						</form>
				    	    </div>
					</div>
					<div class="modal-footer">
				    	    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
			        </div>
			    </div>
			</div>
                	<!--modal ends-->
	        </div>
	    <!--mfql ends-->
	    </div>
	</div><!--tab-content ends-->
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js" type="text/javascript"></script>
<script>
    /*endpoint backup start*/
    $(function(){
        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item:checked:checked").length > 1){
		$('.downloadLogs').show();
		$('.quarantineDevice').show();
		$('.ignore').show();
                /*$('#bulkstopbackup').removeClass('disabled');
		$('#bulkpausebackup').removeClass('disabled');*/
            }else{
                $('.downloadLogs').hide();
		$('.quarantineDevice').hide();
		$('.ignore').hide();
                /*$('#bulkstopbackup').addClass('disabled');
		$('#bulkpausebackup').addClass('disabled');*/
	    }
	    var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
           }).get();
        console.log("arrrrr : "+arr);
        });
        //check selected items
	$("input.select-item").click(function () {
		console.log("cameeeeeeeeeeee");
            var checked = this.checked;
	    checkSelected();
	    if($("input.select-item:checked:checked").length > 1){
		    console.log("cameeeeeeeeeeee111");
                $('.downloadLogs').show();
                $('.quarantineDevice').show();
                /*$('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');*/
	    }else{
		    console.log("cameeeeeeeeeeee2222");
                $('.downloadLogs').hide();
                $('.quarantineDevice').hide();
                /*$('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');*/
            }
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            all.checked = len===total;
        }
    });
/**endpoint backup end**/
</script>
<style>
#progress-bar-inf {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}
#progress-div-inf {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}
#targetLayerInf{width:100%;text-align:center;}
.invalid{
  background-color: gainsboro !important;
  cursor:not-allowed !important;
  pointer-events:none !important;
}	
</style>
