<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <!--<li><h3><?=$data['title']?></h3></li>
		<li><?=$data['crumb1']?></li>-->
		<li><h3><?='Assets'?></h3></li>
                <li><?='List of Assets'?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="DeviceController">
    <span class="d-none currentPage"><?='devicesListPage'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
	    <?php if(isMobile()){ ?>
                     <ul class="nav nav-pills flex-column" style="border: 1px solid #EC6621;border-radius: 10px;">
                        <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="backupDT" class="nav-link <?php echo $data['activeTabBackup'];?>" data-target="#backup" aria-controls="backup" data-toggle="tab">BluVault</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('exchange')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="exchangeDT" class="nav-link <?php echo $data['activeTabExchange'];?>" data-target="#exchange" aria-controls="exchange" data-toggle="tab">Microsoft Exchange</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="sharepointDT" class="nav-link <?php echo $data['activeTabSharepoint'];?>" data-target="#sharepoint" aria-controls="sharepoint" data-toggle="tab">SharePoint Online</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="onedriveDT" class="nav-link <?php echo $data['activeTabOnedrive'];?>" data-target="#onedrive" aria-controls="onedrive" data-toggle="tab">OneDrive for Business</a></li>
                        <?php } ?>
                    </ul>
            <?php } ?>
            <?php if(!isMobile()){ ?>
		    <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">                
			<?php if(Auth::checkCloudPermission('backup') == true){ ?>
			    <li role="presentation" class="nav-item"><a href="" id="backupDT" class="nav-link <?php echo $data['activeTabBackup'];?>" data-target="#backup" aria-controls="backup" role="tab" data-toggle="tab">BluVault</a></li>			    
			<?php } ?>
			<?php if(Auth::checkCloudPermission('exchange')){ ?>
		            <li role="presentation" class="nav-item"><a href="" id="exchangeDT" class="nav-link <?php echo $data['activeTabExchange'];?>" data-target="#exchange" aria-controls="exchange" role="tab" data-toggle="tab">Microsoft Exchange</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('sharepoint')){ ?>
			    <li role="presentation" class="nav-item"><a href="" id="sharepointDT" class="nav-link <?php echo $data['activeTabSharepoint'];?>" data-target="#sharepoint" aria-controls="sharepoint" role="tab" data-toggle="tab">SharePoint Online</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('onedrive')){ ?>
			    <li role="presentation" class="nav-item"><a href="" id="onedriveDT" class="nav-link <?php echo $data['activeTabOnedrive'];?>" data-target="#onedrive" aria-controls="onedrive" role="tab" data-toggle="tab">OneDrive for Business</a></li>
			<?php } ?>
		    </ul>
            <?php } ?>
            <div class="tab-content">
            <div role="tabpanel" class="tab-pane <?php echo $data['activeTabBackup'];?>" id="backup">
            <!--bluvalut devices-->
            <div class="panel nodevice1" style="display:none">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_devices', 'keywords');?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center"><?=Language::show('noDevices', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
            </div>
	    <div class="panel hasDevices" style="display:none;">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_devices', 'keywords');?>
			<?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('backup')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Devices</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('backup')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Devices</a>
                        <?php } ?>
			<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
				<?php if(block == false){ ?>
				    <a class="btn btn-primary btn-small pull-right" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Devices in Bulk</a>
				<?php } else {?>
				<?php if(!isMobile()){ ?>
				    <a class="btn btn-primary btn-small pull-right" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Devices in Bulk</a>
				<?php }else { ?>
				    <a class="btn btn-primary btn-small" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Devices in Bulk</a>
				<?php } ?>
				<?php } ?>
			<?php } ?>                        
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">                        
			<form class="col-lg-12" ng-submit="searchDevice1(search.deviceName)" data-parsley-validate>
				<div class="row">
				    <div class="col-lg-12">
					<select class="searchDeviceName" id="deviceName" style="width: 100%;" ng-model="search.deviceName" data-parsley-trigger="change" multiple="multiple"></select>
				    </div>
				    <!--<div class="col-lg-2">
					<button type="submit" class="btn btn-default">Search</button>
				    </div>-->
				</div>
                        </form>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <div class="h4 nodevice text-center" style="display: none;">No device matched</div>
                        <table class="table table-bordered table-striped deviceListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>
                                <th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                    <?=Language::show('status', 'keywords')?>
                                    <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devices | orderBy:sortType:sortReverse">
                                <!--<td class="text-center" ng-click="openFilesPage(value.deviceId, value.deviceName, value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.unusualActivity)" style="cursor:pointer;" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>-->
				<td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>
                                <td title="{{ value.deviceName }}" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak class="text-center">
                                    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.blocked == false && value.decoupled == false && value.quarantineDevice == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == true && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == false && value.decoupled == true && value.quarantineDevice == false"><?=Language::show('Decoupled', 'keywords')?></label></h5>
				    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.quarantineDevice == true"><?=Language::show('Quarantined', 'keywords')?></label></h5>
                                </td>
                                <td>
                                    <span class="d-none ownerFor{{value.deviceId}}" id="ownerFor{{value.deviceId}}">{{value.ownerList}}</span>
                                    <a ng-click="properties(value.deviceUUID, 'backup')" class="btn btn-small btn-default hide">Properties</a>
				    <button ng-click="logAction(value.deviceUUID,value.deviceType)" class="btn btn-small btn-default hide" ng-class="[{true:'not-allowed'}[value.blocked],{true:'not-allowed'}[value.decoupled]]">Actions</button>
				    <?php if($data['readOnlyAdminUser'] == 'No'){ ?>					
					    <a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName, 'backup')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform unblock operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>"
					       ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName, 'backup')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>				   
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform delete operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName, 'backup')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == false"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userNameForSearch}}/{{value.deviceNameEncoded}}')?>" style="margin: 5px;"><?=Language::show('Manage Device', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userNameForSearch}}/{{ value.deviceUUID }}/{{ value.deviceNameEncoded }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
					    <a class="btn btn-primary btn-small" name="{{value.deviceUUID}}" id="{{value.deviceId}}" title="{{value.deviceName}}" onclick="addCurrentOwner(this.id, this.title, this.name)">Assign additional owners</a>
				    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <?php if(RESTORE_FROM_PORTAL){ ?>
                                            <a ng-click="initiateRestoreBackup(value.deviceUUID, value.deviceName, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Entire Device</a>
                                            <a ng-click="sendMeTo('<?=Url::basePath("backup/files/restore")?>/'+value.deviceId+'/'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Selected Files</a>
                                        <?php } ?>
                                    <?php } ?>					
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row deviceListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="updateDevicesNavigate('all',first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="updateDevicesNavigate('all',previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="updateDevicesNavigate('all',next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="updateDevicesNavigate('all',last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>                    
                </div>
            </div>            
            </div>
            <!--bluvalut devices-->
            	    <!--onedrive device start-->
	    <div role="tabpanel" class="tab-pane <?php echo $data['activeTabOnedrive'];?>" id="onedrive">	    
	    <div class="panel nodeviceOneDrive1" style="display:none">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_assets', 'keywords');?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center"><?=Language::show('noAssets', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
            </div>
	    <div class="panel hasDevicesOneDrive" style="display:none;">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_assets', 'keywords');?>
			<?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('ODB')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Assets</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('ODB')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Assets</a>
                        <?php } ?>
			<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
				<?php if(block == false){ ?>
				    <a class="btn btn-primary btn-small pull-right" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
				<?php } else {?>
				<?php if(!isMobile()){ ?>
				    <a class="btn btn-primary btn-small pull-right" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
				<?php }else { ?>
				    <a class="btn btn-primary btn-small" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
				<?php } ?>
				<?php } ?>
			<?php } ?>                        
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">                        
			<form class="col-lg-12" ng-submit="searchDeviceOneDrive1(search.deviceNameOneDrive)" data-parsley-validate>
				<div class="row">
				    <div class="col-lg-12">
					<select class="searchDeviceNameOneDrive" id="deviceNameOneDrive" style="width: 100%;" ng-model="search.deviceNameOneDrive" data-parsley-trigger="change" multiple="multiple"></select>
				    </div>
				    <!--<div class="col-lg-2">
					<button type="submit" class="btn btn-default">Search</button>
				    </div>-->
				</div>
                        </form>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loadingOneDrive text-center">Loading.....</div>
                        <div class="h4 nodeviceOneDrive text-center" style="display: none;">No asset matched</div>
                        <table class="table table-bordered table-striped deviceOneDriveListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>
				<th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('Asset Name', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                    <?=Language::show('status', 'keywords')?>
                                    <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devicesOneDrive | orderBy:sortType:sortReverse">
                                <!--<td class="text-center" ng-click="openFilesPage(value.deviceId, value.deviceName, value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.unusualActivity)" style="cursor:pointer;" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>-->
				<td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>
                                <td title="{{ value.deviceName }}" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak class="text-center">
                                    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.blocked == false && value.decoupled == false && value.quarantineDevice == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == true && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == false && value.decoupled == true && value.quarantineDevice == false"><?=Language::show('Decoupled', 'keywords')?></label></h5>
				    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.quarantineDevice == true"><?=Language::show('Quarantined', 'keywords')?></label></h5>
                                </td>
                                <td>
                                    <span class="d-none ownerFor{{value.deviceId}}" id="ownerFor{{value.deviceId}}">{{value.ownerList}}</span>
                                    <a ng-click="properties(value.deviceUUID, 'ONEDRIVE')" class="btn btn-small btn-default hide">Properties</a>
				    <button ng-click="logAction(value.deviceUUID,value.deviceType)" class="btn btn-small btn-default hide" ng-class="[{true:'not-allowed'}[value.blocked],{true:'not-allowed'}[value.decoupled]]">Actions</button>
				    <?php if($data['readOnlyAdminUser'] == 'No'){ ?>					
					    <a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName, 'onedrive')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform unblock operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>"
					       ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName, 'onedrive')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>				   
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform delete operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName, 'onedrive')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == false"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userNameForSearch}}/{{value.deviceNameEncoded}}')?>" style="margin: 5px;"><?=Language::show('Manage Asset', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userNameForSearch}}/{{ value.deviceUUID }}/{{ value.deviceNameEncoded }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
					    <a ng-hide="value.showAssignDevices == false" class="btn btn-primary btn-small" name="{{value.deviceUUID}}" id="{{value.deviceId}}" title="{{value.deviceNameNew}}" onclick="addCurrentOwner(this.id, this.title, this.name)">Assign additional owners</a>					
				    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <?php if(RESTORE_FROM_PORTAL){ ?>
                                            <a ng-click="initiateRestoreBackup(value.deviceUUID, value.deviceName, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Entire Device</a>
                                            <a ng-click="sendMeTo('<?=Url::basePath("backup/files/restore")?>/'+value.deviceId+'/'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Selected Files</a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row deviceOneDriveListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountOneDrive}} of {{totalpageCountOneDrive}}</span></p>
                            <a class="btn btn-primary firstOneDrive" title="First" ng-click="updateDevicesOneDriveNavigate('all',firstOneDrive)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousOneDrive" title="Previous" ng-click="updateDevicesOneDriveNavigate('all',previousOneDrive)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextOneDrive" title="Next" ng-click="updateDevicesOneDriveNavigate('all',nextOneDrive)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastOneDrive" title="Last" ng-click="updateDevicesOneDriveNavigate('all',lastOneDrive)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>                    
                </div>
            </div>            
            </div>
            <!--onedrive device ends-->
            	    <!--exchange device start-->
	    <div role="tabpanel" class="tab-pane <?php echo $data['activeTabExchange'];?>" id="exchange">	    
	    <div class="panel nodeviceExchange1" style="display:none">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_assets', 'keywords');?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center"><?=Language::show('noAssets', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
            </div>
	    <div class="panel hasDevicesExchange" style="display:none;">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_assets', 'keywords');?>
			<?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('Exchange')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Assets</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('Exchange')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Assets</a>
                        <?php } ?>
			<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
				<?php if(block == false){ ?>
				    <a class="btn btn-primary btn-small pull-right" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
				<?php } else {?>
				<?php if(!isMobile()){ ?>
				    <a class="btn btn-primary btn-small pull-right" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
				<?php }else { ?>
				    <a class="btn btn-primary btn-small" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
				<?php } ?>
				<?php } ?>
			<?php } ?>                        
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">                        
			<form class="col-lg-12" ng-submit="searchDeviceExchange1(search.deviceNameExchange)" data-parsley-validate>
				<div class="row">
				    <div class="col-lg-12">
					<select class="searchDeviceNameExchange" id="deviceNameExchange" style="width: 100%;" ng-model="search.deviceNameExchange" data-parsley-trigger="change" multiple="multiple"></select>
				    </div>
				    <!--<div class="col-lg-2">
					<button type="submit" class="btn btn-default">Search</button>
				    </div>-->
				</div>
                        </form>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loadingExchange text-center">Loading.....</div>
                        <div class="h4 nodeviceExchange text-center" style="display: none;">No asset matched</div>
                        <table class="table table-bordered table-striped deviceExchangeListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>
                                <th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('Asset Name', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                    <?=Language::show('status', 'keywords')?>
                                    <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devicesExchange | orderBy:sortType:sortReverse">
                                <!--<td class="text-center" ng-click="openFilesPage(value.deviceId, value.deviceName, value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.unusualActivity)" style="cursor:pointer;" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>-->
				<td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>
                                <td title="{{ value.deviceName }}" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak class="text-center">
                                    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.blocked == false && value.decoupled == false && value.quarantineDevice == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == true && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == false && value.decoupled == true && value.quarantineDevice == false"><?=Language::show('Decoupled', 'keywords')?></label></h5>
				    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.quarantineDevice == true"><?=Language::show('Quarantined', 'keywords')?></label></h5>
                                </td>
                                <td>
                                    <span class="d-none ownerFor{{value.deviceId}}" id="ownerFor{{value.deviceId}}">{{value.ownerList}}</span>
                                    <a ng-click="properties(value.deviceUUID, 'EXCHANGE')" class="btn btn-small btn-default hide">Properties</a>
				    <button ng-click="logAction(value.deviceUUID,value.deviceType)" class="btn btn-small btn-default hide" ng-class="[{true:'not-allowed'}[value.blocked],{true:'not-allowed'}[value.decoupled]]">Actions</button>
				    <?php if($data['readOnlyAdminUser'] == 'No'){ ?>					
					    <a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName, 'exchange')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform unblock operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>"
					       ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName, 'exchange')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>				   
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform delete operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName, 'exchange')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == false"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userNameForSearch}}/{{value.deviceNameEncoded}}')?>" style="margin: 5px;"><?=Language::show('Manage Asset', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userNameForSearch}}/{{ value.deviceUUID }}/{{ value.deviceNameEncoded }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
					    <a ng-hide="value.showAssignDevices == false" class="btn btn-primary btn-small" name="{{value.deviceUUID}}" id="{{value.deviceId}}" title="{{value.deviceNameNew}}" onclick="addCurrentOwner(this.id, this.title, this.name)">Assign additional owners</a>					
				    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <?php if(RESTORE_FROM_PORTAL){ ?>
                                            <a ng-click="initiateRestoreBackup(value.deviceUUID, value.deviceName, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Entire Device</a>
                                            <a ng-click="sendMeTo('<?=Url::basePath("backup/files/restore")?>/'+value.deviceId+'/'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Selected Files</a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row deviceExchangeListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountExchange}} of {{totalpageCountExchange}}</span></p>
                            <a class="btn btn-primary firstExchange" title="First" ng-click="updateDevicesExchangeNavigate('all',firstExchange)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousExchange" title="Previous" ng-click="updateDevicesExchangeNavigate('all',previousExchange)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextExchange" title="Next" ng-click="updateDevicesExchangeNavigate('all',nextExchange)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastExchange" title="Last" ng-click="updateDevicesExchangeNavigate('all',lastExchange)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>                    
                </div>
            </div>            
            </div>
            <!--exchange device ends-->
            	    <!--sharepoint device start-->
	    <div role="tabpanel" class="tab-pane <?php echo $data['activeTabSharepoint'];?>" id="sharepoint">	    
	    <div class="panel nodeviceSharepoint1" style="display:none">
                <div class="panel-heading">
                    <h4>
			<?=Language::show('List of SharePoint Sites', 'keywords');?>
			<a ng-click="configureSites()" class="btn btn-small pull-right hide" style="margin-top: 2px;margin-right: 10px;">Configure Sites</a>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
			    <h2 align="center"><?=Language::show('No Sites Configured', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
            </div>
	    <div class="panel hasDevicesSharepoint" style="display:none;">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('List of SharePoint Online Sites', 'keywords');?>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportSitesToExcel()" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Sites</a>
                        <?php } else { ?>
                            <a ng-click="exportSitesToExcel()" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Sites</a>
			<?php } ?>
			<!--<a ng-click="configureSites()" class="btn btn-small pull-right" style="margin-top: 2px;margin-right: 10px;">Configure Sites</a>-->
                    </h4>
                </div>
                <div class="panel-body col-lg-12">
                    <div class="row">                        
			<form class="col-lg-12" ng-submit="searchDeviceSharepoint1(search.deviceNameSharepoint)" data-parsley-validate>
				<div class="row">
				    <div class="col-lg-12">
					<select class="searchDeviceNameSharepoint" id="deviceNameSharepoint" style="width: 100%;" ng-model="search.deviceNameSharepoint" data-parsley-trigger="change" multiple="multiple"></select>
				    </div>
				    <!--<div class="col-lg-2">
					<button type="submit" class="btn btn-default">Search</button>
				    </div>-->
				</div>
                        </form>
                    </div>
		    <br/>
<div class="row">
                    <div class="table-responsive col-lg-12">
                        <div class="h4 loadingSharepoint text-center">Loading.....</div>
                        <div class="h4 nodeviceSharepoint text-center" style="display: none;">No device matched</div>
                        <table class="table table-bordered table-striped deviceSharepointListTable" style="display: none;">
                            <thead>
                            <tr>
<!--                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>-->
                                <th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('Site', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
<!--                                <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>-->
                                <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                    <?=Language::show('status', 'keywords')?>
                                    <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devicesSharepoint | orderBy:sortType:sortReverse">
				<!--<td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>-->
                                <!--<td title="{{ value.deviceName }}" ng-click="openFilesPage(value.deviceId, value.deviceName, value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.unusualActivity)" style="cursor:pointer;" ng-cloak>{{ value.deviceName | limitTo:50}}{{value.deviceName.length > 50 ? '...' : ''}}</td>-->
				    <td title="{{ value.deviceName }}" ng-cloak>{{ value.deviceName | limitTo:50}}{{value.deviceName.length > 50 ? '...' : ''}}</td>
				<!--<td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>-->
                                <td ng-cloak class="text-center">
                                    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.blocked == false && value.decoupled == false && value.quarantineDevice == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == true && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.blocked == false && value.decoupled == true && value.quarantineDevice == false"><?=Language::show('Decoupled', 'keywords')?></label></h5>
				    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.quarantineDevice == true"><?=Language::show('Quarantined', 'keywords')?></label></h5>
                                </td>
                                <td>
				    <span class="d-none ownerFor{{value.deviceId}}" id="ownerFor{{value.deviceId}}">{{value.ownerList}}</span>
				    <a class="btn btn-default btn-small" href="<?=Url::basePath('user/settings/{{ value.userNameForView }}')?>"><i class="fa fa-edit"></i> <?=Language::show('Edit Site', 'keywords');?></a>
                                    <a ng-click="properties(value.deviceUUID, 'SHAREPOINT')" class="btn btn-small btn-default hide">Properties</a>
				    <button ng-click="logAction(value.deviceUUID,value.deviceType)" class="btn btn-small btn-default hide" ng-class="[{true:'not-allowed'}[value.blocked],{true:'not-allowed'}[value.decoupled]]">Actions</button>
				    <?php if($data['readOnlyAdminUser'] == 'No'){ ?>					
					    <a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName ,'site')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform unblock operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action="" class="btn btn-small btn-success hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>"
					       ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName, 'site')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'No'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>				   
					    <a ng-bootbox-alert="<h4><?=Language::show('Please assign device back to original owner to perform delete operation.', 'keywords')?></h4>"
					       ng-bootbox-alert-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == true && value.deviceAssigned == 'Yes'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>
					    <a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>"
					       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName, 'site')"
					       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger hide" ng-if="value.blocked == false"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userNameForSearch}}/{{value.deviceNameEncoded}}')?>" style="margin: 5px;"><?=Language::show('Manage Site', 'keywords');?></a>
					    <a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userNameForSearch}}/{{ value.deviceUUID }}/{{ value.deviceNameEncoded }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
					    <a ng-hide="value.showAssignDevices == false" class="btn btn-primary btn-small hide" name="{{value.deviceUUID}}" id="{{value.deviceId}}" title="{{value.deviceNameNew}}" onclick="addCurrentOwner(this.id, this.title, this.name)">Assign additional owners</a>					
				    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <?php if(RESTORE_FROM_PORTAL){ ?>
                                            <a ng-click="initiateRestoreBackup(value.deviceUUID, value.deviceName, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Entire Device</a>
                                            <a ng-click="sendMeTo('<?=Url::basePath("backup/files/restore")?>/'+value.deviceId+'/'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Selected Files</a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
		    </div>
<div class="col-lg-2 hide">
<center>
<a ng-click="itemSelect1()" class="block btn btn-success">&#8249; Add </a>
<br>
<a ng-click="itemSelect1()" class="block btn btn-success">&#8810; Add</a>
<!--                                    <br>
                                    <a ng-click="removeName1()" class="block btn btn-danger">< Remove</a>
                                    <br>
				    <a ng-click="removeAllName()" class="block btn btn-danger"><< Remove All</a>-->
</center>
</div>
<div class="col-lg-4 hide" style="border: 1px dotted #f27331;overflow:scroll;height:300px">
				    <table id="addedElements" class="table table-hover table-bordered">
                                        <thead ng-show="addedElements.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Discovered Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedElements.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Users Selected</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="addedElements.length > 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedElements.length > 0">
                                            <tr ng-repeat="value1 in addedElements" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(value1, $index)" ng-cloak><span style="cursor: pointer;">{{ value1 }}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
</div>
</div>
                    <div class="row deviceSharepointListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountSharepoint}} of {{totalpageCountSharepoint}}</span></p>
                            <a class="btn btn-primary firstSharepoint" title="First" ng-click="updateDevicesSharepointNavigate('all',firstSharepoint)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousSharepoint" title="Previous" ng-click="updateDevicesSharepointNavigate('all',previousSharepoint)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextSharepoint" title="Next" ng-click="updateDevicesSharepointNavigate('all',nextSharepoint)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastSharepoint" title="Last" ng-click="updateDevicesSharepointNavigate('all',lastSharepoint)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>                    
                </div>
            </div>            
            </div>
            <!--sharepoint device ends-->
            </div>
            
        </div>
    </div>
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
			<h4 class="modal-title">Restore Bucket</h4>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade configureSites">
        <div class="modal-dialog" style="width:1250px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Configure Sites</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <!--added starts-->
                    <div class="usersFound">
			    <div class="table-responsive browsePathDivOnedrive col-lg-12">
				<div class="row col-lg-12">
					<div class="checkbox check-primary">
                             			<input id="autoDiscover" name="autoDiscover" id="autoDiscover" type="checkbox" value="enabled">
                             			<label for="autoDiscover"><?=Language::show('Auto discover and configure SharePoint sites.', 'keywords');?></label>                             	
                             		</div>
				</div>
			        <div class="row col-lg-12">
                                <div class="col-lg-5" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                	Discovered SharePoint Sites
                                                	<span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                	<span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in discoveredSites | orderBy:sortTypeSites:sortReverseSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
                                                <td ng-click="pickElement(value, $index)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
				<div class="col-lg-2">
<center style="margin-top:50%;">
                                    <a ng-click="itemSelect1()" class="block btn btn-small btn-success" style="width: 50%;">><a>
				    <br>
				    <a ng-click="addAllName()" class="block btn btn-small btn-success" style="width: 50%;"> >><a>
				    <br>
                                    <a ng-click="removeName1()" class="block btn btn-small btn-danger" style="width: 50%;"><</a>
                                    <br>
				    <a ng-click="removeAllName()" class="block btn btn-small btn-danger" style="width: 50%;"><<</a>
</center>
                                </div>
                                <div class="col-lg-5" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="addedSites" class="table table-hover table-bordered">
                                        <thead ng-show="addedSites.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected SharePoint Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedSites.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Sites Selected</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="addedSites.length > 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedSites.length > 0">
                                            <tr ng-repeat="value1 in addedSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(value1, $index)" ng-cloak><span style="cursor: pointer;">{{ value1 }}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-6">
				</div>
</div>
                            </div>
			    <div class="col-lg-12" style="margin-top:5%;">
<div class="row">
				<div class="col-lg-6">
				</div>
                                <div class="col-lg-6">
                                    <div class="form-group" style="margin-left:10%;">
                                        <!--<label for="bucketName"><?=Language::show('Change Storage repository', 'keywords');?></label><br/>
					<input type="text" value="" class="form-control bucketName" name="bucketName" id="bucketName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Destination OneDrive for Business account', 'keywords');?>" required autocomplete="off">-->
					<label for="policyName"><?=Language::show('SharePoint Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
				</div>
				<div class="col-lg-6">
				</div>
                                <div class="col-lg-6">
                                    <a class="btn btn-success btn-small pull-right"
                                        ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to configure selected sites to the selected policy?', 'keywords')?></h4>"
                                        ng-bootbox-confirm-action="startSiteConfiguration()"
                                        ng-bootbox-confirm-action-cancel=""
					href="javascript:;"><?=Language::show('Configure Sites', 'keywords');?></a>
<button type="button" class="btn btn-default btn-small pull-right" data-dismiss="modal" style="margin-right:10px;">Close</button>
				</div>
</div>
                            </div>
                        </div>
                        <!--added ends-->
                </div>
                <div class="modal-footer hide">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade deviceDetails">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
		    <h4 class="modal-title">Device Details</h4>
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <p><b>Created At</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.createdTimeStamp }}</span></p>
                    <p><b>Name</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.deviceName }}</span></p>
                    <p><b>Os Type</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.osType }}</span></p>
                    <p ng-if="selectedDevice.decoupled == 'true'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">Yes</span></p>
                    <p ng-if="selectedDevice.decoupled == 'false'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">No</span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade blockedUsersWarning" id="blockedUsersWarning" style="z-index:12000;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Operation could not be completed</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <p><b>Assign owners operation failed as one or more users are blocked</b></p>
                    <div id="blockedUsersListDiv">
                        <ul>
                                <li ng-repeat="item in blockedUsersList" ng-cloak>{{item}}</li>
                        <ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="ownerShipChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'ownerShipForm',
                'autocomplete' => 'off',
                'ng-submit' => 'changeDeviceOwner()',
                ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
		    <h4 class="modal-title">Assign additional owners to manage the selected Asset</h4>
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="deviceNamee">Asset Name : </label>
                        <span name="deviceNamee" id="deviceNamee"></span>
                    </div>
                    <div class="form-group d-none">
                        <label for="deviceName"></label>
                        <input name="deviceName" id="ownerShipMiniCloud" type="text"/>
                    </div>
		    <div class="form-group d-none">
                        <label for="blockedUsers"></label>
                        <span name="blockedUsers" id="blockedUsers"></span>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="form-control ownerShipChange" style="width: 100%;" name="owner[]" id="selectOwnerShip" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary changeOwnerSaveBtn">Save changes</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
    <div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h4 class="modal-title">Device Actions</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>					
					<span class="d-none" id="actionToUserName"></span>
					<span class="d-none" id="actionToDeviceUUID"></span>
					<span class="d-none" id="deviceType"></span>
					<div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="row col-lg-12" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
                            			<center>
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
                            			</center>
 						</div>
 					</div>
 					<?php } ?>
					<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="row col-lg-12" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                <center>
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </center>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="row col-lg-12 agLogs" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                            </center>
                        </div>
                    </div>
                    <div class="row col-lg-12 fBackup" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </center>
                        </div>
                    </div>
		     <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <input class="d-none" id="startBackupGet" name="startBackupGet" type="text" value="">
		     <div class="row col-lg-12 <?php if($data['readOnlyAdminUser'] == 'Yes'){ ?>hide<?php } ?>" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Start Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">
                                    <center>
                             			<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()">Start Backup</a>
                             			<a ng-if="buttonValue=='stopBackup'" class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Backup', 'keywords');?></a>
                                        <a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()">Pause Backup</a>
                             			<a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()">Cancel Schedule</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
		    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		    <input class="d-none" id="startRestoreGet" name="startRestoreGet" type="text" value="">
                    <div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
                                                <a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
                                                <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
<!--                                        <a ng-if="buttonPauseValueRestore=='pauseRestore'" class="btn btn-small btn-danger pauseRestore" id="pauseRestore" name="pauseRestore" val="false" ng-click="pauseRestoreButton()">Pause Restore</a>-->
                                                <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
                    <div class="row col-lg-12 stopBackupWhileRestoreBlock d-none">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/DeviceController.js" type="text/javascript"></script>
<script>
    $('#agentLogs').on('change', function(){
        $('#saveBtn').removeClass('disabled');
            if($(this).prop('checked')){
                $('#historicalLogsBlock').show();
            }else{
                $('#historicalLogsBlock').hide();
                //$('#historicalLogs').prop('checked',false);
            }
    });
    $("#stopBackupWhileRestore").click(function(){
        $('#saveBtn').removeClass('disabled');
    });
</script>
<style>
.not-allowed {
    pointer-events: none !important; 
    opacity : 0.5 !important;
}
</style>
<script>
$('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevicesForDeviceList",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Devices'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }
	
    function selectTemplateSelection(users){
        return users.text;
    }

    $('.searchDeviceNameOneDrive').select2({
    ajax: {
    url: "<?=DIR?>"+"getDevicesPt",
            dataType: 'json',
	    //delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
		    params.page = params.page || 1;
		    console.log("data : "+JSON.stringify(data));
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResultOneDrive,
        templateSelection: selectTemplateSelectionOneDrive,
        placeholder: 'Select Devices'
    });

    function selectTemplateResultOneDrive(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOneDrive(users){
        return users.text;
    }

    $('.searchDeviceNameExchange').select2({
    ajax: {
    url: "<?=DIR?>"+"getDevicesExchangePt",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                    params.page = params.page || 1;
                    console.log("data : "+JSON.stringify(data));
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResultExchange,
        templateSelection: selectTemplateSelectionExchange,
        placeholder: 'Select Devices'
    });

    function selectTemplateResultExchange(users){
        if(users.text != undefined){
        	var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionExchange(users){
        return users.text;
    }
	
    function selectTemplateSelectionOwner(users){
            //console.log("users.active : "+users.active);
            //var miniClouds = $('#ownerFor'+deviceId).html().split(',');
            //console.log("miniClouds : "+miniClouds);
            if(users.active == false){
                    if($('#blockedUsers').html() != ''){
			    var miniClouds1 = $('#blockedUsers').html().split(',');
			    //console.log("miniclouds1 : "+miniClouds1);
			    miniClouds1.push(users.text);
			    document.getElementById("blockedUsers").innerHTML = miniClouds1;
			    //$('[name="blockedUsers"]').val(users.text);
			    //console.log("got blocked user");
                    }else{
			    document.getElementById("blockedUsers").innerHTML = users.text;
                    }
                    document.getElementById("blockedUsers").innerHTML = removeDuplicates($('#blockedUsers').html().split(','));                 
            }
            console.log("selectOwnerShip : "+$('#selectOwnerShip').val());
            if($('#blockedUsers').html() != ''){
                    var miniClouds1 = $('#blockedUsers').html().split(',');
                    miniClouds1.forEach(function(key){
                            if(!$('#selectOwnerShip').val().includes(key)){
                                    //console.log("key : "+key);
                                //miniClouds1.remove(key);
                                    var index = miniClouds1.indexOf(key);
                                    //console.log("index : "+index);
                                    if (index >= 0) {
                                            console.log("spliceeee");
                                  miniClouds1.splice( index, 1 );
                                }
                        }
                    });
		    //console.log("miniClouds1 : "+miniClouds1);
                    document.getElementById("blockedUsers").innerHTML = miniClouds1;

            }
        return users.text;
    }
	
    function removeDuplicates(arr) {
        return arr.filter((item,
            index) => arr.indexOf(item) === index);
    }
    
    //new start
    var owner = $(".ownerShipChange").select2({
    //        maximumSelectionLength: 1,
        ajax: {
	    url: "<?=DIR?>"+"user/searchUserWithDeviceOwner",	
            //url: "<?=DIR?>"+"user/getAllUnBlockedUsersWithLoggedInUser",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.changeOwnerSaveBtn').removeAttr('disabled', 'disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, active: o.active };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelectionOwner,
	minimumInputLength: 3,
        placeholder: 'Select a Owner'
    });

    function addCurrentOwner(deviceId, deviceName, deviceUUID) {
	var abc = deviceUUID;
        //console.log("called addcurrentowner : "+deviceUUID);
        //console.log("called addcurrentowner : "+devicName);
        owner.val(null).trigger("change");
        var miniClouds = $('#ownerFor'+deviceId).html().split(',');
//var miniClouds = [];
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                //console.log("inside :"+value);
                $('#selectOwnerShip').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="deviceName"]').val(abc);
        document.getElementById("deviceNamee").innerHTML = deviceName;
        $('#ownerShipChange').modal('show');
        owner.val(miniClouds).trigger("change");
    }

    $('#ownerShipChange').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });
    
//new end

$("#agentLogs").click(function(){
$('#saveBtn').removeClass('disabled');
});

$("#historicalLogs").click(function(){
$('#saveBtn').removeClass('disabled');
});

$("#setupLogs").click(function(){
$('#saveBtn').removeClass('disabled');
});

$("#databases").click(function(){
$('#saveBtn').removeClass('disabled');
});

document.getElementById('agentLogs').addEventListener('click', function(){
    $('#saveBtn').removeClass('disabled');
});
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 45%;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(70px);
  -ms-transform: translateX(70px);
  transform: translateX(70px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
$(function () {
  $('.ios').tooltip({ trigger: 'click' });
});

$(".searchDeviceNameSharepoint").select2({
        ajax: {
            url: "<?=DIR?>"+"getDevicesSharepointPt",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultSites,
	templateSelection: selectTemplateSelectionSites,
	minimumInputLength: 3,
        placeholder: 'Select sites'
    });

    function selectTemplateResultSites(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionSites(users){
        return users.text;
    }
	
    function searchDiscoveredSite() {
  	var input, filter, table, tr, td, i, txtValue;
  	input = document.getElementById("searchDiscoveredSite");
  	filter = input.value.toUpperCase();
  	table = document.getElementById("discoveredSites");
  	tr = table.getElementsByTagName("tr");
  	for (i = 0; i < tr.length; i++) {
    		td = tr[i].getElementsByTagName("td")[1];
    		if (td) {
      			txtValue = td.textContent || td.innerText;
      			if (txtValue.toUpperCase().indexOf(filter) > -1) {
        			tr[i].style.display = "";
      			} else {
        			tr[i].style.display = "none";
      			}
    		}
  	}
    }

    function searchConfiguredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchConfiguredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("addedSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }
</script>
