<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 28/10/2022
* @time 18:30 PM
*
*/
?>
<div class="container">
    <div>
        <div class="col-lg-6">
	    <ol class="breadcrumb">
		<li><h3><?='Manage Assets'?></h3></li>
                <!--<li><h3><?=$data['title']?></h3></li>-->                
            </ol>
        </div>
        <div class="col-lg-6">
        </div>
    </div>
</div>
<div class="main" ng-controller="BackupController">
    <span class="d-none currentPage"><?='manageDevices'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="d-none selectedUser"><?=$data['selectedUser']?></span>
    <span class="d-none userType"><?=$data['userType']?></span>
    <span class="d-none rwDetectionEnabled"><?=$data['rwDetectionEnabled']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <!--<div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav">
                        <li class="listOfDevices"><a style="color: #000 !important;">List of All Devices</a></li>
                    </ul>
                </div>
	    </div>-->
            <!--new start-->
            <?php if(isMobile()){ ?>
		    <ul class="nav nav-pills flex-column" id="assetsTabs" style="border: 1px solid #EC6621;border-radius: 10px;">
			<?php if(Auth::checkCloudPermission('backup')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a id="backupT" class="nav-link" data-target="#backup" aria-controls="backup" aria-expanded="true" data-toggle="tab" ng-click="changeTab('backup')">BluVault</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('exchange')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a id="exchangeT" class="nav-link" data-target="#exchange" aria-controls="exchange" aria-expanded="false" data-toggle="tab" ng-click="changeTab('Exchange')">Microsoft Exchange</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('onedrive')){ ?>
                            <li class="nav-item" style="display:unset !important;"><a id="onedriveT" class="nav-link" data-target="#onedrive" aria-controls="onedrive" aria-expanded="false" data-toggle="tab" ng-click="changeTab('ODB')">OneDrive for Business</a></li>
                        <?php } ?>
			<?php if(Auth::checkCloudPermission('sharepoint')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a id="sharepointT" class="nav-link" data-target="#sharepoint" aria-controls="sharepoint" aria-expanded="false" data-toggle="tab" ng-click="changeTab('Sharepoint')">SharePoint Online</a></li>
			<?php } ?>			
		    </ul>
            <?php } ?>
            <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" id="assetsTabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">                
                        <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="backupT" class="nav-link" data-target="#backup" aria-controls="backup" role="tab" data-toggle="tab" ng-click="changeTab('backup')">BluVault</a></li>
			<?php } ?>
			<?php if($data['Windows_Server_Backup_Enabled'] == 'yes'){ ?>
			<li role="presentation" class="nav-item hide"><a href="" id="serverT" class="nav-link" data-target="#server" aria-controls="backup" role="tab" data-toggle="tab" ng-click="changeTab('Server')">Servers</a></li>
			<?php } ?>
                        <?php if(Auth::checkCloudPermission('exchange')){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="exchangeT" class="nav-link" data-target="#exchange" aria-controls="exchange" role="tab" data-toggle="tab" ng-click="changeTab('Exchange')">Microsoft Exchange</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('onedrive')){ ?>
                            <li role="presentation" class="nav-item"><a href="" id="onedriveT" class="nav-link" data-target="#onedrive" aria-controls="onedrive" role="tab" data-toggle="tab" ng-click="changeTab('ODB')">OneDrive for Business</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sharepoint')){ ?>			    
			    <li role="presentation" class="nav-item"><a href="" id="sharepointT" class="nav-link" data-target="#sharepoint" aria-controls="sharepoint" role="tab" data-toggle="tab" ng-click="changeTab('Sharepoint')">SharePoint Online</a></li>
                        <?php } ?>                        
                    </ul>
            <?php } ?>
            <!--new end-->		
<div class="modal fade" id="includeLastSuccessfulBackupConfirmModal" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Information</h4>
                        </div>
                        <div class="modal-body">
                                <p>This operation can take a bit longer. Please confirm to proceed.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-right" ng-click="includeLastSuccessfulBackupCancel()">Cancel</button>
                            <a class="btn btn-small btn-primary" ng-click="includeLastSuccessfulBackupConfirm()">Proceed</a>
                        </div>
                    </div>
                </div>
</div>
<div class="modal fade" id="includeLastSuccessfulBackupServerConfirmModal" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Information</h4>
                        </div>
                        <div class="modal-body">
                                <p>This operation can take a bit longer. Please confirm to proceed.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-right" ng-click="includeLastSuccessfulBackupServerCancel()">Cancel</button>
                            <a class="btn btn-small btn-primary" ng-click="includeLastSuccessfulBackupServerConfirm()">Proceed</a>
                        </div>
                    </div>
                </div>
</div>
<div class="modal fade" id="includeLastSuccessfulBackupODBConfirmModal" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Information</h4>
                        </div>
                        <div class="modal-body">
                                <p>This operation can take a bit longer. Please confirm to proceed.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-right" ng-click="includeLastSuccessfulBackupODBCancel()">Cancel</button>
                            <a class="btn btn-small btn-primary" ng-click="includeLastSuccessfulBackupODBConfirm()">Proceed</a>
                        </div>
                    </div>
                </div>
</div>
<div class="modal fade" id="includeLastSuccessfulBackupExchangeConfirmModal" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Information</h4>
                        </div>
                        <div class="modal-body">
                                <p>This operation can take a bit longer. Please confirm to proceed.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-right" ng-click="includeLastSuccessfulBackupExchangeCancel()">Cancel</button>
                            <a class="btn btn-small btn-primary" ng-click="includeLastSuccessfulBackupExchangeConfirm()">Proceed</a>
                        </div>
                    </div>
                </div>
</div>
<div class="modal fade" id="includeLastSuccessfulBackupSharepointConfirmModal" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Information</h4>
                        </div>
                        <div class="modal-body">
                                <p>This operation can take a bit longer. Please confirm to proceed.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-right" ng-click="includeLastSuccessfulBackupSharepointCancel()">Cancel</button>
                            <a class="btn btn-small btn-primary" ng-click="includeLastSuccessfulBackupSharepointConfirm()">Proceed</a>
                        </div>
                    </div>
                </div>
</div>                                    
            <div class="tab-content">
		<div role="tabpanel" class="tab-pane" id="backup">
		<!--backup start-->
		<div class="panel panel-default files-panel no-box-shadow">
                <div class="status" style="display: none; text-align: center;margin:20px;">Loading ...</div>
		<div class="table-responsive devicesList" style="display: none;">
		    <div class="panel-heading">
			<div class="col-lg-12" block-ui="myBlockUI">
                        	<div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                	<div class="background"></div>
                                        <div class="panel-body widget widget-body">
                                        	<span style="font-size: 20px;margin-top: -20px;color:white;">Total BluVault Assets</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ bluvaultAssetCount }}</span>
                                        </div>
                                </div>
                        </div>
                        <h4>
			<?=Language::show('list_of_assets', 'keywords');?>
			<div class="checkbox check-primary includeLastSuccessfulBackupdiv pull-right hide">
                                <input id="includeLastSuccessfulBackup" name="includeLastSuccessfulBackup" type="checkbox" value="enabled" ng-click="includeLastSuccessfulBackup('backup')">
                                <label for="includeLastSuccessfulBackup"><?=Language::show('Include Last Successful Backup', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="left" title="Show Last Successful Backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        </div>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('backup')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Assets</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('backup')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Assets</a>
                        <?php } ?>
                        <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                <?php if(block == false){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } else {?>
                                <?php if(!isMobile()){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php }else { ?>
                                    <a class="btn btn-primary btn-small <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } ?>
                                <?php } ?>
                        <?php } ?>                        
                        </h4>
                    </div>
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchBluvaultInput" onkeyup="searchedBluvaultDevices()" placeholder="Search for Assets.." title="Type in a Asset Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Asset Name
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                User Name
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Asset Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <!--<th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>-->
                        </tr>
                        </thead>
                        <tbody>
			<tr ng-repeat-start="value in devices | orderBy:sortType:sortReverse track by $index">
			    <?php if($data['view'] == 'no'){?>
			    <td ng-if="'<?=$data['selectedUser']?>' != value.userNamePlain" class="text-left" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span>{{ value.displayName  | limitTo:20 }}{{value.displayName.length > 20 ? '...' : ''}}</span></td>
			    <td ng-if="'<?=$data['selectedUser']?>' == value.userNamePlain" class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.displayName  | limitTo:20 }}{{value.displayName.length > 20 ? '...' : ''}}</span></td>
			    <?php } else { ?>
			    <td class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.displayName  | limitTo:20 }}{{value.displayName.length > 20 ? '...' : ''}}</span></td>
			    <?php } ?>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-cloak>
				<h5><label style="width: 70px;" class="badge badge-success" ng-if="value.status == 'Active' && value.quarantineDevice == false && value.decoupled == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Blocked' && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
				<h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Decoupled'"><?=Language::show('Decoupled', 'keywords')?></label></h5>
			    </td>
                            <td class="text-left" ng-cloak>{{ value.createdOn}}</td>
			    <td class="text-left" ng-cloak>
				<!--<span id="lastSpanbackup{{$index}}"><a style="margin-top: 5px;" class="btn btn-primary btn-small loadLastSuccessfulBackupBtnbackup{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'backup')" title="Get Last Successful Backup Time">Load</a></span>-->
				<a class="btn btn-small btn-primary <?php if($data['view'] == 'no'){?> hide <?php } ?>" title="Show Actions" id="showMore_{{value.uuId}}" ng-click="showActionsBluvault(value.uuId)" style="border-radius: 20px;"><i class="fa fa-ellipsis-h fa-1x"></i></a>
			    </td>
			</tr>
			<tr ng-repeat-end style="display:none;" id="collapse{{value.uuId}}">
			    <td class="text-center" colspan="6" style="border:unset;border-bottom: 2px solid black;padding: 5px 15px 5px 15px;">
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userName}}/{{value.nameEncoded}}')?>" style="margin-right:10px;"><?=Language::show('Manage Asset', 'keywords');?></a>
				<a ng-if="(value.blocked == false && value.decoupled == false)" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="margin-right:10px;">Backup Management</a>
<?php if($data['userType'] != 'superAdmin'){ ?>
				<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>
<?php } ?>
				<?php //if($data['showRestore'] == 'no'){?>
				    <!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;">Restore</a>-->
				<?php //} ?>
				<?php //if($data['showRestore'] == 'yes'){?>
				    <?php //if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
				    	<!--<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>-->
				    <?php //}else{ ?>
				    	<!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>-->
				    <?php //} ?>
				<?php //} ?>
				<!--<a ng-click="initiateRestoreForDeviceManage(value.uuId,value.deviceType, value.quarantineDevice, value.blocked, value.userNamePlain, value.name)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" style="margin-right:10px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
				<a ng-hide="value.showAssignDevices == false" class="btn btn-primary btn-small" name="{{value.uuId}}" id="{{value.id}}" title="{{value.nameNew}}" onclick="addCurrentOwner(this.id, this.title, this.name)" style="margin-right:10px;">Assign additional owners</a>
				<span class="d-none ownerFor{{value.id}}" id="ownerFor{{value.id}}">{{value.ownerList}}</span>
				<span class="d-none userName{{value.id}}" id="userName{{value.id}}">{{value.userNamePlain}}</span>
				<span class="btn btn-primary btn-small" id="lastSpanbackup{{$index}}"><a class="loadLastSuccessfulBackupBtnbackup{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'backup')" title="Show Last Successful Backup Time">Show Last Successful Backup Time</a></span>
			    </td>
                        </tr>
                        </tbody>
		    </table>
		    <div id="noResultsMessageDevice" style="display:none;text-align: center;margin:20px;">No match found</div>
		</div>
		<div class="row devicesListTableNavigate hide">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="manageDevicesNavigate('backup', first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="manageDevicesNavigate('backup', previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="manageDevicesNavigate('backup', next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="manageDevicesNavigate('backup', last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
		    <!--backup ends--> 
		    </div>
		    <div role="tabpanel" class="tab-pane" id="server">
                <!--server start-->
                <div class="panel panel-default files-panel no-box-shadow">
                <div class="status" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive serversList" style="display: none;">
                    <div class="panel-heading">
                        <div class="col-lg-12" block-ui="myBlockUI">
                                <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                        <div class="background"></div>
                                        <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Total Servers</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ serverAssetCount }}</span>
                                        </div>
                                </div>
                        </div>
                        <h4>
			<?=Language::show('List of Servers', 'keywords');?>
			<div class="checkbox check-primary includeLastSuccessfulBackupServerdiv pull-right hide">
                                <input id="includeLastSuccessfulBackupServer" name="includeLastSuccessfulBackupServer" type="checkbox" value="enabled" ng-click="includeLastSuccessfulBackupServer('SERVER')">
                                <label for="includeLastSuccessfulBackupServer"><?=Language::show('Include Last Successful Backup', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="left" title="Show Last Successful Backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        </div>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('SERVER')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Assets</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('SERVER')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Assets</a>
                        <?php } ?>
                        <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                <?php if(block == false){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } else {?>
                                <?php if(!isMobile()){ ?>
				    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
			<?php }else { ?>
                                    <a class="btn btn-primary btn-small <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } ?>
                                <?php } ?>
                        <?php } ?>                        
                        <a ng-click="addNewServer()" class="btn btn-small btn-primary pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px;">Add Server</a>
                        </h4>
                    </div>
                    <div class="form-group col-lg-12" style="margin-top:10px;">
                        <input class="form-control" type="text" id="searchServerInput" onkeyup="searchedServerDevices()" placeholder="Search for Servers.." title="Type in a Server Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="serversListTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortTypeS = 'name'; sortReverse = !sortReverse">
                                Server Name
                                <span ng-show="sortTypeS == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeS == 'name' && sortReverse" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeS = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortTypeS == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeS == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeS = 'createdOn'; sortReverse = !sortReverse">
                                Server Configured on
                                <span ng-show="sortTypeS == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeS == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeS = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortTypeS == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeS == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
			<tbody>
			<tr ng-repeat-start="value in servers | orderBy:sortTypeS:sortReverse track by $index">
			    <?php if($data['view'] == 'no'){?>
			    <td ng-if="'<?=$data['selectedUser']?>' != value.userNamePlain" class="text-left" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span>{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <td ng-if="value.class != 'greyout' && '<?=$data['selectedUser']?>' == value.userNamePlain" class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
                            <?php } else { ?>
			    <td ng-if="value.class != 'greyout'" class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <?php } ?>
                            <td ng-if="value.class == 'greyout'" ng-class="{ 'greyBck': value.class == 'greyout' }" class="text-left clickAble" title="{{ value.name }}" ng-cloak>{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</td>
                            <td ng-if="value.class != 'greyout'" class="text-left" ng-cloak>
                                <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.status == 'Active' && value.quarantineDevice == false && value.decoupled == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Blocked' && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Decoupled'"><?=Language::show('Decoupled', 'keywords')?></label></h5>
                            </td>
                            <td ng-if="value.class == 'greyout'" class="text-left greyBck" ng-cloak>{{ value.status}}</td>
                            <td ng-class="{ 'greyBck': value.class == 'greyout' }" class="text-left" ng-cloak>{{ value.createdOn}}</td>
                            <td ng-class="{ 'greyBck': value.class == 'greyout' }" class="text-left" ng-cloak>
                                <!--<span id="lastSpanSERVER{{$index}}"><a style="margin-top: 5px;" class="btn btn-primary btn-small loadLastSuccessfulBackupBtnSERVER{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'SERVER')" title="Get Last Successful Backup Time">Load</a></span>-->
                                <a ng-if="value.class != 'greyout'" class="btn btn-small btn-primary <?php if($data['view'] == 'no'){?> hide <?php } ?>" title="Show Actions" id="showMore_{{value.uuId}}" ng-click="showActionsServer(value.uuId)" style="border-radius: 20px;"><i class="fa fa-ellipsis-h fa-1x"></i></a>
                            </td>
			</tr>
			<tr ng-repeat-end style="display:none;" id="collapse{{value.uuId}}">
                            <td class="text-center" colspan="6" style="border:unset;border-bottom: 2px solid black;padding: 5px 15px 5px 15px;">
                                <a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userName}}/{{value.nameEncoded}}')?>" style="margin-right:10px;"><?=Language::show('Manage Asset', 'keywords');?></a>
				<a ng-if="(value.blocked == false && value.decoupled == false)" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="margin-right:10px;">Backup Management</a>
<?php if($data['userType'] != 'superAdmin'){ ?>
				<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>
<?php } ?>
                                <a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" style="margin-right:10px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
                                <span class="d-none ownerFor{{value.id}}" id="ownerFor{{value.id}}">{{value.ownerList}}</span>
				<span class="d-none userName{{value.id}}" id="userName{{value.id}}">{{value.userNamePlain}}</span>
				<span class="btn btn-primary btn-small" id="lastSpanSERVER{{$index}}"><a class="loadLastSuccessfulBackupBtnSERVER{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'SERVER')" title="Show Last Successful Backup Time">Show Last Successful Backup Time</a></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <div id="noResultsMessageServer" style="display:none;text-align: center;margin:20px;">No match found</div>
                </div>
                <div class="row serversListTableNavigate hide">
                        <div class="col-lg-12 text-center">
			    <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
			    <a class="btn btn-primary first" title="First" ng-click="manageServersNavigate('Server', first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="manageServersNavigate('Server', previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="manageServersNavigate('Server', next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="manageServersNavigate('Server', last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
                    <!--server ends-->
                    </div>
		    <div role="tabpanel" class="tab-pane" id="onedrive">
		<!--onedrive start-->
		<div class="panel panel-default files-panel no-box-shadow">
                <div class="statusOneDrive" style="display: none; text-align: center;margin:20px;">Loading ...</div>
		<div class="table-responsive devicesListOneDrive" style="display: none;">
		    <div class="panel-heading">
			<div class="col-lg-12" block-ui="myBlockUI">
                                <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                        <div class="background"></div>
                                        <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Total OneDrive for Business Assets</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ onedriveAssetCount }}</span>
                                        </div>
                                </div>
                        </div>
                    	<h4>
			<?=Language::show('list_of_assets', 'keywords');?>
			<div class="checkbox check-primary includeLastSuccessfulBackupODBdiv pull-right hide">
                                <input id="includeLastSuccessfulBackupODB" name="includeLastSuccessfulBackupODB" type="checkbox" value="enabled" ng-click="includeLastSuccessfulBackupODB('ODB')">
                                <label for="includeLastSuccessfulBackupODB"><?=Language::show('Include Last Successful Backup', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="left" title="Show Last Successful Backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        </div>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('ODB')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Assets</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('ODB')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Assets</a>
                        <?php } ?>
                        <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                <?php if(block == false){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } else {?>
                                <?php if(!isMobile()){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php }else { ?>
                                    <a class="btn btn-primary btn-small <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } ?>
                                <?php } ?>
			<?php } ?>                        
			<?php if($data['oneDriveArchivingEnabled'] == 'true'){?>
			<a ng-click="getJobStatus('ODB')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Get Capacity Savings Status</a>
			<?php } ?>
                    	</h4>
                    </div>	
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchOnedriveInput" onkeyup="searchedOnedriveDevices()" placeholder="Search for Assets.." title="Type in a Asset Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListOnedriveTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Asset Name
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                User Name
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Asset Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <!--<th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>-->
                        </tr>
                        </thead>
                        <tbody>
			<tr ng-repeat-start="value in devicesOneDrive | orderBy:sortType:sortReverse track by $index">
			    <?php if($data['view'] == 'no'){?>
			    <td ng-if="'<?=$data['selectedUser']?>' != value.userNamePlain" class="text-left" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span>{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <td ng-if="'<?=$data['selectedUser']?>' == value.userNamePlain" class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
                            <?php } else { ?>
			    <td class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <?php } ?>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-cloak>
				    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.status == 'Active' && value.quarantineDevice == false && value.decoupled == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Blocked' && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
				    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Decoupled'"><?=Language::show('Decoupled', 'keywords')?></label></h5>
			    </td>
                            <td class="text-left" ng-cloak>{{ value.createdOn}}</td>
			    <td class="text-left" ng-cloak>
				<!--<span id="lastSpanODB{{$index}}"><a style="margin-top: 5px;" class="btn btn-primary btn-small loadLastSuccessfulBackupBtnODB{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'ODB')" title="Get Last Successful Backup Time">Load</a></span>-->
				<a class="btn btn-small btn-primary <?php if($data['view'] == 'no'){?> hide <?php } ?>" title="Show Actions" id="showMore_{{value.uuId}}" ng-click="showActionsOnedrive(value.uuId)" style="border-radius: 20px;"><i class="fa fa-ellipsis-h fa-1x"></i></a>
			    </td>
			</tr>
			<tr ng-repeat-end style="display:none;" id="collapse{{value.uuId}}">
			    <td class="text-center" colspan="6" style="border:unset;border-bottom: 2px solid black;padding: 5px 15px 5px 15px;">
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userName}}/{{value.nameEncoded}}')?>" style="margin-right:10px;"><?=Language::show('Manage Asset', 'keywords');?></a>
				<a ng-if="value.status == 'Active'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="margin-right:10px;">Backup Management</a>
				<a ng-if="value.status != 'Active'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="pointer-events:none;opacity:0.4;margin-right:10px;">Backup Management</a>	
<?php if($data['userType'] != 'superAdmin'){ ?>
				<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>
<?php } ?>
				<?php //if($data['showRestore'] == 'no'){?>
				<!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;margin-right:10px;">Restore</a>-->
				<?php //} ?>
				<?php //if($data['showRestore'] == 'yes'){?>
				    <?php //if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
<!--				    	<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>-->
				    <?php //}else{ ?>
<!--				    	<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>-->
				    <?php //} ?>
				<?php //} ?>
				<!--<a ng-click="initiateRestoreForDeviceOnedriveManage(value.uuId,value.deviceType, value.quarantineDevice, value.blocked, value.userNamePlain, value.name)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" style="margin-right:10px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
				<a ng-hide="value.showAssignDevices == false" class="btn btn-primary btn-small" name="{{value.uuId}}" id="{{value.id}}" title="{{value.nameNew}}" onclick="addCurrentOwner(this.id, this.title, this.name)" style="margin-right:10px;">Assign additional owners</a>
				<span class="d-none ownerFor{{value.id}}" id="ownerFor{{value.id}}">{{value.ownerList}}</span>
				<span class="d-none userName{{value.id}}" id="userName{{value.id}}">{{value.userNamePlain}}</span>
				<span class="btn btn-primary btn-small" id="lastSpanODB{{$index}}"><a class="loadLastSuccessfulBackupBtnODB{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'ODB')" title="Show Last Successful Backup Time">Show Last Successful Backup Time</a></span>
			    </td>
                        </tr>
                        </tbody>
		    </table>
		    <div id="noResultsMessageOnedrive" style="display:none;text-align: center;margin:20px;">No match found</div>
		</div>
		<div class="row devicesListOnedriveTableNavigate hide">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountOnedrive}} of {{totalpageCountOnedrive}}</span></p>
                            <a class="btn btn-primary firstOnedrive" title="First" ng-click="manageDevicesOneDriveNavigate('ODB', firstOnedrive)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousOnedrive" title="Previous" ng-click="manageDevicesOneDriveNavigate('ODB', previousOnedrive)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextOnedrive" title="Next" ng-click="manageDevicesOneDriveNavigate('ODB', nextOnedrive)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastOnedrive" title="Last" ng-click="manageDevicesOneDriveNavigate('ODB', lastOnedrive)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
		    <!--onedrive ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="exchange">
		    <!--exchange starts-->
			<div class="panel panel-default files-panel no-box-shadow">
                <div class="statusExchange" style="display: none; text-align: center;margin:20px;">Loading ...</div>
		<div class="table-responsive devicesListExchange" style="display: none;">
		    <div class="panel-heading">
			<div class="col-lg-12" block-ui="myBlockUI">
                                <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                        <div class="background"></div>
                                        <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Total Microsoft Exchange Assets</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ exchangeAssetCount }}</span>
                                        </div>
                                </div>
                        </div>
                        <h4>
			<?=Language::show('list_of_assets', 'keywords');?>
			<div class="checkbox check-primary includeLastSuccessfulBackupExchangediv pull-right hide">
                                <input id="includeLastSuccessfulBackupExchange" name="includeLastSuccessfulBackupExchange" type="checkbox" value="enabled" ng-click="includeLastSuccessfulBackupExchange('Exchange')">
                                <label for="includeLastSuccessfulBackupExchange"><?=Language::show('Include Last Successful Backup', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="left" title="Show Last Successful Backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        </div>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel('Exchange')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Assets</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel('Exchange')" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Assets</a>
                        <?php } ?>
                        <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                <?php if(block == false){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } else {?>
                                <?php if(!isMobile()){ ?>
                                    <a class="btn btn-primary btn-small pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php }else { ?>
                                    <a class="btn btn-primary btn-small <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Assets in Bulk</a>
                                <?php } ?>
                                <?php } ?>
			<?php } ?>
			<?php if($data['mailArchivingEnabled'] == 'true'){?>		    
			<a ng-click="getJobStatus('Exchange')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Get Capacity Savings Status</a>    
			<?php } ?>
                        </h4>
                    </div>
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchExchangeInput" onkeyup="searchedExchangeDevices()" placeholder="Search for Assets.." title="Type in a Asset Name">
                    </div>
		    <table class="table table-bordered table-striped table-hover files-table" id="devicesListExchangeTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Asset Name
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                User Name
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Asset Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
			<tr ng-repeat-start="value in devicesExchange | orderBy:sortType:sortReverse track by $index">
			    <?php if($data['view'] == 'no'){?>
			    <td ng-if="'<?=$data['selectedUser']?>' != value.userNamePlain" class="text-left" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span>{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <td ng-if="'<?=$data['selectedUser']?>' == value.userNamePlain" class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
                            <?php } else { ?>
			    <td class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i><span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <?php } ?>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
                            <td class="text-left" ng-cloak>
                                    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.status == 'Active' && value.quarantineDevice == false && value.decoupled == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Blocked' && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Decoupled'"><?=Language::show('Decoupled', 'keywords')?></label></h5>
                            </td>
                            <td class="text-left" ng-cloak>{{ value.createdOn}}</td>
                            <td class="text-left" ng-cloak>
                                <!--<span id="lastSpanExchange{{$index}}"><a style="margin-top: 5px;" class="btn btn-primary btn-small loadLastSuccessfulBackupBtnExchange{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'Exchange')" title="Get Last Successful Backup Time">Load</a></span>-->
                                <a class="btn btn-small btn-primary <?php if($data['view'] == 'no'){?> hide <?php } ?>" title="Show Actions" id="showMore_{{value.uuId}}" ng-click="showActionsExchange(value.uuId)" style="border-radius: 20px;"><i class="fa fa-ellipsis-h fa-1x"></i></a>
                            </td>
			</tr>
			<tr ng-repeat-end style="display:none;" id="collapse{{value.uuId}}">
                            <td class="text-center" colspan="6" style="border:unset;border-bottom: 2px solid black;padding: 5px 15px 5px 15px;">
                                <a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userName}}/{{value.nameEncoded}}')?>" style="margin-right:10px;"><?=Language::show('Manage Asset', 'keywords');?></a>
                                <a ng-if="value.status == 'Active'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="margin-right:10px;">Backup Management</a>
				<a ng-if="value.status != 'Active'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="pointer-events:none;opacity:0.4;margin-right:10px;">Backup Management</a>
<?php if($data['userType'] != 'superAdmin'){ ?>
				<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>
<?php } ?>
                                <?php //if($data['showRestore'] == 'no'){?>
                                        <!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;margin-right:10px;">Restore</a>-->
                                <?php //} ?>
                                <?php //if($data['showRestore'] == 'yes'){?>
                                    <?php //if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
                                        <!--<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>-->
                                    <?php //}else{ ?>
                                        <!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>-->
                                    <?php //} ?>
                                <?php //} ?>
                                <a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" style="margin-right:10px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
                                <a ng-hide="value.showAssignDevices == false" class="btn btn-primary btn-small" name="{{value.uuId}}" id="{{value.id}}" title="{{value.nameNew}}" onclick="addCurrentOwner(this.id, this.title, this.name)" style="margin-right:10px;">Assign additional owners</a>
				<span class="d-none ownerFor{{value.id}}" id="ownerFor{{value.id}}">{{value.ownerList}}</span>
				<span class="d-none userName{{value.id}}" id="userName{{value.id}}">{{value.userNamePlain}}</span>
				<span class="btn btn-primary btn-small" id="lastSpanExchange{{$index}}"><a class="loadLastSuccessfulBackupBtnExchange{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'Exchange')" title="Show Last Successful Backup Time">Show Last Successful Backup Time</a></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
		    <div id="noResultsMessageExchange" style="display:none;text-align: center;margin:20px;">No match found</div>
		</div>
		<div class="row devicesListExchangeTableNavigate hide">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountExchange}} of {{totalpageCountExchange}}</span></p>
                            <a class="btn btn-primary firstExchange" title="First" ng-click="manageDevicesExchangeNavigate('Exchange', firstExchange)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousExchange" title="Previous" ng-click="manageDevicesExchangeNavigate('Exchange', previousExchange)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextExchange" title="Next" ng-click="manageDevicesExchangeNavigate('Exchange', nextExchange)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastExchange" title="Last" ng-click="manageDevicesExchangeNavigate('Exchange', lastExchange)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
		    <!--exchange ends-->
		    </div>
		    <!--<div role="tabpanel" class="tab-pane <?php echo $data['activeTabSharepoint'];?>" id="sharepoint">-->
		    <div role="tabpanel" class="tab-pane" id="sharepoint">
		    <!--sharepoint starts-->
			<div class="panel panel-default files-panel no-box-shadow">		    
                <div class="statusSharepoint" style="display: none; text-align: center;margin:20px;">Loading ...</div>
		<div class="table-responsive devicesListSharepoint" style="display: none;">
		    <div class="panel-heading">
			<div class="col-lg-12" block-ui="myBlockUI">
                                <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                        <div class="background"></div>
                                        <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Total SharePoint Online Assets</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ sharepointAssetCount }}</span>
                                        </div>
                                </div>
                        </div>
                    	<h4>
			<?=Language::show('List of SharePoint Online Sites', 'keywords');?>
			<div class="checkbox check-primary includeLastSuccessfulBackupSharepointdiv pull-right hide">
                                <input id="includeLastSuccessfulBackupSharepoint" name="includeLastSuccessfulBackupSharepoint" type="checkbox" value="enabled" ng-click="includeLastSuccessfulBackupSharepoint('Sharepoint')">
                                <label for="includeLastSuccessfulBackupSharepoint"><?=Language::show('Include Last Successful Backup', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="left" title="Show Last Successful Backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        </div>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportSitesToExcel()" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Export Sites</a>
                        <?php } else { ?>
                            <a ng-click="exportSitesToExcel()" class="btn btn-small btn-primary" style="margin-top: 2px;margin-right: 10px;">Export Sites</a>
			<?php } ?>
			<?php //if($data['userType'] == 'admin'){ ?>
			    <a ng-click="configureSites()" class="btn btn-small btn-primary pull-right <?php if($data['view'] == 'no'){?> hide <?php } ?>" style="margin-right: 10px;">Configure Sites</a>
			<?php //} ?>
			<?php if($data['spArchivingEnabled'] == 'true'){?>
			<a ng-click="getJobStatus('Sharepoint')" class="btn btn-small btn-primary pull-right" style="margin-right: 10px;">Get Capacity Savings Status</a>
			<?php } ?>
                    	</h4>
                    </div>
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchSharepointInput" onkeyup="searchedSharepointDevices()" placeholder="Search for Sites.." title="Type in a Site Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListSharepointTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Sites
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <!--<th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                UserName
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>-->
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Site Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left  clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <!--<th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>-->
                        </tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat-start="value in devicesSharepoint | orderBy:sortType:sortReverse track by $index">
			    <!--<td class="text-left clickAble" title="{{ value.name }}" ng-cloak><img src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" style="height:20px;width:20px;"> <span ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>-->
			    <?php if($data['view'] == 'no'){?>
			    <td ng-if="'<?=$data['selectedUser']?>' != value.userNamePlain" class="text-left" title="{{ value.name }}" ng-cloak><img src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" style="height:20px;width:20px;"><span>{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span></td>
			    <td ng-if="'<?=$data['selectedUser']?>' == value.userNamePlain" class="text-left clickAble" title="{{ value.name }}" ng-cloak><img src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" style="height:20px;width:20px;"> <span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:40 }}{{value.name.length > 40 ? '...' : ''}}</span></td>
                            <?php } else { ?>
			    <td class="text-left clickAble" title="{{ value.name }}" ng-cloak><img src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" style="height:20px;width:20px;"> <span ng-click="openFilesPage(value.id, value.nameEncoded, value.uuId, value.deviceType, value.icon, value.userNameEnc, value.blocked, value.quarantineDevice)" style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:40 }}{{value.name.length > 40 ? '...' : ''}}</span></td>
			    <?php } ?>
                            <!--<td class="text-left" title="{{ value.userNamePlain }}" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>-->
			    <td class="text-left" ng-cloak><!--{{ value.status }}-->
				    <h5><label style="width: 70px;" class="badge badge-success" ng-if="value.status == 'Active' && value.quarantineDevice == false && value.decoupled == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Blocked' && value.quarantineDevice == false"><?=Language::show('Blocked', 'keywords')?></label></h5>
				    <h5><label style="width: 70px;" class="badge badge-danger" ng-if="value.status == 'Decoupled'"><?=Language::show('Decoupled', 'keywords')?></label></h5>
			    </td>
                            <td class="text-left" ng-cloak>{{ value.createdOn}}</td>
			    <td class="text-left" ng-cloak>
				<!--<span id="lastSpanSharepoint{{$index}}"><a style="margin-top: 5px;" class="btn btn-primary btn-small loadLastSuccessfulBackupBtnSharepoint{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'Sharepoint')" title="Get Last Successful Backup Time">Load</a></span>-->
				<a class="btn btn-small btn-primary <?php if($data['view'] == 'no'){?> hide <?php } ?>" title="Show Actions" id="showMore_{{value.uuId}}" ng-click="showActionsSharepoint(value.uuId)" style="border-radius: 20px;"><i class="fa fa-ellipsis-h fa-1x"></i></a>
			    </td>
			</tr>
			<tr ng-repeat-end style="display:none;" id="collapse{{value.uuId}}">
			    <td class="text-center" colspan="6" style="border:unset;border-bottom: 2px solid black;padding: 5px 15px 5px 15px;">
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('myAccount/{{value.userName}}/{{value.nameEncoded}}')?>" style="margin-right:10px;"><?=Language::show('Manage Site', 'keywords');?></a>
				<a ng-if="value.status == 'Active'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="margin-right:10px;">Backup Management</a>
				<a ng-if="value.status != 'Active'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management" style="pointer-events:none;opacity:0.4;margin-right:10px;">Backup Management</a>
<?php if($data['userType'] != 'superAdmin'){ ?>
				<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.nameEncoded, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="margin-right:10px;">Restore</a>
<?php } ?>
				<!--<a ng-click="initiateRestoreForDeviceSharepoint(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameEncoded }}')?>" style="margin-right:10px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
				<?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
				<a class="btn btn-primary btn-small" href="<?=Url::basePath('user/settings/{{ value.userName }}')?>" style="margin-right:10px;"><?=Language::show('Edit Site', 'keywords');?></a>
				<?php } ?>
				<span class="btn btn-primary btn-small" id="lastSpanSharepoint{{$index}}"><a class="loadLastSuccessfulBackupBtnSharepoint{{$index}}" ng-click="loadLastSuccessfulBackup(value.uuId, $index, 'Sharepoint')" title="Show Last Successful Backup Time">Show Last Successful Backup Time</a></span>
			    </td>
                        </tr>
                        </tbody>
		    </table>
		    <div id="noResultsMessageSharepoint" style="display:none;text-align: center;margin:20px;">No match found</div>
		</div>
		<div class="row devicesListSharepointTableNavigate hide">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountSharepoint}} of {{totalpageCountSharepoint}}</span></p>
                            <a class="btn btn-primary firstSharepoint" title="First" ng-click="manageDevicesSharepointNavigate('Sharepoint', firstSharepoint)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousSharepoint" title="Previous" ng-click="manageDevicesSharepointNavigate('Sharepoint', previousSharepoint)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextSharepoint" title="Next" ng-click="manageDevicesSharepointNavigate('Sharepoint', nextSharepoint)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastSharepoint" title="Last" ng-click="manageDevicesSharepointNavigate('Sharepoint', lastSharepoint)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div> 
            </div>
		    <!--sharepoint ends-->
		    </div>
            </div>
<!--new ends-->
<!--job status modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningJobs" id="currentlyRunningJobs" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <span><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>
                        <div class="modal-header" style="margin-bottom: -10px;">
			    <span class="hide" id="jobProductType"></span>
                            <div class="panel-heading col-lg-12">
                                <h4>Capacity Savings Job Status <a href="" ng-click="refreshJobStatus()" class="text-danger pull-right" ng-cloak>Refresh <i class="glyphicon glyphicon-refresh"></i></a></h4>
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="table-responsive currentJobTable">
                            </hr>
                            <table id="CurrentJobTable" class="table table-bordered currentJobTable" style="display: none;">
                                <thead>
                                <tr>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center"><?=Language::show('Savings', 'keywords')?></th>
                                 <th class="text-center actionn"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
				<tr ng-repeat="value in currentJob | orderBy:currentBackupSortType:sortReverse" class="text-center">
				    <td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div title="{{value.uploadedFiles}} {{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-cloak>{{ value.totalSizeToUpload }}</td>
                                    <td class="actionn">
                                        <a ng-if="value.status == 'PAUSED' || value.status == 'ABORTED'" ng-click="stopCurrentJob('start')" class="toolTip" id="start_{{$index}}" data-toggle="tooltip" data-placement="top" title="Start Capacity Savings Job" href="javascript:;" style="color:green !important;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-play fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a ng-if="value.status != 'COMPLETED' && value.status != 'PAUSED'" ng-click="stopCurrentJob('pause')" class="toolTip" id="pause_{{$index}}" data-toggle="tooltip" data-placement="top" title="Pause Capacity Savings Job" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a ng-if="value.status != 'COMPLETED' || value.status == 'PAUSED'" class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Capacity Savings Job" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="stopCurrentJob('stop')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:red !important;">
                                        <span class="fa-stack">
					  <i class="fa fa-circle fa-stack-2x"></i>
					  <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
			    <div class="h4 currentJobError text-center" style="display: none">No details found</div>
			    <div class="col-lg-12 currentJobError">
                                <center><p>Capacity Savings Job not running. <a ng-click="startCurrentJob('start')" class="toolTip" data-toggle="tooltip" data-placement="top" title="Start Capacity Savings Job" href="javascript:;" style="color:green !important;">Run Now</a></p></center>
			    </div>
			    <!--collapse start-->
			    <p><a href="" ng-click="getJobStatusHistory()" class="btn btn-primary" ng-cloak>View Capacity Savings Job History</a></p>
			    <div class="collapse" id="collapseHistory">
				  <div class="card card-body">
                                <!--tableresponsive-->
                            <div class="h4 currentJobHistoryError text-center" style="display: none">No details found</div>
                            <div class="table-responsive CurrentJobHistoryTable" id="CurrentJobHistoryTable">
				    <h4 class="modal-title">Capacity Savings Job History
				    <span style="float:right;cursor: pointer;">
                                        <i ng-click="hideCapacityHistory()" class="aarestoreSharepoint glyphicon glyphicon-remove"></i>
                                    </span>
				    </h4><br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th class="text-center clickAble" ng-click="sortTypeCSJH = 'startTimeLong'; sortReverseCSJH = !sortReverseCSJH">
                                                    <?=Language::show('start_time', 'keywords')?>
                                                    <span ng-show="sortTypeCSJH == 'startTimeLong' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'startTimeLong' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble" ng-click="sortTypeCSJH = 'endTimeLong'; sortReverseCSJH = !sortReverseCSJH">
						    <?=Language::show('End Time', 'keywords')?>
						    <span ng-show="sortTypeCSJH == 'endTimeLong' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'endTimeLong' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble d-none" ng-click="sortTypeCSJH = 'totalNumberOfFiles'; sortReverseCSJH = !sortReverseCSJH">
						    <p style="margin: 0 0 0px;">Total Number of</p><p style="margin: 0 0 0px;">Eligible Items</p>
                                                    <span ng-show="sortTypeCSJH == 'totalNumberOfFiles' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'totalNumberOfFiles' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble d-none" ng-click="sortTypeCSJH = 'noOfFilesBackedup'; sortReverseCSJH = !sortReverseCSJH">
                                                    <?=Language::show('Items processed', 'keywords')?>
                                                    <span ng-show="sortTypeCSJH == 'noOfFilesBackedup' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'noOfFilesBackedup' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble" ng-click="sortTypeCSJH = 'uploadedPercentage'; sortReverseCSJH = !sortReverseCSJH">
                                                    <?=Language::show('Percentage Completed', 'keywords')?>
                                                    <span ng-show="sortTypeCSJH == 'uploadedPercentage' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'uploadedPercentage' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble" ng-click="sortTypeCSJH = 'cpConvFiles'; sortReverseCSJH = !sortReverseCSJH">						    
						    <p style="margin: 0 0 0px;">Total Number of</p><p style="margin: 0 0 0px;">Converted Items</p>
						    <span ng-show="sortTypeCSJH == 'cpConvFiles' && !sortReverseCSJH" class="fa fa-caret-up"></span>
						    <span ng-show="sortTypeCSJH == 'cpConvFiles' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble" ng-click="sortTypeCSJH = 'totalSizeToUpload'; sortReverseCSJH = !sortReverseCSJH">
                                                    <?=Language::show('Savings', 'keywords')?>
                                                    <span ng-show="sortTypeCSJH == 'totalSizeToUpload' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'totalSizeToUpload' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                                <th class="text-center clickAble" ng-click="sortTypeCSJH = 'status'; sortReverseCSJH = !sortReverseCSJH">
                                                    <?=Language::show('Status', 'keywords')?>
                                                    <span ng-show="sortTypeCSJH == 'status' && !sortReverseCSJH" class="fa fa-caret-up"></span>
                                                    <span ng-show="sortTypeCSJH == 'status' && sortReverseCSJH" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in currentJobHistory | orderBy:sortTypeCSJH:sortReverseCSJH">
                                                <td class="text-center" ng-cloak>{{ value.startTime }}</td>
                                                <td class="text-center" ng-if="value.status == 'Batch under process'" ng-cloak>-</td>
                                                <td class="text-center" ng-if="value.status != 'Batch under process'" ng-cloak>{{ value.endTime }}</td>
                                                <td class="text-center d-none" ng-cloak>{{ value.totalNumberOfFiles }}</td>
                                                <td class="text-center d-none" ng-cloak>{{ value.noOfFilesBackedup }}</td>
                                                <td class="text-center" ng-cloak>{{ value.uploadedPercentage }}</td>
                                                <td class="text-center" ng-cloak>{{ value.cpConvFiles }}</td>
                                                <td class="text-center" ng-cloak>{{ value.totalSizeToUpload }}</td>
						<td class="text-center" ng-cloak>{{ value.status }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
  </div>
</div>
<!--collapse end-->
                                </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--job status modal ends-->
<!-- restore for outlook start -->

<!-- restore for outlook device start -->

<div class="modal fade restoreBuckettOutlookDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width:90%;">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
                        <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlookDevice"></span>
					</div>
				<div class="settingsDivOutlookDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookDevice">User Id</label>
                                            <select name="searchUsernameOutlookDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookDevice"
                                                    id="searchUsernameOutlookDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlookDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlookDevice form-control" id="searchDeviceNameOutlookDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="hide" type="text" id="uuuOutlookDevice" value=""/>

                                    <div class="form-group col-lg-12">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelOutlookDevice" for="destinationPathOutlookDevice">Enter a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOutlookDevice" id="destinationPathOutlookDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOutlookDevice" ng-click="browseOutlookDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
						<div class="col-lg-6">
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OutlookDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlookDevice"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
</div>
                                        <div class="col-lg-6" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;/*margin-left: -30px;*/">
                                                <div class="col-lg-6">
<label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-6">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOutlookDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlookDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlookDevice" id="restoreDateOutlookDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlookDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlookDevice" name="restoreTimeOutlookDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
</div>					
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOutlookDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdOutlookDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td>
					    	<div class="progress">
					    		<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					    </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
			<button type="button" ng-click="calculateRestorableSizeDevice('OutlookDevice')" class="btn btn-default calculateRestorableSizeBtnOutlookDevice">Calculate Restorable Size</button>
                        <button type="submit" ng-click="initiateRestoreOutlookDevice()"  class="btn btn-default initiateRestoreBtnOutlookDevice">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOutlookDevice()" class="btn btn-primary cancelRestoreBtnOutlookDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOutlookDevice()" class="btn btn-default normalCancelOutlookDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOutlookDevice()"  class="btn btn-default warningCancelOutlookDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<!--<div class="modal fade restoreEventsExistsOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">A restore request already exists</h4>
                        </div>
                        <div class="modal-body">
                            <p class="hide"><span id="statementForCompPathOutlook"></span><span id="statementForDesPathOutlook"></span></p>
                            
                            <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>File Path</th>
                                            <th>Destination Path</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>{{ restoreEventsExists.fileElement.fileCompletePath }}</td>
                                            <td ng-if="restoreEventsExists.destinationPath != ''">{{ restoreEventsExists.destinationPath }}</td>
                                            <td ng-if="restoreEventsExists.destinationPath == ''"> - </td>
                                            <td>{{restoreEventsExists.status}}</td>
<td>
                                                <a ng-if="restoreEventsExists.status == 'QUEUE'" ng-click="deleteRestoreOutlook()" class="btn btn-danger btn-small">Cancel Restore</a>
                                            </td>
                                        </tr>
                                        </tbody>
</table>
                                </div>
                                <p><span id="restorealreadyexistsOutlook"></span></p>
                        </div>
                        <div class="modal-footer">
          			<button type="button" class="btn btn-default closeBtnRestoreBtnForFilesOutlook" data-dismiss="modal" style="display:none;">Close</button>
      				<button type="button" ng-click="deleteRestoreOutlook()" class="btn btn-primary cancelRestoreBtnForFilesOutlook" style="display:none;">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>-->
<div class="modal fade restoreWindowConfirmCloseOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOutlookDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlookDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOutlookDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOutlookDevice == ''" ng-cloak>/</span><span ng-if="pathOutlookDevice != ''" ng-cloak>{{pathOutlookDevice}}</span>
<div class="col-lg-12">
	<div class="row">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOutlookDevice(pathOutlookDevice)" style="margin:5px;" ng-if="pathOutlookDevice != ''"><i class="fa fa-arrow-left"></i> Back</a>
</br>
                        <div class="table-responsive browsePathDivOutlookDevice">
<span class="noPathOutlookDevice" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOutlookDevice" class="table table-hover table-bordered browsePathOutlookDevice" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOutlookDevice(value, $index)" ng-dblclick="getChildsOutlookDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOutlookDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOutlookDevice" id="newFolderOutlookDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOutlookDevice()" class="btn btn-default addNewFolderBtnOutlookDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
	</div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOutlookDevice" ng-click="usePathOutlookDevice(pathOutlookDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook device end -->

<!-- restore for outlook end -->

<!-- restore for onedrive device start -->

<div class="modal fade restoreBuckettOnedriveDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width:90%;">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
                        <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOnedriveDevice"></span>
					</div>
				<div class="settingsDivOnedriveDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOnedriveDevice">User Id</label>
                                            <select name="searchUsernameOnedriveDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOnedriveDevice"
                                                    id="searchUsernameOnedriveDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>					
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOnedriveDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOnedriveDevice form-control" id="searchDeviceNameOnedriveDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="hide" type="text" id="uuuOnedriveDevice" value=""/>

                                    <div class="form-group col-lg-12">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelOnedriveDevice" for="destinationPathOnedriveDevice">Select a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOnedriveDevice" id="destinationPathOnedriveDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOnedriveDevice" ng-click="browseOnedriveDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
						<div class="col-lg-6">
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
<div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OnedriveDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
</div>							
                                        <div class="col-lg-6" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;/*margin-left: -30px;*/">
                                                <div class="col-lg-6">
<label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
</div>
                                                <div class="col-lg-6">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOnedriveDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOnedriveDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateOnedriveDevice" id="restoreDateOnedriveDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOnedriveDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOnedriveDevice" name="restoreTimeOnedriveDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
</div>					
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOnedriveDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdOnedriveDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
					</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
					    <div class="progress">
					    	<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					     </td>
					     <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
			<button type="button" ng-click="calculateRestorableSizeDevice('OnedriveDevice')" class="btn btn-default calculateRestorableSizeBtnOnedriveDevice">Calculate Restorable Size</button>
                        <button type="submit" ng-click="initiateRestoreOnedriveDevice()"  class="btn btn-default initiateRestoreBtnOnedriveDevice">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOnedriveDevice()" class="btn btn-primary cancelRestoreBtnOnedriveDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOnedriveDevice()" class="btn btn-default normalCancelOnedriveDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOnedriveDevice()"  class="btn btn-default warningCancelOnedriveDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseOnedriveDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOnedriveDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOnedriveDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>
</div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOnedriveDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOnedriveDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOnedriveDevice == ''" ng-cloak>/</span><span ng-if="pathOnedriveDevice != ''" ng-cloak>{{pathOnedriveDevice}}</span>
<div class="col-lg-12">
	<div class="row">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOnedriveDevice(pathOnedriveDevice)" style="margin:5px;" ng-if="pathOnedriveDevice != ''"><i class="fa fa-arrow-left"></i> Back</a>
</br>
                        <div class="table-responsive browsePathDivOnedriveDevice">
<span class="noPathOnedriveDevice" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOnedriveDevice" class="table table-hover table-bordered browsePathOnedriveDevice" style="display: none;">
                                <tbody>
<tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOnedriveDevice(value, $index)" ng-dblclick="getChildsOnedriveDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOnedriveDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOnedriveDevice" id="newFolderOnedriveDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOnedriveDevice()" class="btn btn-default addNewFolderBtnOnedriveDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
	</div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOnedriveDevice" ng-click="usePathOnedriveDevice(pathOnedriveDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for Onedrive device end -->
<!--browse modal start-->
<div class="modal fade browseEndPointOnedriveDevice" style="z-index: 999999999999999;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <span>Current Path : </span><span ng-if="pathEndPointOnedriveDevice == ''" ng-cloak>/</span><span ng-if="pathEndPointOnedriveDevice != ''" ng-cloak>{{pathEndPointOnedriveDevice}}</span>
                                <div class="col-lg-12">
<div class="row">
                                <div class="col-lg-7" style="border: 1px solid black;">
                                <a class="btn btn-small btn-primary" ng-click="backEndPointOnedriveDevice(pathEndPointOnedriveDevice)" style="margin:5px;" ng-if="pathEndPointOnedriveDevice != ''"><i class="fa fa-arrow-left"></i> Back</a>
                                </br>
                        <div class="table-responsive browsePathDivEndPointOnedriveDevice">
                        <span class="noPathEndPointOnedriveDevice" style="display:none;"> No path available</span>
                        <span ng-if="browseElementsEndPointDevice == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathEndPointOnedriveDevice" class="table table-hover table-bordered browsePathEndPointOnedriveDevice" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElementsEndPointDevice" class="text-left" ng-class="{'selected':$index == selectedRowEndPointDevice}">
                                        <td ng-click="pickEndPointOnedriveDevice(value, $index)" ng-dblclick="getChildsEndPointOnedriveDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderEndPointOnedriveDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderEndPointOnedriveDevice" id="newFolderEndPointOnedriveDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderEndPointOnedriveDevice()" class="btn btn-default addNewFolderBtnEndPointOnedriveDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathEndPointOnedriveDevice" ng-click="usePathEndPointOnedriveDevice(pathEndPointOnedriveDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->	
<!-- restore for EndPointDevice start -->
<div class="modal fade restoreBuckettEndPointDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width:90%;">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathEndPointDevice"></span>
					</div>
				<div class="settingsDivEndPointDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsernameEndPointDevice">User Id</label>
                                            <select name="searchUsernameEndPointDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameEndPointDevice"
                                                    id="searchUsernameEndPointDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>					
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameEndPointDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameEndPointDevice form-control" id="searchDeviceNameEndPointDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
                                    <input class="hide" type="text" id="uuu" value=""/>
				    <input class="hide" type="text" id="uuuOS" value=""/>
                                    <div class="form-group col-lg-12" id="destinationPathEndPointDeviceRow">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelEndPointDevice" for="destinationPathEndPointDevice">Enter a Destination Path</label>
					<input type="text" class="form-control" style="width: 100%;" id="destinationPathEndPointDevice" placeholder="Enter Destination Path" required/>
                                        <span class="help-block hide">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
				    <!--browse for endpoint start-->
                                    <div class="form-group col-lg-12" id="destinationPathEndPointOnedriveDeviceRow" style="margin-bottom:10px;display:none;">
                                        <!--<br/>-->
                                        <label for="destinationPathEndPointOnedriveDevice">Select a Destination Path</label>
                                        <div class="col-lg-12 row">
                                                <div class="col-lg-10">
                                                        <input type="text" class="" name="destinationPathEndPointOnedriveDevice" id="destinationPathEndPointOnedriveDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
                                                </div>
                                                <div class="col-lg-2">
                                                        <span class="input-group-btn">
                                                        <button id="browseEndPointOnedriveDevice" ng-click="browseEndPointOnedriveDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
                                                        </span>
                                                </div>
                                        </div>
                                    </div>
                                    <!--browse for endpoint ends-->
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
					<div class="form-group col-lg-12 row" id="noOfThreadsRow">
						<label for="noOfThreads">Number of Threads</label>
						<input type="number" class="form-control" style="width: 100%;" id="noOfThreads" min="1" max="6" value="1" placeholder="Enter number of Threads" required/>
					</div>
                                        <div class="col-lg-12 row" id="suspendbackupEndPointDeviceRow">
						<div class="col-lg-6">
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
<label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
						    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackupEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row" id="inPlaceRestoreEndPointDeviceRow">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
						</label>
                                            </div>
                                        </div>
					    <div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesEndPoint"><?=Language::show('Restore Deleted Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row" id="overwriteNewerFilesEndPointDeviceRow">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="overwriteNewerFilesEndPoint"><?=Language::show('Overwrite Newer Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchoverwriteNewerFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
</div>							
					    <div class="col-lg-6" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;/*margin-left: -30px;*/">
                                                <div class="col-lg-6">
                                                    <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-6">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateEndPointDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateEndPointDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateEndPointDevice" id="restoreDateEndPointDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
</div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTime"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeEndPointDevice" name="restoreTimeEndPointDevice" disabled>
</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
</div>					
<!--tableresponsive-->
                            <div class="table-responsive currentProgressEndPointDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdEndPointDevice"></span>
				    </br>
                                    <table class="table table-bordered table-striped currentProgressEndPointDeviceTable" style="display:none;">
                                        <thead>
						<tr>
						    <th>Source Path</th>
						    <th>Overall Progress</th>
						    <th>Status</th>
						</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
						<td ng-if="progress.currentFolderPath">{{ progress.currentFolderPath | limitTo:40 }}{{progress.currentFolderPath.length > 40 ? '...' : ''}}</td>
						<td ng-if="!progress.currentFolderPath">-</td>
						<td ng-if="progress.totalRestorePct != ''">
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
							</div>
						</td>
						<td ng-if="progress.totalRestorePct == ''">-</td>
					    	<td><span id="statusEndPointDevice"></span></td>
                                        </tr>
                                        </tbody>
                                    </table>
				    <table class="table table-bordered table-striped currentProgressEndPointOneDriveDeviceTable" style="display:none;">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                    <span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
			<button type="button" ng-click="calculateRestorableSizeDevice('EndPointDevice')" class="btn btn-default calculateRestorableSizeBtnEndPointDevice">Calculate Restorable Size</button>
			<button type="submit" ng-click="initiateRestoreEndPointDevice()"  class="btn btn-default initiateRestoreBtnEndPointDevice">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmEndPointDevice()" class="btn btn-primary cancelRestoreBtnEndPointDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshEndPointDevice()" class="btn btn-default normalCancelEndPointDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreEndPointDevice()"  class="btn btn-default warningCancelEndPointDevice" style="display:none;">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseEndPointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
<!--                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnEndPointDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
				</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmEndPointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
    <!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
<button type="button" class="btn btn-default" ng-click="deleteRestoreEndPointDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<!-- restore for EndPointDevice end -->		
<!--sharepoint device start-->
<!-- restore for sharepoint device start -->
<div class="modal fade restoreBuckettSharepointDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                        <div class="form-group col-lg-12">
                                                <span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathSharepointDevice"></span>
                                        </div>
                                <div class="settingsDivSharepointDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
                                        <div class="row" style="margin-left:0px;">
                                                <span class="star">Select a destination Site:</span>
                                        </div>
<div class="row">
                                    <div class="col-lg-10">
                                        <select class="searchDeviceNameSharepointDevice" id="deviceNameSharepointDevice" style="width: 100%;" data-parsley-trigger="change"></select>
                                    </div>
                                </div>
                                    </div>
                                    <input class="d-none" type="text" id="uuuSharepointDevice" value=""/>
                                    <div class="form-group col-lg-12" style="margin-bottom:10px;">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelSharepointDevice" for="destinationPathSharepointDevice">Select a Destination Path</label>
<!--                                        <div class="col-lg-12 row">
                                                <div class="col-lg-10">-->
                                                        <input type="text" class="" name="destinationPathSharepointDevice" id="destinationPathSharepointDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required style="width:100%;"/>
<!--                                                </div>
                                                <div class="col-lg-2">
                                                        <span class="input-group-btn">
                                                        <button id="browseSharepointDevice" ng-click="browseSharepointDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
                                                        </span>
                                                </div>
                                        </div>-->
                                    </div>
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
<legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1SharepointDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                            	<label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsSharepointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceSharepointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
                                                        <label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateSharepointDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateSharepointDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateSharepointDevice" id="restoreDateSharepointDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeSharepointDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeSharepointDevice" name="restoreTimeSharepointDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressSharepointDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
                                    <span class="d-none" id="batchIdSharepointDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                    <span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
                        <button ng-if="selected[0].type === 'Folder'" type="button" ng-click="calculateRestorableSize('Onedrive')" class="btn btn-default calculateRestorableSizeBtnSharepointDevice">Calculate Restorable Size</button>
                        <button type="submit" ng-click="initiateRestoreSharepointDevice()"  class="btn btn-default initiateRestoreBtnSharepointDevice">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmSharepointDevice()" class="btn btn-primary cancelRestoreBtnSharepointDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshSharepointDevice()" class="btn btn-default normalCancelSharepointDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreSharepointDevice()"  class="btn btn-default warningCancelSharepointDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseSharepointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnSharepointDevice()">Ok</button>
                          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmSharepointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>
                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-default" ng-click="deleteRestoreSharepointDevice()">Ok</button>
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseSharepointDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <span>Current Path : </span><span ng-if="pathSharepointDevice == ''" ng-cloak>/</span><span ng-if="pathSharepointDevice != ''" ng-cloak>{{pathSharepointDevice}}</span>
                                <div class="col-lg-12">
                                        <div class="row">
                                                <div class="col-lg-7" style="border: 1px solid black;">
                                                        <a class="btn btn-small btn-primary" ng-click="backSharepointDevice(pathSharepointDevice)" style="margin:5px;" ng-if="pathSharepoint != ''"><i class="fa fa-arrow-left"></i> Back</a>
                                                        </br>
                                                                <div class="table-responsive browsePathDivSharepointDevice">
                                                                        <span class="noPathSharepointDevice" style="display:none;"> No path available</span>
                                                                        <span ng-if="browseElementsDevice == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                                                                        <table id="browsePathSharepoint" class="table table-hover table-bordered browsePathSharepointDevice" style="display: none;">
                                                                                <tbody>
                                                                                        <tr ng-repeat="value in browseElementsDevice" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                                                                                <td ng-click="pickSharepointDevice(value, $index)" ng-dblclick="getChildsSharepointDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                                                                        </tr>
                                                                                </tbody>
                                                                        </table>
                                                                </div>
                                                </div>
                                                <div class="col-lg-5">
                                                	<div class="form-group">
                                                                <label for="newFolderSharepointDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                                                <div class="input-group">
                                                                        <input type="text" class="form-control" name="newFolderSharepointDevice" id="newFolderSharepointDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                                                        <span class="input-group-btn">
                                                                                <button ng-click="addNewFolderSharepointDevice()" class="btn btn-default addNewFolderBtnSharepointDevice" style="padding-bottom: 10px;" type="button">Create</button>
                                                                        </span>
                                                                </div>
                                                        </div>
                                                </div>
                                </div>
                        </div>
                        <div class="modal-footer">
                                <a class="btn btn-small btn-primary usePathSharepointDevice" ng-click="usePathSharepointDevice(pathSharepointDevice)">Use Path</a>
                                <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for sharepoint Device end -->
<!--sharepoint Device end-->
<!--restorableSizeModal start-->
    	    <div class="modal fade restorableSizeModal" id="restorableSizeModal" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Restorable Size </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
			    <span id="restorableSizeLabel" style="display:none;"> Calculating....</span>
                            <center><span id="restorableSizeSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                            <h4 id="restorableSize" class="modal-title">
                                <p><span>Size: {{restorableSize}}</span></p>
                                <p ng-if="totalNumberOfFiles !=''"><span>Contains: {{totalNumberOfFiles}} items</span></p>
                            </h4>
			    <h4 id="restorableSizeError" class="modal-title">Operation to Calculate restorable size of folder failed.</h4>
                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Close </button>
                        </div>
                    </div>
                </div>
	    </div>
<!--restorableSizeModal ends-->
<!--add server modal start-->
<div class="modal fade" id="addNewServer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'addServerForm',
                        'id' => 'addServerForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'addSingleMspServer()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Add New Server</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group col-lg-12">
                                        <label for="serverName"><?=Language::show('Server Name', 'keywords')?></label>
                                                <input type="text" class="form-control" name="newServerName" id="newServerName" value="" placeholder="Enter Server Name" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Please enter valid Server Name.">
				</div>
<?php if(!empty($data['serverbackupPolicies'])){?>
<input type="hidden" class="defServerPolicyName" value="<?=$data['serverbackupPolicies'][0]?>"/>
<?php } ?>
                                <div class="form-group col-lg-12">
                                        <label for="policy"><?=Language::show('Policy', 'keywords')?></label>
						<select name="newServerPolicy" id="newServerPolicy" class="form-control newServerPolicy"  title='Select Server Backup Policy Name'>
						<option value="suspended">No Backup</option>
                                                <?php if(!empty($data['serverbackupPolicies'])){ ?>
                                                    <?php foreach($data['serverbackupPolicies'] as $value){
                                                    $label = $value;
                                                    /*$lastDashPosition = strrpos($label, "-");
                                                        if ($lastDashPosition !== false) {
                                                                $trimmedString = substr($label, 0, $lastDashPosition);
                                                        }*/
                                                                if( strlen( $value ) > 75 ) {
                                                                   $label = substr( $label, 0, 75 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveServer btn btn-success">Save</button>
                            </div>
                        </div>
                    <?= Form::close(); ?>
                </div>
    </div>
<!--add server modal ends-->
<!--event hub modal start-->
<div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h4 class="modal-title">Backup Management</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>					
					<span class="d-none" id="actionToUserName"></span>
					<span class="d-none" id="actionToDeviceUUID"></span>
					<span class="d-none" id="deviceType"></span>
					<div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="row col-lg-12" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
 						</div>
 					</div>
 					<?php } ?>
					<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="row col-lg-12" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="row col-lg-12 agLogs" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                        </div>
                    </div>
                    <!--<div class="row col-lg-12 fBackup <?php if($data['userType'] == 'readOnlyAdmin'){ ?>hide<?php } ?>" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Yes" data-off="No">
                        </div>
                    </div>-->
		     <?php //if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <input class="d-none" id="startBackupGet" name="startBackupGet" type="text" value="">
		     <div class="row col-lg-12 <?php if($data['userType'] == 'readOnlyAdmin'){ ?>hide<?php } ?>" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">                                    		
						<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()" style="border-radius:15px;">Start Backup</a>
						<a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()" style="border-radius:15px;">Pause Backup</a>
                                                <a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()" style="border-radius:15px;">Cancel Schedule</a>
						<a class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="border-radius:15px;"><?=Language::show('Stop Backup', 'keywords');?></a>
						<span class="fBackup <?php if($data['userType'] == 'readOnlyAdmin'){ ?>hide<?php } ?>" style="display:none;margin-left:5px;">
                                                        <input id="checkbox checkbox-primary fullBackup" name="fullBackup" type="checkbox" value="Yes">
                                                        <label for="fullBackup"><?=Language::show('Full Backup', 'keywords');?></label>
                                                </span>
                                </div>
                    </div>
                    <?php //} ?>
		    <?php //if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		    <input class="d-none" id="startRestoreGet" name="startRestoreGet" type="text" value="">
                    <div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
					<a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
					<!--<a ng-if="buttonPauseValueRestore=='pauseRestore'" class="btn btn-small btn-danger pauseRestore" id="pauseRestore" name="pauseRestore" val="false" ng-click="pauseRestoreButton()">Pause Restore</a>-->
                                        <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>	
                                        <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
                                    </center>
                                </div>
                    </div>
                    <?php //} ?>
                    <div class="row col-lg-12 stopBackupWhileRestoreBlock d-none">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--event hub modal ends-->
<!--assign owner model start-->
<div class="modal fade" id="ownerShipChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'ownerShipForm',
                'autocomplete' => 'off',
                'ng-submit' => 'changeDeviceOwner()',
                ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Assign additional owners to manage the selected Asset</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="deviceNamee">Asset Name : </label>
                        <span name="deviceNamee" id="deviceNamee"></span>
		    </div>
		    <div class="form-group hide">
                        <label for="deviceOwn">Asset Own : </label>
                        <span name="deviceOwn" id="deviceOwn"></span>
                    </div>
                    <div class="form-group d-none">
                        <label for="deviceName"></label>
                        <input name="deviceName" id="ownerShipMiniCloud" type="text"/>
                    </div>
                    <div class="form-group d-none">
                        <label for="blockedUsers"></label>
                        <span name="blockedUsers" id="blockedUsers"></span>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="form-control ownerShipChange" style="width: 100%;" name="owner[]" id="selectOwnerShip" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary changeOwnerSaveBtn">Save changes</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
<!--assign owner model end-->
<!--configure sites modal start-->
<div class="modal fade configureSites whiteAndBigModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Configure Sites</h4>
		    <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
		    <a class="close pull-right" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to exit? Any changes made on this screen will be lost.', 'keywords')?></h4>" ng-bootbox-confirm-action="siteConfigurationClose()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><span aria-hidden="true">&times;</span></a>
                </div>
		<div class="modal-body">
<?php if(!isMobile()){ ?>
            <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">
	    <li role="presentation" class="nav-item" style="cursor:pointer;"><a id="configT" class="nav-link <?php if($data['userType'] == 'admin'){ ?>active <?php } ?>" data-target="#config" aria-controls="config" role="tab" data-toggle="tab">Configure Sites</a></li>
	    <li role="presentation" class="nav-item" style="cursor:pointer;"><a id="manageT" class="nav-link <?php if($data['userType'] != 'admin'){ ?>active <?php } ?>" data-target="#management" aria-controls="management" role="tab" data-toggle="tab">Manage Sites</a></li>
            </ul>
	<?php } ?>
<div class="tab-content">
	<div role="tabpanel" class="tab-pane <?php if($data['userType'] == 'admin'){ ?>active <?php } ?>" id="config">
                <!--added starts-->
                    <div class="usersFound">
                            <div class="table-responsive browsePathDivOnedrive col-lg-12">
                                <div class="row col-lg-12">
<div class="col-lg-4">
                                        <div class="checkbox check-primary" style="margin-top:15px;">
                                                <input id="autoDiscover" name="autoDiscover" id="autoDiscover" type="checkbox" value="enabled">
                                                <label for="autoDiscover"><?=Language::show('Automatically configure all discovered SharePoint Online Sites', 'keywords');?></label>
                                        </div>
</div>
<div class="col-lg-4">
                                    <div class="form-group">
                                        <!--<label for="bucketName"><?=Language::show('Change Storage repository', 'keywords');?></label><br/>
                                        <input type="text" value="" class="form-control bucketName" name="bucketName" id="bucketName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Destination OneDrive for Business account', 'keywords');?>" required autocomplete="off">-->
                                        <label for="policyName"><?=Language::show('SharePoint Online Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                </div>
				</div>				
<hr>
				<div class="row col-lg-12" id="operationWindow">
<div class="row col-lg-12 form-group">
                                        <div>
                                                <a class="btn btn-primary btn-small" href="" ng-click="discoverNow()">Discover Sites Now</a>
                                        </div>
                                </div>
<br>
<div class="form-group col-lg-12 row">
                                <input class="form-control col-lg-3" type="text" id="searchDiscoveredSite" placeholder="Search for Sites.." title="Type in a Site name">

<div class="form-group col-lg-3"></div>
                                <input class="form-control col-lg-3" type="text" id="searchConfiguredSite" placeholder="Search for Sites.." title="Type in a Site name" style="margin-left: 12px;">
</div>
				<div class="col-lg-4" style="border: 1px dotted #f27331;height: 300px;overflow-y: scroll;border-radius:10px;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead>
                                            <tr id="left">
                                                <th class="text-center"><input type="checkbox" class="select-all" id="selectAll"> </th>
                                                <th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Unconfigured SharePoint Online Sites
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
					</thead>
<tbody ng-show="discoveredSites.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Sites </span></td>
                                            </tr>
                                        </tbody>
					<tbody ng-show="discoveredSites.length > 0">
                                            <tr ng-repeat="value in discoveredSites | orderBy:sortTypeSites:sortReverseSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" id="selectLeft{{$index}}" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
                                                <td ng-click="pickElement(value, $index)" ng-cloak><span title="{{value}}" style="cursor: pointer;">{{value | limitTo:25}}{{value.length > 25 ? '...' : ''}}</span><input type="hidden" name="siteNamesU" class="siteNamesU" value="{{value}}"></td>
                                            </tr>
                                        </tbody>
				    </table>
<div id="noResults1" style="display: none;">No results found</div>
                                </div>
                                <div class="col-lg-2">
<center style="margin-top:50%;">
                                    <a ng-click="itemSelect1()" class="block btn btn-small btn-success" style="width: 50%;">><a>
                                    <br>
                                    <!--<a ng-click="addAllName()" class="block btn btn-small btn-success" style="width: 50%;"> >><a>
                                    <br>-->
                                    <a ng-click="removeName1()" class="block btn btn-small btn-danger" style="width: 50%;"><</a>
                                    <br>
                                    <!--<a ng-click="removeAllName()" class="block btn btn-small btn-danger" style="width: 50%;"><<</a>-->
</center>
                                </div>
				<div class="col-lg-6" style="border: 1px dotted #f27331;height: 300px;overflow-y: scroll;border-radius:10px;">
                                    <table id="addedSites" class="table table-hover table-bordered">
					<thead ng-show="siteMapKeys.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Site</th>
                                            </tr>
                                        </thead>
					<tbody ng-show="siteMapKeys.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Sites Selected</span></td>
                                            </tr>
                                        </tbody>
					<thead ng-show="siteMapKeys.length > 0" ng-cloak>
                                            <tr id="right">
                                                <th class="text-center"><input type="checkbox" class="select-allright" id="selectAllright"></th>
                                                <th>Site</th>
                                                <th>Policy</th>
                                            </tr>
                                        </thead>
<tbody ng-show="siteMapKeys.length > 0">
                                            <tr ng-repeat="(key,value) in aad " class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" id="selectRight{{$index}}" class="select-itemright checkbox" name="select-itemright" value="{{ key }}" ng-model="item.checked"/>
                                                </td>
                                                <td ng-click="pickElement1(key, $index)" ng-cloak><span title="{{key}}" style="cursor: pointer;">{{key | limitTo:25}}{{key.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            $la = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>" ng-selected="value == '<?=$la?>'"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
				    </table>
<div id="noResults2" style="display: none;">No results found</div>
                                </div>
                                <div class="col-lg-6">
                                </div>
</div>
                            </div>
                            <div class="col-lg-12" style="margin-top:5%;">
<div class="row">
				<div class="col-lg-6">
					<!--<a class="btn btn-primary btn-small" href="" ng-click="discoverNow()">Discover Sites Now</a>-->
                                </div>
                                <div class="col-lg-6">
                                    <a class="btn btn-success pull-right" ng-bootbox-confirm="<h4><?=Language::show('Save site policy mappings?', 'keywords')?></h4>" ng-bootbox-confirm-action="startSiteConfiguration()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Save', 'keywords');?></a>
				    <!--<button type="button" class="btn btn-default btn-small pull-right" data-dismiss="modal" style="margin-right:10px;">Close</button>-->
				    <a class="btn btn-default pull-right" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to exit? Any changes made on this screen will be lost.', 'keywords')?></h4>" ng-bootbox-confirm-action="siteConfigurationClose()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Cancel', 'keywords');?></a>
                                </div>
</div>
                            </div>
                        </div>
			<!--added ends-->
</div>
	<div role="tabpanel" class="tab-pane <?php if($data['userType'] != 'admin'){ ?>active <?php } ?>" id="management">
			<div class="row col-lg-12">
<div class="col-lg-12" style="margin-top:10px;margin-bottom:10px;">
				<input class="form-control col-lg-6" type="text" id="searchMappedSites" placeholder="Search for Sites.." title="Type in a Site name">
</div>
<div class="col-lg-12 row">
				<div class="col-lg-12" style="border: 1px dotted #f27331;border-radius:10px;height: 500px;overflow-y: scroll;">
<div id="noResults" style="display: none;">No results found</div>
                                    <table id="mappedSites" class="table table-hover table-bordered">
                                        <thead ng-show="allDevices.length <= 0" ng-cloak>
                                            <tr>
						<th>Configured SharePoint Online Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="allDevices.length <= 0">
                                            <tr>
                                                <td ng-cloak><span>No Sites Configured</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="allDevices.length > 0" ng-cloak>
                                            <tr id="back">
                                                <th class="clickAble" ng-click="sortTypeSitesM = 'userNamePlain'; sortReverseSitesM = !sortReverseSitesM">
                                                        Configured SharePoint Online Sites
                                                        <span ng-show="sortTypeSitesM == 'userNamePlain' && !sortReverseSitesM" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSitesM == 'userNamePlain' && sortReverseSitesM" class="fa fa-caret-down"></span>
                                                </th>
						<th>Policy Assigned</th>
						<th>Actions</th>
                                            </tr>
                                        </thead>
<tbody ng-show="allDevices.length > 0">
                                            <tr ng-repeat="value in allDevices |orderBy:sortTypeSitesM:sortReverseSitesM " class="text-left">
						<td ng-cloak><span title="{{value.name}}" style="cursor: pointer;">{{value.name }}</span>
<input type="hidden" class="siteNamesM" name="siteNameM" value="{{value.userNamePlain}}">
</td>
						<td><!--<span> {{value.devPolicyName}}</span>-->
				    <select ng-class="{Blocked:'invalid'}[value.status]" class="form-control selectPolicyPicker policyNamesM" name="policyNamesM[]" id="policyNameM{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value;
                                            $la = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
					    <option value="<?=$value?>" ng-selected="value.devPolicyName == '<?=$la?>'"><?=$label?></option>
                                            <?php } ?>
					<?php } ?>
                                    </select>
</td>
						<td>
							<a ng-show="value.status != 'Blocked'" class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to block the selected Site?', 'keywords')?></h4><br><span style='font-size:14px;'>Note : Blocking the asset will result in running the full backup if it is unblocked again. Do you wish to continue ?</span>" ng-bootbox-confirm-action="blockUnBlockDevice(value.uuId, true,value.userNamePlain, value.name, 'site')" ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('block', 'keywords');?></a>
							<a ng-show="value.status == 'Blocked'" class="btn btn-success btn-small" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to unblock the selected Site?', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.uuId, false,value.userNamePlain, value.name, 'site')" ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('unblock', 'keywords');?></a>
							<a ng-show="value.status == 'Blocked'" class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to delete the selected Site?', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this Site.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteDevice(value.uuId,value.userNamePlain, value.name, 'site')" ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords');?></a>
						</td>
                                            </tr>
                                        </tbody>
                                    </table>
				</div>
			</div>
		</div>
<div class="col-lg-12" style="margin-top:5%;">
<div class="row">
                                <div class="col-lg-6">
                                </div>
                                <div class="col-lg-6">
                                    <a class="btn btn-success pull-right" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to map selected sites to the selected policy?', 'keywords')?></h4>" ng-bootbox-confirm-action="savePolicy()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Save Policy', 'keywords');?></a>
				    <button type="button" class="btn btn-default pull-right" data-dismiss="modal" style="margin-right:10px;">Cancel</button>
                                </div>
</div>
                            </div>
</div>
                </div>
                <div class="modal-footer hide">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--configure sites model ends-->
        </div>
    </div>
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/BackupController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }


$(".searchDeviceNameSharepointDevice").select2({
ajax: {
            url: "<?=DIR?>"+"getAllUnBlockedSites",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultSites,
        templateSelection: selectTemplateSelectionSites,
        placeholder: 'Select sites'
    });

    function selectTemplateResultSites(users){
    	if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionSites(users){

            console.log("gggggggg : "+users.text);
            if(users.text != 'Select sites'){
            $.ajax({
            url: "<?=DIR?>"+"devicesSharepoint",
            data: {deviceName: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            console.log("newone111 : "+jData.devicesSharepoint);
            console.log("newone111 : "+jData.devicesSharepoint[0].deviceUUID);
            if (jData.devicesSharepoint){
            var options = "";
/*jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
            });*/
//$('.searchDeviceNameOnedriveDevice').html(options);
	    /*xx start*/
//$("#uuuSharepointDevice").val(users.text);	   
$("#uuuSharepointDevice").val(jData.devicesSharepoint[0].deviceUUID);
        /*xx end*/
        	}else{
//              $('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
//                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
                $("#uuuSharepointDevice").val('');
            }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
            }
        return users.text;
    }
</script>
<script>
$('.restoreDateSharepointDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
        container:'.restoreBuckettSharepointDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateSharepointDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateSharepointDevice').removeAttr('disabled');
        $('#restoreTimeSharepointDevice').removeAttr('disabled');
    } else {
        $('#restoreDateSharepointDevice').attr('disabled', true); //disable input
        $('#restoreTimeSharepointDevice').attr('disabled', true);
    }
});


$("#switchinplaceSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('required', 'required');
        $('#destinationPathlabelSharepointDevice').removeClass('star');
        $('#destinationPathSharepointDevice').attr('disabled', true);
        $('#browseSharepointDevice').attr('disabled', true);
    } else {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('disabled');
        $('#destinationPathlabelSharepointDevice').addClass('star');
        $('#destinationPathSharepointDevice').attr('required', 'required');
        $('#browseSharepointDevice').removeAttr('disabled');
    }
});

    //function searchDiscoveredSite() {
        var input1;
        input1 = document.getElementById("searchDiscoveredSite");
	input1.addEventListener("input", function () {
		var filter, table, tr, td, i, txtValue;
        table = document.getElementById("discoveredSites");
        var noResults = document.getElementById("noResults1");
            noResults.style.display = "none";
    filter = input1.value.toUpperCase();
    tr = table.getElementsByTagName("tr");
    // Hide the "No results found" message
    noResults.style.display = "none";
    for (i = 1; i < tr.length; i++) {
        td = tr[i].getElementsByTagName("td");
        var found = false;
        for (var j = 0; j < td.length; j++) {
            var cell = td[j];
            if (cell) {
                txtValue = cell.textContent || cell.innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    found = true;
                    break;
                }
            }
        }
        if (found) {
            tr[i].style.display = "";
        } else {
            tr[i].style.display = "none";
	}
	if(input1.value == ''){
                document.getElementById('selectAll').style.opacity = '1';
                document.getElementById('selectAll').style['pointer-events'] = 'unset';
        }else{
                document.getElementById('selectAll').style.opacity = '0.4';
                document.getElementById('selectAll').style['pointer-events'] = 'none';
        }
    }
    // Show "No results found" message if no matching rows
    var visibleRows = Array.from(tr).filter((row) => row.style.display !== "none");
    if (visibleRows.length <= 1) {
        noResults.style.display = "block";
    }
    document.getElementById('left').style.display = 'contents';
});
        /*tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }*/

    //function searchConfiguredSite() {
        var input2;
        input2 = document.getElementById("searchConfiguredSite");
	input2.addEventListener("input", function () {
		var filter, table, tr, td, i, txtValue;
        table = document.getElementById("addedSites");
        var noResults = document.getElementById("noResults2");
            noResults.style.display = "none";
    filter = input2.value.toUpperCase();
    tr = table.getElementsByTagName("tr");
    // Hide the "No results found" message
    noResults.style.display = "none";
    for (i = 1; i < tr.length; i++) {
        td = tr[i].getElementsByTagName("td");
        var found = false;
        for (var j = 0; j < td.length-1; j++) {
            var cell = td[j];
            if (cell) {
                txtValue = cell.textContent || cell.innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    found = true;
                    break;
                }
            }
        }
        if (found) {
            tr[i].style.display = "";
        } else {
            tr[i].style.display = "none";
	}
	if(input2.value == ''){
                document.getElementById('selectAllright').style.opacity = '1';
                document.getElementById('selectAllright').style['pointer-events'] = 'unset';
        }else{
                document.getElementById('selectAllright').style.opacity = '0.4';
                document.getElementById('selectAllright').style['pointer-events'] = 'none';
        }
    }
    // Show "No results found" message if no matching rows
    var visibleRows = Array.from(tr).filter((row) => row.style.display !== "none");
    if (visibleRows.length <= 1) {
        noResults.style.display = "block";
    }
    document.getElementById('right').style.display = 'contents';
});
        /*tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }*/
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 55px;
  height: 25px;
}
.switch input {display:none;}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}
.slider:before {
  position: absolute;
  content: "";
  height: 18px;
  width: 18px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}
input:checked + .slider {
  background-color: #f27331;
}
input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}
input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}
/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}
.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    $('#agentLogs').on('change', function(){
        $('#saveBtn').removeClass('disabled');
            if($(this).prop('checked')){
                $('#historicalLogsBlock').show();
            }else{
                $('#historicalLogsBlock').hide();
                //$('#historicalLogs').prop('checked',false);
            }
    });
    $("#stopBackupWhileRestore").click(function(){
        $('#saveBtn').removeClass('disabled');
    });
	
    $("#agentLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#historicalLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#setupLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#databases").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $('#fullBackup').on('change', function(){
        $('#saveBtn').removeClass('disabled');
    });

    $('#fullBackup').on('change', function(){
        $('#saveBtn').removeClass('disabled');
    });

    document.getElementById('agentLogs').addEventListener('click', function(){
	$('#saveBtn').removeClass('disabled');
    });
	
    $(function () {
	$('.ios').tooltip({ trigger: 'click' });
    });
</script>
<script>
    $('.searchUsernameEndPointDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        dropdownParent: $('.restoreBuckettEndPointDevice'),
        templateResult: selectTemplateResultEndPointDevice,
        templateSelection: selectTemplateSelectionEndPointDevice,
        placeholder: 'Select user'
    });
    
    function selectTemplateResultEndPointDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }
    
    function selectTemplateSelectionEndPointDevice(users){
            console.log("gggggggg : "+users.text);
            if(users.text != 'Select user'){
            $.ajax({
            url: "<?=DIR?>"+"getDeviceEndPoint",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            console.log("newone111 : "+jData.newone1);
            if (jData.newone1.length > 0){
            var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID +","+device.osType+ '">' + device.deviceName + '</option>'
});
//options += '<option value="OneDrive">My OneDrive</option>'
$('.searchDeviceNameEndPointDevice').html(options);
/*xx start*/
if (jData.newone1.length > 0){
$("#uuu").val(jData.newone1[0].deviceUUID);
$("#uuuOS").val(jData.newone1[0].osType);
 var src = jData.newone1[0].osType;
        if(src == 'apple'){
        src = 'mac';
        }
        src = src.substring(0, 3);
        src = src.toLowerCase();
        if(jData.newone1[0].osType){
            var dest = jData.newone1[0].osType;
            dest = dest.substring(0, 3);
            dest = dest.toLowerCase();
                if(src != dest)
                {
                        $('#switchinplaceEndPointDevice').attr('disabled', 'disabled');
                }else{
                        $('#switchinplaceEndPointDevice').removeAttr('disabled');
                }
        }
}
        /*xx end*/
            }else{
                $('.searchDeviceNameEndPointDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameEndPointDevice').attr("readonly", "readonly");
                $("#uuu").val('');
            }
}).fail(function(data){
            $('.searchDeviceNameEndPointDevice').html("<option value='all' selected>User has no devices configured</option>");
            $('.searchDeviceNameEndPointDevice').attr("readonly", "readonly");
            $("#uuu").val('');
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
            }
        return users.text;
    }
    
    $("#searchDeviceNameEndPointDevice").change(function () {
            var ghr = $('#searchDeviceNameEndPointDevice').val();
            if($('#searchDeviceNameEndPointDevice').val() != 'OneDrive'){
                var uuid = ghr.split(",")[0];
                var os = ghr.split(",")[1];
                console.log("uuidvvvvvv : "+uuid);
                console.log("osvvvvvv : "+os);
                $("#uuu").val(uuid);
                $("#uuuOS").val(os);
                var src = os;
                if(src == 'apple'){
                        src = 'mac';
                }
                src = src.substring(0, 3);
                src = src.toLowerCase();
                if(os){
                    var dest = os;
                    dest = dest.substring(0, 3);
                    dest = dest.toLowerCase();
                        if(src != dest)
                        {
                                $('#switchinplaceEndPointDevice').attr('disabled', 'disabled');
                        }else{
                                $('#switchinplaceEndPointDevice').removeAttr('disabled');
                        }
                }
                $('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('disabled');
                $('#destinationPathlabelEndPointDevice').addClass('star');
                $('#destinationPathEndPointDevice').attr('required', 'required');
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('disabled');
                $('#noOfThreads').addClass('star');
                $('#noOfThreads').attr('required', 'required');
                $('#switchinplaceEndPointDevice').removeAttr('disabled');
                $('#switchoverwriteNewerFilesEndPointDevice').removeAttr('disabled');
                $('#switchsuspendbackupEndPointDevice').removeAttr('disabled');
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "1";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "1";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'unset';
                document.getElementById("noOfThreadsRow").style.opacity = "1";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "1";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "block";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "none";
            }else{
                $("#uuu").val($('.deviceUUID').html());
                $('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('required', 'required');
                $('#destinationPathlabelEndPointDevice').removeClass('star');
                $('#destinationPathEndPointDevice').attr('disabled', true);
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('required', 'required');
                $('#noOfThreads').removeClass('star');
                $('#noOfThreads').attr('disabled', true);
                $('#switchinplaceEndPointDevice').attr('disabled', true);
                $('#switchoverwriteNewerFilesEndPointDevice').attr('disabled', true);
                $('#switchsuspendbackupEndPointDevice').attr('disabled', true);
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'none';
                document.getElementById("noOfThreadsRow").style.opacity = "0.5";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "none";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "block";
            }

    });
</script>
<script>
    $('.searchUsernameOutlookDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOutlookDevice'),
        templateResult: selectTemplateResultOutlookDevice,
        templateSelection: selectTemplateSelectionOutlookDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultOutlookDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOutlookDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOutlook",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOutlookDevice').html(options);
/*xx start*/
$("#uuuOutlookDevice").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOutlookDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOutlookDevice').attr("readonly", "readonly");
		$("#uuuOutlookDevice").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOutlookDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOutlookDevice').val());
	    var uuid = $('#searchDeviceNameOutlookDevice').val();	    
	    $("#uuuOutlookDevice").val(uuid);        

    });
</script>
<script>
    $('.searchUsernameOnedriveDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOnedriveDevice'),
        templateResult: selectTemplateResultOnedriveDevice,
        templateSelection: selectTemplateSelectionOnedriveDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultOnedriveDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOnedriveDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOnedrive",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOnedriveDevice').html(options);
/*xx start*/
$("#uuuOnedriveDevice").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
		$("#uuuOnedriveDevice").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOnedriveDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOnedriveDevice').val());
	    var uuid = $('#searchDeviceNameOnedriveDevice').val();	    
	    $("#uuuOnedriveDevice").val(uuid);        

    });
</script>
<script>		
    function searchedBluvaultDevices() {
    var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
    input = document.getElementById("searchBluvaultInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("devicesListTable");
    tr = table.getElementsByTagName("tr");
    for (i = 0; i < tr.length; i++) {
        td1 = tr[i].getElementsByTagName("td")[0];
        td2 = tr[i].getElementsByTagName("td")[1];
        if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
			//if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
			if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
    }
    // Show a message when no matches are found
    var noResultsMessage = document.getElementById("noResultsMessageDevice");
    if (!foundMatch) {
        noResultsMessage.style.display = "block";
    } else {
        noResultsMessage.style.display = "none";
    }
    }

    function searchedServerDevices() {
    var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
    input = document.getElementById("searchServerInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("serversListTable");
    tr = table.getElementsByTagName("tr");
    for (i = 0; i < tr.length; i++) {
        td1 = tr[i].getElementsByTagName("td")[0];
        td2 = tr[i].getElementsByTagName("td")[1];
        if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
                        //if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
                        if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
    }
    // Show a message when no matches are found
    var noResultsMessage = document.getElementById("noResultsMessageServer");
    if (!foundMatch) {
        noResultsMessage.style.display = "block";
    } else {
        noResultsMessage.style.display = "none";
    }
    }

    function searchedExchangeDevices() {
    var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
    input = document.getElementById("searchExchangeInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("devicesListExchangeTable");
    tr = table.getElementsByTagName("tr");
    for (i = 0; i < tr.length; i++) {
        td1 = tr[i].getElementsByTagName("td")[0];
        td2 = tr[i].getElementsByTagName("td")[1];
        if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
			//if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
			if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
    }
    // Show a message when no matches are found
    var noResultsMessage = document.getElementById("noResultsMessageExchange");
    if (!foundMatch) {
        noResultsMessage.style.display = "block";
    } else {
        noResultsMessage.style.display = "none";
    }
}

function searchedOnedriveDevices() {
    var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
    input = document.getElementById("searchOnedriveInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("devicesListOnedriveTable");
    tr = table.getElementsByTagName("tr");
    for (i = 0; i < tr.length; i++) {
        td1 = tr[i].getElementsByTagName("td")[0];
        td2 = tr[i].getElementsByTagName("td")[1];
        if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
			//if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
			if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
    }
    // Show a message when no matches are found
    var noResultsMessage = document.getElementById("noResultsMessageOnedrive");
    if (!foundMatch) {
        noResultsMessage.style.display = "block";
    } else {
        noResultsMessage.style.display = "none";
    }
}    


function searchedSharepointDevices() {
    var input, filter, table, tr, td1, td2, i, txtValue1, txtValue2, foundMatch = false;
    input = document.getElementById("searchSharepointInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("devicesListSharepointTable");
    tr = table.getElementsByTagName("tr");
    for (i = 0; i < tr.length; i++) {
        td1 = tr[i].getElementsByTagName("td")[0];
        td2 = tr[i].getElementsByTagName("td")[1];
        if (td1 && td2) {
                        txtValue1 = td1.title || td1.textContent;
                        txtValue2 = td2.title || td2.textContent;
			//if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
			if(txtValue1.toUpperCase().indexOf(filter) > -1 || txtValue2.toUpperCase().indexOf(filter) > -1){
                                tr[i].style.display = "";
                                foundMatch = true;
                        } else {
                                tr[i].style.display = "none";
                        }
                }
    }
    // Show a message when no matches are found
    var noResultsMessage = document.getElementById("noResultsMessageSharepoint");
    if (!foundMatch) {
        noResultsMessage.style.display = "block";
    } else {
        noResultsMessage.style.display = "none";
    }
}

$("input.select-all").click(function () {
	angular.element(document.getElementById('searchDiscoveredSite')).scope().updateCheckedItemsCount();
	console.log("vvvvvv");
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            /*if($("input.select-item:checked:checked").length > 1){
                $('.actionn').hide();
                $('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');
            }else{
                $('.actionn').show();

                $('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');
}*/
});

$("input.select-allright").click(function () {
        //console.log("vvvvvv");
            var checked = this.checked;
            $("input.select-itemright").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
	    });
	    //angular.element(document.getElementById('searchDiscoveredSite')).scope().updateCheckedItemsCount();
});

$(document).on("click", "input.select-item", function () {
    if (!$(this).is(':disabled')) {
        if (!this.checked) {
            $("input.select-all").prop("checked", false);
        } else {
            var allChecked = true;
            $("input.select-item").each(function () {
                if (!$(this).is(':disabled') && !this.checked) {
                    allChecked = false;
                }
            });
            $("input.select-all").prop("checked", allChecked);
        }
    }
});

$(document).on("click", "input.select-itemright", function () {
    if (!$(this).is(':disabled')) {
        if (!this.checked) {
            $("input.select-allright").prop("checked", false);
        } else {
            var allChecked = true;
            $("input.select-itemright").each(function () {
                if (!$(this).is(':disabled') && !this.checked) {
                    allChecked = false;
                }
            });
            $("input.select-allright").prop("checked", allChecked);
        }
    }
});
/*var selectAllCheckbox = document.getElementById("selectAll");
var checkboxes = document.querySelectorAll(".select-item");
checkboxes.forEach(function(checkbox) {
    checkbox.addEventListener("change", function() {
        if (!this.checked) {
            selectAllCheckbox.checked = false;
        } else {
            // Check if all individual checkboxes are checked
            var allChecked = Array.from(checkboxes).every(function(checkbox) {
                return checkbox.checked;
            });
            selectAllCheckbox.checked = allChecked;
        }
    });
});*/
$(document).ready(function () {
    // When the modal is hidden, clear the search input and show all table rows
    $('.configureSites').on('hidden.bs.modal', function () {
        var input = document.getElementById("searchDiscoveredSite");
        input.value = ''; // Clear the search input
        var table = document.getElementById('discoveredSites');
        var rows = table.getElementsByTagName("tr");
        // Show all rows
        for (var i = 0; i < rows.length; i++) {
            rows[i].style.display = "";
	}
	var input = document.getElementById("searchConfiguredSite");
        input.value = ''; // Clear the search input
        var table = document.getElementById('addedSites');
        var rows = table.getElementsByTagName("tr");
        // Show all rows
        for (var i = 0; i < rows.length; i++) {
            rows[i].style.display = "";
	}
	var input = document.getElementById("searchMappedSites");
        input.value = ''; // Clear the search input
        var table = document.getElementById('mappedSites');
        var rows = table.getElementsByTagName("tr");
        // Show all rows
        for (var i = 0; i < rows.length; i++) {
            rows[i].style.display = "";
	}
	document.getElementById('noResults1').style.display = "none";
	document.getElementById('noResults2').style.display = "none";
	document.getElementById('noResults').style.display = "none";
	document.getElementById('selectAll').style.opacity = '1';
        document.getElementById('selectAll').style['pointer-events'] = 'unset';

    });
});

/*assign owner start*/
function addCurrentOwner(deviceId, deviceName, deviceUUID) {
        var abc = deviceUUID;
        owner.val(null).trigger("change");
        var miniClouds = $('#ownerFor'+deviceId).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectOwnerShip').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="deviceName"]').val(abc);
	document.getElementById("deviceNamee").innerHTML = deviceName.replaceAll('_PB_',' ');
        document.getElementById("deviceOwn").innerHTML = $('#userName'+deviceId).html();
        $('#ownerShipChange').modal('show');
        owner.val(miniClouds).trigger("change");
    }

    $('#ownerShipChange').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });
    
    
    
    var owner = $(".ownerShipChange").select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceOwner",   
            dataType: 'json',
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.changeOwnerSaveBtn').removeAttr('disabled', 'disabled');
                }
                return {
		results: $.map(data.users, function (o) {
			if($('#deviceOwn').html() != o.userName ){
				return { id: o.userName, text: o.userName, img: o.profilePic, active: o.active };
			}
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        templateResult: selectTemplateResultOwner,
        templateSelection: selectTemplateSelectionOwner,
        minimumInputLength: 3,
        placeholder: 'Select a Owner'
    });
    
    function selectTemplateSelectionOwner(users){
            if(users.active == false){
                    if($('#blockedUsers').html() != ''){
			    var miniClouds1 = $('#blockedUsers').html().split(',');
			    miniClouds1.push(users.text);
			    document.getElementById("blockedUsers").innerHTML = miniClouds1;
                    }else{
			    document.getElementById("blockedUsers").innerHTML = users.text;
                    }
                    document.getElementById("blockedUsers").innerHTML = removeDuplicates($('#blockedUsers').html().split(','));                 
            }
            console.log("selectOwnerShip : "+$('#selectOwnerShip').val());
            if($('#blockedUsers').html() != ''){
                    var miniClouds1 = $('#blockedUsers').html().split(',');
                    miniClouds1.forEach(function(key){
                            if(!$('#selectOwnerShip').val().includes(key)){
                                    var index = miniClouds1.indexOf(key);
                                    if (index >= 0) {
                                            console.log("spliceeee");
                                  miniClouds1.splice( index, 1 );
                                }
                        }
                    });
                    document.getElementById("blockedUsers").innerHTML = miniClouds1;

            }
        return users.text;
    }
    
    function selectTemplateResultOwner(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }
	
    function removeDuplicates(arr) {
        return arr.filter((item,
            index) => arr.indexOf(item) === index);
    }
    /*assign owner end*/
    function configureSites(){
            angular.element(document.getElementById('searchSharepointInput')).scope().configureSites();
    }

    var inputManage;
        inputManage = document.getElementById("searchMappedSites");
        inputManage.addEventListener("input", function () {
        var filter, table, tr, td, i, txtValue;
        var foundMatch = false;
        table = document.getElementById("mappedSites");
    	filter = inputManage.value.toUpperCase();
    	tr = table.getElementsByTagName("tr");
    	// Hide the "No results found" message
    	var noResults = document.getElementById("noResults");
    	noResults.style.display = "none";
    		for (i = 0; i < tr.length; i++) {
        	td1 = tr[i].getElementsByTagName("td")[0];
        	td2 = tr[i].getElementsByTagName("td")[1];
        	if (td1) {
                        	txtValue1 = td1.title || td1.textContent;
                        	//txtValue2 = td2.title || td2.textContent;
                        	//if(txtValue1.toUpperCase().startsWith(filter) || txtValue2.toUpperCase().startsWith(filter)){
                        	if(txtValue1.toUpperCase().indexOf(filter) > -1){
                                	tr[i].style.display = "";
                                	foundMatch = true;
                        	} else {
                                	tr[i].style.display = "none";
                        	}
                	}
    		}
    		var noResults = document.getElementById("noResults");
    		if (!foundMatch) {
        		noResults.style.display = "block";
    		} else {
        		noResults.style.display = "none";
    		}
	});
</script>
<style>
    .invalid{
        background-color: gainsboro !important;
	pointer-events:none !important;
    }
    .disabled-link {
	pointer-events: none;
	opacity: 0.4;
    	color: grey; /* You can customize the color for a disabled link */
    	text-decoration: none;
    }    
    .files-table tbody tr td{
        padding: 10px 15px 5px 15px;
    }
    .greyBck{
                background: lightgrey !important;
                color:black;
                text-decoration:none;
                cursor:unset;
        /*      pointer-events:none;*/
            }
	.greySelect{
                /*background: lightgrey !important;*/
                pointer-events:none;
            }
</style>
