<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 28/10/2022
* @time 18:30 PM
*
 */
?>
<div id="userAlert" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
        <span style="color: white;font-size: 18px;" id="userPercentage"> </span>
        <span class="pull-right" ng-click="closeUserWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div id="storageAlert" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
        <span style="color: white;font-size: 18px;" id="storagePercentage"> </span>
        <span class="pull-right" ng-click="closeStorageWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div class="main" ng-controller="ReportController">
    <span class="d-none currentPage"><?='licenseOptimizer'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-12 col-md-12 col-sm-12">
<div class="modal fade" id="confirmationModalEndPoint" tabindex="-1" role="dialog" aria-labelledby="confirmationModalEndPointLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" >Warning</h5>
      </div>
      <div class="modal-body">
        There are unsaved changes. Are you sure you want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" id="confirmCancelChangeEndPoint">Cancel</button>
        <button type="button" class="btn btn-primary" id="confirmTabChangeEndPoint">Proceed</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="confirmationModalServer" tabindex="-1" role="dialog" aria-labelledby="confirmationModalServerLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="z-index:111111;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Warning</h5>
      </div>
      <div class="modal-body">
        There are unsaved changes. Are you sure you want to proceed?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" id="confirmCancelChangeServer">Cancel</button>
        <button type="button" class="btn btn-primary" id="confirmTabChangeServer">Proceed</button>
      </div>
    </div>
  </div>
</div>
<div class="row">
<div class="panel-heading col-lg-12">
                                <h4 class="currentBackup text-center">License Optimizer </h4>
                            </div>
<div class="col-lg-12">
<?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;font-size: small;">
                            <li role="presentation" class="nav-item"><a href="" id="endpointOptimizerM" class="nav-link active" data-target="#endpointOptimizer" aria-controls="endpoint" role="tab" data-toggle="tab">Endpoint</a></li>
                            <?php if($data['serverMgmt'] == 'yes'){?>
                            <li role="presentation" class="nav-item"><a href="" id="serverOptimizerM" class="nav-link" data-target="#serverOptimizer" aria-controls="server" role="tab" data-toggle="tab">Server Backup</a></li>
                            <?php } ?>
                    </ul>
                <?php } ?>
</div>
<br>            <br>
                <div class="tab-content col-lg-12">
                    <div role="tabpanel" class="tab-pane panel active" id="endpointOptimizer">
                            <div class="row">
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
					    <div class="background">
					    </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Users</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalNoOfActiveUsers }} / {{statisticsOptimizer.totalNoOfUsersAlloted}}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalStorageUtilized }} / {{ statisticsOptimizer.totalStorageAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <span class="hide" id="actual_totalNoOfActiveUsers"></span>
                                <span class="hide" id="actual_totalStorageUtilized"></span>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Users will be reduced by</p><p id="usersReducedTo" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
				</div>
				<div class="col-lg-6 optimizerDiv" style="border: 1px solid #F27331!important;border-radius: 10px;height:350px;overflow-y:scroll;">
                                        <h4 style="text-align:center;text-decoration:underline;margin:5%;">Select Users and Assets to delete.</h2>
                                        <span ng-if="quotaDevices1.length <= 0">No data available</span>
                                        <div class="col-lg-12" ng-repeat="(key, devices) in quotaDevices1" class="item" ng-cloak>
                                                <label><input type="checkbox" id="parent_{{key}}" value="{{key}}" ng-model="selectAll[key]" ng-change="toggleSelectAll(key)" style="margin-right:10px;"><i class="fa fa-user"></i> {{ key }}</label>
                                                <span class="item-title" ng-click="toggleCollapse(key)" ng-class="{'no-children': quotaDevices1[key].length === 0}">
                                                        <span ng-if="!isExpanded[key]" style="color:green;"><i class="fa fa-plus-circle"></i></span>
                                                        <span ng-if="isExpanded[key]" style="color:red;"><i class="fa fa-minus-circle"></i></span>
                                                </span>
                                                <p ng-repeat="device in devices track by $index" style="margin-left:10%;" class="expandable" ng-class="{'expanded': isExpanded[key]}"><label><input type="checkbox" class="child_{{key}}" value="{{device.deviceUUID}}" ng-model="device.selected" ng-change="toggleSelection(device, key)" style="margin-right:10px;"><i class="fa fa-{{ device.icon }} fa-1x"></i> {{device.name}} [{{device.storageUsedByDeviceGB}}]</label></p>
                                                <hr style="margin-top:unset;margin-bottom: 10px;">
                                        </div>
                                </div>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Managed Data will be reduced by</p><p id="storageReducedTo" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
				</div>
                            </div>
                            <div class="row col-lg-12 "style="justify-content:center;margin-top:10px;">
                                <a class="btn btn-success btn-small" ng-click="applyCompliance()" href="javascript:;">Apply</a>
                                <a class="btn btn-primary btn-small" id="closeQuotaManagerEndpoint" ng-click="cancelQuotaManagerEndpoint()" href="javascript:;">Reset</a>
                            </div>
                    </div>
                    <div role="tabpanel" class="tab-pane panel" id="serverOptimizer">
                            <div class="row">
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-users"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Servers</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalNoOfServerDevices }} / {{statisticsOptimizer.totalNoOfServersAlloted}}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-desktop"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 16px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statisticsOptimizer.totalStorageUtilized }} / {{ statisticsOptimizer.totalStorageAlloted }}</span>
                                            </div>
					</div>
                                </div>
                             </div>
                            <div class="row col-lg-12">
                                <span class="hide" id="actual_totalNoOfActiveServers"></span>
                                <span class="hide" id="actual_totalStorageUtilizedServer"></span>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                            </div>
                                            <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Servers will be reduced by</p><p id="serversReducedTo" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-6 optimizerDivServer" style="border: 1px solid #F27331!important;border-radius: 10px;height:350px;overflow-y:scroll;">
                                        <h4 style="text-align:center;text-decoration:underline;margin:5%;">Select Servers to delete.</h2>
                                        <span ng-if="quotaServers1.length <= 0">No data available</span>
                                        <div class="col-lg-12" ng-repeat="server in quotaServers1" class="item">
                                                <label><input type="checkbox" id="parent_{{server.name}}" value="{{server.uuId}}" ng-model="server.selected" ng-change="toggleSelectionServer(server)" style="margin-right:10px;" ><i class="fa fa-desktop"></i> {{ server.name }} [{{server.storageUsedByDeviceGB}}]</label>
                                                <hr style="margin-top:unset;margin-bottom: 10px;">
                                        </div>
                                </div>
                                <div class="col-lg-3" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
					    </div>
					    <div class="panel-body widget widget-body" style="text-align:center;">
                                                <p style="font-size: 16px;color:white;">Managed Data will be reduced by</p><p id="storageReducedToServer" style="font-size: 20px;color:white;" ng-cloak>0</p>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row col-lg-12 "style="justify-content:center;margin-top:10px;">
                                <a class="btn btn-success btn-small" ng-click="applyComplianceServer()" href="javascript:;">Apply</a>
                                <a class="btn btn-primary btn-small" id="closeQuotaManagerServer" ng-click="cancelQuotaManagerServer()" href="javascript:;">Reset</a>
                            </div>
                    </div>
                </div>
</div>
            <div class="modal fade applyComplianceNewConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body" ng-if="inCompliance == 'Yes'">
                            <p>
                                <span>Are you sure you want to apply the changes?</span>
                            </p>
<div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        These changes may require some time to take effect.
				    </p>
				</div>
                            </div>
                        </div>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="applyComplianceNewConfirmation()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                        <div class="modal-body" ng-if="inCompliance == 'No'">
                            <p>
                                <span>You might want to reduce the storage consumption a down to {{storageCompliancePercentage}}GB little more in order to ensure that your next few scheduled backups are successful.</span>
                            </p>
                            <button type="button" class="btn btn-success" data-dismiss="modal" style="float:right;">Yes</button>
                            <button type="button" ng-click="applyComplianceNewConfirmation()" class="btn btn-default" style="float:right;margin-right:5px;">No</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade gotoDeviceComplianceConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation for moving to Storage Compliance</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span>It seems that Users are still not in compliance state. Do you wish to go for Storage Compliance?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
			    <button type="button" ng-click="gotoDeviceComplianceConfirm()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade gotoUserComplianceConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation for moving to User Compliance</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span>It seems that Storage is still not in compliance state. Do you wish to go for User Compliance?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="gotoUserComplianceConfirm()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade applyComplianceNewConfirmationServer">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body" ng-if="inComplianceServer == 'Yes'">
                            <p>
                                <span>Are you sure you want to apply the changes?</span>
                            </p>
<div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        These changes may require some time to take effect.
                                    </p>
                                </div>
                            </div>
                        </div>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">No</button>
                            <button type="button" ng-click="applyComplianceNewConfirmationServer()" class="btn btn-success" style="float:right;margin-right:5px;">Yes</button>
                        </div>
                        <div class="modal-body" ng-if="inComplianceServer == 'No'">
                            <p>
                                <span>You might want to reduce the storage consumption a down to {{storageCompliancePercentageServer}}GB little more in order to ensure that your next few scheduled backups are successful.</span>
                            </p>
                            <button type="button" class="btn btn-success" data-dismiss="modal" style="float:right;">Yes</button>
                            <button type="button" ng-click="applyComplianceNewConfirmationServer()" class="btn btn-default" style="float:right;margin-right:5px;">No</button>
                        </div>
                    </div>
                </div>
            </div>
<!--qouta manager end-->
</div>
<div id="overlayTextDelegated"><center><h2 style="color:white;margin-top:20%;">Loading.....</h2></center></div>
    <?php //View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<script>
    $("#closeQuotaManager").click(function() {
        $('#quotaManager').modal('hide');
        location.reload();
    });
</script>
<style>
.fab-wrapper{
display: none!important;
}
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 22px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 3px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
	    .invalid{
                background-color: gainsboro !important;
                cursor:not-allowed !important;
                opacity: 0.4 !important;
                pointer-events:none !important;
            }
            div.dropdown-menu.open{
                max-height: 314px !important;
                overflow: hidden;
            }
            ul.dropdown-menu.inner{
                max-height: 260px !important;
                overflow-y: auto;
            }
            .parentLink.active{
                background-color: #F27331!important;
            }
            .greyBck{
                background: lightgrey !important;
                color:black;
                text-decoration:none;
                cursor:unset;
            }
	.greySelect{
		pointer-events:none;
        }
	.invalid{
            background-color: gainsboro !important;
            cursor:not-allowed !important;
            opacity: 0.4 !important;
            pointer-events:none !important;
        }
        div.dropdown-menu.open{
            max-height: 314px !important;
            overflow: hidden;
        }
        ul.dropdown-menu.inner{
            max-height: 260px !important;
            overflow-y: auto;
        }
        #overlayTextDelegated {
          position: fixed;
          display: none;
          width: 100%;
          height: 100%;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          background-color: rgba(0,0,0,0.5);
          z-index: 1000000000000;
          cursor: pointer;
        }
	.expandable-row {
            cursor: pointer;
        }
        .expandable {
            display: none;
        }
        .expanded {
            display: table-row;
        }
        .expandable {
            display: none;
        }
        .expanded {
            display: block;
        }

        .item {
            margin-bottom: 10px;
        }
        .item-title {
            cursor: pointer;
        }
        .expand-icon::before{
            content: '&#xf055';
            font-weight: bold;
            cursor: pointer;
        }
        .collapse-icon::before {
            content: '&#xf056;';
            font-weight: bold;
	    cursor: pointer;
        }
        .item-title.no-children {
            display: none;
        }
        .match{
            pointer-events: none;
            opacity: 0.4;
        }
	.serverDevicesListTable td{
	    vertical-align:middle;
	}
    </style>
