/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ShareController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = true;
    $scope.sortType = 'sharedTimeInMillis';
    $scope.items = [];
    $scope.selected = [];
    $scope.showShareLink = false;
    
    $scope.showDetails = function(value){
        $('#sharedEmailsModal').modal('show');
        $scope.sharedFilesEmails = value.split(',');
//        $scope.$apply();
            if($scope.sharedFilesEmails.length > 15){
                $('.emailsListDiv').css('overflowY', 'scroll');
                $('.emailsListDiv').height('300px');
            }else{
                $('.emailsListDiv').css('overflowY', 'unset');
                $('.emailsListDiv').height('inherit');
            }
    };
	
    $scope.showSharedFiles = function(value, destination, isShareLatestVersion, devicePath, userName, gatewayName, isView, isDownload){
        $('#sharedFilesModal').modal('show');
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/getSharedFilesList',
            type: 'POST',
            data: {id: value, destinationCollection : destination, isShareLatestVersion: isShareLatestVersion, devicePath: devicePath, userName: userName, gatewayName: gatewayName, isView: isView, isDownload: isDownload}
        }).done(function(data){
            var jData = JSON.parse(data);
            $scope.sharedFileDetails = jData.data;
            if(jData.result == 'success'){
               $scope.sharedFilesList = jData.items;
            }else{
                $('#sharedFilesModal').modal('hide');
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFileList = function(filePath, currentPath, update, refreshed){
        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/myShares',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                disableButtons();
                $('.filePanel').show();
                $scope.items = jData.items;
                $scope.$apply();
                toastr.info('Page loaded successfully', 'Information!!!', {allowHtml: true});
                if($scope.items.length <= 0){
                    $('.status').show();
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.selectionStart = function(selected){
        $scope.selected = [];
    };

    $scope.selectionStop = function(selected){
        disableButtons();
        $scope.selected = selected;
        if(selected.length == 1){
            enableButtons();
        }
    };

    function disableButtons(){
        $('.getLink').hide();
        $('.unShare').hide();
	$('.share').hide();
        $('.openFile').hide();
    }

    function enableButtons(){
        if($scope.selected.length > 0){
            $('.getLink').show();
            $('.unShare').show();
	        $('.share').show();
            $('.openFile').show();
        }
    }

    function loadMenuOptions(){
    $scope.menuOptions = [
        $scope.showShareLink ? ['Get Link', function ($itemScope) {
            $scope.getLink();
        }, function(){
            if($('.shareType').html() != 'shareWith'){
                if($scope.selected.length == 1){
                    return true;
                }
            }
        }] : " ",
	['Edit', function ($itemScope) {
            $scope.share();
        }, function(){
            if($('.shareType').html() == 'share') {
                if ($scope.selected.length == 1) {
                    return true;
                }
            }
        }],
        /*['Un-Share', function ($itemScope) {
            $scope.unShareFile();
        }, function(){
                if($scope.selected.length == 1) {
                    return true;
                }
        }],*/
        ['Open File Location', function ($itemScope) {
            $scope.openFile();
        }, function(){
            if($scope.selected.length == 1){
                return true;
            }
        }],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                return true;
            }
        }]
    ];
    }

    $scope.getLink = function(){
        $('#shareLink').modal('show');
        var data = {
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath,
	    fileId   : $scope.selected[0].fileId
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            $('.shareLinkLoading').hide();
            $('.shareLinkBody').show();
            var jData = JSON.parse(data);
            $scope.sharedFileDetails = jData.data;
            if(jData.result == true){
                $('.unShareBtn').show();
                $('.shareLinkBlockLink').show();
		jData.link = jData.link+'?userName='+$('.uploadUserName').html();
                $('.shareLinkLink').html(jData.link);
                $('#isgoogleAuthIsEnabled').val(jData.data.googleAuthIsEnabled);
            }else{
                $('#shareLink').modal('hide');
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.openFile = function(){
//        if($scope.selected[0].backupID.length > 0){
        if($scope.selected[0].isBackup == 'true'){
            window.location.href = $scope.BASE_FOLDER+'/backup/openFileLocation?filePath='+$scope.selected[0].devicePath+"&deviceID="+$scope.selected[0].deviceID+"&deviceUUID="+$scope.selected[0].deviceUUID+"&deviceName="+$scope.selected[0].deviceName;
        }else{
            window.location.href = $scope.BASE_FOLDER+'/openFileLocation?filePath='+$scope.selected[0].devicePath;
        }
    };

    $scope.unShareFile = function(){
        var url = "";
        var data = {};
        /*if($scope.selected[0].backupID.length > 0){
            url = $scope.BASE_FOLDER+'/backup/files/unShare';
            data = {
                fileName : $scope.selected[0].fileName,
                filePath : $scope.selected[0].devicePath,
                csrf_token : $('.csrf_token').html(),
                backupID : $scope.selected[0].backupID
            };
        }else{*/
            url = $scope.BASE_FOLDER+'/sync/files/unShare';
            data = {
                fileName : $scope.selected[0].fileName,
                filePath : $scope.selected[0].devicePath,
		fileId   : $scope.selected[0].fileId,
		sharedBackupImageIds	: $scope.selected[0].backupIDs
            };
        //}
        $.ajax({
            url: url,
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result = 'success'){
                $('#share').modal('hide');
                $('#shareWith').modal('hide');
                $scope.updateFileList('root', 'root', true, true);
                toastr.success('File has been successfully unshared', 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.copyToClipboard = function(){
        toastr.success('Copied to Clipboard');
    };
    
    $scope.sendEmailShareLink = function(){
        $('.sendEmailShareForm').toggleClass('hide');
    };
    
    $('#share').on('hidden.bs.modal', function () {
        $(this).removeData('bs.modal');
        $('.shareLoading').show();
        $('.shareBody').hide();
        $('.shareLinkBlock').hide();
        $('.shareBtn').hide();
        $('.unShareBtn').hide();
        $('.updateShareDetails').hide();
    });

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'trash'){
            blockUI.start();
            $scope.updateFileList('root', 'root', true, true);
        }

	var googleAuthIsEnabled = document.querySelector('.googleAuthIsEnabled');
        if(googleAuthIsEnabled){ var init = new Switchery(googleAuthIsEnabled, { color: '#4CAF50'}); }
	    
	var linkExpiryAlertsEnabled = document.querySelector('.linkExpiryAlertsEnabled');
        if(linkExpiryAlertsEnabled){ var init = new Switchery(linkExpiryAlertsEnabled, { color: '#4CAF50'}); }
	    
	var shareLatestVersion = document.querySelector('.shareLatestVersion');
        if(shareLatestVersion){ var init = new Switchery(shareLatestVersion, { color: '#4CAF50'}); }

	var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        if(sharePasswordSwitch){ var init = new Switchery(sharePasswordSwitch, { color: '#4CAF50', size: 'large'}); }

        var enableDownload = document.querySelector('.enableDownload');
        if(enableDownload){ var init = new Switchery(enableDownload, { color: '#4CAF50'}); }

        var enableView = document.querySelector('.enableView');
        if(enableView){ var init = new Switchery(enableView, { color: '#4CAF50'}); }

	$scope.getUserPolicy();

    });

    function getCommon(arr1, arr2) {
	  var common = [];                   // Array to contain common elements
	  for(var i=0 ; i<arr1.length ; ++i) {
	    for(var j=0 ; j<arr2.length ; ++j) {
	      if(arr1[i] == arr2[j]) {       // If element is in both the arrays
		common.push(arr1[i]);        // Push to common array
	      }
	    }
	  }

	  return common;                     // Return the common elements
    }

    $scope.sendShareEmail = function(emails){
	var type = $('.shareDomainType').html();
        var shareDomainIncExclusions = $('.shareDomainIncExclusions').html();
        var domainsList = shareDomainIncExclusions.split(',');
        var jj = emails.split(',');
        var present =  'yes';
	if($scope.shareDomainsEnabled == true){
		if(type == "Share only with these Email domains"){
			var domain;
			var newDomain = [];
			jj.forEach(function(value2){
				domain = value2.substring(value2.indexOf('@') + 1);
				newDomain.push(domain);
			});
			let uniqueChars = newDomain.filter((c, index) => {
				return newDomain.indexOf(c) === index;
			});
			var emailDomains = uniqueChars;
			var n;
			for(let i=0; i<emailDomains.length; i++){
				for(let j=0; j<domainsList.length; j++){
					if(domainsList.includes(emailDomains[i])){
						n = 'yes';
					}else{
						n = 'no';
					}
					if(n == 'no'){
						toastr.error('One or more email recipients are disallowed by your policy.  Check your policy settings and remove such disallowed recipients.  To effect any changes in the policy, please consult your Administrator.');
						return;
					}
				};
			};
		}

		if(type == "Share with all Email domains excepting these"){
			var commonWithExclusion = getCommon(jj, $('.shareDomainIncExclusionsException').html().split(','));
                        var toRemove = $('.shareDomainIncExclusionsException').html().split(',');
                        console.log("commonWithExclusion : "+commonWithExclusion);
                        var difference = jj.filter((item) => !toRemove.includes(item));
                        console.log("difference : "+difference);
                        for(let i=0; i<difference.length; i++){
                                for(let j=0; j<domainsList.length; j++){
                                        if(difference[i].includes(domainsList[j])){
                                                n = 'no';
                                        }else{
                                                n = 'yes';
                                        }
                                        if(n == 'no'){
                                                toastr.error('One or more email recipients are disallowed by your policy.  Check your policy settings and remove such disallowed recipients.  To effect any changes in the policy, please consult your Administrator.');
                                                return;
                                        }
                                };
                        }
                        emails = difference.concat(commonWithExclusion);
                        emails = emails.join().trim();			
		}
	}
        if(emails != undefined && emails.length > 0){
            $('.loading').show();
            var html = $('.shareEmailLinkSendBtn').html();
            $('.shareEmailLinkSendBtn').attr('disabled','disabled');
            $('.shareEmailLinkSendBtn').html('Sending... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    var googleAuthIsEnabled = document.querySelector('.googleAuthIsEnabled');
	    var isgoogleAuthIsEnabled = googleAuthIsEnabled.checked;
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/sendShareEmail',
                data: {emails: emails, url: $('.shareLink').html(), filePath: $scope.selected[0].devicePath, fileName: $scope.selected[0].fileName, csrf_token: $('.csrf_token').html(),googleAuthIsEnabled: isgoogleAuthIsEnabled, exceptionEmails: $('.shareDomainIncExclusionsException').html(), id: $scope.selected[0].fileId, sharedBackupImageIds:$scope.selected[0].backupIDs},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                console.log(data);
                $('.shareEmailLinkSendBtn').removeAttr('disabled');
                $('.shareEmailLinkSendBtn').html(html);
                if(jData.result == 'success'){
                    $('.sendEmailShareForm').addClass('hide');
                    $('#emails').val('');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>email address</b>', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.getUserPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/user/policy',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.userAssignedPolicy = jData.policy;
		$scope.showShareLink = jData.policy.showShareLink;
		console.log("scope.userAssignedPolicy : "+JSON.stringify($scope.userAssignedPolicy));
                if(jData.policy.twoWayShareEnabled == '1'){
                    $('#twoWay').show();
                    $('#twoWayNormal').show();
                    $('#shareWithHome').hide();
                    $('#shareHome').hide();
                    $('#home').removeClass('active');
                    $('#home').removeClass('in');
                    $('#shareWithSimple').addClass('active');
                    $('#shareWithSimple').addClass('in');
                    $('#shareWithHome').removeClass('active');
                    $('#twoWay').addClass('active');

                    $('#home1').removeClass('active');
                    $('#home1').removeClass('in');
                    $('#shareWithNormal').addClass('active');
                    $('#shareWithNormal').addClass('in');
                  }
                  else{
                    $('#twoWay').hide();
                    $('#twoWayNormal').hide();
                    $('#shareWithHome').show();
                    $('#shareHome').show();
                    $('#home').addClass('active');
                    $('#home').addClass('in');
                    $('#shareWithSimple').removeClass('active');
                    $('#shareWithSimple').removeClass('in');
                    $('#shareWithHome').addClass('active');
                    $('#twoWay').removeClass('active');

                    $('#home1').addClass('active');
                    $('#home1').addClass('in');
                    $('#shareWithNormal').removeClass('active');
                    $('#shareWithNormal').removeClass('in');
                  }
                /*$scope.isAdminDeleteBackupFile = $('.isAdminDeleteBackupFile').html();
                $scope.showOpen = jData.policy.menuOptions.open;
                $scope.showView = jData.policy.menuOptions.view;
                $scope.showVersions = jData.policy.menuOptions.versions;
                $scope.showShare = jData.policy.menuOptions.share;
                $scope.showdownload = jData.policy.menuOptions.download;
                $scope.showrename = jData.policy.menuOptions.rename;
                $scope.showcutcopypaste = jData.policy.menuOptions.cutCopyPaste;
                $scope.showFileUpload = jData.policy.menuOptions.fileUpload;
                $scope.showCreateFolder = jData.policy.menuOptions.createFolder;
                $scope.showCreateMinicloud = jData.policy.menuOptions.createMiniCloud;
                $scope.showDelete = jData.policy.menuOptions.delete;
                $scope.showShareLink = jData.policy.showShareLink;
                $scope.shareDomainsEnabled = jData.policy.shareDomainsEnabled;*/
                $scope.$apply();
                loadMenuOptions();
            }else{
                toastr.info('You have not assigned a policy yet!!!', 'Information!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

$scope.share = function(){
        if ($scope.selected.length > 10){
                toastr.error('Allowed multiple files count for sharing is 10, Please check the selection.', 'Information!!!');
                return;
        }
        $('#share').modal('show');
        $('.shareLoading').show();
        $('.shareBody').hide();
        $('.shareLinkBlock').hide();
        $('.shareBtn').hide();
        $('.unShareBtn').hide();
        $('.changeImpactText').hide();
        $('.updateShareDetails').hide();
        $('.shareBtn').html('Share');
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        var linkExpiryAlertsEnabled = document.querySelector('.linkExpiryAlertsEnabled');
        var shareLatestVersion = document.querySelector('.shareLatestVersion');
        var googleAuthIsEnabled = document.querySelector('.googleAuthIsEnabled');

        var data = {
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath,
	    fileId  : $scope.selected[0].fileId,
        };
        console.log(data);
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            console.log(data);
            $('.shareLoading').hide();
            $('.shareBody').show();
            var jData = JSON.parse(data);
            console.log(jData);
            $scope.sharedFileDetails = jData.data;
            	if(jData.result == true){
                if(jData.data.shareLatestVersion == true){
                    if(shareLatestVersion.checked == false){
                        $('.shareLatestVersion').click();
                    }
            }else{
                    if(shareLatestVersion.checked == true){
                        $('.shareLatestVersion').click();
                    }
            }
            if(jData.data.googleAuthIsEnabled == true){
                    if(googleAuthIsEnabled.checked == false){
                        $('.googleAuthIsEnabled').click();
                    }
            }else{
                    if(googleAuthIsEnabled.checked == true){
                        $('.googleAuthIsEnabled').click();
                    }
            }
            if(jData.data.linkExpiryAlertsEnabled == true){
                    if(linkExpiryAlertsEnabled.checked == false){
                        $('.linkExpiryAlertsEnabled').click();
                    }
            }else{
                    if(linkExpiryAlertsEnabled.checked == true){
                        $('.linkExpiryAlertsEnabled').click();
                    }
            }
            if(jData.data.passwordProtected == true){
                    if(sharePasswordSwitch.checked == false){
                        $('.sharePasswordSwitch').click();
                    }
                }else{
                    if(sharePasswordSwitch.checked == true){
                        $('.sharePasswordSwitch').click();
                    }
                }

                if(jData.data.download == true){
                    if(enableDownload.checked == false){
                        $('.enableDownload').click()
                    }
                }else{
                    if(enableDownload.checked == true){
                        $('.enableDownload').click()
                    }
                }

                if(jData.data.view == true){
                    if(enableView.checked == false){
                        $('.enableView').click()
                    }
                }else{
                    if(enableView.checked == true){
                        $('.enableView').click()
                    }
                }
                if(jData.data.validUntil != null){
                    $('.removeValidUntil').show();
                    $('.validitySettingsDiv').css("display","none");
                    if(jData.data.enableValidity == true){
                        $('#enableValidity').prop('checked', true);
                        $(".validityRow").css('pointer-events','auto');
                            console.log("autooo");
                        $(".validityRow").css('opacity','1');
                        $('.currentValidityDiv').show();
                        //$('#linkExpiresOn').show();
                        //$('.removeValidUntil').show();                            
                    }else{
                        $('.validitySettingsDiv').css("display","block");
                        $('#enableValidity').prop('checked', false);
                            console.log("noneee");
                        $(".validityRow").css('pointer-events','none');
                        $(".validityRow").css('opacity','0.5');
                        $('.currentValidityDiv').hide();
                        //$('#linkExpiresOn').hide();
                        //$('.removeValidUntil').show();                            
                    }
                    //$('.currentValidityDiv').show();
                    $('#currentValidity').show();
                    $('#currentValidity').html(jData.data.currentValid + " "+jData.data.timeZone);
                    $('#till').val(jData.data.newValid1);
                    $('#tillTime').val(jData.data.tillTime);
                    //$('#till').val(jData.data.validUntil);
                    $('#dropdownTimeZone').find('option[value="'+jData.data.timeZone+'"]').prop("selected",true);
                }else{
                    $('.removeValidUntil').hide();
                    //document.getElementById('pickerDateTime').value = moment().format('YYYY-MM-DDTHH:mm');
                }
                $('.shareLinkBlock').show();
                $('.shareLink').html(jData.link);
                $('.shareBtn').hide();
                $('.unShareBtn').show();
                $('.changeImpactText').hide();
                //$('.updateShareDetails').show();
            }else{
                if(sharePasswordSwitch.checked == true){
                    if($scope.userAssignedPolicy.highSecureShareEnabled != "1"){
                        $('.sharePasswordSwitch').click();
                    }
                }
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.shareLinkBlock').hide();
                $('.shareBtn').show();
                $('.unShareBtn').hide();
                $('.changeImpactText').hide();
                $('.validitySettingsDiv').css("display","block");
                $('.currentValidityDiv').hide();
                $('#currentValidity').hide();
                $('.removeValidUntil').hide();
                if($scope.userAssignedPolicy.expiredDate == '1'){
                        $('#enableValidity').attr('checked', 'checked');
                        $('.enableValidityDiv').css('pointer-events','none');
                        $('.enableValidityDiv').css('opacity','0.5');
                        $(".validityRow").css('pointer-events','unset');
                        $(".validityRow").css('opacity','1');
                }else{
                        $('#enableValidity').removeAttr('checked');
                        $('.enableValidityDiv').css('pointer-events','unset');
                        $('.enableValidityDiv').css('opacity','1');
                        $(".validityRow").css('pointer-events','none');
                        $(".validityRow").css('opacity','0.5');
                }
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    
    $('#enableValidity').on('change', function(){
            var checked = document.getElementById('enableValidity').checked;
            if(checked){
                $(".validityRow").css('pointer-events','auto');
                $(".validityRow").css('opacity','1');
                if($('#currentValidity').html() != ''){
                    $('.currentValidityDiv').show();
                    $('#linkExpiresOn').show();
                    $('.removeValidUntil').hide();
                }
            }else{
                $(".validityRow").css('pointer-events','none');
                $(".validityRow").css('opacity','0.5');
                if($('#currentValidity').html() != ''){
                    $('.currentValidityDiv').hide();
                    $('#linkExpiresOn').hide();
                    $('.removeValidUntil').hide();
                }
            }
        if($(".shareLinkBlock").is(":visible")) {
                $('.shareBtn').show();
                $('.shareBtn').html('Save');
                $('.changeImpactText').show();
        }
    });
        
    var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
    if(sharePasswordSwitch){
        sharePasswordSwitch.onchange = function() {
            if(sharePasswordSwitch.checked == true){
                $('.sharePasswordBlock').show();
            }else{
                $('#sharePassword').val('');
                $('#reSharePassword').val('');
                $('.sharePasswordBlock').hide();
            }
        };
    }
    
    const DEFAULT_FORMAT = 'DD-MM-YYYY HH:mm:ss Z';
    function submitDate(){
        let localValue = document.getElementById('pickerDateTime').value;
        let timeZoneValue = document.getElementById("dropdownTimeZone").value;

        let local =  document.getElementById('divLocal');
        local.innerHTML = formatDate(moment(localValue));
        //local.innerHTML = getDate(moment(localValue));
        //console.log("1 : "+moment(localValue));

        let utc =  document.getElementById('divUTC');
        utc.innerHTML = formatDate(getUtcValue(localValue));
        //utc.innerHTML = getDate(getUtcValue(localValue));
        //console.log("2 : "+getUtcValue(localValue));

        let selected =  document.getElementById('divSelected');
        selected.innerHTML = formatDate(getSelectedValue(localValue,timeZoneValue));
        //selected.innerHTML = getDate(getSelectedValue(localValue,timeZoneValue));
        //console.log("3 : "+getSelectedValue(localValue,timeZoneValue));

        let utcSelected =  document.getElementById('divUTCSelected');
        utcSelected.innerHTML = formatDate(getSelectedUTCValue(localValue,timeZoneValue));
        //utcSelected.innerHTML = getDate(getSelectedUTCValue(localValue,timeZoneValue));
        //console.log("4 : "+getSelectedUTCValue(localValue,timeZoneValue));
   }

   function formatDate(momentDate){
        return momentDate.format(DEFAULT_FORMAT);
   }
   
   function getDate(momentDate){
      return momentDate.toDate();
   }

   function getUtcValue(localDateTime){
        return moment(localDateTime).utc();
   }

   function getSelectedValue(localDateTime, timeZone){
        return moment.tz(localDateTime,timeZone);
   }

   function getSelectedUTCValue(localDateTime, timeZone){
        return moment.tz(localDateTime,timeZone).utc();
   }
   
   function getMeDate(came){
        var str = came;
        var year = str.split('-').pop();
        var daymonth = str.substring(0, str.lastIndexOf("-"));
        var day = daymonth.substring(0, daymonth.lastIndexOf("-"));
        var month = daymonth.split('-').pop();
        var mon;
        var finall;
        switch (month) {
          case 'Jan':
            mon = "01";
            break;
          case 'Feb':
            mon = "02";
            break;
          case 'Mar':
            mon = "03";
            break;
          case 'Apr':
            mon = "04";
            break;
          case 'May':
            mon = "05";
            break;
          case  'Jun':
            mon = "06";
            break;
          case 'Jul':
            mon = "07";
            break;
          case 'Aug':
            mon = "08";
            break;
          case 'Sep':
            mon = "09";
            break;
          case 'Oct':
            mon = "10";
            break;
          case 'Nov':
            mon = "11";
            break;
          case  'Dec':
            mon = "12";
        }
        finall = year+"-"+mon+"-"+day;
        //finall = mon+"/"+day+"/"+year;
        return finall;
    }
    
    $scope.saveShare = function(){
/*        var ids = [];
        $scope.selected.forEach(function(value, key){
            ids.push(value.fileRevisionId);
        });*/
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        var googleAuthIsEnabled = document.querySelector('.googleAuthIsEnabled');
        var linkExpiryAlertsEnabled = document.querySelector('.linkExpiryAlertsEnabled');
        var shareLatestVersion = document.querySelector('.shareLatestVersion');
        var onedate = $('#till').val();
        var three = getMeDate($('#till').val());
        //var three = moment(onedate).format('YYYY-MM-DD');
        var localValue = three+'T'+$('#tillTime').val();
        var timeZoneValue = document.getElementById("dropdownTimeZone").value;
        var ff = getSelectedUTCValue(localValue,timeZoneValue).format("X");
        if(sharePasswordSwitch.checked == true){
            if($('#sharePassword').val().length <= 0){
                toastr.error('You need to specify a password to share a file', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        var enableValidity = document.querySelector('#enableValidity');
        if ( enableValidity.checked == true) {
                var enableValidity = 'enabled';
        }else{
                var enableValidity = 'disabled';
        }
        if($('#till').prop('required') == true && enableValidity == 'disabled'){
                toastr.error('You need to specify validity to create link of the file.', 'Fail!!!', {allowHtml: true});
                return;
        }
        //if ( $('#fileShareForm').parsley().isValid() && (enableDownload.checked == true || enableView.checked == true)) {
        if ( enableDownload.checked == true || enableView.checked == true) {
            var download = enableDownload.checked;
            var view = enableView.checked;
            //var validTill = $('#till').val();
            var validTill = parseInt(ff);
            var isPasswordProtected = sharePasswordSwitch.checked;
            var isgoogleAuthIsEnabled = googleAuthIsEnabled.checked;
            var islinkExpiryAlertsEnabled = linkExpiryAlertsEnabled.checked;
            var isshareLatestVersion = shareLatestVersion.checked;
            var password = '';
            if(isPasswordProtected == true){
                password = $('#sharePassword').val();
            }
            var timeZone = $('#dropdownTimeZone').val();
            var data = {
                fileName : $scope.selected[0].fileName,
                filePath : $scope.selected[0].devicePath,
		fileId : $scope.selected[0].fileId,
                download : download,
                view : view,
                enableValidity : enableValidity,
                timeZone : timeZone,
                validTill : validTill,
                isPasswordProtected : isPasswordProtected,
                googleAuthIsEnabled : isgoogleAuthIsEnabled,
                password : password,
                linkExpiryAlertsEnabled : islinkExpiryAlertsEnabled,
                shareLatestVersion : isshareLatestVersion,
                backupImageId : $scope.selected[0].backupID,
                sharedBackupImageIds : $scope.selected[0].backupIDs
            };
            console.log(data);
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/shareMyShare',
                type: 'POST',
                data: data
            }).done(function(data){
                var jData = JSON.parse(data);
                $scope.sharedFileDetails = jData.data;
                if(jData.result = 'success'){
		    $('.shareId').html($scope.sharedFileDetails.id);
                    $('.shareLinkBlock').show();
                    $('.shareLink').html(jData.link);
                    $('.shareBtn').hide();
                    $('.unShareBtn').show();
                    $('#extensionsToPdfView').modal('hide');
		    toastr.success('File link has been created.', 'Successful!!!', {allowHtml: true});
                    /*var fileName = $scope.selected[0].fileName;
                    var extension = fileName.substr(fileName.lastIndexOf(".") + 1);
                    var extensionsToPdfView = $('.extensionsToPdfView').html().replace(' ', '').split(',');
                    if(extensionsToPdfView.indexOf(extension)>=0 && enableDownload.checked == false){
                        $('.shareLinkBlock').hide();
                        $('#extensionsToPdfView').modal('show');
                    }else{
                    //$('.updateShareDetails').show();
                    toastr.success('File link has been created.', 'Successful!!!', {allowHtml: true});
                    }*/
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if($('#fileShareForm').parsley().isValid()){
                toastr.error('Either Download or View should be enabled to share a file.', 'Fail!!!', {allowHtml: true});
            }
        }
    };

}]);
