<?php

use Helpers\Assets;
use Helpers\Url;
use Helpers\Hooks;

//initialise hooks
$hooks = Hooks::get();
?>

<!-- JavaScript Plugins
================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<?php

    /**
     * Core Javascript Files will be loaded for everypage
     */

    Assets::js(array(
        //Url::templatePath() . 'js/plugins/jquery-1.9.1.js',
        //Url::templatePath() . 'js/plugins/jquery-2.1.4.min.js',
        Url::templatePath() . 'js/plugins/jquery-latest.min.js',
        Url::templatePath() . 'js/plugins/jqueryLatest-ui.min.js',
        Url::templatePath() . 'js/plugins/parsley.min.js',
        Url::templatePath() . 'js/plugins/popper.min.js',
        Url::templatePath() . 'js/plugins/bootstrap_latest.min.js',
        Url::templatePath() . 'js/plugins/nprogress.js',
        Url::templatePath() . 'js/plugins/ie10-viewport-bug-workaround.js',
    ));

    /**
     * Core Javascript Files will be loaded for only selected pages
     */

    if(RELAXED_CHECK == true){
        Assets::js(array(
            Url::templatePath() . 'js/login-scripts1.js?'.VERSIONS_NUMBER
        ));
    }else{
        Assets::js(array(
            Url::templatePath() . 'js/login-scripts.js?'.VERSIONS_NUMBER
        ));
    }

    //hook for plugging in javascript
    $hooks->run('js');

    //hook for plugging in code into the footer
    $hooks->run('footer');
?>


<!-- FOR EVERY PAGE THE BELOW CODE SHOULD BE ADDED -->
<?php if(enableRecaptcha == true){ ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php } ?>
<script>
    NProgress.start();
    var interval = setInterval(function() { NProgress.inc(); }, 1000);
    //$(window).load(function () {
    $(window).on('load',function () {
        clearInterval(interval);
        NProgress.done();
    });
    //$(window).unload(function () {
    $(window).on('unload',function () {
        NProgress.start();
    });
    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    })
    jQuery(document).bind("keyup keydown", function(e){
        if(e.ctrlKey && e.keyCode == 80){
            return false;
        }
    });
    $(document).ready(function(){
            // Enable the input field after the page has loaded
            $('#username').prop('disabled', false);
            $('#password').prop('disabled', false);
            $('#username, #password').first().focus();
        });
</script>
<div class="text-center row col-lg-10 col-lg-offset-1">
    <?php if(DISCLAIMER == true){ ?>
        <p class="text-left">!!! Warning!!!</p>
        <p class="text-left">This system is for the use of authorized Wipro personnel only and by accessing this system you hereby consent to the system being monitored by Wipro. Any unauthorized use will be considered a breach of Wipro's Information Security policies and may also be unlawful under law. Wipro reserves the right to take any action including disciplinary action or legal proceedings in a court of law against persons involved in the violation of the access restrictions herein.</p>
    <?php } ?>
    <a href="https://www.parablu.com" target="_blank">© <?=COPYRIGHT_NAME?> <?=date('Y')?> </a>
</div>
</body>
</html>
