<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Mechanic extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Mechanic Model was called', 'info');
    }

    public function download($path, $name){
        if(!is_file($path) || CONNECTION_STATUS()!=0){
            return false;
        }
        HEADER("Cache-Control: private");
        HEADER("Pragma: public");
        HEADER("Expires: ".GMDATE("D, d M Y H:i:s", MKTIME(DATE("H")+2, DATE("i"), DATE("s"), DATE("m"), DATE("d"), DATE("Y")))." GMT");
        HEADER("Last-Modified: ".GMDATE("D, d M Y H:i:s")." GMT");
        HEADER("Content-Type: application/octet-stream");
        HEADER("Content-Length: ".(string)(FILESIZE($path)));
        HEADER("Content-Disposition: attachment; filename=".$name);
        HEADER("Content-Transfer-Encoding: binary");
        session_write_close();
        if($file = FOPEN($path, 'rb')) {
            while(!FEOF($file) && (CONNECTION_STATUS()==0)) {
                PRINT(FREAD($file, 1024*8));
                FLUSH();
            }
            FCLOSE($file);
        }
        return((CONNECTION_STATUS()==0) && !CONNECTION_ABORTED());
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getCloudInfo($headers){
	$data = [];
        $url = $this->api->getUrl('cloudLicense');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function preauthenticate($opts){
        $url = $this->api->getUrl('preauthenticate');
	$headers = [];
	Model::req($url,$headers,$opts);
        $this->curl->setHeaders($opts);
        $this->curl->get($url);
        $response = array(
            'status' => ($this->curl->http_status_code == 202) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log(json_encode($url), 'info');
        $this->log(json_encode($response), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$response['status']);
        return $response;
    }

}
