<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class History extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('History Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDeviceBackupHistory($headers, $data, $pageNumber){
        //$url = $this->api->getUrl('deviceBackupHistory');
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/report/backupActivityHistory?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function userDeviceBackupHistory1($headers, $data, $url){
	//$url = $this->api->getUrl('deviceBackupHistory');
        $url = PROTOCOL.PARACLOUD_IP.$url;;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDeviceBackupHistoryDetails($headers){
        $url = $this->api->getUrl('deviceBackupHistoryDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Exports Activity History TO Excel
     *
     * @param $headers
     * @return array
     */
    public function exportActivityHistoryToExcel($headers){
        $url = $this->api->getUrl('exportActivityHistoryToExcel');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->log(json_encode($url), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Exports Activity History TO Excel
     *
     * @param $headers
     * @return array
     */
    public function exportShareActivityHistoryToExcel($headers){
        $url = $this->api->getUrl('exportShareActivityHistoryToExcel');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->log(json_encode($url), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getBackupActivityHistory($headers, $pageNumber, $userName){
	//$url = $this->api->getUrl('backupActivityHistory');
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/activities?deviceName&userName=".$userName."&pageNumber=".$pageNumber;
        Model::req($url,$headers,$userName);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getBackupActivityHistory1($headers, $url){
	//$url = $this->api->getUrl('backupActivityHistory');
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getShareActivityHistory($headers, $pageNumber){
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."cloud/".CLOUD_NAME."/files/sharedAH/all?pageNumber=".$pageNumber;
        //$url = $this->api->getUrl('shareActivityHistory');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getShareActivityHistory1($headers, $url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
        //$url = $this->api->getUrl('shareActivityHistory');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getBackupAttemps($headers){
        $url = $this->api->getParacloudUrl('getBackupAttemps');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function exportActivityHistoryToPdf($headers){
        $url = $this->api->getUrl('exportActivityHistoryToPdf');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->log(json_encode($url), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUnusualActivityHistory($headers, $pageNumber, $userName, $deviceName, $deviceUUID){
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/activities/unusualActivity?deviceName=".$deviceName."&userName=".$userName."&pageNumber=".$pageNumber."&deviceUUID=".$deviceUUID;
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUnusualActivityHistoryNavigate($headers, $url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function unusualActivityAction($headers){
        $url = $this->api->getParacloudUrl('unusualActivityAction');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function uploadInfFileApi($headers){
        $url = $this->api->getBlukryptUrl('uploadInfFileApi');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result:::::::::: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getInfStatistics($headers){
        $url = $this->api->getParacloudUrl('getInfStatistics');
	$data = [];
	Model::req($url,$headers,$data);
        $this->log("URL : ".$url,"info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
	    'body' => $this->curl->response,
	    'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getQuarantineList($headers){
        $url = $this->api->getParacloudUrl('getQuarantineList');
        //Model::req($url,$headers,$device);
        $this->log("URL : ".$url,"info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRwFile($headers){
        $url = $this->api->getParacloudUrl('deleteRwFile');
	$data = [];
	Model::req($url,$headers,$data);
        $this->log("URL : ".$url,"info");
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function exportUnusualActivityHistoryToExcel($headers){
        $url = $this->api->getUrl('exportUnusualActivityHistoryToExcel');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->log(json_encode($url), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getQuarantineDevices($headers){
        $url = $this->api->getParacloudUrl('getQuarantineDevices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function preauthenticate($opts){
        $url = $this->api->getUrl('preauthenticate');
        $headers = [];
        Model::req($url,$headers,$opts);
        $this->curl->setHeaders($opts);
        $this->curl->get($url);
        $response = array(
            'status' => ($this->curl->http_status_code == 202) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log(json_encode($url), 'info');
        $this->log(json_encode($response), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$response['status']);
        return $response;
    }

    public function getDevicesForRestorePage($headers, $deviceUUID){
        $url = $this->api->getUrl('getDevicesForRestorePage', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
