<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Backup extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Backup Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFiles($headers){
	$url = $this->api->getUrl('backupFiles');
	$url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.2/cloud/".CLOUD_NAME."/backup/files/child/agent";
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function getDevices($headers, $userName){
        $url = $this->api->getUrl('backupDevices', array('userName' => $userName));
        Model::req($url,$headers,$userName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        if($this->curl->http_status_code == 200){
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        }else{
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
            );
        }
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileVersions($headers){
        $url = $this->api->getUrl('backupFileVersions');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileChunks($headers){
        $url = $this->api->getUrl('fileChunks');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $dataString
     * @return array
     */
    public function backupFileDelete($headers, $dataString){
        $url = $this->api->getParacloudUrl('backupFileDelete');
        Model::req($url,$headers,$dataString);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url, $dataString);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function download($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
	$data = [];
	$url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$_SESSION['cloudName'].DS.'portal'.DS.'download'.DS.'files'.DS;
        $url = $url.$this->getStringForGetFromArray($headers);
        Model::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function downloadShare($headers)
    {
        $pms = new Pms();
        /*$blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
	}*/
	$blukryptIP = BLUKRYPT_IP;
	$data = [];
	$url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$headers['cloudName'].DS.'portal'.DS.'download'.DS.'files'.DS;        
        $url = $url.$this->getStringForGetFromArray($headers);
        Model::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function searchInDevices($headers){
        $url = $this->api->getUrl('searchDevices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllDevices($headers){
        $url = $this->api->getUrl('listOfDevices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFile($headers, $elements){
        $url = $this->api->getUrl('syncFileShare');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function updateSharePolicy($headers, $elements){
        $url = $this->api->getUrl('updateSharePolicy');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $policyName
     * @return array
     */
    public function getPolicy($headers, $policyName){
        $url = $this->api->getUrl('getPolicy', array('policyName' => $policyName));
        Model::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function isSharedOrNot($headers){
        $url = $this->api->getUrl('isSharedOrNot');
	$policyName = [];
	Model::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getUserBackupPolicy($headers){
        $url = $this->api->getUrl('getUserBackupPolicy');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function unShare($headers, $xml){
        $url = $this->api->getUrl('unShare');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function downloadFolder($headers, $userName, $fileName,$syncRevisionId,$filePath,$deviceUUID,$gatewayName, $restoreDeletedFile, $loggedInUserName, $folderSearch){
        //$this->curl->setTimeout(1200);
	$this->curl->setTimeout(0);
        $url = $this->api->getUrl('downloadFolder', array('userName' => $userName,'fileName'=> $fileName, 'syncRevisionId'=>$syncRevisionId, 'filePath'=>$filePath, 'deviceUUID'=>$deviceUUID, 'folderSearch' => $folderSearch));
        Model::req($url,$headers,$userName);
        $this->curl->setHeaders($headers);
        $url = $url.'?userName='.$userName.'&fileName='.$fileName.'&gatewayName='.$gatewayName.'&deviceUUID='.$deviceUUID.'&syncRevisionId='.$syncRevisionId.'&restoreDeletedFile='.$restoreDeletedFile.'&filePath='.$filePath.'&loginUserName='.$loggedInUserName.'&folderSearch='.$folderSearch;
        $this->log("URL : ".$url,"info");
        $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteFolderNew($headers){
        $url = $this->api->getUrl('deleteFolderNew');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
            );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getFiles1($headers){
	//$url = $this->api->getUrl('backupFiles1');
        $pageNumber = 1;
	$first = 'true';
        $last = 'false';
	$ltf = true;
	$nextPage = 0;
        $prevPage = 0;
        //$url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/backup/mail/msgs/child?pageNumber=".$pageNumber;
	$url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."cloud/".CLOUD_NAME."/backup/mail/msgs/child?pageNumber=".$pageNumber.'&first='.$first.'&last='.$last.'&nextPage='.$nextPage.'&prevPage='.$prevPage.'&ltf=true';
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getFilesOutlookNavigate($headers, $url){
	//$url = $this->api->getUrl('backupFiles1');
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function viewOutlook($headers){
        $url = $this->api->getUrl('viewOutlook');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getSearchResultsOutlook($headers, $searchType, $pageNumber){
	$url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."cloud/".CLOUD_NAME."/search/file?pageNumber=".$pageNumber;
	//$url = $this->api->getUrl($searchType);
        Model::req($url,$headers,$searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getSearchResultsOutlookNavigate($headers, $searchType, $url){
	$url = PROTOCOL.PARACLOUD_IP.$url;
	//$url = $this->api->getUrl($searchType);
        Model::req($url,$headers,$searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getDevicesForRestorePage($headers, $deviceUUID){
        $url = $this->api->getUrl('getDevicesForRestorePage', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function initiateRestores($headers, $data){
        $url = $this->api->getParacloudUrl('initiateRestores');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function deleteRestores($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestores', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveUserBackupPolicy($headers){
         $url = $this->api->getUrl('getOneDriveUserBackupPolicy');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'url' => $url,
             'header' => $this->curl->response_headers
         );
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }

    public function initiateRestoresOneDrive($headers, $data){
	$this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function deleteRestoresOneDrive($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }    

    public function initiateRestoresOutlook($headers, $data){
        $this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRestoresOutlook($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function initiateRestoresOutlookFile($headers, $data){
        $this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRestoresOutlookFile($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getAllDevices11($headers,$pageNumber){
	$url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/device/all?pageNumber=".$pageNumber;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        if($this->curl->http_status_code == 200){
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response
            );
        }else{
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
            );
        }
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getDeviceId($headers, $deviceId){
        $url = $this->api->getUrl('getDeviceId', array('deviceId' => $deviceId));
        Model::req($url,$headers,$deviceId);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function initiateRestoresOutlookSearchFileGS($headers, $data){
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRestoresOutlookSearchFileGS($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function changePasswordForFirstlogin($headers){
	$url = $this->api->getUrl('changePasswordForFirstlogin');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function sendShareEmail($headers,$data){
        $url = $this->api->getUrl('sendEmailBackup');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function calculateRestorableSize($headers){
        $url = $this->api->getUrl('calculateRestorableSize');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getUserData($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.$username.DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function sendQR($headers,$cloudName){
        $url =PARA_URL.'cloud'.DS.$cloudName.DS.'qrcode'.DS.'share';
        Model::req($url,$headers,$cloudName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getManageDevices($headers, $type){
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."cloud/".CLOUD_NAME."/device/all/".$type."?pageNumber=1";
        Model::req($url,$headers,$type);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        if($this->curl->http_status_code == 200){
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        }else{
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
            );
        }
        $this->log('url: '.$url, 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getManageDevicesNavigate($headers,$url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getEventHub($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('getEventHub', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->log('Result_url'.json_encode($url), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveEventHub($headers, $data){
        $url = $this->api->getParacloudUrl('saveEventHub');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Result_headers'.json_encode($headers), 'info');
        $this->log('Result_data'.json_encode($data), 'info');
        $this->log('Result_url'.json_encode($url), 'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getCurrentBackupDetails($headers,$deviceUUID){
        $url = $this->api->getParacloudUrl('currentBackupForDeviceAction',array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->log('Result_url_current_Backup'.json_encode($url), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getCurrentRestoreDetails($headers,$deviceUUID){
        $url = $this->api->getParacloudUrl('currentRestoreForDeviceAction',array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->log('Result_url_current_Backup'.json_encode($url), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getAllOneDrivePolicies($headers){
        $url = $this->api->getUrl('getAllOneDrivePolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function preauthenticate($opts){
        $url = $this->api->getUrl('preauthenticate');
        $headers = [];
        Model::req($url,$headers,$opts);
        $this->curl->setHeaders($opts);
        $this->curl->get($url);
        $response = array(
            'status' => ($this->curl->http_status_code == 202) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$response['status']);
	return $response;
    }

    public function getAllOfficePolicyName($headers){
        $url = $this->api->getUrl('newOffice');
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getSharePolicy($headers, $deviceUUID){
        $url = $this->api->getUrl('getSharePolicy', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        if($this->curl->http_status_code == 200){
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        }else{
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
            );
        }
        $this->log('url: '.$url, 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function discoverNow($headers){
        $url = $this->api->getUrl('discoverNow');
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

     public function initiateRestoresOutlookAsPst($headers, $data){
            $this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
     }

    public function selectedFles($headers, $data){
        $this->curl->setTimeout(0);
        $url = $this->api->getUrl('selectedFles');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("URL : ".$url,"info");
        $this->curl->post($url, $data);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getAllUsers($headers,$pageNumber){
        //$url = $this->api->getUrl('users');
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/users/all?pageNumber=".$pageNumber;
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getAllPolicyName($headers){
        //$url = $this->api->getUrl('getAllPolices');
        $url = $this->api->getUrl('newBackup');
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function stopRestore($headers){
        $url = $this->api->getParacloudUrl('stopRestore');
        $data = [];
        Model::req($url,$headers,$data);
        $this->log("usrl". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getJobStatus($headers, $pageNumber){
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/report/currentCPBackup?pageNumber=".$pageNumber;
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getJobStatusHistory($headers, $pageNumber){
        $url = PROTOCOL.PARACLOUD_IP.DS.PARACLOUD_NAME.DS."versions/2.5/clouds/".CLOUD_NAME."/report/cpBackupActivityHistory?pageNumber=".$pageNumber;
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function stopCurrentJob($headers){
        $url = $this->api->getParacloudUrl('stopCurrentJob');
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function startCurrentJob($headers){
        $url = PROTOCOL.PARACLOUD_IP."/BluKryptBuilder/start/cp/";;
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getlastSuccessfullbackup($headers, $deviceUUID){
        $url = $this->api->getUrl('getlastSuccessfullbackup', array('deviceUUID' => $deviceUUID));
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
