<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Report;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ReportController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('report');
        $this->_model = new Report();
        //Auth::allowOnly('readOnlyAdmin');
    }

    public function validateData1($value){
        if(preg_match('/[\'\/~`\\\^&\*\(\)_\-\+=\{\}\[\]\|;"\<\>,\?\\\]/', $value)){
		$response = array(
                	'result' => 'fail',
                        'msg' => 'Bad Input'
                );
                echo json_encode($response);
                exit;
        }
    }	

    public function dashboard(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/dashboard', $data);
        View::renderTemplate('footer', $data);
    }

    public function syncDashboard(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/syncDashboard', $data);
        View::renderTemplate('footer', $data);
    }

    public function statistics(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('statistics'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/statistics/statistics', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getSyncStatisticsOne(){
        //Auth::allowOnly('readOnlyAdmin');
        $headers = array(
            'Content-type' => 'application/json',
            'Accept' => 'application/json',
            'Accept-Charset' => 'utf-8',
            'token' => $this->session->get('token'),
            'cloudParams' => 'home,users,devices,myclouds,syncUsers,backupUsers,size'
        );
        $cloudDetails = $this->_model->getSyncStatistics($headers);
        $this->log('Cloud Details: '. json_encode($cloudDetails), 'info');
        switch ($cloudDetails['status']) {
                case (200):
                    $cloudDetails['body']->{'cloudBasicElement'}->{'liscenseElement'}->{'cloudSizeAllowed'} = round(((float)$cloudDetails['body']->{'cloudBasicElement'}->{'liscenseElement'}->{'cloudSizeAllowed'}) / 1024, 2);
                    if((int)$cloudDetails['body']->{'cloudBasicElement'}->{'spaceUsed'} < 1024){
                        $cloudDetails['body']->{'cloudBasicElement'}->{'spaceUsed'} = (int)$cloudDetails['body']->{'cloudBasicElement'}->{'spaceUsed'};
                        $unit = "MB";
                    }else{
                        $cloudDetails['body']->{'cloudBasicElement'}->{'spaceUsed'} = round(((int)$cloudDetails['body']->{'cloudBasicElement'}->{'spaceUsed'})/1024, 2);
                        $unit = "GB";
                    }
                        $cloudDetails['body']->{'cloudBasicElement'}->{'liscenseElement'}->{'validityPeriod'} = date('d-M-Y', (((int)$cloudDetails['body']->{'cloudBasicElement'}->{'liscenseElement'}->{'validityPeriod'}) / 1000));
                        $this->log("kkkkkkkkkkkkkk : ".json_encode($cloudDetails['body']->{'cloudBasicElement'}),"info");
                    $response = array(
                        'result' => 'success',
                        'statisticsSync' => $cloudDetails['body']->{'cloudBasicElement'},
                        'unit' => $unit
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function closeWarning(){
        $this->session->put("showBanner","no");
    }
	
    public function closeSoftBlockWarning(){
        $this->session->put("showSoftBlockBanner","no");
    }

    public function getStatistics(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getStatistics($headers);
            switch ($result['status']) {
                case (200):
		    $showSoftBlockBanner = '';
                    $softBlockedUsersCount = $result['body']->{'cloudOverviewElement'}->{'softBlockedUsersCount'};
                    if($softBlockedUsersCount > 0 && $this->session->get("showSoftBlockBanner") != 'no' && $this->session->get('admin') == true){
                            $showSoftBlockBanner = 'yes';
                    }else{
                            $showSoftBlockBanner = 'no';
                    }
		    $showBanner = '';
		    $isExpired = '';
                    if($this->session->get("showBanner") != 'no' && $this->session->get('admin') == true){
                    	$currentDate = strtotime("now")*1000;
                    	$validityDate = $result['body']->{'cloudOverviewElement'}->{'cloudValidityUntil'};
                    	$timeDiff = abs($validityDate - $currentDate);
                    	$numberDays = round($timeDiff/86400000);
                    	if($numberDays <= 60){
                            $isExpired = date('d-M-Y H:i', (((int)$result['body']->{'cloudOverviewElement'}->{'cloudValidityUntil'}) / 1000)).' that is '.$numberDays.' days from today.';
                            $pieces = explode(" ", $isExpired);
                            $isExpired = 'You have '.$numberDays.' day(s) before your licenses expire. Your licenses are set to expire at '.$pieces[1].' hours on '.$pieces[0];
                            $showBanner = 'yes';
                    	}else{
                            $isExpired = '';
                            $showBanner = 'no';
			}
		    $this->log("currentDate -------> ".$currentDate,"info");
                    $this->log("validityDate -------> ".$validityDate,"info");
                    $this->log("numberDays -------> ".$numberDays,"info");
                    $this->log("isExpired -------> ".$isExpired,"info");
                    $this->log("showBanner -------> ".$showBanner,"info");
                    }
                    $this->session->put("showBanner",$showBanner);                    
                    if(isset($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'})){
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round((float)$result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    }if(isset($result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'})){
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(((float)$result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    }
		            $result['body']->{'cloudOverviewElement'}->{'cloudValidityUntil'} = date('d-M-Y', (((int)$result['body']->{'cloudOverviewElement'}->{'cloudValidityUntil'}) / 1000));
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'},
			'showBanner' => $showBanner,
			'showSoftBlockBanner' => $showSoftBlockBanner,
                        'isExpired' => $isExpired
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getOneDriveStatistics(){
        if(!empty($_POST)){
            $headers = array(
		    'token'         => $this->session->get('token'),
		    'productType'   => $_POST['type']
            );
            $result = $this->_model->getOneDriveStatistics($headers);
            switch ($result['status']) {
                case (200):
                    if(isset($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'})){
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round((float)$result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    }if(isset($result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'})){
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(((float)$result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    }
		            $result['body']->{'cloudOverviewElement'}->{'cloudValidityUntil'} = date('d-M-Y', (((int)$result['body']->{'cloudOverviewElement'}->{'cloudValidityUntil'}) / 1000));
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getSyncStatistics(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getStatistics($headers);
            switch ($result['status']) {
                case (200):
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(($result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getServerBackupStatistics(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getServerBackupStatistics($headers);
            $this->log('ServerBackup Status ' . json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(($result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function overview($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        $backupPolicies=[];
        if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        }
        $odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
        if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
	}
	if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('overview'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserRole'=>$this->session->get('readOnlyAdmin'),
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
	    'backupPolicies'=>array_reverse($backupPolicies),
	    'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/overview/overview', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getOverview(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['userName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == ['all'] || $_POST['policyName'] == null || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
        }       
        unset($_POST['policyName']['all']);
        $headers = array(
            'Content-Type'  => 'application/json',
            'token' => $this->session->get('token'),
            'Accept' => 'application/json',
	    'productType' => $_POST['reportProductType']            
        );
        $this->log("policyname : ".json_encode($_POST['policyName']), "info");
        $data=array(
            'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'userName'      => $_POST['userName'] == 'all' ? '' : $_POST['userName'],
            'deviceName'    => $_POST['deviceName'] == 'all' ? '' : $_POST['deviceName'],
            'policyNames'    => $_POST['policyName']=='all' ? []:$_POST['policyName'],
            'isUserWithoutDeviceEnabled' => $_POST['isUserWithoutDeviceEnabled']=="true" ? true : false,
            'showBlockedUsers' => $_POST['showBlockedUsers']=="true" ? true : false,
	    'showBlockedDevices' => $_POST['showBlockedDevices']=="true" ? true : false,
	    'report' => 'BACKUP_OVERVIEW',
            'productType'=> $_POST['reportProductType'],
            'operationType'=>'GENERATE_VIEW'
        );

        $this->log(json_encode($headers), "info");
        $result = $this->_model->getOverview($headers, $data, $_POST['pageNumber']);
        $this->log(json_encode($result));
        switch ($result['status']) {
            case (200):
                if(!empty($result['header']['overViewJobTime'])){
                    $seconds = $result['header']['overViewJobTime'] / 1000;
                    $overViewJobTime = date('d-M-Y H:i:s', $seconds) .' '. date('T');
                }else{
                    $overViewJobTime = '';
                }
                $overviewList = [];
		if(!empty($result['body']->{'data'}->{'backupOverview'})){
                foreach($result['body']->{'data'}->{'backupOverview'} as $value){
                    //$filesBackedUp = intval($value->{'totalNoOfFiles'}) - intval($value->{'noOfFilesRemaining'});
			//$completedPercentage = ($value->{'totalNoOfFiles'} > 0 ) ? round(($filesBackedUp / $value->{'totalNoOfFiles'}) * 100).'%' : '0 %';
		if(!empty($value->{'lastBkpStatus'})){
                    if($value->{'lastBkpStatus'} != 'STARTED' && $value->{'lastBkpStatus'} != 'COMPLETED'){
                            $reason = !empty($value->{'reason'}) ? $value->{'reason'} : '-';

                     }elseif($value->{'lastBkpStatus'} == 'STARTED' || $value->{'lastBkpStatus'} == 'COMPLETED') {
                            $reason = '-';
		     }
		}
                    if(!empty($value->{'deviceName'})){
                        if($value->{'deviceActive'} == "1"){
                            if($value->{'decoupled'} == "1"){
                                $value->{'deviceActive'} = "Decoupled";
                                $devAct = "Decoupled";
                            }else{
                                $value->{"deviceActive"} = "Active";
                                $devAct = "Active";
                            }
                        }
                        else{
                            $value->{"deviceActive"} = "Blocked";
                            $devAct = "Blocked";
                        }
                        $devName = $value->{'deviceName'};
                    }else{
                        $devAct = "-";
                        $devName = "-";
                    }                 
                    if($value->{'firstBackupCompleted'} == true){
                        $firstFullBkpTotalSizeOfFiles = $value->{'firstFullBkpTotalSizeOfFiles'};
                        $firstFullBkpNoOfFiles = $value->{'firstFullBkpNoOfFiles'};
                        $lastSucessfulBkpTotalSizeOfFiles = $value->{'lastSucessfulBkpTotalSizeOfFiles'};
                        $lastSucessfulBkpNoOfFiles = $value->{'lastSucessfulBkpNoOfFiles'};
                    }else{
                        $firstFullBkpTotalSizeOfFiles = "-";
                        $firstFullBkpNoOfFiles = "-";
                        $lastSucessfulBkpTotalSizeOfFiles = "-";
                        $lastSucessfulBkpNoOfFiles = "-";
                    }                
                    //if($value->{'currentBkpStatus'} == 'STARTED'){
                        $totalCurrentlyRunningBkpSizeInPer = $value->{'totalCurrentlyRunningBkpSizeInPer'};
                        $currentlyRunningBkpTotalSizeOfFiles = $value->{'currentlyRunningBkpTotalSizeOfFiles'};
                        $currentlyRunningBkpNoOfFiles = $value->{'currentlyRunningBkpNoOfFiles'};
                        $totalSizeToUpload = !empty($value->{'totalSizeToUpload'}) ? $value->{'totalSizeToUpload'} : '-';
                    /*}else{
                        $totalCurrentlyRunningBkpSizeInPer = "-";
                        $currentlyRunningBkpTotalSizeOfFiles = "-";
                        $currentlyRunningBkpNoOfFiles = "-";
                        $totalSizeToUpload = "-";
                    }*/
                    if($value->{'userActive'} == "1"){
                        $userActive = 'Active';
                    }else{
                        $userActive = 'Blocked';
                    }              
                    if($value->{'firstBackupCompleted'} == "1"){
                        $isFirstBackupCompleted = 'Yes';
                    }else{
                        $isFirstBackupCompleted = 'No';
                    }                   
                    if($value->{'backupRunning'} == true){
                        $isBackupRunning = 'Yes';
                    }else{
                        $isBackupRunning = 'No';
                    }                    
                    $overview = array(
                        'userId' => $value->{'userId'},
                        'emailId' => !empty($value->{'emailId'}) ? $value->{'emailId'} : '-',
                        'deviceName' => $devName,
                        'policyName' => !empty($value->{'policyName'}) ? $value->{'policyName'} : '',
                        'oneDrivePolicyName' => !empty($value->{'oneDrivePolicyName'}) ? $value->{'oneDrivePolicyName'} : '',
                        'exchangePolicyName' => !empty($value->{'exchangePolicyName'}) ? $value->{'exchangePolicyName'} : '',
                        'sharepointPolicyName' => !empty($value->{'spPolicyName'}) ? $value->{'spPolicyName'} : '',
                        //'epaInstallationDate' => $value->{'epaInstallationDate'},
                        'firstBkpStartTime' => !empty($value->{'firstBkpStartTime'}) ? $value->{'firstBkpStartTime'} : 0,
                        'firstBkpEndTime' => !empty($value->{'firstBkpEndTime'}) ? $value->{'firstBkpEndTime'} : 0,
                        'lastBkpStartTime' => !empty($value->{'lastBkpStartTime'}) ? $value->{'lastBkpStartTime'} : 0,
                        'lastSuccessfulBkp' => !empty($value->{'lastSuccessfulBkp'}) ? $value->{'lastSuccessfulBkp'} : 0,
                        'lastBkpStatus' => !empty($value->{'lastBkpStatus'}) ? $value->{'lastBkpStatus'} : '-',
                        'reason' => !empty($value->{'reason'}) ? $value->{'reason'} : '-',
                        'storageUtilized' => $value->{'storageUtilized'},
                        //'completedPercentage' => $completedPercentage,
                        'deviceActive' => $devAct,
                        'userActive' => $userActive,
                        'isFirstBackupCompleted' => $isFirstBackupCompleted,
                        'isBackupRunning' => $isBackupRunning,
                        'clientVersion' => !empty($value->{'clientVersion'}) ? $value->{'clientVersion'} : '-',
                        'firstBackupCompleted' => $value->{'firstBackupCompleted'},
                        'lastHeardTime' => !empty($value->{'lastHeardTime'}) ? $value->{'lastHeardTime'} : '-',
                        'currentBkpCompletionPct' => !empty($value->{'currentBkpCompletionPct'}) ? $value->{'currentBkpCompletionPct'} : '0',
                        'currentBkpCompletionPctInt' => !empty($value->{'currentBkpCompletionPct'}) ? intval($value->{'currentBkpCompletionPct'}) : 0,
                        'currentBkpStatus' => !empty($value->{'currentBkpStatus'}) ? $value->{'currentBkpStatus'} : '-',
                        'currentBkpStartTime' =>  !empty($value->{'currentBkpStartTime'}) ? $value->{'currentBkpStartTime'} : 0,
                        'lastSuccessfulBackupStartTime' => !empty($value->{'lastSuccessfulBackupStartTime'}) ? $value->{'lastSuccessfulBackupStartTime'} : 0,
                        'lastSuccessfulBackupEndTime' => !empty($value->{'lastSuccessfulBackupEndTime'}) ? $value->{'lastSuccessfulBackupEndTime'} : 0,
                        'firstFullBkpTotalSizeOfFiles' => $firstFullBkpTotalSizeOfFiles,
                        'firstFullBkpNoOfFiles' => $firstFullBkpNoOfFiles,
                        'lastSucessfulBkpTotalSizeOfFiles' => $lastSucessfulBkpTotalSizeOfFiles,
			'lastSucessfulBkpNoOfFiles' => $lastSucessfulBkpNoOfFiles,
			'currentlyRunningBkpTotalSizeOfFiles' => $currentlyRunningBkpTotalSizeOfFiles,
                        'currentlyRunningBkpNoOfFiles' => $currentlyRunningBkpNoOfFiles,
                        'totalSizeToUpload' => $totalSizeToUpload,
                        'totalCurrentlyRunningBkpSizeInPer' => $totalCurrentlyRunningBkpSizeInPer,
                        'firstFullBkpTotalSizeOfFilesInKB' => $value->{'firstFullBkpTotalSizeOfFilesInKB'},
                        'lastSuccessfulBackupStartTimeInMillis' => $value->{'lastSuccessfulBackupStartTimeInMillis'},
                        'lastSuccessfulBackupEndTimeInMillis' => $value->{'lastSuccessfulBackupEndTimeInMillis'},
                        'lastSucessfulBkpTotalSizeOfFilesInKB' => $value->{'lastSucessfulBkpTotalSizeOfFilesInKB'},
                        'currentBkpStartTimeInMillis' => $value->{'currentBkpStartTimeInMillis'},
                        'currentlyRunningBkpTotalSizeOfFilesInKB' => $value->{'currentlyRunningBkpTotalSizeOfFilesInKB'},
                        'totalSizeToUploadInKB' => $value->{'totalSizeToUploadInKB'},
                        'lastHeardTimeInMillis' => !empty($value->{'lastHeardTimeInMillis'}) ? $value->{'lastHeardTimeInMillis'} : 0,
			'storageUtilizedInKB' => $value->{'storageUtilizedInKB'},
			'currentBkpCompletionPct' => $value->{'currentBkpCompletionPct'}
                    );
                    $overviewList = array_merge(array($overview), $overviewList);

                }
                }
                if(!empty($result['body']->{'metadata'})){
                	$metadata = $result['body']->{'metadata'};
                	$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'overViewJobTime' => $overViewJobTime,
                    'overview' => array_reverse($overviewList),
                    'metadata' => $metadata
                );
                echo json_encode($response);
		exit;
	    case (400):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('400')
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
    
    public function getOverview1(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == ['all'] || $_POST['policyName'] == null || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
        }
        unset($_POST['policyName']['all']);   
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
	    'productType'   => $_POST['reportProductType']
        );
        $this->log("policyname : ".json_encode($_POST['policyName']), "info");
        $data=array(
            'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'userName'      => $_POST['userName'] == 'all' ? '' : $_POST['userName'],
            'deviceName'    => $_POST['deviceName'] == 'all' ? '' : $_POST['deviceName'],
            'policyNames'    => $_POST['policyName']=='all' ? []:$_POST['policyName'],
            'isUserWithoutDeviceEnabled' => $_POST['isUserWithoutDeviceEnabled']=="true" ? true : false,
            'showBlockedUsers' => $_POST['showBlockedUsers']=="true" ? true : false,
	    'showBlockedDevices' => $_POST['showBlockedDevices']=="true" ? true : false,
	    'report' => 'BACKUP_OVERVIEW',
            'productType'=> $_POST['reportProductType'],
            'operationType'=> 'GENERATE_VIEW'
        );
        $this->log("DATA : ".json_encode($data), "info");
        $result = $this->_model->getOverview1($headers, $data, $_POST['url']);
	$this->log("lllllllllllll".json_encode($result['body']->{'metadata'}),"info");
        $this->log(json_encode($result));
        switch ($result['status']) {
            case (200):
                if(!empty($result['header']['overViewJobTime'])){
                    $seconds = $result['header']['overViewJobTime'] / 1000;
                    $overViewJobTime = date('d-M-Y H:i:s', $seconds) .' '. date('T');
                }else{
                    $overViewJobTime = '';
                }
                $overviewList = [];
		if(!empty($result['body']->{'data'}->{'backupOverview'})){
                foreach($result['body']->{'data'}->{'backupOverview'} as $value){
                    //$filesBackedUp = intval($value->{'totalNoOfFiles'}) - intval($value->{'noOfFilesRemaining'});
		    //$completedPercentage = ($value->{'totalNoOfFiles'} > 0 ) ? round(($filesBackedUp / $value->{'totalNoOfFiles'}) * 100).'%' : '0 %';
		    if(!empty($value->{'lastBkpStatus'})){
                    if($value->{'lastBkpStatus'} != 'STARTED' && $value->{'lastBkpStatus'} != 'COMPLETED'){
                            $reason = !empty($value->{'reason'}) ? $value->{'reason'} : '-';

                     }elseif($value->{'lastBkpStatus'} == 'STARTED' || $value->{'lastBkpStatus'} == 'COMPLETED') {
                            $reason = '-';
		     }
		    }
                    if(!empty($value->{'deviceName'})){
                        if($value->{'deviceActive'} == "1"){
                            if($value->{'decoupled'} == "1"){
                                $value->{'deviceActive'} = "Decoupled";
                                $devAct = "Decoupled";
                            }else{
                                $value->{"deviceActive"} = "Active";
                                $devAct = "Active";
                            }
                        }
                        else{
                            $value->{"deviceActive"} = "Blocked";
                            $devAct = "Blocked";
                        }
                        $devName = $value->{'deviceName'};
                    }else{
                        $devAct = "-";
                        $devName = "-";
                    }                    
                    if($value->{'firstBackupCompleted'} == true){
                        $firstFullBkpTotalSizeOfFiles = $value->{'firstFullBkpTotalSizeOfFiles'};
                        $firstFullBkpNoOfFiles = $value->{'firstFullBkpNoOfFiles'};
                        $lastSucessfulBkpTotalSizeOfFiles = $value->{'lastSucessfulBkpTotalSizeOfFiles'};
                        $lastSucessfulBkpNoOfFiles = $value->{'lastSucessfulBkpNoOfFiles'};
                    }else{
                        $firstFullBkpTotalSizeOfFiles = "-";
                        $firstFullBkpNoOfFiles = "-";
                        $lastSucessfulBkpTotalSizeOfFiles = "-";
                        $lastSucessfulBkpNoOfFiles = "-";
                    }                    
                    //if($value->{'currentBkpStatus'} == 'STARTED'){
                        $totalCurrentlyRunningBkpSizeInPer = $value->{'totalCurrentlyRunningBkpSizeInPer'};
                        $currentlyRunningBkpTotalSizeOfFiles = $value->{'currentlyRunningBkpTotalSizeOfFiles'};
                        $currentlyRunningBkpNoOfFiles = $value->{'currentlyRunningBkpNoOfFiles'};
                        $totalSizeToUpload = !empty($value->{'totalSizeToUpload'}) ? $value->{'totalSizeToUpload'} : '-';
                    /*}else{
                        $totalCurrentlyRunningBkpSizeInPer = "-";
                        $currentlyRunningBkpTotalSizeOfFiles = "-";
                        $currentlyRunningBkpNoOfFiles = "-";
                        $totalSizeToUpload = "-";
                    }*/
                    if($value->{'userActive'} == "1"){
                        $userActive = 'Active';
                    }else{
                        $userActive = 'Blocked';
                    }                    
                    if($value->{'firstBackupCompleted'} == "1"){
                        $isFirstBackupCompleted = 'Yes';
                    }else{
                        $isFirstBackupCompleted = 'No';
                    }                    
                    if($value->{'backupRunning'} == true){
                        $isBackupRunning = 'Yes';
                    }else{
                        $isBackupRunning = 'No';
                    }                    
                    $overview = array(
			'userId' => $value->{'userId'},
                        'emailId' => !empty($value->{'emailId'}) ? $value->{'emailId'} : '-',
                        'deviceName' => $devName,
                        'policyName' => !empty($value->{'policyName'}) ? $value->{'policyName'} : '',
			'oneDrivePolicyName' => !empty($value->{'oneDrivePolicyName'}) ? $value->{'oneDrivePolicyName'} : '',
			'exchangePolicyName' => !empty($value->{'exchangePolicyName'}) ? $value->{'exchangePolicyName'} : '',
			'sharepointPolicyName' => !empty($value->{'spPolicyName'}) ? $value->{'spPolicyName'} : '',
                        //'epaInstallationDate' => $value->{'epaInstallationDate'},
                        'firstBkpStartTime' => !empty($value->{'firstBkpStartTime'}) ? $value->{'firstBkpStartTime'} : 0,
                        'firstBkpEndTime' => !empty($value->{'firstBkpEndTime'}) ? $value->{'firstBkpEndTime'} : 0,
                        'lastBkpStartTime' => !empty($value->{'lastBkpStartTime'}) ? $value->{'lastBkpStartTime'} : 0,
                        'lastSuccessfulBkp' => !empty($value->{'lastSuccessfulBkp'}) ? $value->{'lastSuccessfulBkp'} : 0,
                        'lastBkpStatus' => !empty($value->{'lastBkpStatus'}) ? $value->{'lastBkpStatus'} : '-',
                        'reason' => !empty($value->{'reason'}) ? $value->{'reason'} : '-',
                        'storageUtilized' => $value->{'storageUtilized'},
                        //'completedPercentage' => $completedPercentage,
                        'deviceActive' => $devAct,
                        'userActive' => $userActive,
                        'isFirstBackupCompleted' => $isFirstBackupCompleted,
                        'isBackupRunning' => $isBackupRunning,
                        'clientVersion' => !empty($value->{'clientVersion'}) ? $value->{'clientVersion'} : '-',
                        'firstBackupCompleted' => $value->{'firstBackupCompleted'},
                        'lastHeardTime' => !empty($value->{'lastHeardTime'}) ? $value->{'lastHeardTime'} : '-',    
                        'currentBkpCompletionPct' => !empty($value->{'currentBkpCompletionPct'}) ? $value->{'currentBkpCompletionPct'} : '0',
                        'currentBkpCompletionPctInt' => !empty($value->{'currentBkpCompletionPct'}) ? intval($value->{'currentBkpCompletionPct'}) : 0,
                        'currentBkpStatus' => !empty($value->{'currentBkpStatus'}) ? $value->{'currentBkpStatus'} : '-',
                        'currentBkpStartTime' =>  !empty($value->{'currentBkpStartTime'}) ? $value->{'currentBkpStartTime'} : 0,
                        'lastSuccessfulBackupStartTime' => !empty($value->{'lastSuccessfulBackupStartTime'}) ? $value->{'lastSuccessfulBackupStartTime'} : 0,
                        'lastSuccessfulBackupEndTime' => !empty($value->{'lastSuccessfulBackupEndTime'}) ? $value->{'lastSuccessfulBackupEndTime'} : 0,
                        'firstFullBkpTotalSizeOfFiles' => $firstFullBkpTotalSizeOfFiles,
                        'firstFullBkpNoOfFiles' => $firstFullBkpNoOfFiles,
                        'lastSucessfulBkpTotalSizeOfFiles' => $lastSucessfulBkpTotalSizeOfFiles,
                        'lastSucessfulBkpNoOfFiles' => $lastSucessfulBkpNoOfFiles,
                        'currentlyRunningBkpTotalSizeOfFiles' => $currentlyRunningBkpTotalSizeOfFiles,
                        'currentlyRunningBkpNoOfFiles' => $currentlyRunningBkpNoOfFiles,
                        'totalSizeToUpload' => $totalSizeToUpload,
                        'totalCurrentlyRunningBkpSizeInPer' => $totalCurrentlyRunningBkpSizeInPer,
                        'firstFullBkpTotalSizeOfFilesInKB' => $value->{'firstFullBkpTotalSizeOfFilesInKB'},
                        'lastSuccessfulBackupStartTimeInMillis' => $value->{'lastSuccessfulBackupStartTimeInMillis'},
                        'lastSuccessfulBackupEndTimeInMillis' => $value->{'lastSuccessfulBackupEndTimeInMillis'},
                        'lastSucessfulBkpTotalSizeOfFilesInKB' => $value->{'lastSucessfulBkpTotalSizeOfFilesInKB'},
                        'currentBkpStartTimeInMillis' => $value->{'currentBkpStartTimeInMillis'},
                        'currentlyRunningBkpTotalSizeOfFilesInKB' => $value->{'currentlyRunningBkpTotalSizeOfFilesInKB'},
                        'totalSizeToUploadInKB' => $value->{'totalSizeToUploadInKB'},
                        'lastHeardTimeInMillis' => !empty($value->{'lastHeardTimeInMillis'}) ? $value->{'lastHeardTimeInMillis'} : 0,
			'storageUtilizedInKB' => $value->{'storageUtilizedInKB'},
			'currentBkpCompletionPct' => $value->{'currentBkpCompletionPct'}
                    );

                    $overviewList = array_merge(array($overview), $overviewList);

                }
		}
                if(!empty($result['body']->{'metadata'})){
                	$metadata = $result['body']->{'metadata'};
                	$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'overViewJobTime' => $overViewJobTime,
                    'overview' => array_reverse($overviewList),
                    'metadata' => $metadata
                );
                echo json_encode($response);
		exit;
	    case (400):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('400')
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function restoreByDate($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $backupPolicies=[];
        if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        }
        $odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
        if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
        }
        if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('restoreHistory'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'backupPolicies' => array_reverse($backupPolicies),
	    'loggedInUserReadOnlyAdmin' => $this->session->get("readOnlyAdmin"),
	    'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/restore/restoreByDate', $data);
        View::renderTemplate('footer', $data);
    }

    public function restoreByUsername(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('restoreByUserName'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/restore/restoreByUsername', $data);
        View::renderTemplate('footer', $data);
    }

    public function restoreByDevice(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('restoreByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/restore/restoreByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getRestoreHistory(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }

            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
	    }
	    $this->log("nnnnnnnnnnnnnn : ".$_POST['reportProductType'],"info");
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType']
            );
            $data = array(
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'userName'      => $_POST["userName"],
                'deviceName'    => $_POST["deviceName"],
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'RESTORE_HISTORY',
                'productType'   => $_POST['reportProductType'],
                'operationType' => 'GENERATE_VIEW'
            );
            
            if(empty($_POST['from']) && empty($_POST['to']) && empty($_POST['userName']) && empty($_POST['deviceName'])){
                $data['endDate'] = '';
                $data['startDate'] = '';
            }elseif(!empty($_POST['from']) && !empty($_POST['to'])){
                $data['endDate'] = $_POST['to'];
                $data['startDate'] = $_POST['from'];
            }

            $this->log('Headers'. json_encode($headers), 'info');
            $result = $this->_model->getRestoreHistory($headers,$data,$_POST['pageNumber']);
            
            if(!empty($result['body']->{'data'}->{'restoreHistoryElement'})){
                foreach($result['body']->{'data'}->{'restoreHistoryElement'} as $value){
                    /*if($value->{'restoredFiles'} != '-'){
                            $value->{'restoredFiles'} = intval($value->{'restoredFiles'});
                    }else{
                        $value->{'restoredFiles'} = $value->{'restoredFiles'};
		    }*/
		if(!empty($value->{'restoredFiles'})){
		    if($value->{'restoredFiles'} != '-'){
                        $parts = explode("/", $value->{'restoredFiles'});
                        if (count($parts) == 2) {
                                $numerator = $parts[0];
                                $denominator = $parts[1];
                                if(intval($numerator) != intval($denominator)){
                                        $value->{'status'} = 'Incomplete';
                                }
                        }
		    }
		}
                    $value->{'restoreTime'} = date('d-M-Y H:i:s',(int)($value->{'restoreTimeInMillis'})/1000);
		    if($value->{'restoreEndTimeInMillis'} != 0){
                    	$value->{'restoreEndTime'} = date('d-M-Y H:i:s',(int)($value->{'restoreEndTimeInMillis'})/1000);
		    }else{
		    	$value->{'restoreEndTime'} = '-';
		    }
                    $value->{'restoreFolder'} = !empty($value->{'restoreFolder'}) ? base64_decode($value->{'restoreFolder'}) : '-';
                    $value->{'destFolder'} = !empty($value->{'destFolder'}) ? base64_decode($value->{'destFolder'}) : '-';
		    if(!empty($value->{'deviceName'})){
                    	if((strpos($value->{'deviceName'}, '(Microsoft OneDrive)') !== false || strpos($value->{'deviceName'}, '(Microsoft Exchange)') !== false || strpos($value->{'deviceName'}, '(Microsoft Sharepoint)') !== false)){
                        	//$value->{'restoredSize'} = 'NA';
                        	//$value->{'restoredSizeInKB'} = 0;
                    	}
		    }else{
                    	//$value->{'restoredSize'} = 'NA';
                        //$value->{'restoredSizeInKB'} = 0;
                    }
		    if($value->{'status'} == 'Started'){
                        $value->{'restoreEndTime'} = '-';
                        $value->{'restoreEndTimeInMillis'} = 0;
                    }
                }
            }else{
                $result['body']->{'data'}->{'restoreHistoryElement'} = null;
            }
            if(!empty($result['body']->{'metadata'})){
            	$metadata = $result['body']->{'metadata'};
            	$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
            }else{
            	$metadata = [];
            }
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'restoreByDate' => $result['body']->{'data'}->{'restoreHistoryElement'},
                        'metadata'=> $metadata
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                    	'result' => 'fail',
                    	'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'respos' => $headers,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getRestoreHistory1(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType']
            );
            $data = array(
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'userName'      => $_POST["userName"],
                'deviceName'    => $_POST["deviceName"],
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report' 	=> 'RESTORE_HISTORY',
            	'productType'	=> $_POST['reportProductType'],
            	'operationType'	=> 'GENERATE_VIEW'
            );
            
            if(empty($_POST['from']) && empty($_POST['to']) && empty($_POST['userName']) && empty($_POST['deviceName'])){
                $data['endDate'] = '';
                $data['startDate'] = '';
            }elseif(!empty($_POST['from']) && !empty($_POST['to'])){
                $data['endDate'] = $_POST['to'];
                $data['startDate'] = $_POST['from'];
            }

            $this->log('Headers'. json_encode($headers), 'info');
            $result = $this->_model->getRestoreHistory($headers,$data,$_POST['pageNumber']);
            
            if(!empty($result['body']->{'data'}->{'restoreHistoryElement'})){
                foreach($result['body']->{'data'}->{'restoreHistoryElement'} as $value){
                    /*if($value->{'restoredFiles'} != '-'){
                            $value->{'restoredFiles'} = intval($value->{'restoredFiles'});
                    }else{
                        $value->{'restoredFiles'} = $value->{'restoredFiles'};
		    }*/
		if(!empty($value->{'restoredFiles'})){
		    if($value->{'restoredFiles'} != '-'){
                        $parts = explode("/", $value->{'restoredFiles'});
                        if (count($parts) == 2) {
                                $numerator = $parts[0];
                                $denominator = $parts[1];
                                if(intval($numerator) != intval($denominator)){
                                        $value->{'status'} = 'Incomplete';
                                }
                        }
		    }
		}
                    $value->{'restoreTime'} = date('d-M-Y H:i:s',(int)($value->{'restoreTimeInMillis'})/1000);
		    if($value->{'restoreEndTimeInMillis'} != 0){
                    	$value->{'restoreEndTime'} = date('d-M-Y H:i:s',(int)($value->{'restoreEndTimeInMillis'})/1000);
		    }else{
		    	$value->{'restoreEndTime'} = '-';
		    }
                    $value->{'restoreFolder'} = !empty($value->{'restoreFolder'}) ? base64_decode($value->{'restoreFolder'}) : '-';
                    $value->{'destFolder'} = !empty($value->{'destFolder'}) ? base64_decode($value->{'destFolder'}) : '-';
		    if(!empty($value->{'deviceName'})){
                    	if((strpos($value->{'deviceName'}, '(Microsoft OneDrive)') !== false || strpos($value->{'deviceName'}, '(Microsoft Exchange)') !== false || strpos($value->{'deviceName'}, '(Microsoft Sharepoint)') !== false)){
                        	//$value->{'restoredSize'} = 'NA';
                        	//$value->{'restoredSizeInKB'} = 0;
                    	}
		    }else{
                    	//$value->{'restoredSize'} = 'NA';
                        //$value->{'restoredSizeInKB'} = 0;
                    }
		    if($value->{'status'} == 'Started'){
                        $value->{'restoreEndTime'} = '-';
                        $value->{'restoreEndTimeInMillis'} = 0;
                    }
                }
            }else{
                $result['body']->{'data'}->{'restoreHistoryElement'} = null;
            }
            if(!empty($result['body']->{'metadata'})){
            	$metadata = $result['body']->{'metadata'};
            	$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
            }else{
            	$metadata = [];
            }
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'restoreByDate' => $result['body']->{'data'}->{'restoreHistoryElement'},
			'metadata'=> $metadata
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                    	'result' => 'fail',
                    	'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'respos' => $headers,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    

    public function updateSyncCloudUsageDetails(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'userName'      => null,
                'deviceName'    => null,
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            if(empty($_POST['from']) && empty($_POST['to']) && empty($_POST['userName']) && empty($_POST['deviceName'])){
                $headers['endDate'] = '';
                $headers['startDate'] = '';
            }elseif(!empty($_POST['from']) && !empty($_POST['to'])){
                $headers['endDate'] = $_POST['to'];
                $headers['startDate'] = $_POST['from'];
            }elseif(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }elseif(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }
            $this->log('Headers'. json_encode($headers), 'info');
            $result = $this->_model->updateSyncCloudUsageDetails($headers);
            foreach($result['body']->{'syncOverviewListElement'}->{'fileElementList'} as $value){
                    $value->{'totalFilesDownloaded'} = intval($value->{'totalFilesDownloaded'});
                    $value->{'totalFilesShared'} = intval($value->{'totalFilesShared'});
                    $value->{'totalUsers'} = intval($value->{'totalUsers'});
                }
            $this->log('Logging Syn Cloud Usage Details'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'syncCloudUsageDetails' => $result['body']->{'syncOverviewListElement'}->{'fileElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'respos' => $headers,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function longBackup(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('longBackup'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/longBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getLongBackup(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            $result = $this->_model->getLongBackupDetails($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'longBackup' => $result['body']->{'notificationElementList'}->{'delayedNotificationHistoryElements'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function currentBackup(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('currentBackup'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/currentBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getCurrentBackup(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'searchValue' => $_POST['searchValue'],
		'backupType' => $_POST['backupType'],
		'productType' => $_POST['productType']
            );
            $result = $this->_model->getCurrentBackupDetails($headers,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
			$currentBackupList = [];
			if(!empty($result['body']->{'metadata'})){
				$metadata = $result['body']->{'metadata'};
			}else{
				$metadata = [];
			}
			if(!empty($result['body']->{'notificationElementList'}->{'currentBatchElements'})){
                                foreach($result['body']->{'notificationElementList'}->{'currentBatchElements'} as $value){
					$currentBackup = array(
						"deviceName" => !empty($value->{"deviceName"}) ? $value->{"deviceName"} : '-',
                                                "userName" => !empty($value->{"userName"}) ? $value->{"userName"} : '-',
                                                "startTime"=> !empty($value->{"startTime"}) ? $value->{"startTime"} : '-',
                                                "whenFailed"=> !empty($value->{"whenFailed"}) ? $value->{"whenFailed"} : '-',
                                                "errorCode"=> !empty($value->{"errorCode"}) ? $value->{"errorCode"} : '-',
                                                "failedReason"=> !empty($value->{"failedReason"}) ? $value->{"failedReason"} : '-',
                                                "uploadedFiles"=> !empty($value->{"uploadedFiles"}) ? $value->{"uploadedFiles"} : '-',
                                                "totalNoOfFiles"=> !empty($value->{"totalNoOfFiles"}) ? $value->{"totalNoOfFiles"} : '-',
                                                "noOfFiles"=> !empty($value->{"noOfFiles"}) ? $value->{"noOfFiles"} : '-',
                                                "totalFiles"=> !empty($value->{"totalFiles"}) ? $value->{"totalFiles"} : '-',
                                                "uploadPercent"=> !empty($value->{"uploadPercent"}) ? $value->{"uploadPercent"} : '0',
                                                "deviceUUID"=> !empty($value->{"deviceUUID"}) ? $value->{"deviceUUID"} : '-',
                                                "status"=> !empty($value->{"status"}) ? $value->{"status"} : '-',
                                                "deviceType"=> !empty($value->{"deviceType"}) ? $value->{"deviceType"} : '-',
                                                "startTimeInMillis"=> !empty($value->{"startTimeInMillis"}) ? $value->{"startTimeInMillis"} : '0',
                                                "whenFailedInMillis"=> !empty($value->{"whenFailedInMillis"}) ? $value->{"whenFailedInMillis"} : '0',
                                                "currentlyRunningBkpTotalSizeOfFilesInKB"=> !empty($value->{"currentlyRunningBkpTotalSizeOfFilesInKB"}) ? $value->{"currentlyRunningBkpTotalSizeOfFilesInKB"} : '-',
                                                "totalSizeToUploadInKB"=> !empty($value->{"totalSizeToUploadInKB"}) ? $value->{"totalSizeToUploadInKB"} : '-',
                                                "restoreByUserName"=> !empty($value->{"restoreByUserName"}) ? $value->{"restoreByUserName"} : '-',
                                                "restoreByDeviceName"=> !empty($value->{"restoreByDeviceName"}) ? $value->{"restoreByDeviceName"} : '-',
                                                "restoreByDeviceUUID"=> !empty($value->{"restoreByDeviceUUID"}) ? $value->{"restoreByDeviceUUID"} : '-',
                                                "restoreInitiatedBy"=> !empty($value->{"restoreInitiatedBy"}) ? $value->{"restoreInitiatedBy"} : '-',
                                                "backupType"=> !empty($value->{"backupType"}) ? $value->{"backupType"} : '-',
                                                "totalRestorePct"=> !empty($value->{"totalRestorePct"}) ? $value->{"totalRestorePct"} : '0',
                                                "destFolder"=> !empty($value->{"destFolder"}) ? $value->{"destFolder"} : '-',
                                                "restoreFolder"=> !empty($value->{"restoreFolder"}) ? $value->{"restoreFolder"} : '-'
					);
					$currentBackupList = array_merge(array($currentBackup), $currentBackupList);
				}
			}
                    $response = array(
                        'result' => 'success',
			'currentBackup' => array_reverse($currentBackupList),
                        //'currentBackup' => $result['body']->{'notificationElementList'}->{'currentBatchElements'},
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getCurrentBackup1(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'searchValue' => $_POST['searchValue'],
		'backupType' => $_POST['backupType'],
		'productType' => $_POST['productType']
            );
            $result = $this->_model->getCurrentBackupDetails1($headers,$_POST['url']);
            switch ($result['status']) {
                case (200):
                        $currentBackupList = [];
                        if(!empty($result['body']->{'metadata'})){
                                $metadata = $result['body']->{'metadata'};
                        }else{
                                $metadata = [];
                        }
                        if(!empty($result['body']->{'notificationElementList'}->{'currentBatchElements'})){
                                foreach($result['body']->{'notificationElementList'}->{'currentBatchElements'} as $value){
                                        $currentBackup = array(
						"deviceName" => !empty($value->{"deviceName"}) ? $value->{"deviceName"} : '-',
                                                "userName" => !empty($value->{"userName"}) ? $value->{"userName"} : '-',
                                                "startTime"=> !empty($value->{"startTime"}) ? $value->{"startTime"} : '-',
                                                "whenFailed"=> !empty($value->{"whenFailed"}) ? $value->{"whenFailed"} : '-',
                                                "errorCode"=> !empty($value->{"errorCode"}) ? $value->{"errorCode"} : '-',
                                                "failedReason"=> !empty($value->{"failedReason"}) ? $value->{"failedReason"} : '-',
                                                "uploadedFiles"=> !empty($value->{"uploadedFiles"}) ? $value->{"uploadedFiles"} : '-',
                                                "totalNoOfFiles"=> !empty($value->{"totalNoOfFiles"}) ? $value->{"totalNoOfFiles"} : '-',
                                                "noOfFiles"=> !empty($value->{"noOfFiles"}) ? $value->{"noOfFiles"} : '-',
                                                "totalFiles"=> !empty($value->{"totalFiles"}) ? $value->{"totalFiles"} : '-',
                                                "uploadPercent"=> !empty($value->{"uploadPercent"}) ? $value->{"uploadPercent"} : '0',
                                                "deviceUUID"=> !empty($value->{"deviceUUID"}) ? $value->{"deviceUUID"} : '-',
                                                "status"=> !empty($value->{"status"}) ? $value->{"status"} : '-',
                                                "deviceType"=> !empty($value->{"deviceType"}) ? $value->{"deviceType"} : '-',
                                                "startTimeInMillis"=> !empty($value->{"startTimeInMillis"}) ? $value->{"startTimeInMillis"} : '0',
                                                "whenFailedInMillis"=> !empty($value->{"whenFailedInMillis"}) ? $value->{"whenFailedInMillis"} : '0',
                                                "currentlyRunningBkpTotalSizeOfFilesInKB"=> !empty($value->{"currentlyRunningBkpTotalSizeOfFilesInKB"}) ? $value->{"currentlyRunningBkpTotalSizeOfFilesInKB"} : '-',
                                                "totalSizeToUploadInKB"=> !empty($value->{"totalSizeToUploadInKB"}) ? $value->{"totalSizeToUploadInKB"} : '-',
                                                "restoreByUserName"=> !empty($value->{"restoreByUserName"}) ? $value->{"restoreByUserName"} : '-',
                                                "restoreByDeviceName"=> !empty($value->{"restoreByDeviceName"}) ? $value->{"restoreByDeviceName"} : '-',
                                                "restoreByDeviceUUID"=> !empty($value->{"restoreByDeviceUUID"}) ? $value->{"restoreByDeviceUUID"} : '-',
                                                "restoreInitiatedBy"=> !empty($value->{"restoreInitiatedBy"}) ? $value->{"restoreInitiatedBy"} : '-',
                                                "backupType"=> !empty($value->{"backupType"}) ? $value->{"backupType"} : '-',
                                                "totalRestorePct"=> !empty($value->{"totalRestorePct"}) ? $value->{"totalRestorePct"} : '0',
                                                "destFolder"=> !empty($value->{"destFolder"}) ? $value->{"destFolder"} : '-',
                                                "restoreFolder"=> !empty($value->{"restoreFolder"}) ? $value->{"restoreFolder"} : '-'
					);
					$currentBackupList = array_merge(array($currentBackup), $currentBackupList);                                 
                                }
                        }
                    $response = array(
                        'result' => 'success',
                        'currentBackup' => array_reverse($currentBackupList),
                        //'currentBackup' => $result['body']->{'notificationElementList'}->{'currentBatchElements'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getCurrentRestore(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
		'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'productType' => $_POST['productType']
            );
             $result = $this->_model->getCurrentRestoreDetails($headers,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
			if(!empty($result['body']->{'metadata'})){
				$metadata = $result['body']->{'metadata'};
				$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
			}else{
				$metadata = [];
			}
		    if(!empty($result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'})){
			foreach($result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'} as $value){
			    $value->{'restoreFolder'} = !empty($value->{'restoreFolder'}) ? base64_decode($value->{'restoreFolder'}) : '-';
			    $value->{'destFolder'} = !empty($value->{'destFolder'}) ? base64_decode($value->{'destFolder'}) : '-';
			}
            	    }/*else{
		    	$result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'} = [];
		    }*/
                    $response = array(
                        'result' => 'success',
                        'currentRestore' => !empty($result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'}) ? $result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'} : null,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getCurrentRestore1(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
		'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'productType' => $_POST['productType']
            );
            $result = $this->_model->getCurrentRestoreDetails1($headers,$_POST['url']);
            switch ($result['status']) {
                case (200):
			if(!empty($result['body']->{'metadata'})){
				$metadata = $result['body']->{'metadata'};
				$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
			}else{
				$metadata = [];
			}
		    if(!empty($result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'})){
			foreach($result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'} as $value){
			    $value->{'restoreFolder'} = !empty($value->{'restoreFolder'}) ? base64_decode($value->{'restoreFolder'}) : '-';
                            $value->{'destFolder'} = !empty($value->{'destFolder'}) ? base64_decode($value->{'destFolder'}) : '-';
			}
            	    }/*else{
		    	$result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'} = [];
		    }*/
                    $response = array(
                        'result' => 'success',
                        'currentRestore' => !empty($result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'}) ? $result['body']->{'data'}->{'notificationElementList'}->{'currentBatchElements'} : null,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                    )
            );
        }
    }

    public function noBackup($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
	$backupPolicies=[];
	if($reportProductType == 'backup'){
        	$backupResult=$this->_model->getAllPolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        	foreach((array)$backupResult['body']->{'stringList'} as $value){
            		$policy = $value;
            		$backupPolicies = array_merge(array($policy), $backupPolicies);
		}
	}
	$odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
        if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
        }
        if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('noBackup'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
	    'backupPolicies' => array_reverse($backupPolicies),
	    'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/noBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getNoBackup(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType'],
		'system-based' => 'true'
            ); 
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }            
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		"report"        => "ASSETS_NOT_PROTECTED",
                "productType"   => $_POST['reportProductType'],
		"operationType" => "GENERATE_VIEW",
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'true'
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getNoBackupDetails($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'backupHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupHistoryElement'} as $value){
                        $value->{'noOfDaysNotBackedUp'} = intval($value->{'noOfDaysNotBackedUp'});
                    }
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                    $response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'backupHistoryElement'}) ? $result['body']->{'data'}->{'backupHistoryElement'} : [],
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('204')
                    );
                    echo json_encode($result);
		    exit();
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getNoBackup1(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType'],
		'system-based' => 'true'
            ); 
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
        	    $_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
        	    $_POST['userName']='';
            }

            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
        	    $_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		"report"        => "ASSETS_NOT_PROTECTED",
                "productType"   => $_POST['reportProductType'],
		"operationType" => "GENERATE_VIEW",
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'true'
                );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getNoBackupDetails1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'backupHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupHistoryElement'} as $value){
                        $value->{'noOfDaysNotBackedUp'} = intval($value->{'noOfDaysNotBackedUp'});
                        $value->{'lastHeardTime'} = intval($value->{'lastHeardTime'});
                    }
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
		$response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'backupHistoryElement'}) ? $result['body']->{'data'}->{'backupHistoryElement'} : [],
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('204')
                    );
                    echo json_encode($result);
		    exit();
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function lastAgentServerConnectionDetails($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $backupPolicies=[];
        $backupResult=$this->_model->getAllPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('lastAgentServerConnectionDetails'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
            'backupPolicies' => array_reverse($backupPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/lastAgentServerConnectionDetails', $data);
        View::renderTemplate('footer', $data);
    }

    public function getLastAgentServerConnectionDetails(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType']
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
            $data = array(
                'noOfDays' => $_POST['numberOfDays'],
		'policyNames'  => $_POST['policyName'],
		'productType' => $_POST['reportProductType']
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getAgentNotHeardDetails($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'devicePolicyDetailsList'})){
                    foreach($result['body']->{'data'}->{'devicePolicyDetailsList'} as $value){
                        $value->{'formatedTime'} = date('d-M-Y H:i:s',(int)($value->{'formatedTimeInMills'})/1000);
                    }
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                    $response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'devicePolicyDetailsList'}) ? $result['body']->{'data'}->{'devicePolicyDetailsList'} : null,
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getLastAgentServerConnectionDetails1(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType']
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            		$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            		$_POST['userName']='';
            }

            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            		$_POST['deviceName'] = '';
            }
            $data = array(
                'noOfDays' => $_POST['numberOfDays'],
		'policyNames'  => $_POST['policyName'],
		'productType' => $_POST['reportProductType']
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getAgentNotHeardDetails1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'devicePolicyDetailsList'})){
                    foreach($result['body']->{'data'}->{'devicePolicyDetailsList'} as $value){
                        $value->{'formatedTime'} = date('d-M-Y H:i:s',(int)($value->{'formatedTimeInMills'})/1000);
                    }
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                    $response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'devicePolicyDetailsList'}) ? $result['body']->{'data'}->{'devicePolicyDetailsList'} : null,
			'metadata' => $metadata
		    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                    case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }


    public function downloadAgentNotHeardReport(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
	    'productType'   => $_POST['reportProductType']
        );
        if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
             $_POST['policyName'] = [];
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }

        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        $data = array(
                'noOfDays' => $_POST['number'],
		'policyNames'  => $_POST['policyName'],
		'productType' => $_POST['reportProductType']
            );
        $this->log("HEADERS".json_encode($headers),"info");
        $this->log("DATA".json_encode($data),"info");

        $result = $this->_model->downloadAgentNotHeardReport($headers, $data);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;
	    case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('204')
                );
                echo json_encode($result);
                exit();
	    case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                     );
                    echo json_encode($response);
                    exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function downloadAgentNotHeardReportExcel(){
        $filePath = AGENT_NOT_HEARD_PATH.AGENT_NOT_HEARD_OVERVIEW;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
	    //header('Content-Disposition: attachment; filename='.AGENT_NOT_HEARD_OVERVIEW);
	    header('Content-Disposition: attachment; filename=Asset_Heartbeat_Report.xlsx');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }
    
    public function userBackupSummary($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
	$backupPolicies=[];
	if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllPolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
	}
	}
	$odbPolicies=[];
        $exchangePolicies=[];
	$sharepointPolicies=[];
	if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
            if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
        }
        if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userBackupSummary'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
	    'backupPolicies' => array_reverse($backupPolicies),
	    'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/userBackupSummary', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getUserBackupSummary(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
		'Content-type'  => 'application/json',
		'Accept'  => 'application/json',
		'productType'   => $_POST['reportProductType']
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }

            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            $data = array(
                'noOfDays' => $_POST['numberOfDays'],
		'policyNames'  => $_POST['policyName'],
		"report" => "DATA_PROTECTION_SCORECARD",
                "productType"=> $_POST['reportProductType'],
                "operationType"=> "GENERATE_VIEW"
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getUserBackupSummary($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'userBackupSummary' => $result['body']->{'data'}
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadUserBackupSummaryReport(){
        $headers = array(
	    'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
	    'productType'   => $_POST['reportProductType']
        );
        if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
        $_POST['policyName'] = [];
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
	}
	if(isset($_POST['includeDetails']) && $_POST['includeDetails']=='true'){
             $_POST['includeDetails'] = true;
        }else{
                $_POST['includeDetails'] = false;
        }
        $data = array(
                'noOfDays' => $_POST['number'],
                'policyNames'  => $_POST['policyName'],
		'includeDetails' => $_POST['includeDetails'],
		"report" => "DATA_PROTECTION_SCORECARD",
                "productType"=> $_POST['reportProductType'],
                "operationType"=> "GENERATE_EXCEL"
            );
        $this->log("HEADERS".json_encode($headers),"info");
        $this->log("DATA".json_encode($data),"info");
        $result = $this->_model->downloadUserBackupSummaryReport($headers, $data);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('204')
                );
                echo json_encode($result);
		exit();
	    case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                    );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function downloadUserBackupSummaryReportExcel(){
        $filePath = AGENT_NOT_HEARD_PATH.USER_BACKUP_SUMMARY;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.USER_BACKUP_SUMMARY);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }

    public function storageUtilizedByUser(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizationByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/storageUtilized/storageUtilizedByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function storageUtilizedByDevice(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizationByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/storageUtilized/storageUtilizedByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStorageUtilized(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'deviceName'    => null,
                'userName'      => null,
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            if(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }elseif(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }
            $result = $this->_model->getStorageUtilized($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'storageUtilized' => $result['body']->{'storageInfoElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function storageUtilizedByPG(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizedByPG'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/storageUtilized/storageUtilizedByPG', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStorageUtilizedByPG(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getStorageUtilizedByPG($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'storageUtilizedByPG' => $result['body']->{'PGInfoElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function failedBackup($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $backupResult = $this->_model->getAllPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        $backupPolicies = [];
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('failedBackup'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserRole'=>$this->session->get('readOnlyAdmin'),
            'backupPolicies'=>array_reverse($backupPolicies),
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/failedBackup', $data);
        View::renderTemplate('footer', $data);
    }
            
    public function failedBackupByUser(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('failedBackupByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/failedBackupByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function failedBackupByDevice(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('failedBackupByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/failedBackupByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getFailedBackup(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }

            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }

            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
		'productType' => $_POST['reportProductType']
                
            );
            $data =array(
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y'),
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->getFailedBackup($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
                    if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		    }else{
			$metadata = [];
		    }
		if(!empty($result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'})){
                    foreach($result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'} as $value){
                        $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeInMillis'})/1000);
                        $value->{'whenFailed'} = date('d-M-Y H:i:s',(int)($value->{'whenFailedInMillis'})/1000);
                    }
		}
                    $response = array(
                        'result' => 'success',
                        'failedBackup' => !empty($result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'}) ? $result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'} : [],
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getFailedBackup1(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }
 	    if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Accept'  => 'application/json',
                'Content-Type'  => 'application/json',
		'productType' => $_POST['reportProductType']
                );
            $data =array(
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y'),
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->getFailedBackup1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
		if(!empty($result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'})){
                    foreach($result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'} as $value){
                        $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeInMillis'})/1000);
                        $value->{'whenFailed'} = date('d-M-Y H:i:s',(int)($value->{'whenFailedInMillis'})/1000);
                    }
		}
                    $response = array(
                        'result' => 'success',
                        'failedBackup' => !empty($result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'}) ? $result['body']->{'data'}->{'notificationElementList'}->{'notificationHistoryElementList'} : [],
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
                );
        }
    }


    public function storage(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageTrend'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/trend/storage', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStorageTrend(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
            exit;
        }
        if(!empty($_POST['from']) && $_POST['to'] == 'dashboard'){
            $_POST['from'] = date('m/d/Y', ($_POST['from']/1000));
            $_POST['to'] = date('m/d/Y', ($_POST['to']/1000));
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 31){
            $data = array(
                'result' => 'fail',
                'msg' => 'Trend Graph can only be plotted between 31 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $days = array();
        for($i = 0; $i < $numberDays; $i++){
            $date = strtotime("+".$i." day", strtotime($fromDate));
            $days = array_merge($days, array(array('size'=> 0,'date'=>date('d-M', $date))));
        }
        $response 	= $this->_model->getStorageTrend($fromDate, $toDate);
        $response 	= json_decode($response , true);
        if(empty($response)){
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $pgS = array();
        $dataForPG = array();
        foreach($response['PGInfoElementList'] as $item){
            $curPG = array($item['gatewayName']);
            $pgS = array_merge($pgS, $curPG);
        }
        $pgS = array_unique($pgS);
        foreach($pgS as $pg){
            $allData = array();
            foreach($response['PGInfoElementList'] as $key => $item){
                if($pg == $item['gatewayName']){
                    $data = array(
                        'size' => round($item['sizeInMB']/1000, 2),
                        'date' => date('d-M', strtotime($item['date']))
                    );
                    $allData[$key] = $data;
                }
            }
            $dataForPG[$pg] = array_values($allData);
        }
        if(count($dataForPG) >= 1){
            $dataPerDayPerPG = array();
            foreach($dataForPG as $pg => $pgData){
                $dataPerDayPerPG[$pg] = $days;
            }
            $finalPGPerData = array();
            foreach($dataPerDayPerPG as $pgKey => $data){
                $keys = array_column($dataForPG[$pgKey], 'date');
                $size = array_column($dataForPG[$pgKey], 'size');
                $finalData = array();
                foreach($data as $d){
                    if(in_array($d['date'], $keys)){
                        $key = array_search($d['date'], $keys);
                        $d['size'] = $size[$key];
                    }
                    $finalData = array_merge($finalData, array($d));
                }
                $finalPGPerData[$pgKey] = $finalData;
            }
            $jsonData = json_encode($finalPGPerData);
            echo $jsonData;
            exit;
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
    }

    public function blobTrend(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('blobTrend'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/trend/blob', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBlobTrend(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
            exit;
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 31){
            $data = array(
                'result' => 'fail',
                'msg' => 'Trend Graph can only be plotted between 31 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $days = array();
        for($i = 0; $i < $numberDays; $i++){
            $date = strtotime("+".$i." day", strtotime($fromDate));
            $days = array_merge($days, array(array('size'=> 0,'date'=>date('d-M', $date))));
        }
        $response 	= $this->_model->getBlobTrend($fromDate, $toDate);
        $response 	= json_decode($response , true);
        if(empty($response)){
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $pgS = array();
        $dataForPG = array();
        foreach($response['PGInfoElementList'] as $item){
            $curPG = array($item['gatewayName']);
            $pgS = array_merge($pgS, $curPG);
        }
        $pgS = array_unique($pgS);
        foreach($pgS as $pg){
            $allData = array();
            foreach($response['PGInfoElementList'] as $key => $item){
                if($pg == $item['gatewayName']){
                    $data = array(
                        'size' => round($item['sizeInMB']/1000, 3),
                        'date' => date('d-M', strtotime($item['date']))
                    );
                    $allData[$key] = $data;
                }
            }
            $dataForPG[$pg] = array_values($allData);
        }
        if(count($dataForPG) >= 1){
            $dataPerDayPerPG = array();
            foreach($dataForPG as $pg => $pgData){
                $dataPerDayPerPG[$pg] = $days;
            }
            $finalPGPerData = array();
            foreach($dataPerDayPerPG as $pgKey => $data){
                $keys = array_column($dataForPG[$pgKey], 'date');
                $size = array_column($dataForPG[$pgKey], 'size');
                $finalData = array();
                foreach($data as $d){
                    if(in_array($d['date'], $keys)){
                        $key = array_search($d['date'], $keys);
                        $d['size'] = $size[$key];
                    }
                    $finalData = array_merge($finalData, array($d));
                }
                $finalPGPerData[$pgKey] = $finalData;
            }
            $jsonData = json_encode($finalPGPerData);
            echo $jsonData;
            exit;
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
    }

    public function backupTrend(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('backupTrend'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/trend/backup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBackupTrend(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
            exit;
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 31){
            $data = array(
                'result' => 'fail',
                'msg' => 'Trend Graph can only be plotted between 31 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $days = array();
        for($i = 0; $i < $numberDays; $i++){
            $date = strtotime("+".$i." day", strtotime($fromDate));
            $days = array_merge($days, array(array('size'=> 0,'date'=>date('d-M', $date))));
        }
        $response 	= $this->_model->getBackupTrend($fromDate, $toDate);
        $response 	= json_decode($response , true);
        if(empty($response)){
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $pgS = array();
        $dataForPG = array();
        foreach($response['PGInfoElementList'] as $item){
            $curPG = array($item['gatewayName']);
            $pgS = array_merge($pgS, $curPG);
        }
        $pgS = array_unique($pgS);
        foreach($pgS as $pg){
            $allData = array();
            foreach($response['PGInfoElementList'] as $key => $item){
                if($pg == $item['gatewayName']){
                    $data = array(
                        'size' => round($item['sizeInMB']/1000, 3),
                        'date' => date('d-M', strtotime($item['date']))
                    );
                    $allData[$key] = $data;
                }
            }
            $dataForPG[$pg] = array_values($allData);
        }
        if(count($dataForPG) >= 1){
            $dataPerDayPerPG = array();
            foreach($dataForPG as $pg => $pgData){
                $dataPerDayPerPG[$pg] = $days;
            }
            $finalPGPerData = array();
            foreach($dataPerDayPerPG as $pgKey => $data){
                $keys = array_column($dataForPG[$pgKey], 'date');
                $size = array_column($dataForPG[$pgKey], 'size');
                $finalData = array();
                foreach($data as $d){
                    if(in_array($d['date'], $keys)){
                        $key = array_search($d['date'], $keys);
                        $d['size'] = $size[$key];
                    }
                    $finalData = array_merge($finalData, array($d));
                }
                $finalPGPerData[$pgKey] = $finalData;
            }
            $jsonData = json_encode($finalPGPerData);
            echo $jsonData;
            exit;
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
    }

    public function userDeviceHistory(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userDeviceHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/userDeviceHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUserDeviceHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : ''
            );
            $result = $this->_model->getUserDeviceHistory($headers);
            $this->log('result' .json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'userDeviceHistory' => $result['body']->{'userDeviceHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function userBackupHistory($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
	$backupPolicies=[];
	if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
	}
	}
	$odbPolicies=[];
        $exchangePolicies=[];
	$sharepointPolicies=[];
	if($reportProductType == 'sharepoint'){
		$resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
		if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
	}
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
        }
        if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userBackupHistory'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
	    'backupPolicies'=>array_reverse($backupPolicies),
	    'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/userBackupHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUserBackupHistory(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
		'productType' => $_POST['reportProductType']
            );         
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '' ,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
		"report"        => "BACKUP_HISTORY",
                "productType"   => $_POST['reportProductType'],
                "operationType" => "GENERATE_VIEW"
            );
            $result = $this->_model->getUserBackupHistory($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'backupHistoryElement'} )){
                foreach($result['body']->{'data'}->{'backupHistoryElement'} as $value){
                    $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeInMillis'})/1000);
                    $value->{'endTime'} = date('d-M-Y H:i:s',(int)($value->{'endTimeInMillis'})/1000);
                }
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                    $response = array(
                        'result' => 'success',
                        'userBackupHistory' => !empty($result['body']->{'data'}->{'backupHistoryElement'}) ? $result['body']->{'data'}->{'backupHistoryElement'} : [],
			'metadata' => $metadata
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }
    
    public function getUserBackupHistory1(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }

            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'token' => $this->session->get('token'),
		'Content-type' => 'application/json',
            	'Accept' => 'application/json',
		'productType' => $_POST['reportProductType']
            );
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '' ,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
		"report" 	=> "BACKUP_HISTORY",
                "productType"	=> $_POST['reportProductType'],
                "operationType"	=> "GENERATE_VIEW"
            );
            $result = $this->_model->getUserBackupHistory1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'backupHistoryElement'} )){
                foreach($result['body']->{'data'}->{'backupHistoryElement'} as $value){
                    $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeInMillis'})/1000);
                    $value->{'endTime'} = date('d-M-Y H:i:s',(int)($value->{'endTimeInMillis'})/1000);
                }
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                    $response = array(
                        'result' => 'success',
                        'userBackupHistory' => $result['body']->{'data'}->{'backupHistoryElement'},
			'metadata' => $metadata
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }

    public function dailyUserBackupOverview($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
	$cloudProperties = $this->_model->getCloudProperties($headers);        
	$backupPolicies=[];
        if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        }
        $odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
        if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
	}
	if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizationReport'),
            'active' => 'report',
	    'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get("readOnlyAdmin"),
            'showLatestBkpInfo' => $cloudProperties['body']->{'cloudPropertyElement'}->{'showLatestBkpInfo'},
            'hideStorageSizeInCloud' => $cloudProperties['body']->{'cloudPropertyElement'}->{'hideStorageSizeInCloud'},
	    'hideStorageSizeOnServer' => $cloudProperties['body']->{'cloudPropertyElement'}->{'hideStorageSizeOnServer'},
	    'hideCompressedSize' => $cloudProperties['body']->{'cloudPropertyElement'}->{'hideCompressedSize'},
	    'backupPolicies'=>array_reverse($backupPolicies),
            'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/dailyUserBackupOverview', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDailyUserBackupOverview(){        
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }

        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
        $_POST['policyName'] = [];
        }
        $headers = array(
            'Content-Type'  => 'application/json',
            'token' => $this->session->get('token'),
            'Accept' => 'application/json',
	    'productType' => $_POST['reportProductType']
        );
        $data = array(
            'deviceName'      => !empty($_POST['deviceName']) ? ($_POST['deviceName'] == 'all') ? '' : $_POST['deviceName'] : '',
            'userName'      => !empty($_POST['userName']) ? ($_POST['userName'] == 'all') ? "" : $_POST['userName'] : '',
            /*'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '',*/
            'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
        );
        $this->log(json_encode($headers), "info");
        $this->log(json_encode($data), "info");
        $result = $this->_model->getDailyUserBackupOverview($headers,$data,$_POST['pageNumber']);
        $this->log(json_encode($result), "info");
        $dailyUserBackupOverview = [];
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'data'}->{'overview'})){
                    foreach($result['body']->{'data'}->{'overview'} as $row){
                        $current['userName'] = $row->{'userName'};
                        $current['deviceName'] = $row->{'deviceName'};
                        $current['storageDate'] = $row->{'storageDate'};
                        $current['storageUsedInPg'] = $row->{'storageUsedInPg'};
                        $current['actualStorageUtilized'] = $row->{'actualStorageUtilized'};
                        $current['storageUsedInCloud'] = $row->{'storageUsedInCloud'};
                        $current['storageUtilized'] = $row->{'storageUtilized'};
                        //$current['totalSizeOfDataInCurrentBackupSet'] = $row->{'totalSizeOfDataInCurrentBackupSet'};
                        $current['totalSizeOfDataInCurrentBackupLatestVersion'] = $row->{'totalSizeOfDataInCurrentBackupLatestVersion'};
                        $current['storageDateReadable'] = date('m/d/y', (((int)$row->{'storageDate'}) / 1000));
                        $current['totalSizeOfBackupFileCompressionRatio'] = $row->{'totalSizeOfBackupFileCompressionRatio'};
                        $current['storageUsedInPgInKB'] = $row->{'storageUsedInPgInKB'};
                        $current['storageUsedInCloudInKB'] = $row->{'storageUsedInCloudInKB'};
                        $current['totalSizeOfDataInCurrentBackupLatestVersionInKB'] = $row->{'totalSizeOfDataInCurrentBackupLatestVersionInKB'};
                        $current['storageUtilizedInKB'] = $row->{'storageUtilizedInKB'};
                        $current['actualStorageUtilizedInKB'] = $row->{'actualStorageUtilizedInKB'};
                        $dailyUserBackupOverview = array_merge(array($current), $dailyUserBackupOverview);
                    }
                }
                if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                $response = array(
                    'result' => 'success',
                    'dailyUserBackupOverview' => $dailyUserBackupOverview,
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
    
    public function getDailyUserBackupOverview1(){
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
        $_POST['policyName'] = [];
        }
        $headers = array(
            'Content-Type'  => 'application/json',
            'token' => $this->session->get('token'),
            'Accept' => 'application/json',
	    'productType' => $_POST['reportProductType']
        );
        $data = array(
            'deviceName'      => !empty($_POST['deviceName']) ? ($_POST['deviceName'] == 'all') ? '' : $_POST['deviceName'] : '',
            'userName'      => !empty($_POST['userName']) ? ($_POST['userName'] == 'all') ? "" : $_POST['userName'] : '',
            /*'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '',*/
            'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
        );
        $this->log(json_encode($headers), "info");
        $this->log(json_encode($data), "info");
        $result = $this->_model->getDailyUserBackupOverview1($headers,$data,$_POST['url']);
        $this->log(json_encode($result), "info");
        $dailyUserBackupOverview = [];
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'data'}->{'overview'})){
                    foreach($result['body']->{'data'}->{'overview'} as $row){
                        $current['userName'] = $row->{'userName'};
                        $current['deviceName'] = $row->{'deviceName'};
                        $current['storageDate'] = $row->{'storageDate'};
                        $current['storageUsedInPg'] = $row->{'storageUsedInPg'};
                        $current['actualStorageUtilized'] = $row->{'actualStorageUtilized'};
                        $current['storageUsedInCloud'] = $row->{'storageUsedInCloud'};
                        $current['storageUtilized'] = $row->{'storageUtilized'};
                        //$current['totalSizeOfDataInCurrentBackupSet'] = $row->{'totalSizeOfDataInCurrentBackupSet'};
                        $current['totalSizeOfDataInCurrentBackupLatestVersion'] = $row->{'totalSizeOfDataInCurrentBackupLatestVersion'};
                        $current['storageDateReadable'] = date('m/d/y', (((int)$row->{'storageDate'}) / 1000));
                        $current['totalSizeOfBackupFileCompressionRatio'] = $row->{'totalSizeOfBackupFileCompressionRatio'};
                        $current['storageUsedInPgInKB'] = $row->{'storageUsedInPgInKB'};
                        $current['storageUsedInCloudInKB'] = $row->{'storageUsedInCloudInKB'};
                        $current['totalSizeOfDataInCurrentBackupLatestVersionInKB'] = $row->{'totalSizeOfDataInCurrentBackupLatestVersionInKB'};
                        $current['storageUtilizedInKB'] = $row->{'storageUtilizedInKB'};
                        $current['actualStorageUtilizedInKB'] = $row->{'actualStorageUtilizedInKB'};
                        $dailyUserBackupOverview = array_merge(array($current), $dailyUserBackupOverview);
                    }
                }
                if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                $response = array(
                    'result' => 'success',
                    'dailyUserBackupOverview' => $dailyUserBackupOverview,
		    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function downloadDailyUserBackupOverview(){        
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if( $_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
         $_POST['policyName'] = [];
        }
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
	    'productType'   => $_POST['reportProductType']
            /*'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''*/
        );
        $data = array(
            'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
            /*'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '',*/
            'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
        );
        $result = $this->_model->downloadDailyUserBackupOverview($headers,$data);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;
            case (204):
                $response = array(
                    'result' => 'fail',
                    'msg' => 'No records found, Unable to create excel.'
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function deviceUserHistory(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('deviceUserHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/deviceInfo/deviceUserHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDeviceUserHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'deviceName'      => !empty($_POST['deviceName']) ? $_POST['deviceName'] : ''
            );
            $result = $this->_model->getDeviceUserHistory($headers);
            $this->log('result' .json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'deviceUserHistory' => $result['body']->{'userDeviceHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function deviceBackupHistory(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('deviceBackupHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/deviceInfo/deviceBackupHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDeviceBackupHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'deviceName'      => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''
            );
            $result = $this->_model->getDeviceBackupHistory($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'deviceBackupHistory' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function lastBackupByUser(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('lastBackupByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/lastBackup/lastBackupByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function lastBackupByDevice(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('lastBackupByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/lastBackup/lastBackupByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getLastBackupDetails(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json'
            );
            if(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }
            if(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }
            $result = $this->_model->getLastBackupDetails($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'lastBackupDetails' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function alertByDevice(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('alertHistory'),
            'crumb2' => $this->language->get('alertByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/alertHistory/alertByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function alertByUser(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('alertHistory'),
            'crumb2' => $this->language->get('alertByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/alertHistory/alertByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function alertByDate(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('alertHistory'),
            'crumb2' => $this->language->get('alertByDate'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/alertHistory/alertByDate', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAlertHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json'
            );
            if(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }
            if(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }
            if(!empty($_POST['from']) && !empty($_POST['to'])){
                $headers['startDate'] = $_POST['from'];
                $headers['endDate'] = $_POST['to'];
            }
            $result = $this->_model->getAlertHistory($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'alertHistory' => $result['body']->{'alertHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function userMigration(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userMigrationStatus'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userMigration', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUserMigration(){
        if(!empty($_POST)){
            $headers = array(
                    'Content-Type'  => 'application/json',
                    'Accept'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            $result = $this->_model->getUserMigration($headers, $_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'userMigration' => $result['body']->{'data'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getUserMigration1(){
        if(!empty($_POST)){
            $headers = array(
                    'Content-Type'  => 'application/json',
                    'Accept'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
	    $result = $this->_model->getUserMigration1($headers, $_POST['url']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'userMigration' => $result['body']->{'data'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function syncOverview(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('syncCloudUsage'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/sync/syncOverview', $data);
        View::renderTemplate('footer', $data);
    }

    public function getSyncOverview(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            $result = $this->_model->getSyncCLoudUsage($headers);
            $this->log("syncCLoudUsage: ". json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'syncCLoudUsage' => $result['body']->{'syncOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function syncCLoudUsage(){
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('syncCloudOverview'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/sync/syncCloudUsage', $data);
        View::renderTemplate('footer', $data);
    }

    public function getSyncCLoudUsage(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            $result = $this->_model->getSyncCLoudUsage($headers);
            $this->log("syncCLoudUsage: ". json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'syncCLoudUsage' => $result['body']->{'syncOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function downloadDailyUserBackupOverviewExcel(){
        $filePath = OVERVIEW_REPORT_PATH.OVERVIEW_DAILY_USERBACKUP_OVERVIEW;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.OVERVIEW_DAILY_USERBACKUP_OVERVIEW);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }

    public function downloadOverviewReport(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == 'undefined' || $_POST['policyName']==null || $_POST['policyName'] == ['all'] || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
        }
        $data=array(
            'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'userName'      => $_POST['userName'],
            'deviceName'    => $_POST['deviceName'],
            'policyNames'    =>$_POST['policyName'],
	    'isUserWithoutDeviceEnabled' => $_POST['isUserWithoutDeviceEnabled']=='true' ? true : false,
	    'showBlockedUsers' => $_POST['showBlockedUsers']=="true" ? true : false,
	    'showBlockedDevices' => $_POST['showBlockedDevices']=="true" ? true : false,
	    'report' => 'BACKUP_OVERVIEW',
            'productType'=> $_POST['reportProductType'],
            'operationType'=> 'GENERATE_EXCEL'
        );
        $headers = array(
            'Content-Type' => 'application/json',
            'token'        => $this->session->get('token'),
	    'productType'  => $_POST['reportProductType']
        );
        $result = $this->_model->downloadOverViewReport($headers,$data);
        switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                    	'result' => 'fail',
                    	'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadOverViewReportToExcel(){
    $filePath = OVERVIEW_REPORT_PATH.OVERVIEW_REPORT_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.OVERVIEW_REPORT_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }


    public function downloadSyncOverViewReport(){
        $headers = array(
            'Content-Type' => 'application/json',
            'token'         => $this->session->get('token'),
        );
        $result = $this->_model->downloadSyncOverViewReport($headers);
        if($result['status'] == 200){
            $filePath = OVERVIEW_REPORT_PATH.SYNC_OVERVIEW_REPORT_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.SYNC_OVERVIEW_REPORT_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }

    }

    public function downloadOverViewReportSync(){
        $headers = array(
            'Content-Type' => 'application/json',
            'token'         => $this->session->get('token'),
            'endDate'       => date('m/d/Y'),
            'startDate'     => '01/01/1970'
        );
        if(!empty($_GET['fromDate']) && !empty($_GET['toDate'])){
            $headers['endDate'] = $_GET['toDate'];
            $headers['startDate'] = $_GET['fromDate'];
        }else{
            header('Location: '.Url::basePath('report/syncCLoudUsage'.$_GET['from'].'?result=302'));
        }
        $this->log('Headers'. json_encode($headers), 'info');
        $result = $this->_model->downloadOverViewReportSync($headers);
        $this->log('Result'. json_encode($result), 'info');
        if($result['status'] == 200){
            $filePath = OVERVIEW_REPORT_PATH.OVERVIEW_REPORT_NAME_SYNC;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.OVERVIEW_REPORT_NAME_SYNC);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/syncCLoudUsage'.$_GET['from'].'?result=404'));
            }
        }else{
            header('Location: '.Url::basePath('report/syncCLoudUsage'.$_GET['from'].'?result=500'));
        }
    }
    
    public function saveEventHubCurrentBackup(){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'         => $this->session->get('token'),
                'isStopBackup' => $_POST['stopBackup'],
                'isPauseBackup' => $_POST['pauseBackup']
            );
            $eventHubElements = [];
                $data = array(
                    "actionToDeviceUUID" => $_POST['actionToDeviceUUID'],
                    "actions"         	 => $eventHubElements,
                );
                $result = $this->_model->saveEventHubCurrentBackup($headers, $data);
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => "Settings Saved"
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
			                'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (409):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('policyExists')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
    }
    
    public function downloadNobackupReportExcel(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
		'productType'   => $_POST['reportProductType'],
		'system-based' => 'true'
            ); 
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }

            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'ASSETS_NOT_PROTECTED',
                'productType'   => $_POST['reportProductType'],
		'operationType' => 'GENERATE_EXCEL',
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'true'
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->downloadNobackupReportExcel($headers,$data);
            switch ($result['status']) {
                case (200):
		    $this->session->put("tempProductType",$_POST['reportProductType']);	
		    $response = array(
                        'result' => 'success',
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
		case (204):
                    $response = array(
                    	'result' => 'fail',
                    	'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                         );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            }
    }

    public function downloadNobackupToExcel(){
    $filePath = AGENT_NOT_HEARD_PATH.NOBACKUP_REPORT_NAME_EXL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
		//if($this->session->get("tempProductType") == 'ODB' || $this->session->get("tempProductType") == 'Exchange'){
                        header('Content-Disposition: attachment; filename=AssetsNotProtected.xlsx');
                /*}else{
                        header('Content-Disposition: attachment; filename='.NOBACKUP_REPORT_NAME_EXL);
			}*/
                header('Pragma: no-cache');
		$this->session->put("tempProductType",'');
		ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }    

    public function downloadFailedBackupReportExcel(){
	/*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
		'productType'   => $_POST['reportProductType']
                );
            $data =array(
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y'),
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadFailedBackupReportExcel($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function downloadFailedBackupReportToExcel(){
            $filePath = OVERVIEW_REPORT_PATH.FAILED_BACKUP_REPORT_NAME_EXL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.FAILED_BACKUP_REPORT_NAME_EXL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }


    public function downloadRestoreHistoryReportExcel(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
            	'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
		'productType'   => $_POST['reportProductType']
            );
            $data =array(
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y'),
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
		'report'        => 'RESTORE_HISTORY',
                'productType'   => $_POST['reportProductType'],
                'operationType' => 'GENERATE_EXCEL'
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadRestoreHistoryReportExcel($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                    	'result' => 'fail',
                    	'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                    default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function downloadRestoreHistoryReportToExcel(){
        $filePath = OVERVIEW_REPORT_PATH.RESTORE_HISTORY_REPORT_NAME_EXL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.RESTORE_HISTORY_REPORT_NAME_EXL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }

    public function downloadUserBackupHistoryExcel(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' 	=> $this->session->get('token'),
		'productType' 	=> $_POST['reportProductType']
            );
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '' ,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
		"report"        => "BACKUP_HISTORY",
                "productType"   => $_POST['reportProductType'],
                "operationType" => "GENERATE_EXCEL"
            );
            $result = $this->_model->downloadUserBackupHistoryExcel($headers,$data);
            switch ($result['status']) {
                case (200):
                $response = array(
                        'result' => 'success',
                        //'userBackupHistory' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
                    }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }

    public function downloadBackupHistoryReportExcel(){
        $filePath = OVERVIEW_REPORT_PATH.USER_BACKUP_HISTORY_EXL;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.USER_BACKUP_HISTORY_EXL);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }
    
    /*pdf report download start*/
    public function downloadUserBackupHistoryPdf(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' 	=> $this->session->get('token'),
		'productType'	 => $_POST['reportProductType']
            );
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '' ,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
		"report"        => "BACKUP_HISTORY",
                "productType"   => $_POST['reportProductType'],
                "operationType" => "GENERATE_PDF"
            );
            $result = $this->_model->downloadUserBackupHistoryPdf($headers,$data);
            switch ($result['status']) {
                case (200):
                $response = array(
                        'result' => 'success',
                        //'userBackupHistory' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }

    public function downloadBackupHistoryReportPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.USER_BACKUP_HISTORY_PDF;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.USER_BACKUP_HISTORY_PDF);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }
    
    public function downloadOverviewReportPdf(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == 'undefined' || $_POST['policyName']==null || $_POST['policyName'] == ['all'] || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
        }
        $data=array(
            'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'userName'      => $_POST['userName'],
            'deviceName'    => $_POST['deviceName'],
            'policyNames'    =>$_POST['policyName'],
            'isUserWithoutDeviceEnabled' => $_POST['isUserWithoutDeviceEnabled']=='true' ? true : false,
	    'showBlockedUsers' => $_POST['showBlockedUsers']=="true" ? true : false,
	    'showBlockedDevices' => $_POST['showBlockedDevices']=="true" ? true : false,
	    'report' => 'BACKUP_OVERVIEW',
            'productType'=> $_POST['reportProductType'],
            'operationType'=> 'GENERATE_PDF'
        );
        $headers = array(
            'Content-Type' => 'application/json',
            'token'        => $this->session->get('token'),
	    'productType'  => $_POST['reportProductType']
        );
        $result = $this->_model->downloadOverViewReportPdf($headers,$data);
        switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success'
                        );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                    	'result' => 'fail',
                    	'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadOverViewReportToPdf(){
    $filePath = AGENT_NOT_HEARD_PATH.OVERVIEW_REPORT_NAME_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.OVERVIEW_REPORT_NAME_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                    header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }

    public function downloadFailedBackupReportPdf(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
		'productType'   => $_POST['reportProductType']
                );
            $data =array(
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y'),
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadFailedBackupReportPdf($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                        );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                    default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadFailedBackupReportToPdf(){
    $filePath = AGENT_NOT_HEARD_PATH.FAILED_BACKUP_REPORT_NAME_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.FAILED_BACKUP_REPORT_NAME_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }
    
    public function downloadNobackupReportPdf(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
		'productType'   => $_POST['reportProductType'],
		'system-based' => 'true'
            ); 
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'ASSETS_NOT_PROTECTED',
                'productType'   => $_POST['reportProductType'],
		'operationType' => 'GENERATE_PDF',
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'true'
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->downloadNobackupReportPdf($headers,$data);
            switch ($result['status']) {
                case (200):
		    $this->session->put("tempProductType",$_POST['reportProductType']);	
		    $response = array(
                        'result' => 'success',
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                     echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                         );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            }
    }

    public function downloadNobackupToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.NOBACKUP_REPORT_NAME_PDF;
            if(file_exists($filePath)){
		header('Content-Type: application/csv');
		//if($this->session->get("tempProductType") == 'ODB' || $this->session->get("tempProductType") == 'Exchange'){
                        header('Content-Disposition: attachment; filename=AssetsNotProtected.pdf');
                /*}else{
                	header('Content-Disposition: attachment; filename='.NOBACKUP_REPORT_NAME_PDF);
			}*/
		header('Pragma: no-cache');
		$this->session->put("tempProductType",'');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }
    
    public function downloadRestoreHistoryReportPdf(){
	    /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
		'productType'   => $_POST['reportProductType']
            );
            $data =array(
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y'),
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
		'report'        => 'RESTORE_HISTORY',
                'productType'   => $_POST['reportProductType'],
                'operationType' => 'GENERATE_PDF'
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadRestoreHistoryReportPdf($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                    	'result' => 'fail',
                    	'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadRestoreHistoryReportToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.RESTORE_HISTORY_REPORT_NAME_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.RESTORE_HISTORY_REPORT_NAME_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }
    
    public function downloadDailyUserBackupOverviewPdf(){        
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
                 $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if( $_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
         $_POST['policyName'] = [];
        }
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
	    'productType'   => $_POST['reportProductType']
            /*'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''*/
        );
        $data = array(
            'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
            /*'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '',*/
            'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []
        );
        $result = $this->_model->downloadDailyUserBackupOverviewPdf($headers,$data);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;
            case (204):
                $response = array(
                    'result' => 'fail',
                    'msg' => 'No records found, Unable to create Pdf.'
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                 exit();
        }
    }

    public function downloadDailyUserBackupOverviewToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.OVERVIEW_DAILY_USERBACKUP_OVERVIEW_PDF;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.OVERVIEW_DAILY_USERBACKUP_OVERVIEW_PDF);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }
    
    public function downloadAgentNotHeardReportPdf(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
	    'productType'   => $_POST['reportProductType']
        );
        if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
        	$_POST['policyName'] = [];
        }
        if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }
        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        $data = array(
                'noOfDays' => $_POST['number'],
		'policyNames'  => $_POST['policyName'],
		'productType' => $_POST['reportProductType']
            );
        $this->log("HEADERS".json_encode($headers),"info");
        $this->log("DATA".json_encode($data),"info");
        $result = $this->_model->downloadAgentNotHeardReportPdf($headers, $data);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('204')
                );
                echo json_encode($result);
                exit();
	    case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                     );
                    echo json_encode($response);
                    exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function downloadAgentNotHeardReportToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.AGENT_NOT_HEARD_OVERVIEW_PDF;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
	    //header('Content-Disposition: attachment; filename='.AGENT_NOT_HEARD_OVERVIEW_PDF);
	    header('Content-Disposition: attachment; filename=Asset_Heartbeat_Report.pdf');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }
    
    public function downloadUserBackupSummaryReportPdf(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
	    'productType'   => $_POST['reportProductType'],
        );
	if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
        $_POST['policyName'] = [];
	}
	if(isset($_POST['includeDetails']) && $_POST['includeDetails']=='true'){
             $_POST['includeDetails'] = true;
        }else{
                $_POST['includeDetails'] = false;
        }
        $data = array(
                'noOfDays' => $_POST['number'],
                'policyNames'  => $_POST['policyName'],
		'includeDetails' => $_POST['includeDetails'],
		"report" => "DATA_PROTECTION_SCORECARD",
                "productType"=> $_POST['reportProductType'],
                "operationType"=> "GENERATE_PDF"
            );
        $this->log("HEADERS".json_encode($headers),"info");
        $this->log("DATA".json_encode($data),"info");
        $result = $this->_model->downloadUserBackupSummaryReportPdf($headers, $data);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                    );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('204')
                );
                echo json_encode($result);
		exit();
	    case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
                case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                    );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function downloadUserBackupSummaryReportToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.USER_BACKUP_SUMMARY_PDF;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.USER_BACKUP_SUMMARY_PDF);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }
    /*pdf report download end*/
    
    /*report usersWithoutDevicesView start*/
   public function usersWithoutDevices($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $backupPolicies=[];
        if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        }
        $odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
	}
	if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('usersWithoutDevices'),
            'active' => 'report',
            'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
            'backupPolicies' => array_reverse($backupPolicies),
            'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/usersWithoutDevices', $data);
        View::renderTemplate('footer', $data);
    }

    public function usersWithoutDevicesView(){
        if(!empty($_POST)){
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = '';
            }else{
            	$_POST['policyName'] = implode(',', $_POST['policyName']);
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyNames'   => $_POST['policyName'],
		'productType'   => $_POST['productTypeReport'],
                'showBlockedDevices' => $_POST['showBlockedDevices']
	    );
	    $data = [];
            $result = $this->_model->usersWithoutDevicesView($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
                    if(!empty($result['body']->{'metadata'})){
                    	$metadata = $result['body']->{'metadata'};
                    	$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                    	$metadata = [];
                    }
                    $users = array();
		    if(!empty($result['body']->{'data'}->{'users'})){
			    foreach($result['body']->{'data'}->{'users'} as $value){
				$user = array(
				    'emailId'          => (string)$value->{'emailId'},
				    'userName'         => (string)$value->{'userName'},
				    'displayName'         => !empty($value->{'displayName'}) ? (string)$value->{'displayName'} : '',
				    'timeinmillis'     => !empty($value->{'lastModifiedTimestamp'}) ? (int)($value->{'lastModifiedTimestamp'}) : '-',
                                    'time'             => !empty($value->{'lastModifiedTimestamp'}) ? date('d-M-Y H:i:s',(int)($value->{'lastModifiedTimestamp'})/1000) : '-',
				    );
				$users = array_merge(array($user), $users);
			    }
		    }
                    $response = array(
                        'result' => 'success',
                        'usersWithoutDevices' => $users,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }

    public function usersWithoutDevicesView1(){
            if(!empty($_POST)){
                if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            		$_POST['policyName'] = '';
            	}else{
            		$_POST['policyName'] = implode(',', $_POST['policyName']);
            	}
            $headers = array(
                'token' => $this->session->get('token'),
                'Content-type' => 'application/json',
                'Accept' => 'application/json',
                'policyNames'   => $_POST['policyName'],
		'productType'   => $_POST['productTypeReport'],
                'showBlockedDevices' => $_POST['showBlockedDevices']
	    );
	    $data = [];
            $result = $this->_model->usersWithoutDevicesView1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
                    if(!empty($result['body']->{'metadata'})){
			    $metadata = $result['body']->{'metadata'};
			    $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                    	$metadata = [];
                    }
                    $users = array();
		    if(!empty($result['body']->{'data'}->{'users'})){
			    foreach($result['body']->{'data'}->{'users'} as $value){
				$user = array(
				    'emailId'          => (string)$value->{'emailId'},
				    'userName'         => (string)$value->{'userName'},
				    'displayName'         => !empty($value->{'displayName'}) ? (string)$value->{'displayName'} : '',
				    'timeinmillis'     => !empty($value->{'lastModifiedTimestamp'}) ? (int)($value->{'lastModifiedTimestamp'}) : '-',
                                    'time'             => !empty($value->{'lastModifiedTimestamp'}) ? date('d-M-Y H:i:s',(int)($value->{'lastModifiedTimestamp'})/1000) : '-',
				);
				$users = array_merge(array($user), $users);
			    }
		    }
                    $response = array(
                        'result' => 'success',
                        'usersWithoutDevices' => $users,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }

    public function downloadUsersWithoutDevices(){
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = '';
            }else{
            	$_POST['policyName'] = implode(',', $_POST['policyName']);
            }
        $headers = array(
            'Content-Type' => 'application/json',
            'token'     => $this->session->get('token'),
            'policyNames'   => $_POST['policyName'],
	    'productType'   => $_POST['productTypeReport'],
            'showBlockedDevices' => $_POST['showBlockedDevices']
        );
        $result = $this->_model->downloadUsersWithoutDevices($headers);
        switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                     );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                     );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadUsersWithoutDevicesExcel(){
        $filePath = AGENT_NOT_HEARD_PATH.USER_EXCEL_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.USER_EXCEL_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('users/'.$_GET['from'].'?result=404'));
            }
    }
    /*report usersWithoutDevicesView end*/
    
    /*report schedule start*/
    public function getSchedule(){
            $this->log("jjjjjj inside","info");
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'id' => $_POST['id']
            );
            $schedulerName  = '';
            $result = $this->_model->getScheduleReport($headers,$schedulerName);
            $days = (array)explode(',', $result['body']->{'reportSchedulerElementList'}[0]->{'days'});
	    $result['body']->{'reportSchedulerElementList'}[0]->{'allAdmins'} = $result['body']->{'reportSchedulerElementList'}[0]->{'allAdmins'} ? 'true' : 'false';
            $this->log("DAYS : ".json_encode($days),"info");
            switch ($result['status']) {
                case (200):
                $response = array(
                        'result' => 'success',
                        'schedulerData' => $result['body']->{'reportSchedulerElementList'}[0],
                        'days' => $days
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
                    }
    }

    public function saveScheduleReport(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token')
            );
            if(!empty($_POST['days'])){
                $_POST['days'] = implode(',', $_POST['days']);
            }	    
            if(!isset($_POST['months']) || $_POST['months'] == null){
            	$_POST['months'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
            if(!isset($_POST['policyName']) || $_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all'] || $_POST['policyName'] == ''){
        	$_POST['policyName'] = [];
            }
            if($_POST['endDate'] != '' && $_POST['startDate'] != ''){
		if(strtotime($_POST['endDate']) < strtotime($_POST['startDate'])){
			$data = array(
			    'result' => 'fail',
			    'msg' => 'To Date should be greater than From Date'
			);
			$jsonData = json_encode($data);
			echo $jsonData;
			exit;
		}
	}
	if($_POST['mailid'] == 'all admins' || $_POST['mailid'] == 'All admins'){
                $allowAllAdmins = true;
        }else{
                $allowAllAdmins = false;
        }
	if($_POST['miniCloudList'] == ['all'] || $_POST['miniCloudList'] == null || $_POST['miniCloudList'] == 'all'){
                $_POST['miniCloudList'] = [];
	}	
	$_POST['miniCloudList'] = implode(', ', $_POST['miniCloudList']);
	if(!empty($_POST['isUserWithoutDeviceEnabled'])){
                if($_POST['isUserWithoutDeviceEnabled'] == 'true'){
                        $_POST['isUserWithoutDeviceEnabled'] = true;
                }else{
                        $_POST['isUserWithoutDeviceEnabled'] = false;
                }
        }else{
                $_POST['isUserWithoutDeviceEnabled'] = false;
        }
        if(!empty($_POST['showBlockedUsers'])){
                if($_POST['showBlockedUsers'] == 'true'){
                        $_POST['showBlockedUsers'] = true;
                }else{
                        $_POST['showBlockedUsers'] = false;
                }
        }else{
                $_POST['showBlockedUsers'] = false;
        }
        if(!empty($_POST['showBlockedDevices'])){
                if($_POST['showBlockedDevices'] == 'true'){
                        $_POST['showBlockedDevices'] = true;
                }else{
                        $_POST['showBlockedDevices'] = false;
                }
        }else{
                $_POST['showBlockedDevices'] = false;
        }
	if(!empty($_POST['includeDetails'])){
                if($_POST['includeDetails'] == 'true'){
                        $_POST['includeDetails'] = true;
                }else{
                        $_POST['includeDetails'] = false;
                }
        }else{
                $_POST['includeDetails'] = false;
        }
        $this->log("DATA : ".json_encode($_POST['userName']),"info");
        $this->log("DATA : ".json_encode($_POST['deviceName']),"info");
        $data = array(
                'id' => !empty($_POST['id']) ? $_POST['id'] : '',
                'schedulerName'  => $_POST['trigger'],
                'displayName' => $_POST['scheduleName'],
                'time'    => $_POST['time'],
                'date' => $_POST['date'],
                'days'      => $_POST['days'],
                'emailIds'     => explode(',', $_POST['mailid']),
                'deviceName'      => !empty($_POST['deviceName']) ? ($_POST['deviceName'] == 'all') ? '' : $_POST['deviceName'] : '',
                'userName'      => !empty($_POST['userName']) ? ($_POST['userName'] == 'all') ? "" : $_POST['userName'] : '',
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
                'months'    => $_POST['months'],
                'dayOfMonth' => $_POST['dayOfMonth'],
                'noOfDays' => $_POST['noOfDays'],
                'userWithoutDeviceEnabled' => $_POST['isUserWithoutDeviceEnabled'],
                'showBlockedUsers' => $_POST['showBlockedUsers'],
                'showBlockedDevices' => $_POST['showBlockedDevices'],
		'includeDetails' => $_POST['includeDetails'],
                'endDate'       => $_POST['endDate'],
                'startDate'     => $_POST['startDate'],
		'allAdmins'     => $allowAllAdmins,
		'createdBy'     => $_POST['createdBy'],
		'reason'        => $_POST['reason'],
                'productType'   => !empty($_POST['productType']) ? $_POST['productType'] : 'sync',
		'systemsProtected'  => $_POST['systemBased'],
		'miniCloudList' => $_POST['miniCloudList'] =='all' ? '' : $_POST['miniCloudList'],
	);
	    $schedulerName = $_POST['trigger'];
            $this->log("DATA : ".json_encode($data),"info");
            $result = $this->_model->saveScheduleReport($headers,$data,$schedulerName);
            switch ($result['status']) {
                case (200):
                $response = array(
                        'result' => 'success',
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
		case (403):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Schedule with same name already exists'
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
                    }
    }
	
    public function usersMailId(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'        => 'application/json',
                'token'             => $this->session->get('token')
            );
            $result = $this->_model->usersMailId($headers);
            $this->log("usersMailId : ".json_encode($result['body']->{'userElementResponse'}->{'users'}),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'users'    => $result['body']->{'userElementResponse'}->{'users'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function getSchedules(){
            $this->log("jjjjjjbb inside : ".$_POST['trigger'],"info");
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token')
            );
            $schedulerName  = $_POST['trigger'];
            $result = $this->_model->getScheduleReport($headers,$schedulerName);
            $schedules = [];
            switch ($result['status']) {
            case (200):
            if(!empty($result['body']->{'reportSchedulerElementList'})){
		    foreach($result['body']->{'reportSchedulerElementList'} as $value){
			    if($value->{'productType'} == 'Sharepoint'){
                                $value->{'productType'} = 'sharepoint';
                            }
                            if($value->{'productType'} == 'ODB'){
                                $value->{'productType'} = 'onedrive';
			    }
			    if($value->{'productType'} == 'Exchange'){
                                $value->{'productType'} = 'exchange';
			    }
			    if($value->{'productType'} == 'backup'){
                                $value->{'productType'} = 'backup';
			    }			    
                	$schedule = array(
                        	'id' => (string)$value->{'id'},
                        	'schedulerName' => (string)$value->{'schedulerName'},
                                'time' => (string)$value->{'time'},
                                'scheduleName' => (string)$value->{'displayName'},
                                'days' => (array)$value->{'days'},
                                'date' => (string)$value->{'date'},
                                'emailIds' => implode(',', (array)$value->{'emailIds'}),
                                'months' => (array)$value->{'months'},
                                'dayOfMonth' => (string)$value->{'dayOfMonth'},
				'allAdmins' => $value->{'allAdmins'} ? 'true' : 'false',
				'systemsProtected' => $value->{'systemsProtected'} ? 'true' : 'false',
				'productType' => $value->{'productType'}
                            );
                            $schedules = array_merge(array($schedule), $schedules);
                    }
            }
                $response = array(
                        'result' => 'success',
                        'schedules' => $schedules,
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
                    }
    }

    public function deleteSchedule(){
        $this->log("jjjjjj inside","info");
            $headers = array(
                'Content-Type'  	=> 'application/json',
                'token' 		=> $this->session->get('token'),
                'id' 			=> $_POST['id'],
		'schedulerName'    	=> $_POST['scheduleName']
            );
	    $schedulerName = $_POST['scheduleName'];
            $result = $this->_model->deleteSchedule($headers,$schedulerName);
            switch ($result['status']) {
                case (200):
                $response = array(
                        'result' => 'success',
                        'msg' => 'Schedule deleted successfully'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    /*report schedule end*/
	
    public function saveBulkEventHubCurrentBackup(){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'         => $this->session->get('token'),
                'isStopBackup' => $_POST['stopBackup'],
                'isPauseBackup' => $_POST['pauseBackup']
            );
            $eventHubElements = [];
                $data = array(
                    "actionToDeviceUUIDs" => $_POST['actionToDeviceUUID'],
                    "actions"         	 => $eventHubElements,
                );
                $result = $this->_model->saveEventHubCurrentBackup($headers, $data);
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => "Settings Saved"
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
			                'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (409):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('policyExists')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
    }


    public function stopBulkRestore(){
                $_POST['actionToDeviceUUID'] = implode(',', $_POST['actionToDeviceUUID']);
                $headers = array(
                	'Content-Type' => 'application/json',
                	'token'         => $this->session->get('token'),
 			"deviceUUIDs"   => $_POST['actionToDeviceUUID']
            	);
                $result = $this->_model->stopRestore($headers);
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => "Settings Saved"
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
			    'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (409):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('policyExists')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
			);
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
    }

    public function stopRestore(){
                $headers = array(
            	    'Content-Type' => 'application/json',
            	    'token'         => $this->session->get('token'),
		    'deviceUUIDs' => $_POST['actionToDeviceUUID'],
		    'batchId'	=> $_POST['batchId']
                );
                $result = $this->_model->stopRestore($headers);
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => "Settings Saved"
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
			    'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (409):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('policyExists')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
    }	
	
    public function viewRestoreProgress(){
            $headers = array(
                    'token'     => $this->session->get('token'),
                    'Accept' => 'application/json',
		    'loginUserName' => $this->session->get('userName'),
		    'batchId' => $_POST['batchId']
            );
            $result = $this->_model->viewRestoreProgress($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'progress'  => $result['body']->{'restoreProgressEventsElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "No Restore in Queue"
                    );
                    echo json_encode($result);
                    exit();
		case (202):
                    $result = array(
                        'result' => 'restore_completed',
                        'msg' => "Restore completed successfully"
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
		    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function viewRestoreProgressEndpoint(){
            $headers = array(
                    'token'     => $this->session->get('token'),
                    'Accept' => 'application/json',
		    'loginUserName' => $this->session->get('userName'),
		    'batchId' => $_POST['batchId']
            );
            $result = $this->_model->viewRestoreProgressEndpoint($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'progress'  => $result['body']->{'restoreProgressEventsElement'}
                    );
                    echo json_encode($response);
                    exit;
		case (206):
                    $result = array(
                        'result' => 'restore_in_queue',
                        'progress'  => $result['body']->{'restoreProgressEventsElement'}
                    );
                    echo json_encode($result);
                    exit();
                case (204):
                    $result = array(
                        'result' => 'restore_no',
                        'msg' => "Restore completed successfully"
                    );
                    echo json_encode($result);
                    exit();
		case (202):
                    $result = array(
                        'result' => 'restore_completed',
                        'msg' => "Restore completed successfully"
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                        $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
		    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function changePasswordForFirstlogin(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'userName' => $this->session->get('userName'),
                'password' => hash('sha512', $_POST['password']),
            );
            $this->log("PASSWORD => ".$_POST['password'],"info");
            $result = $this->_model->changePasswordForFirstlogin($headers);
            switch ($result['status']) {
                case (200):
		    $this->session->put('firstLogin1','false');
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
		    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
/*users with no backup report start*/
    public function usersNoBackup($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        Auth::allowOnly('readOnlyAdmin');
	$backupPolicies=[];
	if($reportProductType == 'backup'){
        	$backupResult=$this->_model->getAllPolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
		if(!empty($backupResult['body']->{'stringList'})){
			foreach((array)$backupResult['body']->{'stringList'} as $value){
            			$policy = $value;
            			$backupPolicies = array_merge(array($policy), $backupPolicies);
			}
		}
	}
	$odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
        if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
                foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
        }
        if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Users without any systems protected',
            'active' => 'report',
            'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
	    'backupPolicies' => array_reverse($backupPolicies),
	    'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/usersNoBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUsersNoBackup(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType'],
                'system-based' => 'false'
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'ASSETS_NOT_PROTECTED',
                'productType'   => $_POST['reportProductType'],
		'operationType' => 'GENERATE_VIEW',
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'false'
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getUsersNoBackupDetails($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
                if(!empty($result['body']->{'data'}->{'backupHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupHistoryElement'} as $value){
                        $value->{'noOfDaysNotBackedUp'} = intval($value->{'noOfDaysNotBackedUp'});
            	    }
                }
                if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'backupHistoryElement'}) ? $result['body']->{'data'}->{'backupHistoryElement'} : [],
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('204')
                    );
                    echo json_encode($result);
		    exit();
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
		case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getUsersNoBackup1(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType'],
                'system-based' => 'false'
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
 	    if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'ASSETS_NOT_PROTECTED',
                'productType'   => $_POST['reportProductType'],
		'operationType' => 'GENERATE_VIEW',
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'false'
                );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getUsersNoBackupDetails1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
                if(!empty($result['body']->{'data'}->{'backupHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupHistoryElement'} as $value){
                        $value->{'noOfDaysNotBackedUp'} = intval($value->{'noOfDaysNotBackedUp'});
                        $value->{'lastHeardTime'} = intval($value->{'lastHeardTime'});
                    }
                }
		if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                $response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'backupHistoryElement'}) ? $result['body']->{'data'}->{'backupHistoryElement'} : [],
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('204')
                    );
                    echo json_encode($result);
		    exit();
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function downloadUsersNobackupReportExcel(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'productType'   => $_POST['reportProductType'],
                'system-based' => 'false'
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'ASSETS_NOT_PROTECTED',
                'productType'   => $_POST['reportProductType'],
		'operationType' => 'GENERATE_EXCEL',
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'false'
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->downloadUsersNobackupReportExcel($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
			'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                         );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            }
    }

    public function downloadUsersNobackupToExcel(){
    	$filePath = AGENT_NOT_HEARD_PATH.USERS_NOBACKUP_REPORT_NAME_EXL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.USERS_NOBACKUP_REPORT_NAME_EXL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }

    public function downloadUsersNobackupReportPdf(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'productType'   => $_POST['reportProductType'],
                'system-based' => 'false'
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            	$_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
            	$_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            	$_POST['deviceName'] = '';
            }
	    if($_POST['includeDevicesHeardFrom'] == 'false'){
                $_POST['daysToIncludeDevicesHeardFrom'] = 0;
            }
            $data = array(
                'noOfDays'      => $_POST['numberOfDays'],
		'daysToIncludeDevicesHeardFrom'      => $_POST['daysToIncludeDevicesHeardFrom'],
                'includeDevicesHeardFrom' => $_POST['includeDevicesHeardFrom'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
		'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] :[],
		'report'        => 'ASSETS_NOT_PROTECTED',
                'productType'   => $_POST['reportProductType'],
		'operationType' => 'GENERATE_PDF',
		'productType' => $_POST['reportProductType'],
                'systemBased' => 'false'
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->downloadUsersNobackupReportPdf($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                    );
                    echo json_encode($response);
		    exit;
		case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                    $response = array(
			'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                     echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                         );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
		echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            }
    }

    public function downloadUsersNobackupToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.USERS_NOBACKUP_REPORT_NAME_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.USERS_NOBACKUP_REPORT_NAME_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }
/*users with no backup report start*/
	
/*miniclouds reporting starts*/	
    public function minicloudActivity(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        Auth::allowOnly('readOnlyAdmin');        
        $miniClouds = $this->_model->getAllMiniClouds(array('token' => $this->session->get('token')));
	$mini = [];
	if(!empty($miniClouds['body']->{'mini-cloud'})){
        	foreach($miniClouds['body']->{'mini-cloud'} as $key => $value){
                	$mini = array_merge(array($value), $mini);
		}
	}
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('minicloudHistory'),
            'active' => 'report',
            'mini' => $mini,          
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserRole'=>$this->session->get('readOnlyAdmin'),                        
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/sync/minicloudActivity', $data);
        View::renderTemplate('footer', $data);
    }

    public function getMinicloudActivityHistory(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
        }
        if($_POST['minicloudName'] == ['all'] || $_POST['minicloudName'] == null || $_POST['minicloudName'] == 'all'){
            $_POST['minicloudName'] = [];
        }
        $_POST['minicloudName'] = implode(', ', $_POST['minicloudName']);
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
            'minicloudName' => $_POST['minicloudName'] =='all' ? '' : $_POST['minicloudName'],
            'fromDate' 	    => $_POST['from'],
            'toDate'        => $_POST['to']
        );
        $result = $this->_model->getMinicloudActivityHistory($headers, $_POST['pageNumber']);
        switch ($result['status']) {
            case (200):
                $audits = [];
                $metadata = [];
                if(!empty($result['body']->{'data'}->{'audits'})){
                    foreach($result['body']->{'data'}->{'audits'} as $value){
                        if(strpos(strtolower((string)$value->{'action'}), 'deleted') !== false || strpos(strtolower((string)$value->{'action'}), 'decoupled') !== false){
                            $color = 'info';
                        }elseif(strpos(strtolower((string)$value->{'action'}), 'migration') !== false){
                            $color = 'indigo';
                        }elseif(strpos(strtolower((string)$value->{'action'}), 'logged') !== false){
                            $color = 'deeporange';
                        }else{
                            $color = 'lime';
                        }
                        $audit = array(
                            'action' => !empty($value->{'action'}) ? (string)$value->{'action'} : '',
                            'actionByUser' => !empty($value->{'actionByUserName'}) ? (string)$value->{'actionByUserName'} : '',
                            'actionOnObject' => !empty($value->{'actionOnObject'}) ? (string)$value->{'actionOnObject'} : '',
                            'actionUsingObject' =>!empty($value->{'actionUsingObject'}) ? (string)$value->{'actionUsingObject'} : '',
                            'additionalInfo' => !empty($value->{'additionalInfo'}) ? (string)$value->{'additionalInfo'} : '',
                            'auditId' => !empty($value->{'audit-id'}) ? (string)$value->{'audit-id'} : '',
                            'folder' => !empty($value->{'folder'}) ? (string)$value->{'folder'} : '',
                            'timestampInLong' => !empty($value->{'timestampInLong'}) ? (int)$value->{'timestampInLong'} : '',
                            'time' => !empty($value->{'timestampInLong'}) ? date('d-M-y H:i:s', (((int)$value->{'timestampInLong'}) / 1000)) : '',
                            'color' => $color
                        );
                        $audits = array_merge(array($audit), $audits);
                    }
                }
                if(!empty($result['body']->{'metadata'})){
                	$metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits),
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                	'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getMinicloudActivityHistory1(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
        }
        if($_POST['minicloudName'] == ['all'] || $_POST['minicloudName'] == null || $_POST['minicloudName'] == 'all'){
            $_POST['minicloudName'] = [];
        }
        $_POST['minicloudName'] = implode(', ', $_POST['minicloudName']);
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
            'minicloudName' => $_POST['minicloudName'] =='all' ? '' : $_POST['minicloudName'],
            'fromDate' 	    => $_POST['from'],
            'toDate' 	    => $_POST['to']
        );
        $result = $this->_model->getMinicloudActivityHistory1($headers, $_POST['url']);       
        switch ($result['status']) {
            case (200):
                $audits = [];
                $metadata = [];
                if(!empty($result['body']->{'data'}->{'audits'})){
                    foreach($result['body']->{'data'}->{'audits'} as $value){
                        if(strpos(strtolower((string)$value->{'action'}), 'deleted') !== false || strpos(strtolower((string)$value->{'action'}), 'decoupled') !== false){
                            $color = 'info';
                        }elseif(strpos(strtolower((string)$value->{'action'}), 'migration') !== false){
                            $color = 'indigo';
                        }elseif(strpos(strtolower((string)$value->{'action'}), 'logged') !== false){
                            $color = 'deeporange';
                        }else{
                            $color = 'lime';
                        }
                        $audit = array(
                            'action' => !empty($value->{'action'}) ? (string)$value->{'action'} : '',
                            'actionByUser' => !empty($value->{'actionByUserName'}) ? (string)$value->{'actionByUserName'} : '',
                            'actionOnObject' => !empty($value->{'actionOnObject'}) ? (string)$value->{'actionOnObject'} : '',
                            'actionUsingObject' =>!empty($value->{'actionUsingObject'}) ? (string)$value->{'actionUsingObject'} : '',
                            'additionalInfo' => !empty($value->{'additionalInfo'}) ? (string)$value->{'additionalInfo'} : '',
                            'auditId' => !empty($value->{'audit-id'}) ? (string)$value->{'audit-id'} : '',
                            'folder' => !empty($value->{'folder'}) ? (string)$value->{'folder'} : '',
                            'timestampInLong' => !empty($value->{'timestampInLong'}) ? (int)$value->{'timestampInLong'} : '',
                            'time' => !empty($value->{'timestampInLong'}) ? date('d-M-y H:i:s', (((int)$value->{'timestampInLong'}) / 1000)) : '',
                            'color' => $color
                        );

                        $audits = array_merge(array($audit), $audits);
                    }
                }
                if(!empty($result['body']->{'metadata'})){
                    $metadata = $result['body']->{'metadata'};
                    $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                    $metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits),
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function minicloudActivityExcel(){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['minicloudName'] == ['all'] || $_POST['minicloudName'] == null || $_POST['minicloudName'] == 'all'){
            	$_POST['minicloudName'] = [];
            }
            $_POST['minicloudName'] = implode(', ', $_POST['minicloudName']);
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'minicloudName' => $_POST['minicloudName'] =='all' ? '' : $_POST['minicloudName'],
                'fromDate' 	=> $_POST['from'],
                'toDate' 	=> $_POST['to']
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->minicloudActivityExcel($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadMinicloudActivityToExcel(){
        $filePath = AGENT_NOT_HEARD_PATH.MINICLOUD_ACTIVITY_EXCEL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.MINICLOUD_ACTIVITY_EXCEL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }

    public function minicloudActivityPdf(){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['minicloudName'] == ['all'] || $_POST['minicloudName'] == null || $_POST['minicloudName'] == 'all'){
                $_POST['minicloudName'] = [];
            }
            $_POST['minicloudName'] = implode(', ', $_POST['minicloudName']);
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'minicloudName' => $_POST['minicloudName'] =='all' ? '' : $_POST['minicloudName'],
                'fromDate' 	=> $_POST['from'],
                'toDate' 	=> $_POST['to']
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->minicloudActivityPdf($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                    case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadMinicloudActivityToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.MINICLOUD_ACTIVITY_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.MINICLOUD_ACTIVITY_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }	
/*miniclouds reporting ends*/

    public function productOverview($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        Auth::allowOnly('readOnlyAdmin');
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
	}
	$backupPolicies = [];
	$officePolicies = [];
	//$syncPolicies = [];
	if(Auth::checkCloudPermission('backup')){
		$backupResult = $this->_model->getAllPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true', 'productType'=>$reportProductType));	
		foreach((array)$backupResult['body']->{'stringList'} as $value){
		    $policy = $value;
		    $backupPolicies = array_merge(array($policy), $backupPolicies);
		}
	}
	if(Auth::checkCloudPermission('office365')){
	$officeResult = $this->_model->getAllPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true', 'productType'=>'office'));
		foreach((array)$officeResult['body']->{'stringList'} as $value){
		    $policy = $value;
		    $officePolicies = array_merge(array($policy), $officePolicies);
		}
	}
	/*if(Auth::checkCloudPermission('sync')){
	$syncResult = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true'));
		foreach((array)$syncResult['body']->{'stringList'} as $value){
		    $policy = $value;
		    $syncPolicies = array_merge(array($policy), $syncPolicies);
		}
	}*/
	$policiesFinal = array_merge($backupPolicies, $officePolicies);
	//$this->log("POLICIES1 : ".json_encode($backupPolicies1),"info");
	//$this->log("POLICIES_SYNC : ".json_encode($syncPolicies),"info");
	//$this->log("POLICIES_FINAL : ".json_encode($backupPoliciesFinal),"info");*/
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('Product Overview'),
            'active' => 'report',
            'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserRole'=>$this->session->get('readOnlyAdmin'),
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'backupPolicies'=>array_reverse($policiesFinal),
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/overview/productOverview', $data);
        View::renderTemplate('footer', $data);
    }

    public function getProductOverview(){
        if(!empty($_POST)){
            $headers = array(
		    'token'         => $this->session->get('token'),
		    'Content-Type'  => 'application/json',
	);

	if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
        }

        if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
        }
        if($_POST['policyName'] == ['all'] || $_POST['policyName'] == null || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
	}
	$data=array(            
            'userName'      => '',
            'deviceName'    => '',
            'policyNames'    => $_POST['policyName']=='all' ? []:$_POST['policyName'],
            'isUserWithoutDeviceEnabled' => true,
            'showBlockedUsers' => true,
	    'showBlockedDevices' => true,
	    'noOfDays' => $_POST['numberOfDays'],
        );
            $result = $this->_model->getProductOverview($headers, $data);
            switch ($result['status']) {
                case (200):
			$result['body']->{'productOverviewElement'}->{'licenseElement'}->{'validityPeriod'} = date('d-M-Y', (((int)$result['body']->{'productOverviewElement'}->{'licenseElement'}->{'validityPeriod'}) / 1000));
			$result['body']->{'productOverviewElement'}->{'licenseElement'}->{'blockedUsers'} = (int)($result['body']->{'productOverviewElement'}->{'licenseElement'}->{'totalUsers'} - $result['body']->{'productOverviewElement'}->{'licenseElement'}->{'totalActiveUsers'});			
		    $overviewList = [];
                    if(!empty($result['body']->{'productOverviewElement'}->{'backupOverviewElementList'})){
			foreach($result['body']->{'productOverviewElement'}->{'backupOverviewElementList'} as $value){
                    		$filesBackedUp = intval($value->{'totalNoOfFiles'}) - intval($value->{'noOfFilesRemaining'});
                    		$completedPercentage = ($value->{'totalNoOfFiles'} > 0 ) ? round(($filesBackedUp / $value->{'totalNoOfFiles'}) * 100).'%' : '0 %';
                    		if($value->{'lastBkpStatus'} != 'STARTED' && $value->{'lastBkpStatus'} != 'COMPLETED'){
                            		$reason = $value->{'reason'};
                     		}elseif($value->{'lastBkpStatus'} == 'STARTED' || $value->{'lastBkpStatus'} == 'COMPLETED') {
                            		$reason = '-';
                     		}                     
			    if($value->{'deviceName'} != ''){
				if($value->{'deviceActive'} == "1"){
				    if($value->{'decoupled'} == "1"){
					$value->{'deviceActive'} = "Decoupled";
					$devAct = "Decoupled";
				    }else{
					$value->{"deviceActive"} = "Active";
					$devAct = "Active";
				    }
				}
				else{
				    $value->{"deviceActive"} = "Blocked";
				    $devAct = "Blocked";
				}
				$devName = $value->{'deviceName'};
			    }else{
				$devAct = "-";
				$devName = "-";
			    }                    
			    if($value->{'firstBackupCompleted'} == true){
				$firstFullBkpTotalSizeOfFiles = $value->{'firstFullBkpTotalSizeOfFiles'};
				$firstFullBkpNoOfFiles = $value->{'firstFullBkpNoOfFiles'};
				$lastSucessfulBkpTotalSizeOfFiles = $value->{'lastSucessfulBkpTotalSizeOfFiles'};
				$lastSucessfulBkpNoOfFiles = $value->{'lastSucessfulBkpNoOfFiles'};
			    }else{
				$firstFullBkpTotalSizeOfFiles = "-";
				$firstFullBkpNoOfFiles = "-";
				$lastSucessfulBkpTotalSizeOfFiles = "-";
				$lastSucessfulBkpNoOfFiles = "-";
			    }                    
			    if($value->{'currentBkpStatus'} == 'STARTED'){
				$totalCurrentlyRunningBkpSizeInPer = $value->{'totalCurrentlyRunningBkpSizeInPer'};
				$currentlyRunningBkpTotalSizeOfFiles = $value->{'currentlyRunningBkpTotalSizeOfFiles'};
				$currentlyRunningBkpNoOfFiles = $value->{'currentlyRunningBkpNoOfFiles'};
				$totalSizeToUpload = $value->{'totalSizeToUpload'};
			    }else{
				$totalCurrentlyRunningBkpSizeInPer = "-";
				$currentlyRunningBkpTotalSizeOfFiles = "-";
				$currentlyRunningBkpNoOfFiles = "-";
				$totalSizeToUpload = "-";
			    }                    
			    if($value->{'userActive'} == "1"){
				$userActive = 'Active';
			    }else{
				$userActive = 'Blocked';
			    }

			    if($value->{'firstBackupCompleted'} == "1"){
				$isFirstBackupCompleted = 'Yes';
			    }else{
				$isFirstBackupCompleted = 'No';
			    }

			    if($value->{'backupRunning'} == true){
				$isBackupRunning = 'Yes';
			    }else{
				$isBackupRunning = 'No';
			    }                    
			    $overview = array(
				'userId' => $value->{'userId'},
				'emailId' => $value->{'emailId'},
				'deviceName' => $devName,
				'policyName' => $value->{'policyName'},
				'odbPolicyName' => $value->{'odbPolicyName'},
				'epaInstallationDate' => $value->{'epaInstallationDate'},
				'firstBkpStartTime' => $value->{'firstBkpStartTime'},
				'firstBkpEndTime' => $value->{'firstBkpEndTime'},
				'lastBkpStartTime' => $value->{'lastBkpStartTime'},
				'lastSuccessfulBkp' => $value->{'lastSuccessfulBkp'},
				'lastBkpStatus' => $value->{'lastBkpStatus'},
				'reason' => $value->{'reason'},
				'storageUtilized' => $value->{'storageUtilized'},
				'completedPercentage' => $completedPercentage,
				'deviceActive' => $devAct,
				'userActive' => $userActive,
				'isFirstBackupCompleted' => $isFirstBackupCompleted,
				'isBackupRunning' => $isBackupRunning,
				'clientVersion' => $value->{'clientVersion'},
				'firstBackupCompleted' => $value->{'firstBackupCompleted'},
				'lastHeardTime' => $value->{'lastHeardTime'},
				'currentBkpCompletionPct' => $value->{'currentBkpCompletionPct'},
				'currentBkpCompletionPctInt' => intval($value->{'currentBkpCompletionPct'}),
				'currentBkpStatus' => $value->{'currentBkpStatus'},
				'currentBkpStartTime' =>  $value->{'currentBkpStartTime'},
				'lastSuccessfulBackupStartTime' => $value->{'lastSuccessfulBackupStartTime'},
				'lastSuccessfulBackupEndTime' => $value->{'lastSuccessfulBackupEndTime'},
				'firstFullBkpTotalSizeOfFiles' => $firstFullBkpTotalSizeOfFiles,
				'firstFullBkpNoOfFiles' => $firstFullBkpNoOfFiles,
				'lastSucessfulBkpTotalSizeOfFiles' => $lastSucessfulBkpTotalSizeOfFiles,
				'lastSucessfulBkpNoOfFiles' => $lastSucessfulBkpNoOfFiles,
				'currentlyRunningBkpTotalSizeOfFiles' => $currentlyRunningBkpTotalSizeOfFiles,
				'currentlyRunningBkpNoOfFiles' => $currentlyRunningBkpNoOfFiles,
				'totalSizeToUpload' => $totalSizeToUpload,
				'totalCurrentlyRunningBkpSizeInPer' => $totalCurrentlyRunningBkpSizeInPer,
				'firstFullBkpTotalSizeOfFilesInKB' => $value->{'firstFullBkpTotalSizeOfFilesInKB'},
				'lastSuccessfulBackupStartTimeInMillis' => $value->{'lastSuccessfulBackupStartTimeInMillis'},
				'lastSuccessfulBackupEndTimeInMillis' => $value->{'lastSuccessfulBackupEndTimeInMillis'},
				'lastSucessfulBkpTotalSizeOfFilesInKB' => $value->{'lastSucessfulBkpTotalSizeOfFilesInKB'},
				'currentBkpStartTimeInMillis' => $value->{'currentBkpStartTimeInMillis'},
				'currentlyRunningBkpTotalSizeOfFilesInKB' => $value->{'currentlyRunningBkpTotalSizeOfFilesInKB'},
				'totalSizeToUploadInKB' => $value->{'totalSizeToUploadInKB'},
				'lastHeardTimeInMillis' => $value->{'lastHeardTimeInMillis'},
				'storageUtilizedInKB' => $value->{'storageUtilizedInKB'},
			    );
                    		$overviewList = array_merge(array($overview), $overviewList);
			}
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'notificationElementList'}->{'notificationHistoryElementList'})){
			foreach($result['body']->{'productOverviewElement'}->{'notificationElementList'}->{'notificationHistoryElementList'} as $value){
				$value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeInMillis'})/1000);
				$value->{'whenFailed'} = date('d-M-Y H:i:s',(int)($value->{'whenFailedInMillis'})/1000);
			}
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'restoreHistoryElements'})){
			foreach($result['body']->{'productOverviewElement'}->{'restoreHistoryElements'} as $value){
			    $value->{'restoredFiles'} = intval($value->{'restoredFiles'});
			    $value->{'restoreTime'} = date('d-M-Y H:i:s',(int)($value->{'restoreTimeInMillis'})/1000);
			    if($value->{'restoreEndTimeInMillis'} != 0){
				$value->{'restoreEndTime'} = date('d-M-Y H:i:s',(int)($value->{'restoreEndTimeInMillis'})/1000);
			    }else{
				$value->{'restoreEndTime'} = '-';
			    }
			    $value->{'restoreFolder'} = base64_decode($value->{'restoreFolder'});
			    $value->{'destFolder'} = base64_decode($value->{'destFolder'});
			    if((strpos($value->{'deviceName'}, '(Microsoft OneDrive)') !== false || strpos($value->{'deviceName'}, '(Microsoft Exchange)') !== false)){
				$value->{'restoredSize'} = 'NA';
				$value->{'restoredSizeInKB'} = 0;
			    }
			}
		    }
		    else{
			$result['body']->{'productOverviewElement'}->{'restoreHistoryElements'} = [];
		    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'allAdmins'})){
			foreach($result['body']->{'productOverviewElement'}->{'allAdmins'} as $value){
				$value->{'lastLoggedInTime'} = date('d-M-Y H:i:s',(int)($value->{'lastLoggedInTime'})/1000);
				$value->{'backupPoliciesAdmin'} = implode(',', (array)$value->{'backupPoliciesAdmin'});
			}
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'allBlockedDevices'})){
			foreach($result['body']->{'productOverviewElement'}->{'allBlockedDevices'} as $value){
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }elseif($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }elseif($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }
			    $value->{'status'} = $status;
			}
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'backupHistoryElements'} )){
			foreach($result['body']->{'productOverviewElement'}->{'backupHistoryElements'} as $value){
                    		$value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeInMillis'})/1000);
                    		$value->{'endTime'} = date('d-M-Y H:i:s',(int)($value->{'endTimeInMillis'})/1000);
			}
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'allAdmins'} )){
			foreach($result['body']->{'productOverviewElement'}->{'allAdmins'} as $value){
			   if($value->{'admin'} == true){
				$value->{'role'} = 'Administrator';
			   }elseif($value->{'readOnlyAdmin'} == true && $value->{'delegatedAdmin'} == false){
				$value->{'role'} = 'Delegated Administrator';
			   }elseif($value->{'readOnlyAdmin'} == true && $value->{'delegatedAdmin'} == true){
				$value->{'role'} = 'Read Only Administrator';
			   }else{
				$value->{'role'} = 'User';
			   } 
			}
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'userPolicyMappingElementList'} )){
		        foreach($result['body']->{'productOverviewElement'}->{'userPolicyMappingElementList'} as $value){
		           if($value->{'productType'} == 'backup'){
		                $value->{'productType'} = 'BluVault';
		           }elseif($value->{'productType'} == 'sync'){
		                $value->{'productType'} = 'BluSync';
		           }elseif($value->{'productType'} == 'office'){
		                $value->{'productType'} = 'Office 365 Backup';
		           }
		        }
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'userPolicyMappingElementList'})){
                                foreach($result['body']->{'productOverviewElement'}->{'userPolicyMappingElementList'} as $value){
                                        $value->{'userNames'} = implode(',', (array)$value->{'userNames'});
                                }
                    }

                    if(!empty($result['body']->{'productOverviewElement'}->{'backupPolicyStatisticsElement'})){
                    	foreach($result['body']->{'productOverviewElement'}->{'backupPolicyStatisticsElement'} as $value){
                           if($value->{'productType'} == 'Bluvault'){
                                $value->{'productType'} = 'BluVault';
                           }elseif($value->{'productType'} == 'Blusync'){
                                $value->{'productType'} = 'BluSync';
                           }elseif($value->{'productType'} == 'Office 365'){
                                $value->{'productType'} = 'Office 365 Backup';
                           }
                    	}
                    }
				
                    $response = array(
                        'result' => 'success',
			'productOverviewLicense' => $result['body']->{'productOverviewElement'}->{'licenseElement'},
			'productOverviewPolicyElement' => $result['body']->{'productOverviewElement'}->{'backupPolicyStatisticsElement'},
			'failedBackup' => !empty($result['body']->{'productOverviewElement'}->{'notificationElementList'}->{'notificationHistoryElementList'}) ? $result['body']->{'productOverviewElement'}->{'notificationElementList'}->{'notificationHistoryElementList'} : [],
			'overview' => array_reverse($overviewList),
			'restoreByDate' => $result['body']->{'productOverviewElement'}->{'restoreHistoryElements'},
			'blockedUsers' => $result['body']->{'productOverviewElement'}->{'allBlockedUsers'},
			'adminDetails' => $result['body']->{'productOverviewElement'}->{'allAdmins'},
			'allBlockedDevices' => $result['body']->{'productOverviewElement'}->{'allBlockedDevices'},
			'userBackupHistory' => $result['body']->{'productOverviewElement'}->{'backupHistoryElements'},
			'userPolicyMappingElementList' => $result['body']->{'productOverviewElement'}->{'userPolicyMappingElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function downloadProductOverview(){
        if(!empty($_POST)){
            $headers = array(
                    'token'         => $this->session->get('token'),
                    'Content-Type'  => 'application/json',
        );
        if($_POST['policyName'] == ['all'] || $_POST['policyName'] == null || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
        }
        $data=array(
            'userName'      => '',
            'deviceName'    => '',
            'policyNames'    => $_POST['policyName']=='all' ? []:$_POST['policyName'],
            'isUserWithoutDeviceEnabled' => true,
            'showBlockedUsers' => true,
            'showBlockedDevices' => true,
            'noOfDays' => $_POST['numberOfDays'],
        );
            $result = $this->_model->downloadProductOverview($headers, $data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
	}
    }

    public function downloadProductOverviewExcel(){
    $filePath = OVERVIEW_REPORT_PATH.PRODUCT_OVERVIEW_REPORT_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.PRODUCT_OVERVIEW_REPORT_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }

    public function downloadProductOverviewToPdf(){
        if(!empty($_POST)){
            $headers = array(
                    'token'         => $this->session->get('token'),
                    'Content-Type'  => 'application/json',
        );
        if($_POST['policyName'] == ['all'] || $_POST['policyName'] == null || $_POST['policyName'] == 'all'){
            $_POST['policyName'] = [];
        }
        $data=array(
            'userName'      => '',
            'deviceName'    => '',
            'policyNames'    => $_POST['policyName']=='all' ? []:$_POST['policyName'],
            'isUserWithoutDeviceEnabled' => true,
            'showBlockedUsers' => true,
            'showBlockedDevices' => true,
            'noOfDays' => $_POST['numberOfDays'],
        );
            $result = $this->_model->downloadProductOverviewToPdf($headers, $data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }
    }

    public function downloadProductOverviewPdf(){
    	    $filePath = AGENT_NOT_HEARD_PATH.PRODUCT_OVERVIEW_REPORT_NAME_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.PRODUCT_OVERVIEW_REPORT_NAME_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }

    public function saveScheduleReportProductOverview(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token')
            );
            if(!empty($_POST['days'])){
                $_POST['days'] = implode(',', $_POST['days']);
            }
            if($_POST['months'] == null){
            $_POST['months'] = [];
            }

	     if($_POST['endDate'] != '' && $_POST['startDate'] != ''){
		if(strtotime($_POST['endDate']) < strtotime($_POST['startDate'])){
			$data = array(
			    'result' => 'fail',
			    'msg' => 'To Date should be greater than From Date'
			);
			$jsonData = json_encode($data);
			echo $jsonData;
			exit;
		}
	     }
	     if($_POST['mailid'] == 'all admins'){
                $allowAllAdmins = true;
	     }else{
                $allowAllAdmins = false;
	     }
	     $this->log("DATA : ".json_encode($_POST['userName']),"info");
	     $this->log("DATA : ".json_encode($_POST['deviceName']),"info");
	     $data = array(
                'id' => $_POST['id'],
                'schedulerName'  => $_POST['trigger'],
                'displayName' => $_POST['scheduleName'],
                'time'    => $_POST['time'],
                'date' => $_POST['date'],
                'days'      => $_POST['days'],
                'emailIds'     => explode(',', $_POST['mailid']),
                'deviceName'      => '',
                'userName'      => '',
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
                'months'    => $_POST['months'],
                'dayOfMonth' => $_POST['dayOfMonth'],
                'noOfDays' => $_POST['noOfDays'],
                'userWithoutDeviceEnabled' => true,
                'showBlockedUsers' => true,
                'showBlockedDevices' => true,
                'endDate'       => $_POST['endDate'],
                'startDate'     => $_POST['startDate'],
		'allAdmins'     => $allowAllAdmins,
		'createdBy'     => $_POST['createdBy'],
            );
            $this->log("DATA : ".json_encode($data),"info");
	    $this->validateData1($_POST['scheduleName']);
            $this->validateData1($_POST['time']);
            $result = $this->_model->saveScheduleReportProductOverview($headers,$data,$schedulerName);
            switch ($result['status']) {
                case (200):
                $response = array(
                        'result' => 'success',
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
		case (403):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Schedule with same name already exists'
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
	
    public function incompleteBackup($reportProductType){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        Auth::allowOnly('readOnlyAdmin');
        $backupResult = $this->_model->getAllPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        $backupPolicies = [];
	if(!empty($backupResult['body']->{'stringList'})){
		foreach((array)$backupResult['body']->{'stringList'} as $value){
            		$policy = $value;
            		$backupPolicies = array_merge(array($policy), $backupPolicies);
		}
	}
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('incompleteBackup'),
            'active' => 'report',
            'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserRole'=>$this->session->get('readOnlyAdmin'),
            'backupPolicies'=>array_reverse($backupPolicies),
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/incompleteBackup', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getIncompleteBackup(){
        if(!empty($_POST)){
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }
	    $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType']

            );
            if($_POST['includeDateRange'] == 'no'){
                    $this->log("includeDateRange : ".$_POST['includeDateRange'],"info");
                    $from = '';
                    $to = '';
            }else{
                    $from = $_POST['from'];
                    $to = $_POST['to'];
            }
            if($_POST['reason'] == 'NotHeardDevices'){
                $to = '';
            }
            $data =array(
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
                'reason'        => $_POST['reason'],
                'startDate' => $from,
                'endDate' => $to
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->getIncompleteBackup($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $history = [];
                if(!empty($result['body']->{'data'}->{'backupActivityHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupActivityHistoryElement'} as $value){
                    /*    $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeLong'})/1000);
                        $value->{'whenFailed'} = date('d-M-Y H:i:s',(int)($value->{'endTimeLong'})/1000);
                    $value->{'totalFiles'} = $value->{'noOfFilesBackedup'} + $value->{'noOfFilesFailed'};*/

                    if($_POST['reason'] == 'UsersWithoutAgent'){
                        $lastHeardDate = '-';
                    }else{
                        $lastHeardDate = date('d-M-Y H:i:s',(int)($value->{'lastHeardDate'})/1000);
                    }
                    if($_POST['reason'] == 'NotHeardDevices' || $_POST['reason'] == 'UsersWithoutAgent'){
                        $status = 'no';
                    }else{
                        $status = 'yes';
                    }
                        $totalFiles = $value->{'noOfFilesBackedup'} + $value->{'noOfFilesFailed'};
                    $his = array(
                            'startTime' => date('d-M-Y H:i:s',(int)($value->{'startTimeLong'})/1000),
                            'whenFailed' => date('d-M-Y H:i:s',(int)($value->{'endTimeLong'})/1000),
                            'lastHeardDate' => $lastHeardDate,
                            'startTimeLong' => $value->{'startTimeLong'},
                            'endTimeLong' => $value->{'endTimeLong'},
                            'lastHeardDateLong' => $value->{'lastHeardDate'},
                            'userName' => $value->{'userName'},
                            'deviceName' => $value->{'deviceName'},
                            'noOfFilesBackedup' => $value->{'noOfFilesBackedup'},
                            'totalFile' => $totalFiles,
                            'totalNumberOfFiles' => $value->{'totalNumberOfFiles'},
                            'status' => $status,
                        );
                    $history = array_merge(array($his), $history);
                    }
                }
                
                $this->log("hhhhhhhhhhhhhhh : ".json_encode($history),"info");
                    $response = array(
                        'result' => 'success',
                        'failedBackup' => $history,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getIncompleteBackup1(){
        if(!empty($_POST)){
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }
	    $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Accept'  => 'application/json',
                'Content-Type'  => 'application/json',
                'productType' => $_POST['reportProductType']
                );
            if($_POST['includeDateRange'] == 'no'){
                    $this->log("includeDateRange : ".$_POST['includeDateRange'],"info");
                    $from = '';
                    $to = '';
            }else{
                    $from = $_POST['from'];
                    $to = $_POST['to'];
            }
            if($_POST['reason'] == 'NotHeardDevices'){
                $to = '';
            }
            $data =array(
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
                'reason'        => $_POST['reason'],
                'startDate' => $from,
                'endDate' => $to
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->getIncompleteBackup1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
                if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                $history =[];
                if(!empty($result['body']->{'data'}->{'backupActivityHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupActivityHistoryElement'} as $value){
                    /*    $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'startTimeLong'})/1000);
                        $value->{'whenFailed'} = date('d-M-Y H:i:s',(int)($value->{'endTimeLong'})/1000);
                    $value->{'totalFiles'} = $value->{'noOfFilesBackedup'} + $value->{'noOfFilesFailed'};*/

                    if($_POST['reason'] == 'UsersWithoutAgent'){
                        $lastHeardDate = '-';
                    }else{
                    	$lastHeardDate = date('d-M-Y H:i:s',(int)($value->{'lastHeardDate'})/1000);
                    }
                    if($_POST['reason'] == 'NotHeardDevices' || $_POST['reason'] == 'UsersWithoutAgent'){
                        $status = 'no';
                    }else{
                        $status = 'yes';
                    }
                        $totalFiles = $value->{'noOfFilesBackedup'} + $value->{'noOfFilesFailed'};
                    $his = array(
                            'startTime' => date('d-M-Y H:i:s',(int)($value->{'startTimeLong'})/1000),
                            'whenFailed' => date('d-M-Y H:i:s',(int)($value->{'endTimeLong'})/1000),
                            'lastHeardDate' => $lastHeardDate,
                            'startTimeLong' => $value->{'startTimeLong'},
                            'endTimeLong' => $value->{'endTimeLong'},
                            'lastHeardDateLong' => $value->{'lastHeardDate'},
                            'userName' => $value->{'userName'},
                            'deviceName' => $value->{'deviceName'},
                            'noOfFilesBackedup' => $value->{'noOfFilesBackedup'},
                            'totalFile' => $totalFiles,
                            'totalNumberOfFiles' => $value->{'totalNumberOfFiles'},
                            'status' => $status,
                        );
                    $history = array_merge(array($his), $history);
                    }
                }
                    $response = array(
                        'result' => 'success',
                        'failedBackup' => $history,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
                );
       }
    }
    
    
    public function downloadIncompleteBackupReportExcel(){
        if(!empty($_POST)){
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
	    $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'productType'   => $_POST['reportProductType']
                );
            if($_POST['includeDateRange'] == 'no'){
                    $this->log("includeDateRange : ".$_POST['includeDateRange'],"info");
                    $from = '';
                    $to = '';
            }else{
                    $from = $_POST['from'];
                    $to = $_POST['to'];
            }
            if($_POST['reason'] == 'NotHeardDevices'){
                $to = '';
            }
            $data =array(
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
                'reason'        => $_POST['reason'],
                'startDate' => $from,
                'endDate' => $to
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadIncompleteBackupReportExcel($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadIncompleteBackupReportToExcel(){
            $filePath = AGENT_NOT_HEARD_PATH.INCOMPLETE_BACKUP_REPORT_NAME_EXL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.INCOMPLETE_BACKUP_REPORT_NAME_EXL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }
    
    public function downloadIncompleteBackupReportPdf(){
        if(!empty($_POST)){
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
	    $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'productType'   => $_POST['reportProductType']
                );
            if($_POST['includeDateRange'] == 'no'){
                    $this->log("includeDateRange : ".$_POST['includeDateRange'],"info");
                    $from = '';
                    $to = '';
            }else{
                    $from = $_POST['from'];
                    $to = $_POST['to'];
            }
	    if($_POST['reason'] == 'NotHeardDevices'){
                $to = '';
            }
            $data =array(
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : [],
                'reason'        => $_POST['reason'],
                'startDate' => $from,
                'endDate' => $to
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadIncompleteBackupReportPdf($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                        );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                    default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadIncompleteBackupReportToPdf(){
    	$filePath = AGENT_NOT_HEARD_PATH.INCOMPLETE_BACKUP_REPORT_NAME_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.INCOMPLETE_BACKUP_REPORT_NAME_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }
	
    public function downloadUserMigration(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'userName'      => $this->session->get('userName')
        );
        $result = $this->_model->downloadUserMigration($headers);
        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;
            case (204):
                $response = array(
                    'result' => 'fail',
                    'msg' => 'No records found, Unable to create excel.'
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
		exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
	
    public function downloadUserMigrationExcel(){
        $filePath = OVERVIEW_REPORT_PATH.USER_MIGRATION;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.USER_MIGRATION);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }

    public function convertUnit($valueWithUnit, $toUnit) {
	    $unitFactors = [
	        'B' => 1,
	        'KB' => 1024,
	        'MB' => 1024 * 1024,
	        'GB' => 1024 * 1024 * 1024,
	        'TB' => 1024 * 1024 * 1024 * 1024,
	    ];
	
	    // Extract the numeric value and unit abbreviation from the input string
	    if (preg_match('/^(\d+(\.\d+)?)\s*(\w+)$/', $valueWithUnit, $matches)) {
	        $value = (float)$matches[1];
	        $fromUnit = strtoupper($matches[3]);
	
	        $toUnit = strtoupper($toUnit);
	
	        if (array_key_exists($fromUnit, $unitFactors) && array_key_exists($toUnit, $unitFactors)) {
	            return $value * ($unitFactors[$fromUnit] / $unitFactors[$toUnit]);
	        }
	    }
	
	    throw new Exception("Invalid input or unit specified");
    }

    public function getStatisticsMSP(){
        if(!empty($_POST)){
            $headers = array(
		    'token'         => $this->session->get('token'),
		    'Content-Type'  => 'application/json',
            	    'Accept'        => 'application/json',
	    	    'deviceType'   => 'BACKUP'
            );
	    $result = $this->_model->getStatistics($headers);
	    $convertedOne = $this->convertUnit($result['body']->{'MSPCloudOverviewElement'}->{'totalStorageUtilized'}, 'GB');
            //$this->log("CONVERTED : ".round($convertedOne,2),"info");
            $result['body']->{'MSPCloudOverviewElement'}->{'totalStorageUtilized'} = round($convertedOne,2).' GB';
	    $percentageUser = 0;
            $percentageUserString = '';
            $percentage = '';
            $percentageString = '';
            $alert = '';
            $alertUser = '';
            if($this->session->get("showStorageBanner") != 'no'){
		$showStorageBanner = 'yes';
            }else{
		$showStorageBanner = 'no';
            }
            if($this->session->get("showUserBanner") != 'no'){
		$showUserBanner = 'yes';
            }else{
		$showUserBanner = 'no';
            }
            if($this->session->get("showUserBanner") != 'no'){
	            $totalUsersUtilized = (int)$result['body']->{'MSPCloudOverviewElement'}->{'totalNoOfActiveUsers'};
		    $totalNoOfUsers = ((int)$result['body']->{'MSPCloudOverviewElement'}->{'totalNoOfUsersAlloted'} != 0) ? (int)$result['body']->{'MSPCloudOverviewElement'}->{'totalNoOfUsersAlloted'} : 0;
		    if($totalNoOfUsers != 0){
			    $percentageUser = round(($totalUsersUtilized/$totalNoOfUsers)*100, 2);
		    }
	            $percentageUserString = 'Approaching user limit, Currently at '.$percentageUser.'%.';
	            if($percentageUser >= 90){
	                    $alertUser = 'yes';
	                    $showUserBanner = 'yes';
	            }else{
	                    $alertUser = 'no';
	                    $showUserBanner = 'no';
		    }
		    if($percentageUser >= 100){
			$percentageUserString = 'User limit exceeded 100%.';
		    }
            }
            if($this->session->get("showStorageBanner") != 'no'){
                    $percentage = round($result['body']->{'MSPCloudOverviewElement'}->{'totalStoragePercent'});
                    $percentageString = 'Approaching storage limit, Currently at '.round($result['body']->{'MSPCloudOverviewElement'}->{'totalStoragePercent'}, 2).'%.';
                    if($percentage >= 80){
                            $alert = 'yes';
                            $showStorageBanner = 'yes';
                    }else{
                            $alert = 'no';
                            $showStorageBanner = 'no';
                    }
                    $this->log("percentage : ".$percentage,"info");
                    if($percentage >= 100){
                        $percentageString = 'Storage limit exceeded 100%.';
                    }
            }
            $this->session->put("showUserBanner",$showUserBanner);
	    $this->session->put("showStorageBanner",$showStorageBanner);
	    if(!empty($result['body']->{'MSPCloudOverviewElement'}->{'packs'})){
                    for($p=0;$p<sizeof($result['body']->{'MSPCloudOverviewElement'}->{'packs'});$p++){
                            if($result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'subscriptionActive'} == true){
                                $this->log("PPPPP : ".$p,"info");
                                $this->session->put("showpacks",'SHOWPACKS');
				$this->session->put("skuCode",$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'skuCode'});
				if (substr($result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'skuCode'}, 0, 2) === 'FR') {
                                        $this->session->put("packModel",'FREMIUM');
                                } else {
                                        $this->session->put("packModel",'PREMIUM');
                                }
                                $this->log("PACKCODE : ".$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'skuCode'},"info");
                                $totalStorage = (int)preg_replace("/[^0-9]/", '', $result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'storageSize'});
                                $totalUser = (int)preg_replace("/[^0-9]/", '', $result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'minUserCount'});
                                $this->session->put("storageSize",$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'storageSize'});
                                $this->session->put("minUserCount",$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'minUserCount'});
                                $this->session->put("customerId",$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'customerId'});
                                $this->session->put("referenceNumber",$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'referenceNumber'});
                                $subDateBase =  date('d-M-Y H:i:s', (((int)$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'subscriptionStartDate'}) / 1000));
                                $this->session->put("subscriptionStartDate",$subDateBase);
                                $this->session->put("addons",$result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'});
                                foreach($result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'} as $value){
                                        if($value->{'subscriptionActive'} == true && substr($value->{'skuCode'}, 0, 5) !== "ADSER"){
                                        $totalUser = $totalUser + (int)preg_replace("/[^0-9]/", '', $value->{'minUserCount'});
                                        $totalStorage = $totalStorage + (int)preg_replace("/[^0-9]/", '', $value->{'storageSize'});
                                        }
				}
				$totalServer = 0;
				foreach($result['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'} as $value){
                                        if (substr($value->{'skuCode'}, 0, 5) === "ADSER") {
                                                if($value->{'subscriptionActive'} == true){
							$totalServer = $totalServer + (int)preg_replace("/[^0-9]/", '', $value->{'minUserCount'});
							$totalStorage = $totalStorage + (int)preg_replace("/[^0-9]/", '', $value->{'storageSize'});
                                                }
                                        }
                                }
                                $this->log("TOTALSTORAGE : ".$totalStorage,"info");
				$this->log("TOTALUSER : ".$totalUser,"info");
                                $this->session->put("totalStorage",$totalStorage);
				$this->session->put("totalUser",$totalUser);
				$this->session->put("totalServer",$totalServer);
                            }
                    }
	    }
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'statistics' => !empty($result['body']->{'MSPCloudOverviewElement'}) ? $result['body']->{'MSPCloudOverviewElement'} : [],
			'alert' => $alert,
                        'percentage' => $percentageString,
                        'alertUser' => $alertUser,
                        'percentageUser' => $percentageUserString
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveEventHubMsp(){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'         => $this->session->get('token'),
 		'isStopBackup' => 'false',
                'isPauseBackup' => 'false'
	    );
	    $eventHubElements = [];
            array_push($eventHubElements,'START_BACKUP');
            $headers["isStopBackup"] = "false";
            $headers["isPauseBackup"] = "false";
            $headers["isRestoreStarted"] = "false";                    
            $headers["isStopRestore"] = "false";                    
            $data = array(
                    "actionToDeviceUUID" => $_POST['actionToDeviceUUID'],
                    "actions"         => $eventHubElements,
            );
            $result = $this->_model->saveEventHubMsp($headers, $data);
            switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => "Settings Saved"
                        );
                        echo json_encode($response);
                        exit;
		    case (417):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Request already exists in Queue.'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (409):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('policyExists')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
    }

    public function getCurrentDeviceIDInformationMsp(){
            $headers = array(
                'token' => $this->session->get('token'),
                'deviceUUID' => $_POST['currentDeviceUUID']
            );
            $result = $this->_model->userDevicePolicyInfoMsp($headers);
            switch ($result['status']) {
            case (200):
                    $response = array(
                        'result' => 'success',
                        'defaultFolders' => $result['body']->bluSyncPortalBackupPolicyElement->defaultFolders,
                        'userExcludedFolders' => $result['body']->bluSyncPortalBackupPolicyElement->userExcludedFolders,
                        'userDefinedFolders' => $result['body']->bluSyncPortalBackupPolicyElement->userDefinedFolders,
                        'fileTypes' => $result['body']->bluSyncPortalBackupPolicyElement->fileTypes,
                        'filterType' => $result['body']->bluSyncPortalBackupPolicyElement->filterType,
                        'maxSizeAllowed' => $result['body']->bluSyncPortalBackupPolicyElement->maxSizeAllowed,
                        'canAdminRestore' => (boolean)$result['body']->bluSyncPortalBackupPolicyElement->canAdminRestore,
                        'showdisableAdminRestore' => (boolean)$result['body']->bluSyncPortalBackupPolicyElement->showdisableAdminRestore,
                        'userSQLBackupFolders' => $result['body']->bluSyncPortalBackupPolicyElement->userSQLBackupFolders,
                        'fromFilter' => $result['body']->bluSyncPortalBackupPolicyElement->fromFilter,
                        'toFilter' => $result['body']->bluSyncPortalBackupPolicyElement->toFilter,
                        'subjectFilter' => $result['body']->bluSyncPortalBackupPolicyElement->subjectFilter
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function closeStorageWarning(){
        $this->session->put("showStorageBanner","no");
    }

    public function closeUserWarning(){
        $this->session->put("showUserBanner","no");
    }

    public function deviceOverview($reportProductType){
        Auth::allowOnly('readOnlyAdmin');
        $backupPolicies=[];
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        if(!empty($backupResult['body']->{'stringList'})){
		foreach((array)$backupResult['body']->{'stringList'} as $value){
		    $policy = $value;
		    $backupPolicies = array_merge(array($policy), $backupPolicies);
		}
	}
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Backup Completion Report',
            'active' => 'report',
            'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
            'backupPolicies'=>array_reverse($backupPolicies)
        );
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/deviceOverview', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getDeviceOverview(){
            /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
                $_POST['userName']='';
            }
            if($_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
                $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'productType' => $_POST['reportProductType']
            );
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'onDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'jobType' => 'BACKUP',
                'currentRunningBackups' => $_POST['currentRunningBackups']=="true" ? true : false,
                /*'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '' ,
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []*/
            );
            $result = $this->_model->getDeviceOverview($headers,$data,$_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
                if(!empty($result['body']->{'data'}->{'backupBatchReportElements'} )){
		        foreach($result['body']->{'data'}->{'backupBatchReportElements'} as $value){
		            $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'batchStartTimestamp'})/1000);
		            $value->{'endTime'} = date('d-M-Y H:i:s',(int)($value->{'batchEndTimestamp'})/1000);
		            $value->{'uploadedSizeWithUnit'} = !empty($value->{'uploadedSizeWithUnit'}) ? $value->{'uploadedSizeWithUnit'} : '-';
		            if($value->{'status'} == 'STARTED'){
				$value->{'status'} = 'Data Uploading';
			    }elseif($value->{'status'} == 'SCANNING'){
				$value->{'status'} = 'Scanning';
			    }elseif($value->{'status'} == 'COMPLETED'){
				$value->{'status'} = 'Completed';
			    }elseif($value->{'status'} == 'FAILED'){
				$value->{'status'} = 'Failed';
			    }elseif($value->{'status'} == 'INTERRUPTED'){
				$value->{'status'} = 'Interrupted';
			    }elseif($value->{'status'} == 'PAUSED'){
				$value->{'status'} = 'Paused';
			    }elseif($value->{'status'} == 'ABORTED'){
				$value->{'status'} = 'Aborted';
			    }elseif($value->{'status'} == 'EXITED'){
				$value->{'status'} = 'Exited';
			    }

		            if($value->{'status'} != 'Completed'){
		                $value->{'endTime'} = '-';
		            }
		        }
                }
                if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'deviceOverview' => !empty($result['body']->{'data'}->{'backupBatchReportElements'}) ? $result['body']->{'data'}->{'backupBatchReportElements'} : [],
                        'totalCompletedStatusCount' => !empty($result['body']->{'data'}->{'totalCompletedStatusCount'}) ? $result['body']->{'data'}->{'totalCompletedStatusCount'} : 0,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }
    
    public function getDeviceOverview1(){
            /*$_POST['from'] = $_POST['from']/1000;
            $_POST['to'] = $_POST['to']/1000;
            $_POST['from'] = date('m/d/Y',$_POST['from']);
            $_POST['to'] = date('m/d/Y',$_POST['to']);*/
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
                $_POST['userName']='';
            }
            if($_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
                $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
            $headers = array(
                'token' => $this->session->get('token'),
                'Content-type' => 'application/json',
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType']
            );
            $data = array(
            	'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'onDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'jobType' => 'BACKUP',
                'currentRunningBackups' => $_POST['currentRunningBackups']=="true" ? true : false,
                /*'endDate'       => !empty($_POST['to']) ? $_POST['to'] : '' ,
                'policyNames'   => !empty($_POST['policyName']) ? $_POST['policyName'] : []*/
            );
            $result = $this->_model->getDeviceOverview1($headers,$data,$_POST['url']);
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'data'}->{'backupBatchReportElements'} )){
		        foreach($result['body']->{'data'}->{'backupBatchReportElements'} as $value){
		            $value->{'startTime'} = date('d-M-Y H:i:s',(int)($value->{'batchStartTimestamp'})/1000);
		            $value->{'endTime'} = date('d-M-Y H:i:s',(int)($value->{'batchEndTimestamp'})/1000);
		            $value->{'uploadedSizeWithUnit'} = !empty($value->{'uploadedSizeWithUnit'}) ? $value->{'uploadedSizeWithUnit'} : '-';
		            if($value->{'status'} == 'STARTED'){
				$value->{'status'} = 'Data Uploading';
			    }elseif($value->{'status'} == 'SCANNING'){
				$value->{'status'} = 'Scanning';
			    }elseif($value->{'status'} == 'COMPLETED'){
				$value->{'status'} = 'Completed';
			    }elseif($value->{'status'} == 'FAILED'){
				$value->{'status'} = 'Failed';
			    }elseif($value->{'status'} == 'INTERRUPTED'){
				$value->{'status'} = 'Interrupted';
			    }elseif($value->{'status'} == 'PAUSED'){
				$value->{'status'} = 'Paused';
			    }elseif($value->{'status'} == 'ABORTED'){
				$value->{'status'} = 'Aborted';
			    }elseif($value->{'status'} == 'EXITED'){
				$value->{'status'} = 'Exited';
			    }

		            if($value->{'status'} != 'Completed'){
		                $value->{'endTime'} = '-';
		            }
		        }
                }
                if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'deviceOverview' => !empty($result['body']->{'data'}->{'backupBatchReportElements'}) ? $result['body']->{'data'}->{'backupBatchReportElements'} : [],
                        'totalCompletedStatusCount' => !empty($result['body']->{'data'}->{'totalCompletedStatusCount'}) ? $result['body']->{'data'}->{'totalCompletedStatusCount'} : 0,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }
	
    public function downloadDeviceOverviewReportExcel(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
                $_POST['userName']='';
            }
            if($_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
                $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
            $headers = array(
                'token' => $this->session->get('token'),
                'Content-type' => 'application/json',
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType']
            );
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'onDate'     	=> !empty($_POST['from']) ? $_POST['from'] : '',
                'jobType' 	=> 'BACKUP',
                'currentRunningBackups' => $_POST['currentRunningBackups']=="true" ? true : false,
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadDeviceOverviewReportExcel($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                    default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadDeviceOverviewReportToExcel(){
        $filePath = OVERVIEW_REPORT_PATH.BACKUP_COMPLETION_EXCEL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BACKUP_COMPLETION_EXCEL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }
    
    public function downloadDeviceOverviewReportPdf(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
                $_POST['userName']='';
            }
            if($_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
                $_POST['deviceName'] = '';
            }
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == ['all']){
                $_POST['policyName'] = [];
            }
            $headers = array(
                'token' => $this->session->get('token'),
                'Content-type' => 'application/json',
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType']
            );
            $data = array(
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'onDate'     	=> !empty($_POST['from']) ? $_POST['from'] : '',
                'jobType' 	=> 'BACKUP',
                'currentRunningBackups' => $_POST['currentRunningBackups']=="true" ? true : false,
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadDeviceOverviewReportPdf($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function downloadDeviceOverviewReportToPdf(){
        $filePath = AGENT_NOT_HEARD_PATH.BACKUP_COMPLETION_PDF;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BACKUP_COMPLETION_PDF);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }

    public function viewRestoreProgressAsPst(){
            $headers = array(
                    'token'     => $this->session->get('token'),
                    'Accept' => 'application/json',
                    'loginUserName' => $this->session->get('userName'),
                    'batchId' => !empty($_POST['batchId']) ? $_POST['batchId'] : ''
            );

            $result = $this->_model->viewRestoreProgressAsPst($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'progress'  => $result['body']->{'restoreProgressEventsElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "No Restore in Queue"
                    );
                    echo json_encode($result);
                    exit();
                case (202):
                    $result = array(
                        'result' => 'restore_completed',
                        'msg' => "Restore completed successfully"
                    );
                    echo json_encode($result);
                    exit();
                case (421):
		    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function capacityManagementReport($reportProductType){
        if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        Auth::allowOnly('readOnlyAdmin');
        $backupPolicies=[];
        if($reportProductType == 'backup'){
        $backupResult=$this->_model->getAllpolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>$reportProductType));
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }
        }
        $odbPolicies=[];
        $exchangePolicies=[];
        $sharepointPolicies=[];
        if($reportProductType == 'sharepoint'){
                $resultSharepoint = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Sharepoint'));
                if(!empty($resultSharepoint['body']->{'stringList'})){
                foreach((array)$resultSharepoint['body']->{'stringList'} as $value){
                        $sharepointPolicy = $value;
                        $sharepointPolicies = array_merge(array($sharepointPolicy), $sharepointPolicies);
                }
            }
        }
        if($reportProductType == 'onedrive'){
                $resultODB = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'ODB'));
            if(!empty($resultODB['body']->{'stringList'})){
            	foreach((array)$resultODB['body']->{'stringList'} as $value){
                        $odbPolicy = $value;
                        $odbPolicies = array_merge(array($odbPolicy), $odbPolicies);
                }
            }
        }
        if($reportProductType == 'exchange'){
                $resultExchange = $this->_model->getAllOfficePolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Exchange'));
            if(!empty($resultExchange['body']->{'stringList'})){
                foreach((array)$resultExchange['body']->{'stringList'} as $value){
                        $exchangePolicy = $value;
                        $exchangePolicies = array_merge(array($exchangePolicy), $exchangePolicies);
                }
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('capacityManagementReport'),
            'active' => 'report',
            'reportProductType' => $reportProductType,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'loggedInUserReadOnlyAdmin' => $this->session->get('readOnlyAdmin'),
            'backupPolicies'=>array_reverse($backupPolicies),
            'odbPolicies'=>array_reverse($odbPolicies),
            'exchangePolicies'=>array_reverse($exchangePolicies),
            'sharepointPolicies'=>array_reverse($sharepointPolicies)
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/capacityManagementReport', $data);
        View::renderTemplate('footer', $data);
    }

    public function getFileSize($sizeInKB){
        $bytes = ($sizeInKB*1024);
        if ($bytes >= 1073741824){
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }elseif ($bytes >= 1048576){
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }elseif ($bytes >= 1024){
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }elseif ($bytes > 1){
            $bytes = $bytes . ' bytes';
        }elseif ($bytes == 1){
            $bytes = $bytes . ' byte';
        }else{
            $bytes = '0 bytes';
        }
        return $bytes;
    }

    public function getCapacityManagementReport(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token' => $this->session->get('token'),
                'Accept' => 'application/json',
                'productType' => $_POST['reportProductType']
            );
            if($_POST['policyName'] == 'all' || $_POST['policyName'] == null || $_POST['policyName'] == ['all']){
            $_POST['policyName'] = [];
            }
            if(!isset($_POST['userName']) || $_POST['userName']=='all' || $_POST['userName']=='undefined' || $_POST['userName']==null || $_POST['userName'] == 'null'){
             $_POST['userName']='';
            }
            if(!isset($_POST['deviceName']) || $_POST['deviceName'] == null || $_POST['deviceName'] == 'null' || $_POST['deviceName'] == 'all' || $_POST['deviceName'] == 'undefined'){
            $_POST['deviceName'] = '';
            }
            $data = array(
                'policyNames'  => $_POST['policyName']
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getCapacityManagementReport($headers,$data);
            switch ($result['status']) {
                case (200):
                    $totalCpCompressedStorage = 0;
                if(!empty($result['body']->{'data'}->{'devicePolicyDetailsList'})){
                        foreach($result['body']->{'data'}->{'devicePolicyDetailsList'} as $value){
                            $value->{'cpActualFileSize'} = $this->getFileSize((int)$value->{'cpActualFileSize'}/1024);
                            $value->{'cpCompressedStorage'} = $this->getFileSize((int)$value->{'cpCompressedStorage'}/1024);
                        }
                        $this->log("totalCpCompressedStorage : ".$result['header']->{'container'}['totalCpCompressedStorage'],"info");
			$totalCpCompressedStorage = $this->getFileSize(((int)$result['header']->{'container'}['totalCpCompressedStorage']/1024));
			$totalCpActualFileSize = $this->getFileSize(((int)$result['header']->{'container'}['totalCpActualFileSize']/1024));
                }
                if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                        $metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'noBackup' => !empty($result['body']->{'data'}->{'devicePolicyDetailsList'}) ? $result['body']->{'data'}->{'devicePolicyDetailsList'} : [],
			'totalCpCompressedStorage' => $totalCpCompressedStorage,
			'totalCpActualFileSize' => $totalCpActualFileSize,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function deleteRestoresEndpoint(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'batchId'       => $_POST['batchId']
            );
            $result = $this->_model->deleteRestores($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function licenseOptimizer(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
	);
	$serverMgmt = $this->session->get('serverMgmt');
	$data['serverMgmt'] = $serverMgmt;
	if($this->session->get('Windows_Server_Backup_Enabled') == 'true'){
                $data['Windows_Server_Backup_Enabled'] = 'yes';
        }else{
                $data['Windows_Server_Backup_Enabled'] = 'no';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('backup/licenseOptimizer', $data);
        View::renderTemplate('footer', $data);
    }

    public function sendMailWelcomeMail(){
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );
	$emailProps = array(
		'action' => 'create-server',
		'actionOn' => $_POST['serverName'],
		'actionBy' => $this->session->get('userName'),
		'cloudName' => $this->session->get('cloudName'),
                        );
        $result = $this->_model->sendMailWelcomeMail($headers, $emailProps);
        switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Operation performed successfully.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
			'result' => 'fail',
			'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function mspProvisioning(){
//        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => 'MSP Provisioning',
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/mspProvisioning', $data);
        View::renderTemplate('footer', $data);
    }

    public function getCustomerList(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'Username' => 'testqauser',
                'Password' => 'ParaBlu@153'
            );
            $result = $this->_model->getCustomerList($headers);
            $customerList = [];
            if(!empty($result['body'])){
                    foreach($result['body'] as $value){
                        $customer = array(
                            'customerId' => !empty($value->{'customerId'}) ? (string)$value->{'customerId'} : '',
                            'mspId' => !empty($value->{'mspId'}) ? (string)$value->{'mspId'} : '',
                            'customerName' => !empty($value->{'customerName'}) ? (string)$value->{'customerName'} : '',
                            'customerEmail' => !empty($value->{'customerEmail'}) ? (string)$value->{'customerEmail'} : '',
                            'customerUserFirstName' =>!empty($value->{'customerUserFirstName'}) ? (string)$value->{'customerUserFirstName'} : '',
			    'customerUserLastName' => !empty($value->{'customerUserLastName'}) ? (string)$value->{'customerUserLastName'} : '',
			    'phoneNumber' => !empty($value->{'phoneNumber'}) ? (string)$value->{'phoneNumber'} : '',
                            'active' => $value->{'active'},
                            'suspend' => $value->{'suspend'},
                            'activationTimeStamp' => !empty($value->{'activationTimeStamp'}) ? (int)$value->{'activationTimeStamp'} : '',
                            'activationTime' => !empty($value->{'activationTimeStamp'}) ? date('d-M-y H:i:s', (((int)$value->{'activationTimeStamp'}) / 1000)) : '',
                            'lastModified' => !empty($value->{'lastModified'}) ? (int)$value->{'lastModified'} : '',
                            'lastModifiedTime' => !empty($value->{'lastModified'}) ? date('d-M-y H:i:s', (((int)$value->{'lastModified'}) / 1000)) : '',
                            'creationReferenceNumber' => !empty($value->{'creationReferenceNumber'}) ? (string)$value->{'creationReferenceNumber'} : '',
                            'modifiedReferenceNumber' => !empty($value->{'modifiedReferenceNumber'}) ? (string)$value->{'modifiedReferenceNumber'} : '',
                        );

                        $customerList = array_merge(array($customer), $customerList);
                    }
                }
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Customer list loaded successfully',
                        'customerList' => $customerList
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
		    echo json_encode($result);
		    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getBaseSubscriptionId(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'Username' => 'testqauser',
                'Password' => 'ParaBlu@153',
                'view-model' => 'BASE_PLAN_VIEW'
	    );
	    $result = $this->_model->getCustomerInfo($headers, $_POST['customerId']);
            $response = array(
                        'result' => 'success',
                        'msg' => 'Customer Info loaded successfully',
                        'baseSubscriptionId' => $result['body'][0]->{'baseSubscriptionId'},
                        'skuName' => $result['body'][0]->{'skuName'}
                    );
                    echo json_encode($response);
                    exit;
    }

    public function getAddOnBasedOnBaseSubscriptionId(){
        $headersAddOns = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'Username' => 'testqauser',
                'Password' => 'ParaBlu@153',
                'view-model' => 'ADDON_PLAN_VIEW'
            );
            $resultAddOns = $this->_model->getCustomerAddOnInfo($headersAddOns, $_POST['baseSubscriptionId']);
            $this->log("ADD-ONs : ".count($resultAddOns['body']),"info");
            $addonList = [];
            if(!empty($resultAddOns['body'])){
                    foreach($resultAddOns['body'] as $value){
                        $baseSubscriptionId = (string)$value->{'baseSubscriptionId'};
                        $addon = array(
                            'addonSubscriptionId' => !empty($value->{'addonSubscriptionId'}) ? (string)$value->{'addonSubscriptionId'} : '',
                            'baseSubscriptionId' => !empty($value->{'baseSubscriptionId'}) ? (string)$value->{'baseSubscriptionId'} : '',
                            'skuName' => !empty($value->{'skuName'}) ? (string)$value->{'skuName'} : '',
                            'active' => ($value->{'active'} == true) ? 'Yes' : 'No',
                            'activationTimeStamp' => !empty($value->{'activationTimeStamp'}) ? (int)$value->{'activationTimeStamp'} : '',
                            'activationTime' => !empty($value->{'activationTimeStamp'}) ? date('d-M-y H:i:s', (((int)$value->{'activationTimeStamp'}) / 1000)) : '',
                            'lastModified' => !empty($value->{'lastModified'}) ? (int)$value->{'lastModified'} : '',
                            'lastModifiedTime' => !empty($value->{'lastModified'}) ? date('d-M-y H:i:s', (((int)$value->{'lastModified'}) / 1000)) : '',
                            'numQuantity' => !empty($value->{'numQuantity'}) ? (string)$value->{'numQuantity'} : '-',
                            'creationReferenceNumber' => !empty($value->{'creationReferenceNumber'}) ? (string)$value->{'creationReferenceNumber'} : '',
                            'modifiedReferenceNumber' => !empty($value->{'modifiedReferenceNumber'}) ? (string)$value->{'modifiedReferenceNumber'} : '',
			);
			$addonList = array_merge(array($addon), $addonList);
                    }
            }
            $this->log("ADD-ONs List: ".json_encode($addonList),"info");
            $response = array(
                        'result' => 'success',
                        'addOnList' => $addonList
                    );
                    echo json_encode($response);
                    exit;
    }

    public function getCustomerInfo(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'Username' => 'testqauser',
                'Password' => 'ParaBlu@153',
                'view-model' => 'BASE_PLAN_VIEW'
            );
            $result = $this->_model->getCustomerInfo($headers, $_POST['customerId']);
            $customerInfo = [];
            $customer = [];
            if(!empty($result['body'])){
                    foreach($result['body'] as $value){
                        $baseSubscriptionId = (string)$value->{'baseSubscriptionId'};
                        $customer = array(
                            'baseSubscriptionId' => !empty($value->{'baseSubscriptionId'}) ? (string)$value->{'baseSubscriptionId'} : '',
                            'customerId' => !empty($value->{'customerId'}) ? (string)$value->{'customerId'} : '',
                            'skuName' => !empty($value->{'skuName'}) ? (string)$value->{'skuName'} : '',
                            'active' => ($value->{'active'} == true) ? 'Yes' : 'No',
                            'activationTimeStamp' => !empty($value->{'activationTimeStamp'}) ? (int)$value->{'activationTimeStamp'} : '',
                            'activationTime' => !empty($value->{'activationTimeStamp'}) ? date('d-M-y H:i:s', (((int)$value->{'activationTimeStamp'}) / 1000)) : '',
                            'lastModified' => !empty($value->{'lastModified'}) ? (int)$value->{'lastModified'} : '',
                            'lastModifiedTime' => !empty($value->{'lastModified'}) ? date('d-M-y H:i:s', (((int)$value->{'lastModified'}) / 1000)) : '',
                            'numQuantity' => !empty($value->{'numQuantity'}) ? (string)$value->{'numQuantity'} : '-',
                            //'numberOfAddOns' => count($resultAddOns['body'])
			);
			//$customerInfo = array_merge(array($customer), $customerInfo);
                    }
            }
            $this->log("baseSubscriptionId : ".$baseSubscriptionId,"info");
            $headersAddOns = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'Username' => 'testqauser',
                'Password' => 'ParaBlu@153',
                'view-model' => 'ADDON_PLAN_VIEW'
            );
            $resultAddOns = $this->_model->getCustomerAddOnInfo($headersAddOns, $baseSubscriptionId);
            $this->log("ADD-ONs : ".count($resultAddOns['body']),"info");
            $this->log("customerInfo : ".json_encode($customer),"info");
            $customer['numberOfAddOns'] = count($resultAddOns['body']);
            $addonList = [];
            if(!empty($resultAddOns['body'])){
                    foreach($resultAddOns['body'] as $value){
                        $baseSubscriptionId = (string)$value->{'baseSubscriptionId'};
                        $addon = array(
                            'addonSubscriptionId' => !empty($value->{'addonSubscriptionId'}) ? (string)$value->{'addonSubscriptionId'} : '',
                            'baseSubscriptionId' => !empty($value->{'baseSubscriptionId'}) ? (string)$value->{'baseSubscriptionId'} : '',
                            'skuName' => !empty($value->{'skuName'}) ? (string)$value->{'skuName'} : '',
                            'active' => ($value->{'active'} == true) ? 'Yes' : 'No',
                            'activationTimeStamp' => !empty($value->{'activationTimeStamp'}) ? (int)$value->{'activationTimeStamp'} : '',
                            'activationTime' => !empty($value->{'activationTimeStamp'}) ? date('d-M-y H:i:s', (((int)$value->{'activationTimeStamp'}) / 1000)) : '',
                            'lastModified' => !empty($value->{'lastModified'}) ? (int)$value->{'lastModified'} : '',
                            'lastModifiedTime' => !empty($value->{'lastModified'}) ? date('d-M-y H:i:s', (((int)$value->{'lastModified'}) / 1000)) : '',
                            'numQuantity' => !empty($value->{'numQuantity'}) ? (string)$value->{'numQuantity'} : '-',
                            'creationReferenceNumber' => !empty($value->{'creationReferenceNumber'}) ? (string)$value->{'creationReferenceNumber'} : '',
                            'modifiedReferenceNumber' => !empty($value->{'modifiedReferenceNumber'}) ? (string)$value->{'modifiedReferenceNumber'} : '',
			);
			$addonList = array_merge(array($addon), $addonList);
                    }
            }
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Customer Info loaded successfully',
                        'customerInfo' => $customer,
                        'addonList' => $addonList
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
		    );
		    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function generateTokenFromOrderCenter(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json',
                'Username' => 'testqauser',
                'Password' => 'ParaBlu@153',
                'msp-client' => 'mantest'//$this->session->get('cloudName'),
            );
            $result = $this->_model->generateTokenFromOrderCenter($headers);
            if($result['status'] == 202){
                    return $result['body']->{'token'};
            }else{
            switch ($result['status']) {
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
		    echo json_encode($result);
		    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
            }
    }

    public function addSingleCustomer(){
	    $token = $this->generateTokenFromOrderCenter();
                $this->log("Generated Token : ".$token,"info");
                $headersCreate = array(
                        'Content-Type'  => 'application/json',
                        'Accept' => 'application/json',
                        'api-key' => $token,
                        'msp-client' => 'mantest',//$this->session->get('cloudName'),
                        'action' => $_POST['action']
                );

                $data = array(
                        "customerName"          => $_POST['customerName'],
                        "userFirstName"         => $_POST['userFirstName'],
                        "userLastName"          => $_POST['userLastName'],
                        "userEmail"             => $_POST['userEmail'],
                        "userPhoneNumber"       => $_POST['userPhoneNumber'],
                        "actionType"            => $_POST['actionType'],
                        "skuCode"               => $_POST['skuCode'],
                        "numQuantity"           => $_POST['numQuantity']
                );
                $this->log("Customer Details : ".json_encode($data),"info");
                $result = $this->_model->addSingleCustomer($headersCreate, $data);
                switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Customer added successfully'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
		    echo json_encode($result);
		    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function modifySingleCustomer(){
                $token = $this->generateTokenFromOrderCenter();
                $this->log("Generated Token : ".$token,"info");
                $headersCreate = array(
                        'Content-Type'  => 'application/json',
                        'Accept' => 'application/json',
                        'api-key' => $token,
                        'msp-client' => 'mantest',//$this->session->get('cloudName'),
                        'action' => $_POST['actionM']
                );

                $data = array(
                        "actionType"            => $_POST['actionTypeM'],
                        "subscriptionID"        => $_POST['subscriptionID'],
                        "skuCode"               => $_POST['skuCodeM']
                );
                if($_POST['actionTypeM'] == 'CHANGE_BASE_PLAN'){
                        $data['skuCode'] = $_POST['skuCodeM'];
                }
                if($_POST['actionTypeM'] == 'ACTIVATE_ADDON'){
                        $data['skuCode'] = $_POST['skuCodeMP'];
                }
                $this->log("Update Details : ".json_encode($data),"info");
                $result = $this->_model->modifySingleCustomer($headersCreate, $data);
                switch ($result['status']) {
                case (200):
                    if($_POST['actionTypeM'] == 'CHANGE_BASE_PLAN'){
                        $msg = 'Changed Base Plan successfully for ';
                    }else if($_POST['actionTypeM'] == 'ACTIVATE_ADDON'){
                        $msg = 'Add-on successfully added for ';
                    }else if($_POST['actionTypeM'] == 'CHANGE_ADDON_QUANTITY'){
                        $msg = 'Changed Add-on quantity successfully for ';
                    }
                    $response = array(
                        'result' => 'success',
                        'msg' => $msg
                    );
                    echo json_encode($response);
		    exit;
		    case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function performAction(){
        $token = $this->generateTokenFromOrderCenter();
                $this->log("Generated Token : ".$token,"info");
                $headersCreate = array(
                        'Content-Type'  => 'application/json',
                        'Accept' => 'application/json',
                        'api-key' => $token,
			'msp-client' => 'mantest',//$this->session->get('cloudName'),
			'action' => 'Execute'
                );

                $data = array(
                        "actionType"            => $_POST['actionType'],
                        "subscriptionID"        => $_POST['baseSubscriptionId']
                );
                $this->log("Update Details : ".json_encode($data),"info");
                $result = $this->_model->modifySingleCustomer($headersCreate, $data);
                switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => ucfirst(strtolower($_POST['actionType'])).' performed successfully on '
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
		    echo json_encode($result);
		    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

}
