<?php

namespace Controllers;
require_once(DIRECTORY_PATH.'/Helpers/Paraview/Classes/PhpOffice/PhpSpreadsheet/IOFactory.php');
use Core\View;
use Models\Backup;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Core\Controller;
use Helpers\Url;
use Helpers\Auth;
use Helpers\Paraview\docReader;
use Helpers\Paraview\docxReader;
use Helpers\Paraview\odtReader;
use Helpers\Paraview\XMLExtractor;
use Models\ParaView;
use Models\Sync;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * ParaView controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com (Please do not remove this author thing, i worte man, :)
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ParaViewController extends Controller{

    /**
     * Below variable contains the object reference of a model
     * @version 1.0
     * @var object
     */

    protected $_model;
    protected $_codeLength = 6;

    /**
     * The below variable holds the data of the base path the file location
     * @version 1.0
     * @var string
     */
    var $filePath = PARAVIEW_TMP_PATH;

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedExtensions = array('pdf', 'docx', 'odt', 'txt', 'xls','xlsx', 'ods', 'pptx', 'ppt', 'doc', 'log');

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedImageExtensions = array('png', 'jpg', 'jpeg', 'gif', 'tiff', 'TIF', 'tif');

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedVideoExtensions = array('mp4', 'avi', 'webm', 'ogg');

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        if(SHARE_LOGIN_CHECK) {
            $this->auth->loginCheck();
        }
        $this->auth->tokenCheck();
        $this->language->load('index');
        $this->_model = new ParaView();
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function reader(){
        if(!empty($_POST['fileName']) && !empty($_POST['path'])) {
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token' => $this->session->get('token'),
                'path' => $_POST['path'].'/'.$_POST['fileName'],
		'fileRevisionId' => $_POST['fileRevisionId']
            );
	    $sync = new Sync();
	    $backup = new Backup();
            $result = $sync->getFileInfo($headers);
            switch ($result['status']) {
                case (200):
		    //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
		    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = $this->filePath;
                    $this->cleanUpTempDirectory($fullPath);

                    $headers['file-name'] = (string)$result['body']->{'file-name'};
                    $headers['file-path'] = rtrim($_POST['path'], '/');
                    $headers['userName'] = $this->session->get('userName');
                    $headers['syncRevisionId'] = (string)$result['body']->{'file-revision-id'};
		    $headers['blukryptIp'] = $_POST['blukryptIp'];
		    $headers['backupID'] = (string)$result['body']->{'file-revision-id'};
		    $headers['deviceUUID'] = 'Portal';
		    $headers['isSync'] = 'true';
		    $headers1['fileName'] = base64_encode((string)$result['body']->{'file-name'});
                    $headers1['filePath'] = base64_encode(rtrim($_POST['path'], '/'));
		    $headers1['userName'] = base64_encode($this->session->get('userName'));
		    $headers1['loginUserName'] = base64_encode($this->session->get('userName'));
                    $headers1['syncRevisionId'] = (string)$result['body']->{'file-revision-id'};
                    $headers1['blukryptIp'] = $_POST['blukryptIp'];
                    $headers1['backupID'] = (string)$result['body']->{'file-revision-id'};
                    $headers1['deviceUUID'] = 'Portal';
		    $headers1['isSync'] = 'true';
		    $headers1['path'] = $_POST['path'].$_POST['fileName'];
		    $headers1['isDownload'] = 'false';
		    $headers1['token'] = $this->session->get('token');
		    //$fileContent = $sync->download($headers);
		    $fileContent = $backup->download($headers1);
                    if($fileContent['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
			    'status' => $fileContent['status'],
			    'msg' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                        ));
                        exit;
                    }

                    //$fileFullPath   = $fullPath.ltrim($result['body']->{'file-name'}, DS);
		    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $fileContent['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);
                    if(in_array($extension, $this->allowedImageExtensions)) {
                        $this->sendImageData($_POST['fileName']);
                    }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                        $this->sendVideoData($_POST['fileName']);
                    }elseif(in_array($extension, $this->allowedExtensions)) {
			if($extension == 'log'){
                    		$extension = 'logExt';
                	}
                        if(method_exists($this, $extension)){
                            $this->$extension();
                        }else{
                            $data = array(
                                'result' => 'fail',
                                'msg' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                            );
                            $jsonDoc = json_encode($data);
                            echo $jsonDoc;
                            exit;
                        }
                    }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file format is not supported'
                        );
                        $jsonDoc = json_encode($data);
                        echo $jsonDoc;
                        exit;
                    }
                    break;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'No file was passed to view'
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function backupReader(){
        if(!empty($_POST['fileName']) && !empty($_POST['filePath'])) {
            $backup = new Backup();
            $result['status'] = 200;
            switch ($result['status']) {
                case (200):
		    //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
		    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = $this->filePath;
                    $this->cleanUpTempDirectory($fullPath);

                    $file['fileName'] = base64_encode($_POST['fileName']);
                    $file['filePath'] = base64_encode(rtrim($_POST['filePath'], '/'));
                    $file['userName'] = base64_encode($_POST['userName']);
		    $file['loginUserName'] = base64_encode($_POST['userName']);
		    $file['loginUserName'] = base64_encode($this->session->get('userName'));
                    $file['backupID'] = $_POST['backupId'];
		    $file['deviceUUID'] = !empty($_POST['deviceUUID']) ? $_POST['deviceUUID'] : '';
                    //$file['deviceUUID'] = "";
                    $file['isSync'] = $_POST['isSync'];
                    $file['cloudName'] = $this->session->get("cloudName");
		    $file['blukryptIp'] = $_POST['blukryptIp'];
		    $file['isDownload'] = 'false';
                    $fileContent = $backup->download($file);
                    if($fileContent['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
			    'status' => $fileContent['status'],
			    'msg' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                        ));
                        exit;
                    }
                    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $fileContent['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);
                    if(in_array($extension, $this->allowedImageExtensions)) {
                        $this->sendImageData($_POST['fileName']);
                    }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                        $this->sendVideoData($_POST['fileName']);
                    }elseif(in_array($extension, $this->allowedExtensions)) {
			if($extension == 'log'){
                    		$extension = 'logExt';
                	}
                        if(method_exists($this, $extension)){
                            $this->$extension();
                        }else{
                            $data = array(
                                'result' => 'fail',
                                'msg' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                            );
                            $jsonDoc = json_encode($data);
                            echo $jsonDoc;
                            exit;
                        }
                    }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file format is not supported'
                        );
                        $jsonDoc = json_encode($data);
                        echo $jsonDoc;
                        exit;
                    }
                    break;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'No file was passed to view'
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function sharedFileReader(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['syncRevisionId'])){
		//$_POST['fileName'] = urldecode($_POST['fileName']);
		//$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
		$_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
		$_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		$t=time();
		$_POST['fileName'] = $t.$_POST['fileName'];
		$checkForShareWith = !empty($_POST['shareWith']) ? true : false;

	     if($_POST['passwordProtected'] == 'enabled' && $checkForShareWith == false){
            //if($this->session->get('passwordProtected') == true && $checkForShareWith == false){
                if(!empty($_POST['password'])){
		    if($_POST['passwordHash'] != md5($_POST['password'])){
                    //if($this->session->get('passwordHash') != md5($_POST['password'])){
                        echo json_encode(array(
                            'result' => 'fail',
                            'message' => 'Password Authentication Failed'
                        ));
                        exit;
                    }
                }else{
                    echo json_encode(array(
                        'result' => 'fail',
                        'message' => 'Password Authentication Failed'
                    ));
                    exit;
                }
            }
if(multifactorAuthWithAccessCode == false){		
	    if($_POST['googleAuth'] == 'enabled'){
//		    if($_POST['secretKeyList'] != ''){
		    //email list present block starts
		    $secretList = $_POST['secretKeyList'];
		    $this->log("got list : ".$_POST['secretKeyList'],"info");
		    $newsecretlist = explode(',',$secretList);
		    $this->log("newsecretlist : ".json_encode($newsecretlist),"info");
		    foreach ($newsecretlist as $value) {
                	$this->log("LOOP of SECRET : ".$value,"info");
	                $checkResult = $this->verifyCode($value, $_POST['code'], 2);
        		if($checkResult){
                		$result = 'Success';
        		}else{
                		$result = 'Failed';
        		}
			if($result == 'Success'){
				break;
			}
		    }
		    $this->log("resulttttttt after code verification : ".$result,"info");
		    if($result != 'Success'){
		    	$result = array(
		    		'result' => 'fail',
		    		'asdasd' => $result,
		    		'message' => 'Google Authentication Code verification failed'
		    	);
		    	echo json_encode($result);
		    	exit();
		    }
		    //email list present block ends
		//}
	    }
}
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $headers['file-name'] = base64_encode($_POST['fileName']);
            $headers['file-path'] = base64_encode(rtrim($_POST['path'], '/'));
            $headers['userName'] = $_POST['userName'];
            $headers['syncRevisionId'] = $_POST['syncRevisionId'];
	    $headers['cloudName'] = $_POST['cloudName'];
		
	    $headers1['fileName'] = base64_encode($_POST['fileName']);
	    $headers1['filePath'] = base64_encode(rtrim($_POST['path'], '/'));
	    $headers1['userName'] = base64_encode($_POST['userName']);
	    if($_POST['userId'] == ''){
                $_POST['userId'] = 'Unknown User';
            }
	    $headers1['loginUserName'] = !empty($this->session->get('userName')) ? base64_encode($this->session->get('userName')) : base64_encode($_POST['userId']);
	    $headers1['cloudName'] = $_POST['cloudName'];
	    $headers1['syncRevisionId'] = $_POST['syncRevisionId'];
	    $headers1['blukryptIp'] = !empty($_POST['blukryptIp']) ? $_POST['blukryptIp'] : '';
	    $headers1['backupID'] = $_POST['syncRevisionId'];
	    $headers1['deviceUUID'] = 'Portal';
	    $headers1['isSync'] = 'true';
	    $headers1['path'] = $_POST['path'].$_POST['fileName'];
	    $headers1['isDownload'] = 'false';
	    //$sync = new Sync();
	    $backup = new Backup();
	    //$fileContent = $sync->downloadShare($headers);
	    $fileContent = $backup->downloadShare($headers1);
            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
		    'status' => $fileContent['status'],
		    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }
            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);
            if(in_array($extension, $this->allowedImageExtensions)) {
                $this->sendImageData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                $this->sendVideoData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedExtensions)) {
		if($extension == 'log'){
                    	$extension = 'logExt';
                }
                if(method_exists($this, $extension)){
                    $this->$extension();
                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }
        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function sharedBackupFileReader(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['backupID'])){
                    //$_POST['fileName'] = urldecode($_POST['fileName']);
                    //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
                    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;
	    if($_POST['passwordProtected'] == 'enabled' && $checkForShareWith == false){
            //if($this->session->get('passwordProtected') == true && $checkForShareWith == false){
                if(!empty($_POST['password'])){
		    if($_POST['passwordHash'] != md5($_POST['password'])){
                    //if($this->session->get('passwordHash') != md5($_POST['password'])){
                        echo json_encode(array(
                            'result' => 'fail',
                            'message' => 'Password Authentication Failed'
                        ));
                        exit;
                    }
                }else{
                    echo json_encode(array(
                        'result' => 'fail',
                        'message' => 'Password Authentication Failed'
                    ));
                    exit;
                }
            }
	    if($_POST['googleAuth'] == 'enabled'){
//		    if($_POST['secretKeyList'] != ''){
		    //email list present block starts
		    $secretList = $_POST['secretKeyList'];
		    $this->log("got list : ".$_POST['secretKeyList'],"info");
		    $newsecretlist = explode(',',$secretList);
		    $this->log("newsecretlist : ".json_encode($newsecretlist),"info");
		    foreach ($newsecretlist as $value) {
                	$this->log("LOOP of SECRET : ".$value,"info");
	                $checkResult = $this->verifyCode($value, $_POST['code'], 2);
        		if($checkResult){
                		$result = 'Success';
        		}else{
                		$result = 'Failed';
        		}

			if($result == 'Success'){
				break;
			}
		    }
		    $this->log("resulttttttt after code verification : ".$result,"info");
		    if($result != 'Success'){
        		$result = array(
        			'result' => 'fail',
        			'asdasd' => $result,
        			'message' => 'Google Authentication Code verification failed'
        		);
        		echo json_encode($result);
        		exit();
		    }
		    //email list present block ends
		//}
	    }
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $file['fileName'] = base64_encode($_POST['fileName']);
            $file['filePath'] = base64_encode(rtrim($_POST['path'], '/'));
            $file['userName'] = base64_encode($_POST['userName']);
	    $file['loginUserName'] = base64_encode($_POST['userName']);
            $file['backupID'] = $_POST['backupID'];
            $file['deviceUUID'] = "";
            $file['isSync'] = $_POST['isSync'];
            //$file['cloudName'] = $this->session->get("cloudName");
	    $file['cloudName'] = $_POST['cloudName'];
	    $file['isDownload'] = 'false';
            $backup = new Backup();
            $fileContent = $backup->downloadShare($file);
            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
		    'status' => $fileContent['status'],
		    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }
            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);
            if(in_array($extension, $this->allowedImageExtensions)) {
                $this->sendImageData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                $this->sendVideoData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedExtensions)) {
		if($extension == 'log'){
                    	$extension = 'logExt';
                }
                if(method_exists($this, $extension)){
                    $this->$extension();
                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }
        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will paraview only odt formats
     */
    /*public function odt(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $extract = new OdtReader();
                $extract->odtPath = $this->filePath . $_POST['fileName'];
                $extract->content_folder = 'temp';
                $extract->image_max_width = '10000';
                $extract->imagePathPrefix = '';
                $extract->keepOriginalImage = true;
                $extract->Init();
                $doc = str_replace('<p>Â&nbsp;</p>', ' ', $extract->output);
                $doc['type'] = 'odt';
                $jsonDoc = json_encode($doc);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }*/

    /**
     * Below function will read only pdf formats
     * #toolbar=0 Add this to iframe url after file url to disable toolbar for pdf viewer
     */
    public function pdf(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $data = array(
                    'html' => '<iframe seamless="" style="margin-top: -50px;" width="100%" height="600" src="'.Url::basePath('pdfViewer?').'file=app/templates/default/documents/'.$_POST['fileName'].'"></iframe>',
                    'type' => 'pdf'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function pdfViewer(){
        View::render('paraview/pdf');
    }

    /**
     * below function excepts $filename a parameter
     * generates a link to view that file
     * @param $fileName
     */
    public function sendImageData($fileName){
        if(!empty($fileName)) {
            $_POST['fileName'] = rawurlencode(html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5));
            if(file_exists($this->filePath . $fileName)) {
                $data = array(
                    'html' => '<img style="max-height: 500px" src="'.Url::templatePath('default/documents/'.$_POST['fileName']).'">',
		    'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
                    'type' => 'image'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /**
     * below function excepts $filename a parameter
     * generates a link to view that video file
     * @param $fileName
     */
    public function sendVideoData($fileName){
        if(!empty($fileName)) {
            $_POST['fileName'] = rawurlencode(html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5));
            if(file_exists($this->filePath . $fileName)) {
                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                $mimeType = finfo_file($finfo, $this->filePath . $fileName);
                finfo_close($finfo);
                $data = '<video height="500" controls>';
                $data .= '<source src="'.Url::templatePath('default/documents/'.$_POST['fileName']).'" type="'.$mimeType.'">';
                $data .= "I'm sorry; your browser doesn't support HTML5 video in WebM with VP8 or MP4 with H.264.";
                $data .= '</video>';
                $data = array(
                    'html' => $data,
                    'type' => 'image'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function convertArrayToStylesString($style){
        $string = '';
        if(is_array($style)){
            foreach($style as $key => $value){
                $string .= $key . ': ' . $value . ';';
            }
            return $string;
        }else{
            return '';
        }

    }

    public function cleanUpTempDirectory($fullPath){
        $files = glob($fullPath.DS.'{,.}*', GLOB_BRACE);
        foreach($files as $file){
            if(is_file($file)){
                unlink($file);
            }
        }
    }

    public function readFileFromUpload($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }

        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $username = array();
        $test = array();
        $rowData = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
            }
            array_push($pageWiseData, $data);
        }                
        $pageWiseData = array_unique($pageWiseData);
        $this->log('Result_Test11: '.json_encode($test), 'info');
        $this->log('Result_PagewiseData: '.json_encode($pageWiseData), 'info');
        $this->log('Result_PagewiseData0000: '.json_encode($pageWiseData[0]), 'info');
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            	$this->log('Result_$1111: ', 'info');
		foreach($pageData as $rowDatar){
		    $this->log('Result_$2222: ', 'info');
			if(!empty($rowDatar[0])) {
			    foreach( $rowDatar[0] as $key => $value ) {                        
				if($value == 'User Name'){
				    $userNameColumnNumber = $key;
				}                                            
			    }                    
			}
		}   
        }        
$this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
foreach($pageWiseData as $pageKey => $pageData){
        $this->log('Result_$1111: ', 'info');
        foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        $this->log('KEY : '.$key.' : VALUE : '.$value, 'info');
                        
                        if($key === $userNameColumnNumber && $value != ''){
                        $data = (string)$value;
                        }
                        $username = array_merge(array($data), $username);                                           
                    }
                }
            }            
        }
	$username = array_keys(array_flip($username));
	$this->log('NEEEEEEEEEEEEEEE: '.json_encode($username), 'info');
        $html[$pageKey] = array(
                /*'sheetName' => $sheetName,
		'id' => $sheetId,*/
                'userNames' => $username
        );
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html)
        );//$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }

    public function readFileFromUploadForDevices($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }
        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
		if($rowData[0][0] != ''){
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
		}
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData) || !in_array($data, $rowData)) {
                array_push($data, $rowData);
                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');               
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
            $even = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');

// -------------------------------------------------------------------------------------
	foreach($pageWiseData as $pageKey => $pageData){
		$this->log('Result_$1111: ', 'info');
		foreach($pageData as $rowDatar){
		    $this->log('Result_$2222: ', 'info');
			if(!empty($rowDatar[0])) {
			    foreach( $rowDatar[0] as $key => $value ) {
				if($value == 'Asset Name'){
				    $deviceNameColumnNumber = $key;
				}
				if($value == 'User Name'){
				    $userNameColumnNumber = $key;
				}
			    }
			}
		    }   
	}
        $this->log('CAUTCH KEY FOR deviceName COLUMN: '.$deviceNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
	foreach($pageWiseData as $pageKey => $pageData){
                $this->log('Result_$1111: ', 'info');
                foreach($pageData as $rowDatar){
                    $this->log('Result_$2222: ', 'info');
                        if(!empty($rowDatar[0])) {
                            foreach( $rowDatar[0] as $key => $value ) {
                                $this->log('KEY : '.$key.' : VALUE : '.$value, 'info');
                                if($key === $deviceNameColumnNumber && $value !== ''){
                                    $this->log('CCCCCCCCCCAAAAAAAAAAMMMMMMMEE : ', 'info');
                                $deviceName[]['deviceName'] = $value;
                                }
                                if($key === $userNameColumnNumber && $value !== ''){
                                $userName[]['userName'] = $value;
                                }
                            }
                        }
                }                    
        }
        
        $this->log('Result_DEVICENAMEEEEEE: '.json_encode($deviceName), 'info');
        $this->log('Result_USERNAMEEEEEEEE: '.json_encode($userName), 'info');
	function unique_key($array,$keyname){
		$new_array = array();
	 	foreach($array as $key=>$value){
	   		if(!isset($new_array[$value[$keyname]])){
	     			$new_array[$value[$keyname]] = $value;
	   		}
	 	}
 		$new_array = array_values($new_array);
 		return $new_array;
	}
	$this->log('Result_USERNAMEEEEEEEE_newone: '.json_encode(unique_key($userName,'userName')), 'info');
	$this->log('Result_DEVICENAMEEEEEE_COUNT: '.count($deviceName), 'info');
        $this->log('Result_USERNAMEEEEEEEE_COUNT: '.count($userName), 'info');
	//$userName = unique_key($userName,'userName');
	if(count($deviceName) != count($userName)){
	$resultData1 = array(
            'result' => 'fail_samecolumn',
            'msg' => 'fileds missing'
        );
        return json_encode($resultData1);
	}
	for($i=1;$i<sizeof($deviceName);$i++){
		if(count($userName) !=0 && count($deviceName) !=0 ){
			$bigDog[] = array_merge($userName[$i],$deviceName[$i]);
		}
		if(count($userName) ==0 && count($deviceName) !=0 ){
			$bigDog[] = array_merge($deviceName[$i]);
		}
		if(count($userName) !=0 && count($deviceName) ==0 ){
			$bigDog[] = array_merge($userName[$i]);
		}
		if(count($userName) ==0 && count($deviceName) ==0 ){
			$bigDog[] = array_merge($userName[$i],$deviceName[$i]);
		}
	}
	$this->log('Result_BBBBBBBIIIIIIIIIGGGGGGGGG: '.json_encode($bigDog), 'info');
	if(count($userName)-1 == 0){
	$resultData1 = array(
		    'result' => 'fail_usernames',
		    'msg' => 'usernames missing'
		);
		return json_encode($resultData1);
	}
	if(count($deviceName)-1 == 0){
	$resultData1 = array(
		    'result' => 'fail_devicenames',
		    'msg' => 'devicenames missing'
		);
		return json_encode($resultData1);
	}
// -------------------------------------------------------------------------------------       
        $new = array('deviceList' => $bigDog);                
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];                        
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }                
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                /*'sheetName' => $sheetName,
		'id' => $sheetId,*/
                'userNames' => $htmlData
            );
        }                        
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'deviceList' => $new
        );$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }

    public function readFileFromUploadForCreateUsers($fileName){
        if(empty($fileName) || !file_exists($this->filePath.$fileName)) {
		if(empty($fileName)) {
		    $resultData = array(
			'result' => 'fail',
			'msg' => 'The File format is not yet support'
		    );
		}
		if(!file_exists($this->filePath.$fileName)) {
		    $resultData = array(
			'result' => 'fail',
			'msg' => 'Selected file was not found' .$this->filePath.$fileName
		    );
		}
		return json_encode($resultData);
        }

        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');
                
            }
            array_push($pageWiseData, $data);
        }                        
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
        $even = array();
        $emailId = array();
        $username = array();
        $password = array();
        $displayname = array();
        $department = array();
        $location = array();
        $policyname = array();
        $syncPolicyName = array();
        $o365PolicyName = array();
	$exchangePolicyName = array();
        $spPolicyName = array();
        $oneDrivePolicyName = array();
        $odbId = array();
	$googleSecretKey = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');        
        foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
            foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        if($value == 'Email Id'){
                            $emailIdColumnNumber = $key;
                        }
                        if($value == 'User Name'){
                            $userNameColumnNumber = $key;
                        }
                        if($value == 'Password'){
                            $passwdHashColumnNumber = $key;
                        }
                        if($value == 'Display Name'){
                            $displayNameColumnNumber = $key;
                        }
                        if($value == 'Department'){
                            $departmentColumnNumber = $key;
                        }
                        if($value == 'Location'){
                            $locationColumnNumber = $key;
                        }
                        if($value == 'BluVault Policy Name'){
                            $policyNameColumnNumber = $key;
                        }
                        if($value == 'BluSync Policy Name'){
                            $syncPolicyNameColumnNumber = $key;
                        }
                        if($value == 'Microsoft Exchange Policy Name'){
                            $exchangePolicyNameColumnNumber = $key;
                        }
                        if($value == 'Sharepoint Policy Name'){
                            $spPolicyNameColumnNumber = $key;
                        }
                        if($value == 'OneDrive for Business Policy Name'){
                            $oneDrivePolicyNameColumnNumber = $key;
                        }
                        if($value == 'Backup Target'){
                            $odbLoginIdColumnNumber = $key;
                        }                        
                    }                    
                }
            }   
        }
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('CAUTCH KEY FOR emailId COLUMN: '.$emailIdColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR passwdHashColumnNumber COLUMN: '.$passwdHashColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR displayNameColumnNumber COLUMN: '.$displayNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR departmentColumnNumber COLUMN: '.$departmentColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR locationColumnNumber COLUMN: '.$locationColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR policyNameColumnNumber COLUMN: '.$policyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR syncPolicyNameColumnNumber COLUMN: '.$syncPolicyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR exchangePolicyNameColumnNumber COLUMN: '.$exchangePolicyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR spPolicyNameColumnNumber COLUMN: '.$spPolicyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR oneDrivePolicyNameColumnNumber COLUMN: '.$oneDrivePolicyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR odbLoginIdColumnNumber COLUMN: '.$odbLoginIdColumnNumber, 'info');
        foreach($pageWiseData as $pageKey => $pageData){
                $this->log('Result_$1111: ', 'info');
                foreach($pageData as $rowDatar){
                    $this->log('Result_$2222: ', 'info');
                        if(!empty($rowDatar[0])) {
                            for($k=0;$k< 12;$k++){
				$this->log('NEEEEEEEWWWWWWWWW COUNT : '.$k, 'info');
				if(empty($rowDatar[0][$k])){
                                        $rowDatar[0][$k] = '';
                                }
                                $this->log('NEEEEEEE COUNT : '.$rowDatar[0][$k], 'info');
                                if($k === $emailIdColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $emailId[]['emailId'] = $rowDatar[0][$k];
                                    }else{
                                        $emailId[]['emailId'] = '';
                                    }
                                }
                                if($k === $userNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $username[]['userName'] = $rowDatar[0][$k];
                                    }else{
                                        $username[]['userName'] = '';
                                    }
                                }
                                if($k === $passwdHashColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $password[]['passwdHash'] = $rowDatar[0][$k];
                                    }else{
                                        $password[]['passwdHash'] = '';
                                    }
                                }
                                if($k === $displayNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $displayname[]['displayName'] = $rowDatar[0][$k];
                                    }else{
                                        $displayname[]['displayName'] = '';
                                    }
                                }
                                if($k === $departmentColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $department[]['department'] = $rowDatar[0][$k];
                                    }else{
                                        $department[]['department'] = '';
                                    }
                                }
                                if($k === $locationColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $location[]['location'] = $rowDatar[0][$k];
                                    }else{
                                        $location[]['location'] = '';
                                    }
                                }
                                if($k === $policyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $policyname[]['policyName'] = $rowDatar[0][$k];
                                    }else{
                                        $policyname[]['policyName'] = '';
                                    }
                                }
                                if($k === $syncPolicyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $syncPolicyName[]['syncPolicyName'] = $rowDatar[0][$k];
                                    }else{
                                        $syncPolicyName[]['syncPolicyName'] = '';
                                    }
                                }
                                if($k === $exchangePolicyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $exchangePolicyName[]['exchangePolicyName'] = $rowDatar[0][$k];
                                    }else{
                                        $exchangePolicyName[]['exchangePolicyName'] = '';
                                    }
				}
                                if($k === $spPolicyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $spPolicyName[]['spPolicyName'] = $rowDatar[0][$k];
                                    }else{
                                        $spPolicyName[]['spPolicyName'] = '';
                                    }
                                }
                                if($k === $oneDrivePolicyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $oneDrivePolicyName[]['oneDrivePolicyName'] = $rowDatar[0][$k];
                                    }else{
                                        $oneDrivePolicyName[]['oneDrivePolicyName'] = '';
                                    }
                                }
                                if($k === $odbLoginIdColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $odbId[]['odbLoginId'] = $rowDatar[0][$k];
                                    }else{
                                        $odbId[]['odbLoginId'] = '';
                                    }
                                }
                            }
                        }
                }
        }
        $this->log('COUNT USERNAME : '.count($username), 'info');
        $this->log('Result_EMAILID: '.json_encode($emailId), 'info');
        $this->log('Result_USERNAME: '.json_encode($username), 'info');
        $this->log('Result_PASSWORD: '.json_encode($password), 'info');
        $this->log('Result_DIAPLAYNAME: '.json_encode($displayname), 'info');
        $this->log('Result_DEPARTMENT: '.json_encode($department), 'info');
        $this->log('Result_LOCATION: '.json_encode($location), 'info');
        $this->log('Result_POLICYNAME: '.json_encode($policyname), 'info');
        $this->log('Result_SYNCPOLICYNAME: '.json_encode($syncPolicyName), 'info');
        $this->log('Result_EXCHANGEPOLICYNAME: '.json_encode($exchangePolicyName), 'info');
        $this->log('Result_SPPOLICYNAME: '.json_encode($spPolicyName), 'info');
        $this->log('Result_ONEDRIVEPOLICYNAME: '.json_encode($oneDrivePolicyName), 'info');
        $this->log('Result_ODBID: '.json_encode($odbId), 'info');
        $this->log('Result_$4999999: '.json_encode($even), 'info');
        $this->log('Result_$5999999: '.json_encode($odd), 'info');
        $this->log('Result_$4999999count: '.json_encode(count($even)), 'info');
        $this->log('Result_$5999999count: '.json_encode(count($odd)), 'info');
        $sizeOfEven = count($emailId);
        $sizeOfOdd = count($username);
        $this->log('Result_EMAILID_COUNT: '.$sizeOfEven, 'info');
        $this->log('Result_USERNAME_COUNT: '.$sizeOfOdd, 'info');
        $this->log('Result_EMAILID_COUNT: '.count($emailId), 'info');
        $this->log('Result_USERNAME_COUNT: '.count($username), 'info');
        $this->log('Result_PASSWORD_COUNT: '.count($password), 'info');
        $this->log('Result_DIAPLAYNAME_COUNT: '.count($displayname), 'info');
        $this->log('Result_DEPARTMENT_COUNT: '.count($department), 'info');
        $this->log('Result_LOCATION_COUNT: '.count($location), 'info');
        $this->log('Result_POLICYNAME_COUNT: '.count($policyname), 'info');
        $this->log('Result_SYNCPOLICYNAME_COUNT: '.count($syncPolicyName), 'info');
        $this->log('Result_EXCHANGEPOLICYNAME_COUNT: '.count($exchangePolicyName), 'info');
        $this->log('Result_SHAREPOINTPOLICYNAME_COUNT: '.count($spPolicyName), 'info');
        $this->log('Result_ONEDRIVEPOLICYNAME_COUNT: '.count($oneDrivePolicyName), 'info');
        $this->log('Result_ODBID_COUNT: '.count($odbId), 'info');	    
	$countSecretKey = count($emailId) - 1;
	$this->log('Result_GOOGLE_SECRET_KEY_COUNT: '.$countSecretKey, 'info');
	for($j=1; $j<=$countSecretKey; $j++){
		$secret = $this->createSecret();
		$this->log("SECRET KEY for ".$j." is --: ".$secret,"info");
		$secretA = array("googleSecretKey" => $secret);
		$googleSecretKey = array_merge(array($secretA), $googleSecretKey);
	}	    	    
        for($j=0; $j<count($username);$j++ ) {
                if($username[$j]['userName'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_usernames',
                        'msg' => 'usernames missing'
                    );
                    return json_encode($resultData1);
                }
               
        }
        for($j=0; $j<count($emailId);$j++ ) {
                if($emailId[$j]['emailId'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_emailId',
                        'msg' => 'email id missing'
                    );
                    return json_encode($resultData1);
                }               
        }        
        if($sizeOfEven == $sizeOfOdd){
            if(!empty($emailId) && !empty($username)){
                for($i=1;$i<sizeof($emailId);$i++){
                    
                    $dog[] = array_merge($emailId[$i],$username[$i]);
                }
            }
        }else{
            $resultData = array(
            	'result' => 'fail'
            );
            return json_encode($resultData);            
        }
        for($i=1;$i<sizeof($emailId);$i++){
        	$this->log('Result_gggggggggggggggggggggggggggggggggg: ','info');
        	$bigDog[] = array_merge($emailId[$i],$username[$i],$password[$i],$displayname[$i],$department[$i],$policyname[$i],$syncPolicyName[$i],$exchangePolicyName[$i],$spPolicyName[$i],$oneDrivePolicyName[$i],$location[$i],$odbId[$i],$googleSecretKey[$i-1]);
        }
        $this->log('Result_datacgARRAYFILL: '.json_encode($even),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($odd),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($dog),'info');
        $this->log('Result_BIGDOG: '.json_encode($bigDog),'info');
        function combineStringArrayWithDuplicates ($even, $odd) {
		$iter = 0;
		$combined = '';
                foreach ($even as $key) 
                    { 
                        $combined[$iter] = $key .": ". $odd[$iter];
                        $iter++;                        
                    }
                    return $combined;
                }
                $combined = combineStringArrayWithDuplicates($even, $odd);
                $this->log('Result_datacgjjjjjjjjjjjjjjjj: '.json_encode($combined), 'info');
                //$new = array('deviceList' => $combined);
                $new = array('userList' => $bigDog);       
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];                        
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }                        
            $this->log('Result_KKKKKKKKKhtmlData: '.json_encode($htmlData), 'info');   
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                /*'sheetName' => $sheetName,
		'id' => $sheetId,*/
                'userNames' => $htmlData
            );
        }
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'userList' => $new
        );$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }
	
    public function sharedFileReaderShareView(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['syncRevisionId'])){
            //$_POST['fileName'] = urldecode($_POST['fileName']);
            //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
            $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
            $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
            $t=time();
            $_POST['fileName'] = $t.$_POST['fileName'];
            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $headers['file-name'] = $_POST['fileName'];
            $headers['file-path'] = rtrim($_POST['path'], '/');
            $headers['userName'] = $_POST['userName'];
            $headers['syncRevisionId'] = $_POST['syncRevisionId'];
	    $headers['isDownload'] = 'false';
            $sync = new Sync();
            $fileContent = $sync->download($headers);
            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
		    'status' => $fileContent['status'],
		    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }
            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
	    fwrite($myFile, $txt);
            fclose($myFile);
            if(in_array($extension, $this->allowedImageExtensions)) {
                $this->sendImageData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                $this->sendVideoData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedExtensions)) {
		if($extension == 'log'){
                    	$extension = 'logExt';
                }
                if(method_exists($this, $extension)){		    
                    $this->$extension();		    
                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
		echo $jsonDoc;
                exit;
            }
        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }
	
    public function sharedBackupFileReaderShareView(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['backupID'])){
            //$_POST['fileName'] = urldecode($_POST['fileName']);
            //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
            $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
            $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
            $t=time();
            $_POST['fileName'] = $t.$_POST['fileName'];

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;            
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);
            $file['fileName'] = $_POST['fileName'];
            $file['filePath'] = rtrim($_POST['path'], '/');
            $file['userName'] = $_POST['userName'];
            $file['backupID'] = $_POST['backupID'];
            $file['deviceUUID'] = "";
            $file['isSync'] = $_POST['isSync'];
            $file['cloudName'] = $this->session->get("cloudName");
	    $file['isDownload'] = 'false';
            $backup = new Backup();
            $fileContent = $backup->download($file);
            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
		    'status' => $fileContent['status'],
		    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }
            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);
            if(in_array($extension, $this->allowedImageExtensions)) {
                $this->sendImageData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                $this->sendVideoData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedExtensions)) {
		if($extension == 'log'){
                    	$extension = 'logExt';
                }
                if(method_exists($this, $extension)){		    
                    $this->$extension();		    
                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }
        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }
	
    public function pptx(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
                    'type' => 'pptx'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }
	
    public function ppt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
                    'type' => 'pptx'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }
	
    public function doc(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                /*$data = array(
                    'html' => nl2br(file_get_contents($this->filePath.$fileName)),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);*/
                    $jsonDoc = json_encode(Url::templatePath('default/documents/'.$_POST['fileName']));
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }
	
    public function docx(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {                
                 $jsonDoc = json_encode(Url::templatePath('default/documents/'.$_POST['fileName']));
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }
	
    public function xls(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $data = array(
                'type' => 'excel',
                'fileName' => Url::templatePath('default/documents/'.$_POST['fileName'])
        //    'html' => array_values($html)
        );
        echo json_encode($data);
    }
	
    public function xlsx(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $this->log("first : ".$_POST['fileName'],"info");
        $data = array(
                'type' => 'excel',
                'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
           // 'html' => array_values($html)
    );
//      $this->log("------------> ".json_encode($data),"info");
        echo json_encode($data);
    }
	
    public function txt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
		$data = file_get_contents($this->filePath.$fileName);
		$jsonDoc = $data;
                /*$data = array(
                    'html' => file_get_contents($this->filePath.$fileName),
                    'fileName' => $_POST['fileName'],
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);*/
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }
	
    public function readFileFromUploadForPolicyMapping($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }
        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                if($rowData[0][0] != ''){
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData) || !in_array($data, $rowData)) {
                array_push($data, $rowData);
                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
        $even = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');

// -------------------------------------------------------------------------------------
	foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
            foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        if($value == 'User Name'){
                            $userNameColumnNumber = $key;
                        }
                        if($value == 'Policy Name'){
                            $policyNameColumnNumber = $key;
                        }
                    }
                }
            }
        }
        $this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR policyName COLUMN: '.$policyNameColumnNumber, 'info');
	$kkww = array();
	foreach($pageWiseData as $pageKey => $pageData){
                $this->log('Result_$1111: ', 'info');
                foreach($pageData as $rowDatar){
                    $this->log('Result_$2222: ', 'info');
                        if(!empty($rowDatar[0])) {
                            foreach( $rowDatar[0] as $key => $value ) {
                                $this->log('KEY : '.$key.' : VALUE : '.$value, 'info');
                                /*if($key === $deviceNameColumnNumber && $value !== ''){
                                    $this->log('CCCCCCCCCCAAAAAAAAAAMMMMMMMEE : ', 'info');
                                $deviceName[]['deviceName'] = $value;
                                }*/
                                if($key === $userNameColumnNumber && $value !== ''){
                                	$userName[]['userName'] = $value;
					array_push($kkww,$value);
                                }
                                if($key === $policyNameColumnNumber && $value !== ''){
                                	$this->log('CCCCCCCCCCAAAAAAAAAAMMMMMMMEE : ', 'info');
                                	$policyName[]['policyName'] = $value;
                                }
                            }
                        }
                }
        }
        $this->log('Result_USERNAMEEEEEEEE: '.json_encode($userName), 'info');
        $this->log('Result_POLICYNAMEEEEEE: '.json_encode($policyName), 'info');
	array_shift($kkww);
	function unique_key($array,$keyname){
		$new_array = array();
		foreach($array as $key=>$value){
			if(!isset($new_array[$value[$keyname]])){
				$new_array[$value[$keyname]] = $value;
			}
		}
		$new_array = array_values($new_array);
	return $new_array;
	}
	$this->log('Result_USERNAMEEEEEEEE_newone: '.json_encode(unique_key($userName,'userName')), 'info');
	$this->log('Result_DEVICENAMEEEEEE_COUNT: '.count($policyName), 'info');
        $this->log('Result_USERNAMEEEEEEEE_COUNT: '.count($userName), 'info');
	//$userName = unique_key($userName,'userName');
	if(count($userName) != count($policyName)){
	$resultData1 = array(
		    'result' => 'fail_samecolumn',
		    'msg' => 'fileds missing'
		);
		return json_encode($resultData1);
	}
	for($i=1;$i<sizeof($policyName);$i++){
                    if(count($userName) !=0 && count($policyName) !=0 ){
                        $bigDog[] = array_merge($userName[$i],$policyName[$i]);
                    }
                    if(count($userName) ==0 && count($policyName) !=0 ){
			$bigDog[] = array_merge($policyName[$i]);
                    }
                    if(count($userName) !=0 && count($policyName) ==0 ){
			$bigDog[] = array_merge($userName[$i]);
                    }
                    if(count($userName) ==0 && count($policyName) ==0 ){
			$bigDog[] = array_merge($userName[$i],$policyName[$i]);
                    }
                }
	$this->log('Result_BBBBBBBIIIIIIIIIGGGGGGGGG: '.json_encode($bigDog), 'info');
	if(count($userName)-1 == 0){
	$resultData1 = array(
		    'result' => 'fail_usernames',
		    'msg' => 'usernames missing'
		);
		return json_encode($resultData1);

	}
	if(count($policyName)-1 == 0){
	$resultData1 = array(
		    'result' => 'fail_policynames',
		    'msg' => 'policy names missing'
		);
		return json_encode($resultData1);
	}
// -------------------------------------------------------------------------------------

        $new = array('policyMappingList' => $bigDog);
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                            /*'sheetName' => $sheetName,
			    'id' => $sheetId,*/
                	     'userNames' => $htmlData
		            );
        }
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
	    'kkww' => $kkww,
            'deviceList' => $new
        );$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }
    
    public function readFileFromUploadOld($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }

        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $username = array();
        $test = array();
        $rowData = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
            	foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
            }
            array_push($pageWiseData, $data);
        }
        $pageWiseData = array_unique($pageWiseData);
        $this->log('Result_Test11: '.json_encode($test), 'info');
        $this->log('Result_PagewiseData: '.json_encode($pageWiseData), 'info');
        $this->log('Result_PagewiseData0000: '.json_encode($pageWiseData[0]), 'info');
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
            foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
            	if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {

                        if($value == 'User Name'){
                            $userNameColumnNumber = $key;
                        }
                    }
                }
            }
        }
	$this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
	foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
            foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        $this->log('KEY : '.$key.' : VALUE : '.$value, 'info');

                        if($key === $userNameColumnNumber && $value != ''){
                        $data = (string)$value;
                        }
                        $username = array_merge(array($data), $username);
                    }
                }
            }
        }
	$username = array_keys(array_flip($username));
	$this->log('NEEEEEEEEEEEEEEE: '.json_encode($username), 'info');
        $html[$pageKey] = array(
                /*'sheetName' => $sheetName,
		'id' => $sheetId,*/
                'userNames' => $username
            );
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html)
        );//$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }	
	
    /*----------------------------------------*/
	//protected $_codeLength = 6;

    /**
     * Create new secret.
     * 16 characters, randomly chosen from the allowed base32 characters.
     *
     * @param int $secretLength
     * @return string
     */
    public function createSecret($secretLength = 16)
    {
        $validChars = $this->_getBase32LookupTable();
        unset($validChars[32]);

        $secret = '';
        for ($i = 0; $i < $secretLength; $i++) {
            $secret .= $validChars[array_rand($validChars)];
        }
        return $secret;
    }

    /**
     * Calculate the code, with given secret and point in time
     *
     * @param string $secret
     * @param int|null $timeSlice
     * @return string
     */
    public function getCode($secret, $timeSlice = null){
        if ($timeSlice === null) {
            $timeSlice = floor(time() / 30);
        }

        $secretkey = $this->_base32Decode($secret);

        // Pack time into binary string
        $time = chr(0).chr(0).chr(0).chr(0).pack('N*', $timeSlice);
        // Hash it with users secret key
        $hm = hash_hmac('SHA1', $time, $secretkey, true);
        // Use last nipple of result as index/offset
        $offset = ord(substr($hm, -1)) & 0x0F;
        // grab 4 bytes of the result
        $hashpart = substr($hm, $offset, 4);

        // Unpak binary value
        $value = unpack('N', $hashpart);
        $value = $value[1];
        // Only 32 bits
        $value = $value & 0x7FFFFFFF;

        $modulo = pow(10, $this->_codeLength);
        return str_pad($value % $modulo, $this->_codeLength, '0', STR_PAD_LEFT);
    }
/**
     * Get QR-Code URL for image, from google charts
     *
     * @param string $name
     * @param string $secret
     * @param string $title
     * @return string
     */
    public function getQRCodeGoogleUrl($name, $secret, $title = null) {
        $urlencoded = urlencode('otpauth://totp/'.$name.'?secret='.$secret.'');
    	if(isset($title)) {
                $urlencoded .= urlencode('&issuer='.urlencode($title));
        }
        return 'https://chart.googleapis.com/chart?chs=200x200&chld=M|0&cht=qr&chl='.$urlencoded.'';
    }
    /**
     * Check if the code is correct. This will accept codes starting from $discrepancy*30sec ago to $discrepancy*30sec from now
     *
     * @param string $secret
     * @param string $code
     * @param int $discrepancy This is the allowed time drift in 30 second units (8 means 4 minutes before or after)
     * @param int|null $currentTimeSlice time slice if we want use other that time()
     * @return bool
     */
    public function verifyCode($secret, $code, $discrepancy = 1, $currentTimeSlice = null){
        if ($currentTimeSlice === null) {
            $currentTimeSlice = floor(time() / 30);
        }

        for ($i = -$discrepancy; $i <= $discrepancy; $i++) {
            	$calculatedCode = $this->getCode($secret, $currentTimeSlice + $i);
		$this->log("CODE : ".json_encode($code),"info");
		$this->log("getCODE : ".json_encode($calculatedCode),"info");
            	if ($calculatedCode == $code ) {
			return true;
            	}
        }
        return false;
    }

    /**
     * Set the code length, should be >=6
     *
     * @param int $length
     * @return GoogleAuthenticator
     */
    public function setCodeLength($length)
    {
        $this->_codeLength = $length;
        return $this;
    }
    /**
     * Helper class to decode base32
     *
     * @param $secret
     * @return bool|string
     */
    protected function _base32Decode($secret){
        if (empty($secret)) return '';
        $base32chars = $this->_getBase32LookupTable();
        $base32charsFlipped = array_flip($base32chars);
        $paddingCharCount = substr_count($secret, $base32chars[32]);
        $allowedValues = array(6, 4, 3, 1, 0);
        if (!in_array($paddingCharCount, $allowedValues)) return false;
        for ($i = 0; $i < 4; $i++){
        if ($paddingCharCount == $allowedValues[$i] &&
                substr($secret, -($allowedValues[$i])) != str_repeat($base32chars[32], $allowedValues[$i])) return false;
        }
        $secret = str_replace('=','', $secret);
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i = $i+8) {
            $x = "";
            if (!in_array($secret[$i], $base32chars)) return false;
            for ($j = 0; $j < 8; $j++) {
                $x .= str_pad(base_convert(@$base32charsFlipped[@$secret[$i + $j]], 10, 2), 5, '0', STR_PAD_LEFT);
            }
            $eightBits = str_split($x, 8);
            for ($z = 0; $z < count($eightBits); $z++) {
                $binaryString .= ( ($y = chr(base_convert($eightBits[$z], 2, 10))) || ord($y) == 48 ) ? $y:"";
            }
        }
        return $binaryString;
    }

    /**
     * Helper class to encode base32
     *
     * @param string $secret
     * @param bool $padding
     * @return string
     */
    protected function _base32Encode($secret, $padding = true){
        if (empty($secret)) return '';
        $base32chars = $this->_getBase32LookupTable();
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i++) {
    		$binaryString .= str_pad(base_convert(ord($secret[$i]), 10, 2), 8, '0', STR_PAD_LEFT);
        }
        $fiveBitBinaryArray = str_split($binaryString, 5);
        $base32 = "";
        $i = 0;
        while ($i < count($fiveBitBinaryArray)) {
            $base32 .= $base32chars[base_convert(str_pad($fiveBitBinaryArray[$i], 5, '0'), 2, 10)];
            $i++;
        }
        if ($padding && ($x = strlen($binaryString) % 40) != 0) {
            if ($x == 8) $base32 .= str_repeat($base32chars[32], 6);
            elseif ($x == 16) $base32 .= str_repeat($base32chars[32], 4);
            elseif ($x == 24) $base32 .= str_repeat($base32chars[32], 3);
            elseif ($x == 32) $base32 .= $base32chars[32];
        }
        return $base32;
    }
    /**
     * Get array with all 32 characters for decoding from/encoding to base32
     *
     * @return array
     */
    protected function _getBase32LookupTable(){
        return array(
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', //  7
            'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', // 15
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', // 23
            'Y', 'Z', '2', '3', '4', '5', '6', '7', // 31
            '='  // padding char
        );
    }
/*----------------------------------------*/
	
    public function readerGetting(){
                $extension = 'pdf';
                if(file_exists('/var/www/portal/app/templates/default/collateral/gettingStarted.pdf')){
                        $data = array(
                            'html' => '<iframe seamless="" style="margin-top: -50px;" width="100%" height="600" src="'.Url::basePath('pdfViewer?').'file=app/templates/default/collateral/gettingStarted.pdf"></iframe>',
                            'type' => 'pdf'
                        );
                        $jsonDoc = json_encode($data);
                }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file was not found'
                        );
                        $jsonDoc = json_encode($data);
                }
                echo $jsonDoc;
    }
	
    public function viewFileUrlReader(){
            $this->log("inside viewFileUrlReader","info");
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['backupID'])){
                    //$_POST['fileName'] = urldecode($_POST['fileName']);
                    //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
                    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
                    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $file['fileName'] = base64_encode($_POST['fileName']);
            $file['filePath'] = base64_encode(rtrim($_POST['path'], '/'));
            $file['userName'] = base64_encode($_POST['userName']);
            $file['loginUserName'] = base64_encode($_POST['userName']);
            $file['backupID'] = $_POST['backupID'];
            $file['deviceUUID'] = $_POST['deviceUUID'];
            $file['isSync'] = $_POST['isSync'];
            //$file['cloudName'] = $this->session->get("cloudName");
            $file['cloudName'] = $_POST['cloudName'];
	    $file['attachName'] = $_POST['attachName'];
	    $file['isDownload'] = 'false';
            $backup = new Backup();
            $fileContent = $backup->downloadShare($file);
            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }
	    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);
            if(in_array($extension, $this->allowedImageExtensions)) {
                $this->sendImageData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedVideoExtensions)) {
                $this->sendVideoData($_POST['fileName']);
            }elseif(in_array($extension, $this->allowedExtensions)) {
                if(method_exists($this, $extension)){
                    $this->$extension();
                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later. Try the download option.'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported, Try the download option.'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }
        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }
	
    public function logExt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = file_get_contents($this->filePath.$fileName);
                $jsonDoc = $data;
                /*$data = array(
                    'html' => file_get_contents($this->filePath.$fileName),
                    'fileName' => $_POST['fileName'],
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);*/
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }

    public function odt(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                 $jsonDoc = json_encode(Url::templatePath('default/documents/'.$_POST['fileName']));
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function ods(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $this->log("first : ".$_POST['fileName'],"info");
        $data = array(
                'type' => 'excel',
                'fileName' => Url::templatePath('default/documents/'.$_POST['fileName'])          
        );
        echo json_encode($data);
    }

    /*msp start*/
    public function readFileFromUploadForCreateUsersMsp($fileName){
        if(empty($fileName) || !file_exists($this->filePath.$fileName)) {
		if(empty($fileName)) {
		    $resultData = array(
			'result' => 'fail',
			'msg' => 'The File format is not yet support'
		    );
		}
		if(!file_exists($this->filePath.$fileName)) {
		    $resultData = array(
			'result' => 'fail',
			'msg' => 'Selected file was not found' .$this->filePath.$fileName
		    );
		}
		return json_encode($resultData);
        }

        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');
                
            }
            array_push($pageWiseData, $data);
        }                        
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
        $even = array();
        $emailId = array();
        $username = array();
        $password = array();
        $displayname = array();
        $department = array();
        $location = array();
        $policyname = array();
        $syncPolicyName = array();
        $o365PolicyName = array();
	$exchangePolicyName = array();
        $spPolicyName = array();
        $oneDrivePolicyName = array();
        $odbId = array();
	$googleSecretKey = array();
	$suspended = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');        
        foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
            foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        if($value == 'Email Id'){
                            $emailIdColumnNumber = $key;
                        }                        
                    }                    
                }
            }   
        }
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('CAUTCH KEY FOR emailId COLUMN: '.$emailIdColumnNumber, 'info');
        foreach($pageWiseData as $pageKey => $pageData){
                $this->log('Result_$1111: ', 'info');
                foreach($pageData as $rowDatar){
                    $this->log('Result_$2222: ', 'info');
                        if(!empty($rowDatar[0])) {
                            for($k=0;$k< 12;$k++){
				$this->log('NEEEEEEEWWWWWWWWW COUNT : '.$k, 'info');
				if(empty($rowDatar[0][$k])){
                                        $rowDatar[0][$k] = '';
                                }
                                $this->log('NEEEEEEE COUNT : '.$rowDatar[0][$k], 'info');
                                if($k === $emailIdColumnNumber){
                                    if($rowDatar[0][$k] != ''){
					    $emailId[]['emailId'] = $rowDatar[0][$k];
					    $username[]['userName'] = $rowDatar[0][$k];
					    $policyname[]['policyName'] = $this->session->get('policyName');
					    $password[]['passwdHash'] = $this->generateRandomString();
					    $displayname[]['displayName'] = '';
					    $department[]['department'] = '';
					    $location[]['location'] = '';
					    $syncPolicyName[]['syncPolicyName'] = '';
					    $exchangePolicyName[]['exchangePolicyName'] = '';
					    $spPolicyName[]['spPolicyName'] = '';
					    $oneDrivePolicyName[]['oneDrivePolicyName'] = '';
					    $odbId[]['odbLoginId'] = '';
					    $suspended[]['suspended'] = true;
                                    }else{
                                        $emailId[]['emailId'] = '';
                                    }
                                }
                            }
                        }
                }
        }
        $this->log('COUNT USERNAME : '.count($username), 'info');
	$this->log('Result_EMAILID: '.json_encode($emailId), 'info');
//	$username = $emailId;
        $this->log('Result_USERNAME: '.json_encode($username), 'info');
        $this->log('Result_PASSWORD: '.json_encode($password), 'info');
        $this->log('Result_DIAPLAYNAME: '.json_encode($displayname), 'info');
        $this->log('Result_DEPARTMENT: '.json_encode($department), 'info');
        $this->log('Result_LOCATION: '.json_encode($location), 'info');
        $this->log('Result_POLICYNAME: '.json_encode($policyname), 'info');
        $this->log('Result_SYNCPOLICYNAME: '.json_encode($syncPolicyName), 'info');
        $this->log('Result_EXCHANGEPOLICYNAME: '.json_encode($exchangePolicyName), 'info');
        $this->log('Result_SPPOLICYNAME: '.json_encode($spPolicyName), 'info');
        $this->log('Result_ONEDRIVEPOLICYNAME: '.json_encode($oneDrivePolicyName), 'info');
        $this->log('Result_ODBID: '.json_encode($odbId), 'info');
        $this->log('Result_$4999999: '.json_encode($even), 'info');
        $this->log('Result_$5999999: '.json_encode($odd), 'info');
        $this->log('Result_$4999999count: '.json_encode(count($even)), 'info');
        $this->log('Result_$5999999count: '.json_encode(count($odd)), 'info');
        $sizeOfEven = count($emailId);
        $sizeOfOdd = count($username);
        $this->log('Result_EMAILID_COUNT: '.$sizeOfEven, 'info');
        $this->log('Result_USERNAME_COUNT: '.$sizeOfOdd, 'info');
        $this->log('Result_EMAILID_COUNT: '.count($emailId), 'info');
        $this->log('Result_USERNAME_COUNT: '.count($username), 'info');
        $this->log('Result_PASSWORD_COUNT: '.count($password), 'info');
        $this->log('Result_DIAPLAYNAME_COUNT: '.count($displayname), 'info');
        $this->log('Result_DEPARTMENT_COUNT: '.count($department), 'info');
        $this->log('Result_LOCATION_COUNT: '.count($location), 'info');
        $this->log('Result_POLICYNAME_COUNT: '.count($policyname), 'info');
        $this->log('Result_SYNCPOLICYNAME_COUNT: '.count($syncPolicyName), 'info');
        $this->log('Result_EXCHANGEPOLICYNAME_COUNT: '.count($exchangePolicyName), 'info');
        $this->log('Result_SHAREPOINTPOLICYNAME_COUNT: '.count($spPolicyName), 'info');
        $this->log('Result_ONEDRIVEPOLICYNAME_COUNT: '.count($oneDrivePolicyName), 'info');
        $this->log('Result_ODBID_COUNT: '.count($odbId), 'info');	    
	$countSecretKey = count($emailId) - 1;
	$this->log('Result_GOOGLE_SECRET_KEY_COUNT: '.$countSecretKey, 'info');
	for($j=1; $j<=$countSecretKey; $j++){
		$secret = $this->createSecret();
		$this->log("SECRET KEY for ".$j." is --: ".$secret,"info");
		$secretA = array("googleSecretKey" => $secret);
		$googleSecretKey = array_merge(array($secretA), $googleSecretKey);
	}	    	    
        /*for($j=0; $j<count($username);$j++ ) {
                if($username[$j]['userName'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_usernames',
                        'msg' => 'usernames missing'
                    );
                    return json_encode($resultData1);
                }
               
        }*/
        for($j=0; $j<count($emailId);$j++ ) {
                if($emailId[$j]['emailId'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_emailId',
                        'msg' => 'email id missing'
                    );
                    return json_encode($resultData1);
                }               
        }        
        /*if($sizeOfEven == $sizeOfOdd){
            if(!empty($emailId) && !empty($username)){
                for($i=1;$i<sizeof($emailId);$i++){
                    
                    $dog[] = array_merge($emailId[$i],$username[$i]);
                }
            }
        }else{
            $resultData = array(
            	'result' => 'fail'
            );
            return json_encode($resultData);            
        }*/
	for($i=1;$i<sizeof($emailId);$i++){		
        	$this->log('Result_gggggggggggggggggggggggggggggggggg: '.sizeof($emailId),'info');
        	$bigDog[] = array_merge($emailId[$i],$username[$i],$password[$i],$displayname[$i],$department[$i],$policyname[$i],$syncPolicyName[$i],$exchangePolicyName[$i],$spPolicyName[$i],$oneDrivePolicyName[$i],$location[$i],$odbId[$i],$googleSecretKey[$i-1],$suspended[$i]);
        }
        $this->log('Result_datacgARRAYFILL: '.json_encode($even),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($odd),'info');
        //$this->log('Result_datacgARRAYFILL: '.json_encode($dog),'info');
        $this->log('Result_BIGDOG: '.json_encode($bigDog),'info');
        function combineStringArrayWithDuplicates ($even, $odd) {
		$iter = 0;
		$combined = '';
                foreach ($even as $key) 
                    { 
                        $combined[$iter] = $key .": ". $odd[$iter];
                        $iter++;                        
                    }
                    return $combined;
                }
                $combined = combineStringArrayWithDuplicates($even, $odd);
                $this->log('Result_datacgjjjjjjjjjjjjjjjj: '.json_encode($combined), 'info');
                //$new = array('deviceList' => $combined);
                $new = array('userList' => $bigDog);       
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];                        
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }                        
            $this->log('Result_KKKKKKKKKhtmlData: '.json_encode($htmlData), 'info');   
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                /*'sheetName' => $sheetName,
		'id' => $sheetId,*/
                'userNames' => $htmlData
            );
        }
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'userList' => $new
	);
	$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
	$this->log('Result_resultDatahhhNEW: '.json_encode($new), 'info');
        return json_encode($resultData);
    }

    public function readFileFromUploadForCreateUsersMspServer($fileName){
        if(empty($fileName) || !file_exists($this->filePath.$fileName)) {
		if(empty($fileName)) {
		    $resultData = array(
			'result' => 'fail',
			'msg' => 'The File format is not yet support'
		    );
		}
		if(!file_exists($this->filePath.$fileName)) {
		    $resultData = array(
			'result' => 'fail',
			'msg' => 'Selected file was not found' .$this->filePath.$fileName
		    );
		}
		return json_encode($resultData);
        }
        $objPHPExcel = IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
        $highestRow1 = $sheet1->getHighestRow();
        $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
        $this->log('Result_row1: '.json_encode($row1), 'info');
        $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
        $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');

            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
        $even = array();
        $emailId = array();
        $username = array();
        $password = array();
        $displayname = array();
        $department = array();
        $location = array();
        $policyname = array();
        $syncPolicyName = array();
        $o365PolicyName = array();
	$exchangePolicyName = array();
        $spPolicyName = array();
        $oneDrivePolicyName = array();
        $odbId = array();
	$googleSecretKey = array();
	$userType = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');
        foreach($pageWiseData as $pageKey => $pageData){
            foreach($pageData as $rowDatar){
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        if($value == 'Server Name'){
                            $userNameColumnNumber = $key;
			}
			if($value == 'Password'){
                            $passwdHashColumnNumber = $key;
                        }
			if($value == 'Policy Name'){
                            $policyNameColumnNumber = $key;
                        }
                    }
                }
            }
        }
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        foreach($pageWiseData as $pageKey => $pageData){
                foreach($pageData as $rowDatar){
                        if(!empty($rowDatar[0])) {
                            for($k=0;$k< 12;$k++){
				$this->log('NEEEEEEEWWWWWWWWW COUNT : '.$k, 'info');
				if(empty($rowDatar[0][$k])){
                                        $rowDatar[0][$k] = '';
                                }
				$this->log('NEEEEEEE COUNT : '.$rowDatar[0][$k], 'info');
                                if($k === $userNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
					    $emailId[]['emailId'] = $rowDatar[0][$k].'@'.$this->session->get('domain').'.com';
					    $username[]['userName'] = $rowDatar[0][$k];
					    $password[]['passwdHash'] = $this->generateRandomString();
					    $displayname[]['displayName'] = '';
					    $department[]['department'] = '';
					    $location[]['location'] = '';
					    $syncPolicyName[]['syncPolicyName'] = '';
					    $exchangePolicyName[]['exchangePolicyName'] = '';
					    $spPolicyName[]['spPolicyName'] = '';
					    $oneDrivePolicyName[]['oneDrivePolicyName'] = '';
					    $odbId[]['odbLoginId'] = '';
                                    }else{
                                        $emailId[]['emailId'] = '';
                                    }
				}
				/*if($k === $passwdHashColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $password[]['passwdHash'] = $rowDatar[0][$k];
                                    }else{
                                        $password[]['passwdHash'] = '';
                                    }
				}*/
				if($k === $policyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $policyname[]['policyName'] = $rowDatar[0][$k];
                                    }else{
                                        $policyname[]['policyName'] = '';
                                    }
                                }
                            }
                        }
                }
        }
        $sizeOfEven = count($emailId);
        $sizeOfOdd = count($username);
	$countSecretKey = count($emailId) - 1;
	for($j=1; $j<=$countSecretKey; $j++){
		$secret = $this->createSecret();
		$secretA = array("googleSecretKey" => $secret);
		$googleSecretKey = array_merge(array($secretA), $googleSecretKey);
	}
	for($j=1; $j<=$countSecretKey; $j++){
                $userT = 'SERVER';
                $userTA = array("userType" => $userT);
                $userType = array_merge(array($userTA), $userType);
        }
        for($j=0; $j<count($emailId);$j++ ) {
                if($emailId[$j]['emailId'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_emailId',
                        'msg' => 'email id missing'
                    );
                    return json_encode($resultData1);
                }
        }
	for($i=1;$i<sizeof($emailId);$i++){
        	$bigDog[] = array_merge($emailId[$i],$username[$i],$password[$i],$displayname[$i],$department[$i],$policyname[$i],$syncPolicyName[$i],$exchangePolicyName[$i],$spPolicyName[$i],$oneDrivePolicyName[$i],$location[$i],$odbId[$i],$googleSecretKey[$i-1],$userType[$i-1]);
        }
        $this->log('Result_datacgARRAYFILL: '.json_encode($even),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($odd),'info');
        $this->log('Result_BIGDOG: '.json_encode($bigDog),'info');
        function combineStringArrayWithDuplicates ($even, $odd) {
		$iter = 0;
		$combined = '';
                foreach ($even as $key)
                    {
                        $combined[$iter] = $key .": ". $odd[$iter];
                        $iter++;
                    }
                    return $combined;
                }
                $combined = combineStringArrayWithDuplicates($even, $odd);
                $this->log('Result_datacgjjjjjjjjjjjjjjjj: '.json_encode($combined), 'info');
                //$new = array('deviceList' => $combined);
                $new = array('userList' => $bigDog);
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }
            $this->log('Result_KKKKKKKKKhtmlData: '.json_encode($htmlData), 'info');
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                /*'sheetName' => $sheetName,
		'id' => $sheetId,*/
                'userNames' => $htmlData
            );
        }
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'userList' => $new
	);
	$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
	$this->log('Result_resultDatahhhNEW: '.json_encode($new), 'info');
        return json_encode($resultData);
    }

    public function generateRandomString($length = 8) {
    	$characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+{}|[]\:";\'<>?,./';
    	$randomString = '';
    	// Shuffle the characters to create randomness
    	$shuffledChars = str_shuffle($characters);
    	// Select the first $length characters from the shuffled string
    	$randomString = substr($shuffledChars, 0, $length);
    	return $randomString;
    }
    /*msp stop*/

}
