<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use DOMDocument;
use Helpers\Url;
use Models\Index;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class IndexController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->auth->tokenCheck();
        $this->language->load('index');
        $this->_model = new Index();
	$this->session->put('session_cok2',$_COOKIE['PARABLU_INC']);
        /*if(Auth::checkUserPermission('readOnlyAdmin') == false){
            Url::redirect('myAccount');
        }*/
	if($this->session->get('localUser') != '1'){
		if(Auth::checkUserPermission('readOnlyAdmin') == false){
			$this->log("*******************Came inside indexcontroller for normal user condition*******************","info");
			if($this->session->get('redirectUrl') != '' && $this->session->get('redirectUrl') != '/portal/dashboard'){
                                Url::redirect($this->session->get('redirectUrl'));
                        }
			if($this->session->get('backupEnabled') == true|| $this->session->get('onedriveBkpEnabled') == true || $this->session->get('exchangeBkpEnabled') == true){
				$this->log("*******************Came inside indexcontroller if condition*******************","info");
				Url::redirect('backup/devices');
			}else{
				$this->log("*******************Came inside indexcontroller else condition*******************","info");
				Url::redirect('sync/files');
			}
		}
	}
    }

    /**
     * Define Index page title and load template files
     */
    public function index() {
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        /*if(Auth::checkCloudPermission('sync') == false && (Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('serverBackup') == true)){
            Url::redirect('server/dashboard');
        }elseif(Auth::checkCloudPermission('sync') == true && (Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('serverBackup') == false)){
            Url::redirect('sync/files');
        }*/
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        $data = array(
            'csrf_token' => $this->setCSRFToken(),
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
	    'loggedInUser' => $this->session->all(),
	    'loggedIn' => 'Yes'
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
        $data['showBackupOverview'] = true;
        $data['showBackupHistory'] = true;
        $data['showFailedBackupHistory'] = true;
        $data['showSystemsWithoutBackups'] = true;
        $data['showRestoreHistory'] = true;
        $data['showStorageUtilizationReport'] = true;
        $data['showDeviceHeartbeatReport'] = true;
        $data['showUserBackupSummary'] = true;
	$data['showBackupCompletionReport'] = false;
	$data['tile8ReportType'] = 'systemsWithoutBackup';
	$data['tile8ReportTypeOnedrive'] = 'systemsWithoutBackup';
	$data['tile8ReportTypeExchange'] = 'systemsWithoutBackup';
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $data['hideCompressedSize'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'hideCompressedSize'};
        $data['showBackupOverview'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupOverview'};
        $data['showBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupHistory'};
        $data['showFailedBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showFailedBackupHistory'};
	$data['showIncompleteBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showIncompleteBackupHistory'};
        $data['showSystemsWithoutBackups'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSystemsWithoutBackups'};
        $data['showRestoreHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showRestoreHistory'};
        $data['showStorageUtilizationReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showStorageUtilizationReport'};
        $data['showDeviceHeartbeatReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showDeviceHeartbeatReport'};
        $data['showUserBackupSummary'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserBackupSummary'};
        $data['showCurrentlyRunningReports'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showCurrentlyRunningReports'};
	$data['showSupportPage'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSupportPage'};
	$data['showBackupCompletionReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupCompletionReport'};
	$this->session->put('showSupportPage',$data['showSupportPage']);
	$showAuditHistory = $cloudProperties['body']->{'cloudPropertyElement'}->{'showAuditHistory'};
        $this->session->put('showAuditHistory',$showAuditHistory);
	$data['tile8ReportType'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'tile8ReportType'};
        $data['flipNotProtectedTile'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'flipNotProtectedTile'};
	$data['forceChangePasswordAtFirstTimeLogin'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'forceChangePasswordAtFirstTimeLogin'};
	$data['forceSessionLogoutAfterChangepassword'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'forceSessionLogoutAfterChangepassword'};
	$data['showAccessCodeOnFirstLogin'] = !empty($cloudProperties['body']->{'cloudPropertyElement'}->{'showAccessCodeOnFirstLogin'}) ? $cloudProperties['body']->{'cloudPropertyElement'}->{'showAccessCodeOnFirstLogin'} : false;
	$data['Storage_Provider'] = !empty($cloudProperties['body']->{'cloudPropertyElement'}->{'storageProvider'}) ? $cloudProperties['body']->{'cloudPropertyElement'}->{'storageProvider'} : 'ParaBlu';
	$data['Hosted'] = !empty($result['body']->{'cloudPropertyElement'}->{'hostedSetup'}) ? $result['body']->{'cloudPropertyElement'}->{'hostedSetup'} : 'true';
        $data['MSP'] = $this->session->get('MSP_Environment_Enabled');
        $data['superAdmin'] = $this->session->get('userType');
	$this->session->put("Storage_Provider",$data['Storage_Provider']);

	    
	if($this->session->get('admin') == true){
        	$this->session->put('showAuditHistory',true);
        }elseif($this->session->get('readOnlyAdmin') == true){
		$this->session->put('showAuditHistory',$showAuditHistory);
        }else{
                $this->session->put('showAuditHistory',true);
	}	    	    
	$data['time'] = '';
        if($this->session->get('lastLoggedInTime') != ""){
	    $data['time'] = date('d-M-Y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
	}
	$data['isAdmin'] = 'false';
        if($this->session->get('admin') == true){
        $data['isAdmin'] = 'true';
        }        
        $data['stopPauseAccess'] = 'true';
        if($this->session->get('readOnlyAdmin') == true){
            if($cloudProperties['body']->{'cloudPropertyElement'}->{'stopPauseAccess'} == true){
                $data['stopPauseAccess'] = 'true';
            }else{
                $data['stopPauseAccess'] = 'false';
            }
            $this->log("inside read only admin true","info");
            if($cloudProperties['body']->{'cloudPropertyElement'}->{'hideDashboard'} == true){
                $this->log("inside hide dash true","info");
                $data['isAdmin'] = 'false';
            }else{
                $this->log("inside hide dash false","info");
                $data['isAdmin'] = 'true';
            }
        }        
        if($this->session->get('downloadAgent') == 'true'){
            $data['downloadAgent'] = 'true';
        }else{
            $data['downloadAgent'] = 'false';
	}
	$visible = '';
	if($this->session->get('firstLogin1') == "true" && $this->session->get('localUser') == '1' && $data['forceChangePasswordAtFirstTimeLogin'] == true){
                $visible = 'visible';
	}
	$data['popup'] = $visible;
	$data['activeTabB'] = '';
	$data['activeTabS'] = '';
	$data['activeTabO'] = '';
	$data['activeTabShare'] = '';
        $data['activeTabExchange'] = '';

        if(Auth::checkCloudPermission('backup') == true){
                $data['activeTabB'] = 'active';
        }elseif(Auth::checkCloudPermission('backup') == false){
                if(Auth::checkCloudPermission('sync') == true){
                        $data['activeTabS'] = 'active';
                }else{
                        if(Auth::checkCloudPermission('exchange') == true){
                                $data['activeTabExchange'] = 'active';
                        }else{
                                if(Auth::checkCloudPermission('sharepoint') == true){
                                        $data['activeTabShare'] = 'active';
                                }else{
                                        if(Auth::checkCloudPermission('onedrive') == true){
                                                $data['activeTabO'] = 'active';
                                        }else{
                                        }
                                }
                        }
                }
        }
	/*if($_SESSION['sharepointBkpEnabled'] == 'true'){
		$data['activeTabO'] = 'active';
	}*/
	$data['session_cok'] = $this->session->get('session_cok2');
	if($this->session->get('rwDetectionEnabled') == 'true'){
            $data['rwDetectionEnabled'] = 'true';
        }else{
            $data['rwDetectionEnabled'] = 'false';
	}
	$data['isBackupEnabled'] = 'no';
        $data['isSyncEnabled'] = 'no';
        $data['isOnedriveEnabled'] = 'no';
        $data['isExchangeEnabled'] = 'no';
        $data['isSharepointEnabled'] = 'no';
        if(Auth::checkCloudPermission('backup') == true){
                $data['isBackupEnabled'] = 'yes';
        }
        if(Auth::checkCloudPermission('sync') == true){
                $data['isSyncEnabled'] = 'yes';
        }
        if(Auth::checkCloudPermission('exchange') == true){
                $data['isExchangeEnabled'] = 'yes';
        }
        if(Auth::checkCloudPermission('sharepoint') == true){
                $data['isSharepointEnabled'] = 'yes';
        }
        if(Auth::checkCloudPermission('onedrive') == true){
                $data['isOnedriveEnabled'] = 'yes';
        }
	$this->session->put('redirectUrl', '');
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
        if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }
        if($this->session->get('spArchivingEnabled') == "true"){
                $data['spArchivingEnabled'] = 'true';
        }else{
                $data['spArchivingEnabled'] = 'false';
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/index', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Define Index page title and load template files
     */
    public function serverBackup() {
        $data = array(
            'csrf_token' 	=> $this->setCSRFToken(),
            'loggedInUser' 	=> $this->session->all()
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/serverBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function index_mockup() {
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        $data = array(
            'csrf_token' => $this->setCSRFToken(),
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'loggedInUser' => $this->session->all()
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
        $data['showBackupOverview'] = true;
        $data['showBackupHistory'] = true;
        $data['showFailedBackupHistory'] = true;
        $data['showSystemsWithoutBackups'] = true;
        $data['showRestoreHistory'] = true;
        $data['showStorageUtilizationReport'] = true;
        $data['showDeviceHeartbeatReport'] = true;
        $data['showUserBackupSummary'] = true;
        $data['tile8ReportType'] = 'systemsWithoutBackup';
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $data['hideCompressedSize'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'hideCompressedSize'};
        $data['showBackupOverview'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupOverview'};
        $data['showBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupHistory'};
        $data['showFailedBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showFailedBackupHistory'};
        $data['showIncompleteBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showIncompleteBackupHistory'};
        $data['showSystemsWithoutBackups'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSystemsWithoutBackups'};
        $data['showRestoreHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showRestoreHistory'};
        $data['showStorageUtilizationReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showStorageUtilizationReport'};
        $data['showDeviceHeartbeatReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showDeviceHeartbeatReport'};
        $data['showUserBackupSummary'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserBackupSummary'};
        $data['showCurrentlyRunningReports'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showCurrentlyRunningReports'};
        $data['showSupportPage'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSupportPage'};
        $this->session->put('showSupportPage',$data['showSupportPage']);
        $showAuditHistory = $cloudProperties['body']->{'cloudPropertyElement'}->{'showAuditHistory'};
        $this->session->put('showAuditHistory',$showAuditHistory);
        $data['tile8ReportType'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'tile8ReportType'};
        $data['flipNotProtectedTile'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'flipNotProtectedTile'};
        $data['forceChangePasswordAtFirstTimeLogin'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'forceChangePasswordAtFirstTimeLogin'};
	$data['forceSessionLogoutAfterChangepassword'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'forceSessionLogoutAfterChangepassword'};
	$data['showAccessCodeOnFirstLogin'] = !empty($cloudProperties['body']->{'cloudPropertyElement'}->{'showAccessCodeOnFirstLogin'}) ? $cloudProperties['body']->{'cloudPropertyElement'}->{'showAccessCodeOnFirstLogin'} : false;

        if($this->session->get('admin') == true){
                $this->session->put('showAuditHistory',true);
        }elseif($this->session->get('readOnlyAdmin') == true){
                $this->session->put('showAuditHistory',$showAuditHistory);
        }else{
                $this->session->put('showAuditHistory',true);
        }
        if($this->session->get('lastLoggedInTime') != ""){
            $data['time'] = date('d-M-Y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
        }
        if($this->session->get('admin') == true){
        $data['isAdmin'] = 'true';
        }
        $data['stopPauseAccess'] = 'true';
        if($this->session->get('readOnlyAdmin') == true){
            if($cloudProperties['body']->{'cloudPropertyElement'}->{'stopPauseAccess'} == true){
                $data['stopPauseAccess'] = 'true';
            }else{
                $data['stopPauseAccess'] = 'false';
            }
            $this->log("inside read only admin true","info");
            if($cloudProperties['body']->{'cloudPropertyElement'}->{'hideDashboard'} == true){
                $this->log("inside hide dash true","info");
                $data['isAdmin'] = 'false';
            }else{
                $this->log("inside hide dash false","info");
                $data['isAdmin'] = 'true';
            }
        }
        if($this->session->get('downloadAgent') == 'true'){
            $data['downloadAgent'] = 'true';
        }else{
            $data['downloadAgent'] = 'false';
	}
	$visible = '';
        if($this->session->get('firstLogin1') == "true" && $this->session->get('localUser') == '1' && $data['forceChangePasswordAtFirstTimeLogin'] == true){
                $visible = 'visible';
        }
        $data['activeTabB'] = '';
        $data['activeTabS'] = '';
        $data['activeTabO'] = '';
        if(Auth::checkCloudPermission('backup') == true){
                $data['activeTabB'] = 'active';
        }elseif(Auth::checkCloudPermission('backup') == false){
        	if(Auth::checkCloudPermission('sync') == true){
                        $data['activeTabS'] = 'active';
                }else{
                        $data['activeTabO'] = 'active';
                }
        }
        $data['session_cok'] = $this->session->get('session_cok2');
        $data['isOnedriveEnabled'] = 'no';
        $data['isExchangeEnabled'] = 'no';
        $data['isSharepointEnabled'] = 'no';
        if(Auth::checkCloudPermission('onedrive')){
                $data['isOnedriveEnabled'] = 'yes';
        }
        if(Auth::checkCloudPermission('exchange')){
                $data['isExchangeEnabled'] = 'yes';
        }
        if(Auth::checkCloudPermission('sharepoint')){
                $data['isSharepointEnabled'] = 'yes';
	}
	$backupResult = $this->_model->getAllPolicyName(array('token'=>$this->session->get('token'),'isReport' => 'true','productType'=>'backup'));
	$backupPolicies = [];
	if(!empty($backupResult['body']->{'stringList'})){
        foreach((array)$backupResult['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies = array_merge(array($policy), $backupPolicies);
	}
	}
	$data['backupPolicies'] = array_reverse($backupPolicies);
	$data['type'] = 'This user is managed by AAD group, this action is not allowed.';
	$data['reportProductType'] = 'backup';
	$data['readOnlyAdminUser'] = 'No';
	$data['popup'] = $visible;
	$data['policy'] = $this->session->get("policyName");
	//$data['policy_staging'] = explode('_', $data['policy']);
	$data['policy_staging'] = $data['policy'].'_staging';
	$this->log("policy : ".$data['policy'],"info");
/*	$schedulesResult = $this->_model->getSchedules($headers);


	$sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
	}
	natcasesort($sch1);
	$data['sch1'] = $sch1;*/
	/*edit policy starts */
	$schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$overridePolicySettings = $cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'};
	$showUserConsentFieldInPolicies = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserConsentFieldInPolicies'};
        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }
        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }       
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }
        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }
	natcasesort($sch1);
	$this->log("zzzzaadd : ".json_encode($sch1),"info");
        natcasesort($fil1);
        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                  if((string)$value->{'productType'} != 'blusync'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
            }
        }      
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }
        natcasesort($filCanned);                    
        $data['schedules'] = $schedules;
$data['filters'] = $filters;
$data['sch1'] = $sch1;
$data['fil1'] = $fil1;
$data['filCanned'] = $filCanned;
$data['IncFilters'] = $IncFilters;
$data['ExcFilters'] = $ExcFilters;
$data['pgs'] = $pgs;
$data['ccS'] = $ccS;
$data['noOfDevicesAllowed'] = $noOfDevicesAllowed;
$data['passwordChangeEnforce'] = $passwordChangeEnforce;
$data['canUserChangePassword'] =  $canUserChangePassword;
$data['canAdminChangeUserPassword'] = $canAdminChangeUserPassword;
$data['canAdminRestoreAll'] = $canAdminRestoreAll;
$data['canAdminDelete'] = $canAdminDelete;
$data['searchEnabled'] = $searchEnabled;
$data['overridePolicySettings'] = $overridePolicySettings;
$data['showUserConsentFieldInPolicies'] = $showUserConsentFieldInPolicies;
	    
	if($this->session->get('isSQLBkpEnabled') == 'true'){
        	$data['isSQLBkpEnabled'] = 'true';
        }else{
        	$data['isSQLBkpEnabled'] = 'false';
	}
	if($this->session->get('rwDetectionEnabled') == 'true'){
                $data['rwDetectionEnabled'] = 'true';
        }else{
                $data['rwDetectionEnabled'] = 'false';
        }
	/*edit policy ends*/
	/*change password start*/
	if(enableRecaptcha == true){
        	$resultCaptcha = $this->_model->preauthenticate($options);
	}

	$data['letter'] = '';
        $data['count'] = '';
	if(enableRecaptcha == true){
            	$data['letter'] = $resultCaptcha['headers']->container['captcha-value'];
        	$this->session->put("usercaptcha-value",$resultCaptcha['headers']->container['captcha-value']);
            	$data['count'] = time();
        }else{
        	$data['letter'] = '';
            	$data['count'] = '';
        }
	$username = base64_encode($this->session->get('userName'));
	$userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token'), 'loggedInUserName' => base64_encode($this->session->get('userName'))), $username);
	$data['userDetails'] = $userDetails['body'];
	if($this->session->get('userName') == $userDetails['body']->{'user-name'}){
            	$data['lastLoggedInTime'] = $this->session->get('lastLoggedInTime');
	    }else{
            	$data['lastLoggedInTime'] = $userDetails['body']->{'lastLoggedInTime'};
	    }
	$data['activateEdit'] = true;
	$data['oneDriveBackupType'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'oneDriveBackupType'};
	$data['managedBackup'] = 'Yes';
	$data['managedSync'] = 'No';
	$data['autoExpireUsers'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'autoExpireUsers'};
	$data['googleSecretKey'] = $userDetails['body']->{'google-secret-key'};
	$data['recoverykey'] = $userDetails['body']->{'recovery-key'};
	$data['userName'] = $userDetails['body']->{'user-name'};
	$this->session->put('cuph',(string)$userDetails['body']->{'password-hash'});
            $this->session->put('curk',(string)$userDetails['body']->{'recovery-key'});
            $this->session->put('cugsk',(string)$userDetails['body']->{'google-secret-key'});
	$email = $userDetails['body']->{'email-id'};
	$parts = explode('@', $email);
	$parts = explode('.', $parts[1]);
	$data['domain'] = $parts[0];
	$this->session->put("domain",$data['domain']);
	/*change password end*/
	$data['MSP_Environment_Enabled'] = 'No';
        if(($this->session->get('MSP_Environment_Enabled') == 'true' && $this->session->get('userType') == 'delegatedAdmin') || ($this->session->get('MSP_Environment_Enabled') == 'true' && $this->session->get('userType') == 'user')){
                $data['MSP_Environment_Enabled'] = 'Yes';
        }
	$data['sessionUser'] = $this->session->get('userName');
	$serverbackupPolicies=[];
	$serverbackupResult=$this->_model->getAllPolicyName(array("token"=>$this->session->get('token'),'isReport' => 'true','productType'=>'Server'));
	if(!empty($serverbackupResult['body']->{'stringList'})){
        foreach((array)$serverbackupResult['body']->{'stringList'} as $value){
            $serverpolicy = $value;
            $serverbackupPolicies = array_merge(array($serverpolicy), $serverbackupPolicies);
	}
	}
	$this->log("serverbackupPolicies : ".json_encode($serverbackupPolicies),"info");

	$data['serverbackupPolicies'] = array_reverse($serverbackupPolicies);
	/*overview start*/
	$headersO = array(
                    'token'         => $this->session->get('token'),
                    'Content-Type'  => 'application/json',
                    'Accept'        => 'application/json',
                    'deviceType'   => 'BACKUP'
            );
	$resultO = $this->_model->getStatistics($headersO);
	$serverMgmt = 'no';
	if(!empty($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'})){
                    for($p=0;$p<sizeof($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'});$p++){
			    if($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'subscriptionActive'} == true){
				$this->log("PACKCODE : ".json_encode($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'}),"info");
				foreach($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'} as $value){
					if (substr($value->{'skuCode'}, 0, 5) === "ADSER") {
                                        	if($value->{'subscriptionActive'} == true){
                                        		$serverMgmt = 'yes';
						}
					}
                                }
			    }
		    }
	}
	$this->session->put("serverMgmt",$serverMgmt);
	$data['serverMgmt'] = $serverMgmt;
	if(!empty($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'})){
                    for($p=0;$p<sizeof($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'});$p++){
                            if($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'subscriptionActive'} == true){
                                $this->log("PPPPP : ".$p,"info");
                                $this->session->put("showpacks",'SHOWPACKS');
				$this->session->put("skuCode",$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'skuCode'});
				if (substr($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'skuCode'}, 0, 2) === 'FR') {
                                        $this->session->put("packModel",'FREMIUM');
                                } else {
                                        $this->session->put("packModel",'PREMIUM');
                                }
                                $this->log("PACKCODE : ".$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'skuCode'},"info");
                                $totalStorage = (int)preg_replace("/[^0-9]/", '', $resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'storageSize'});
                                $totalUser = (int)preg_replace("/[^0-9]/", '', $resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'minUserCount'});
                                $this->session->put("storageSize",$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'storageSize'});
                                $this->session->put("minUserCount",$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'minUserCount'});
                                $this->session->put("customerId",$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'customerId'});
                                $this->session->put("referenceNumber",$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'referenceNumber'});
                                $subDateBase =  date('d-M-Y H:i:s', (((int)$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'subscriptionStartDate'}) / 1000));
                                $this->session->put("subscriptionStartDate",$subDateBase);
                                $this->session->put("addons",$resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'});
                                foreach($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'} as $value){
                                        if($value->{'subscriptionActive'} == true && substr($value->{'skuCode'}, 0, 5) !== "ADSER"){
                                        $totalUser = $totalUser + (int)preg_replace("/[^0-9]/", '', $value->{'minUserCount'});
                                        $totalStorage = $totalStorage + (int)preg_replace("/[^0-9]/", '', $value->{'storageSize'});
                                        }
				}
				$totalServer = 0;
				foreach($resultO['body']->{'MSPCloudOverviewElement'}->{'packs'}[$p]->{'addons'} as $value){
                                        if (substr($value->{'skuCode'}, 0, 5) === "ADSER") {
                                                if($value->{'subscriptionActive'} == true){
							$totalServer = $totalServer + (int)preg_replace("/[^0-9]/", '', $value->{'minUserCount'});
							$totalStorage = $totalStorage + (int)preg_replace("/[^0-9]/", '', $value->{'storageSize'});
                                                }
                                        }
                                }
                                $this->log("TOTALSTORAGE : ".$totalStorage,"info");
                                $this->log("TOTALUSERXXXXXXXXXXXX : ".$totalUser,"info");
                                $this->session->put("totalStorage",$totalStorage);
				$this->session->put("totalUser",$totalUser);
				$this->session->put("totalServer",$totalServer);
                            }
                    }
            }
	/*overview end*/
	if($this->session->get('isSQLBkpEnabled') == 'true'){
        	$data['isSQLBkpEnabled'] = 'true';
        }else{
        	$data['isSQLBkpEnabled'] = 'false';
	}
	if($this->session->get('Windows_Server_Backup_Enabled') == 'true'){
                $data['Windows_Server_Backup_Enabled'] = 'yes';
        }else{
                $data['Windows_Server_Backup_Enabled'] = 'no';
	}
	$data['packModel'] = $this->session->get('packModel');
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/index_mockup2', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDaysString($numString){
        $numString = str_replace('1', Language::show('Sunday', 'keywords'), $numString);
        $numString = str_replace('2', Language::show('Monday', 'keywords'), $numString);
        $numString = str_replace('3', Language::show('Tuesday', 'keywords'), $numString);
        $numString = str_replace('4', Language::show('Wednesday', 'keywords'), $numString);
        $numString = str_replace('5', Language::show('Thursday', 'keywords'), $numString);
        $numString = str_replace('6', Language::show('Friday', 'keywords'), $numString);
        return str_replace('7', Language::show('Saturday', 'keywords'), $numString);
    }
	
}
