<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\History;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class HistoryController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('history');
        $this->_model = new History();
        $this->verifyAndCleanItUp();
    }

    public function backupHistory($userName, $deviceUUID, $deviceName){
	$deviceName = str_replace('_PB_', ' ', $deviceName);
	$deviceName = base64_decode($deviceName);
	$userName = urldecode($userName);
	$deviceName = urldecode($deviceName);
	$ciphering = "AES-256-CBC";
        $decryption_iv = '2007199020071990';
        $decryption_key = "PORTAL";
        $options = 0;
        $userName1 = $userName;
        $userName = base64_decode($userName);
        $decryption=openssl_decrypt ($userName, $ciphering,$decryption_key, $options, $decryption_iv);
        //$this->auth->checkLoggedInUser($userName);
        $this->session->put('currentDeviceUUID', $deviceUUID);
        $this->session->put('currentDeviceName', $deviceName);
        $this->session->put('currentUser', $decryption);
	//$this->session->put('currentUser', $userName);
	if (strpos($deviceName, 'Microsoft OneDrive') !== false ||
    		strpos($deviceName, 'Microsoft Exchange') !== false ||
    		strpos($deviceName, 'Microsoft SharePoint') !== false) {
    		$type = 'office';
	} else {
    		$type = 'other';
	}
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('device'),
            'crumb2' => $this->language->get('device_backup_history'),
            'deviceUUID' => $this->session->get('currentDeviceUUID'),
            //'currentUser' => $userName,
	    'currentUser' => $userName1,
            'csrf_token' => $this->setCSRFToken(),
	    'loggedInUser' => $this->session->all(),
	    'active' => '',
	    'deviceType' => $type
        );
	$data['MSP_Environment_Enabled'] = 'No';
        if(($this->session->get('MSP_Environment_Enabled') == 'true' && $this->session->get('userType') == 'delegatedAdmin') || $this->session->get('MSP_Environment_Enabled') == 'true' && $this->session->get('userType') == 'user'){
                $data['MSP_Environment_Enabled'] = 'Yes';
        }
	/*change password start*/
        if(($this->session->get('MSP_Environment_Enabled') == 'true' && $this->session->get('userType') == 'delegatedAdmin') || $this->session->get('MSP_Environment_Enabled') == 'true' && $this->session->get('userType') == 'user'){
        if(enableRecaptcha == true){
                $resultCaptcha = $this->_model->preauthenticate($options);
        }

        $data['letter'] = '';
        $data['count'] = '';
        if(enableRecaptcha == true){
                $data['letter'] = $resultCaptcha['headers']->container['captcha-value'];
                $this->session->put("usercaptcha-value",$resultCaptcha['headers']->container['captcha-value']);
                $data['count'] = time();
        }else{
                $data['letter'] = '';
                $data['count'] = '';
        }
        $username = base64_encode($this->session->get('userName'));
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token'), 'loggedInUserName' => base64_encode($this->session->get('userName'))), $username);
        $data['googleSecretKey'] = $userDetails['body']->{'google-secret-key'};
        $data['recoverykey'] = $userDetails['body']->{'recovery-key'};
        $data['userName'] = $userDetails['body']->{'user-name'};
        $this->log("googleSecretKey : ".$data['googleSecretKey'],"info");
        $this->log("recoverykey : ".$data['recoverykey'],"info");
        }
	/*change password end*/
	$headersD = array(
        	'Content-Type' => 'application/json',
                'token'     => $this->session->get('token')
        );
        $resultD = $this->_model->getDevicesForRestorePage($headersD, $deviceUUID);
        $data['deviceTypeActual'] = $resultD['body']->{'deviceType'};
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/deviceBackupHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBackupHistory(){
        if(empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-type'  => 'application/json',
            'Accept'        => 'application/json',
        );
        $data = array(
            'deviceName'    => $this->session->get('currentDeviceName'),
            'userName'      => $this->session->get('currentUser'),
            'deviceUUID'    => $this->session->get('currentDeviceUUID')
        );

        $pageNumber = 1;
        $result = $this->_model->userDeviceBackupHistory($headers,$data,$pageNumber);
        switch ($result['status']) {
            case (200):
                if(!empty($result['header']['totalNoOfFiles'])){
                    $totalNoOfFiles = $result['header']['totalNoOfFiles'];
                    $filesBackedUp = $totalNoOfFiles - $result['header']['noOfFilesToBeUploaded'];
                    $completedPercentage = round(($filesBackedUp / $totalNoOfFiles) * 100).'%';
                }elseif(($result['header']['totalNoOfFiles'] < $result['header']['noOfFilesToBeUploaded'])) {
                    $totalNoOfFiles = 'Problem with Data';
                    $completedPercentage = 'Problem with Data';
                }elseif($result['header']['totalNoOfFiles'] == 0){
                    $totalNoOfFiles = '0';
                    $completedPercentage = 'N/A';
                }else{
                    $totalNoOfFiles = 'No Backup is initiated';
                    $completedPercentage = 'No Backup is initiated';
                }
                if(($result['header']['totalNoOfFiles'] < $result['header']['noOfFilesToBeUploaded'])) {
                    $noOfFilesToBeUploaded = 'Problem with Data';
                }elseif(!empty($result['header']['noOfFilesToBeUploaded'])){
                    $noOfFilesToBeUploaded = $result['header']['noOfFilesToBeUploaded'];
                }elseif($result['header']['noOfFilesToBeUploaded'] == 0){
                    $noOfFilesToBeUploaded = '0';
                }else{
                    $noOfFilesToBeUploaded = 'No Backup is initiated';
                }
                $summary = array(
                    'completedPercentage' => $completedPercentage,
                    'totalNoOfFiles' => $totalNoOfFiles,
                    'noOfFilesToBeUploaded' => $noOfFilesToBeUploaded
                );
                $history = [];
                if(!empty($result['body']->{'data'}->{'backupActivityHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupActivityHistoryElement'} as $value){
                        if(!empty($value->noOfFilesFailed)){    
				$totalFiles = $value->noOfFilesBackedup + $value->noOfFilesFailed;
			}else{
				$totalFiles = $value->noOfFilesBackedup;
			}
                        /*if($value->noOfFilesFailed > 0){
                            $percentage = ' ('.round(($value->noOfFilesBackedup / $totalFiles) * 100).' %)';
                        }else{
                            $percentage = ' (100 %)';
                        }*/
			if($value->totalNumberOfFiles > 0){
                        	$percentage = ' ('.round(($totalFiles / $value->totalNumberOfFiles) * 100).'%)';
                    	}else{
                    		$percentage = ' (100%)';
                    	}
			if($value->status == 'Data Uploading' || $value->status == 'SCANNING' || $value->status == 'QUEUED'){
				$status = 'HIDE';
				$percentage = ' (0%)';
                        }else{
				$status = $value->status;
				$percentage = ' (0%)';
                        }
                        if(!empty($value->uploadedPercentage)){
                        	$percentage = ' ('.$value->uploadedPercentage.' )';
                        }else{
                        	$percentage = $percentage;
			}
			if($value->status == 'SCANNING' || $value->status == 'QUEUED'){
                                if((!empty($value->comments) && $value->comments != "Admin stopped queue manually") &&  (!empty($value->comments) && $value->comments != "Admin stopped scanning manually")){
                                        $value->endTime = '-';
                                        $totalFiles = '-';
                                        $value->noOfFilesBackedup = '-';
                                        $percentage = '';
                                        $value->noOfFilesFailed = '-';
                                        $value->totalNumberOfFiles = '-';
                                }
                                if((!empty($value->comments) && $value->comments == "Admin stopped queue manually") || (!empty($value->comments) && $value->comments == "Admin stopped scanning manually")){
                                        $status = $value->status;
                                }
                                /*$totalFiles = '-';
                                $value->noOfFilesBackedup = '-';
                                $percentage = '';
                                $value->noOfFilesFailed = '-';
                                $value->totalNumberOfFiles = '-';*/
                        }
                        $his = array(
                            'startTime' => $value->startTime,
                            'endTime' => $value->endTime,
			    'startTimeLong' => $value->startTimeLong,
			    'endTimeLong' => $value->endTimeLong,
                            'totalFile' => $totalFiles,
                            'percentage' => $value->noOfFilesBackedup.$percentage,
                            //'failedLogPresent' => $vaule->failedLogPresent,
                            'failed' => !empty($value->noOfFilesFailed) ? $value->noOfFilesFailed : 0,
                            'batchId' => $value->batchId,
                            'comments' => !empty($value->comments) ? $value->comments : '-',
                            'attemptIsThere' => $value->attemptIsThere,
			    'totalNumberOfFiles' => $value->totalNumberOfFiles,
			    'status' => $status,
			    'fullBackup' => $value->fullBackup
                        );
                        $history = array_merge(array($his), $history);
                    }
                }
                
                if(!empty($result['body']->{'metadata'})){
                    $metadata = $result['body']->{'metadata'};
                    $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                    $metadata = [];
                }

                $response = array(
                    'result' => 'success',
                    'summary' => $summary,
                    'history' => $history,
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
    
    public function getBackupHistory1(){
        if(empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-type'  => 'application/json',
            'Accept'        => 'application/json',
        );

        $data = array(
            'deviceName'    => $this->session->get('currentDeviceName'),
            'userName'      => $this->session->get('currentUser'),
            'deviceUUID'    => $this->session->get('currentDeviceUUID')
        );
        $result = $this->_model->userDeviceBackupHistory1($headers,$data,$_POST['url']);
        switch ($result['status']) {
            case (200):
                if(!empty($result['header']['totalNoOfFiles'])){
                    $totalNoOfFiles = $result['header']['totalNoOfFiles'];
                    $filesBackedUp = $totalNoOfFiles - $result['header']['noOfFilesToBeUploaded'];
                    $completedPercentage = round(($filesBackedUp / $totalNoOfFiles) * 100).'%';
                }elseif(($result['header']['totalNoOfFiles'] < $result['header']['noOfFilesToBeUploaded'])) {
                    $totalNoOfFiles = 'Problem with Data';
                    $completedPercentage = 'Problem with Data';
                }elseif($result['header']['totalNoOfFiles'] == 0){
                    $totalNoOfFiles = '0';
                    $completedPercentage = 'N/A';
                }else{
                    $totalNoOfFiles = 'No Backup is initiated';
                    $completedPercentage = 'No Backup is initiated';
                }
                if(($result['header']['totalNoOfFiles'] < $result['header']['noOfFilesToBeUploaded'])) {
                    $noOfFilesToBeUploaded = 'Problem with Data';
                }elseif(!empty($result['header']['noOfFilesToBeUploaded'])){
                    $noOfFilesToBeUploaded = $result['header']['noOfFilesToBeUploaded'];
                }elseif($result['header']['noOfFilesToBeUploaded'] == 0){
                    $noOfFilesToBeUploaded = '0';
                }else{
                    $noOfFilesToBeUploaded = 'No Backup is initiated';
                }
                $summary = array(
                    'completedPercentage' => $completedPercentage,
                    'totalNoOfFiles' => $totalNoOfFiles,
                    'noOfFilesToBeUploaded' => $noOfFilesToBeUploaded
                );
                $history = [];
                if(!empty($result['body']->{'data'}->{'backupActivityHistoryElement'})){
                    foreach($result['body']->{'data'}->{'backupActivityHistoryElement'} as $value){
                        if(!empty($value->noOfFilesFailed)){    
				$totalFiles = $value->noOfFilesBackedup + $value->noOfFilesFailed;
			}else{
				$totalFiles = $value->noOfFilesBackedup;
			}
                        /*if($value->noOfFilesFailed > 0){
                            $percentage = ' ('.round(($value->noOfFilesBackedup / $totalFiles) * 100).' %)';
                        }else{
                            $percentage = ' (100 %)';
                        }*/
			if($value->totalNumberOfFiles > 0){
                        	$percentage = ' ('.round(($totalFiles / $value->totalNumberOfFiles) * 100).'%)';
                    	}else{
                    		$percentage = ' (100%)';
                    	}
			if($value->status == 'Data Uploading' || $value->status == 'SCANNING' || $value->status == 'QUEUED'){
                                $status = 'HIDE';
                        }else{
                                $status = $value->status;
                        }
                        if(!empty($value->uploadedPercentage)){
                        	$percentage = ' ('.$value->uploadedPercentage.' )';
                        }else{
                        	$percentage = $percentage;
			}
			if($value->status == 'SCANNING' || $value->status == 'QUEUED'){
                                if((!empty($value->comments) && $value->comments != "Admin stopped queue manually") &&  (!empty($value->comments) && $value->comments != "Admin stopped scanning manually")){
                                        $value->endTime = '-';
                                        $totalFiles = '-';
                                        $value->noOfFilesBackedup = '-';
                                        $percentage = '';
                                        $value->noOfFilesFailed = '-';
                                        $value->totalNumberOfFiles = '-';
                                }
                                if((!empty($value->comments) && $value->comments == "Admin stopped queue manually") || (!empty($value->comments) && $value->comments == "Admin stopped scanning manually")){
                                        $status = $value->status;
                                }
                                /*$totalFiles = '-';
                                $value->noOfFilesBackedup = '-';
                                $percentage = '';
                                $value->noOfFilesFailed = '-';
                                $value->totalNumberOfFiles = '-';*/
                        }
                        $his = array(
                            'startTime' => $value->startTime,
                            'endTime' => $value->endTime,
                            'startTimeLong' => $value->startTimeLong,
                            'endTimeLong' => $value->endTimeLong,
                            'totalFile' => $totalFiles,
                            'percentage' => $value->noOfFilesBackedup.$percentage,
                            //'failedLogPresent' => $vaule->failedLogPresent,
                            'failed' => !empty($value->noOfFilesFailed) ? $value->noOfFilesFailed : 0,
                            'batchId' => $value->batchId,
                            'comments' => !empty($value->comments) ? $value->comments : '-',
                            'attemptIsThere' => $value->attemptIsThere,
			    'totalNumberOfFiles' => $value->totalNumberOfFiles,
			    'status' => $status,
			    'fullBackup' => $value->fullBackup
                        );
                    $history = array_merge(array($his), $history);

                    }
                }
                if(!empty($result['body']->{'metadata'})){
                    $metadata = $result['body']->{'metadata'};
                    $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                    $metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'summary' => $summary,
                    'history' => $history,
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getBackupHistoryDetails(){
        if(!empty($_POST) && !empty($_POST['batchId'])){
            $headers = array(
                'token'         => $this->session->get('token'),
                'userName'      => $this->session->get('userName'),
                'batchId'      => $_POST['batchId']
            );
            $result = $this->_model->userDeviceBackupHistoryDetails($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'historyDetails' => $result['body']->backupHistoryFileElementList
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function activityHistory(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        $data = array(
            'title' => $this->language->get('history'),
            'crumb1' => $this->language->get('activityHistory'),
            'csrf_token' => $this->setCSRFToken(),
	    'loggedInUser' => $this->session->all(),
	    'active' => ''
        );
	if($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true'){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/backupActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getActivityHistory(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
            'pbAuditUserName'      => $_POST['pbAuditUserName'],
            'pbAuditDeviceName'      => $_POST['pbAuditDeviceName'],
	    //'pageNumber'      => $_POST['pageNumber'],
	    //'rows'      => $_POST['rows']
        );
	$userName = '';
        if($this->session->get('admin') != true){
            $headers['userName'] = base64_encode($this->session->get('userName'));
	    $userName = base64_encode($this->session->get('userName'));
            $headers['pbAuditUserName'] = base64_encode($this->session->get('userName'));
        }
        $result = $this->_model->getBackupActivityHistory($headers, $_POST['pageNumber'], $userName);
        switch ($result['status']) {
            case (200):
                $audits = [];
                $metadata = [];
                if(!empty($result['body']->{'data'}->{'audits'})){
			foreach($result['body']->{'data'}->{'audits'} as $value){
			    if(!empty($value->{'action'})){
                        	if(strpos(strtolower((string)$value->{'action'}), 'deleted') !== false || strpos(strtolower((string)$value->{'action'}), 'decoupled') !== false){
                            		$color = 'info';
                        	}elseif(strpos(strtolower((string)$value->{'action'}), 'migration') !== false){
                            		$color = 'indigo';
                        	}elseif(strpos(strtolower((string)$value->{'action'}), 'logged') !== false){
                            		$color = 'deeporange';
                        	}else{
                            		$color = 'lime';
                        	}
			    }else{
			    	$color = 'lime';
			    }
                        $audit = array(
                            'action' => !empty($value->{'action'}) ? (string)$value->{'action'} : '',
                            'actionByUser' => !empty($value->{'actionByUserName'}) ? (string)$value->{'actionByUserName'} : '',
                            'actionOnObject' => !empty($value->{'actionOnObject'}) ? (string)$value->{'actionOnObject'} : '',
                            'actionUsingObject' =>!empty($value->{'actionUsingObject'}) ? (string)$value->{'actionUsingObject'} : '',
                            'additionalInfo' => !empty($value->{'additionalInfo'}) ? (string)$value->{'additionalInfo'} : '',
                            'auditId' => !empty($value->{'audit-id'}) ? (string)$value->{'audit-id'} : '',
                            'folder' => !empty($value->{'folder'}) ? (string)$value->{'folder'} : '',
                            'timestampInLong' => !empty($value->{'timestampInLong'}) ? (int)$value->{'timestampInLong'} : '',
                            'time' => !empty($value->{'timestampInLong'}) ? date('d-M-Y H:i:s', (((int)$value->{'timestampInLong'}) / 1000)) : '',
                            'color' => $color
                        );
			if(!empty($value->{'action'})){
                                if($value->{'action'} == 'Unusual activity detected'){
                                        $audit['totalNumberOfFiles'] = $value->{'totalNumberOfFiles'};
                                        $audit['numberOfFilesInfected'] = $value->{'numberOfFilesInfected'};
                                        $audit['numberOfFilesDeleted'] = $value->{'numberOfFilesDeleted'};
                                        $audit['numberOfNewFiles'] = $value->{'numberOfNewFiles'};
                                }
                        }
                        $audits = array_merge(array($audit), $audits);
                    }
                }
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
			$metadata = [];
		}
                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits),
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
    
    public function getActivityHistory1(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
        );	    
        if($this->session->get('admin') != true){
            $headers['userName'] = base64_encode($this->session->get('userName'));
            $headers['pbAuditUserName'] = base64_encode($this->session->get('userName'));
        }
	$result = $this->_model->getBackupActivityHistory1($headers, $_POST['url']);
	$this->log("uuuuuu : ","info");
	$this->log("uuuuuu : ".json_encode($result['body']->{'data'}),"info");
	$this->log("uuuuuuMETA : ".json_encode($result['body']->{'metadata'}),"info");

        switch ($result['status']) {
 	    case (200):
                $audits = [];
		$metadata = [];
                if(!empty($result['body']->{'data'}->{'audits'})){
                    foreach($result['body']->{'data'}->{'audits'} as $value){
                        if(!empty($value->{'action'})){
                                if(strpos(strtolower((string)$value->{'action'}), 'deleted') !== false || strpos(strtolower((string)$value->{'action'}), 'decoupled') !== false){
                                        $color = 'info';
                                }elseif(strpos(strtolower((string)$value->{'action'}), 'migration') !== false){
                                        $color = 'indigo';
                                }elseif(strpos(strtolower((string)$value->{'action'}), 'logged') !== false){
                                        $color = 'deeporange';
                                }else{
                                        $color = 'lime';
                                }
			}else{
				$color = 'lime';
			}
                        $audit = array(
                            'action' => !empty($value->{'action'}) ? (string)$value->{'action'} : '',
                            'actionByUser' => !empty($value->{'actionByUserName'}) ? (string)$value->{'actionByUserName'} : '',
                            'actionOnObject' => !empty($value->{'actionOnObject'}) ? (string)$value->{'actionOnObject'} : '',
                            'actionUsingObject' =>!empty($value->{'actionUsingObject'}) ? (string)$value->{'actionUsingObject'} : '',
                            'additionalInfo' => !empty($value->{'additionalInfo'}) ? (string)$value->{'additionalInfo'} : '',
                            'auditId' => !empty($value->{'audit-id'}) ? (string)$value->{'audit-id'} : '',
                            'folder' => !empty($value->{'folder'}) ? (string)$value->{'folder'} : '',
                            'timestampInLong' => !empty($value->{'timestampInLong'}) ? (int)$value->{'timestampInLong'} : '',
                            'time' => !empty($value->{'timestampInLong'}) ? date('d-M-Y H:i:s', (((int)$value->{'timestampInLong'}) / 1000)) : '',
                            'color' => $color
			);
			if(!empty($value->{'action'})){
				if($value->{'action'} == 'Unusual activity detected'){
                                	$audit['totalNumberOfFiles'] = $value->{'totalNumberOfFiles'};
                                	$audit['numberOfFilesInfected'] = $value->{'numberOfFilesInfected'};
                                	$audit['numberOfFilesDeleted'] = $value->{'numberOfFilesDeleted'};
                                	$audit['numberOfNewFiles'] = $value->{'numberOfNewFiles'};
				}
			}
                        $audits = array_merge(array($audit), $audits);
		    }
                }
                if(!empty($result['body']->{'metadata'})){
                    $metadata = $result['body']->{'metadata'};
                    $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                    $metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits),
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                    );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function shareActivityHistory(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        $data = array(
            'title' => $this->language->get('history'),
            'crumb1' => $this->language->get('activityHistory'),
            'csrf_token' => $this->setCSRFToken(),
	    'loggedInUser' => $this->session->all(),
	    'active' => ''
        );
	if($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true'){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/shareActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getShareActivityHistory(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'             => $this->session->get('token'),
            'shareWithInOrg'    => "false",
            'skipValue'         => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'encrypted'         => 'false',
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
        );
        if(SHARE_WITHIN_ORG){
            $headers['shareWithInOrg'] = "true";
        }
        $result = $this->_model->getShareActivityHistory($headers, $_POST['pageNumber']);
        $this->log('ShareActivity History '. json_encode($headers), 'info');
        switch ($result['status']) {
            case (200):
                $audits = [];
                $color = 'lime';
                if(!empty($result['body']->{'data'})){
                    foreach($result['body']->{'data'} as $value){
			if($color == 'lime'){
                            $color = 'deeporange';
                        }elseif($color == 'deeporange'){
                            $color = 'indigo';
                        }elseif($color == 'indigo'){
                            $color = 'info';
                        }elseif($color == 'info'){
                            $color = 'lime';
                        }
                        $audit = array(
                            'color' => $color,
                            'ip' => !empty($value->{'ip'}) ? (string)$value->{'ip'} : '',
                            'osType' => !empty($value->{'osType'}) ? (string)$value->{'osType'} : '',
                            'accessType' => !empty($value->{'accessType'}) ? (string)$value->{'accessType'} : '',
                            'browser' => !empty($value->{'browser'}) ? (string)$value->{'browser'} : '',
                            'accessTimeStamp' => !empty($value->{'accessTimeStamp'}) ? date('d-M-Y H:i:s', (((int)$value->{'accessTimeStamp'}) / 1000)) : 0,
                            'devicePath' => !empty($value->{'devicePath'}) ? (string)$value->{'devicePath'} : '',
                            'fileName' => !empty($value->{'fileName'}) ? (string)$value->{'fileName'} : '',
                            'cloudName' => !empty($value->{'cloudName'}) ? (int)$value->{'cloudName'} : '',
			    'userName' => !empty($value->{'userName'}) ? $value->{'userName'} : '',
                        );
                        $audits = array_merge(array($audit), $audits);
                    }
                }
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }
		$response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits),
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('noContent')
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
		$result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getShareActivityHistory1(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'             => $this->session->get('token'),
            'shareWithInOrg'    => "false",
            'skipValue'         => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'encrypted'         => 'false',
            'Content-Type'  	=> 'application/json',
            'Accept'        	=> 'application/json',
        );
        if(SHARE_WITHIN_ORG){
            $headers['shareWithInOrg'] = "true";
        }
        $result = $this->_model->getShareActivityHistory1($headers, $_POST['url']);
	switch ($result['status']) {
            case (200):
                $audits = [];
                $color = 'lime';
                if(!empty($result['body']->{'data'})){
                    foreach($result['body']->{'data'} as $value){
                        if($color == 'lime'){
                            $color = 'deeporange';
                        }elseif($color == 'deeporange'){
                            $color = 'indigo';
                        }elseif($color == 'indigo'){
                            $color = 'info';
                        }elseif($color == 'info'){
                            $color = 'lime';
                        }
                        $audit = array(
                            'color' => $color,
                            'ip' => !empty($value->{'ip'}) ? (string)$value->{'ip'} : '',
                            'osType' => !empty($value->{'osType'}) ? (string)$value->{'osType'} : '',
                            'accessType' => !empty($value->{'accessType'}) ? (string)$value->{'accessType'} : '',
                            'browser' => !empty($value->{'browser'}) ? (string)$value->{'browser'} : '',
                            'accessTimeStamp' => !empty($value->{'accessTimeStamp'}) ? date('d-M-Y H:i:s', (((int)$value->{'accessTimeStamp'}) / 1000)) : 0,
                            'devicePath' => !empty($value->{'devicePath'}) ? (string)$value->{'devicePath'} : '',
                            'fileName' => !empty($value->{'fileName'}) ? (string)$value->{'fileName'} : '',
                            'cloudName' => !empty($value->{'cloudName'}) ? (int)$value->{'cloudName'} : '',
			    'userName' => !empty($value->{'userName'}) ? $value->{'userName'} : '',
                        );
                        $audits = array_merge(array($audit), $audits);
                    }
                }
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
			$metadata = [];
                }
                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits),
                    'metadata' => $metadata
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('noContent')
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
		exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function exportActivityHistoryToExcel(){
        if(!empty($_POST)){
            if(empty($_POST['allAdmins']) && empty($_POST['userNames']) && empty($_POST['users'])){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Please select a user to generate an excel file'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
            $numberDays = intval($timeDiff/86400) + 1;
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
	    if($numberDays > 365){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 365 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            /*if($numberDays > 16){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 15 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }*/	
	    if((isset($_POST['allAdmins'])) && (isset($_POST['allAdmins']))){
                $isAdmin = 'all';
            }
            if((isset($_POST['allAdmins'])) && (!isset($_POST['users']))){
                $isAdmin = 'admins';
            }
            if((!isset($_POST['allAdmins'])) && (isset($_POST['users']))){
                $isAdmin = 'users';
            }
            $headers = array(
                'token'          => $this->session->get('token'),
                'adminName'      => $this->session->get('userName'),
                //'isAdmin'        => !empty($_POST['allAdmins']) ? 'true' : 'false',
                'startDate'      => $fromDate,
                'endDate'        => $toDate,
                'userName'       => !empty($_POST['userNames']) ? $_POST['userNames'] : ''
            );
	    if(empty($_POST['userNames'])){
            	$headers['isAdmin'] = $isAdmin;
            }
            $result = $this->_model->exportActivityHistoryToExcel($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('exportActivityHistoryToExcel'),
                        'fileName' => !empty($_POST['userNames']) ? $_POST['userNames'] : 'admin'
                    );
                    echo json_encode($response);
                    exit;
                case (432):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('432')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function downloadExportActivityHistoryToExcel($fileName){
        $filePath = OVERVIEW_REPORT_PATH.'Audit_Overview_'.$this->session->get('userName').'.xls';
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=Audit_Overview_'.$this->session->get('userName').'.xls');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            //unlink($filePath);
        }else{
            header('Location: '.Url::basePath('/report/'.$_GET['from'].'?result=404'));
        }
    }
	
    public function exportActivityHistoryToPdf(){
        if(!empty($_POST)){
            if(empty($_POST['allAdmins']) && empty($_POST['userNames']) && empty($_POST['users'])){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Please select a user to generate PDF file'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
            $numberDays = intval($timeDiff/86400) + 1;
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
	    if($numberDays > 365){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 365 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            /*if($numberDays > 16){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 15 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }*/
	    if((isset($_POST['allAdmins'])) && (isset($_POST['allAdmins']))){
                $isAdmin = 'all';
            }
            if((isset($_POST['allAdmins'])) && (!isset($_POST['users']))){
                $isAdmin = 'admins';
            }
            if((!isset($_POST['allAdmins'])) && (isset($_POST['users']))){
                $isAdmin = 'users';
            }
            $headers = array(
                'token'          => $this->session->get('token'),
                'adminName'      => $this->session->get('userName'),
                //'isAdmin'        => !empty($_POST['allAdmins']) ? 'true' : 'false',
                'startDate'      => $fromDate,
                'endDate'        => $toDate,
                'userName'       => !empty($_POST['userNames']) ? $_POST['userNames'] : ''
            );
	    if(empty($_POST['userNames'])){
            	$headers['isAdmin'] = $isAdmin;
            }
            $result = $this->_model->exportActivityHistoryToPdf($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('exportActivityHistoryToPdf'),
                        'fileName' => !empty($_POST['userNames']) ? $_POST['userNames'] : 'admin'
                    );
                    echo json_encode($response);
                    exit;
                case (432):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('432')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function downloadExportActivityHistoryToPdf($fileName){
        $filePath = OVERVIEW_REPORT_PATH.'Audit_Overview_'.$this->session->get('userName').'.pdf';
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=Audit_Overview_'.$this->session->get('userName').'.pdf');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            unlink($filePath);
        }else{
            header('Location: '.Url::basePath('/report/'.$_GET['from'].'?result=404'));
        }
    }

    public function exportShareActivityHistoryToExcel(){
        if(!empty($_POST)){
            if(empty($_POST['allAdmins']) && empty($_POST['userNames'])){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Please select a user to generate an excel file'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
            $numberDays = intval($timeDiff/86400) + 1;
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            /*if($numberDays > 16){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 15 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }*/
	    if($numberDays > 365){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 365 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'          => $this->session->get('token'),
                'adminName'      => $this->session->get('userName'),
                'isAdmin'        => !empty($_POST['allAdmins']) ? 'true' : 'false',
                'startDate'      => $fromDate,
                'endDate'        => $toDate,
                'shareWithInOrg' => "false",
                'timeZone' 	 => $_POST['timeZone'],
                'userName'       => !empty($_POST['userNames']) ? $_POST['userNames'] : ''
            );
            if(SHARE_WITHIN_ORG){
                $headers['shareWithInOrg'] = "true";
            }
            $this->log(json_encode($headers), 'info');
            $result = $this->_model->exportShareActivityHistoryToExcel($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('exportActivityHistoryToExcel'),
                        'fileName' => !empty($_POST['userNames']) ? $_POST['userNames'] : 'admin'
                    );
                    echo json_encode($response);
                    exit;
                case (432):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('432')
                    );
                    echo json_encode($result);
                    exit();
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('noContent')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function checkFile(){
        $id = $_POST['id'];
        $name = $_POST['name'];
        $fileNameA = "failedFile.csv";
        $fileNameB = "failedFile.log";
        $path = "/parablu/support/failedFileslogs/";
        $pathA = $path.$id.DS.$name.DS.$fileNameA;
        $pathB = $path.$id.DS.$name.DS.$fileNameB;
        if(empty($id) || empty($name)){
                    echo json_encode(array(
                            'result' => 'fail',
                            'message' => $this->language->get('noData')
                        )
                    );
                    exit;
                }
                if(is_file($pathA) == '1' || is_file($pathB) == '1'){
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Log file found and downloading'
                    );
                    echo json_encode($response);
                    exit;
                }else{
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Log file not present'
                );
                echo json_encode($result);
                exit();
                }
    }
    
    public function downloadLogOne($id, $name){
        if(!empty($id) && !empty($name)){
            $fileNameA = "failedFile.csv";
            $fileNameB = "failedFile.log";
            $path = "/parablu/support/failedFileslogs/";
            $pathA = $path.$id.DS.$name.DS.$fileNameA;
            $pathB = $path.$id.DS.$name.DS.$fileNameB;
            if((!is_file($pathA) && !is_file($pathB)) || CONNECTION_STATUS()!=0){
                Url::redirect('deviceBackupHistory/'.$id);
            }
            if(is_file($pathA) == '1'){
                HEADER("Cache-Control: private");
                HEADER("Pragma: public");
                HEADER("Expires: ".GMDATE("D, d M Y H:i:s", MKTIME(DATE("H")+2, DATE("i"), DATE("s"), DATE("m"), DATE("d"), DATE("Y")))." GMT");
                HEADER("Last-Modified: ".GMDATE("D, d M Y H:i:s")." GMT");
                HEADER("Content-Type: application/octet-stream");
                HEADER("Content-Length: ".(string)(FILESIZE($pathA)));
                HEADER("Content-Disposition: attachment; filename=".$fileNameA);
                HEADER("Content-Transfer-Encoding: binary");
                session_write_close();
                if($file = FOPEN($pathA, 'rb')) {
                    while(!FEOF($file) && (CONNECTION_STATUS()==0)) {
                        PRINT(FREAD($file, 1024*8));
                        FLUSH();
                    }
                    FCLOSE($file);
                }
            }
            if(is_file($pathB) == '1'){
                HEADER("Cache-Control: private");
                HEADER("Pragma: public");
                HEADER("Expires: ".GMDATE("D, d M Y H:i:s", MKTIME(DATE("H")+2, DATE("i"), DATE("s"), DATE("m"), DATE("d"), DATE("Y")))." GMT");
                HEADER("Last-Modified: ".GMDATE("D, d M Y H:i:s")." GMT");
                HEADER("Content-Type: application/octet-stream");
                HEADER("Content-Length: ".(string)(FILESIZE($pathB)));
                HEADER("Content-Disposition: attachment; filename=".$fileNameB);
                HEADER("Content-Transfer-Encoding: binary");
                session_write_close();
                if($file = FOPEN($pathB, 'rb')) {
                    while(!FEOF($file) && (CONNECTION_STATUS()==0)) {
                        PRINT(FREAD($file, 1024*8));
                        FLUSH();
                    }
                    FCLOSE($file);
                }
            }
            return((CONNECTION_STATUS()==0) && !CONNECTION_ABORTED());
        }/*else{
            Url::redirect('logDetails/'.$id);
        }*/
    }

    public function downloadExportShareActivityHistoryToExcel($fileName){
        $this->log("I am here", "info");
        $filePath = OVERVIEW_REPORT_PATH.'Share_Audit_Overview_'.$this->session->get('userName').'.xls';
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=Share_Audit_Overview_'.$this->session->get('userName').'.xls');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            unlink($filePath);
        }else{
            header('Location: '.Url::basePath('/report/'.$_GET['from'].'?result=404'));
        }
    }
    
    public function getBackupAttemps(){
            $headers = array(
                'token'         => $this->session->get('token'),
		'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
                'batchId'       => $_POST['batchId']
            );
            $result = $this->_model->getBackupAttemps($headers);
            switch ($result['status']) {
                case (200):
                    $batchElements = [];
                    foreach($result['body']->{'data'}->{'backupAttemptElements'} as $value){
                        $batchElement = array(
                            'startTime' => !empty($value->{'startTime'}) ? (string)$value->{'startTime'} : '-',
                            'endTime' => !empty($value->{'endTime'}) ? (string)$value->{'endTime'} : '-',
                            'comments' => !empty($value->{'comments'}) ? (string)$value->{'comments'} : '-',
                            'status' => !empty($value->{'status'}) ? (string)$value->{'status'} : '-',
                            //'additionalInfo' => (string)$value->{'additionalInfo'},
                            'noOfFiles' => !empty($value->{'noOfFiles'}) ? (string)$value->{'noOfFiles'} : '-',
                            'uploadedSize' => !empty($value->{'uploadedSize'}) ? (string)$value->{'uploadedSize'} : '-',
                            'uploadedPercentage' => !empty($value->{'uploadedPercentage'}) ? (string)$value->{'uploadedPercentage'} : '-',
			    'totalNoOfFiles' => !empty($value->{'totalNoOfFiles'}) ? $value->{'totalNoOfFiles'} : '-',
			    'startTimeLong' => !empty($value->{'startTimeLong'}) ? (string)$value->{'startTimeLong'} : 0,
                            'endTimeLong' => !empty($value->{'endTimeLong'}) ? (string)$value->{'endTimeLong'} : 0,
                        );
                        $batchElements = array_merge(array($batchElement), $batchElements);
                    }
                    $response = array(
                        'result' => 'success',
                        'batchElements' => array_reverse($batchElements)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    /*unusual activity starts*/
    public function unusualActivityHistory($userName, $deviceUUID, $deviceName){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('history'),
	    'crumb1' => $this->language->get('Unusual Activity History'),
	    'crumb2' => $this->language->get('Unusual Device Activity History'),
            'userName' => base64_encode($userName),
            'deviceName' => base64_encode($deviceName),
            'deviceUUID' => $deviceUUID,
	    'currentUser' => $userName,
	    'currentDevice' => $deviceName,
	    'csrf_token' => $this->setCSRFToken(),
	    'active' => 'unusualActivity',
            'loggedInUser' => $this->session->all()
        );
	if($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true'){
                Url::redirect('404');
        }
	$this->log("username : ".$userName,"info");
	$this->log("username : ".$userName,"info");
	$this->log("username : ".$deviceName,"info");
	$this->log("username : ".base64_encode($deviceName),"info");
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/deviceUnusualActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function unusualActivityHistoryForAll(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
	Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => 'Manage Unusual Activities',
            'csrf_token' => $this->setCSRFToken(),
	    'active' => 'unusualActivity',
	    'userName' => '',
            'deviceName' => '',
            'deviceUUID' => '',
            'loggedInUser' => $this->session->all()
        );
	if($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true'){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/unusualActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUnusualActivityHistory(){
	Auth::allowOnly('readOnlyAdmin');
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
	    'Accept'        => 'application/json',
	    'onlyActive'    => !empty($_POST['onlyActive']) ? $_POST['onlyActive'] : 'false',
	    'isAuditHistory' => !empty($_POST['isAuditHistory']) ? $_POST['isAuditHistory'] : 'false',
    	);
	$_POST['pageNumber'] = 1;
	$_POST['userName'] = !empty($_POST['userName']) ? base64_encode($_POST['userName']) : '';
        $_POST['deviceName'] = !empty($_POST['deviceName']) ? base64_encode($_POST['deviceName']) : '';
        $_POST['deviceUUID'] = !empty($_POST['deviceUUID']) ? $_POST['deviceUUID'] : '';
        $result = $this->_model->getUnusualActivityHistory($headers, $_POST['pageNumber'], $_POST['userName'], $_POST['deviceName'], $_POST['deviceUUID']);
        switch ($result['status']) {
            case (200):
                $audits = [];
                $metadata = [];
                if(!empty($result['body']->{'data'}->{'audits'})){
                    foreach($result['body']->{'data'}->{'audits'} as $value){                        
			if($value->{'active'} == true){
				$status = 'Active';
			}else{
				$status = 'Resolved';
			}
			if((string)$value->{'alertType'} == 'other'){
                                $alertType = 'Other';
                        }else{
                                $alertType = (string)$value->{'alertType'};
                        }
			$audit = array(
			    'userName' => (string)$value->{'userName'},
                            'alertType' => $alertType,
                            'deviceName' => (string)$value->{'deviceName'},
                            'actionUsingObject' => (string)$value->{'actionUsingObject'},
                            'actionType' => !empty($value->{'actionType'}) ? (string)$value->{'actionType'} : '',
                            'numberOfFilesInfected' => (string)$value->{'numberOfFilesInfected'},
                            'totalNumberOfFiles' => (string)$value->{'totalNumberOfFiles'},
                            'timestamp' => (int)$value->{'timestamp'},
                            'time' => date('d-M-Y H:i:s', (((int)$value->{'timestamp'}) / 1000)),
                            'status' => $status,
			    'backupStartTimestamp' => (string)$value->{'backupStartTimestamp'},
			    'backupStartTime' => date('d-M-Y H:i:s', (((int)$value->{'backupStartTimestamp'}) / 1000)),
			    'time' => (string)$value->{'time'},
			    'deviceUUID' => $value->{'deviceUUID'},
			    'osType' => (string)$value->{'osType'},
			    'id' => $value->{'id'},
			    'batchId' => $value->{'batchId'},
			    'isDevicequarantined' => $value->{'devicequarantined'},
			    'numberOfFilesDeleted' => $value->{'numberOfFilesDeleted'},
			    'numberOfNewFiles' => $value->{'numberOfNewFiles'},
			    'numberOfFilesmodified' => $value->{'numberOfFilesmodified'}
                        );
                        $audits = array_merge(array($audit), $audits);
                    }
		}
		$this->log("AUDITS : ".json_encode($audits),"info");
		$newAudits = [];
		if(!empty($result['body']->{'data'}->{'audits'})){
			foreach($result['body']->{'data'}->{'audits'} as $value){
				//if($newAudits['deviceName'] != (string)$value->{'deviceName'} && $newAudits['userName'] != (string)$value->{'userName'}){
				if($value->{'active'} == true){
                                        $status = 'Active';
                                }else{
                                        $status = 'Resolved';
                                }
				$newAudit = array(
				'deviceName' => (string)$value->{'deviceName'},
				'userName' => (string)$value->{'userName'},
				'deviceUUID' => $value->{'deviceUUID'},
				'isDevicequarantined' => $value->{'devicequarantined'},
                                //'status' => $status,
			);
				$newAudits = array_merge(array($newAudit), $newAudits);
				//}
			}
		}
		$this->log("NEW AUDITS : ".json_encode($newAudits),"info");
		$kkk = array_unique($newAudits, SORT_REGULAR);
		$this->log("KKKKK : ".json_encode($kkk),"info");
		$infFiles = [];
		$delFiles = [];
		$newFiles = [];
		$modifiedFiles = [];
		$totalFiles = [];
		$alertType = [];
		$backupStartTime = [];
		if(!empty($result['body']->{'data'}->{'audits'})){
			foreach($result['body']->{'data'}->{'audits'} as $value){
				array_push($infFiles,$value->{'numberOfFilesInfected'});
				array_push($delFiles,$value->{'numberOfFilesDeleted'});
				array_push($newFiles,$value->{'numberOfNewFiles'});
				array_push($modifiedFiles,$value->{'numberOfFilesmodified'});
				array_push($totalFiles,$value->{'totalNumberOfFiles'});
				array_push($alertType,$value->{'alertType'});
				array_push($backupStartTime, date('d-M-Y H:i:s', (((int)$value->{'backupStartTimestamp'}) / 1000)));
			}
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
		}else{
			$metadata = [];
		}
		$this->log("vvvvvvvvvvv : ".$result['header']->{'container'}['total-alerts'],"info");
                $response = array(
                    'result' => 'success',
		    'audits' => array_reverse($audits),
		    'auditsUnique' => array_reverse($kkk),
		    'totalAlerts' => $result['header']->{'container'}['total-alerts'],
		    'totalActiveAlerts' => $result['header']->{'container'}['total-active-alerts'],
		    'totalDevicesAffected' => $result['header']->{'container'}['total-devices-affected'],
		    'userRole' => !empty($result['header']->{'container'}['user-role']) ? $result['header']->{'container'}['user-role'] : '',
		    'metadata' => $metadata,
		    'totalFiles' => $totalFiles,
		    'infFiles' => array_reverse($infFiles),
		    'delFiles' => array_reverse($delFiles),
		    'newFiles' => array_reverse($newFiles),
		    'modifiedFiles' => array_reverse($modifiedFiles),
		    'alertType' => $alertType,
		    'backupStartTime' => array_reverse($backupStartTime)
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
		exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getUnusualActivityHistoryNavigate(){
	Auth::allowOnly('readOnlyAdmin');
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'Content-Type'  => 'application/json',
	    'Accept'        => 'application/json',
	    'onlyActive'    => !empty($_POST['onlyActive']) ? $_POST['onlyActive'] : 'false',
	    'isAuditHistory' => !empty($_POST['isAuditHistory']) ? $_POST['isAuditHistory'] : 'false',
	);
        if($this->session->get('admin') != true){
            $headers['userName'] = $this->session->get('userName');
            $headers['pbAuditUserName'] = $this->session->get('userName');
	}
	$_POST['userName'] = !empty($_POST['userName']) ? base64_encode($_POST['userName']) : '';
        $_POST['deviceName'] = !empty($_POST['deviceName']) ? base64_encode($_POST['deviceName']) : '';
        $_POST['deviceUUID'] = !empty($_POST['deviceUUID']) ? $_POST['deviceUUID'] : '';
	$result = $this->_model->getUnusualActivityHistoryNavigate($headers, $_POST['url'], $_POST['userName'], $_POST['deviceName'], $_POST['deviceUUID']);
        switch ($result['status']) {
 	    case (200):
                $audits = [];
                $metadata = [];
                if(!empty($result['body']->{'data'}->{'audits'})){
                    foreach($result['body']->{'data'}->{'audits'} as $value){                        
			if($value->{'active'} == true){
				$status = 'Active';
			}else{
				$status = 'Resolved';
			}
			if((string)$value->{'alertType'} == 'other'){
                                $alertType = 'Other';
                        }else{
                                $alertType = (string)$value->{'alertType'};
                        }
			$audit = array(
			    'userName' => (string)$value->{'userName'},
                            'alertType' => $alertType,
                            'deviceName' => (string)$value->{'deviceName'},
                            'actionUsingObject' => (string)$value->{'actionUsingObject'},
                            'actionType' => !empty($value->{'actionType'}) ? (string)$value->{'actionType'} : '',
                            'numberOfFilesInfected' => (string)$value->{'numberOfFilesInfected'},
                            'totalNumberOfFiles' => (string)$value->{'totalNumberOfFiles'},
                            'timestamp' => (int)$value->{'timestamp'},
                            'time' => date('d-M-Y H:i:s', (((int)$value->{'timestamp'}) / 1000)),
                            'status' => $status,
			    'backupStartTimestamp' => (string)$value->{'backupStartTimestamp'},
			    'backupStartTime' => date('d-M-Y H:i:s', (((int)$value->{'backupStartTimestamp'}) / 1000)),
			    'time' => (string)$value->{'time'},
			    'deviceUUID' => $value->{'deviceUUID'},
			    'osType' => (string)$value->{'osType'},
			    'id' => $value->{'id'},
			    'batchId' => $value->{'batchId'},
			    'isDevicequarantined' => $value->{'devicequarantined'},
			    'numberOfFilesDeleted' => $value->{'numberOfFilesDeleted'},
			    'numberOfNewFiles' => $value->{'numberOfNewFiles'},
			    'numberOfFilesmodified' => $value->{'numberOfFilesmodified'}
                        );
                        $audits = array_merge(array($audit), $audits);
                    }
		}
		$this->log("AUDITS : ".json_encode($audits),"info");
		$newAudits = [];
		if(!empty($result['body']->{'data'}->{'audits'})){
			foreach($result['body']->{'data'}->{'audits'} as $value){
				//if($newAudits['deviceName'] != (string)$value->{'deviceName'} && $newAudits['userName'] != (string)$value->{'userName'}){
				if($value->{'active'} == true){
                                        $status = 'Active';
                                }else{
                                        $status = 'Resolved';
                                }
				$newAudit = array(
				'deviceName' => (string)$value->{'deviceName'},
				'userName' => (string)$value->{'userName'},
				'deviceUUID' => $value->{'deviceUUID'},
				'isDevicequarantined' => $value->{'devicequarantined'},
                                //'status' => $status,
			);
				$newAudits = array_merge(array($newAudit), $newAudits);
				//}
			}
		}
		$this->log("NEW AUDITS : ".json_encode($newAudits),"info");
		$kkk = array_unique($newAudits, SORT_REGULAR);
		$this->log("KKKKK : ".json_encode($kkk),"info");
		$infFiles = [];
		$delFiles = [];
		$newFiles = [];
		$modifiedFiles = [];
		$totalFiles = [];
		$alertType = [];
		$backupStartTime = [];
		if(!empty($result['body']->{'data'}->{'audits'})){
			foreach($result['body']->{'data'}->{'audits'} as $value){
				array_push($infFiles,$value->{'numberOfFilesInfected'});
				array_push($delFiles,$value->{'numberOfFilesDeleted'});
				array_push($newFiles,$value->{'numberOfNewFiles'});
				array_push($modifiedFiles,$value->{'numberOfFilesmodified'});
				array_push($totalFiles,$value->{'totalNumberOfFiles'});
				array_push($alertType,$value->{'alertType'});
				array_push($backupStartTime, date('d-M-Y H:i:s', (((int)$value->{'backupStartTimestamp'}) / 1000)));
			}
		}
		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
		}else{
			$metadata = [];
		}
		$this->log("vvvvvvvvvvv : ".$result['header']->{'container'}['total-alerts'],"info");
                $response = array(
                    'result' => 'success',
		    'audits' => array_reverse($audits),
		    'auditsUnique' => array_reverse($kkk),
		    'totalAlerts' => $result['header']->{'container'}['total-alerts'],
		    'totalActiveAlerts' => $result['header']->{'container'}['total-active-alerts'],
		    'totalDevicesAffected' => $result['header']->{'container'}['total-devices-affected'],
		    'userRole' => !empty($result['header']->{'container'}['user-role']) ? $result['header']->{'container'}['user-role'] : '',
		    'metadata' => $metadata,
		    'totalFiles' => $totalFiles,
		    'infFiles' => array_reverse($infFiles),
		    'delFiles' => array_reverse($delFiles),
		    'newFiles' => array_reverse($newFiles),
		    'modifiedFiles' => array_reverse($modifiedFiles),
		    'alertType' => $alertType,
		    'backupStartTime' => array_reverse($backupStartTime)
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                    );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
		 );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function unusualActivityAction(){	    
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'action' => $_POST['action'],
                'id' => !empty($_POST['id']) ? $_POST['id'] : '',
                'deviceUUID' => $_POST['deviceUUID'],
                'userName' => $this->session->get('userName')
            );
            $result = $this->_model->unusualActivityAction($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Action performed successfully',
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (447):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function uploadInfFile(){
    	$this->log("Called saveEPAWIndows ","info");
	//start
	$errors = [];
    	if (isset($_FILES['infFileName'])) {
		$path = "/parablu/RWSampleFiles/";
    			if (!is_dir($path)) {
    				$result = array(
                                	'result' => 'fail',
                                	'msg' => 'No Directory Found'
    				);
		die(json_encode($result));
    	}
    	            $file_name = $_FILES['infFileName']['name'];
    	            $file_tmp = $_FILES['infFileName']['tmp_name'];
    	            $file_type = $_FILES['infFileName']['type'];
    	            $file_size = $_FILES['infFileName']['size'];
    	            $file_ext = strtolower(end(explode('.', $_FILES['infFileName']['name'])));

    	            $file = $path . $file_name;
    	            $this->log("file :  ".$file,"info");
    	                if ($errors) {
    	                        $this->log("ERRORS WHILE UPLOADING".json_encode($errors),"info");
    	                        $result = array(
    	                            'result' => 'fail_size_exceeds',
    	                            'msg'    => 'Failed to upload file'
    	                        );
    	                        die(json_encode($result));
    	                }
    		            if (empty($errors)) {
    		                $this->log("success ","info");
    		                move_uploaded_file($file_tmp, $file);
    		                chmod($file, 0777);
    						$response = array(
    		                        'result' => 'success',
    		                        'msg'    => 'File uploaded succesfully'
    		                    );
    		                    echo json_encode($response);
    		                    exit;
    					}else{
    						$response = array(
    	                        'result' => 'fail',
    	                        'msg'    => 'Failed to upload file'
    	                    );
    	                    echo json_encode($response);
    	                    exit;
    					}
    	}else{
    	//	$this->uploadInfFileApi();
    	}
    	//end
    }

    public function uploadInfFileApi(){
    	$this->log("Called uploadInfFileApi "."/parablu/RWSampleFiles/".$_FILES["infFileName"]["name"],"info");
    	$headers = array(
    		//'Content-Type'  => 'application/json',
    		'token'         => $this->session->get('token'),
    		'file-path' 	 => base64_encode("/parablu/RWSampleFiles/".$_FILES["infFileName"]["name"]),
    		'userName'	=> base64_encode($this->session->get('userName'))
    	);
    	$this->log("jjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
    	$this->log("jjjjjjjjjjjjjjjj : ".json_encode($_FILES['infFileName']),"info");
    	$result = $this->_model->uploadInfFileApi($headers);
    	switch ($result['status']) {
    		case (200):
    			/*$path = "/parablu/RWSampleFiles/".$_FILES["infFileName"]["name"];
    			unlink($path);*/
			$response = array(
				'result' => 'success',
				'response' => $result,
				'msg'    => 'File Uploaded successfully.'
			);
			echo json_encode($response);
			exit;
		case (421):
			$result = array(
				'result' => 'fail',
				'msg' => $this->language->get('421')
			);
			echo json_encode($result);
			exit();
		case (412):
			$result = array(
				'result' => 'fail',
				'msg' => 'Selected file should have proper naming convention'
			);
			echo json_encode($result);
			exit();
		case (507):
			$result = array(
				'result' => 'fail',
				'msg' => 'Failed to download file from DNS'
			);
			echo json_encode($result);
			exit();
		case (500):
			$result = array(
				'result' => 'fail',
				'msg' => $this->language->get('500')
			);
			echo json_encode($result);
			exit();
		case (0):
			$result = array(
				'result' => 'fail',
				'msg' => $this->language->get('0')
			);
			echo json_encode($result);
			exit();
		default:
			$result = array(
				'result' => 'fail',
				'response' => $result,
				'msg' => $this->language->get('default')
			);
			echo json_encode($result);
			exit();
    	}
    }

    public function getInfStatistics(){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getInfStatistics($headers);
            $fileCount = !empty($result['header']->container['file-count']) ? $result['header']->container['file-count'] : 0 ;
            switch ($result['status']) {
	    case (200):
		    $quarantineList = [];
                    if(!empty($result['body']->{'rwSampleFileElementList'})){
                        foreach($result['body']->{'rwSampleFileElementList'} as $value){
                            $file = array(
				'fileName'    => (string)$value->{'fileName'},
				'id' => $value->{'id'},
                                'timestampInMillis'    => $value->{'timestamp'},
                                'timestamp'    => (!empty($value->{'timestamp'}) && $value->{'timestamp'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'timestamp'}) / 1000)) : '',
                            );
                            $quarantineList = array_merge(array($file), $quarantineList);
                        }
                    }
                    $response = array(
                        'result' => 'success',
			'fileCount' => $fileCount,
			'quarantineList' => $quarantineList
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
			 'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function quarantineList(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        $data = array(
	    'title' => $this->language->get('history'),
	    'crumb1' => $this->language->get('Unusual Activity History'),
            'crumb2' => $this->language->get('Quarantine Files List'),
            'csrf_token' => $this->setCSRFToken(),
            'active' => 'devices',
            'loggedInUser' => $this->session->all()
        );
	if($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true'){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/quarantineList', $data);
        View::renderTemplate('footer', $data);
    }

    public function getQuarantineList(){
            $headers = array(
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
                'token'         => $this->session->get('token'),
            );
            $result = $this->_model->getQuarantineList($headers);
            $this->log('Result:'. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $fileVersions = [];
                    if($result['body']->{'backupListElement'}->{'fileElementList'}){
                        foreach($result['body']->{'backupListElement'}->{'fileElementList'} as $value){
                            $fileVersion = array(
                                'backupId'            => (string)$value->{'backupId'},
                                'baseFolder'            => (string)$value->{'isBasefolder'},
                                'externalStorage'       => (string)$value->{'isExternalStorage'},
                                'filePath'              => (string)$value->{'filePath'},
                                'fileDevice'            => (string)$value->{'fileDevice'},
                                'fileName'              => (string)$value->{'fileName'},
                                'fileUser'              => (string)$value->{'fileUser'},
                                'folder'                => (string)$value->{'folder'},
                                'clientModifiedTimeInMillis'    => $value->{'lastClientModifiedTime'},
                                'serverModifiedTimeInMillis'    => $value->{'lastServerModifiedTime'},
                                'clientModifiedTime'    => (!empty($value->{'lastClientModifiedTime'}) && $value->{'lastClientModifiedTime'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'lastClientModifiedTime'}) / 1000)) : '',
                                'serverModifiedTime'    => (!empty($value->{'lastServerModifiedTime'}) && $value->{'lastServerModifiedTime'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'lastServerModifiedTime'}) / 1000)) : '',
                                'checkSum'              => (string)$value->{'checksum'},
                                'exists'                => (string)$value->{'exists'},
                                'rawSize'               => (int)$value->{'size'},
                                'size'                  => $this->getFileSize((string)$value->{'size'}),
                                'version'               => 'Version ',
                                'status'                => (string)$value->{'status'},
                                'storagePlace'          => (string)$value->{'storagePlace'},
                                'fsPath'                => (string)$value->{'fsPath'}
                            );
                            $fileVersions = array_merge(array($fileVersion), $fileVersions);
                        }
                    }
                    $response = array(
                        'result' => 'success',
                        'fileVersions' => array_reverse($fileVersions)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function deleteRwFile(){
            $headers = array(
                'token' => $this->session->get('token'),
                'id'  => $_POST['id']
            );
            $result = $this->_model->deleteRwFile($headers);
            switch ($result['status']) {
            case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'File deleted.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                         'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function getQuarantineDevices(){
            $headers = array(
                    'token'         => $this->session->get('token'),
                    'Content-Type'  => 'application/json',
                    'Accept'        => 'application/json',
            );
            $result = $this->_model->getQuarantineDevices($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'quarantineDevices' => $result['body']->{'data'}->{'devices'}
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $result = array(
                        'result' => 'fail_empty',
                        'quarantineDevices' => [],
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
		    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    /*unusual activity ends*/
	
    public function ransomwareActivityHistory(){
	if(($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true') || ($this->session->get('userType') == 'user' && $this->session->get('MSP_Environment_Enabled') == 'true')){
                Url::redirect('404');
        }
        $data = array(
            'title' => $this->language->get('history'),
            'crumb1' => $this->language->get('Unusual Activity History'),
            'csrf_token' => $this->setCSRFToken(),
	    'loggedInUser' => $this->session->all(),
	    'active' => 'unusualActivity'
        );
	if($this->session->get('userType') == 'delegatedAdmin' && $this->session->get('MSP_Environment_Enabled') == 'true'){
                Url::redirect('404');
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/ransomwareActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function exportUnusualActivityHistoryToExcel(){
        if(!empty($_POST)){
            if(empty($_POST['allAdmins']) && empty($_POST['userNames']) && empty($_POST['users'])){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Please select a user to generate an excel file'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
            $numberDays = intval($timeDiff/86400) + 1;
            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
		echo $jsonData;
                exit;
            }
            if($numberDays > 365){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Unusual Activity History can only be generated for 365 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            if($_POST['allAdmins'] == 'admins' && $_POST['users'] == 'users'){
                $isAdmin = 'all';
            }
            if($_POST['allAdmins'] == 'admins' && $_POST['users'] != 'users'){
                $isAdmin = 'admins';
            }
            if($_POST['allAdmins'] != 'admins' && $_POST['users'] == 'users'){
                $isAdmin = 'users';
            }
            $headers = array(
                'token'          => $this->session->get('token'),
                'adminName'      => $this->session->get('userName'),
                //'isAdmin'        => !empty($_POST['allAdmins']) ? 'true' : 'false',
                'startDate'      => $fromDate,
                'endDate'        => $toDate,
                'userName'       => !empty($_POST['userNames']) ? $_POST['userNames'] : ''
            );
            if(empty($_POST['userNames'])){
                $headers['isAdmin'] = $isAdmin;
            }
            $result = $this->_model->exportUnusualActivityHistoryToExcel($headers);
            switch ($result['status']) {
                case (200):
		    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('exportUnusualActivityHistoryToExcel'),
                        'fileName' => !empty($_POST['userNames']) ? $_POST['userNames'] : 'admin'
                    );
                    echo json_encode($response);
                    exit;
                case (432):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('432')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
		default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
	
    public function downloadExportUnusualActivityHistoryToExcel($fileName){
        $filePath = OVERVIEW_REPORT_PATH.'UnusualActivity_Audit_Overview_'.$this->session->get('userName').'.xls';
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=UnusualActivity_Audit_Overview_'.$this->session->get('userName').'.xls');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            //unlink($filePath);
        }else{
            header('Location: '.Url::basePath('/report/'.$_GET['from'].'?result=404'));
        }
    }
	
	

}
