/*
 * Decompiled with CFR 0.152.
 */
package com.example.shabaazutility.dao;

import com.example.shabaazutility.domain.DeviceBackupOverview;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceBackupOverviewDao {
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<DeviceBackupOverview> getUsersWithFullBackupCompleted() {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"BACKUP"), Criteria.where((String)"isDeviceBolcked").is((Object)false)});
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        System.out.println("getUsersWithFullBackupCompleted Query= " + query);
        List deviceBackupOverviews = this.mongoTemplate.find(query, DeviceBackupOverview.class);
        return deviceBackupOverviews;
    }

    public void blockDevices(List<String> deviceUUIDs) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").in(deviceUUIDs)});
        Update update = new Update();
        update.set("isDeviceBolcked", (Object)true);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, DeviceBackupOverview.class);
    }
}

