/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.msputility;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.parablu.msputility.request.MspRequest;
import com.parablu.msputility.service.MspService;
import java.io.File;
import java.io.IOException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class MspUtilityApplication {
    public static void main(String[] args) throws StreamReadException, DatabindException, IOException {
        try {
            ConfigurableApplicationContext context = SpringApplication.run(MspUtilityApplication.class, (String[])args);
            MspService mspService = (MspService)context.getBean(MspService.class);
            File file = null;
            if (args != null && args.length == 1) {
                System.out.println("getting the file path = " + args[0]);
                file = new File(args[0]);
                if (file.exists()) {
                    System.out.println("File path is valid.");
                } else {
                    System.out.println("File path is invalid.");
                }
            } else {
                System.out.println("There is error in arguments passed... please pass valid arguments!!");
                return;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            MspRequest mspRequest = (MspRequest)objectMapper.readValue(file, MspRequest.class);
            mspService.insertPreRequisiteData(mspRequest);
        }
        catch (Exception e) {
            System.out.println("There is an error while running the utility e= " + e);
            e.printStackTrace();
        }
    }
}

