/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CrawlPolicyUtility {
    private static void updateUser(Document user, String policyType, String newPolicyName, MongoDatabase db) {
        String userName = user.getString((Object)"userName");
        BasicDBObject updateQuery = new BasicDBObject();
        BasicDBObject updateFields = new BasicDBObject();
        if ("ODB".equalsIgnoreCase(policyType)) {
            updateFields.append("oneDrivePolicyName", (Object)newPolicyName);
        } else if ("EXCHANGE".equalsIgnoreCase(policyType)) {
            updateFields.append("exchangePolicyName", (Object)newPolicyName);
        } else if ("SHAREPOINT".equalsIgnoreCase(policyType)) {
            updateFields.append("spPolicyName", (Object)newPolicyName);
        }
        System.out.println(".....userName-mail...." + userName + "...poltype..." + policyType);
        updateQuery.append("$set", (Object)updateFields);
        MongoCollection userDBCollection = db.getCollection("USER");
        BasicDBObject userPolicyQuery = new BasicDBObject();
        userPolicyQuery.append("_id", user.get((Object)"_id"));
        UpdateResult updateOne = userDBCollection.updateOne((Bson)userPolicyQuery, (Bson)updateQuery);
        System.out.println("....updateuser..." + userName + "..." + updateOne.getModifiedCount());
    }

    private static void updateOverview(Document user, String policyType, String newPolicyName, MongoDatabase db) {
    }

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty((String)mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI msguri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablumsg");
        MongoClient msgclient = new MongoClient(msguri);
        MongoDatabase msgdb = msgclient.getDatabase(msguri.getDatabase());
        System.out.println("connectivity success.... ");
        MongoCollection officeDBCollection = db.getCollection("OFFICE_BACKUP_POLICY");
        FindIterable officePolicyList = officeDBCollection.find();
        HashMap<String, String> policyMap = new HashMap<String, String>();
        HashMap<String, String> newpolicyMap = new HashMap<String, String>();
        for (Document policy : officePolicyList) {
            String policyName = policy.getString((Object)"policyName");
            String policyType = policy.getString((Object)"policyType");
            String newPolicyName = policyName.toUpperCase();
            policyName = policyName.toUpperCase();
            System.out.println("...before policy..." + policyName);
            if (policyName.startsWith("ODB_")) {
                policyName = policyName.replaceFirst("ODB_", "");
            }
            if (policyName.startsWith("EX_")) {
                policyName = policyName.replaceFirst("EX_", "");
            }
            if (policyName.startsWith("SP_")) {
                policyName = policyName.replaceFirst("SP_", "");
            }
            System.out.println("....addding to map...." + policyName);
            policyMap.put("BACKUP_BATCH_" + policyName.toUpperCase(), policyType);
            if ("ODB".equalsIgnoreCase(policyType) || "ONEDRIVE".equalsIgnoreCase(policyType)) {
                newPolicyName = "ODB_" + policyName;
            } else if ("EXCHANGE".equalsIgnoreCase(policyType)) {
                newPolicyName = "EX_" + policyName;
            } else if ("SHAREPOINT".equalsIgnoreCase(policyType)) {
                newPolicyName = "SP_" + policyName;
            }
            newpolicyMap.put("BACKUP_BATCH_" + policyName.toUpperCase(), "BACKUP_BATCH_" + newPolicyName.toUpperCase());
        }
        System.out.println(String.valueOf(policyMap.size()) + "*****************************************************************************************************************************");
        List existingCollection = (List)msgdb.listCollectionNames().into(new ArrayList());
        for (String exiColl : existingCollection) {
            if (!exiColl.startsWith("BACKUP_BATCH_")) continue;
            System.out.println("....vla...." + exiColl);
            if (!policyMap.containsKey(exiColl)) continue;
            String newCollectTable = (String)newpolicyMap.get(exiColl);
            System.out.println(String.valueOf(newCollectTable) + "...This collection exists....." + exiColl);
            try {
                MongoNamespace mongoNamespace = new MongoNamespace("parablumsg." + newCollectTable);
                msgdb.getCollection(exiColl).renameCollection(mongoNamespace);
                System.out.println(String.valueOf(exiColl) + "..collection convertedto.." + newCollectTable);
            }
            catch (MongoCommandException exception) {
                if (exception.getMessage().contains("target namespace exists")) continue;
                exception.printStackTrace();
            }
        }
        for (String polmap : policyMap.keySet()) {
            System.out.println("...polmap...." + polmap);
        }
        System.out.println("Well its Done ");
    }
}

