/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class BackupPolicyUtility {
    private static void updateUser(Document user, String policyType, String newPolicyName, MongoDatabase db) {
        String userName = user.getString((Object)"userName");
        BasicDBObject updateQuery = new BasicDBObject();
        BasicDBObject updateFields = new BasicDBObject();
        if ("ODB".equalsIgnoreCase(policyType)) {
            updateFields.append("oneDrivePolicyName", (Object)newPolicyName);
        } else if ("EXCHANGE".equalsIgnoreCase(policyType)) {
            updateFields.append("exchangePolicyName", (Object)newPolicyName);
        } else if ("SHAREPOINT".equalsIgnoreCase(policyType)) {
            updateFields.append("spPolicyName", (Object)newPolicyName);
        }
        System.out.println(".....userName-mail...." + userName + "...poltype..." + policyType);
        updateQuery.append("$set", (Object)updateFields);
        MongoCollection userDBCollection = db.getCollection("USER");
        BasicDBObject userPolicyQuery = new BasicDBObject();
        userPolicyQuery.append("_id", user.get((Object)"_id"));
        UpdateResult updateOne = userDBCollection.updateOne((Bson)userPolicyQuery, (Bson)updateQuery);
        System.out.println("....updateuser..." + userName + "..." + updateOne.getModifiedCount());
    }

    private static void updateOverview(Document user, String policyType, String newPolicyName, MongoDatabase db) {
        String userName = user.getString((Object)"userName");
        BasicDBObject updateQuery = new BasicDBObject();
        BasicDBObject updateFields = new BasicDBObject();
        if ("ODB".equalsIgnoreCase(policyType)) {
            updateFields.append("oneDrivePolicyName", (Object)newPolicyName);
        } else if ("EXCHANGE".equalsIgnoreCase(policyType)) {
            updateFields.append("exchangePolicyName", (Object)newPolicyName);
        } else if ("SHAREPOINT".equalsIgnoreCase(policyType)) {
            updateFields.append("spPolicyName", (Object)newPolicyName);
        }
        System.out.println(".....overview...." + userName + "...poltype..." + policyType);
        updateQuery.append("$set", (Object)updateFields);
        MongoCollection deviceBkpOverviewCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", (Object)userName));
        if ("ODB".equalsIgnoreCase(policyType)) {
            System.out.println("....onedriveupdate...");
            whereQuery.add(new BasicDBObject("deviceType", (Object)"ONEDRIVE"));
        } else {
            whereQuery.add(new BasicDBObject("deviceType", (Object)policyType.toUpperCase()));
        }
        BasicDBObject andQuery = new BasicDBObject();
        andQuery.put((Object)"$and", whereQuery);
        UpdateResult updateOne = deviceBkpOverviewCollection.updateOne((Bson)andQuery, (Bson)updateQuery);
        System.out.println("....updatequertydeviceoverview...." + updateOne.getModifiedCount());
        System.out.println(String.valueOf(policyType) + "&&&&&&&&&&&&&&policy&&&&&&&&&&&" + newPolicyName + "...." + userName);
    }

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty((String)mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success.... ");
        MongoCollection officeDBCollection = db.getCollection("OFFICE_BACKUP_POLICY");
        MongoCollection userDBCollection = db.getCollection("USER");
        FindIterable officePolicyList = officeDBCollection.find();
        MongoCollection reportSchedulerCollection = db.getCollection("REPORT_SCHEDULER");
        FindIterable scheduleList = reportSchedulerCollection.find();
        for (Document scheduler : scheduleList) {
            String schedulerName = scheduler.getString((Object)"schedulerName");
            String productType = scheduler.getString((Object)"productType");
            if (StringUtils.isEmpty((String)productType) || !"ODB".equalsIgnoreCase(productType) && !"EXCHANGE".equalsIgnoreCase(productType) && !"SHAREPOINT".equalsIgnoreCase(productType) && !"ONEDRIVE".equalsIgnoreCase(productType)) continue;
            List policyNames = (List)scheduler.get((Object)"policyNames");
            ArrayList<String> newPolicyNames = new ArrayList<String>();
            if (policyNames != null) {
                for (String policyNameDef : policyNames) {
                    System.out.println(String.valueOf(schedulerName) + "..schedule$$..." + policyNameDef);
                    boolean nameAdded = false;
                    for (Document policy : officePolicyList) {
                        String policyName = policy.getString((Object)"policyName");
                        String policyType = policy.getString((Object)"policyType");
                        if (policyName.startsWith("STATISTIC") || policyName.startsWith("STAGING") || policyName.startsWith("SP_") || policyName.startsWith("ODB_") || policyName.startsWith("EX_") || !policyType.equalsIgnoreCase(productType) || !policyName.equalsIgnoreCase(policyNameDef)) continue;
                        String newPolicyName = policyName;
                        if ("ODB".equalsIgnoreCase(policyType)) {
                            newPolicyName = "ODB_" + policyName;
                        } else if ("EXCHANGE".equalsIgnoreCase(policyType)) {
                            newPolicyName = "EX_" + policyName;
                        } else if ("SHAREPOINT".equalsIgnoreCase(policyType)) {
                            newPolicyName = "SP_" + policyName;
                        }
                        System.out.println(String.valueOf(policyNameDef) + "...newpolicy to update..." + newPolicyName);
                        newPolicyNames.add(newPolicyName);
                        nameAdded = true;
                    }
                    if (nameAdded) continue;
                    newPolicyNames.add(policyNameDef);
                }
                for (String name : newPolicyNames) {
                    System.out.println(".....newnames..." + name);
                }
            }
            if (CollectionUtils.isEmpty(newPolicyNames)) continue;
            BasicDBObject scheduleQuery = new BasicDBObject();
            scheduleQuery.append("_id", scheduler.get((Object)"_id"));
            BasicDBObject updateQuery = new BasicDBObject();
            BasicDBObject updateFields = new BasicDBObject();
            updateQuery.append("$set", (Object)updateFields);
            updateFields.append("policyNames", newPolicyNames);
            UpdateResult updateOne = reportSchedulerCollection.updateOne((Bson)scheduleQuery, (Bson)updateQuery);
            System.out.println("....updateschedulerName..." + schedulerName + "..." + updateOne.getModifiedCount());
        }
        for (Document policy : officePolicyList) {
            String policyName = policy.getString((Object)"policyName");
            String policyType = policy.getString((Object)"policyType");
            if (policyName.startsWith("STATISTIC") || policyName.startsWith("STAGING") || policyName.startsWith("SP_") || policyName.startsWith("ODB_") || policyName.startsWith("EX_")) continue;
            System.out.println(String.valueOf(policyType) + ".....officepolicy...." + policyName);
            if (StringUtils.isEmpty((String)policyName) || StringUtils.isEmpty((String)policyType)) continue;
            String newPolicyName = policyName;
            BasicDBObject query = null;
            if ("ODB".equalsIgnoreCase(policyType)) {
                query = new BasicDBObject("oneDrivePolicyName", (Object)policyName);
                newPolicyName = "ODB_" + policyName;
            } else if ("EXCHANGE".equalsIgnoreCase(policyType)) {
                query = new BasicDBObject("exchangePolicyName", (Object)policyName);
                newPolicyName = "EX_" + policyName;
            } else if ("SHAREPOINT".equalsIgnoreCase(policyType)) {
                query = new BasicDBObject("spPolicyName", (Object)policyName);
                newPolicyName = "SP_" + policyName;
            }
            System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&" + policyName);
            System.out.println(String.valueOf(newPolicyName) + ".....before updating query....." + policy.get((Object)"_id"));
            BasicDBObject policyQuery = new BasicDBObject();
            policyQuery.append("_id", policy.get((Object)"_id"));
            BasicDBObject updateFields = new BasicDBObject();
            BasicDBObject updateQuery = new BasicDBObject();
            updateFields.append("policyName", (Object)newPolicyName);
            updateQuery.append("$set", (Object)updateFields);
            officeDBCollection.updateOne((Bson)policyQuery, (Bson)updateQuery);
            FindIterable userList = userDBCollection.find((Bson)query);
            System.out.println("&&&&&&&&&&&FIRTS&&&&&&&&&&&&&&" + policyName);
            for (Document user : userList) {
                String userName = user.getString((Object)"userName");
                BackupPolicyUtility.updateUser(user, policyType.toUpperCase(), newPolicyName, db);
                BackupPolicyUtility.updateOverview(user, policyType.toUpperCase(), newPolicyName, db);
            }
            System.out.println(String.valueOf(policyType) + "&&&&&&&&&&&&&&endofpolicy&&&&&&&&&&&" + newPolicyName);
        }
        System.out.println("Well its Done ");
    }
}

