/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd;

import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.repository.DeviceRepository;
import com.parablu.pcbd.repository.RestoreEventsRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.util.StringUtils;

@SpringBootApplication
public class RestoreEventsApp
implements CommandLineRunner {
    @Autowired
    private RestoreEventsRepository restoreEventsRepository;
    @Autowired
    private DeviceRepository deviceRepository;

    public static void main(String[] args) {
        SpringApplication.run(RestoreEventsApp.class, (String[])args);
    }

    public boolean isOutlookDevice(String uuid) {
        Optional devOpt = this.deviceRepository.findByDeviceUUID(uuid);
        return devOpt.map(device -> {
            String deviceType = device.getDeviceType();
            return "OUTLOOK".equalsIgnoreCase(deviceType);
        }).orElse(false);
    }

    public void run(String ... args) {
        boolean isPstRestoreRunning = false;
        System.out.println("start to check pst restore is running or not...");
        List findAll = this.restoreEventsRepository.findAll();
        for (RestoreEvents restoreEvents : findAll) {
            boolean isOutlookDevice;
            if (restoreEvents == null || !(isOutlookDevice = this.isOutlookDevice(restoreEvents.getActionOnDeviceUUID())) || restoreEvents.getEventType() != null || StringUtils.hasText((String)restoreEvents.getDestinationDeviceUUID())) continue;
            isPstRestoreRunning = true;
            System.out.println(restoreEvents.getActionOnDeviceUUID() + "PSTRESTORE-RUNNING:" + true);
            break;
        }
        System.out.println("PSTcheck Utility Completed..." + isPstRestoreRunning);
    }
}

