/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.mongo_device_utility;

import com.parablu.mongo_device_utility.service.DeviceService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class MongoDeviceUtilityApplication
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MongoDeviceUtilityApplication.class);
    @Autowired
    private DeviceService deviceService;

    public static void main(String[] args) {
        SpringApplication.run(MongoDeviceUtilityApplication.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        logger.info("Starting MongoDeviceUtilityApplication...");
        if (args.length == 0) {
            logger.error("No connection file path provided.");
            throw new IllegalArgumentException("Please provide the connection file path as the first argument.");
        }
        String connectionFilePath = args[0];
        if (connectionFilePath == null || connectionFilePath.trim().isEmpty()) {
            logger.error("Connection file path is not provided. Please provide a valid file path argument.");
            throw new IllegalArgumentException("Connection file path is required.");
        }
        File connectionFile = new File(connectionFilePath);
        if (!connectionFile.exists()) {
            logger.error("Connection file does not exist at path: {}", (Object)connectionFilePath);
            throw new IllegalArgumentException("Connection file not found.");
        }
        if (!connectionFile.canRead()) {
            logger.error("Connection file at path {} is not readable.", (Object)connectionFilePath);
            throw new IllegalArgumentException("Cannot read the connection file.");
        }
        logger.info("Connection file path validated: {}", (Object)connectionFilePath);
        try {
            this.deviceService.syncDevicesData(connectionFilePath);
        }
        catch (Exception e) {
            logger.error("An error occurred during the sync process.", (Throwable)e);
        }
    }
}

