<?php
use \Core\View;
use Helpers\Auth;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
	<?php if($data['userDetails']->{'site'} != 'true'){ ?>
            <ol class="breadcrumb">
                <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <?php }else{ ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><a href="<?=Url::basePath('myAccount/'.base64_encode($data['userDetails']->{'user-name'}))?>"><?=Language::show('user_account', 'keywords')?></a></li>
                <li><?=Language::show('edit_profile', 'keywords')?></li>
            </ol>
	<?php } else { ?>
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('devices')?>"><h3><?='Devices'?></h3></a></li>
		<li><a href="<?=Url::basePath('myAccount/'.base64_encode($data['userDetails']->{'user-name'}))?>"><?=Language::show('Site Details', 'keywords')?></a></li>
                <li><?=Language::show('Edit Site', 'keywords')?></li>
            </ol>
	<?php } ?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <?php if(!empty($_SESSION['storageResult']) && $_SESSION['storageResult'] == 'error'){ ?>
        <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
    <?php }elseif(!empty($_SESSION['storageResult']) && $_SESSION['storageResult'] == 'success'){ ?>
        <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
    <?php } ?>
    <?php $_SESSION['storageResult'] = ''; ?>
    <?php $_SESSION['storageMessage'] = ''; ?>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                    <span class="solutionType" style="display: none;">
                        <?php
                        if((string)$data['userDetails']->{'is-admin'} == 'true'){
                            echo 'Admin';
                        }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                            //echo 'Read Only Admin';
                            echo 'Delegated Administrator';
                        }else{
                            echo 'User';
                        }
                        ?>
                    </span>
                <div class="col-lg-3">
                    <div class="sidebar">
                        <div class="side-menu">
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'd-none';}?>" align="center">
                                    <br/>
                                    <img class="profileImg drop-box"
                                         ngf-select ngf-drop
                                         ng-model="file"
                                         ngf-drag-over-class="dragover"
                                         ngf-multiple="false"
                                         ngf-allow-dir="true"
                                         ngf-keep="false"
                                         ngf-pattern="'.jpg'"
                                         ngf-src="file"
                                         ngf-default-src="'<?=Url::profilePic($data['userDetails']->{'user-name'})?>'"
                                         accept="image/*" ngf-accept="'image/*'">
                                    <div ngf-no-file-drop><?=Language::show('drag_drop_not_supported', 'keywords');?></div>
                                </div>
                            <?php }else{ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'd-none';}?>" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic($data['userDetails']->{'user-name'})?>" />
                                </div>
                            <?php } ?>
                            <br/>
                            <div align="center">
                                <ul class="nav wordwrap">
				    <li><p><?=Language::show('name', 'keywords');?>: <span class="userName"><?=$data['userDetails']->{'user-name'};?></span></p></li>
<?php
if($data['userDetails']->{'site'} != 'true'){ ?>
				    <li><p><?=Language::show('email', 'keywords');?>: <?=$data['userDetails']->{'email-id'};?></p></li>
<?php } ?>
                                    <li>
                                        <p>
                                            <?=Language::show('account_type', 'keywords');?>:
<?php
if($data['userDetails']->{'site'} == 'true'){
	echo 'Site';
}else{
                                            if((string)$data['userDetails']->{'is-admin'} == 'true'){
                                                echo 'Admin';
                                            }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true' && $data['userDetails']->{'delegated-admin'} == 'false'){
                                                echo 'Delegated Administrator';
                                            }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true' && $data['userDetails']->{'delegated-admin'} == 'true'){
                                                echo 'Read Only Admin';
                                            }else{
                                                echo 'User';
					    }
}
                                            ?>
                                        </p>
                                    </li>
                                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-y H:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'Not Updated';}?>"><?=Language::show('last_modified_time', 'keywords');?>: <?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-y H:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'Not Updated';}?></p></li>
                                    <?php if($data['lastLoggedInTime']){ ?>
				                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?>"><?=Language::show('last_loggedin_time', 'keywords');?>: <?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?></p></li>
				    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="panel col-lg-12">
                        <div class="panel-heading">
                            <?php if($data['userDetails']->{'site'} != 'true'){ ?>
                            	<h4><?=Language::show('edit_profile', 'keywords')?></h4>
			    <?php } else { ?>
				<h4><?=Language::show('Edit Site', 'keywords')?></h4>
			    <?php } ?>
                        </div>
                        <div class="panel-body">
                            <div class="error col-lg-12" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                            <?= Form::open(array(
                                'method' => 'post',
                                'ng-submit' => 'saveUserDetails()',
                                'class' => 'userSettingsForm',
				'id' => 'userSettingsForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            )); ?>

			    <div class="row" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Basic Information', 'keywords')?></legend>
                            <div class="form-group col-lg-6 d-none">
                                <label for="user_name"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="user_name" id="user_name" value="<?=$data['userDetails']->{'user-name'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="password_hash"><?=Language::show('password_hash', 'keywords');?></label>
                                <input type="text" class="form-control" name="password_hash" id="password_hash" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('password_hash', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="aadLoginId"><?=Language::show('aadLoginId', 'keywords');?></label>
                                <input type="text" class="form-control" name="aadLoginId" id="aadLoginId" value="<?=$data['userDetails']->{'aadLoginId'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('aadLoginId', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="is_guest"><?=Language::show('Is Guest', 'keywords');?></label>
                                <input type="text" class="form-control" name="is_guest" id="is_guest" value="<?=$data['userDetails']->{'is-guest'};?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="local_user"><?=Language::show('local_user', 'keywords');?></label>
                                <input type="text" class="form-control" name="local_user" id="local_user" value="<?=$data['userDetails']->{'localUser'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="softBlockedTime"><?=Language::show('Soft Blocked Time', 'keywords');?></label>
                                <input type="text" class="form-control" name="softBlockedTime" id="softBlockedTime" value="<?=$data['userDetails']->{'softBlockedTime'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="lastLoginTime"><?=Language::show('lastLoginTime', 'keywords');?></label>
                                <input type="text" class="form-control" name="lastLoginTime" id="lastLoginTime" value="<?=$data['lastLoggedInTime'];?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="userNameLowerCase"><?=Language::show('userNameLowerCase', 'keywords');?></label>
                                <input type="text" class="form-control" name="userNameLowerCase" id="userNameLowerCase" value="<?=$data['userDetails']->{'user-name-lower-case'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="consentGiven"><?=Language::show('User Consent', 'keywords');?></label>
                                <input type="text" class="form-control" name="consentGiven" id="consentGiven" value="<?=$data['userDetails']->{'user-consent'};?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="consentGivenTime"><?=Language::show('User Consent Time', 'keywords');?></label>
                                <input type="text" class="form-control" name="consentGivenTime" id="consentGivenTime" value="<?=$data['userDetails']->{'user-consent-time'};?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="recovery_key"><?=Language::show('recovery_key', 'keywords');?></label>
                                <input type="text" class="form-control" name="recovery_key" id="recovery_key" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('recovery_key', 'keywords');?>" autocomplete="off">
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="google_secret_key"><?=Language::show('google_secret_key', 'keywords');?></label>
                                <input type="text" class="form-control" name="google_secret_key" id="google_secret_key" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('google_secret_key', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 d-none">
                                <label for="backupTargetErrorCode"><?=Language::show('Backup Target Error Code', 'keywords');?></label>
                                <input type="text" class="form-control" name="backupTargetErrorCode" id="backupTargetErrorCode" value="<?=$data['userDetails']->{'backupTargetErrorCode'};?>" autocomplete="off">
                            </div>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="is_first_login" id="is_first_login" required="">
                                        <option value="true" <?php if($data['userDetails']->{'is-first-login'} == 'true'){ ?>selected<?php } ?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-first-login'} == 'false'){ ?>selected<?php } ?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords');?></label>
                                    <input type="text" class="form-control" name="is_first_login" id="is_first_login" value="<?php if($data['userDetails']->{'is-first-login'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('is_first_login', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php //if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <!--<div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="account_status" id="account_status" required="" disabled>
                                        <option value="true" <?php if($data['userDetails']->{'is-active'} == 'true'){ ?>selected<?php } ?>><?=Language::show('activate', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-active'} == 'false'){ ?>selected<?php } ?>><?=Language::show('de_activate', 'keywords')?></option>
                                    </select>
                                </div>-->
                            <?php // }else{ ?>
                                <div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_status" id="account_status" value="<?php if($data['userDetails']->{'is-active'} == 'true'){ echo Language::show('activate', 'keywords'); }else{ echo Language::show('de_activate', 'keywords'); } ?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('account_status', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
			    <div class="form-group col-lg-6">
                                <label for="displayName"><?=Language::show('displayName', 'keywords');?></label>
                                <input type="text" class="form-control" name="displayName" id="displayName" value="<?=$data['userDetails']->{'display-name'};?>" autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed." <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true' || $data['userDetails']->{'site'} == 'true'){ echo 'readonly';}?>>
                            </div>
                            <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                <label for="location"><?=Language::show('location', 'keywords');?></label>
                                <input type="text" class="form-control" name="location" id="location" value="<?=$data['userDetails']->{'location'};?>" autocomplete="off" <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true' || $data['userDetails']->{'site'} == 'true'){ echo 'readonly';}?>>
                            </div>
                            <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                <label for="department"><?=Language::show('department', 'keywords');?></label>
                                <input type="text" class="form-control" name="department" id="department" value="<?=$data['userDetails']->{'department'};?>" autocomplete="off" <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true' || $data['userDetails']->{'site'} == 'true'){ echo 'readonly';}?>>
                            </div>
                            <?php // } ?>
			    <?php if($data['userDetails']->{'site'} != 'true'){ ?>
				    <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'} && $data['loggedInUser']['readOnlyAdmin'] != true){ ?>
					<div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
					    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords')?></label>
					    <select class="form-control selectPicker" name="account_type" id="account_type" required="">
						<option value="admin" <?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('admin', 'keywords')?></option>
						<option value="read_only_admin" <?php if($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('read_only_admin', 'keywords')?></option>
						<option value="user" <?php if($data['userDetails']->{'is-admin'} != 'true' && $data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'selected';}?>><?=Language::show('user', 'keywords')?></option>
					    </select>
					</div>
					<div class="form-group col-lg-3 readOnlyAdminRole" <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ ?> style="display:none;" <?php } ?>>
						<label for="readOnlyAdminRole">Read Only Admin</label>
						<div class="row">
							<div class="col-lg-2">
								<label class="switch" style="margin-left: 15px;">
								<input id="switchrole" name="delegatedAdmin" <?php if($data['userDetails']->{'delegated-admin'} == 'true'){ ?> checked <?php } ?> type="checkbox">
								<div class="slider round"></div>
								</label>
							</div>
						</div>
					</div>
				    <?php }else{ ?>
					<div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
					    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords');?></label>
					    <input type="text" class="form-control" name="account_type" id="account_type" value="<?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'Admin';}elseif($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo Language::show('read_only_admin','keywords');}elseif($data['userDetails']->{'is-guest'} == 'true'){ echo Language::show('Guest','keywords');}else{ echo Language::show('user','keywords');}?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('account_type', 'keywords');?>" required autocomplete="off" readonly>
					</div>
					<div class="form-group col-lg-3 readOnlyAdminRole" <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ ?> style="display:none;" <?php } ?>>
						<label for="readOnlyAdminRole">Read Only Admin</label>
						<div class="row">
							<div class="col-lg-2">
								<label class="switch" style="margin-left: 15px;">
								<input id="switchrole" name="delegatedAdmin" <?php if($data['userDetails']->{'delegated-admin'} == 'true'){ ?> checked <?php } ?> type="checkbox" disabled>
								<div class="slider round"></div>
								</label>
							</div>
						</div>
					</div>
				    <?php } ?>
			    <?php } else { ?>
				<div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_type" id="account_type" value="Site" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('account_type', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
			    <?php } ?>
			    <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'false'){echo 'd-none';}?>">
                                    <label for="spPolicyName"><?=Language::show('SharePoint Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="spPolicyName" id="spPolicyName">
                                        <?php if(!empty($data['spPolicies1'])){ ?>
                                            <?php foreach($data['spPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value['name']?>" <?php if($data['userDetails']->{'spPolicyName'} == $value['name']){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                            </div>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 d-none share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true" <?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'share-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 d-none share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <input type="text" class="form-control" name="share_enabled" id="share_enabled" value="<?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                <label for="email_address"><?=Language::show('email_address', 'keywords');?></label>
                                <!--<input <?php if($data['userDetails']->{'localUser'} == 'false'){ ?> type="text" <?php } else { ?>type="email" <?php } ?> class="form-control" name="email_address" id="email_address" value="<?=$data['userDetails']->{'email-id'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('email_address', 'keywords');?>" <?php if($data['userDetails']->{'email-id'} != ''){ ?> required <?php } ?> autocomplete="off" <?php if($data['activateEdit'] == false || $data['userDetails']->{'localUser'} == 'false' && $data['userDetails']->{'email-id'} != ''){ echo 'readonly';}?> <?php if($data['userDetails']->{'localUser'} == 'true'){ ?> data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="This value should be a valid email."<?php } ?>>-->
                                <input type="email" class="form-control" name="email_address" id="email_address" value="<?=$data['userDetails']->{'email-id'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email_address', 'keywords');?>" required autocomplete="off" <?php if($data['activateEdit'] == false){ echo 'readonly';}?> <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true'){ echo 'readonly';}?>>
                            </div>
                            <?php if(STORAGE_TYPE == "ONE_DRIVE" || Auth::checkCloudPermission('office365') == true){ ?>
				    <?php if($data['oneDriveBackupType'] != 'NONMUX'){ ?>
					<div class="form-group col-lg-6">
					    <label for="odb_login_Id"><?=Language::show('Backup Target', 'keywords');?></label>
					    <input type="text" class="form-control" name="odb_login_Id" id="odb_login_Id" value="<?=$data['userDetails']->{'odb-loginId'};?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('OneDrive for Business Login Id', 'keywords');?>" autocomplete="off" <?php if($data['userDetails']->{'userUnderOdbMigration'} == 'true'){ echo 'readonly';}?> <?php if($data['oneDriveBackupType'] == 'MUX'){ ?> required <?php } ?>>
					</div>
				    <?php } ?>
                            <?php } ?>
			    <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                <div class="form-group col-lg-6 <?php if($data['userDetails']->{'site'} == 'true'){echo 'd-none';}?>">
                                    <label for="backupTargetAssigned"><?=Language::show('Backup Target Assigned', 'keywords');?></label>
                                    <input type="text" class="form-control" name="backupTargetAssigned" id="backupTargetAssigned" value="<?php if($data['userDetails']->{'backupTargetAssigned'} == 'true'){ echo Language::show('Yes', 'keywords'); }else{ echo Language::show('No', 'keywords'); } ?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Backup Target Assigned', 'keywords');?>" autocomplete="off" readonly>
                                </div>
                            <?php } ?>
			    <div class="form-group col-lg-6 hide">
			    	<label for="oneDriveBackupType"><?=Language::show('OneDrive Backup Type', 'keywords');?></label>
			    	<input type="text" class="form-control" name="oneDriveBackupType" id="oneDriveBackupType" value="<?=$data['oneDriveBackupType'];?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('OneDrive Backup Type', 'keywords');?>" autocomplete="off">
			    </div>

</div>
<?php //if(Auth::checkCloudPermission('backup') == true){ ?>
<div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'site'} == 'true') { echo 'd-none'; } ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
<?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'd-none';}?> <?php if(DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>" <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?> style="pointer-events: none;" <?php } ?>>
                                    <label for="backup" style="margin-bottom:0px;"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?>>
                                        <option value="true" <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'd-none';}?> <?php if(DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="backup" id="backup" value="<?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('backup', 'keywords');?>" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
<?php if(Auth::checkCloudPermission('backup') == true) { ?>
                            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                            <div class="form-group col-lg-6 backup backupPolicyName <?php if(Auth::checkCloudPermission('backup') == false || DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>">
                                    <label for="policyName"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['backupPolicies1'])){ ?>
                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>" <?php if($data['userDetails']->{'policy-name'} == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } else { ?>
                            <div class="form-group col-lg-6">
                                <label for="policy_name"><?=Language::show('policy_name', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policy_name" value="<?=$data['userDetails']->{'policy-name'};?>" autocomplete="off" readonly>
                            </div>
                            <?php } ?>
<?php } ?>
<!--<div class="row">
    <div class="col-lg-6" style="margin-left: 16px;">-->
<?php
            $backupPoliciesAdmin = [];
            if(!empty((array)$data['userDetails']->{'backupPoliciesAdmin'}->{'backupPolicyAdmin'})){
               foreach($data['userDetails']->{'backupPoliciesAdmin'}->{'backupPolicyAdmin'} as $key => $value){
                    //$policy = array('name' => (string)$value);
                    //$backupPoliciesAdmin = array_merge(array($policy),$backupPoliciesAdmin);
                    $backupPoliciesAdmin = array_merge($backupPoliciesAdmin, array((string)$value));
               }
            }
        ?>
        <div class="form-group col-lg-12 backupPoliciesAdmin <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'd-none';}?>">
            <label for="backupPoliciesAdmin">Manage Backup Policies</label>
            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                <select name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" class="form-control selectPicker" title="Select Backup Policies Name" multiple>
                            <?php if(!empty($data['backupPolicies1'])){ ?> 
                                <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                $label = $value;
                                if( strlen( $label ) > 25 ) {
                                   $label = substr( $label, 0, 25 ) . '...';
                                }
                                ?>
                                    <option value="<?=$value?>"<?php if(in_array($value,$backupPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                <?php } ?>
                            <?php } ?>
                </select>
            <?php } else { ?>
                <input type="text" class="form-control" name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" value="<?=implode(',', $backupPoliciesAdmin);?>" autocomplete="off" readonly>
            <?php } ?>
        </div>
	</div>
<!--    </div>
</div>-->
<?php //} ?>
<?php //if(Auth::checkCloudPermission('sync') == true){ ?>
<div class="row <?php if(DISABLE_BLUSYNC == true || Auth::checkCloudPermission('sync') == false) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'site'} == 'true') { echo 'd-none'; } ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('BluSync Information', 'keywords')?></legend>

<?php
                            $miniClouds = [];
                            if(!empty((array)$data['userDetails']->{'mini-clouds'}->{'mini-cloud'})){
                                foreach($data['userDetails']->{'mini-clouds'}->{'mini-cloud'} as $key => $value){
                                    $miniClouds = array_merge($miniClouds, array((string)$value->{'mini-cloud-name'}));
                                }
                            }
                            ?>
                            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['miniClouds']->{'mini-cloud'} as $key => $value){ ?>
                                            <?php
                                                $trimmedName = str_replace("_mc_","",$value->{'mini-cloud-name'});
                                            ?>
                                                <option value="<?=$value->{'mini-cloud-name'}?>" <?php if(in_array($value->{'mini-cloud-name'}, $miniClouds)){ echo 'selected';}?>><?=$trimmedName?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php }else{ ?>
                                <?php if(!empty($miniClouds)){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords');?></label>
                                        <input type="text" class="form-control" name="miniCloudName" id="miniCloudName" value="<?=implode(',', $miniClouds);?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('miniCloud', 'keywords');?>" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
                            <?php } ?>

                            <!--<?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 sync_access <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="sync_access">BluSync Access</label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <option value="false" <?php if($data['userDetails']->{'sync-webAccess-enabled'} =='false'){echo 'selected';}?>><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="true" <?php if($data['userDetails']->{'sync-webAccess-enabled'} =='true'){echo 'selected';}?>><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 sync_access <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="sync_access">BluSync Access</label>
                                    <input type="text" class="form-control" name="sync_access" id="sync_access" value="<?php if($data['userDetails']->{'sync-webAccess-enabled'} == 'true'){ echo Language::show('epa_web_access', 'keywords'); }else{ echo Language::show('web_access', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync_access', 'keywords');?>" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>-->
			    <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 sync <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>" <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?> style="pointer-events: none;" <?php } ?>>
                                    <label for="sync" style="margin-bottom:0px;">BluSync</label>
                                    <select class="form-control selectPicker" name="sync" id="sync" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <option value="true" <?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'sync-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 sync <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="sync">BluSync</label>
                                    <input type="text" class="form-control" name="sync" id="sync" value="<?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync', 'keywords');?>" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
	
			    <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 syncAccessType syncAccessTypeBlock <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'sync-enabled'} == 'false'){ echo 'd-none'; } ?>">
                                    <label for="syncAccessType">BluSync Access</label>
                                    <select class="form-control selectPicker" name="syncAccessType" id="syncAccessType" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <option value="WEBONLY" <?php if($data['userDetails']->{'sync-enabled'} =='true' && $data['userDetails']->{'syncAccessType'} =='WEBONLY'){echo 'selected';}?>><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="WEBANDENDPOINT" <?php if($data['userDetails']->{'syncAccessType'} =='WEBANDENDPOINT'){echo 'selected';}?>><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>                    
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 syncAccessType syncAccessTypeBlock <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'd-none';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?> <?php if($data['userDetails']->{'sync-enabled'} == 'false'){ echo 'd-none'; } ?>">
                                    <label for="syncAccessType">BluSync Access</label>
                                    <input type="text" class="form-control" name="syncAccessType" id="syncAccessType" value="<?php if($data['userDetails']->{'syncAccessType'} =='WEBANDENDPOINT'){ echo Language::show('epa_web_access', 'keywords'); }else if($data['userDetails']->{'syncAccessType'} =='WEBONLY'){ echo Language::show('web_access', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync_access', 'keywords');?>" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            
<?php //if(Auth::checkCloudPermission('sync') == true) { ?>
                            <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                            <div class="form-group col-lg-6 sync <?php if(Auth::checkCloudPermission('sync') == false || DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="syncPolicyName">BluSync Policy Name</label><br/>
                                    <select class="form-control selectPolicyPicker" name="syncPolicyName" id="syncPolicyName" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                            <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>" <?php if($data['userDetails']->{'sync-policy-name'} == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } else { ?>
                            <div class="form-group col-lg-6">
                                <label for="sync_policy_name">BluSync Policy Name</label>
                                <input type="text" class="form-control" name="syncPolicyName" id="sync_policy_name" value="<?=$data['userDetails']->{'sync-policy-name'};?>" autocomplete="off" readonly>
                            </div>
                            <?php } ?>
<?php //} ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'd-none';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true" <?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'server-backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'd-none';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="serverBackup" id="serverBackup" value="<?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('serverBackup', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
			   <?php
                                $syncPoliciesAdmin = [];
                                if(!empty((array)$data['userDetails']->{'syncPoliciesAdmin'}->{'syncPolicyAdmin'})){
                                   foreach($data['userDetails']->{'syncPoliciesAdmin'}->{'syncPolicyAdmin'} as $key => $value){
                                        //$policy = array('name' => (string)$value);
                                        //$backupPoliciesAdmin = array_merge(array($policy),$backupPoliciesAdmin);
                                        $syncPoliciesAdmin = array_merge($syncPoliciesAdmin, array((string)$value));
                                   }
                                }
                            ?>
                            <div class="form-group <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?> col-lg-6 <?php } else { ?> col-lg-12 <?php } ?> syncPoliciesAdmin <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'd-none'; } ?>">
                                    <label for="syncPoliciesAdmin">Manage BluSync Policies</label> 
                                    <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                    <select name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" class="form-control selectPicker" title="Select BluSync Policies Name" multiple>
                                        <?php if(!empty($data['syncPolicies1'])){ ?> 
                                             <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                             $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                             ?>
                                                <option value="<?=$value?>"<?php if(in_array($value,$syncPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    <?php } else { ?>
                                        <input type="text" class="form-control" name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" value="<?=implode(',', $syncPoliciesAdmin);?>" autocomplete="off" readonly>
                                    <?php } ?>
                            </div>
			    <?php if($data['userDetails']->{'localUser'} == 'true'){ ?>
			    <div class="form-group col-lg-12 <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>">
                                        <div class="checkbox check-primary">
                                            <input id="autoAgingUsers" name="autoAgingUsers" type="checkbox" value="enabled" onclick="onToggleAgingBlock()" <?php if($data['userDetails']->{'autoExpireType'} != 'DISABLED' ){ echo 'checked';}?>>
                                            <label for="autoAgingUsers"><?=Language::show('Allow automatic user-aging', 'keywords');?></label>
                                        </div>
                            </div>
			    <div class="form-group col-lg-12 autoAgingUsersBlock <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>" style="border: 1px dashed grey;border-radius: 10px;">
				<div class="row">
                                	<div class="form-group col-lg-4">
                                    		<label for="noOfDaysForAutoBlock"><?=Language::show('Number of days after which to auto-block users', 'keywords');?></label>
                                    		<input type="number" class="form-control" name="noOfDaysForAutoBlock" id="noOfDaysForAutoBlock" <?php if($data['userDetails']->{'noOfDaysForAutoBlock'} != '0'){?> value="<?=$data['userDetails']->{'noOfDaysForAutoBlock'}; ?>" <?php } else { ?> value="2000" <?php } ?> placeholder="<?=Language::show('Number of days', 'keywords');?>" autocomplete="off" <?php if($data['userDetails']->{'autoExpireType'} != 'DISABLED'){ ?> min="45" max="2000" required <?php } ?>>
                                	</div>
                                	<div class="col-lg-8" id="chooser" style="margin-left:-14px;margin-top:20px;">
                                        	<div class="col-lg-12" style="margin-bottom:15px;">
                                                    <input type="radio" name="autoExpireType" value="EXPIRE_IDLE_TIME" <?php if($data['userDetails']->{'autoExpireType'} == 'EXPIRE_IDLE_TIME'){echo 'checked';}?>>
                                                        <label for="link" style="display:initial;"><?=Language::show('Number of days of inactivity after which user is automatically blocked', 'keywords');?></label>
							</br>
                                                        <input type="radio" name="autoExpireType" value="EXPIRE_CREATED_TIME" <?php if($data['userDetails']->{'autoExpireType'} == 'EXPIRE_CREATED_TIME'){echo 'checked';}?>>
                                                        <label for="link" style="display:initial;"><?=Language::show('Number of days after user ID creation after which user is automatically blocked', 'keywords');?></label>							
                                                </div>
                                        </div>
				</div>
			    </div>
			    <?php if($data['autoExpireUsers'] != 'DISABLED' ){ ?>
			    <div class="row col-lg-12 helpTextAging <?php if($data['userDetails']->{'autoExpireType'} == 'DISABLED' ){ echo 'd-none';}?>">
				    <div class="col-lg-12">
					<div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
					    <p>
						Users, once blocked will lose access to all products.
						<br/>Applies only to users in the Parablu namespace.
					    </p>
					</div>      
				    </div>      
                            </div>
			    <?php } ?>
			    <?php } ?>
                     </div>     
<?php //} ?>                 
<?php if(Auth::checkCloudPermission('office365') == true){ ?>
<div class="row <?php if($data['userDetails']->{'site'} == 'true'){ echo 'hide';} ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
			    <legend class="h4" style="color: #585f69;"><?=Language::show('Office 365 Information', 'keywords')?></legend>
<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
<div class="form-group col-lg-6 <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                        <label class="star" for="onedriveBkpEnabled"><?=Language::show('OneDrive for Business', 'keywords')?></label>
                                        <div class="checkbox check-primary">
                                                <?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
                                                        <input id="onedriveBkpEnabled" name="onedriveBkpEnabled" type="checkbox" value="enabled" <?php if($data['userDetails']->{'onedriveBkpEnabled'} == 'true'){ ?> checked <?php } ?> <?php if($data['activateEdit'] != true){ ?> disabled <?php } ?>>
                                                        <label for="onedriveBkpEnabled"><?=Language::show('Enable OneDrive', 'keywords');?></label>
                                                <?php } ?>

                                        </div>
                                </div>


                                        <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 oneDrivePolicyName">
                                    <label for="oneDrivePolicyName"><?=Language::show('OneDrive for Business Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="oneDrivePolicyName" id="oneDrivePolicyName" required="">
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>" <?php if($data['userDetails']->{'oneDrivePolicyName'} == $value['name']){echo 'selected';}?>><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                <?php } else { ?>
                                    <div class="form-group col-lg-6">
                                        <label for="oneDrivePolicyName"><?=Language::show('OneDrive for Business Policy Name', 'keywords');?></label>
                                        <input type="text" class="form-control" name="oneDrivePolicyName" id="oneDrivePolicyName" value="<?=$data['userDetails']->{'oneDrivePolicyName'};?>" autocomplete="off" readonly>
                                    </div>
				<?php } ?>
<?php } ?>
<?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                                <div class="form-group col-lg-6 <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'd-none';}?>">
                                	<label class="star" for="exchangeBkpEnabled"><?=Language::show('Microsoft Exchange Backup', 'keywords')?></label>
                                        <div class="checkbox check-primary">
                                                <?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                                                        <input id="exchangeBkpEnabled" name="exchangeBkpEnabled" type="checkbox" value="enabled" <?php if($data['userDetails']->{'exchangeBkpEnabled'} == 'true'){ ?> checked <?php } ?> <?php if($data['activateEdit'] != true){ ?> disabled <?php } ?>>
                                                        <label for="exchangeBkpEnabled"><?=Language::show('Enable Exchange', 'keywords');?></label>
                                                <?php } ?>
                                        </div>
                                </div>


                                <?php if($data['activateEdit'] == true && $data['userDetails']->{'userUnderOdbMigration'} == 'false'){ ?>
                                <div class="form-group col-lg-6 odbPolicyName">
                                    <label for="exchangePolicyName"><?=Language::show('Microsoft Exchange Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="exchangePolicyName" id="exchangePolicyName" required="">
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>" <?php if($data['userDetails']->{'exchangePolicyName'} == $value['name']){echo 'selected';}?>><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                <?php } else { ?>
                                    <div class="form-group col-lg-6">
                                        <label for="exchangePolicyName"><?=Language::show('Microsoft Exchange Policy Name', 'keywords');?></label>
                                        <input type="text" class="form-control" name="exchangePolicyName" id="exchangePolicyName" value="<?=$data['userDetails']->{'exchangePolicyName'};?>" autocomplete="off" readonly>
                                    </div>
				<?php } ?>
<?php } ?>
<!-- manage start -->
<!--<div class="row">
    <div class="col-lg-6" style="margin-left: 16px;">-->
<?php
            $odbPoliciesAdmin = [];
            if(!empty((array)$data['userDetails']->{'odbPoliciesAdmin'}->{'odbPolicyAdmin'})){
               foreach($data['userDetails']->{'odbPoliciesAdmin'}->{'odbPolicyAdmin'} as $key => $value){
                    //$policy = array('name' => (string)$value);
                    //$backupPoliciesAdmin = array_merge(array($policy),$backupPoliciesAdmin);
                    $odbPoliciesAdmin = array_merge($odbPoliciesAdmin, array((string)$value));
               }
            }
        ?>
        <div class="form-group odbPoliciesAdmin col-lg-12" <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ ?> style="display:none;" <?php } ?>>
            <label for="odbPoliciesAdmin">Manage Office 365 Policies</label>
                <select name="odbPoliciesAdmin[]" id="odbPoliciesAdmin" class="form-control selectPicker" title="Select office 365 Policies Name" multiple>
                            <?php if(!empty($data['odbPolicies1'])){ ?>
                                <?php foreach($data['odbPolicies1'] as $key => $value){
                                $label = $value['name'];
                                if( strlen( $label ) > 25 ) {
                                   $label = substr( $label, 0, 25 ) . '...';
                                }
                                ?>
                                    <option value="<?=$value['name']?>"<?php if(in_array($value['name'],$odbPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                <?php } ?>
                            <?php } ?>
                </select>
        </div>
<!--        </div>
    </div>-->
<!-- manage end -->
</div>
<?php } ?>

                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <?php if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                                    <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                        <div class="form-group col-lg-12 d-none">
                                            <div class="well well-lg">
                                                <h4 style="margin-top: -5px;">Select Storage Space</h4>
                                                <hr/>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                    - Your cloud does not support this feature
                                                </p>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                    - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                </p>
                                                <?php
                                                $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                    - Google Drive Storage space
                                                </p>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>
			    <div class="row">
<?php //if($data['userDetails']->{'site'} != 'true'){ ?>
                            <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                <?php if($data['activateEdit'] == true && STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                    <div class="col-lg-12">
                                       <?php if($data['oneDriveBackupType'] == 'MUX' || $data['oneDriveBackupType'] == 'NONMUX'){ ?>
                                       		<button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                                       <?php } ?>
                                       <?php if($data['oneDriveBackupType'] == 'MIX'){ ?>
                                       		<button type="button" class="UserSave btn btn-primary pull-right" ng-click="saveUserDetails1()"><?=Language::show('save', 'keywords');?></button>
                                       <?php } ?>
                                   </div>
                                <?php }?>
                                <?php  if($data['activateEdit'] == true && STORAGE_TYPE !== "ONE_DRIVE"){ ?>
                                    <div class="col-lg-12">
                                       <?php if($data['oneDriveBackupType'] == 'MUX' || $data['oneDriveBackupType'] == 'NONMUX'){ ?>
                                       		<button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                                       <?php } ?>
                                       <?php if($data['oneDriveBackupType'] == 'MIX'){ ?>
                                       		<button type="button" class="UserSave btn btn-primary pull-right" ng-click="saveUserDetails1()"><?=Language::show('save', 'keywords');?></button>
                                       <?php } ?>
                                   </div>
                                <?php }?>
                                <?php  if($data['activateEdit'] == false && STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                    <div class="col-lg-12">
                                       <?php if($data['oneDriveBackupType'] == 'MUX' || $data['oneDriveBackupType'] == 'NONMUX'){ ?>
                                       		<button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                                       <?php } ?>
                                       <?php if($data['oneDriveBackupType'] == 'MIX'){ ?>
                                       		<button type="button" class="UserSave btn btn-primary pull-right" ng-click="saveUserDetails1()"><?=Language::show('save', 'keywords');?></button>
                                       <?php } ?>
                                   </div>
                                <?php }?>                                
			    <?php }?>
<?php //} ?>
			    </div>

                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
<!--modal start-->
<div class="modal fade targetWarning" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Warning</h4>
			</div>
			<div class="modal-body">
				<h4 class="modal-title">If you don’t specify the target, Data will be written to the respective user’s OneDrive.</h4>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" ng-click="saveUserDetails()">Ok</button>
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
			</div>
		</div>
	</div>
</div>
<!--modal ends-->
<!--modal start-->
<div class="modal fade targetWarning2" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Warning</h4>
			</div>
			<div class="modal-body">
				<h4 class="modal-title">If you specify the target, Data will be written to the storage target, and not to the respective user’s OneDrive.</h4>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" ng-click="saveUserDetails()">Ok</button>
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
			</div>
		</div>
	</div>
</div>
<!--modal ends-->		
<?php if(STORAGE_TYPE == "GOOGLE_DRIVE"){ ?>
                 <div class="col-lg-9 <?php if($data['userDetails']->{'externalstorage-authorized'}=='false') { echo 'd-none';}?>">
                        <div class="panel">
                                <div class="panel-heading">
                                        <h4 style="margin-top: -5px;">Configure Google Drive</h4>
                                </div>
                                <div class="panel-body">
                                        <?php
$GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
 ?>
                                        <p>

<a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                        </p>
                                </div>
                        </div>
                </div>
                <?php } ?>

<?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                 <?php if($data['graphApi'] == 'false'){ ?>
                 	<div class="col-lg-9 <?php if($data['userDetails']->{'externalstorage-authorized'}=='false') { echo 'd-none';}?>">
		<?php } else { ?>
			<div class="col-lg-9 d-none">
		<?php } ?>
                        <div class="panel">
                                <div class="panel-heading">
                                        <h4 style="margin-top: -5px;">Configure OneDrive</h4>
                                </div>
                                <div class="panel-body">
                                        <?php
				      if(useLocalPackage != true){
                                                        $redirectUri = "https://api-app.parablu.com/";
                                                        $aadURL = 'https://api-app.parablu.com/call.php';
                                                    }else{
                                                        $redirectUri = LOCAL_IP."/app/index.php";
                                                        $aadURL = LOCAL_IP."/app/call.php";
                                                    }
				      		$user_principal = $data['user_principal'];
						$serviceAccount = "true";
                                                //$params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$data["clientRedirectURI"]."&state=".$data['loggedInUser']['userName'];
                                                $params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$redirectUri."&state=".$data['loggedInUser']['userName']."&user_principal=".$user_principal;
                                                //$MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                $MODBUrl = $aadURL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                    - Microsoft OneDrive for business Storage Space
                                                </p>
</div>
                        </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $("#account_type").on('change',function(){
        if($("#account_type").val() == 'read_only_admin'){
            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                $(".backupPoliciesAdmin").removeClass("d-none");
                $("label[for=\"" + $('#backupPoliciesAdmin').attr("id") + "\"]").addClass("star");
//                $("#backupPoliciesAdmin").attr("required", "true");
                $("#backupPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                $(".syncPoliciesAdmin").removeClass("d-none");
                $("label[for=\"" + $('#syncPoliciesAdmin').attr("id") + "\"]").addClass("star");
//                $("#syncPoliciesAdmin").attr("required", "true");
                $("#syncPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                $(".odbPoliciesAdmin").show();
                $("label[for=\"" + $('#odbPoliciesAdmin').attr("id") + "\"]").addClass("star");
//                $("#odbPoliciesAdmin").attr("required", "true");
                $("#odbPoliciesAdmin").selectpicker('refresh');
            <?php }?>
	    $('.account_type').removeClass('col-lg-6');
	    $('.account_type').addClass('col-lg-3');
	    $('.readOnlyAdminRole').show();
        }else{
            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                $(".backupPoliciesAdmin").addClass("d-none");
                //$("#backupPoliciesAdmin").removeAttr('required');
                $("#backupPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                $(".syncPoliciesAdmin").addClass("d-none");
                //$("#syncPoliciesAdmin").removeAttr('required');
                $("#syncPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                $(".odbPoliciesAdmin").hide();
                //$("#odbPoliciesAdmin").removeAttr('required');
                $("#odbPoliciesAdmin").selectpicker('refresh');
            <?php }?>
	    $('.account_type').removeClass('col-lg-3');
	    $('.account_type').addClass('col-lg-6');
	    $('.readOnlyAdminRole').hide();
        }
    });
    $('html').bind('keypress', function(e)
    {
       if(e.keyCode == 13)
       {
          return false;
       }
    });
	
    function onToggleAgingBlock(){
        if(document.querySelector('#autoAgingUsers').checked) {
            $('.autoAgingUsersBlock').removeClass('d-none');
            $('#noOfDaysForAutoBlock').attr('min','45');
            $('#noOfDaysForAutoBlock').attr('max','2000');
            $('#noOfDaysForAutoBlock').val('');
            $('#noOfDaysForAutoBlock').removeAttr('disabled');
            $("#noOfDaysForAutoBlock").attr('required', 'required');
	    $('.helpTextAging').removeClass('d-none');
    	}else{
            $('.autoAgingUsersBlock').addClass('d-none');
            $('#noOfDaysForAutoBlock').removeAttr('min');
            $('#noOfDaysForAutoBlock').removeAttr('max');
            $('#noOfDaysForAutoBlock').val('2000');
            $('#noOfDaysForAutoBlock').attr('disabled','disabled');
            $("#noOfDaysForAutoBlock").removeAttr('required');
	    $('.helpTextAging').addClass('d-none');
    	}
    }
	
$('#sync').on('change', function(){
        if($('#sync').val() == 'true'){
            $('.syncAccessTypeBlock').removeClass('d-none');
            $('#syncPolicyName').attr('required', 'required');
            $('#syncPolicyName').selectpicker('refresh');
        }else{           
            $('.syncAccessTypeBlock').addClass('d-none');
            $('#syncPolicyName').removeAttr('required', 'required');
            $('#syncPolicyName').selectpicker('refresh');
        }
});	
</script>
