<?php

use \Core\View;
use \Helpers\Url;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?=$data['crumb1']?></span>
<!--            <div class="row">-->
<?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#ssl" aria-expanded="true" aria-controls="ssl">SSL Configuration</a></li>
                      <li class="nav-item hide" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#encryption" aria-expanded="false" aria-controls="encryption">Encryption Configuration</a></li>
                    </ul>
		    <?php } ?>
<?php if(!isMobile()){ ?>
                <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                    <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#ssl" aria-controls="ssl" role="tab" data-toggle="tab">SSL Configuration</a></li>
                    <li class="nav-item hide" role="presentation"><a href="" class="nav-link" data-target="#encryption" aria-controls="encryption" role="tab" data-toggle="tab">Encryption Configuration</a></li>
		</ul>
<?php } ?>
                <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="ssl">
                        <div class="panel col-lg-12">
                            <div class="panel-heading">
                                <h4>SSL Configuration</h4>
                            </div>
                            <div class="panel-body">
				<form class="SSLConfiguration" data-parsley-validate enctype="multipart/form-data">
					<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                    <div class="form-group col-lg-12">
                                        <label for="mainCRTFile">Main Crt File</label>
                                        <input type="file" class="form-control" name="mainCRTFile" id="mainCRTFile" accept=".crt" required autocomplete="off" style="height:auto !important;">
                                        <span class="help-line text-muted">Note:- files with an extension of .crt can only be uploaded.</span>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="keyFile">Key File</label>
                                        <input type="file" class="form-control" name="keyFile" id="keyFile" accept=".key" required autocomplete="off" style="height:auto !important;">
                                        <span class="help-line text-muted">Note:- files with an extension of .key can only be uploaded.</span>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="serverName">Server Name</label>
                                        <input type="text" class="form-control" name="serverName" id="serverName" value="" placeholder="Enter Server Name" required autocomplete="off">
                                        <span class="help-line text-muted">Example:- www.parablu.com</span>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="chainCRTFile">Chain CRT File (optional)</label>
                                        <input type="file" class="form-control" name="chainCRTFile" id="chainCRTFile" accept=".crt" autocomplete="off" style="height:auto !important;">
                                        <span class="help-line text-muted">Note:- files with an extension of .crt can only be uploaded.</span>
                                    </div>
                                    <?php if(isMobile()){ ?>
                                        <div class="text-center">
                                            <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                        </div>
                                    <?php } ?>
					<br/>
<div class="col-lg-12">
					<button type="submit" class="btn btn-success float-right">Save</button>
</div>
				    </div>
</div>
                                </form>
                            </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="encryption">
                        <div class="panel col-lg-12">
                            <div class="panel-heading">
                                <h4>Encryption Configuration</h4>
                            </div>
                            <div class="panel-body">
                                <!-- table start-->
                                <div class="table-responsive keychart d-none">
                                    <div class="h4 loading text-center d-none">Loading.....</div>
                                    <table class="table table-bordered table-striped deviceListTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Product Type</th>
                                            <th class="text-center">Salt key</th>
                                            <th class="text-center">Modified by</th>
                                            <th class="text-center">Modified time</th>
                                            
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr class="ng-scope" ng-repeat="value in keys track by $index" ng-if="value.endTimestamp == 0">
                                            <td class="text-center" ng-if="value.productType == 'backup'">BluVault For End Point</td>
                                            <td class="text-center" ng-if="value.productType == 'serverBackup'">BluVault For Servers</td>                                            
                                            <td class="text-center" ng-if="value.productType == 'sync'">BluSync</td>
                                            <td class="text-center">##############</td>
                                            <td class="text-center">{{value.userName}}</td>
                                            <td class="text-center">{{value.startTime}}</td>
                                            
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- table ends-->
				<form class="encryptionConfiguration" ng-submit="saveEncryptionConfiguration()" data-parsley-validate>
					<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                    <div class="form-group col-lg-12">
                                        <label for="productType">Select a Product Type</label>
                                        <select class="form-control" name="productType" id="productType" required>
						<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                    <option value="backup">BluVault For End Point</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                                    <option value="serverBackup">BluVault For Servers</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                    	<option value="sync">BluSync</option>
                                                <?php } ?>
                                                <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                	<option value="O365">Office365</option>
                                                <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="saltKey">Salt key</label>
                                        <input type="text" class="form-control" name="saltKey" id="saltKey" value="" placeholder="Enter your Salt key" autocomplete="off">
                                        <span class="help-line text-muted">Note:- This will be a part of the Encryption key, If the Administrator chooses to specify a salt key, salt key must be a min length of 16 and max length of 128.</span>
                                    </div>
				    <br/>
<div class="col-lg-12">
				    <button type="submit" class="saveEncSetting btn btn-success float-right">Save</button>
</div>
</div>
                                </form>
                            </div>
                        </div>
                    </div>
                <!--</div>-->
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
